#! /usr/bin/octave -qf
# Table 5
# Octave Code for Impedance Locus Circle Diagram

printf("\n\n *** IMPEDANCE LOCUS CIRCLE DIAGRAM ***\n");

Rmax = input("\n\n ENTER MAXIMUM RESISTANCE: ");
Rmin = input("\n ENTER MINIMUM RESISTANCE: ");

# Calculate a circle for the two specified resistances.

radius = (Rmax - Rmin) / 2;
center = Rmax - radius;
angl = linspace(0, 2 * pi, 100);
x = radius * cos(angl) + center;
y = radius * sin(angl);
y_center = 0;

# Set up plot parameters and plot impedance locus circle.

title "IMPEDANCE LOCUS";
xlabel "REAL Z";
ylabel "IMAG Z";
if (Rmax < 220)
  gset xtics 5;
  gset ytics 5;
elseif(Rmax < 440)
  gset xtics 10;
  gset ytics 10;
elseif(Rmax < 660)
  gset xtics 20;
  gset ytics 20;
elseif(Rmax < 880)
  gset xtics 50;
  gset ytics 50;
endif
gset mxtics 5;
gset mytics 5;
grid("on");
axis([0, 1.1 * Rmax, -abs(1.1 * max(y)), abs(1.1 * max(y))]);
plot(x, y, '-', center, y_center, '+');
pause;


