#! /usr/bin/octave -qf
# Table 4
# Octave Code for SWR Circle Diagram With Antenna Impedance Trace
#
printf("\n\n    *** SWR CIRCLE DIAGRAM ***\n");

# Calculate SWR circles for the specified SWRs and Zo.

Zo = 50;
swr1 = 1.5;
swr2 = 2.0;
swr3 = 3.0;
radius1 = Zo * (swr1 - 1 / swr1) / 2;
radius2 = Zo * (swr2 - 1 / swr2) / 2;
radius3 = Zo * (swr3 - 1 / swr3) / 2;
center1 = Zo * swr1 - radius1;
center2 = Zo * swr2 - radius2;
center3 = Zo * swr3 - radius3;
angl = linspace(0, 2 * pi, 100);
x1 = radius1 * cos(angl) + center1;
y1 = radius1 * sin(angl);
x2 = radius2 * cos(angl) + center2;
y2 = radius2 * sin(angl);
x3 = radius3 * cos(angl) + center3;
y3 = radius3 * sin(angl);

# Set up plot parameters and plot SWR circles.

title "SWR CIRCLE";
xlabel "REAL Z";
ylabel "IMAG Z";
if ((Zo * (1.1 * max(swr3))) < 220)
  gset xtics 5;
  gset ytics 5;
elseif((Zo * (1.1 * max(swr3))) < 440)
  gset xtics 10;
  gset ytics 10;
elseif((Zo * (1.1 * max(swr3))) < 660)
  gset xtics 20;
  gset ytics 20;
elseif((Zo * (1.1 * max(swr3))) < 880)
  gset xtics 50;
  gset ytics 50;
endif
gset mxtics 5;
gset mytics 5;
grid("on");
axis([((Zo * 1.1 * max(swr3)) - 2.5 * radius3), Zo * (1.1 * max(swr3)), \
  -abs(1.1 * max(max(y3))), abs(1.1 * max(max(y3)))]);

# Set up matrix representing impedance trace and add to plot.

x4 = [153, 107, 76, 55, 31, 33, 57];
y4 = [-71, -35, -15, -3.5, 17, 52, 93];
plot(x1, y1, '-1', x2, y2, '-1', x3, y3, '-1', x4, y4, "-@1");
pause;



