unit CATkia;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, oaGPS_NMEA_Extractor, showtraffic1, ExtCtrls;

type
  TfTest = class(TForm)
    gbStrigs: TGroupBox;
    lbLog: TListBox;
    gbPosition: TGroupBox;
    lLongitude: TLabel;
    lLatitude: TLabel;
    lAltitude: TLabel;
    gbDateTime: TGroupBox;
    lTime: TLabel;
    lDate: TLabel;
    btnPort: TButton;
    btnConnect: TButton;
    gbDirection: TGroupBox;
    lTrack: TLabel;
    lKts: TLabel;
    lMagDev: TLabel;
    Button1: TButton;
    Button2: TButton;
    Memo1: TMemo;
    Button3: TButton;
    Button4: TButton;
    Label1: TLabel;
    Button5: TButton;
    RadioGroup5: TRadioGroup;
    procedure FormCreate(Sender: TObject);
    procedure btnPortClick(Sender: TObject);
    procedure btnConnectClick(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure RadioGroup5Click(Sender: TObject);
  private
    { Dclarations prives }
    GPS_Info : ToaGPS_NMEA;
    procedure AddString;
    procedure ShowInfo;

  public
    { Dclarations publiques }
  end;

var
  fTest: TfTest;

implementation

{$R *.DFM}


procedure TfTest.FormCreate(Sender: TObject);
begin
  GPS_Info := ToaGPS_NMEA.Create(Self, 'GPS_COM');
  GPS_Info.OnInputStr := AddString;
  GPS_Info.OnNewPosition := ShowInfo;
  GPS_Info.Active := True;
end;                                            

procedure TfTest.RadioGroup5Click(Sender: TObject);
var
mode:integer;
begin
  if RadioGroup5.ItemIndex>=0  then begin

  mode :=RadioGroup5.ItemIndex + 1;
    GPS_Info.Comport.WriteStr('MD'+inttostr(mode)+';')
  end;

end;

procedure TfTest.AddString;
begin
  with lbLog do ItemIndex := Items.Add(GPS_Info.InputStr);
end;

procedure TfTest.ShowInfo;
begin
  lTime.Caption := 'Time : ' + TimeToStr(GPS_Info.TU_GPS);
  lDate.Caption := 'Date : ' + DateToStr(GPS_Info.Date_GPS);
  lLongitude.Caption := 'Longitude : ' + FormatFloat(',.0000', GPS_Info.Longitude);
  lLatitude.Caption := 'Latitude : ' + FormatFloat(',.0000', GPS_Info.Latitude);
  lAltitude.Caption := 'Altitude : ' + FormatFloat(',.0', GPS_Info.Altitude);
  lTrack.Caption := 'Track angle : ' + FormatFloat(',.0000', GPS_Info.TrackAngle);
  lKts.Caption := 'Speed (kts) : ' + FormatFloat(',.0000', GPS_Info.Kts);
  lMagDev.Caption := 'Magnetic deviation : ' + FormatFloat(',.0', GPS_Info.MagneticDeviation);
  label1.Caption:=GPS_Info.frequency;

end;
procedure TfTest.btnPortClick(Sender: TObject);
begin
  GPS_Info.Comport.ShowSetupDialog;
end;

procedure TfTest.Button1Click(Sender: TObject);
begin
  GPS_Info.Comport.WriteStr('FA;');
end;

procedure TfTest.Button2Click(Sender: TObject);
begin
  GPS_Info.Comport.WriteStr('MD3;');
end;

procedure TfTest.Button3Click(Sender: TObject);
begin
  GPS_Info.Comport.WriteStr('AI2;');
end;

procedure TfTest.Button4Click(Sender: TObject);
begin
  Showtraffic.visible:=true;
end;

procedure TfTest.Button5Click(Sender: TObject);
begin
  showinfo;
end;

procedure TfTest.btnConnectClick(Sender: TObject);
begin
  GPS_Info.Active := True;
end;

end.
