unit kiaCOM;

interface

uses
  Windows, Messages, SysUtils,  Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, ComCtrls,comobj, Buttons;

type
  TForm1 = class(TForm)
    Timer1: TTimer;
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    Memo1: TMemo;
    Button13: TButton;
    Edit1: TEdit;
    Button4: TButton;
    Button5: TButton;
    Edit2: TEdit;
    Edit3: TEdit;
    Button6: TButton;
    Button12: TButton;
    Button11: TButton;
    Label1: TLabel;
    BitBtn1: TBitBtn;
    RadioGroup1: TRadioGroup;
    ComboBox1: TComboBox;
    Label2: TLabel;
    Button9: TButton;
    Label3: TLabel;
    CheckBox1: TCheckBox;
    Button1: TButton;
    TabSheet3: TTabSheet;
    Memo2: TMemo;
    RadioGroup2: TRadioGroup;
    RadioGroup3: TRadioGroup;
    RadioGroup4: TRadioGroup;
    Image1: TImage;
    Label4: TLabel;
    RadioGroup5: TRadioGroup;
    procedure Button5Click(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure Button11Click(Sender: TObject);
    procedure Button12Click(Sender: TObject);
    procedure Button13Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button6Click(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Button9Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure RadioGroup5Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
   //function SendText()
   // function ReadText(s: string);
   procedure Initialize_DCB;
  end;

var
  Form1: TForm1;
  ComFile: THandle;
  s:string;


  
implementation


{$R *.dfm}

function OpenCOMPort: Boolean;
var
  DeviceName: array[0..80] of Char;
begin
   { Open the communications device for read/write.
     This is achieved using the Win32 'CreateFile' function.
        }

  // StrPCopy(DeviceName, 'COM1:');    //in its simpliest form
  StrPCopy(DeviceName, 'COM'+inttostr(Form1.Radiogroup1.itemindex +1)+':');

  ComFile := CreateFile(DeviceName,
    GENERIC_READ or GENERIC_WRITE,
    0,
    nil,
    OPEN_EXISTING,
    FILE_ATTRIBUTE_NORMAL,
    0);

  if ComFile = INVALID_HANDLE_VALUE then
    Result := False
  else
    Result := True;
end;


// Initialize the device control block.
procedure TForm1.Initialize_DCB;
var
   MyDCB : TDCB;
   CommTimeouts: TCommTimeouts;
begin
   // Only want to perform the setup
   // if the port has been opened and
   // the handle assigned.
   if comFile = INVALID_HANDLE_VALUE then exit;

   // The GetCommState function fills in a 
   // device-control block (a DCB structure) 
   // with the current control settings for 
   // a specified communications device. 
   // (Win32 Developers Reference) 
   // Get a default fill of the DCB. 
   GetCommState(comFile, MyDCB);

   MyDCB.BaudRate:= 57600;
   //allows selection of baud rate using a Combobox
   case Form1.Combobox1.ItemIndex  of
     0: MyDCB.BaudRate:= 9600;
     1: MyDCB.BaudRate:= 19200;
     2: MyDCB.BaudRate:= 57600;   //default  as coded
   end;

//  case fBaudRate of 
//    br110 : MyDCB.BaudRate := 110; 
//    br300 : MyDCB.BaudRate := 300; 
//    br600 : MyDCB.BaudRate := 600; 
//    br1200 : MyDCB.BaudRate := 1200; 
//    br2400 : MyDCB.BaudRate := 2400; 
//    br4800 : MyDCB.BaudRate := 4800; 
//    br9600 : MyDCB.BaudRate := 9600; 
//    br14400 : MyDCB.BaudRate := 14400; 
//    br19200 : MyDCB.BaudRate := 19200; 
//    br38400 : MyDCB.BaudRate := 38400; 
// 
//    br56000 : MyDCB.BaudRate := 56000; 
//    br128000 : MyDCB.BaudRate := 128000; 
//    br256000 : MyDCB.BaudRate := 256000; 
//  end;


 {  // Parity error checking parameters.
   case fParityType of 
     pcNone : MyDCB.Parity := NOPARITY; 
     pcEven : MyDCB.Parity := EVENPARITY; 
     pcOdd : MyDCB.Parity := ODDPARITY; 
     pcMark : MyDCB.Parity := MARKPARITY; 
     pcSpace : MyDCB.Parity := SPACEPARITY; 
   end; 
   if fParityErrorChecking then inc(MyDCB.Flags, $0002); 
   if fParityErrorReplacement then inc(MyDCB.Flags, $0021); 
   MyDCB.ErrorChar := char(fErrorChar);  }

        myDCB.Parity:=NOPARITY;
      case Form1.RadioGroup2.ItemIndex  of
        0: MyDCB.Parity:= 0;    //default
        1: MyDCB.Parity:= 1;
        2: MyDCB.Parity:= 2;
        3: MyDCB.Parity:= 3;
        4: MyDCB.Parity:= 4;
      end;  


   MyDCB.StopBits := ONESTOPBIT;
      case Form1.RadioGroup3.ItemIndex  of
        0: MyDCB.StopBits:= 0;  //1 stop bit
        1: MyDCB.StopBits:= 1;  //1.5 stop bits
        2: MyDCB.StopBits:= 2;  //2 stop bits
       end;

  ///   MyDCB.ByteSize := fDataBits;
       MyDCB.ByteSize := 8;
       case Form1.RadioGroup4.ItemIndex  of
          0: MyDCB.ByteSize:= 4;
          1: MyDCB.ByteSize:= 5;
          2: MyDCB.ByteSize:= 6;
          3: MyDCB.ByteSize:= 7;
          4: MyDCB.ByteSize:= 8;
        end;

   // The 'flags' are bit flags,
   // which means that the flags 
   // either turn on or off the 
   // desired flow control type.

   {
   case fFlowControl of 
     fcXON_XOFF : MyDCB.Flags := MyDCB.Flags or $0020 or $0018;
     fcRTS_CTS : MyDCB.Flags := MyDCB.Flags or $0004 or
$0024*RTS_CONTROL_HANDSHAKE; 
     fcDSR_DTR : MyDCB.Flags := MyDCB.Flags or $0008 or 
$0010*DTR_CONTROL_HANDSHAKE; 
   end;    }
 /////<does not like this -->    MyDCB.Flags:= MyDCB.Flags or $0020 or $0018;

///   if fStripNullChars then inc(MyDCB.Flags,$0022);


 ///  MyDCB.XONChar := Char(fXONChar);
 ///  MyDCB.XOFFChar := Char(fXONChar);


   // The XON Limit is the number of 
   // bytes that the data in the 
   // receive buffer must fall below 
   // before sending the XON character, 
   // there for resuming the flow 
   // of data.

 //  Specifies the minimum number of bytes allowed in the input buffer before the XON character is sent.
 ///  MyDCB.XONLim := fXONLim;
  /////    MyDCB.XONLim := 256;

   // The XOFF limit is the max number
   // of bytes that the receive buffer 
   // can contain before sending the 
   // XOFF character, therefore 
   // stopping the flow of data.
  // Specifies the maximum number of bytes allowed in the input buffer before the XOFF character is sent. The maximum number of bytes allowed is calculated by subtracting this value from the size, in bytes, of the input buffer.
  /// MyDCB.XOFFLim := fXOFFLim;
 /////   MyDCB.XOFFLim := 256;

   // Character that signals the end of file. 
 ///  if fEOFChar <> 0 then MyDCB.EOFChar := char(EOFChar);

 /////    MyDCB.EofChar := char(';');    //this isn't really used.  It should be helpful with the Kenwood commands

   // The SetCommTimeouts function sets 
   // the time-out parameters for all 
   // read and write operations on a 
   // specified communications device. 
   // (Win32 Developers Reference) 
   // The GetCommTimeouts function retrieves 
   // the time-out parameters for all read 
   // and write operations on a specified
   // communications device. 
   // GetCommTimeouts(hCommPort, MyCommTimeouts); 
   // MyCommTimeouts.ReadIntervalTimeout := ... 
   // MyCommTimeouts.ReadTotalTimeoutMultiplier := ... 
   // MyCommTimeouts.etc................... 
   // SetCommTimeouts(hCommPort, MyCommTimeouts);
   
   // these are hardwired, you could have these selectable
   // This is not used.  Some serial applications may require these
   // be set to appropriate values.

   { with CommTimeouts do
       begin
         ReadIntervalTimeout         := 300;
         ReadTotalTimeoutMultiplier  := 1;
         ReadTotalTimeoutConstant    := 1000;
         WriteTotalTimeoutMultiplier := 1;
         WriteTotalTimeoutConstant   := 1000;
       end;  }

{-------------------------
  ReadIntervalTimeout

Specifies the maximum time, in milliseconds, allowed to elapse between the arrival of two characters on the communications line. During a ReadFile operation, the time period begins when the first character is received. If the interval between the arrival of any two characters exceeds this amount, the ReadFile operation is completed and any buffered data is returned. A value of zero indicates that interval time-outs are not used. 
A value of MAXDWORD, combined with zero values for both the ReadTotalTimeoutConstant and ReadTotalTimeoutMultiplier members, specifies that the read operation is to return immediately with the characters that have already been received, even if no characters have been received. 

ReadTotalTimeoutMultiplier

Specifies the multiplier, in milliseconds, used to calculate the total time-out period for read operations. For each read operation, this value is multiplied by the requested number of bytes to be read. 

ReadTotalTimeoutConstant

Specifies the constant, in milliseconds, used to calculate the total time-out period for read operations. For each read operation, this value is added to the product of the ReadTotalTimeoutMultiplier member and the requested number of bytes. 
A value of zero for both the ReadTotalTimeoutMultiplier and ReadTotalTimeoutConstant members indicates that total time-outs are not used for read operations. 

WriteTotalTimeoutMultiplier

Specifies the multiplier, in milliseconds, used to calculate the total time-out period for write operations. For each write operation, this value is multiplied by the number of bytes to be written. 

WriteTotalTimeoutConstant

Specifies the constant, in milliseconds, used to calculate the total time-out period for write operations. For each write operation, this value is added to the product of the WriteTotalTimeoutMultiplier member and the number of bytes to be written. 
A value of zero for both the WriteTotalTimeoutMultiplier and WriteTotalTimeoutConstant members indicates that total time-outs are not used for write operations. 

 

Remarks

If an application sets ReadIntervalTimeout and ReadTotalTimeoutMultiplier to MAXDWORD and sets ReadTotalTimeoutConstant to a value greater than zero and less than MAXDWORD, one of the following occurs when the ReadFile function is called:

	If there are any characters in the input buffer, ReadFile returns immediately with the characters in the buffer.
	If there are no characters in the input buffer, ReadFile waits until a character arrives and then returns immediately. 
	If no character arrives within the time specified by ReadTotalTimeoutConstant, ReadFile times out. 

 ---------------}

  SetCommState(ComFile, MyDCB);

end; 



{  Example of using the 'WriteFile' function
  to write data to the serial port.  }

procedure SendText(s: string);
var
  BytesWritten: DWORD;
begin
   { Add a word-wrap (#13 + #10) to the string   }
  s := s + #13 + #10;
  WriteFile(ComFile, s[1], Length(s), BytesWritten, nil);
end;

 {  The following function is an example of using the 'ReadFile' function to read
  data from the serial port.  This is inadequate  and the function ReadText is
  retained as a possible alternative to the actual routine used here.
   }

function ReadText: string;
var           /// not used
  d: array[1..80] of Char;
  ///  s: string;
  BytesRead, i: Integer;
 /// results:string;
begin
  Result := '';
 //// if not ReadFile(ComFile, d, SizeOf(d), BytesRead, nil) then
  begin
    { Raise an exception }
  end;
  s := '';
  for i := 1 to BytesRead do s := s + d[I];
  Result := s;
end;


procedure CloseCOMPort;
begin
  // close the COM Port!
  CloseHandle(ComFile);
end;


procedure TForm1.BitBtn1Click(Sender: TObject);
begin
  application.ProcessMessages;  // allow Window commands
  Timer1.Enabled:=false;        // turn off the timer
  CloseComPort;
  Close;
end;

procedure TForm1.Button11Click(Sender: TObject);
var
 InputBuffer : string;
 NumberOfBytesRead : dword;

 Buffer : array[0..255] of char;
 i: Integer;
 data:string;
 RXFrequency:integer;
begin       // this is the routine that actually reads data coming from the transceiver
  if ComFile=INVALID_HANDLE_VALUE then exit;

   PurgeComm(ComFile, PURGE_RXABORT or PURGE_RXCLEAR);
   InputBuffer := '';

   sendtext('FA;'); //poll VFO A    This is a Kenwood command
   sendtext('MD;'); //poll Mode

//  for i := 0 to 255 do    // This is just for test
//       Buffer[I] := #42;  // It demonstrates why InputBuffer
                          // is built inside a "for" loop

  if ReadFile(ComFile, Buffer, sizeof(Buffer),
              NumberOfBytesRead, nil) = false then
    begin
     ShowMessage('Unable to read from comport');
     exit;
    end;
  InputBuffer := '';
  for i := 0 to NumberOfBytesRead - 1 do
      InputBuffer := InputBuffer + Buffer[i];


 /// if Buffer[i]=';' then
 ///   delete(inputbuffer,i,length(inputbuffer)-i);

  edit2.Text := InputBuffer;
  memo1.Lines.Add(inputbuffer);

     ////  sendtext('FA;');
   data:=edit2.text;
   if length(edit2.text)>3 then
     begin
       // for a Kenwood, write VFO A frequency
       if (pos('FA',data)=1) and (length(data) =18) then   // filters the data
         begin
           delete(data,1,2);//delete FA
           if length(trim(data))<18 then
             RxFrequency:=strtoint(copy(data,3,9));
             label1.Caption := format( '%.2d.%.3d.%.2d',
               [RxFrequency div 1000000,
               ( RxFrequency mod 1000000 ) div 1000,
               (RxFrequency mod 1000) div 10 ] );

            edit2.Text:=''; //clear it
          end;

        if pos('MD',data)<>0 then   // for a Kenwood, mode info
          begin
            delete(data,1,2);//delete MD
            if length(trim(data))<25 then
              case strtoint(copy(data,pos('MD',data)+2,1)) of
                1: begin
                     label3.caption:='LSB';
                     RadioGroup5.ItemIndex:=0;
                   end;
                2: begin
                    label3.caption:='USB';
                    RadioGroup5.ItemIndex:=1;
                   end;
                3: begin
                     label3.caption:='CW';
                     RadioGroup5.ItemIndex:=2;
                   end;
                4: begin
                    label3.caption:='FM';
                    RadioGroup5.ItemIndex:=3;
                   end;
                5: begin
                     label3.caption:='AM';
                     RadioGroup5.ItemIndex:=4;
                   end;
                6: begin
                     label3.caption:='FSK';
                     RadioGroup5.ItemIndex:=5;
                   end;
               end;

               edit2.Text:=''; //clear it
             end;

           end;

       if checkbox1.Checked = true then   Memo1.Clear; // clear the contents of the Memo1
end;

procedure TForm1.Button12Click(Sender: TObject);
begin   //it the timer is on, turn if off; if off, turn it on
  if timer1.Enabled = true  then
    begin
      timer1.Enabled := false;
      Button12.caption :='Timer OFF';
    end
  else
    begin
      timer1.Enabled :=true;
      Button12.caption :='Timer ON';
    end;
end;

procedure TForm1.Button13Click(Sender: TObject);
begin
  OpenComPort;
end;

procedure TForm1.Button1Click(Sender: TObject);

begin
  sendtext('AI2;'); //the AI command turns the auto info command on/off (AI0 is off)
end;

procedure TForm1.Button4Click(Sender: TObject);
begin
  sendtext(edit1.Text);
end;

procedure TForm1.Button5Click(Sender: TObject);
begin
  CloseComPort;  
end;

procedure TForm1.Button6Click(Sender: TObject);
begin
  timer1.Interval:=strtoint(edit3.text);
end;




procedure TForm1.FormCreate(Sender: TObject);
begin
  Radiogroup1.ItemIndex:=0; //initial com port is COM1
  Radiogroup2.ItemIndex:=0; //initial no parity
  Radiogroup3.ItemIndex:=0; //initial one stop bit
  Radiogroup4.ItemIndex:=4; //initial 8 data bits
  Combobox1.ItemIndex:=2; //initial baud is 57600
  combobox1.Text:=combobox1.Items.Strings[2]; //show the current selection

end;


procedure TForm1.Button9Click(Sender: TObject);
begin
  Initialize_DCB;
end;


procedure TForm1.Timer1Timer(Sender: TObject);
begin
  button11.Click; // the routine that reads the data coming
  // from the PC.

 end;



procedure TForm1.RadioGroup5Click(Sender: TObject);
begin  // to select the radio mode using the PC radio buttons
   case RadioGroup5.ItemIndex of
     0..5: sendtext('MD'+inttostr(RadioGroup5.ItemIndex +1)+';');
   end; //end case
end;

end.
