#! /usr/bin/octave -qf
#
#  TRANSMISSION LINE IMPEDANCE TRANSFORMATIONS
#
#  This program is intended for radio frequency work where
#  the phase characteristic of a line is expressed as a
#  velocity factor, the imaginary part of the characteristic
#  impedance is negligible, and the attenuation of the line
#  is expressed in decibels.
#
#  The inputs are:
#
#     frequency
#     length of line
#     attenuation per unit length in decibels
#     velocity factor as a percent
#     real characteristic impedance
#     complex terminating impedance
#
#  The output is:
#
#     input impedance of the line
#
#  Units of length may be anything so long as they are used
#  consistently throughout.
#
#  Arrays of data may be input as follow:
#
#     [7.63, 3.45, -1.45, -6.78]
#
#
#                  Maynard Wright, P. E., W6PAP,  2/17/06

# Print header

printf("\n\n     *** TRANSMISSION LINE CALCULATIONS ***\n");

# Enter input data from keyboard

f = input("\n                               FREQUENCY IN MHz: ");
d = input("\n                         LENGTH OF LINE IN FEET: ");
a = input("\n                 ATTENUATION IN dB PER 100 FEET: ");
v = input("\n                VELOCITY FACTOR AS A PERCENTAGE: ");
Zo = input("\n               CHARACTERISTIC IMPEDANCE IN OHMS: ");
Rt = input("\n     REAL PART OF TERMINATING IMPEDANCE IN OHMS: ");
Xt = input("\nIMAGINARY PART OF TERMINATING IMPEDANCE IN OHMS: ");

# Convert inputs as required

a = a ./ 1e2;  # convert dB per 100 feet to dB per foot
a = 0.1151 .* a;  # convert dB to nepers
c = 9.836e8;  # speed of light in feet per second
lambda = c ./ (1e6 .* f);  # wavelength of signal in vacuum
lambda = (v ./ 1e2) .* lambda; # adjust lambda for velocity
B = (2 .* pi) ./ lambda; # calculate Beta
Zt = Rt .+ j .* Xt;  # calculate complex terminating impedance

# Calculate input impedance

#Zd = Zo .* tanh((a .+ j .* B) .* d .+ atanh(Zt ./ Zo));

Zd = Zo .* ((Zt .* cosh((a .+ j .*B) .* d) .+ Zo .* ...
sinh((a .+ j .*B) .* d)) ./ (Zt .* sinh((a .+ j .*B) .* d) ...
.+ Zo .* cosh((a .+ j .*B) .* d)));

# Print results

for k = 1:columns(Zd)
   if imag(Zd(1,k)) < 0
      printf("\n\n  INPUT IMPEDANCE = %8.5g - j%-8.5g\n\n", ...
      real(Zd(1,k)), abs(imag(Zd(1,k))));
   else
      printf("\n\n  INPUT IMPEDANCE = %8.5g + j%-8.5g\n\n", ...
      real(Zd(1,k)), imag(Zd(1,k)));
   endif
endfor

# End input impedance program
