#! /usr/bin/octave -qf

# function trunq() produces a truncated copy of the
# frequency domain representation of the signal for
# display by function plot.

1;

function retval = trunq(spectrum)
   if(nargin != 1)
      usage("trunq(vector)");
   endif
   for n = 1:80
      retval(n) = spectrum(n);
   endfor
endfunction

# develop a vector for displaying the frequency on
# a plot

w1(1) = 0;
for n = 1:79
   w1(n + 1) = 0.5 * n;
endfor

# begin flow of main program: define variables: accept inputs

time1 = linspace(1, 1024, 1024);
time2 = linspace(1, 80, 80);
A_cxr = 1.;
m = input("\n  ENTER MODULATION FACTOR: ");
loss_dB = 0.;

# develop carrier waveform

v_cxr = A_cxr * cos(2 * pi * time1 / 32);

# develop the audio waveform: the usual coefficient
# is multiplied by 2 here so that inspection of
# one side of the two-sided spectrum will yield the
# same amplitude that would be displayed if a single
# sided spectrum were used

v_mod = m * sin(2 * pi * time1 / 512);

# display the input audio waveform

title "TIME DOMAIN TRANSMITTER AUDIO INPUT";
xlabel "TIME: 1.95 us PER SAMPLE";
ylabel "AMPLITUDE";
grid
axis([0, 512, -1.1 * abs(max(v_mod)), 1.1 * abs(max(v_mod))]);
plot(time1, v_mod, "-");
pause;

# modulate the carrier with the audio in an AM modulator that
# will not overmodulate, producing a DSBTC signal

v_cxr_am = v_cxr .* (1 + v_mod);

# modulate the carrier with the audio in an AM modulator that
# simulates a plate or collector modulator that cannot handle
# reverse current and that can therefore be overmodulated

#for n = 1:1024
#   if((1 + v_mod(n)) >= 0.)
#      v_cxr_am(n) = v_cxr(n) .* (1 + v_mod(n));
#   else
#      v_cxr_am(n) = 0.;
#   endif
#endfor

# display the time domain AM signal

title "TIME DOMAIN AM SIGNAL AT TRANSMITTER OUTPUT";
xlabel "TIME: 1.95 us PER SAMPLE";
ylabel "AMPLITUDE";
grid
axis([0, 512, -1.1 * abs(max(v_cxr_am)), 1.1 * abs(max(v_cxr_am))]);
plot(time1, v_cxr_am, "-");
pause;

# transform the signal into the frequency domain

s_cxr_am = fft(v_cxr_am) / 512;

# display the frequency domain AM signal

title "FREQUENCY SPECTRUM OF AM SIGNAL AT TRANSMITTER OUTPUT";
xlabel "FREQUENCY IN kHz";
ylabel "AMPLITUDE";
grid
axis([0, 30, 0, 1.1 * abs(max(trunq(s_cxr_am)))]);
plot(w1, abs(trunq(s_cxr_am)), "^");
pause;

# detect the signal by half-wave rectifying it as in a crystal
# set: no selectivity is provided here: it is assumed that the
# desired signal is the only one present

#for n = 1:1024
#   if (v_cxr_am(n) < 0)
#      v_cxr_rect(n) = 0;
#   else
#      v_cxr_rect(n) = v_cxr_am(n);
#   endif
#endfor

# detect the signal by full-wave rectifying it:

for n = 1:1024
   v_cxr_rect(n) = abs(v_cxr_am(n));
endfor

title "TIME DOMAIN RECTIFIED AM SIGNAL IN RECEIVER";
xlabel "TIME: 1.95 us PER SAMPLE";
ylabel "AMPLITUDE";
grid
axis([0, 512, -1.1 * abs(max(v_cxr_rect)), 1.1 * abs(max(v_cxr_rect))]);
plot(time1, v_cxr_rect, "-");
pause;

# transform the signal back into the frequency domain

s_cxr_rect = fft(v_cxr_rect) / 512.;

# display the rectified signal

title "FREQUENCY SPECTRUM OF RECTIFIED AM SIGNAL IN RECEIVER";
xlabel "FREQUENCY IN kHz";
ylabel "AMPLITUDE";
grid
axis([0, 40, 0, 1.1 * abs(max(trunq(s_cxr_rect)))]);
plot(w1, abs(trunq(s_cxr_rect)), "^");
pause;

# low pass filter the rectified signal to yield the audio output:
# this is often done with a capacitor across the headphones in a
# crystal set: note that the low-pass spectra in both halves of 
# the double-sided spectrum remain after filtering

for n = 9:1015
   s_cxr_rect(n) = 0;
endfor

# pass the signal through a series "capacitor" to eliminate the DC
# component: this is often not done in a simple receiver, but it
# aids display of the received signal here

s_cxr_rect(1) = 0;

# transform the audio signal back into the time domain

v_audio = 512. * ifft(s_cxr_rect);

# display the received audio signal

title "TIME DOMAIN RECEIVER AUDIO OUTPUT";
xlabel "TIME: 1.95 us PER SAMPLE";
ylabel "AMPLITUDE";
grid
axis([0, 512, -1.1 * abs(max(v_audio)), 1.1 * abs(max(v_audio))]);
plot(time1, v_audio, "-");
pause;

# end program

exit;

