// Analog Keypad Test
//
// This sketch will monitor the analog pin and create a map array that can be copied from
// the serial monitor into your sketch; allowing for easier setup of arbitrary analog keypads
//
// Just run it and follow the instructions in the serial monitor
// The line to copy will be very similiar to the following.  Review the AnalogKeypad_Simple
// example sketch on how to apply it.
//
// The default for the RobotDyn 4x4 Analog Keypad
// keypad_map[] = {1023,931,853,787,675,633,596,563,503,480,458,438,401,322,269,231};
//
//

//#define debug

#define keypad_pin  A0
#define no_key_pressed 0
#define samples 5 // The number of times to read the key
#define read_delay 10  // Delay between data samples
#define variance 10

int key_value;
int keypad_map[16]; // The number of keys on the keypad
int key;
int zero_value;
int analog_value;

void setup()
{
  Serial.begin(115200);

  Serial.print("No key pressed value defined as: ");
  Serial.print(no_key_pressed);

  read_key(); // Read key 5 times and average - put value in key_value
  Serial.print("   Actual Value:");
  Serial.println(key_value);
  zero_value = key_value;
  Serial.println("Keypad Calibration Sequence Initialized");
  Serial.println();
  Serial.println("Press one button at a time, hold it until instructed to release");
  Serial.println();
}

void loop()
{
  for (key = 0 ; key <= 15; key++)
  {
    Serial.print("Press Key ");
    Serial.println(key + 1);

    do
    {
      read_key();
    } while (key_value < (zero_value + variance));

    read_key();
    Serial.print("Release Key ");
    Serial.println(key + 1);

#ifdef debug
    Serial.print("  Key Value = ");
    Serial.println(key_value);
#endif

    keypad_map[key] = key_value;

    do
    {
      read_key();
    } while (key_value > (zero_value + variance));


    if (key != 16)
    {
      Serial.println("Delaying for next key");
      delay(read_delay);
    }
  }

  // All key data acquired - Print the keypad map array

  Serial.println("Copy the following line into your sketch");
  Serial.println();

  Serial.print("const int keypad_map[] = {");
  for (key = 0; key <= 15; key++)
  {

    Serial.print(keypad_map[key]);
    if (key != 15)
    {
      Serial.print(",");
    } else
    {
      Serial.println("};");
      Serial.println();
    }
  }

  Serial.println("Keypad calibration complete");
  delay(10000);
  Serial.println("Restarting calibration sequence");
  delay(5000);

}

void read_key()
{

#ifdef debug
  Serial.println();
  Serial.print("Averaging ");
#endif

  int average = 0;
  int count = samples;
  for (count = 0; count < samples + 1 ; count++)
  {
    analog_value = analogRead(keypad_pin);
    delay (read_delay);
    if (count != 0)
    {
      average = average + analog_value;


#ifdef debug
      Serial.print(" ");
      Serial.print(count);
      Serial.print(": ");
      Serial.print(average / count);
#endif

    }
    key_value = average / samples;
  }
}



