10 CLS : PRINT "LNVIB - Line voltage and current as a function of the distance"
20 PRINT "from the tuner when the power input and termination is known."
30 PRINT "the line is driven by a conjugate matched tuner."
40 PRINT "D.M. Patterson, KK6JI June 25, 1993 -- N6BV mods for QBASIC, 11/16/94"
50 PRINT : PRINT : PRINT "              INPUT THE DATA REQUESTED"
60 PRINT : PRINT
70 PI = 3.141592654#: DIM BUFI(500): DIM BUFV(500)'CURRENT AND VOLTAGE VALUE BUFFERS
80 INPUT " LINE CHARACTERISTIC IMPEDANCE, OHMS ="; Z0
90 INPUT "LINE ATTTENUATION IN DB/100 FOOT ="; DB1
100 AT = DB1 * 3.280839920043975# / 100 * LOG(10) / 20'LINE ATTENUATION IN NEPERS/METER
110 INPUT " LINE VELOCITY FACTOR, V ="; V: IF V = 0 THEN GOTO 110
120 INPUT "LENGTH OF LINE, FEET = "; FT
130 L = FT / 3.280839920043975#'LINE LENGTH, METERS
140 INPUT "SERIES RESISTIVE COMPONENT OF THE LOAD, OHMS ="; RL
150 INPUT "SERIES REACTIVE COMPONENT OF THE LOAD, +/- OHMS ="; XL
160 INPUT "OPERATING FREQUENCY, MHZ = "; F
170 INPUT "POWER INPUT TO THE LINE FROM THE TUNER, WATTS ="; PT
180 '**********CALCULATE SWR AND REFLECTION COEFIEIENT*************
190 AS1 = SQR((RL + Z0) ^ 2 + XL ^ 2): BS = SQR((RL - Z0) ^ 2 + XL ^ 2): SWR = (AS1 + BS) / (AS1 - BS)
' Note: AS1 was originally AS, and QBASIC would not accept this variable name.
200 P = (SWR - 1) / (SWR + 1)'REFLECTION COEFFICENT
210 '******************CALCULATE LINE VOLTAGE AND CURRENT***************
220 CLS : KEY OFF: LOCATE 10, 20: PRINT "CALCULATING"
230 PRA = PT * (1 - P ^ 2) * EXP(-2 * AT * L) / (1 - P ^ 2 * EXP(-4 * AT * L))'POWER INTO THE LOAD
240 VLN = 1000000!: ILN = 1000000!'INITIAL VALUES OF VOLTAGE AND CURRENT MININUM
250 BP = 2 * PI * F / (299.7927 * V)'LINE PHASE FACTOR RADIANS/METER
260 AD = -1
270 FOR D = 0 TO L STEP L / 500'STEPS IN DISTANCE FROM TUNER
280 AD = AD + 1
290 DR = L - D: A1 = DR * AT: B1 = DR * BP'DR = DISTANCE FROM LOAD
300 V0 = (EXP(2 * A1) - EXP(-2 * A1)) / 2: V1 = (EXP(2 * A1) + EXP(-2 * A1)) / 2: V3 = SIN(2 * B1): V4 = COS(2 * B1)
310 V5 = Z0 * (RL * V1 + RL * V4 + Z0 * V0): V6 = Z0 * (XL * (V1 + V4) + Z0 * V3): V7 = Z0 * (V1 + V4) + RL * V0 - XL * V3
320 V8 = XL * V0 + RL * V3'V0 THROUGH V8 ARE INTERNAL VARIBLES (V2 IS NOT USED)
330 ZSR = (V5 * V7 + V6 * V8) / (V7 ^ 2 + V8 ^ 2)'REAL PART OF SERIES LINE IMPEDANCE
340 ZSI = (V6 * V7 - V5 * V8) / (V7 ^ 2 + V8 ^ 2)'IMAG PART OF SERIES LINE IMPEDANCE
341 IF D = 0 THEN
342   ZSR0 = ZSR
343   ZSI0 = ZSI
344 END IF
350 ZX = SQR(ZSR ^ 2 + ZSI ^ 2)'LINE IMPEDANCE LOOKING TOWARD LOAD
360 PD = PT * (1 - P ^ 2) * EXP(-2 * AT * D) / (1 - P ^ 2 * EXP(-4 * AT * L))'FORWARD POWER AT DISTANCE,D
370 IL = SQR(PD / ZSR): VL = IL * ZX'LINE CURRENT AND VOLTAGE AT DISTANCE D
380 IF VL > VLM THEN LET VLM = VL'REMEMBER PEAK VOLTAGE
390 IF VL < VLN THEN LET VLN = VL'REMEMBER MINIMUM VOLTAGE
400 IF IL > ILM THEN LET ILM = IL'REMEMBER PEAK CURRENT
410 IF IL < ILN THEN LET ILN = IL'REMEMBER MINIMUM CURRENT
420 BUFI(AD) = IL: BUFV(AD) = VL'PUT CURRENT AND VOLTAGE IN BUFFERS FOR PLOTTING
430 NEXT D
440 CLS : LOCATE 10, 1
450 PRINT "POWER INTO THE LOAD, WATTS = "; PRA
460 PRINT "POWER DISSIPATED IN THE LINE = "; PT - PRA
470 PRINT "LOAD STANDING WAVE RATIO,SWR = "; SWR
480 PRINT "MAX VOLTAGE = "; VLM
490 PRINT "MINIMUM VOLTAGE = "; VLN
500 PRINT "MAX CURRENT = "; ILM
510 PRINT "MIN CURRENT = "; ILN
520 PRINT "MAX V/MIN V = "; VLM / VLN
530 PRINT "MAX I/MIN I = "; ILM / ILN

' Note: added the PRINT line below to show complex impedance at line input.
PRINT "ZSR = "; ZSR0; : PRINT "  ZSI = "; ZSI0

540 PRINT : PRINT
550 '************ PLOT WAVEFORMS *****************
560 INPUT "PLOT VOLTAGE, CURRENT OR NONE ? V,I,N"; PG$
561 PG$ = UCASE$(PG$)
570 IF PG$ = "I" THEN GOSUB 620'PLOT CURRENT WAVEFORM
580 IF PG$ = "V" THEN GOSUB 770'PLOT VOLTAGE WAVEFORM
590 IF PG$ = "D" THEN GOTO 440 'DISPLAY DATA
600 IF PG$ = "N" THEN GOTO 610 ELSE 570
610 END
620 '***************PLOT CURRENT WAVEFORM***********
630 CLS : SCREEN 2
640 FR = (ILM - FIX(ILM)) * 100'FRACTIONAL PART OF THE CURRENT
650 LOCATE 1, 2: PRINT ; (CINT(FR) / 100 + FIX(ILM))
660 FR = (ILM / 2 - FIX(ILM / 2)) * 100'FRACTIONAL PART OF THE CURRENT
670 LOCATE 11, 2: PRINT ; CINT(FR) / 100 + FIX(ILM / 2)'ROUNDED TO TWO DECIMALS
680 LOCATE 21, 4: PRINT "0": LOCATE 22, 9: PRINT "XMTR": LOCATE 22, 69: PRINT "LOAD"
690 LOCATE 22, 17: PRINT ">====TRANSMISSION LINE LENGTH ,"; FT; " FEET ====>"
700 LOCATE 9, 1: PRINT "A": LOCATE 10, 1: PRINT "M": LOCATE 11, 1: PRINT "P": LOCATE 12, 1: PRINT "S"
710 GOSUB 920 'DRAW GRID
720 FOR AD = 0 TO 500
730 X = 70 + AD: Y = 160 - BUFI(AD) * 160 / ILM: PSET (X, Y)'PRINT CURRENT WAVEFORM
740 NEXT AD
750 LOCATE 24, 9: INPUT "DISPLAY DATA OR VOLTAGE ? D/V"; PG$
751 PG$ = UCASE$(PG$)
760 RETURN
770 '***************PLOT VOLTAGE WAVEFORM***********
780 CLS : SCREEN 2
790 FR = (VLM - FIX(VLM)) * 100'FRACTIONAL PART OF THE CURRENT
800 LOCATE 1, 2: PRINT ; (CINT(FR) / 100 + FIX(VLM))
810 FR = (VLM / 2 - FIX(VLM / 2)) * 100'FRACTIONAL PART OF THE CURRENT
820 LOCATE 11, 2: PRINT ; CINT(FR) / 100 + FIX(VLM / 2)'ROUNDED TO TWO DECIMALS
830 LOCATE 21, 4: PRINT "0": LOCATE 22, 9: PRINT "XMTR": LOCATE 22, 69: PRINT "LOAD"
840 LOCATE 22, 17: PRINT ">====TRANSMISSION LINE LENGTH ,"; FT; " FEET ====>"
850 LOCATE 9, 1: PRINT "V": LOCATE 10, 1: PRINT "O": LOCATE 11, 1: PRINT "L": LOCATE 12, 1: PRINT "T": LOCATE 13, 1: PRINT "S"
860 GOSUB 920 'DRAW GRID
870 FOR AD = 0 TO 500
880 X = 70 + AD: Y = 160 - BUFV(AD) * 160 / VLM: PSET (X, Y)'PRINT VOLTAGE WAVEFORM
890 NEXT AD
900 LOCATE 24, 9: INPUT "DISPLAY DATA OR CURRENT ? D/I"; PG$
901 PG$ = UCASE$(PG$)
910 RETURN
920 '***************DRAW GRID*******************************
930 LINE (70, 0)-(70, 160): LINE (120, 0)-(120, 160): LINE (170, 0)-(170, 160)
940 LINE (220, 0)-(220, 160): LINE (270, 0)-(270, 160): LINE (320, 0)-(320, 160)
950 LINE (370, 0)-(370, 160): LINE (420, 0)-(420, 160): LINE (470, 0)-(470, 160)
960 LINE (520, 0)-(520, 160): LINE (570, 0)-(570, 160)
970 LINE (70, 0)-(570, 0): LINE (70, 16)-(570, 16): LINE (70, 32)-(570, 32)
980 LINE (70, 48)-(570, 48): LINE (70, 64)-(570, 64): LINE (70, 80)-(570, 80)
990 LINE (70, 96)-(570, 96): LINE (70, 112)-(570, 112): LINE (70, 128)-(570, 128)
1000 LINE (70, 144)-(570, 144): LINE (70, 160)-(570, 160)
1010 RETURN

