30 PI = 3.14158: MH = 400: MV = 91: REM global positioning;mv vertical;mh horizontal
40 CLS : AR = 2.286: REM aspect ratio 2.286
50 DIM A(250): REM dimension array for data
60 SCREEN 2
70 GOSUB 100
80 GOTO 70
90 SCREEN 0: END
100 CLS : REM *******Subroutine to show menu ************
110 LOCATE 4, 7: PRINT "   G3LDO Antenna Polar Plot": PRINT : PRINT
120 PRINT "   T   align plotting time to AUT rotation Time": PRINT
130 PRINT "   P   Plot polar diagram": PRINT
140 PRINT "   S   Save data from antenna plot to file": PRINT
150 PRINT "   L   Load previous plotted data to screen": PRINT
160 PRINT "   Q   to Quit program": PRINT
170 PRINT "        Enter appropriate letter"
180 PRINT "        and press ENTER ": PRINT
190 INPUT "", A$
200 IF A$ = "t" THEN GOSUB 260: GOSUB 720
210 IF A$ = "q" THEN GOTO 90
220 IF A$ = "p" THEN GOSUB 260: GOSUB 720
230 IF A$ = "s" THEN GOSUB 1080
240 IF A$ = "l" THEN GOSUB 1460: GOSUB 260: GOSUB 1170
250 RETURN
260 REM *******Subroutine to draw the graticule*******
270 STARTSIZE = 22: REM size of first circle on graticule
280 D = 2: REM Number of dots per line on graticule
290 CLS : PSET (MH, MV)
300 CS = STARTSIZE: REM cs = circle size
310 FOR R = 0 TO 120 STEP D
320 T = 2 * (PI * R / 120)
330 V = (SIN(T) * CS) + MV
340 H = (COS(T) * (CS * AR)) + MH
350 PSET (H, V)
360 NEXT R
370 CS = 44: REM cs = circle size
380 FOR R = 0 TO 120 STEP (D / 1.666)
390 T = 2 * (PI * R / 120)
400 V = (SIN(T) * CS) + MV
410 H = (COS(T) * (CS * AR)) + MH
420 PSET (H, V)
430 NEXT R
440 CS = 66: REM cs = circle size
450 FOR R = 0 TO 120 STEP (D / 2.5)
460 T = 2 * (PI * R / 120)
470 V = (SIN(T) * CS) + MV
480 H = (COS(T) * (CS * AR)) + MH
490 PSET (H, V)
500 NEXT R
510 CS = 88: REM cs = circle size
520 FOR R = 0 TO 120 STEP (D / 4)
530 T = 2 * (PI * R / 120)
540 V = (SIN(T) * CS) + MV
550 H = (COS(T) * (CS * AR)) + MH
560 PSET (H, V)
570 NEXT R
580 REM Spokes
590 SPOKE = 128
600 FOR CS = STARTSIZE TO (STARTSIZE * 4) STEP D
610 FOR R = 0 TO SPOKE STEP 16: REM spoke/STEP = number of spokes
620 T = 2 * (PI * R / SPOKE)
630 V = (SIN(T) * CS) + MV
640 H = (COS(T) * (CS * AR)) + MH
650 PSET (H, V)
660 NEXT R
670 NEXT CS
680 LOCATE 1, 51: PRINT "0": LOCATE 12, 75: PRINT "90"
690 LOCATE 23, 50: PRINT "180": LOCATE 12, 24: PRINT "270"
700 RETURN
710 PH = 400: PV = 52
720 REM *********Subroutine to read analogue data from FSM*****
730 REM This subroutine is for the Pico ADC-10 only and lines 760-790 &
740 REM 850-920 will have to be changed if a different ADC is used
750 IF A$ = "t" THEN GOSUB 1590: GOTO 820
760 ADDRESS% = &H378: CLOCK% = &H378: PORTIN% = &H379
770 HIGH% = &HFD: LOW% = &HFC: MASK% = &H80: SHIFT% = 2
780 OUT ADDRESS%, &HFE: REM power up ADC
790 OUT ADDRESS%, &HFC: REM chip select
800 LOCATE 1, 1: PRINT "Input Scale Factor"
810 INPUT "Default 1.5 "; PSF: PRINT
820 IF PSF = 0 THEN PSF = 1.5: REM Sets default scale factor
830 PRINT : PRINT "Press RETURN": PRINT "and start AUT rotator"
840 INPUT "to commence plotting", S$
850 Q = 0
860 FOR R = 240 TO 120 STEP -.5
870   Q = Q + 1
880   BITS% = 0
890   FOR J% = 1 TO 8
900    OUT CLOCK%, HIGH%
910    REM read MSB of register 'portin%' and add to left-shifted 'bits%'
920    BITS% = (INP(PORTIN%) AND MASK%) + BITS% * SHIFT%
930     FOR DELAY = 1 TO PT: NEXT: REM pt = plotting time
940    OUT CLOCK%, LOW%
950   NEXT J%
960   IF A$ = "t" THEN DS = 55 ELSE DS = (BITS% / MASK% XOR &HFF) * PSF
970   A(Q) = DS
980   T = 2 * (PI * R / 120)
990   V = (SIN(T) * DS) + MV
1000   H = (COS(T) * (DS * AR) + MH)
1010   CIRCLE (H, V), 1: REM points plotted as small circles
1020  PSET (H + .2, V + .2)
1030 NEXT R
1040 OUT ADDRESS%, &H10: REM power down ADC
1050 PRINT : PRINT : PRINT
1060 INPUT "RETURN for menu", A$
1070 RETURN
1080 REM ****Subroutine for saving antenna data to file***
1090 PRINT "Name Antenna"
1100 INPUT "Data File"; ANT$
1110 OPEN "O", #1, ANT$
1120 DTA = Q
1130 FOR Q = 1 TO DTA
1140 PRINT #1, A(Q)
1150 NEXT
1160 CLOSE : RETURN
1170 REM *******Subroutine to read data from file******
1180 LOCATE 2, 1: PRINT "Scale Factor"
1190 INPUT "(Default 1.5)"; SF
1200 IF SF = 0 THEN SF = 1.5: PRINT
1210 PRINT "L for Linear plot"
1220 PRINT "G for Log plot"
1230 PRINT "A for ARRL plot": PRINT
1240 INPUT "Select plot by letter"; PT$: PRINT
1250 PRINT "Plot of"
1260 PRINT "antenna file"
1270 PRINT ANT$: PRINT : PRINT
1280 PRINT "Press Return"
1290 OPEN "I", #1, ANT$
1300 Q = 1: DS = 1: R = 240
1310 INPUT #1, A(Q)
1320 IF EOF(1) THEN 1430
1330 DS = A(Q)
1340 IF DS = 0 THEN DS = 1
1350 IF PT$ = "g" THEN GOSUB 1490
1360 IF PT$ = "a" THEN GOSUB 1520
1370 IF PT$ = "l" THEN GOSUB 1550
1380 T = 2 * (PI * R / 120)
1390 V = (SIN(T) * DS) + MV
1400 H = (COS(T) * (DS * AR) + MH)
1410 CIRCLE (H, V), 1
1420 A = A + 1: R = R - .5: GOTO 1310
1430 INPUT "for menu", S$
1440 CLOSE : RETURN
1450 REM *******Subroutine for printing antenna file list*****
1460 CLS : PRINT : FILES "*.": PRINT
1470 INPUT "Enter Required File"; ANT$
1480 RETURN
1490 REM *****Log Function Plot*****
1500 DS = (LOG(DS) * .4343) * SF
1510 RETURN
1520 REM ******ARRL Plot********
1530 DS = (.01 * (DS) + (LOG(DS) * .4343)) * SF
1540 RETURN
1550 REM *******Linear Plot***********
1560 DS = DS * SF
1570 RETURN
1580 REM ************Subroutine for setting plotting time**************
1590 PRINT "Set Plot Time"
1600 INPUT "(default 30)"; PT
1610 IF PT = 0 THEN PT = 30
1620 RETURN

6)
390 T = 2 * (PI * R / 120)
400 V = (SIN(T) * CS) + MV
410 H = (COS(T) * (CS * AR)) + MH
420 PSET (H, V)
430 NEXT R
440 CS = 66: REM cs = circle size
450 FOR R = 0 TO 120 STEP (D / 2.5)
460 T = 2 * (PI * R / 120)
470 V = (SIN(T)