/*-------------------------------------------------------------------------
 * PIC32MZ2048ECM144 processor header
 *
 * This software is developed by Microchip Technology Inc. and its
 * subsidiaries ("Microchip").
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are 
 * met:
 * 
 * 1.      Redistributions of source code must retain the above copyright
 *         notice, this list of conditions and the following disclaimer.
 * 2.      Redistributions in binary form must reproduce the above 
 *         copyright notice, this list of conditions and the following 
 *         disclaimer in the documentation and/or other materials provided 
 *         with the distribution.
 * 3.      Microchip's name may not be used to endorse or promote products
 *         derived from this software without specific prior written 
 *         permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY MICROCHIP "AS IS" AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR PURPOSE ARE DISCLAIMED. IN NO EVENT 
 * SHALL MICROCHIP BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING BUT NOT LIMITED TO
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWSOEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 *-------------------------------------------------------------------------*/

#pragma once
#ifndef __32MZ2048ECM144_H
#define __32MZ2048ECM144_H

#if defined (__LANGUAGE_C__) || defined (__LANGUAGE_C_PLUS_PLUS)

#ifdef __cplusplus
extern "C" {
#endif

extern volatile unsigned int        CFGCON __attribute__((section("sfrs")));
typedef struct {
  unsigned TDOEN:1;
  unsigned :1;
  unsigned TROEN:1;
  unsigned JTAGEN:1;
  unsigned ECCCON:2;
  unsigned :2;
  unsigned USBSSEN:1;
  unsigned :2;
  unsigned PGLOCK:1;
  unsigned PMDLOCK:1;
  unsigned IOLOCK:1;
  unsigned :2;
  unsigned OCACLK:1;
  unsigned ICACLK:1;
  unsigned :6;
  unsigned CPUPRI:1;
  unsigned DMAPRI:1;
} __CFGCONbits_t;
extern volatile __CFGCONbits_t CFGCONbits __asm__ ("CFGCON") __attribute__((section("sfrs")));
extern volatile unsigned int        DEVID __attribute__((section("sfrs")));
typedef struct {
  unsigned DEVID:28;
  unsigned VER:4;
} __DEVIDbits_t;
extern volatile __DEVIDbits_t DEVIDbits __asm__ ("DEVID") __attribute__((section("sfrs")));
extern volatile unsigned int        SYSKEY __attribute__((section("sfrs")));
typedef struct {
  unsigned SYSKEY:32;
} __SYSKEYbits_t;
extern volatile __SYSKEYbits_t SYSKEYbits __asm__ ("SYSKEY") __attribute__((section("sfrs")));
extern volatile unsigned int        PMD1 __attribute__((section("sfrs")));
typedef struct {
  unsigned AD1MD:1;
  unsigned :11;
  unsigned CVRMD:1;
} __PMD1bits_t;
extern volatile __PMD1bits_t PMD1bits __asm__ ("PMD1") __attribute__((section("sfrs")));
extern volatile unsigned int        PMD1CLR __attribute__((section("sfrs")));
extern volatile unsigned int        PMD1SET __attribute__((section("sfrs")));
extern volatile unsigned int        PMD1INV __attribute__((section("sfrs")));
extern volatile unsigned int        PMD2 __attribute__((section("sfrs")));
typedef struct {
  unsigned CMP1MD:1;
  unsigned CMP2MD:1;
} __PMD2bits_t;
extern volatile __PMD2bits_t PMD2bits __asm__ ("PMD2") __attribute__((section("sfrs")));
extern volatile unsigned int        PMD2CLR __attribute__((section("sfrs")));
extern volatile unsigned int        PMD2SET __attribute__((section("sfrs")));
extern volatile unsigned int        PMD2INV __attribute__((section("sfrs")));
extern volatile unsigned int        PMD3 __attribute__((section("sfrs")));
typedef struct {
  unsigned IC1MD:1;
  unsigned IC2MD:1;
  unsigned IC3MD:1;
  unsigned IC4MD:1;
  unsigned IC5MD:1;
  unsigned IC6MD:1;
  unsigned IC7MD:1;
  unsigned IC8MD:1;
  unsigned IC9MD:1;
  unsigned :7;
  unsigned OC1MD:1;
  unsigned OC2MD:1;
  unsigned OC3MD:1;
  unsigned OC4MD:1;
  unsigned OC5MD:1;
  unsigned OC6MD:1;
  unsigned OC7MD:1;
  unsigned OC8MD:1;
  unsigned OC9MD:1;
} __PMD3bits_t;
extern volatile __PMD3bits_t PMD3bits __asm__ ("PMD3") __attribute__((section("sfrs")));
extern volatile unsigned int        PMD3CLR __attribute__((section("sfrs")));
extern volatile unsigned int        PMD3SET __attribute__((section("sfrs")));
extern volatile unsigned int        PMD3INV __attribute__((section("sfrs")));
extern volatile unsigned int        PMD4 __attribute__((section("sfrs")));
typedef struct {
  unsigned T1MD:1;
  unsigned T2MD:1;
  unsigned T3MD:1;
  unsigned T4MD:1;
  unsigned T5MD:1;
  unsigned T6MD:1;
  unsigned T7MD:1;
  unsigned T8MD:1;
  unsigned T9MD:1;
} __PMD4bits_t;
extern volatile __PMD4bits_t PMD4bits __asm__ ("PMD4") __attribute__((section("sfrs")));
extern volatile unsigned int        PMD4CLR __attribute__((section("sfrs")));
extern volatile unsigned int        PMD4SET __attribute__((section("sfrs")));
extern volatile unsigned int        PMD4INV __attribute__((section("sfrs")));
extern volatile unsigned int        PMD5 __attribute__((section("sfrs")));
typedef struct {
  unsigned U1MD:1;
  unsigned U2MD:1;
  unsigned U3MD:1;
  unsigned U4MD:1;
  unsigned U5MD:1;
  unsigned U6MD:1;
  unsigned :2;
  unsigned SPI1MD:1;
  unsigned SPI2MD:1;
  unsigned SPI3MD:1;
  unsigned SPI4MD:1;
  unsigned SPI5MD:1;
  unsigned SPI6MD:1;
  unsigned :2;
  unsigned I2C1MD:1;
  unsigned I2C2MD:1;
  unsigned I2C3MD:1;
  unsigned I2C4MD:1;
  unsigned I2C5MD:1;
  unsigned :3;
  unsigned USBMD:1;
  unsigned :3;
  unsigned CAN1MD:1;
  unsigned CAN2MD:1;
} __PMD5bits_t;
extern volatile __PMD5bits_t PMD5bits __asm__ ("PMD5") __attribute__((section("sfrs")));
extern volatile unsigned int        PMD5CLR __attribute__((section("sfrs")));
extern volatile unsigned int        PMD5SET __attribute__((section("sfrs")));
extern volatile unsigned int        PMD5INV __attribute__((section("sfrs")));
extern volatile unsigned int        PMD6 __attribute__((section("sfrs")));
typedef struct {
  unsigned RTCCMD:1;
  unsigned :7;
  unsigned REFO1MD:1;
  unsigned REFO2MD:1;
  unsigned REFO3MD:1;
  unsigned REFO4MD:1;
  unsigned :4;
  unsigned PMPMD:1;
  unsigned EBIMD:1;
  unsigned :5;
  unsigned SQI1MD:1;
  unsigned :4;
  unsigned ETHMD:1;
} __PMD6bits_t;
extern volatile __PMD6bits_t PMD6bits __asm__ ("PMD6") __attribute__((section("sfrs")));
extern volatile unsigned int        PMD6CLR __attribute__((section("sfrs")));
extern volatile unsigned int        PMD6SET __attribute__((section("sfrs")));
extern volatile unsigned int        PMD6INV __attribute__((section("sfrs")));
extern volatile unsigned int        PMD7 __attribute__((section("sfrs")));
typedef struct {
  unsigned :4;
  unsigned DMAMD:1;
  unsigned :15;
  unsigned RNGMD:1;
  unsigned :1;
  unsigned CRYPTMD:1;
} __PMD7bits_t;
extern volatile __PMD7bits_t PMD7bits __asm__ ("PMD7") __attribute__((section("sfrs")));
extern volatile unsigned int        PMD7CLR __attribute__((section("sfrs")));
extern volatile unsigned int        PMD7SET __attribute__((section("sfrs")));
extern volatile unsigned int        PMD7INV __attribute__((section("sfrs")));
extern volatile unsigned int        CFGEBIA __attribute__((section("sfrs")));
typedef struct {
  unsigned EBIA0EN:1;
  unsigned EBIA1EN:1;
  unsigned EBIA2EN:1;
  unsigned EBIA3EN:1;
  unsigned EBIA4EN:1;
  unsigned EBIA5EN:1;
  unsigned EBIA6EN:1;
  unsigned EBIA7EN:1;
  unsigned EBIA8EN:1;
  unsigned EBIA9EN:1;
  unsigned EBIA10EN:1;
  unsigned EBIA11EN:1;
  unsigned EBIA12EN:1;
  unsigned EBIA13EN:1;
  unsigned EBIA14EN:1;
  unsigned EBIA15EN:1;
  unsigned EBIA16EN:1;
  unsigned EBIA17EN:1;
  unsigned EBIA18EN:1;
  unsigned EBIA19EN:1;
  unsigned EBIA20EN:1;
  unsigned EBIA21EN:1;
  unsigned EBIA22EN:1;
  unsigned EBIA23EN:1;
  unsigned :7;
  unsigned EBIPINEN:1;
} __CFGEBIAbits_t;
extern volatile __CFGEBIAbits_t CFGEBIAbits __asm__ ("CFGEBIA") __attribute__((section("sfrs")));
extern volatile unsigned int        CFGEBIACLR __attribute__((section("sfrs")));
extern volatile unsigned int        CFGEBIASET __attribute__((section("sfrs")));
extern volatile unsigned int        CFGEBIAINV __attribute__((section("sfrs")));
extern volatile unsigned int        CFGEBIC __attribute__((section("sfrs")));
typedef struct {
  unsigned EBIDEN0:1;
  unsigned EBIDEN1:1;
  unsigned :2;
  unsigned EBICSEN0:1;
  unsigned EBICSEN1:1;
  unsigned EBICSEN2:1;
  unsigned EBICSEN3:1;
  unsigned EBIBSEN0:1;
  unsigned EBIBSEN1:1;
  unsigned :2;
  unsigned EBIOEEN:1;
  unsigned EBIWEEN:1;
  unsigned :2;
  unsigned EBIRPEN:1;
  unsigned EBIRDYLVL:1;
  unsigned :6;
  unsigned EBIRDYEN1:1;
  unsigned EBIRDYEN2:1;
  unsigned EBIRDYEN3:1;
  unsigned :1;
  unsigned EBIRDYINV1:1;
  unsigned EBIRDYINV2:1;
  unsigned EBIRDYINV3:1;
} __CFGEBICbits_t;
extern volatile __CFGEBICbits_t CFGEBICbits __asm__ ("CFGEBIC") __attribute__((section("sfrs")));
extern volatile unsigned int        CFGEBICCLR __attribute__((section("sfrs")));
extern volatile unsigned int        CFGEBICSET __attribute__((section("sfrs")));
extern volatile unsigned int        CFGEBICINV __attribute__((section("sfrs")));
extern volatile unsigned int        CFGPG __attribute__((section("sfrs")));
typedef struct {
  unsigned CPUPG:2;
  unsigned :2;
  unsigned DMAPG:2;
  unsigned :2;
  unsigned USBPG:2;
  unsigned :2;
  unsigned CAN1PG:2;
  unsigned CAN2PG:2;
  unsigned ETHPG:2;
  unsigned :2;
  unsigned SQI1PG:2;
  unsigned FCPG:2;
  unsigned CRYPTPG:2;
} __CFGPGbits_t;
extern volatile __CFGPGbits_t CFGPGbits __asm__ ("CFGPG") __attribute__((section("sfrs")));
extern volatile unsigned int        CFGPGCLR __attribute__((section("sfrs")));
extern volatile unsigned int        CFGPGSET __attribute__((section("sfrs")));
extern volatile unsigned int        CFGPGINV __attribute__((section("sfrs")));
extern volatile unsigned int        NVMCON __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned NVMOP:4;
    unsigned :3;
    unsigned SWAP:1;
    unsigned :4;
    unsigned LVDERR:1;
    unsigned WRERR:1;
    unsigned WREN:1;
    unsigned WR:1;
  };
  struct {
    unsigned NVMOP0:1;
    unsigned NVMOP1:1;
    unsigned NVMOP2:1;
    unsigned NVMOP3:1;
  };
  struct {
    unsigned PROGOP:4;
  };
  struct {
    unsigned PROGOP0:1;
    unsigned PROGOP1:1;
    unsigned PROGOP2:1;
    unsigned PROGOP3:1;
  };
  struct {
    unsigned w:32;
  };
} __NVMCONbits_t;
extern volatile __NVMCONbits_t NVMCONbits __asm__ ("NVMCON") __attribute__((section("sfrs")));
extern volatile unsigned int        NVMCONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        NVMCONSET __attribute__((section("sfrs")));
extern volatile unsigned int        NVMCONINV __attribute__((section("sfrs")));
extern volatile unsigned int        NVMKEY __attribute__((section("sfrs")));
extern volatile unsigned int        NVMADDR __attribute__((section("sfrs")));
extern volatile unsigned int        NVMADDRCLR __attribute__((section("sfrs")));
extern volatile unsigned int        NVMADDRSET __attribute__((section("sfrs")));
extern volatile unsigned int        NVMADDRINV __attribute__((section("sfrs")));
extern volatile unsigned int        NVMDATA0 __attribute__((section("sfrs")));
extern volatile unsigned int        NVMDATA1 __attribute__((section("sfrs")));
extern volatile unsigned int        NVMDATA2 __attribute__((section("sfrs")));
extern volatile unsigned int        NVMDATA3 __attribute__((section("sfrs")));
extern volatile unsigned int        NVMSRCADDR __attribute__((section("sfrs")));
extern volatile unsigned int        NVMPWP __attribute__((section("sfrs")));
typedef struct {
  unsigned PWP:24;
  unsigned :7;
  unsigned PWPULOCK:1;
} __NVMPWPbits_t;
extern volatile __NVMPWPbits_t NVMPWPbits __asm__ ("NVMPWP") __attribute__((section("sfrs")));
extern volatile unsigned int        NVMBWP __attribute__((section("sfrs")));
typedef struct {
  unsigned UBWP0:1;
  unsigned UBWP1:1;
  unsigned UBWP2:1;
  unsigned UBWP3:1;
  unsigned UBWP4:1;
  unsigned :2;
  unsigned UBWPULOCK:1;
  unsigned LBWP0:1;
  unsigned LBWP1:1;
  unsigned LBWP2:1;
  unsigned LBWP3:1;
  unsigned LBWP4:1;
  unsigned :2;
  unsigned LBWPULOCK:1;
} __NVMBWPbits_t;
extern volatile __NVMBWPbits_t NVMBWPbits __asm__ ("NVMBWP") __attribute__((section("sfrs")));
extern volatile unsigned int        NVMBWPCLR __attribute__((section("sfrs")));
extern volatile unsigned int        NVMBWPSET __attribute__((section("sfrs")));
extern volatile unsigned int        NVMBWPINV __attribute__((section("sfrs")));
extern volatile unsigned int        WDTCON __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned :1;
    unsigned WDTWINEN:1;
    unsigned SWDTPS:5;
    unsigned :8;
    unsigned ON:1;
    unsigned WDTCLRKEY:16;
  };
  struct {
    unsigned :2;
    unsigned SWDTPS0:1;
    unsigned SWDTPS1:1;
    unsigned SWDTPS2:1;
    unsigned SWDTPS3:1;
    unsigned SWDTPS4:1;
    unsigned :9;
    unsigned WDTCLRKEY0:1;
    unsigned WDTCLRKEY1:1;
    unsigned WDTCLRKEY2:1;
    unsigned WDTCLRKEY3:1;
    unsigned WDTCLRKEY4:1;
    unsigned WDTCLRKEY5:1;
    unsigned WDTCLRKEY6:1;
    unsigned WDTCLRKEY7:1;
    unsigned WDTCLRKEY8:1;
    unsigned WDTCLRKEY9:1;
    unsigned WDTCLRKEY10:1;
    unsigned WDTCLRKEY11:1;
    unsigned WDTCLRKEY12:1;
    unsigned WDTCLRKEY13:1;
    unsigned WDTCLRKEY14:1;
    unsigned WDTCLRKEY15:1;
  };
  struct {
    unsigned :2;
    unsigned WDTPSTA:5;
  };
  struct {
    unsigned :2;
    unsigned WDTPS:5;
  };
  struct {
    unsigned w:32;
  };
} __WDTCONbits_t;
extern volatile __WDTCONbits_t WDTCONbits __asm__ ("WDTCON") __attribute__((section("sfrs")));
extern volatile unsigned int        WDTCONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        WDTCONSET __attribute__((section("sfrs")));
extern volatile unsigned int        WDTCONINV __attribute__((section("sfrs")));
extern volatile unsigned int        DMTCON __attribute__((section("sfrs")));
typedef struct {
  unsigned :15;
  unsigned ON:1;
} __DMTCONbits_t;
extern volatile __DMTCONbits_t DMTCONbits __asm__ ("DMTCON") __attribute__((section("sfrs")));
extern volatile unsigned int        DMTPRECLR __attribute__((section("sfrs")));
typedef struct {
  unsigned :8;
  unsigned STEP1:8;
} __DMTPRECLRbits_t;
extern volatile __DMTPRECLRbits_t DMTPRECLRbits __asm__ ("DMTPRECLR") __attribute__((section("sfrs")));
extern volatile unsigned int        DMTCLR __attribute__((section("sfrs")));
typedef struct {
  unsigned STEP2:8;
} __DMTCLRbits_t;
extern volatile __DMTCLRbits_t DMTCLRbits __asm__ ("DMTCLR") __attribute__((section("sfrs")));
extern volatile unsigned int        DMTSTAT __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned WINOPN:1;
    unsigned :4;
    unsigned DMTEVENT:1;
    unsigned BAD:2;
  };
  struct {
    unsigned :6;
    unsigned BAD2:1;
    unsigned BAD1:1;
  };
  struct {
    unsigned w:32;
  };
} __DMTSTATbits_t;
extern volatile __DMTSTATbits_t DMTSTATbits __asm__ ("DMTSTAT") __attribute__((section("sfrs")));
extern volatile unsigned int        DMTCNT __attribute__((section("sfrs")));
typedef struct {
  unsigned COUNTER:32;
} __DMTCNTbits_t;
extern volatile __DMTCNTbits_t DMTCNTbits __asm__ ("DMTCNT") __attribute__((section("sfrs")));
extern volatile unsigned int        DMTPSCNT __attribute__((section("sfrs")));
typedef struct {
  unsigned PSCNT:32;
} __DMTPSCNTbits_t;
extern volatile __DMTPSCNTbits_t DMTPSCNTbits __asm__ ("DMTPSCNT") __attribute__((section("sfrs")));
extern volatile unsigned int        DMTPSINTV __attribute__((section("sfrs")));
typedef struct {
  unsigned PSINTV:32;
} __DMTPSINTVbits_t;
extern volatile __DMTPSINTVbits_t DMTPSINTVbits __asm__ ("DMTPSINTV") __attribute__((section("sfrs")));
extern volatile unsigned int        RTCCON __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RTCOE:1;
    unsigned HALFSEC:1;
    unsigned RTCSYNC:1;
    unsigned RTCWREN:1;
    unsigned :1;
    unsigned RTCCLKON:1;
    unsigned RTCOUTSEL:2;
    unsigned RTCCLKSEL:2;
    unsigned :3;
    unsigned SIDL:1;
    unsigned :1;
    unsigned ON:1;
    unsigned CAL:10;
  };
  struct {
    unsigned w:32;
  };
} __RTCCONbits_t;
extern volatile __RTCCONbits_t RTCCONbits __asm__ ("RTCCON") __attribute__((section("sfrs")));
extern volatile unsigned int        RTCCONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        RTCCONSET __attribute__((section("sfrs")));
extern volatile unsigned int        RTCCONINV __attribute__((section("sfrs")));
extern volatile unsigned int        RTCALRM __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned ARPT:8;
    unsigned AMASK:4;
    unsigned ALRMSYNC:1;
    unsigned PIV:1;
    unsigned CHIME:1;
    unsigned ALRMEN:1;
  };
  struct {
    unsigned w:32;
  };
} __RTCALRMbits_t;
extern volatile __RTCALRMbits_t RTCALRMbits __asm__ ("RTCALRM") __attribute__((section("sfrs")));
extern volatile unsigned int        RTCALRMCLR __attribute__((section("sfrs")));
extern volatile unsigned int        RTCALRMSET __attribute__((section("sfrs")));
extern volatile unsigned int        RTCALRMINV __attribute__((section("sfrs")));
extern volatile unsigned int        RTCTIME __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned :8;
    unsigned SEC01:4;
    unsigned SEC10:4;
    unsigned MIN01:4;
    unsigned MIN10:4;
    unsigned HR01:4;
    unsigned HR10:4;
  };
  struct {
    unsigned w:32;
  };
} __RTCTIMEbits_t;
extern volatile __RTCTIMEbits_t RTCTIMEbits __asm__ ("RTCTIME") __attribute__((section("sfrs")));
extern volatile unsigned int        RTCTIMECLR __attribute__((section("sfrs")));
extern volatile unsigned int        RTCTIMESET __attribute__((section("sfrs")));
extern volatile unsigned int        RTCTIMEINV __attribute__((section("sfrs")));
extern volatile unsigned int        RTCDATE __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned WDAY01:4;
    unsigned :4;
    unsigned DAY01:4;
    unsigned DAY10:4;
    unsigned MONTH01:4;
    unsigned MONTH10:4;
    unsigned YEAR01:4;
    unsigned YEAR10:4;
  };
  struct {
    unsigned w:32;
  };
} __RTCDATEbits_t;
extern volatile __RTCDATEbits_t RTCDATEbits __asm__ ("RTCDATE") __attribute__((section("sfrs")));
extern volatile unsigned int        RTCDATECLR __attribute__((section("sfrs")));
extern volatile unsigned int        RTCDATESET __attribute__((section("sfrs")));
extern volatile unsigned int        RTCDATEINV __attribute__((section("sfrs")));
extern volatile unsigned int        ALRMTIME __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned :8;
    unsigned SEC01:4;
    unsigned SEC10:4;
    unsigned MIN01:4;
    unsigned MIN10:4;
    unsigned HR01:4;
    unsigned HR10:4;
  };
  struct {
    unsigned w:32;
  };
} __ALRMTIMEbits_t;
extern volatile __ALRMTIMEbits_t ALRMTIMEbits __asm__ ("ALRMTIME") __attribute__((section("sfrs")));
extern volatile unsigned int        ALRMTIMECLR __attribute__((section("sfrs")));
extern volatile unsigned int        ALRMTIMESET __attribute__((section("sfrs")));
extern volatile unsigned int        ALRMTIMEINV __attribute__((section("sfrs")));
extern volatile unsigned int        ALRMDATE __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned WDAY01:4;
    unsigned :4;
    unsigned DAY01:4;
    unsigned DAY10:4;
    unsigned MONTH01:4;
    unsigned MONTH10:4;
  };
  struct {
    unsigned w:32;
  };
} __ALRMDATEbits_t;
extern volatile __ALRMDATEbits_t ALRMDATEbits __asm__ ("ALRMDATE") __attribute__((section("sfrs")));
extern volatile unsigned int        ALRMDATECLR __attribute__((section("sfrs")));
extern volatile unsigned int        ALRMDATESET __attribute__((section("sfrs")));
extern volatile unsigned int        ALRMDATEINV __attribute__((section("sfrs")));
extern volatile unsigned int        CVRCON __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CVR:4;
    unsigned CVRSS:1;
    unsigned CVRR:1;
    unsigned CVROE:1;
    unsigned :8;
    unsigned ON:1;
  };
  struct {
    unsigned CVR0:1;
    unsigned CVR1:1;
    unsigned CVR2:1;
    unsigned CVR3:1;
  };
  struct {
    unsigned w:32;
  };
} __CVRCONbits_t;
extern volatile __CVRCONbits_t CVRCONbits __asm__ ("CVRCON") __attribute__((section("sfrs")));
extern volatile unsigned int        CVRCONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        CVRCONSET __attribute__((section("sfrs")));
extern volatile unsigned int        CVRCONINV __attribute__((section("sfrs")));
extern volatile unsigned int        _ICDCON __attribute__((section("sfrs")));
typedef struct {
  unsigned CKSWBKEN:1;
  unsigned SLPBKEN:1;
  unsigned WDTBKEN:1;
  unsigned WDTEN:1;
  unsigned RSTBUG:1;
  unsigned DMTBKEN:1;
  unsigned DMTEN:1;
  unsigned :7;
  unsigned FRZ:1;
} ___ICDCONbits_t;
extern volatile ___ICDCONbits_t _ICDCONbits __asm__ ("_ICDCON") __attribute__((section("sfrs")));
extern volatile unsigned int        _ICDSTAT __attribute__((section("sfrs")));
typedef struct {
  unsigned CKSWBF:1;
  unsigned SLPBF:1;
  unsigned WDTBF:1;
  unsigned DMTBF:1;
} ___ICDSTATbits_t;
extern volatile ___ICDSTATbits_t _ICDSTATbits __asm__ ("_ICDSTAT") __attribute__((section("sfrs")));
extern volatile unsigned int        OSCCON __attribute__((section("sfrs")));
typedef struct {
  unsigned OSWEN:1;
  unsigned SOSCEN:1;
  unsigned :1;
  unsigned CF:1;
  unsigned SLPEN:1;
  unsigned SLOCK:1;
  unsigned ULOCK:1;
  unsigned CLKLOCK:1;
  unsigned NOSC:3;
  unsigned :1;
  unsigned COSC:3;
  unsigned :7;
  unsigned SOSCRDY:1;
  unsigned DRMEN:1;
  unsigned FRCDIV:3;
} __OSCCONbits_t;
extern volatile __OSCCONbits_t OSCCONbits __asm__ ("OSCCON") __attribute__((section("sfrs")));
extern volatile unsigned int        OSCCONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        OSCCONSET __attribute__((section("sfrs")));
extern volatile unsigned int        OSCCONINV __attribute__((section("sfrs")));
extern volatile unsigned int        OSCTUN __attribute__((section("sfrs")));
typedef struct {
  unsigned TUN:6;
} __OSCTUNbits_t;
extern volatile __OSCTUNbits_t OSCTUNbits __asm__ ("OSCTUN") __attribute__((section("sfrs")));
extern volatile unsigned int        OSCTUNCLR __attribute__((section("sfrs")));
extern volatile unsigned int        OSCTUNSET __attribute__((section("sfrs")));
extern volatile unsigned int        OSCTUNINV __attribute__((section("sfrs")));
extern volatile unsigned int        SPLLCON __attribute__((section("sfrs")));
typedef struct {
  unsigned PLLRANGE:3;
  unsigned :4;
  unsigned PLLICLK:1;
  unsigned PLLIDIV:3;
  unsigned :5;
  unsigned PLLMULT:7;
  unsigned :1;
  unsigned PLLODIV:3;
} __SPLLCONbits_t;
extern volatile __SPLLCONbits_t SPLLCONbits __asm__ ("SPLLCON") __attribute__((section("sfrs")));
extern volatile unsigned int        SPLLCONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        SPLLCONSET __attribute__((section("sfrs")));
extern volatile unsigned int        SPLLCONINV __attribute__((section("sfrs")));
extern volatile unsigned int        RCON __attribute__((section("sfrs")));
typedef struct {
  unsigned POR:1;
  unsigned BOR:1;
  unsigned IDLE:1;
  unsigned SLEEP:1;
  unsigned WDTO:1;
  unsigned DMTO:1;
  unsigned SWR:1;
  unsigned EXTR:1;
  unsigned :1;
  unsigned CMR:1;
  unsigned :16;
  unsigned BCFGFAIL:1;
  unsigned BCFGERR:1;
} __RCONbits_t;
extern volatile __RCONbits_t RCONbits __asm__ ("RCON") __attribute__((section("sfrs")));
extern volatile unsigned int        RCONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        RCONSET __attribute__((section("sfrs")));
extern volatile unsigned int        RCONINV __attribute__((section("sfrs")));
extern volatile unsigned int        RSWRST __attribute__((section("sfrs")));
typedef struct {
  unsigned SWRST:1;
} __RSWRSTbits_t;
extern volatile __RSWRSTbits_t RSWRSTbits __asm__ ("RSWRST") __attribute__((section("sfrs")));
extern volatile unsigned int        RSWRSTCLR __attribute__((section("sfrs")));
extern volatile unsigned int        RSWRSTSET __attribute__((section("sfrs")));
extern volatile unsigned int        RSWRSTINV __attribute__((section("sfrs")));
extern volatile unsigned int        RNMICON __attribute__((section("sfrs")));
typedef struct {
  unsigned NMICNT:8;
  unsigned :8;
  unsigned WDTS:1;
  unsigned CF:1;
  unsigned :5;
  unsigned SWNMI:1;
  unsigned WDTO:1;
  unsigned DMTO:1;
} __RNMICONbits_t;
extern volatile __RNMICONbits_t RNMICONbits __asm__ ("RNMICON") __attribute__((section("sfrs")));
extern volatile unsigned int        RNMICONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        RNMICONSET __attribute__((section("sfrs")));
extern volatile unsigned int        RNMICONINV __attribute__((section("sfrs")));
extern volatile unsigned int        PWRCON __attribute__((section("sfrs")));
typedef struct {
  unsigned VREGS:1;
} __PWRCONbits_t;
extern volatile __PWRCONbits_t PWRCONbits __asm__ ("PWRCON") __attribute__((section("sfrs")));
extern volatile unsigned int        PWRCONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        PWRCONSET __attribute__((section("sfrs")));
extern volatile unsigned int        PWRCONINV __attribute__((section("sfrs")));
extern volatile unsigned int        REFO1CON __attribute__((section("sfrs")));
typedef struct {
  unsigned ROSEL:4;
  unsigned :4;
  unsigned ACTIVE:1;
  unsigned DIVSWEN:1;
  unsigned :1;
  unsigned RSLP:1;
  unsigned OE:1;
  unsigned SIDL:1;
  unsigned :1;
  unsigned ON:1;
  unsigned RODIV:15;
} __REFO1CONbits_t;
extern volatile __REFO1CONbits_t REFO1CONbits __asm__ ("REFO1CON") __attribute__((section("sfrs")));
extern volatile unsigned int        REFO1CONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        REFO1CONSET __attribute__((section("sfrs")));
extern volatile unsigned int        REFO1CONINV __attribute__((section("sfrs")));
extern volatile unsigned int        REFO1TRIM __attribute__((section("sfrs")));
typedef struct {
  unsigned :23;
  unsigned ROTRIM:9;
} __REFO1TRIMbits_t;
extern volatile __REFO1TRIMbits_t REFO1TRIMbits __asm__ ("REFO1TRIM") __attribute__((section("sfrs")));
extern volatile unsigned int        REFO1TRIMCLR __attribute__((section("sfrs")));
extern volatile unsigned int        REFO1TRIMSET __attribute__((section("sfrs")));
extern volatile unsigned int        REFO1TRIMINV __attribute__((section("sfrs")));
extern volatile unsigned int        REFO2CON __attribute__((section("sfrs")));
typedef struct {
  unsigned ROSEL:4;
  unsigned :4;
  unsigned ACTIVE:1;
  unsigned DIVSWEN:1;
  unsigned :1;
  unsigned RSLP:1;
  unsigned OE:1;
  unsigned SIDL:1;
  unsigned :1;
  unsigned ON:1;
  unsigned RODIV:15;
} __REFO2CONbits_t;
extern volatile __REFO2CONbits_t REFO2CONbits __asm__ ("REFO2CON") __attribute__((section("sfrs")));
extern volatile unsigned int        REFO2CONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        REFO2CONSET __attribute__((section("sfrs")));
extern volatile unsigned int        REFO2CONINV __attribute__((section("sfrs")));
extern volatile unsigned int        REFO2TRIM __attribute__((section("sfrs")));
typedef struct {
  unsigned :23;
  unsigned ROTRIM:9;
} __REFO2TRIMbits_t;
extern volatile __REFO2TRIMbits_t REFO2TRIMbits __asm__ ("REFO2TRIM") __attribute__((section("sfrs")));
extern volatile unsigned int        REFO2TRIMCLR __attribute__((section("sfrs")));
extern volatile unsigned int        REFO2TRIMSET __attribute__((section("sfrs")));
extern volatile unsigned int        REFO2TRIMINV __attribute__((section("sfrs")));
extern volatile unsigned int        REFO3CON __attribute__((section("sfrs")));
typedef struct {
  unsigned ROSEL:4;
  unsigned :4;
  unsigned ACTIVE:1;
  unsigned DIVSWEN:1;
  unsigned :1;
  unsigned RSLP:1;
  unsigned OE:1;
  unsigned SIDL:1;
  unsigned :1;
  unsigned ON:1;
  unsigned RODIV:15;
} __REFO3CONbits_t;
extern volatile __REFO3CONbits_t REFO3CONbits __asm__ ("REFO3CON") __attribute__((section("sfrs")));
extern volatile unsigned int        REFO3CONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        REFO3CONSET __attribute__((section("sfrs")));
extern volatile unsigned int        REFO3CONINV __attribute__((section("sfrs")));
extern volatile unsigned int        REFO3TRIM __attribute__((section("sfrs")));
typedef struct {
  unsigned :23;
  unsigned ROTRIM:9;
} __REFO3TRIMbits_t;
extern volatile __REFO3TRIMbits_t REFO3TRIMbits __asm__ ("REFO3TRIM") __attribute__((section("sfrs")));
extern volatile unsigned int        REFO3TRIMCLR __attribute__((section("sfrs")));
extern volatile unsigned int        REFO3TRIMSET __attribute__((section("sfrs")));
extern volatile unsigned int        REFO3TRIMINV __attribute__((section("sfrs")));
extern volatile unsigned int        REFO4CON __attribute__((section("sfrs")));
typedef struct {
  unsigned ROSEL:4;
  unsigned :4;
  unsigned ACTIVE:1;
  unsigned DIVSWEN:1;
  unsigned :1;
  unsigned RSLP:1;
  unsigned OE:1;
  unsigned SIDL:1;
  unsigned :1;
  unsigned ON:1;
  unsigned RODIV:15;
} __REFO4CONbits_t;
extern volatile __REFO4CONbits_t REFO4CONbits __asm__ ("REFO4CON") __attribute__((section("sfrs")));
extern volatile unsigned int        REFO4CONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        REFO4CONSET __attribute__((section("sfrs")));
extern volatile unsigned int        REFO4CONINV __attribute__((section("sfrs")));
extern volatile unsigned int        REFO4TRIM __attribute__((section("sfrs")));
typedef struct {
  unsigned :23;
  unsigned ROTRIM:9;
} __REFO4TRIMbits_t;
extern volatile __REFO4TRIMbits_t REFO4TRIMbits __asm__ ("REFO4TRIM") __attribute__((section("sfrs")));
extern volatile unsigned int        REFO4TRIMCLR __attribute__((section("sfrs")));
extern volatile unsigned int        REFO4TRIMSET __attribute__((section("sfrs")));
extern volatile unsigned int        REFO4TRIMINV __attribute__((section("sfrs")));
extern volatile unsigned int        PB1DIV __attribute__((section("sfrs")));
typedef struct {
  unsigned PBDIV:7;
  unsigned :4;
  unsigned PBDIVRDY:1;
} __PB1DIVbits_t;
extern volatile __PB1DIVbits_t PB1DIVbits __asm__ ("PB1DIV") __attribute__((section("sfrs")));
extern volatile unsigned int        PB1DIVCLR __attribute__((section("sfrs")));
extern volatile unsigned int        PB1DIVSET __attribute__((section("sfrs")));
extern volatile unsigned int        PB1DIVINV __attribute__((section("sfrs")));
extern volatile unsigned int        PB2DIV __attribute__((section("sfrs")));
typedef struct {
  unsigned PBDIV:7;
  unsigned :4;
  unsigned PBDIVRDY:1;
  unsigned :3;
  unsigned ON:1;
} __PB2DIVbits_t;
extern volatile __PB2DIVbits_t PB2DIVbits __asm__ ("PB2DIV") __attribute__((section("sfrs")));
extern volatile unsigned int        PB2DIVCLR __attribute__((section("sfrs")));
extern volatile unsigned int        PB2DIVSET __attribute__((section("sfrs")));
extern volatile unsigned int        PB2DIVINV __attribute__((section("sfrs")));
extern volatile unsigned int        PB3DIV __attribute__((section("sfrs")));
typedef struct {
  unsigned PBDIV:7;
  unsigned :4;
  unsigned PBDIVRDY:1;
  unsigned :3;
  unsigned ON:1;
} __PB3DIVbits_t;
extern volatile __PB3DIVbits_t PB3DIVbits __asm__ ("PB3DIV") __attribute__((section("sfrs")));
extern volatile unsigned int        PB3DIVCLR __attribute__((section("sfrs")));
extern volatile unsigned int        PB3DIVSET __attribute__((section("sfrs")));
extern volatile unsigned int        PB3DIVINV __attribute__((section("sfrs")));
extern volatile unsigned int        PB4DIV __attribute__((section("sfrs")));
typedef struct {
  unsigned PBDIV:7;
  unsigned :4;
  unsigned PBDIVRDY:1;
  unsigned :3;
  unsigned ON:1;
} __PB4DIVbits_t;
extern volatile __PB4DIVbits_t PB4DIVbits __asm__ ("PB4DIV") __attribute__((section("sfrs")));
extern volatile unsigned int        PB4DIVCLR __attribute__((section("sfrs")));
extern volatile unsigned int        PB4DIVSET __attribute__((section("sfrs")));
extern volatile unsigned int        PB4DIVINV __attribute__((section("sfrs")));
extern volatile unsigned int        PB5DIV __attribute__((section("sfrs")));
typedef struct {
  unsigned PBDIV:7;
  unsigned :4;
  unsigned PBDIVRDY:1;
  unsigned :3;
  unsigned ON:1;
} __PB5DIVbits_t;
extern volatile __PB5DIVbits_t PB5DIVbits __asm__ ("PB5DIV") __attribute__((section("sfrs")));
extern volatile unsigned int        PB5DIVCLR __attribute__((section("sfrs")));
extern volatile unsigned int        PB5DIVSET __attribute__((section("sfrs")));
extern volatile unsigned int        PB5DIVINV __attribute__((section("sfrs")));
extern volatile unsigned int        PB7DIV __attribute__((section("sfrs")));
typedef struct {
  unsigned PBDIV:7;
  unsigned :4;
  unsigned PBDIVRDY:1;
  unsigned :3;
  unsigned ON:1;
} __PB7DIVbits_t;
extern volatile __PB7DIVbits_t PB7DIVbits __asm__ ("PB7DIV") __attribute__((section("sfrs")));
extern volatile unsigned int        PB7DIVCLR __attribute__((section("sfrs")));
extern volatile unsigned int        PB7DIVSET __attribute__((section("sfrs")));
extern volatile unsigned int        PB7DIVINV __attribute__((section("sfrs")));
extern volatile unsigned int        PB8DIV __attribute__((section("sfrs")));
typedef struct {
  unsigned PBDIV:7;
  unsigned :4;
  unsigned PBDIVRDY:1;
  unsigned :3;
  unsigned ON:1;
} __PB8DIVbits_t;
extern volatile __PB8DIVbits_t PB8DIVbits __asm__ ("PB8DIV") __attribute__((section("sfrs")));
extern volatile unsigned int        PB8DIVCLR __attribute__((section("sfrs")));
extern volatile unsigned int        PB8DIVSET __attribute__((section("sfrs")));
extern volatile unsigned int        PB8DIVINV __attribute__((section("sfrs")));
extern volatile unsigned int        INT1R __attribute__((section("sfrs")));
typedef struct {
  unsigned INT1R:4;
} __INT1Rbits_t;
extern volatile __INT1Rbits_t INT1Rbits __asm__ ("INT1R") __attribute__((section("sfrs")));
extern volatile unsigned int        INT2R __attribute__((section("sfrs")));
typedef struct {
  unsigned INT2R:4;
} __INT2Rbits_t;
extern volatile __INT2Rbits_t INT2Rbits __asm__ ("INT2R") __attribute__((section("sfrs")));
extern volatile unsigned int        INT3R __attribute__((section("sfrs")));
typedef struct {
  unsigned INT3R:4;
} __INT3Rbits_t;
extern volatile __INT3Rbits_t INT3Rbits __asm__ ("INT3R") __attribute__((section("sfrs")));
extern volatile unsigned int        INT4R __attribute__((section("sfrs")));
typedef struct {
  unsigned INT4R:4;
} __INT4Rbits_t;
extern volatile __INT4Rbits_t INT4Rbits __asm__ ("INT4R") __attribute__((section("sfrs")));
extern volatile unsigned int        T2CKR __attribute__((section("sfrs")));
typedef struct {
  unsigned T2CKR:4;
} __T2CKRbits_t;
extern volatile __T2CKRbits_t T2CKRbits __asm__ ("T2CKR") __attribute__((section("sfrs")));
extern volatile unsigned int        T3CKR __attribute__((section("sfrs")));
typedef struct {
  unsigned T3CKR:4;
} __T3CKRbits_t;
extern volatile __T3CKRbits_t T3CKRbits __asm__ ("T3CKR") __attribute__((section("sfrs")));
extern volatile unsigned int        T4CKR __attribute__((section("sfrs")));
typedef struct {
  unsigned T4CKR:4;
} __T4CKRbits_t;
extern volatile __T4CKRbits_t T4CKRbits __asm__ ("T4CKR") __attribute__((section("sfrs")));
extern volatile unsigned int        T5CKR __attribute__((section("sfrs")));
typedef struct {
  unsigned T5CKR:4;
} __T5CKRbits_t;
extern volatile __T5CKRbits_t T5CKRbits __asm__ ("T5CKR") __attribute__((section("sfrs")));
extern volatile unsigned int        T6CKR __attribute__((section("sfrs")));
typedef struct {
  unsigned T6CKR:4;
} __T6CKRbits_t;
extern volatile __T6CKRbits_t T6CKRbits __asm__ ("T6CKR") __attribute__((section("sfrs")));
extern volatile unsigned int        T7CKR __attribute__((section("sfrs")));
typedef struct {
  unsigned T7CKR:4;
} __T7CKRbits_t;
extern volatile __T7CKRbits_t T7CKRbits __asm__ ("T7CKR") __attribute__((section("sfrs")));
extern volatile unsigned int        T8CKR __attribute__((section("sfrs")));
typedef struct {
  unsigned T8CKR:4;
} __T8CKRbits_t;
extern volatile __T8CKRbits_t T8CKRbits __asm__ ("T8CKR") __attribute__((section("sfrs")));
extern volatile unsigned int        T9CKR __attribute__((section("sfrs")));
typedef struct {
  unsigned T9CKR:4;
} __T9CKRbits_t;
extern volatile __T9CKRbits_t T9CKRbits __asm__ ("T9CKR") __attribute__((section("sfrs")));
extern volatile unsigned int        IC1R __attribute__((section("sfrs")));
typedef struct {
  unsigned IC1R:4;
} __IC1Rbits_t;
extern volatile __IC1Rbits_t IC1Rbits __asm__ ("IC1R") __attribute__((section("sfrs")));
extern volatile unsigned int        IC2R __attribute__((section("sfrs")));
typedef struct {
  unsigned IC2R:4;
} __IC2Rbits_t;
extern volatile __IC2Rbits_t IC2Rbits __asm__ ("IC2R") __attribute__((section("sfrs")));
extern volatile unsigned int        IC3R __attribute__((section("sfrs")));
typedef struct {
  unsigned IC3R:4;
} __IC3Rbits_t;
extern volatile __IC3Rbits_t IC3Rbits __asm__ ("IC3R") __attribute__((section("sfrs")));
extern volatile unsigned int        IC4R __attribute__((section("sfrs")));
typedef struct {
  unsigned IC4R:4;
} __IC4Rbits_t;
extern volatile __IC4Rbits_t IC4Rbits __asm__ ("IC4R") __attribute__((section("sfrs")));
extern volatile unsigned int        IC5R __attribute__((section("sfrs")));
typedef struct {
  unsigned IC5R:4;
} __IC5Rbits_t;
extern volatile __IC5Rbits_t IC5Rbits __asm__ ("IC5R") __attribute__((section("sfrs")));
extern volatile unsigned int        IC6R __attribute__((section("sfrs")));
typedef struct {
  unsigned IC6R:4;
} __IC6Rbits_t;
extern volatile __IC6Rbits_t IC6Rbits __asm__ ("IC6R") __attribute__((section("sfrs")));
extern volatile unsigned int        IC7R __attribute__((section("sfrs")));
typedef struct {
  unsigned IC7R:4;
} __IC7Rbits_t;
extern volatile __IC7Rbits_t IC7Rbits __asm__ ("IC7R") __attribute__((section("sfrs")));
extern volatile unsigned int        IC8R __attribute__((section("sfrs")));
typedef struct {
  unsigned IC8R:4;
} __IC8Rbits_t;
extern volatile __IC8Rbits_t IC8Rbits __asm__ ("IC8R") __attribute__((section("sfrs")));
extern volatile unsigned int        IC9R __attribute__((section("sfrs")));
typedef struct {
  unsigned IC9R:4;
} __IC9Rbits_t;
extern volatile __IC9Rbits_t IC9Rbits __asm__ ("IC9R") __attribute__((section("sfrs")));
extern volatile unsigned int        OCFAR __attribute__((section("sfrs")));
typedef struct {
  unsigned OCFAR:4;
} __OCFARbits_t;
extern volatile __OCFARbits_t OCFARbits __asm__ ("OCFAR") __attribute__((section("sfrs")));
extern volatile unsigned int        U1RXR __attribute__((section("sfrs")));
typedef struct {
  unsigned U1RXR:4;
} __U1RXRbits_t;
extern volatile __U1RXRbits_t U1RXRbits __asm__ ("U1RXR") __attribute__((section("sfrs")));
extern volatile unsigned int        U1CTSR __attribute__((section("sfrs")));
typedef struct {
  unsigned U1CTSR:4;
} __U1CTSRbits_t;
extern volatile __U1CTSRbits_t U1CTSRbits __asm__ ("U1CTSR") __attribute__((section("sfrs")));
extern volatile unsigned int        U2RXR __attribute__((section("sfrs")));
typedef struct {
  unsigned U2RXR:4;
} __U2RXRbits_t;
extern volatile __U2RXRbits_t U2RXRbits __asm__ ("U2RXR") __attribute__((section("sfrs")));
extern volatile unsigned int        U2CTSR __attribute__((section("sfrs")));
typedef struct {
  unsigned U2CTSR:4;
} __U2CTSRbits_t;
extern volatile __U2CTSRbits_t U2CTSRbits __asm__ ("U2CTSR") __attribute__((section("sfrs")));
extern volatile unsigned int        U3RXR __attribute__((section("sfrs")));
typedef struct {
  unsigned U3RXR:4;
} __U3RXRbits_t;
extern volatile __U3RXRbits_t U3RXRbits __asm__ ("U3RXR") __attribute__((section("sfrs")));
extern volatile unsigned int        U3CTSR __attribute__((section("sfrs")));
typedef struct {
  unsigned U3CTSR:4;
} __U3CTSRbits_t;
extern volatile __U3CTSRbits_t U3CTSRbits __asm__ ("U3CTSR") __attribute__((section("sfrs")));
extern volatile unsigned int        U4RXR __attribute__((section("sfrs")));
typedef struct {
  unsigned U4RXR:4;
} __U4RXRbits_t;
extern volatile __U4RXRbits_t U4RXRbits __asm__ ("U4RXR") __attribute__((section("sfrs")));
extern volatile unsigned int        U4CTSR __attribute__((section("sfrs")));
typedef struct {
  unsigned U4CTSR:4;
} __U4CTSRbits_t;
extern volatile __U4CTSRbits_t U4CTSRbits __asm__ ("U4CTSR") __attribute__((section("sfrs")));
extern volatile unsigned int        U5RXR __attribute__((section("sfrs")));
typedef struct {
  unsigned U5RXR:4;
} __U5RXRbits_t;
extern volatile __U5RXRbits_t U5RXRbits __asm__ ("U5RXR") __attribute__((section("sfrs")));
extern volatile unsigned int        U5CTSR __attribute__((section("sfrs")));
typedef struct {
  unsigned U5CTSR:4;
} __U5CTSRbits_t;
extern volatile __U5CTSRbits_t U5CTSRbits __asm__ ("U5CTSR") __attribute__((section("sfrs")));
extern volatile unsigned int        U6RXR __attribute__((section("sfrs")));
typedef struct {
  unsigned U6RXR:4;
} __U6RXRbits_t;
extern volatile __U6RXRbits_t U6RXRbits __asm__ ("U6RXR") __attribute__((section("sfrs")));
extern volatile unsigned int        U6CTSR __attribute__((section("sfrs")));
typedef struct {
  unsigned U6CTSR:4;
} __U6CTSRbits_t;
extern volatile __U6CTSRbits_t U6CTSRbits __asm__ ("U6CTSR") __attribute__((section("sfrs")));
extern volatile unsigned int        SDI1R __attribute__((section("sfrs")));
typedef struct {
  unsigned SDI1R:4;
} __SDI1Rbits_t;
extern volatile __SDI1Rbits_t SDI1Rbits __asm__ ("SDI1R") __attribute__((section("sfrs")));
extern volatile unsigned int        SS1R __attribute__((section("sfrs")));
typedef struct {
  unsigned SS1R:4;
} __SS1Rbits_t;
extern volatile __SS1Rbits_t SS1Rbits __asm__ ("SS1R") __attribute__((section("sfrs")));
extern volatile unsigned int        SDI2R __attribute__((section("sfrs")));
typedef struct {
  unsigned SDI2R:4;
} __SDI2Rbits_t;
extern volatile __SDI2Rbits_t SDI2Rbits __asm__ ("SDI2R") __attribute__((section("sfrs")));
extern volatile unsigned int        SS2R __attribute__((section("sfrs")));
typedef struct {
  unsigned SS2R:4;
} __SS2Rbits_t;
extern volatile __SS2Rbits_t SS2Rbits __asm__ ("SS2R") __attribute__((section("sfrs")));
extern volatile unsigned int        SDI3R __attribute__((section("sfrs")));
typedef struct {
  unsigned SDI3R:4;
} __SDI3Rbits_t;
extern volatile __SDI3Rbits_t SDI3Rbits __asm__ ("SDI3R") __attribute__((section("sfrs")));
extern volatile unsigned int        SS3R __attribute__((section("sfrs")));
typedef struct {
  unsigned SS3R:4;
} __SS3Rbits_t;
extern volatile __SS3Rbits_t SS3Rbits __asm__ ("SS3R") __attribute__((section("sfrs")));
extern volatile unsigned int        SDI4R __attribute__((section("sfrs")));
typedef struct {
  unsigned SDI4R:4;
} __SDI4Rbits_t;
extern volatile __SDI4Rbits_t SDI4Rbits __asm__ ("SDI4R") __attribute__((section("sfrs")));
extern volatile unsigned int        SS4R __attribute__((section("sfrs")));
typedef struct {
  unsigned SS4R:4;
} __SS4Rbits_t;
extern volatile __SS4Rbits_t SS4Rbits __asm__ ("SS4R") __attribute__((section("sfrs")));
extern volatile unsigned int        SDI5R __attribute__((section("sfrs")));
typedef struct {
  unsigned SDI5R:4;
} __SDI5Rbits_t;
extern volatile __SDI5Rbits_t SDI5Rbits __asm__ ("SDI5R") __attribute__((section("sfrs")));
extern volatile unsigned int        SS5R __attribute__((section("sfrs")));
typedef struct {
  unsigned SS5R:4;
} __SS5Rbits_t;
extern volatile __SS5Rbits_t SS5Rbits __asm__ ("SS5R") __attribute__((section("sfrs")));
extern volatile unsigned int        SDI6R __attribute__((section("sfrs")));
typedef struct {
  unsigned SDI6R:4;
} __SDI6Rbits_t;
extern volatile __SDI6Rbits_t SDI6Rbits __asm__ ("SDI6R") __attribute__((section("sfrs")));
extern volatile unsigned int        SS6R __attribute__((section("sfrs")));
typedef struct {
  unsigned SS6R:4;
} __SS6Rbits_t;
extern volatile __SS6Rbits_t SS6Rbits __asm__ ("SS6R") __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXR __attribute__((section("sfrs")));
typedef struct {
  unsigned C1RXR:4;
} __C1RXRbits_t;
extern volatile __C1RXRbits_t C1RXRbits __asm__ ("C1RXR") __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXR __attribute__((section("sfrs")));
typedef struct {
  unsigned C2RXR:4;
} __C2RXRbits_t;
extern volatile __C2RXRbits_t C2RXRbits __asm__ ("C2RXR") __attribute__((section("sfrs")));
extern volatile unsigned int        REFCLKI1R __attribute__((section("sfrs")));
typedef struct {
  unsigned REFCLKI1R:4;
} __REFCLKI1Rbits_t;
extern volatile __REFCLKI1Rbits_t REFCLKI1Rbits __asm__ ("REFCLKI1R") __attribute__((section("sfrs")));
extern volatile unsigned int        REFCLKI3R __attribute__((section("sfrs")));
typedef struct {
  unsigned REFCLKI3R:4;
} __REFCLKI3Rbits_t;
extern volatile __REFCLKI3Rbits_t REFCLKI3Rbits __asm__ ("REFCLKI3R") __attribute__((section("sfrs")));
extern volatile unsigned int        REFCLKI4R __attribute__((section("sfrs")));
typedef struct {
  unsigned REFCLKI4R:4;
} __REFCLKI4Rbits_t;
extern volatile __REFCLKI4Rbits_t REFCLKI4Rbits __asm__ ("REFCLKI4R") __attribute__((section("sfrs")));
extern volatile unsigned int        RPA14R __attribute__((section("sfrs")));
typedef struct {
  unsigned RPA14R:4;
} __RPA14Rbits_t;
extern volatile __RPA14Rbits_t RPA14Rbits __asm__ ("RPA14R") __attribute__((section("sfrs")));
extern volatile unsigned int        RPA15R __attribute__((section("sfrs")));
typedef struct {
  unsigned RPA15R:4;
} __RPA15Rbits_t;
extern volatile __RPA15Rbits_t RPA15Rbits __asm__ ("RPA15R") __attribute__((section("sfrs")));
extern volatile unsigned int        RPB0R __attribute__((section("sfrs")));
typedef struct {
  unsigned RPB0R:4;
} __RPB0Rbits_t;
extern volatile __RPB0Rbits_t RPB0Rbits __asm__ ("RPB0R") __attribute__((section("sfrs")));
extern volatile unsigned int        RPB1R __attribute__((section("sfrs")));
typedef struct {
  unsigned RPB1R:4;
} __RPB1Rbits_t;
extern volatile __RPB1Rbits_t RPB1Rbits __asm__ ("RPB1R") __attribute__((section("sfrs")));
extern volatile unsigned int        RPB2R __attribute__((section("sfrs")));
typedef struct {
  unsigned RPB2R:4;
} __RPB2Rbits_t;
extern volatile __RPB2Rbits_t RPB2Rbits __asm__ ("RPB2R") __attribute__((section("sfrs")));
extern volatile unsigned int        RPB3R __attribute__((section("sfrs")));
typedef struct {
  unsigned RPB3R:4;
} __RPB3Rbits_t;
extern volatile __RPB3Rbits_t RPB3Rbits __asm__ ("RPB3R") __attribute__((section("sfrs")));
extern volatile unsigned int        RPB5R __attribute__((section("sfrs")));
typedef struct {
  unsigned RPB5R:4;
} __RPB5Rbits_t;
extern volatile __RPB5Rbits_t RPB5Rbits __asm__ ("RPB5R") __attribute__((section("sfrs")));
extern volatile unsigned int        RPB6R __attribute__((section("sfrs")));
typedef struct {
  unsigned RPB6R:4;
} __RPB6Rbits_t;
extern volatile __RPB6Rbits_t RPB6Rbits __asm__ ("RPB6R") __attribute__((section("sfrs")));
extern volatile unsigned int        RPB7R __attribute__((section("sfrs")));
typedef struct {
  unsigned RPB7R:4;
} __RPB7Rbits_t;
extern volatile __RPB7Rbits_t RPB7Rbits __asm__ ("RPB7R") __attribute__((section("sfrs")));
extern volatile unsigned int        RPB8R __attribute__((section("sfrs")));
typedef struct {
  unsigned RPB8R:4;
} __RPB8Rbits_t;
extern volatile __RPB8Rbits_t RPB8Rbits __asm__ ("RPB8R") __attribute__((section("sfrs")));
extern volatile unsigned int        RPB9R __attribute__((section("sfrs")));
typedef struct {
  unsigned RPB9R:4;
} __RPB9Rbits_t;
extern volatile __RPB9Rbits_t RPB9Rbits __asm__ ("RPB9R") __attribute__((section("sfrs")));
extern volatile unsigned int        RPB10R __attribute__((section("sfrs")));
typedef struct {
  unsigned RPB10R:4;
} __RPB10Rbits_t;
extern volatile __RPB10Rbits_t RPB10Rbits __asm__ ("RPB10R") __attribute__((section("sfrs")));
extern volatile unsigned int        RPB14R __attribute__((section("sfrs")));
typedef struct {
  unsigned RPB14R:4;
} __RPB14Rbits_t;
extern volatile __RPB14Rbits_t RPB14Rbits __asm__ ("RPB14R") __attribute__((section("sfrs")));
extern volatile unsigned int        RPB15R __attribute__((section("sfrs")));
typedef struct {
  unsigned RPB15R:4;
} __RPB15Rbits_t;
extern volatile __RPB15Rbits_t RPB15Rbits __asm__ ("RPB15R") __attribute__((section("sfrs")));
extern volatile unsigned int        RPC1R __attribute__((section("sfrs")));
typedef struct {
  unsigned RPC1R:4;
} __RPC1Rbits_t;
extern volatile __RPC1Rbits_t RPC1Rbits __asm__ ("RPC1R") __attribute__((section("sfrs")));
extern volatile unsigned int        RPC2R __attribute__((section("sfrs")));
typedef struct {
  unsigned RPC2R:4;
} __RPC2Rbits_t;
extern volatile __RPC2Rbits_t RPC2Rbits __asm__ ("RPC2R") __attribute__((section("sfrs")));
extern volatile unsigned int        RPC3R __attribute__((section("sfrs")));
typedef struct {
  unsigned RPC3R:4;
} __RPC3Rbits_t;
extern volatile __RPC3Rbits_t RPC3Rbits __asm__ ("RPC3R") __attribute__((section("sfrs")));
extern volatile unsigned int        RPC4R __attribute__((section("sfrs")));
typedef struct {
  unsigned RPC4R:4;
} __RPC4Rbits_t;
extern volatile __RPC4Rbits_t RPC4Rbits __asm__ ("RPC4R") __attribute__((section("sfrs")));
extern volatile unsigned int        RPC13R __attribute__((section("sfrs")));
typedef struct {
  unsigned RPC13R:4;
} __RPC13Rbits_t;
extern volatile __RPC13Rbits_t RPC13Rbits __asm__ ("RPC13R") __attribute__((section("sfrs")));
extern volatile unsigned int        RPC14R __attribute__((section("sfrs")));
typedef struct {
  unsigned RPC14R:4;
} __RPC14Rbits_t;
extern volatile __RPC14Rbits_t RPC14Rbits __asm__ ("RPC14R") __attribute__((section("sfrs")));
extern volatile unsigned int        RPD0R __attribute__((section("sfrs")));
typedef struct {
  unsigned RPD0R:4;
} __RPD0Rbits_t;
extern volatile __RPD0Rbits_t RPD0Rbits __asm__ ("RPD0R") __attribute__((section("sfrs")));
extern volatile unsigned int        RPD1R __attribute__((section("sfrs")));
typedef struct {
  unsigned RPD1R:4;
} __RPD1Rbits_t;
extern volatile __RPD1Rbits_t RPD1Rbits __asm__ ("RPD1R") __attribute__((section("sfrs")));
extern volatile unsigned int        RPD2R __attribute__((section("sfrs")));
typedef struct {
  unsigned RPD2R:4;
} __RPD2Rbits_t;
extern volatile __RPD2Rbits_t RPD2Rbits __asm__ ("RPD2R") __attribute__((section("sfrs")));
extern volatile unsigned int        RPD3R __attribute__((section("sfrs")));
typedef struct {
  unsigned RPD3R:4;
} __RPD3Rbits_t;
extern volatile __RPD3Rbits_t RPD3Rbits __asm__ ("RPD3R") __attribute__((section("sfrs")));
extern volatile unsigned int        RPD4R __attribute__((section("sfrs")));
typedef struct {
  unsigned RPD4R:4;
} __RPD4Rbits_t;
extern volatile __RPD4Rbits_t RPD4Rbits __asm__ ("RPD4R") __attribute__((section("sfrs")));
extern volatile unsigned int        RPD5R __attribute__((section("sfrs")));
typedef struct {
  unsigned RPD5R:4;
} __RPD5Rbits_t;
extern volatile __RPD5Rbits_t RPD5Rbits __asm__ ("RPD5R") __attribute__((section("sfrs")));
extern volatile unsigned int        RPD6R __attribute__((section("sfrs")));
typedef struct {
  unsigned RPD6R:4;
} __RPD6Rbits_t;
extern volatile __RPD6Rbits_t RPD6Rbits __asm__ ("RPD6R") __attribute__((section("sfrs")));
extern volatile unsigned int        RPD7R __attribute__((section("sfrs")));
typedef struct {
  unsigned RPD7R:4;
} __RPD7Rbits_t;
extern volatile __RPD7Rbits_t RPD7Rbits __asm__ ("RPD7R") __attribute__((section("sfrs")));
extern volatile unsigned int        RPD9R __attribute__((section("sfrs")));
typedef struct {
  unsigned RPD9R:4;
} __RPD9Rbits_t;
extern volatile __RPD9Rbits_t RPD9Rbits __asm__ ("RPD9R") __attribute__((section("sfrs")));
extern volatile unsigned int        RPD10R __attribute__((section("sfrs")));
typedef struct {
  unsigned RPD10R:4;
} __RPD10Rbits_t;
extern volatile __RPD10Rbits_t RPD10Rbits __asm__ ("RPD10R") __attribute__((section("sfrs")));
extern volatile unsigned int        RPD11R __attribute__((section("sfrs")));
typedef struct {
  unsigned RPD11R:4;
} __RPD11Rbits_t;
extern volatile __RPD11Rbits_t RPD11Rbits __asm__ ("RPD11R") __attribute__((section("sfrs")));
extern volatile unsigned int        RPD12R __attribute__((section("sfrs")));
typedef struct {
  unsigned RPD12R:4;
} __RPD12Rbits_t;
extern volatile __RPD12Rbits_t RPD12Rbits __asm__ ("RPD12R") __attribute__((section("sfrs")));
extern volatile unsigned int        RPD14R __attribute__((section("sfrs")));
typedef struct {
  unsigned RPD14R:4;
} __RPD14Rbits_t;
extern volatile __RPD14Rbits_t RPD14Rbits __asm__ ("RPD14R") __attribute__((section("sfrs")));
extern volatile unsigned int        RPD15R __attribute__((section("sfrs")));
typedef struct {
  unsigned RPD15R:4;
} __RPD15Rbits_t;
extern volatile __RPD15Rbits_t RPD15Rbits __asm__ ("RPD15R") __attribute__((section("sfrs")));
extern volatile unsigned int        RPE3R __attribute__((section("sfrs")));
typedef struct {
  unsigned RPE3R:4;
} __RPE3Rbits_t;
extern volatile __RPE3Rbits_t RPE3Rbits __asm__ ("RPE3R") __attribute__((section("sfrs")));
extern volatile unsigned int        RPE5R __attribute__((section("sfrs")));
typedef struct {
  unsigned RPE5R:4;
} __RPE5Rbits_t;
extern volatile __RPE5Rbits_t RPE5Rbits __asm__ ("RPE5R") __attribute__((section("sfrs")));
extern volatile unsigned int        RPE8R __attribute__((section("sfrs")));
typedef struct {
  unsigned RPE8R:4;
} __RPE8Rbits_t;
extern volatile __RPE8Rbits_t RPE8Rbits __asm__ ("RPE8R") __attribute__((section("sfrs")));
extern volatile unsigned int        RPE9R __attribute__((section("sfrs")));
typedef struct {
  unsigned RPE9R:4;
} __RPE9Rbits_t;
extern volatile __RPE9Rbits_t RPE9Rbits __asm__ ("RPE9R") __attribute__((section("sfrs")));
extern volatile unsigned int        RPF0R __attribute__((section("sfrs")));
typedef struct {
  unsigned RPF0R:4;
} __RPF0Rbits_t;
extern volatile __RPF0Rbits_t RPF0Rbits __asm__ ("RPF0R") __attribute__((section("sfrs")));
extern volatile unsigned int        RPF1R __attribute__((section("sfrs")));
typedef struct {
  unsigned RPF1R:4;
} __RPF1Rbits_t;
extern volatile __RPF1Rbits_t RPF1Rbits __asm__ ("RPF1R") __attribute__((section("sfrs")));
extern volatile unsigned int        RPF2R __attribute__((section("sfrs")));
typedef struct {
  unsigned RPF2R:4;
} __RPF2Rbits_t;
extern volatile __RPF2Rbits_t RPF2Rbits __asm__ ("RPF2R") __attribute__((section("sfrs")));
extern volatile unsigned int        RPF3R __attribute__((section("sfrs")));
typedef struct {
  unsigned RPF3R:4;
} __RPF3Rbits_t;
extern volatile __RPF3Rbits_t RPF3Rbits __asm__ ("RPF3R") __attribute__((section("sfrs")));
extern volatile unsigned int        RPF4R __attribute__((section("sfrs")));
typedef struct {
  unsigned RPF4R:4;
} __RPF4Rbits_t;
extern volatile __RPF4Rbits_t RPF4Rbits __asm__ ("RPF4R") __attribute__((section("sfrs")));
extern volatile unsigned int        RPF5R __attribute__((section("sfrs")));
typedef struct {
  unsigned RPF5R:4;
} __RPF5Rbits_t;
extern volatile __RPF5Rbits_t RPF5Rbits __asm__ ("RPF5R") __attribute__((section("sfrs")));
extern volatile unsigned int        RPF8R __attribute__((section("sfrs")));
typedef struct {
  unsigned RPF8R:4;
} __RPF8Rbits_t;
extern volatile __RPF8Rbits_t RPF8Rbits __asm__ ("RPF8R") __attribute__((section("sfrs")));
extern volatile unsigned int        RPF12R __attribute__((section("sfrs")));
typedef struct {
  unsigned RPF12R:4;
} __RPF12Rbits_t;
extern volatile __RPF12Rbits_t RPF12Rbits __asm__ ("RPF12R") __attribute__((section("sfrs")));
extern volatile unsigned int        RPF13R __attribute__((section("sfrs")));
typedef struct {
  unsigned RPF13R:4;
} __RPF13Rbits_t;
extern volatile __RPF13Rbits_t RPF13Rbits __asm__ ("RPF13R") __attribute__((section("sfrs")));
extern volatile unsigned int        RPG0R __attribute__((section("sfrs")));
typedef struct {
  unsigned RPG0R:4;
} __RPG0Rbits_t;
extern volatile __RPG0Rbits_t RPG0Rbits __asm__ ("RPG0R") __attribute__((section("sfrs")));
extern volatile unsigned int        RPG1R __attribute__((section("sfrs")));
typedef struct {
  unsigned RPG1R:4;
} __RPG1Rbits_t;
extern volatile __RPG1Rbits_t RPG1Rbits __asm__ ("RPG1R") __attribute__((section("sfrs")));
extern volatile unsigned int        RPG6R __attribute__((section("sfrs")));
typedef struct {
  unsigned RPG6R:4;
} __RPG6Rbits_t;
extern volatile __RPG6Rbits_t RPG6Rbits __asm__ ("RPG6R") __attribute__((section("sfrs")));
extern volatile unsigned int        RPG7R __attribute__((section("sfrs")));
typedef struct {
  unsigned RPG7R:4;
} __RPG7Rbits_t;
extern volatile __RPG7Rbits_t RPG7Rbits __asm__ ("RPG7R") __attribute__((section("sfrs")));
extern volatile unsigned int        RPG8R __attribute__((section("sfrs")));
typedef struct {
  unsigned RPG8R:4;
} __RPG8Rbits_t;
extern volatile __RPG8Rbits_t RPG8Rbits __asm__ ("RPG8R") __attribute__((section("sfrs")));
extern volatile unsigned int        RPG9R __attribute__((section("sfrs")));
typedef struct {
  unsigned RPG9R:4;
} __RPG9Rbits_t;
extern volatile __RPG9Rbits_t RPG9Rbits __asm__ ("RPG9R") __attribute__((section("sfrs")));
extern volatile unsigned int        INTCON __attribute__((section("sfrs")));
typedef struct {
  unsigned INT0EP:1;
  unsigned INT1EP:1;
  unsigned INT2EP:1;
  unsigned INT3EP:1;
  unsigned INT4EP:1;
  unsigned :3;
  unsigned TPC:3;
  unsigned :1;
  unsigned MVEC:1;
} __INTCONbits_t;
extern volatile __INTCONbits_t INTCONbits __asm__ ("INTCON") __attribute__((section("sfrs")));
extern volatile unsigned int        INTCONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        INTCONSET __attribute__((section("sfrs")));
extern volatile unsigned int        INTCONINV __attribute__((section("sfrs")));
extern volatile unsigned int        PRISS __attribute__((section("sfrs")));
typedef struct {
  unsigned SS0:1;
  unsigned :3;
  unsigned PRI1SS:4;
  unsigned PRI2SS:4;
  unsigned PRI3SS:4;
  unsigned PRI4SS:4;
  unsigned PRI5SS:4;
  unsigned PRI6SS:4;
  unsigned PRI7SS:4;
} __PRISSbits_t;
extern volatile __PRISSbits_t PRISSbits __asm__ ("PRISS") __attribute__((section("sfrs")));
extern volatile unsigned int        PRISSCLR __attribute__((section("sfrs")));
extern volatile unsigned int        PRISSSET __attribute__((section("sfrs")));
extern volatile unsigned int        PRISSINV __attribute__((section("sfrs")));
extern volatile unsigned int        INTSTAT __attribute__((section("sfrs")));
typedef struct {
  unsigned SIRQ:8;
  unsigned SRIPL:3;
} __INTSTATbits_t;
extern volatile __INTSTATbits_t INTSTATbits __asm__ ("INTSTAT") __attribute__((section("sfrs")));
extern volatile unsigned int        INTSTATCLR __attribute__((section("sfrs")));
extern volatile unsigned int        INTSTATSET __attribute__((section("sfrs")));
extern volatile unsigned int        INTSTATINV __attribute__((section("sfrs")));
extern volatile unsigned int        IPTMR __attribute__((section("sfrs")));
typedef struct {
  unsigned IPTMR:32;
} __IPTMRbits_t;
extern volatile __IPTMRbits_t IPTMRbits __asm__ ("IPTMR") __attribute__((section("sfrs")));
extern volatile unsigned int        IPTMRCLR __attribute__((section("sfrs")));
extern volatile unsigned int        IPTMRSET __attribute__((section("sfrs")));
extern volatile unsigned int        IPTMRINV __attribute__((section("sfrs")));
extern volatile unsigned int        IFS0 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CTIF:1;
    unsigned CS0IF:1;
    unsigned CS1IF:1;
    unsigned INT0IF:1;
    unsigned T1IF:1;
    unsigned IC1EIF:1;
    unsigned IC1IF:1;
    unsigned OC1IF:1;
    unsigned INT1IF:1;
    unsigned T2IF:1;
    unsigned IC2EIF:1;
    unsigned IC2IF:1;
    unsigned OC2IF:1;
    unsigned INT2IF:1;
    unsigned T3IF:1;
    unsigned IC3EIF:1;
    unsigned IC3IF:1;
    unsigned OC3IF:1;
    unsigned INT3IF:1;
    unsigned T4IF:1;
    unsigned IC4EIF:1;
    unsigned IC4IF:1;
    unsigned OC4IF:1;
    unsigned INT4IF:1;
    unsigned T5IF:1;
    unsigned IC5EIF:1;
    unsigned IC5IF:1;
    unsigned OC5IF:1;
    unsigned T6IF:1;
    unsigned IC6EIF:1;
    unsigned IC6IF:1;
    unsigned OC6IF:1;
  };
  struct {
    unsigned w:32;
  };
} __IFS0bits_t;
extern volatile __IFS0bits_t IFS0bits __asm__ ("IFS0") __attribute__((section("sfrs")));
extern volatile unsigned int        IFS0CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IFS0SET __attribute__((section("sfrs")));
extern volatile unsigned int        IFS0INV __attribute__((section("sfrs")));
extern volatile unsigned int        IFS1 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned T7IF:1;
    unsigned IC7EIF:1;
    unsigned IC7IF:1;
    unsigned OC7IF:1;
    unsigned T8IF:1;
    unsigned IC8EIF:1;
    unsigned IC8IF:1;
    unsigned OC8IF:1;
    unsigned T9IF:1;
    unsigned IC9EIF:1;
    unsigned IC9IF:1;
    unsigned OC9IF:1;
    unsigned AD1IF:1;
    unsigned :1;
    unsigned AD1DC1IF:1;
    unsigned AD1DC2IF:1;
    unsigned AD1DC3IF:1;
    unsigned AD1DC4IF:1;
    unsigned AD1DC5IF:1;
    unsigned AD1DC6IF:1;
    unsigned AD1DF1IF:1;
    unsigned AD1DF2IF:1;
    unsigned AD1DF3IF:1;
    unsigned AD1DF4IF:1;
    unsigned AD1DF5IF:1;
    unsigned AD1DF6IF:1;
    unsigned :1;
    unsigned AD1D0IF:1;
    unsigned AD1D1IF:1;
    unsigned AD1D2IF:1;
    unsigned AD1D3IF:1;
    unsigned AD1D4IF:1;
  };
  struct {
    unsigned w:32;
  };
} __IFS1bits_t;
extern volatile __IFS1bits_t IFS1bits __asm__ ("IFS1") __attribute__((section("sfrs")));
extern volatile unsigned int        IFS1CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IFS1SET __attribute__((section("sfrs")));
extern volatile unsigned int        IFS1INV __attribute__((section("sfrs")));
extern volatile unsigned int        IFS2 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned AD1D5IF:1;
    unsigned AD1D6IF:1;
    unsigned AD1D7IF:1;
    unsigned AD1D8IF:1;
    unsigned AD1D9IF:1;
    unsigned AD1D10IF:1;
    unsigned AD1D11IF:1;
    unsigned AD1D12IF:1;
    unsigned AD1D13IF:1;
    unsigned AD1D14IF:1;
    unsigned AD1D15IF:1;
    unsigned AD1D16IF:1;
    unsigned AD1D17IF:1;
    unsigned AD1D18IF:1;
    unsigned AD1D19IF:1;
    unsigned AD1D20IF:1;
    unsigned AD1D21IF:1;
    unsigned AD1D22IF:1;
    unsigned AD1D23IF:1;
    unsigned AD1D24IF:1;
    unsigned AD1D25IF:1;
    unsigned AD1D26IF:1;
    unsigned AD1D27IF:1;
    unsigned AD1D28IF:1;
    unsigned AD1D29IF:1;
    unsigned AD1D30IF:1;
    unsigned AD1D31IF:1;
    unsigned AD1D32IF:1;
    unsigned AD1D33IF:1;
    unsigned AD1D34IF:1;
    unsigned AD1D35IF:1;
    unsigned AD1D36IF:1;
  };
  struct {
    unsigned w:32;
  };
} __IFS2bits_t;
extern volatile __IFS2bits_t IFS2bits __asm__ ("IFS2") __attribute__((section("sfrs")));
extern volatile unsigned int        IFS2CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IFS2SET __attribute__((section("sfrs")));
extern volatile unsigned int        IFS2INV __attribute__((section("sfrs")));
extern volatile unsigned int        IFS3 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned AD1D37IF:1;
    unsigned AD1D38IF:1;
    unsigned AD1D39IF:1;
    unsigned AD1D40IF:1;
    unsigned AD1D41IF:1;
    unsigned AD1D42IF:1;
    unsigned AD1D43IF:1;
    unsigned AD1D44IF:1;
    unsigned CPCIF:1;
    unsigned CFDCIF:1;
    unsigned SBIF:1;
    unsigned CRPTIF:1;
    unsigned :1;
    unsigned SPI1EIF:1;
    unsigned SPI1RXIF:1;
    unsigned SPI1TXIF:1;
    unsigned U1EIF:1;
    unsigned U1RXIF:1;
    unsigned U1TXIF:1;
    unsigned I2C1BIF:1;
    unsigned I2C1SIF:1;
    unsigned I2C1MIF:1;
    unsigned CNAIF:1;
    unsigned CNBIF:1;
    unsigned CNCIF:1;
    unsigned CNDIF:1;
    unsigned CNEIF:1;
    unsigned CNFIF:1;
    unsigned CNGIF:1;
    unsigned CNHIF:1;
    unsigned CNJIF:1;
    unsigned CNKIF:1;
  };
  struct {
    unsigned w:32;
  };
} __IFS3bits_t;
extern volatile __IFS3bits_t IFS3bits __asm__ ("IFS3") __attribute__((section("sfrs")));
extern volatile unsigned int        IFS3CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IFS3SET __attribute__((section("sfrs")));
extern volatile unsigned int        IFS3INV __attribute__((section("sfrs")));
extern volatile unsigned int        IFS4 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned PMPIF:1;
    unsigned PMPEIF:1;
    unsigned CMP1IF:1;
    unsigned CMP2IF:1;
    unsigned USBIF:1;
    unsigned USBDMAIF:1;
    unsigned DMA0IF:1;
    unsigned DMA1IF:1;
    unsigned DMA2IF:1;
    unsigned DMA3IF:1;
    unsigned DMA4IF:1;
    unsigned DMA5IF:1;
    unsigned DMA6IF:1;
    unsigned DMA7IF:1;
    unsigned SPI2EIF:1;
    unsigned SPI2RXIF:1;
    unsigned SPI2TXIF:1;
    unsigned U2EIF:1;
    unsigned U2RXIF:1;
    unsigned U2TXIF:1;
    unsigned I2C2BIF:1;
    unsigned I2C2SIF:1;
    unsigned I2C2MIF:1;
    unsigned CAN1IF:1;
    unsigned CAN2IF:1;
    unsigned ETHIF:1;
    unsigned SPI3EIF:1;
    unsigned SPI3RXIF:1;
    unsigned SPI3TXIF:1;
    unsigned U3EIF:1;
    unsigned U3RXIF:1;
    unsigned U3TXIF:1;
  };
  struct {
    unsigned w:32;
  };
} __IFS4bits_t;
extern volatile __IFS4bits_t IFS4bits __asm__ ("IFS4") __attribute__((section("sfrs")));
extern volatile unsigned int        IFS4CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IFS4SET __attribute__((section("sfrs")));
extern volatile unsigned int        IFS4INV __attribute__((section("sfrs")));
extern volatile unsigned int        IFS5 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned I2C3BIF:1;
    unsigned I2C3SIF:1;
    unsigned I2C3MIF:1;
    unsigned SPI4EIF:1;
    unsigned SPI4RXIF:1;
    unsigned SPI4TXIF:1;
    unsigned RTCCIF:1;
    unsigned FCEIF:1;
    unsigned PREIF:1;
    unsigned SQI1IF:1;
    unsigned U4EIF:1;
    unsigned U4RXIF:1;
    unsigned U4TXIF:1;
    unsigned I2C4BIF:1;
    unsigned I2C4SIF:1;
    unsigned I2C4MIF:1;
    unsigned SPI5EIF:1;
    unsigned SPI5RXIF:1;
    unsigned SPI5TXIF:1;
    unsigned U5EIF:1;
    unsigned U5RXIF:1;
    unsigned U5TXIF:1;
    unsigned I2C5BIF:1;
    unsigned I2C5SIF:1;
    unsigned I2C5MIF:1;
    unsigned SPI6IF:1;
    unsigned SPI6RXIF:1;
    unsigned SPI6TX:1;
    unsigned U6EIF:1;
    unsigned U6RXIF:1;
    unsigned U6TXIF:1;
  };
  struct {
    unsigned w:32;
  };
} __IFS5bits_t;
extern volatile __IFS5bits_t IFS5bits __asm__ ("IFS5") __attribute__((section("sfrs")));
extern volatile unsigned int        IFS5CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IFS5SET __attribute__((section("sfrs")));
extern volatile unsigned int        IFS5INV __attribute__((section("sfrs")));
extern volatile unsigned int        IEC0 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CTIE:1;
    unsigned CS0IE:1;
    unsigned CS1IE:1;
    unsigned INT0IE:1;
    unsigned T1IE:1;
    unsigned IC1EIE:1;
    unsigned IC1IE:1;
    unsigned OC1IE:1;
    unsigned INT1IE:1;
    unsigned T2IE:1;
    unsigned IC2EIE:1;
    unsigned IC2IE:1;
    unsigned OC2IE:1;
    unsigned INT2IE:1;
    unsigned T3IE:1;
    unsigned IC3EIE:1;
    unsigned IC3IE:1;
    unsigned OC3IE:1;
    unsigned INT3IE:1;
    unsigned T4IE:1;
    unsigned IC4EIE:1;
    unsigned IC4IE:1;
    unsigned OC4IE:1;
    unsigned INT4IE:1;
    unsigned T5IE:1;
    unsigned IC5EIE:1;
    unsigned IC5IE:1;
    unsigned OC5IE:1;
    unsigned T6IE:1;
    unsigned IC6EIE:1;
    unsigned IC6IE:1;
    unsigned OC6IE:1;
  };
  struct {
    unsigned w:32;
  };
} __IEC0bits_t;
extern volatile __IEC0bits_t IEC0bits __asm__ ("IEC0") __attribute__((section("sfrs")));
extern volatile unsigned int        IEC0CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IEC0SET __attribute__((section("sfrs")));
extern volatile unsigned int        IEC0INV __attribute__((section("sfrs")));
extern volatile unsigned int        IEC1 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned T7IE:1;
    unsigned IC7EIE:1;
    unsigned IC7IE:1;
    unsigned OC7IE:1;
    unsigned T8IE:1;
    unsigned IC8EIE:1;
    unsigned IC8IE:1;
    unsigned OC8IE:1;
    unsigned T9IE:1;
    unsigned IC9EIE:1;
    unsigned IC9IE:1;
    unsigned OC9IE:1;
    unsigned AD1IE:1;
    unsigned :1;
    unsigned AD1DC1IE:1;
    unsigned AD1DC2IE:1;
    unsigned AD1DC3IE:1;
    unsigned AD1DC4IE:1;
    unsigned AD1DC5IE:1;
    unsigned AD1DC6IE:1;
    unsigned AD1DF1IE:1;
    unsigned AD1DF2IE:1;
    unsigned AD1DF3IE:1;
    unsigned AD1DF4IE:1;
    unsigned AD1DF5IE:1;
    unsigned AD1DF6IE:1;
    unsigned :1;
    unsigned AD1D0IE:1;
    unsigned AD1D1IE:1;
    unsigned AD1D2IE:1;
    unsigned AD1D3IE:1;
    unsigned AD1D4IE:1;
  };
  struct {
    unsigned w:32;
  };
} __IEC1bits_t;
extern volatile __IEC1bits_t IEC1bits __asm__ ("IEC1") __attribute__((section("sfrs")));
extern volatile unsigned int        IEC1CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IEC1SET __attribute__((section("sfrs")));
extern volatile unsigned int        IEC1INV __attribute__((section("sfrs")));
extern volatile unsigned int        IEC2 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned AD1D5IE:1;
    unsigned AD1D6IE:1;
    unsigned AD1D7IE:1;
    unsigned AD1D8IE:1;
    unsigned AD1D9IE:1;
    unsigned AD1D10IE:1;
    unsigned AD1D11IE:1;
    unsigned AD1D12IE:1;
    unsigned AD1D13IE:1;
    unsigned AD1D14IE:1;
    unsigned AD1D15IE:1;
    unsigned AD1D16IE:1;
    unsigned AD1D17IE:1;
    unsigned AD1D18IE:1;
    unsigned AD1D19IE:1;
    unsigned AD1D20IE:1;
    unsigned AD1D21IE:1;
    unsigned AD1D22IE:1;
    unsigned AD1D23IE:1;
    unsigned AD1D24IE:1;
    unsigned AD1D25IE:1;
    unsigned AD1D26IE:1;
    unsigned AD1D27IE:1;
    unsigned AD1D28IE:1;
    unsigned AD1D29IE:1;
    unsigned AD1D30IE:1;
    unsigned AD1D31IE:1;
    unsigned AD1D32IE:1;
    unsigned AD1D33IE:1;
    unsigned AD1D34IE:1;
    unsigned AD1D35IE:1;
    unsigned AD1D36IE:1;
  };
  struct {
    unsigned w:32;
  };
} __IEC2bits_t;
extern volatile __IEC2bits_t IEC2bits __asm__ ("IEC2") __attribute__((section("sfrs")));
extern volatile unsigned int        IEC2CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IEC2SET __attribute__((section("sfrs")));
extern volatile unsigned int        IEC2INV __attribute__((section("sfrs")));
extern volatile unsigned int        IEC3 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned AD1D37IE:1;
    unsigned AD1D38IE:1;
    unsigned AD1D39IE:1;
    unsigned AD1D40IE:1;
    unsigned AD1D41IE:1;
    unsigned AD1D42IE:1;
    unsigned AD1D43IE:1;
    unsigned AD1D44IE:1;
    unsigned CPCIE:1;
    unsigned CFDCIE:1;
    unsigned SBIE:1;
    unsigned CRPTIE:1;
    unsigned :1;
    unsigned SPI1EIE:1;
    unsigned SPI1RXIE:1;
    unsigned SPI1TXIE:1;
    unsigned U1EIE:1;
    unsigned U1RXIE:1;
    unsigned U1TXIE:1;
    unsigned I2C1BIE:1;
    unsigned I2C1SIE:1;
    unsigned I2C1MIE:1;
    unsigned CNAIE:1;
    unsigned CNBIE:1;
    unsigned CNCIE:1;
    unsigned CNDIE:1;
    unsigned CNEIE:1;
    unsigned CNFIE:1;
    unsigned CNGIE:1;
    unsigned CNHIE:1;
    unsigned CNJIE:1;
    unsigned CNKIE:1;
  };
  struct {
    unsigned w:32;
  };
} __IEC3bits_t;
extern volatile __IEC3bits_t IEC3bits __asm__ ("IEC3") __attribute__((section("sfrs")));
extern volatile unsigned int        IEC3CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IEC3SET __attribute__((section("sfrs")));
extern volatile unsigned int        IEC3INV __attribute__((section("sfrs")));
extern volatile unsigned int        IEC4 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned PMPIE:1;
    unsigned PMPEIE:1;
    unsigned CMP1IE:1;
    unsigned CMP2IE:1;
    unsigned USBIE:1;
    unsigned USBDMAIE:1;
    unsigned DMA0IE:1;
    unsigned DMA1IE:1;
    unsigned DMA2IE:1;
    unsigned DMA3IE:1;
    unsigned DMA4IE:1;
    unsigned DMA5IE:1;
    unsigned DMA6IE:1;
    unsigned DMA7IE:1;
    unsigned SPI2EIE:1;
    unsigned SPI2RXIE:1;
    unsigned SPI2TXIE:1;
    unsigned U2EIE:1;
    unsigned U2RXIE:1;
    unsigned U2TXIE:1;
    unsigned I2C2BIE:1;
    unsigned I2C2SIE:1;
    unsigned I2C2MIE:1;
    unsigned CAN1IE:1;
    unsigned CAN2IE:1;
    unsigned ETHIE:1;
    unsigned SPI3EIE:1;
    unsigned SPI3RXIE:1;
    unsigned SPI3TXIE:1;
    unsigned U3EIE:1;
    unsigned U3RXIE:1;
    unsigned U3TXIE:1;
  };
  struct {
    unsigned w:32;
  };
} __IEC4bits_t;
extern volatile __IEC4bits_t IEC4bits __asm__ ("IEC4") __attribute__((section("sfrs")));
extern volatile unsigned int        IEC4CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IEC4SET __attribute__((section("sfrs")));
extern volatile unsigned int        IEC4INV __attribute__((section("sfrs")));
extern volatile unsigned int        IEC5 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned I2C3BIE:1;
    unsigned I2C3SIE:1;
    unsigned I2C3MIE:1;
    unsigned SPI4EIE:1;
    unsigned SPI4RXIE:1;
    unsigned SPI4TXIE:1;
    unsigned RTCCIE:1;
    unsigned FCEIE:1;
    unsigned PREIE:1;
    unsigned SQI1IE:1;
    unsigned U4EIE:1;
    unsigned U4RXIE:1;
    unsigned U4TXIE:1;
    unsigned I2C4BIE:1;
    unsigned I2C4SIE:1;
    unsigned I2C4MIE:1;
    unsigned SPI5EIE:1;
    unsigned SPI5RXIE:1;
    unsigned SPI5TXIE:1;
    unsigned U5EIE:1;
    unsigned U5RXIE:1;
    unsigned U5TXIE:1;
    unsigned I2C5BIE:1;
    unsigned I2C5SIE:1;
    unsigned I2C5MIE:1;
    unsigned SPI6IE:1;
    unsigned SPI6RXIE:1;
    unsigned SPI6TXIE:1;
    unsigned U6EIE:1;
    unsigned U6RXIE:1;
    unsigned U6TXIE:1;
  };
  struct {
    unsigned w:32;
  };
} __IEC5bits_t;
extern volatile __IEC5bits_t IEC5bits __asm__ ("IEC5") __attribute__((section("sfrs")));
extern volatile unsigned int        IEC5CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IEC5SET __attribute__((section("sfrs")));
extern volatile unsigned int        IEC5INV __attribute__((section("sfrs")));
extern volatile unsigned int        IPC0 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CTIS:2;
    unsigned CTIP:3;
    unsigned :3;
    unsigned CS0IS:2;
    unsigned CS0IP:3;
    unsigned :3;
    unsigned CS1IS:2;
    unsigned CS1IP:3;
    unsigned :3;
    unsigned INT0IS:2;
    unsigned INT0IP:3;
  };
  struct {
    unsigned w:32;
  };
} __IPC0bits_t;
extern volatile __IPC0bits_t IPC0bits __asm__ ("IPC0") __attribute__((section("sfrs")));
extern volatile unsigned int        IPC0CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IPC0SET __attribute__((section("sfrs")));
extern volatile unsigned int        IPC0INV __attribute__((section("sfrs")));
extern volatile unsigned int        IPC1 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned T1IS:2;
    unsigned T1IP:3;
    unsigned :3;
    unsigned IC1EIS:2;
    unsigned IC1EIP:3;
    unsigned :3;
    unsigned IC1IS:2;
    unsigned IC1IP:3;
    unsigned :3;
    unsigned OC1IS:2;
    unsigned OC1IP:3;
  };
  struct {
    unsigned w:32;
  };
} __IPC1bits_t;
extern volatile __IPC1bits_t IPC1bits __asm__ ("IPC1") __attribute__((section("sfrs")));
extern volatile unsigned int        IPC1CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IPC1SET __attribute__((section("sfrs")));
extern volatile unsigned int        IPC1INV __attribute__((section("sfrs")));
extern volatile unsigned int        IPC2 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned INT1IS:2;
    unsigned INT1IP:3;
    unsigned :3;
    unsigned T2IS:2;
    unsigned T2IP:3;
    unsigned :3;
    unsigned IC2EIS:2;
    unsigned IC2EIP:3;
    unsigned :3;
    unsigned IC2IS:2;
    unsigned IC2IP:3;
  };
  struct {
    unsigned w:32;
  };
} __IPC2bits_t;
extern volatile __IPC2bits_t IPC2bits __asm__ ("IPC2") __attribute__((section("sfrs")));
extern volatile unsigned int        IPC2CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IPC2SET __attribute__((section("sfrs")));
extern volatile unsigned int        IPC2INV __attribute__((section("sfrs")));
extern volatile unsigned int        IPC3 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned OC2IS:2;
    unsigned OC2IP:3;
    unsigned :3;
    unsigned INT2IS:2;
    unsigned INT2IP:3;
    unsigned :3;
    unsigned T3IS:2;
    unsigned T3IP:3;
    unsigned :3;
    unsigned IC3EIS:2;
    unsigned IC3EIP:3;
  };
  struct {
    unsigned w:32;
  };
} __IPC3bits_t;
extern volatile __IPC3bits_t IPC3bits __asm__ ("IPC3") __attribute__((section("sfrs")));
extern volatile unsigned int        IPC3CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IPC3SET __attribute__((section("sfrs")));
extern volatile unsigned int        IPC3INV __attribute__((section("sfrs")));
extern volatile unsigned int        IPC4 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned IC3IS:2;
    unsigned IC3IP:3;
    unsigned :3;
    unsigned OC3IS:2;
    unsigned OC3IP:3;
    unsigned :3;
    unsigned INT3IS:2;
    unsigned INT3IP:3;
    unsigned :3;
    unsigned T4IS:2;
    unsigned T4IP:3;
  };
  struct {
    unsigned w:32;
  };
} __IPC4bits_t;
extern volatile __IPC4bits_t IPC4bits __asm__ ("IPC4") __attribute__((section("sfrs")));
extern volatile unsigned int        IPC4CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IPC4SET __attribute__((section("sfrs")));
extern volatile unsigned int        IPC4INV __attribute__((section("sfrs")));
extern volatile unsigned int        IPC5 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned IC4EIS:2;
    unsigned IC4EIP:3;
    unsigned :3;
    unsigned IC4IS:2;
    unsigned IC4IP:3;
    unsigned :3;
    unsigned OC4IS:2;
    unsigned OC4IP:3;
    unsigned :3;
    unsigned INT4IS:2;
    unsigned INT4IP:3;
  };
  struct {
    unsigned w:32;
  };
} __IPC5bits_t;
extern volatile __IPC5bits_t IPC5bits __asm__ ("IPC5") __attribute__((section("sfrs")));
extern volatile unsigned int        IPC5CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IPC5SET __attribute__((section("sfrs")));
extern volatile unsigned int        IPC5INV __attribute__((section("sfrs")));
extern volatile unsigned int        IPC6 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned T5IS:2;
    unsigned T5IP:3;
    unsigned :3;
    unsigned IC5EIS:2;
    unsigned IC5EIP:3;
    unsigned :3;
    unsigned IC5IS:2;
    unsigned IC5IP:3;
    unsigned :3;
    unsigned OC5IS:2;
    unsigned OC5IP:3;
  };
  struct {
    unsigned w:32;
  };
} __IPC6bits_t;
extern volatile __IPC6bits_t IPC6bits __asm__ ("IPC6") __attribute__((section("sfrs")));
extern volatile unsigned int        IPC6CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IPC6SET __attribute__((section("sfrs")));
extern volatile unsigned int        IPC6INV __attribute__((section("sfrs")));
extern volatile unsigned int        IPC7 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned T6IS:2;
    unsigned T6IP:3;
    unsigned :3;
    unsigned IC6EIS:2;
    unsigned IC6EIP:3;
    unsigned :3;
    unsigned IC6IS:2;
    unsigned IC6IP:3;
    unsigned :3;
    unsigned OC6IS:2;
    unsigned OC6IP:3;
  };
  struct {
    unsigned w:32;
  };
} __IPC7bits_t;
extern volatile __IPC7bits_t IPC7bits __asm__ ("IPC7") __attribute__((section("sfrs")));
extern volatile unsigned int        IPC7CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IPC7SET __attribute__((section("sfrs")));
extern volatile unsigned int        IPC7INV __attribute__((section("sfrs")));
extern volatile unsigned int        IPC8 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned T7IS:2;
    unsigned T7IP:3;
    unsigned :3;
    unsigned IC7EIS:2;
    unsigned IC7EIP:3;
    unsigned :3;
    unsigned IC7IS:2;
    unsigned IC7IP:3;
    unsigned :3;
    unsigned OC7IS:2;
    unsigned OC7IP:3;
  };
  struct {
    unsigned w:32;
  };
} __IPC8bits_t;
extern volatile __IPC8bits_t IPC8bits __asm__ ("IPC8") __attribute__((section("sfrs")));
extern volatile unsigned int        IPC8CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IPC8SET __attribute__((section("sfrs")));
extern volatile unsigned int        IPC8INV __attribute__((section("sfrs")));
extern volatile unsigned int        IPC9 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned T8IS:2;
    unsigned T8IP:3;
    unsigned :3;
    unsigned IC8EIS:2;
    unsigned IC8EIP:3;
    unsigned :3;
    unsigned IC8IS:2;
    unsigned IC8IP:3;
    unsigned :3;
    unsigned OC8IS:2;
    unsigned OC8IP:3;
  };
  struct {
    unsigned w:32;
  };
} __IPC9bits_t;
extern volatile __IPC9bits_t IPC9bits __asm__ ("IPC9") __attribute__((section("sfrs")));
extern volatile unsigned int        IPC9CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IPC9SET __attribute__((section("sfrs")));
extern volatile unsigned int        IPC9INV __attribute__((section("sfrs")));
extern volatile unsigned int        IPC10 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned T9IS:2;
    unsigned T9IP:3;
    unsigned :3;
    unsigned IC9EIS:2;
    unsigned IC9EIP:3;
    unsigned :3;
    unsigned IC9IS:2;
    unsigned IC9IP:3;
    unsigned :3;
    unsigned OC9IS:2;
    unsigned OC9IP:3;
  };
  struct {
    unsigned w:32;
  };
} __IPC10bits_t;
extern volatile __IPC10bits_t IPC10bits __asm__ ("IPC10") __attribute__((section("sfrs")));
extern volatile unsigned int        IPC10CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IPC10SET __attribute__((section("sfrs")));
extern volatile unsigned int        IPC10INV __attribute__((section("sfrs")));
extern volatile unsigned int        IPC11 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned AD1IS:2;
    unsigned AD1IP:3;
    unsigned :11;
    unsigned AD1DC1IS:2;
    unsigned AD1DC1IP:3;
    unsigned :3;
    unsigned AD1DC2IS:2;
    unsigned AD1DC2IP:3;
  };
  struct {
    unsigned w:32;
  };
} __IPC11bits_t;
extern volatile __IPC11bits_t IPC11bits __asm__ ("IPC11") __attribute__((section("sfrs")));
extern volatile unsigned int        IPC11CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IPC11SET __attribute__((section("sfrs")));
extern volatile unsigned int        IPC11INV __attribute__((section("sfrs")));
extern volatile unsigned int        IPC12 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned AD1DC3IS:2;
    unsigned AD1DC3IP:3;
    unsigned :3;
    unsigned AD1DC4IS:2;
    unsigned AD1DC4IP:3;
    unsigned :3;
    unsigned AD1DC5IS:2;
    unsigned AD1DC5IP:3;
    unsigned :3;
    unsigned AD1DC6IS:2;
    unsigned AD1DC6IP:3;
  };
  struct {
    unsigned w:32;
  };
} __IPC12bits_t;
extern volatile __IPC12bits_t IPC12bits __asm__ ("IPC12") __attribute__((section("sfrs")));
extern volatile unsigned int        IPC12CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IPC12SET __attribute__((section("sfrs")));
extern volatile unsigned int        IPC12INV __attribute__((section("sfrs")));
extern volatile unsigned int        IPC13 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned AD1DF1IS:2;
    unsigned AD1DF1IP:3;
    unsigned :3;
    unsigned AD1DF2IS:2;
    unsigned AD1DF2IP:3;
    unsigned :3;
    unsigned AD1DF3IS:2;
    unsigned AD1DF3IP:3;
    unsigned :3;
    unsigned AD1DF4IS:2;
    unsigned AD1DF4IP:3;
  };
  struct {
    unsigned w:32;
  };
} __IPC13bits_t;
extern volatile __IPC13bits_t IPC13bits __asm__ ("IPC13") __attribute__((section("sfrs")));
extern volatile unsigned int        IPC13CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IPC13SET __attribute__((section("sfrs")));
extern volatile unsigned int        IPC13INV __attribute__((section("sfrs")));
extern volatile unsigned int        IPC14 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned AD1DF5IS:2;
    unsigned AD1DF5IP:3;
    unsigned :3;
    unsigned AD1DF6IS:2;
    unsigned AD1DF6IP:3;
    unsigned :11;
    unsigned AD1D0IS:2;
    unsigned AD1D0IP:3;
  };
  struct {
    unsigned w:32;
  };
} __IPC14bits_t;
extern volatile __IPC14bits_t IPC14bits __asm__ ("IPC14") __attribute__((section("sfrs")));
extern volatile unsigned int        IPC14CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IPC14SET __attribute__((section("sfrs")));
extern volatile unsigned int        IPC14INV __attribute__((section("sfrs")));
extern volatile unsigned int        IPC15 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned AD1D1IS:2;
    unsigned AD1D1IP:3;
    unsigned :3;
    unsigned AD1D2IS:2;
    unsigned AD1D2IP:3;
    unsigned :3;
    unsigned AD1D3IS:2;
    unsigned AD1D3IP:3;
    unsigned :3;
    unsigned AD1D4IS:2;
    unsigned AD1D4IP:3;
  };
  struct {
    unsigned w:32;
  };
} __IPC15bits_t;
extern volatile __IPC15bits_t IPC15bits __asm__ ("IPC15") __attribute__((section("sfrs")));
extern volatile unsigned int        IPC15CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IPC15SET __attribute__((section("sfrs")));
extern volatile unsigned int        IPC15INV __attribute__((section("sfrs")));
extern volatile unsigned int        IPC16 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned AD1D5IS:2;
    unsigned AD1D5IP:3;
    unsigned :3;
    unsigned AD1D6IS:2;
    unsigned AD1D6IP:3;
    unsigned :3;
    unsigned AD1D7IS:2;
    unsigned AD1D7IP:3;
    unsigned :3;
    unsigned AD1D8IS:2;
    unsigned AD1D8IP:3;
  };
  struct {
    unsigned w:32;
  };
} __IPC16bits_t;
extern volatile __IPC16bits_t IPC16bits __asm__ ("IPC16") __attribute__((section("sfrs")));
extern volatile unsigned int        IPC16CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IPC16SET __attribute__((section("sfrs")));
extern volatile unsigned int        IPC16INV __attribute__((section("sfrs")));
extern volatile unsigned int        IPC17 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned AD1D9IS:2;
    unsigned AD1D9IP:3;
    unsigned :3;
    unsigned AD1D10IS:2;
    unsigned AD1D10IP:3;
    unsigned :3;
    unsigned AD1D11IS:2;
    unsigned AD1D11IP:3;
    unsigned :3;
    unsigned AD1D12IS:2;
    unsigned AD1D12IP:3;
  };
  struct {
    unsigned w:32;
  };
} __IPC17bits_t;
extern volatile __IPC17bits_t IPC17bits __asm__ ("IPC17") __attribute__((section("sfrs")));
extern volatile unsigned int        IPC17CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IPC17SET __attribute__((section("sfrs")));
extern volatile unsigned int        IPC17INV __attribute__((section("sfrs")));
extern volatile unsigned int        IPC18 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned AD1D13IS:2;
    unsigned AD1D13IP:3;
    unsigned :3;
    unsigned AD1D14IS:2;
    unsigned AD1D14IP:3;
    unsigned :3;
    unsigned AD1D15IS:2;
    unsigned AD1D15IP:3;
    unsigned :3;
    unsigned AD1D16IS:2;
    unsigned AD1D16IP:3;
  };
  struct {
    unsigned w:32;
  };
} __IPC18bits_t;
extern volatile __IPC18bits_t IPC18bits __asm__ ("IPC18") __attribute__((section("sfrs")));
extern volatile unsigned int        IPC18CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IPC18SET __attribute__((section("sfrs")));
extern volatile unsigned int        IPC18INV __attribute__((section("sfrs")));
extern volatile unsigned int        IPC19 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned AD1D17IS:2;
    unsigned AD1D17IP:3;
    unsigned :3;
    unsigned AD1D18IS:2;
    unsigned AD1D18IP:3;
    unsigned :3;
    unsigned AD1D19IS:2;
    unsigned AD1D19IP:3;
    unsigned :3;
    unsigned AD1D20IS:2;
    unsigned AD1D20IP:3;
  };
  struct {
    unsigned w:32;
  };
} __IPC19bits_t;
extern volatile __IPC19bits_t IPC19bits __asm__ ("IPC19") __attribute__((section("sfrs")));
extern volatile unsigned int        IPC19CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IPC19SET __attribute__((section("sfrs")));
extern volatile unsigned int        IPC19INV __attribute__((section("sfrs")));
extern volatile unsigned int        IPC20 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned AD1D21IS:2;
    unsigned AD1D21IP:3;
    unsigned :3;
    unsigned AD1D22IS:2;
    unsigned AD1D22IP:3;
    unsigned :3;
    unsigned AD1D23IS:2;
    unsigned AD1D23IP:3;
    unsigned :3;
    unsigned AD1D24IS:2;
    unsigned AD1D24IP:3;
  };
  struct {
    unsigned w:32;
  };
} __IPC20bits_t;
extern volatile __IPC20bits_t IPC20bits __asm__ ("IPC20") __attribute__((section("sfrs")));
extern volatile unsigned int        IPC20CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IPC20SET __attribute__((section("sfrs")));
extern volatile unsigned int        IPC20INV __attribute__((section("sfrs")));
extern volatile unsigned int        IPC21 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned AD1D25IS:2;
    unsigned AD1D25IP:3;
    unsigned :3;
    unsigned AD1D26IS:2;
    unsigned AD1D26IP:3;
    unsigned :3;
    unsigned AD1D27IS:2;
    unsigned AD1D27IP:3;
    unsigned :3;
    unsigned AD1D28IS:2;
    unsigned AD1D28IP:3;
  };
  struct {
    unsigned w:32;
  };
} __IPC21bits_t;
extern volatile __IPC21bits_t IPC21bits __asm__ ("IPC21") __attribute__((section("sfrs")));
extern volatile unsigned int        IPC21CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IPC21SET __attribute__((section("sfrs")));
extern volatile unsigned int        IPC21INV __attribute__((section("sfrs")));
extern volatile unsigned int        IPC22 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned AD1D29IS:2;
    unsigned AD1D29IP:3;
    unsigned :3;
    unsigned AD1D30IS:2;
    unsigned AD1D30IP:3;
    unsigned :3;
    unsigned AD1D31IS:2;
    unsigned AD1D31IP:3;
    unsigned :3;
    unsigned AD1D32IS:2;
    unsigned AD1D32IP:3;
  };
  struct {
    unsigned w:32;
  };
} __IPC22bits_t;
extern volatile __IPC22bits_t IPC22bits __asm__ ("IPC22") __attribute__((section("sfrs")));
extern volatile unsigned int        IPC22CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IPC22SET __attribute__((section("sfrs")));
extern volatile unsigned int        IPC22INV __attribute__((section("sfrs")));
extern volatile unsigned int        IPC23 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned AD1D33IS:2;
    unsigned AD1D33IP:3;
    unsigned :3;
    unsigned AD1D34IS:2;
    unsigned AD1D34IP:3;
    unsigned :3;
    unsigned AD1D35IS:2;
    unsigned AD1D35IP:3;
    unsigned :3;
    unsigned AD1D36IS:2;
    unsigned AD1D36IP:3;
  };
  struct {
    unsigned w:32;
  };
} __IPC23bits_t;
extern volatile __IPC23bits_t IPC23bits __asm__ ("IPC23") __attribute__((section("sfrs")));
extern volatile unsigned int        IPC23CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IPC23SET __attribute__((section("sfrs")));
extern volatile unsigned int        IPC23INV __attribute__((section("sfrs")));
extern volatile unsigned int        IPC24 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned AD1D37IS:2;
    unsigned AD1D37IP:3;
    unsigned :3;
    unsigned AD1D38IS:2;
    unsigned AD1D38IP:3;
    unsigned :3;
    unsigned AD1D39IS:2;
    unsigned AD1D39IP:3;
    unsigned :3;
    unsigned AD1D40IS:2;
    unsigned AD1D40IP:3;
  };
  struct {
    unsigned w:32;
  };
} __IPC24bits_t;
extern volatile __IPC24bits_t IPC24bits __asm__ ("IPC24") __attribute__((section("sfrs")));
extern volatile unsigned int        IPC24CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IPC24SET __attribute__((section("sfrs")));
extern volatile unsigned int        IPC24INV __attribute__((section("sfrs")));
extern volatile unsigned int        IPC25 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned AD1D41IS:2;
    unsigned AD1D41IP:3;
    unsigned :3;
    unsigned AD1D42IS:2;
    unsigned AD1D42IP:3;
    unsigned :3;
    unsigned AD1D43IS:2;
    unsigned AD1D43IP:3;
    unsigned :3;
    unsigned AD1D44IS:2;
    unsigned AD1D44IP:3;
  };
  struct {
    unsigned w:32;
  };
} __IPC25bits_t;
extern volatile __IPC25bits_t IPC25bits __asm__ ("IPC25") __attribute__((section("sfrs")));
extern volatile unsigned int        IPC25CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IPC25SET __attribute__((section("sfrs")));
extern volatile unsigned int        IPC25INV __attribute__((section("sfrs")));
extern volatile unsigned int        IPC26 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CPCIS:2;
    unsigned CPCIP:3;
    unsigned :3;
    unsigned CFDCIS:2;
    unsigned CFDCIP:3;
    unsigned :3;
    unsigned SBIS:2;
    unsigned SBIP:3;
    unsigned :3;
    unsigned CRPTIS:2;
    unsigned CRPTIP:3;
  };
  struct {
    unsigned w:32;
  };
} __IPC26bits_t;
extern volatile __IPC26bits_t IPC26bits __asm__ ("IPC26") __attribute__((section("sfrs")));
extern volatile unsigned int        IPC26CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IPC26SET __attribute__((section("sfrs")));
extern volatile unsigned int        IPC26INV __attribute__((section("sfrs")));
extern volatile unsigned int        IPC27 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned :8;
    unsigned SPI1EIS:2;
    unsigned SPI1EIP:3;
    unsigned :3;
    unsigned SPI1RXIS:2;
    unsigned SPI1RXIP:3;
    unsigned :3;
    unsigned SPI1TXIS:2;
    unsigned SPI1TXIP:3;
  };
  struct {
    unsigned w:32;
  };
} __IPC27bits_t;
extern volatile __IPC27bits_t IPC27bits __asm__ ("IPC27") __attribute__((section("sfrs")));
extern volatile unsigned int        IPC27CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IPC27SET __attribute__((section("sfrs")));
extern volatile unsigned int        IPC27INV __attribute__((section("sfrs")));
extern volatile unsigned int        IPC28 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned U1EIS:2;
    unsigned U1EIP:3;
    unsigned :3;
    unsigned U1RXIS:2;
    unsigned U1RXIP:3;
    unsigned :3;
    unsigned U1TXIS:2;
    unsigned U1TXIP:3;
    unsigned :3;
    unsigned I2C1BIS:2;
    unsigned I2C1BIP:3;
  };
  struct {
    unsigned w:32;
  };
} __IPC28bits_t;
extern volatile __IPC28bits_t IPC28bits __asm__ ("IPC28") __attribute__((section("sfrs")));
extern volatile unsigned int        IPC28CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IPC28SET __attribute__((section("sfrs")));
extern volatile unsigned int        IPC28INV __attribute__((section("sfrs")));
extern volatile unsigned int        IPC29 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned I2C1SIS:2;
    unsigned I2C1SIP:3;
    unsigned :3;
    unsigned I2C1MIS:2;
    unsigned I2C1MIP:3;
    unsigned :3;
    unsigned CNAIS:2;
    unsigned CNAIP:3;
    unsigned :3;
    unsigned CNBIS:2;
    unsigned CNBIP:3;
  };
  struct {
    unsigned w:32;
  };
} __IPC29bits_t;
extern volatile __IPC29bits_t IPC29bits __asm__ ("IPC29") __attribute__((section("sfrs")));
extern volatile unsigned int        IPC29CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IPC29SET __attribute__((section("sfrs")));
extern volatile unsigned int        IPC29INV __attribute__((section("sfrs")));
extern volatile unsigned int        IPC30 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CNCIS:2;
    unsigned CNCIP:3;
    unsigned :3;
    unsigned CNDIS:2;
    unsigned CNDIP:3;
    unsigned :3;
    unsigned CNEIS:2;
    unsigned CNEIP:3;
    unsigned :3;
    unsigned CNFIS:2;
    unsigned CNFIP:3;
  };
  struct {
    unsigned w:32;
  };
} __IPC30bits_t;
extern volatile __IPC30bits_t IPC30bits __asm__ ("IPC30") __attribute__((section("sfrs")));
extern volatile unsigned int        IPC30CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IPC30SET __attribute__((section("sfrs")));
extern volatile unsigned int        IPC30INV __attribute__((section("sfrs")));
extern volatile unsigned int        IPC31 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CNGIS:2;
    unsigned CNGIP:3;
    unsigned :3;
    unsigned CNHIS:2;
    unsigned CNHIP:3;
    unsigned :3;
    unsigned CNJIS:2;
    unsigned CNJIP:3;
    unsigned :3;
    unsigned CNKIS:2;
    unsigned CNKIP:3;
  };
  struct {
    unsigned w:32;
  };
} __IPC31bits_t;
extern volatile __IPC31bits_t IPC31bits __asm__ ("IPC31") __attribute__((section("sfrs")));
extern volatile unsigned int        IPC31CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IPC31SET __attribute__((section("sfrs")));
extern volatile unsigned int        IPC31INV __attribute__((section("sfrs")));
extern volatile unsigned int        IPC32 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned PMPIS:2;
    unsigned PMPIP:3;
    unsigned :3;
    unsigned PMPEIS:2;
    unsigned PMPEIP:3;
    unsigned :3;
    unsigned CMP1IS:2;
    unsigned CMP1IP:3;
    unsigned :3;
    unsigned CMP2IS:2;
    unsigned CMP2IP:3;
  };
  struct {
    unsigned w:32;
  };
} __IPC32bits_t;
extern volatile __IPC32bits_t IPC32bits __asm__ ("IPC32") __attribute__((section("sfrs")));
extern volatile unsigned int        IPC32CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IPC32SET __attribute__((section("sfrs")));
extern volatile unsigned int        IPC32INV __attribute__((section("sfrs")));
extern volatile unsigned int        IPC33 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned USBIS:2;
    unsigned USBIP:3;
    unsigned :3;
    unsigned USBDMAIS:2;
    unsigned USBDMAIP:3;
    unsigned :3;
    unsigned DMA0IS:2;
    unsigned DMA0IP:3;
    unsigned :3;
    unsigned DMA1IS:2;
    unsigned DMA1IP:3;
  };
  struct {
    unsigned w:32;
  };
} __IPC33bits_t;
extern volatile __IPC33bits_t IPC33bits __asm__ ("IPC33") __attribute__((section("sfrs")));
extern volatile unsigned int        IPC33CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IPC33SET __attribute__((section("sfrs")));
extern volatile unsigned int        IPC33INV __attribute__((section("sfrs")));
extern volatile unsigned int        IPC34 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned DMA2IS:2;
    unsigned DMA2IP:3;
    unsigned :3;
    unsigned DMA3IS:2;
    unsigned DMA3IP:3;
    unsigned :3;
    unsigned DMA4IS:2;
    unsigned DMA4IP:3;
    unsigned :3;
    unsigned DMA5IS:2;
    unsigned DMA5IP:3;
  };
  struct {
    unsigned w:32;
  };
} __IPC34bits_t;
extern volatile __IPC34bits_t IPC34bits __asm__ ("IPC34") __attribute__((section("sfrs")));
extern volatile unsigned int        IPC34CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IPC34SET __attribute__((section("sfrs")));
extern volatile unsigned int        IPC34INV __attribute__((section("sfrs")));
extern volatile unsigned int        IPC35 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned DMA6IS:2;
    unsigned DMA6IP:3;
    unsigned :3;
    unsigned DMA7IS:2;
    unsigned DMA7IP:3;
    unsigned :3;
    unsigned SPI2EIS:2;
    unsigned SPI2EIP:3;
    unsigned :3;
    unsigned SPI2RXIS:2;
    unsigned SPI2RXIP:3;
  };
  struct {
    unsigned w:32;
  };
} __IPC35bits_t;
extern volatile __IPC35bits_t IPC35bits __asm__ ("IPC35") __attribute__((section("sfrs")));
extern volatile unsigned int        IPC35CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IPC35SET __attribute__((section("sfrs")));
extern volatile unsigned int        IPC35INV __attribute__((section("sfrs")));
extern volatile unsigned int        IPC36 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned SPI2TXIS:2;
    unsigned SPI2TXIP:3;
    unsigned :3;
    unsigned U2EIS:2;
    unsigned U2EIP:3;
    unsigned :3;
    unsigned U2RXIS:2;
    unsigned U2RXIP:3;
    unsigned :3;
    unsigned U2TXIS:2;
    unsigned U2TXIP:3;
  };
  struct {
    unsigned w:32;
  };
} __IPC36bits_t;
extern volatile __IPC36bits_t IPC36bits __asm__ ("IPC36") __attribute__((section("sfrs")));
extern volatile unsigned int        IPC36CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IPC36SET __attribute__((section("sfrs")));
extern volatile unsigned int        IPC36INV __attribute__((section("sfrs")));
extern volatile unsigned int        IPC37 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned I2C2BIS:2;
    unsigned I2C2BIP:3;
    unsigned :3;
    unsigned I2C2SIS:2;
    unsigned I2C2SIP:3;
    unsigned :3;
    unsigned I2C2MIS:2;
    unsigned I2C2MIP:3;
    unsigned :3;
    unsigned CAN1IS:2;
    unsigned CAN1IP:3;
  };
  struct {
    unsigned w:32;
  };
} __IPC37bits_t;
extern volatile __IPC37bits_t IPC37bits __asm__ ("IPC37") __attribute__((section("sfrs")));
extern volatile unsigned int        IPC37CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IPC37SET __attribute__((section("sfrs")));
extern volatile unsigned int        IPC37INV __attribute__((section("sfrs")));
extern volatile unsigned int        IPC38 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CAN2IS:2;
    unsigned CAN2IP:3;
    unsigned :3;
    unsigned ETHIS:2;
    unsigned ETHIP:3;
    unsigned :3;
    unsigned SPI3EIS:2;
    unsigned SPI3EIP:3;
    unsigned :3;
    unsigned SPI3RXIS:2;
    unsigned SPI3RXIP:3;
  };
  struct {
    unsigned w:32;
  };
} __IPC38bits_t;
extern volatile __IPC38bits_t IPC38bits __asm__ ("IPC38") __attribute__((section("sfrs")));
extern volatile unsigned int        IPC38CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IPC38SET __attribute__((section("sfrs")));
extern volatile unsigned int        IPC38INV __attribute__((section("sfrs")));
extern volatile unsigned int        IPC39 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned SPI3TXIS:2;
    unsigned SPI3TXIP:3;
    unsigned :3;
    unsigned U3EIS:2;
    unsigned U3EIP:3;
    unsigned :3;
    unsigned U3RXIS:2;
    unsigned U3RXIP:3;
    unsigned :3;
    unsigned U3TXIS:2;
    unsigned U3TXIP:3;
  };
  struct {
    unsigned w:32;
  };
} __IPC39bits_t;
extern volatile __IPC39bits_t IPC39bits __asm__ ("IPC39") __attribute__((section("sfrs")));
extern volatile unsigned int        IPC39CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IPC39SET __attribute__((section("sfrs")));
extern volatile unsigned int        IPC39INV __attribute__((section("sfrs")));
extern volatile unsigned int        IPC40 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned I2C3BIS:2;
    unsigned I2C3BIP:3;
    unsigned :3;
    unsigned I2C3SIS:2;
    unsigned I2C3SIP:3;
    unsigned :3;
    unsigned I2C3MIS:2;
    unsigned I2C3MIP:3;
    unsigned :3;
    unsigned SPI4EIS:2;
    unsigned SPI4EIP:3;
  };
  struct {
    unsigned w:32;
  };
} __IPC40bits_t;
extern volatile __IPC40bits_t IPC40bits __asm__ ("IPC40") __attribute__((section("sfrs")));
extern volatile unsigned int        IPC40CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IPC40SET __attribute__((section("sfrs")));
extern volatile unsigned int        IPC40INV __attribute__((section("sfrs")));
extern volatile unsigned int        IPC41 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned SPI4RXIS:2;
    unsigned SPI4RXIP:3;
    unsigned :3;
    unsigned SPI4TXIS:2;
    unsigned SPI4TXIP:3;
    unsigned :3;
    unsigned RTCCIS:2;
    unsigned RTCCIP:3;
    unsigned :3;
    unsigned FCEIS:2;
    unsigned FCEIP:3;
  };
  struct {
    unsigned w:32;
  };
} __IPC41bits_t;
extern volatile __IPC41bits_t IPC41bits __asm__ ("IPC41") __attribute__((section("sfrs")));
extern volatile unsigned int        IPC41CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IPC41SET __attribute__((section("sfrs")));
extern volatile unsigned int        IPC41INV __attribute__((section("sfrs")));
extern volatile unsigned int        IPC42 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned PREIS:2;
    unsigned PREIP:3;
    unsigned :3;
    unsigned SQI1IS:2;
    unsigned SQI1IP:3;
    unsigned :3;
    unsigned U4EIS:2;
    unsigned U4EIP:3;
    unsigned :3;
    unsigned U4RXIS:2;
    unsigned U4RXIP:3;
  };
  struct {
    unsigned w:32;
  };
} __IPC42bits_t;
extern volatile __IPC42bits_t IPC42bits __asm__ ("IPC42") __attribute__((section("sfrs")));
extern volatile unsigned int        IPC42CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IPC42SET __attribute__((section("sfrs")));
extern volatile unsigned int        IPC42INV __attribute__((section("sfrs")));
extern volatile unsigned int        IPC43 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned U4TXIS:2;
    unsigned U4TXIP:3;
    unsigned :3;
    unsigned I2C4BIS:2;
    unsigned I2C4BIP:3;
    unsigned :3;
    unsigned I2C4SIS:2;
    unsigned I2C4SIP:3;
    unsigned :3;
    unsigned I2C4MIS:2;
    unsigned I2C4MIP:3;
  };
  struct {
    unsigned w:32;
  };
} __IPC43bits_t;
extern volatile __IPC43bits_t IPC43bits __asm__ ("IPC43") __attribute__((section("sfrs")));
extern volatile unsigned int        IPC43CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IPC43SET __attribute__((section("sfrs")));
extern volatile unsigned int        IPC43INV __attribute__((section("sfrs")));
extern volatile unsigned int        IPC44 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned SPI5EIS:2;
    unsigned SPI5EIP:3;
    unsigned :3;
    unsigned SPI5RXIS:2;
    unsigned SPI5RXIP:3;
    unsigned :3;
    unsigned SPI5TXIS:2;
    unsigned SPI5TXIP:3;
    unsigned :3;
    unsigned U5EIS:2;
    unsigned U5EIP:3;
  };
  struct {
    unsigned w:32;
  };
} __IPC44bits_t;
extern volatile __IPC44bits_t IPC44bits __asm__ ("IPC44") __attribute__((section("sfrs")));
extern volatile unsigned int        IPC44CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IPC44SET __attribute__((section("sfrs")));
extern volatile unsigned int        IPC44INV __attribute__((section("sfrs")));
extern volatile unsigned int        IPC45 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned U5RXIS:2;
    unsigned U5RXIP:3;
    unsigned :3;
    unsigned U5TXIS:2;
    unsigned U5TXIP:3;
    unsigned :3;
    unsigned I2C5BIS:2;
    unsigned I2C5BIP:3;
    unsigned :3;
    unsigned I2C5SIS:2;
    unsigned I2C5SIP:3;
  };
  struct {
    unsigned w:32;
  };
} __IPC45bits_t;
extern volatile __IPC45bits_t IPC45bits __asm__ ("IPC45") __attribute__((section("sfrs")));
extern volatile unsigned int        IPC45CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IPC45SET __attribute__((section("sfrs")));
extern volatile unsigned int        IPC45INV __attribute__((section("sfrs")));
extern volatile unsigned int        IPC46 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned I2C5MIS:2;
    unsigned I2C5MIP:3;
    unsigned :3;
    unsigned SPI6EIS:2;
    unsigned SPI6EIP:3;
    unsigned :3;
    unsigned SPI6RXIS:2;
    unsigned SPI6RXIP:3;
    unsigned :3;
    unsigned SPI6TXIS:2;
    unsigned SPI6TXIP:3;
  };
  struct {
    unsigned w:32;
  };
} __IPC46bits_t;
extern volatile __IPC46bits_t IPC46bits __asm__ ("IPC46") __attribute__((section("sfrs")));
extern volatile unsigned int        IPC46CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IPC46SET __attribute__((section("sfrs")));
extern volatile unsigned int        IPC46INV __attribute__((section("sfrs")));
extern volatile unsigned int        IPC47 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned U6EIS:2;
    unsigned U6EIP:3;
    unsigned :3;
    unsigned U6RXIS:2;
    unsigned U6RXIP:3;
    unsigned :3;
    unsigned U6TXIS:2;
    unsigned U6TXIP:3;
  };
  struct {
    unsigned w:32;
  };
} __IPC47bits_t;
extern volatile __IPC47bits_t IPC47bits __asm__ ("IPC47") __attribute__((section("sfrs")));
extern volatile unsigned int        IPC47CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IPC47SET __attribute__((section("sfrs")));
extern volatile unsigned int        IPC47INV __attribute__((section("sfrs")));
extern volatile unsigned int        OFF000 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF000bits_t;
extern volatile __OFF000bits_t OFF000bits __asm__ ("OFF000") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF001 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF001bits_t;
extern volatile __OFF001bits_t OFF001bits __asm__ ("OFF001") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF002 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF002bits_t;
extern volatile __OFF002bits_t OFF002bits __asm__ ("OFF002") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF003 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF003bits_t;
extern volatile __OFF003bits_t OFF003bits __asm__ ("OFF003") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF004 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF004bits_t;
extern volatile __OFF004bits_t OFF004bits __asm__ ("OFF004") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF005 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF005bits_t;
extern volatile __OFF005bits_t OFF005bits __asm__ ("OFF005") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF006 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF006bits_t;
extern volatile __OFF006bits_t OFF006bits __asm__ ("OFF006") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF007 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF007bits_t;
extern volatile __OFF007bits_t OFF007bits __asm__ ("OFF007") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF008 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF008bits_t;
extern volatile __OFF008bits_t OFF008bits __asm__ ("OFF008") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF009 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF009bits_t;
extern volatile __OFF009bits_t OFF009bits __asm__ ("OFF009") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF010 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF010bits_t;
extern volatile __OFF010bits_t OFF010bits __asm__ ("OFF010") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF011 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF011bits_t;
extern volatile __OFF011bits_t OFF011bits __asm__ ("OFF011") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF012 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF012bits_t;
extern volatile __OFF012bits_t OFF012bits __asm__ ("OFF012") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF013 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF013bits_t;
extern volatile __OFF013bits_t OFF013bits __asm__ ("OFF013") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF014 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF014bits_t;
extern volatile __OFF014bits_t OFF014bits __asm__ ("OFF014") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF015 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF015bits_t;
extern volatile __OFF015bits_t OFF015bits __asm__ ("OFF015") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF016 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF016bits_t;
extern volatile __OFF016bits_t OFF016bits __asm__ ("OFF016") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF017 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF017bits_t;
extern volatile __OFF017bits_t OFF017bits __asm__ ("OFF017") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF018 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF018bits_t;
extern volatile __OFF018bits_t OFF018bits __asm__ ("OFF018") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF019 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF019bits_t;
extern volatile __OFF019bits_t OFF019bits __asm__ ("OFF019") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF020 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF020bits_t;
extern volatile __OFF020bits_t OFF020bits __asm__ ("OFF020") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF021 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF021bits_t;
extern volatile __OFF021bits_t OFF021bits __asm__ ("OFF021") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF022 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF022bits_t;
extern volatile __OFF022bits_t OFF022bits __asm__ ("OFF022") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF023 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF023bits_t;
extern volatile __OFF023bits_t OFF023bits __asm__ ("OFF023") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF024 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF024bits_t;
extern volatile __OFF024bits_t OFF024bits __asm__ ("OFF024") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF025 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF025bits_t;
extern volatile __OFF025bits_t OFF025bits __asm__ ("OFF025") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF026 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF026bits_t;
extern volatile __OFF026bits_t OFF026bits __asm__ ("OFF026") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF027 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF027bits_t;
extern volatile __OFF027bits_t OFF027bits __asm__ ("OFF027") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF028 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF028bits_t;
extern volatile __OFF028bits_t OFF028bits __asm__ ("OFF028") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF029 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF029bits_t;
extern volatile __OFF029bits_t OFF029bits __asm__ ("OFF029") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF030 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF030bits_t;
extern volatile __OFF030bits_t OFF030bits __asm__ ("OFF030") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF031 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF031bits_t;
extern volatile __OFF031bits_t OFF031bits __asm__ ("OFF031") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF032 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF032bits_t;
extern volatile __OFF032bits_t OFF032bits __asm__ ("OFF032") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF033 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF033bits_t;
extern volatile __OFF033bits_t OFF033bits __asm__ ("OFF033") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF034 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF034bits_t;
extern volatile __OFF034bits_t OFF034bits __asm__ ("OFF034") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF035 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF035bits_t;
extern volatile __OFF035bits_t OFF035bits __asm__ ("OFF035") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF036 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF036bits_t;
extern volatile __OFF036bits_t OFF036bits __asm__ ("OFF036") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF037 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF037bits_t;
extern volatile __OFF037bits_t OFF037bits __asm__ ("OFF037") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF038 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF038bits_t;
extern volatile __OFF038bits_t OFF038bits __asm__ ("OFF038") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF039 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF039bits_t;
extern volatile __OFF039bits_t OFF039bits __asm__ ("OFF039") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF040 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF040bits_t;
extern volatile __OFF040bits_t OFF040bits __asm__ ("OFF040") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF041 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF041bits_t;
extern volatile __OFF041bits_t OFF041bits __asm__ ("OFF041") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF042 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF042bits_t;
extern volatile __OFF042bits_t OFF042bits __asm__ ("OFF042") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF043 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF043bits_t;
extern volatile __OFF043bits_t OFF043bits __asm__ ("OFF043") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF044 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF044bits_t;
extern volatile __OFF044bits_t OFF044bits __asm__ ("OFF044") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF046 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF046bits_t;
extern volatile __OFF046bits_t OFF046bits __asm__ ("OFF046") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF047 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF047bits_t;
extern volatile __OFF047bits_t OFF047bits __asm__ ("OFF047") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF048 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF048bits_t;
extern volatile __OFF048bits_t OFF048bits __asm__ ("OFF048") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF049 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF049bits_t;
extern volatile __OFF049bits_t OFF049bits __asm__ ("OFF049") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF050 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF050bits_t;
extern volatile __OFF050bits_t OFF050bits __asm__ ("OFF050") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF051 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF051bits_t;
extern volatile __OFF051bits_t OFF051bits __asm__ ("OFF051") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF052 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF052bits_t;
extern volatile __OFF052bits_t OFF052bits __asm__ ("OFF052") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF053 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF053bits_t;
extern volatile __OFF053bits_t OFF053bits __asm__ ("OFF053") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF054 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF054bits_t;
extern volatile __OFF054bits_t OFF054bits __asm__ ("OFF054") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF055 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF055bits_t;
extern volatile __OFF055bits_t OFF055bits __asm__ ("OFF055") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF056 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF056bits_t;
extern volatile __OFF056bits_t OFF056bits __asm__ ("OFF056") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF057 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF057bits_t;
extern volatile __OFF057bits_t OFF057bits __asm__ ("OFF057") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF059 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF059bits_t;
extern volatile __OFF059bits_t OFF059bits __asm__ ("OFF059") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF060 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF060bits_t;
extern volatile __OFF060bits_t OFF060bits __asm__ ("OFF060") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF061 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF061bits_t;
extern volatile __OFF061bits_t OFF061bits __asm__ ("OFF061") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF062 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF062bits_t;
extern volatile __OFF062bits_t OFF062bits __asm__ ("OFF062") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF063 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF063bits_t;
extern volatile __OFF063bits_t OFF063bits __asm__ ("OFF063") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF064 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF064bits_t;
extern volatile __OFF064bits_t OFF064bits __asm__ ("OFF064") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF065 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF065bits_t;
extern volatile __OFF065bits_t OFF065bits __asm__ ("OFF065") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF066 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF066bits_t;
extern volatile __OFF066bits_t OFF066bits __asm__ ("OFF066") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF067 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF067bits_t;
extern volatile __OFF067bits_t OFF067bits __asm__ ("OFF067") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF068 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF068bits_t;
extern volatile __OFF068bits_t OFF068bits __asm__ ("OFF068") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF069 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF069bits_t;
extern volatile __OFF069bits_t OFF069bits __asm__ ("OFF069") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF070 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF070bits_t;
extern volatile __OFF070bits_t OFF070bits __asm__ ("OFF070") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF071 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF071bits_t;
extern volatile __OFF071bits_t OFF071bits __asm__ ("OFF071") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF072 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF072bits_t;
extern volatile __OFF072bits_t OFF072bits __asm__ ("OFF072") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF073 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF073bits_t;
extern volatile __OFF073bits_t OFF073bits __asm__ ("OFF073") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF074 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF074bits_t;
extern volatile __OFF074bits_t OFF074bits __asm__ ("OFF074") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF075 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF075bits_t;
extern volatile __OFF075bits_t OFF075bits __asm__ ("OFF075") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF076 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF076bits_t;
extern volatile __OFF076bits_t OFF076bits __asm__ ("OFF076") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF077 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF077bits_t;
extern volatile __OFF077bits_t OFF077bits __asm__ ("OFF077") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF078 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF078bits_t;
extern volatile __OFF078bits_t OFF078bits __asm__ ("OFF078") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF079 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF079bits_t;
extern volatile __OFF079bits_t OFF079bits __asm__ ("OFF079") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF080 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF080bits_t;
extern volatile __OFF080bits_t OFF080bits __asm__ ("OFF080") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF081 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF081bits_t;
extern volatile __OFF081bits_t OFF081bits __asm__ ("OFF081") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF082 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF082bits_t;
extern volatile __OFF082bits_t OFF082bits __asm__ ("OFF082") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF083 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF083bits_t;
extern volatile __OFF083bits_t OFF083bits __asm__ ("OFF083") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF084 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF084bits_t;
extern volatile __OFF084bits_t OFF084bits __asm__ ("OFF084") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF085 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF085bits_t;
extern volatile __OFF085bits_t OFF085bits __asm__ ("OFF085") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF086 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF086bits_t;
extern volatile __OFF086bits_t OFF086bits __asm__ ("OFF086") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF087 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF087bits_t;
extern volatile __OFF087bits_t OFF087bits __asm__ ("OFF087") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF088 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF088bits_t;
extern volatile __OFF088bits_t OFF088bits __asm__ ("OFF088") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF089 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF089bits_t;
extern volatile __OFF089bits_t OFF089bits __asm__ ("OFF089") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF090 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF090bits_t;
extern volatile __OFF090bits_t OFF090bits __asm__ ("OFF090") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF091 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF091bits_t;
extern volatile __OFF091bits_t OFF091bits __asm__ ("OFF091") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF092 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF092bits_t;
extern volatile __OFF092bits_t OFF092bits __asm__ ("OFF092") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF093 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF093bits_t;
extern volatile __OFF093bits_t OFF093bits __asm__ ("OFF093") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF094 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF094bits_t;
extern volatile __OFF094bits_t OFF094bits __asm__ ("OFF094") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF095 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF095bits_t;
extern volatile __OFF095bits_t OFF095bits __asm__ ("OFF095") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF096 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF096bits_t;
extern volatile __OFF096bits_t OFF096bits __asm__ ("OFF096") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF097 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF097bits_t;
extern volatile __OFF097bits_t OFF097bits __asm__ ("OFF097") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF098 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF098bits_t;
extern volatile __OFF098bits_t OFF098bits __asm__ ("OFF098") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF099 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF099bits_t;
extern volatile __OFF099bits_t OFF099bits __asm__ ("OFF099") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF100 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF100bits_t;
extern volatile __OFF100bits_t OFF100bits __asm__ ("OFF100") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF101 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF101bits_t;
extern volatile __OFF101bits_t OFF101bits __asm__ ("OFF101") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF102 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF102bits_t;
extern volatile __OFF102bits_t OFF102bits __asm__ ("OFF102") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF103 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF103bits_t;
extern volatile __OFF103bits_t OFF103bits __asm__ ("OFF103") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF104 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF104bits_t;
extern volatile __OFF104bits_t OFF104bits __asm__ ("OFF104") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF105 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF105bits_t;
extern volatile __OFF105bits_t OFF105bits __asm__ ("OFF105") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF106 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF106bits_t;
extern volatile __OFF106bits_t OFF106bits __asm__ ("OFF106") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF107 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF107bits_t;
extern volatile __OFF107bits_t OFF107bits __asm__ ("OFF107") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF109 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF109bits_t;
extern volatile __OFF109bits_t OFF109bits __asm__ ("OFF109") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF110 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF110bits_t;
extern volatile __OFF110bits_t OFF110bits __asm__ ("OFF110") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF111 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF111bits_t;
extern volatile __OFF111bits_t OFF111bits __asm__ ("OFF111") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF112 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF112bits_t;
extern volatile __OFF112bits_t OFF112bits __asm__ ("OFF112") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF113 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF113bits_t;
extern volatile __OFF113bits_t OFF113bits __asm__ ("OFF113") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF114 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF114bits_t;
extern volatile __OFF114bits_t OFF114bits __asm__ ("OFF114") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF115 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF115bits_t;
extern volatile __OFF115bits_t OFF115bits __asm__ ("OFF115") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF116 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF116bits_t;
extern volatile __OFF116bits_t OFF116bits __asm__ ("OFF116") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF117 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF117bits_t;
extern volatile __OFF117bits_t OFF117bits __asm__ ("OFF117") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF118 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF118bits_t;
extern volatile __OFF118bits_t OFF118bits __asm__ ("OFF118") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF119 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF119bits_t;
extern volatile __OFF119bits_t OFF119bits __asm__ ("OFF119") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF120 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF120bits_t;
extern volatile __OFF120bits_t OFF120bits __asm__ ("OFF120") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF121 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF121bits_t;
extern volatile __OFF121bits_t OFF121bits __asm__ ("OFF121") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF122 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF122bits_t;
extern volatile __OFF122bits_t OFF122bits __asm__ ("OFF122") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF123 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF123bits_t;
extern volatile __OFF123bits_t OFF123bits __asm__ ("OFF123") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF124 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF124bits_t;
extern volatile __OFF124bits_t OFF124bits __asm__ ("OFF124") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF125 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF125bits_t;
extern volatile __OFF125bits_t OFF125bits __asm__ ("OFF125") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF126 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF126bits_t;
extern volatile __OFF126bits_t OFF126bits __asm__ ("OFF126") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF127 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF127bits_t;
extern volatile __OFF127bits_t OFF127bits __asm__ ("OFF127") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF128 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF128bits_t;
extern volatile __OFF128bits_t OFF128bits __asm__ ("OFF128") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF129 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF129bits_t;
extern volatile __OFF129bits_t OFF129bits __asm__ ("OFF129") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF130 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF130bits_t;
extern volatile __OFF130bits_t OFF130bits __asm__ ("OFF130") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF131 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF131bits_t;
extern volatile __OFF131bits_t OFF131bits __asm__ ("OFF131") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF132 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF132bits_t;
extern volatile __OFF132bits_t OFF132bits __asm__ ("OFF132") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF133 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF133bits_t;
extern volatile __OFF133bits_t OFF133bits __asm__ ("OFF133") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF134 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF134bits_t;
extern volatile __OFF134bits_t OFF134bits __asm__ ("OFF134") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF135 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF135bits_t;
extern volatile __OFF135bits_t OFF135bits __asm__ ("OFF135") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF136 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF136bits_t;
extern volatile __OFF136bits_t OFF136bits __asm__ ("OFF136") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF137 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF137bits_t;
extern volatile __OFF137bits_t OFF137bits __asm__ ("OFF137") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF138 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF138bits_t;
extern volatile __OFF138bits_t OFF138bits __asm__ ("OFF138") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF139 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF139bits_t;
extern volatile __OFF139bits_t OFF139bits __asm__ ("OFF139") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF140 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF140bits_t;
extern volatile __OFF140bits_t OFF140bits __asm__ ("OFF140") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF141 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF141bits_t;
extern volatile __OFF141bits_t OFF141bits __asm__ ("OFF141") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF142 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF142bits_t;
extern volatile __OFF142bits_t OFF142bits __asm__ ("OFF142") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF143 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF143bits_t;
extern volatile __OFF143bits_t OFF143bits __asm__ ("OFF143") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF144 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF144bits_t;
extern volatile __OFF144bits_t OFF144bits __asm__ ("OFF144") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF145 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF145bits_t;
extern volatile __OFF145bits_t OFF145bits __asm__ ("OFF145") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF146 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF146bits_t;
extern volatile __OFF146bits_t OFF146bits __asm__ ("OFF146") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF147 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF147bits_t;
extern volatile __OFF147bits_t OFF147bits __asm__ ("OFF147") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF148 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF148bits_t;
extern volatile __OFF148bits_t OFF148bits __asm__ ("OFF148") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF149 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF149bits_t;
extern volatile __OFF149bits_t OFF149bits __asm__ ("OFF149") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF150 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF150bits_t;
extern volatile __OFF150bits_t OFF150bits __asm__ ("OFF150") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF151 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF151bits_t;
extern volatile __OFF151bits_t OFF151bits __asm__ ("OFF151") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF152 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF152bits_t;
extern volatile __OFF152bits_t OFF152bits __asm__ ("OFF152") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF153 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF153bits_t;
extern volatile __OFF153bits_t OFF153bits __asm__ ("OFF153") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF154 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF154bits_t;
extern volatile __OFF154bits_t OFF154bits __asm__ ("OFF154") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF155 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF155bits_t;
extern volatile __OFF155bits_t OFF155bits __asm__ ("OFF155") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF156 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF156bits_t;
extern volatile __OFF156bits_t OFF156bits __asm__ ("OFF156") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF157 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF157bits_t;
extern volatile __OFF157bits_t OFF157bits __asm__ ("OFF157") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF158 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF158bits_t;
extern volatile __OFF158bits_t OFF158bits __asm__ ("OFF158") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF159 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF159bits_t;
extern volatile __OFF159bits_t OFF159bits __asm__ ("OFF159") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF160 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF160bits_t;
extern volatile __OFF160bits_t OFF160bits __asm__ ("OFF160") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF161 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF161bits_t;
extern volatile __OFF161bits_t OFF161bits __asm__ ("OFF161") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF162 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF162bits_t;
extern volatile __OFF162bits_t OFF162bits __asm__ ("OFF162") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF163 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF163bits_t;
extern volatile __OFF163bits_t OFF163bits __asm__ ("OFF163") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF164 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF164bits_t;
extern volatile __OFF164bits_t OFF164bits __asm__ ("OFF164") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF165 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF165bits_t;
extern volatile __OFF165bits_t OFF165bits __asm__ ("OFF165") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF166 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF166bits_t;
extern volatile __OFF166bits_t OFF166bits __asm__ ("OFF166") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF167 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF167bits_t;
extern volatile __OFF167bits_t OFF167bits __asm__ ("OFF167") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF168 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF168bits_t;
extern volatile __OFF168bits_t OFF168bits __asm__ ("OFF168") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF169 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF169bits_t;
extern volatile __OFF169bits_t OFF169bits __asm__ ("OFF169") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF170 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF170bits_t;
extern volatile __OFF170bits_t OFF170bits __asm__ ("OFF170") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF171 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF171bits_t;
extern volatile __OFF171bits_t OFF171bits __asm__ ("OFF171") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF172 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF172bits_t;
extern volatile __OFF172bits_t OFF172bits __asm__ ("OFF172") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF173 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF173bits_t;
extern volatile __OFF173bits_t OFF173bits __asm__ ("OFF173") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF174 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF174bits_t;
extern volatile __OFF174bits_t OFF174bits __asm__ ("OFF174") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF175 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF175bits_t;
extern volatile __OFF175bits_t OFF175bits __asm__ ("OFF175") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF176 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF176bits_t;
extern volatile __OFF176bits_t OFF176bits __asm__ ("OFF176") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF177 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF177bits_t;
extern volatile __OFF177bits_t OFF177bits __asm__ ("OFF177") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF178 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF178bits_t;
extern volatile __OFF178bits_t OFF178bits __asm__ ("OFF178") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF179 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF179bits_t;
extern volatile __OFF179bits_t OFF179bits __asm__ ("OFF179") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF180 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF180bits_t;
extern volatile __OFF180bits_t OFF180bits __asm__ ("OFF180") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF181 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF181bits_t;
extern volatile __OFF181bits_t OFF181bits __asm__ ("OFF181") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF182 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF182bits_t;
extern volatile __OFF182bits_t OFF182bits __asm__ ("OFF182") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF183 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF183bits_t;
extern volatile __OFF183bits_t OFF183bits __asm__ ("OFF183") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF184 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF184bits_t;
extern volatile __OFF184bits_t OFF184bits __asm__ ("OFF184") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF185 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF185bits_t;
extern volatile __OFF185bits_t OFF185bits __asm__ ("OFF185") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF186 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF186bits_t;
extern volatile __OFF186bits_t OFF186bits __asm__ ("OFF186") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF187 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF187bits_t;
extern volatile __OFF187bits_t OFF187bits __asm__ ("OFF187") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF188 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF188bits_t;
extern volatile __OFF188bits_t OFF188bits __asm__ ("OFF188") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF189 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF189bits_t;
extern volatile __OFF189bits_t OFF189bits __asm__ ("OFF189") __attribute__((section("sfrs")));
extern volatile unsigned int        OFF190 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF190bits_t;
extern volatile __OFF190bits_t OFF190bits __asm__ ("OFF190") __attribute__((section("sfrs")));
extern volatile unsigned int        DMACON __attribute__((section("sfrs")));
typedef struct {
  unsigned :11;
  unsigned DMABUSY:1;
  unsigned SUSPEND:1;
  unsigned :2;
  unsigned ON:1;
} __DMACONbits_t;
extern volatile __DMACONbits_t DMACONbits __asm__ ("DMACON") __attribute__((section("sfrs")));
extern volatile unsigned int        DMACONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DMACONSET __attribute__((section("sfrs")));
extern volatile unsigned int        DMACONINV __attribute__((section("sfrs")));
extern volatile unsigned int        DMASTAT __attribute__((section("sfrs")));
typedef struct {
  unsigned DMACH:3;
  unsigned :28;
  unsigned RDWR:1;
} __DMASTATbits_t;
extern volatile __DMASTATbits_t DMASTATbits __asm__ ("DMASTAT") __attribute__((section("sfrs")));
extern volatile unsigned int        DMASTATCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DMASTATSET __attribute__((section("sfrs")));
extern volatile unsigned int        DMASTATINV __attribute__((section("sfrs")));
extern volatile unsigned int        DMAADDR __attribute__((section("sfrs")));
typedef struct {
  unsigned DMAADDR:32;
} __DMAADDRbits_t;
extern volatile __DMAADDRbits_t DMAADDRbits __asm__ ("DMAADDR") __attribute__((section("sfrs")));
extern volatile unsigned int        DMAADDRCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DMAADDRSET __attribute__((section("sfrs")));
extern volatile unsigned int        DMAADDRINV __attribute__((section("sfrs")));
extern volatile unsigned int        DCRCCON __attribute__((section("sfrs")));
typedef struct {
  unsigned CRCCH:3;
  unsigned :2;
  unsigned CRCTYP:1;
  unsigned CRCAPP:1;
  unsigned CRCEN:1;
  unsigned PLEN:5;
  unsigned :11;
  unsigned BITO:1;
  unsigned :2;
  unsigned WBO:1;
  unsigned BYTO:2;
} __DCRCCONbits_t;
extern volatile __DCRCCONbits_t DCRCCONbits __asm__ ("DCRCCON") __attribute__((section("sfrs")));
extern volatile unsigned int        DCRCCONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCRCCONSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCRCCONINV __attribute__((section("sfrs")));
extern volatile unsigned int        DCRCDATA __attribute__((section("sfrs")));
typedef struct {
  unsigned DCRCDATA:32;
} __DCRCDATAbits_t;
extern volatile __DCRCDATAbits_t DCRCDATAbits __asm__ ("DCRCDATA") __attribute__((section("sfrs")));
extern volatile unsigned int        DCRCDATACLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCRCDATASET __attribute__((section("sfrs")));
extern volatile unsigned int        DCRCDATAINV __attribute__((section("sfrs")));
extern volatile unsigned int        DCRCXOR __attribute__((section("sfrs")));
typedef struct {
  unsigned DCRCXOR:32;
} __DCRCXORbits_t;
extern volatile __DCRCXORbits_t DCRCXORbits __asm__ ("DCRCXOR") __attribute__((section("sfrs")));
extern volatile unsigned int        DCRCXORCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCRCXORSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCRCXORINV __attribute__((section("sfrs")));
extern volatile unsigned int        DCH0CON __attribute__((section("sfrs")));
typedef struct {
  unsigned CHPRI:2;
  unsigned CHEDET:1;
  unsigned :1;
  unsigned CHAEN:1;
  unsigned CHCHN:1;
  unsigned CHAED:1;
  unsigned CHEN:1;
  unsigned CHCHNS:1;
  unsigned :2;
  unsigned CHPATLEN:1;
  unsigned :1;
  unsigned CHPIGNEN:1;
  unsigned :1;
  unsigned CHBUSY:1;
  unsigned :8;
  unsigned CHPIGN:8;
} __DCH0CONbits_t;
extern volatile __DCH0CONbits_t DCH0CONbits __asm__ ("DCH0CON") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH0CONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH0CONSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH0CONINV __attribute__((section("sfrs")));
extern volatile unsigned int        DCH0ECON __attribute__((section("sfrs")));
typedef struct {
  unsigned :3;
  unsigned AIRQEN:1;
  unsigned SIRQEN:1;
  unsigned PATEN:1;
  unsigned CABORT:1;
  unsigned CFORCE:1;
  unsigned CHSIRQ:8;
  unsigned CHAIRQ:8;
} __DCH0ECONbits_t;
extern volatile __DCH0ECONbits_t DCH0ECONbits __asm__ ("DCH0ECON") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH0ECONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH0ECONSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH0ECONINV __attribute__((section("sfrs")));
extern volatile unsigned int        DCH0INT __attribute__((section("sfrs")));
typedef struct {
  unsigned CHERIF:1;
  unsigned CHTAIF:1;
  unsigned CHCCIF:1;
  unsigned CHBCIF:1;
  unsigned CHDHIF:1;
  unsigned CHDDIF:1;
  unsigned CHSHIF:1;
  unsigned CHSDIF:1;
  unsigned :8;
  unsigned CHERIE:1;
  unsigned CHTAIE:1;
  unsigned CHCCIE:1;
  unsigned CHBCIE:1;
  unsigned CHDHIE:1;
  unsigned CHDDIE:1;
  unsigned CHSHIE:1;
  unsigned CHSDIE:1;
} __DCH0INTbits_t;
extern volatile __DCH0INTbits_t DCH0INTbits __asm__ ("DCH0INT") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH0INTCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH0INTSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH0INTINV __attribute__((section("sfrs")));
extern volatile unsigned int        DCH0SSA __attribute__((section("sfrs")));
typedef struct {
  unsigned CHSSA:32;
} __DCH0SSAbits_t;
extern volatile __DCH0SSAbits_t DCH0SSAbits __asm__ ("DCH0SSA") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH0SSACLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH0SSASET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH0SSAINV __attribute__((section("sfrs")));
extern volatile unsigned int        DCH0DSA __attribute__((section("sfrs")));
typedef struct {
  unsigned CHDSA:32;
} __DCH0DSAbits_t;
extern volatile __DCH0DSAbits_t DCH0DSAbits __asm__ ("DCH0DSA") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH0DSACLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH0DSASET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH0DSAINV __attribute__((section("sfrs")));
extern volatile unsigned int        DCH0SSIZ __attribute__((section("sfrs")));
typedef struct {
  unsigned CHSSIZ:16;
} __DCH0SSIZbits_t;
extern volatile __DCH0SSIZbits_t DCH0SSIZbits __asm__ ("DCH0SSIZ") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH0SSIZCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH0SSIZSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH0SSIZINV __attribute__((section("sfrs")));
extern volatile unsigned int        DCH0DSIZ __attribute__((section("sfrs")));
typedef struct {
  unsigned CHDSIZ:16;
} __DCH0DSIZbits_t;
extern volatile __DCH0DSIZbits_t DCH0DSIZbits __asm__ ("DCH0DSIZ") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH0DSIZCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH0DSIZSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH0DSIZINV __attribute__((section("sfrs")));
extern volatile unsigned int        DCH0SPTR __attribute__((section("sfrs")));
typedef struct {
  unsigned CHSPTR:16;
} __DCH0SPTRbits_t;
extern volatile __DCH0SPTRbits_t DCH0SPTRbits __asm__ ("DCH0SPTR") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH0SPTRCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH0SPTRSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH0SPTRINV __attribute__((section("sfrs")));
extern volatile unsigned int        DCH0DPTR __attribute__((section("sfrs")));
typedef struct {
  unsigned CHDPTR:16;
} __DCH0DPTRbits_t;
extern volatile __DCH0DPTRbits_t DCH0DPTRbits __asm__ ("DCH0DPTR") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH0DPTRCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH0DPTRSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH0DPTRINV __attribute__((section("sfrs")));
extern volatile unsigned int        DCH0CSIZ __attribute__((section("sfrs")));
typedef struct {
  unsigned CHCSIZ:16;
} __DCH0CSIZbits_t;
extern volatile __DCH0CSIZbits_t DCH0CSIZbits __asm__ ("DCH0CSIZ") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH0CSIZCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH0CSIZSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH0CSIZINV __attribute__((section("sfrs")));
extern volatile unsigned int        DCS0CPTR __attribute__((section("sfrs")));
typedef struct {
  unsigned CHCPTR:16;
} __DCS0CPTRbits_t;
extern volatile __DCS0CPTRbits_t DCS0CPTRbits __asm__ ("DCS0CPTR") __attribute__((section("sfrs")));
extern volatile unsigned int        DCS0CPTRCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCS0CPTRSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCS0CPTRINV __attribute__((section("sfrs")));
extern volatile unsigned int        DCH0DAT __attribute__((section("sfrs")));
typedef struct {
  unsigned CHPDAT:16;
} __DCH0DATbits_t;
extern volatile __DCH0DATbits_t DCH0DATbits __asm__ ("DCH0DAT") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH0DATCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH0DATSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH0DATINV __attribute__((section("sfrs")));
extern volatile unsigned int        DCH1CON __attribute__((section("sfrs")));
typedef struct {
  unsigned CHPRI:2;
  unsigned CHEDET:1;
  unsigned :1;
  unsigned CHAEN:1;
  unsigned CHCHN:1;
  unsigned CHAED:1;
  unsigned CHEN:1;
  unsigned CHCHNS:1;
  unsigned :2;
  unsigned CHPATLEN:1;
  unsigned :1;
  unsigned CHPIGNEN:1;
  unsigned :1;
  unsigned CHBUSY:1;
  unsigned :8;
  unsigned CHPIGN:8;
} __DCH1CONbits_t;
extern volatile __DCH1CONbits_t DCH1CONbits __asm__ ("DCH1CON") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH1CONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH1CONSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH1CONINV __attribute__((section("sfrs")));
extern volatile unsigned int        DCH1ECON __attribute__((section("sfrs")));
typedef struct {
  unsigned :3;
  unsigned AIRQEN:1;
  unsigned SIRQEN:1;
  unsigned PATEN:1;
  unsigned CABORT:1;
  unsigned CFORCE:1;
  unsigned CHSIRQ:8;
  unsigned CHAIRQ:8;
} __DCH1ECONbits_t;
extern volatile __DCH1ECONbits_t DCH1ECONbits __asm__ ("DCH1ECON") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH1ECONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH1ECONSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH1ECONINV __attribute__((section("sfrs")));
extern volatile unsigned int        DCH1INT __attribute__((section("sfrs")));
typedef struct {
  unsigned CHERIF:1;
  unsigned CHTAIF:1;
  unsigned CHCCIF:1;
  unsigned CHBCIF:1;
  unsigned CHDHIF:1;
  unsigned CHDDIF:1;
  unsigned CHSHIF:1;
  unsigned CHSDIF:1;
  unsigned :8;
  unsigned CHERIE:1;
  unsigned CHTAIE:1;
  unsigned CHCCIE:1;
  unsigned CHBCIE:1;
  unsigned CHDHIE:1;
  unsigned CHDDIE:1;
  unsigned CHSHIE:1;
  unsigned CHSDIE:1;
} __DCH1INTbits_t;
extern volatile __DCH1INTbits_t DCH1INTbits __asm__ ("DCH1INT") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH1INTCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH1INTSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH1INTINV __attribute__((section("sfrs")));
extern volatile unsigned int        DCH1SSA __attribute__((section("sfrs")));
typedef struct {
  unsigned CHSSA:32;
} __DCH1SSAbits_t;
extern volatile __DCH1SSAbits_t DCH1SSAbits __asm__ ("DCH1SSA") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH1SSACLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH1SSASET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH1SSAINV __attribute__((section("sfrs")));
extern volatile unsigned int        DCH1DSA __attribute__((section("sfrs")));
typedef struct {
  unsigned CHDSA:32;
} __DCH1DSAbits_t;
extern volatile __DCH1DSAbits_t DCH1DSAbits __asm__ ("DCH1DSA") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH1DSACLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH1DSASET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH1DSAINV __attribute__((section("sfrs")));
extern volatile unsigned int        DCH1SSIZ __attribute__((section("sfrs")));
typedef struct {
  unsigned CHSSIZ:16;
} __DCH1SSIZbits_t;
extern volatile __DCH1SSIZbits_t DCH1SSIZbits __asm__ ("DCH1SSIZ") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH1SSIZCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH1SSIZSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH1SSIZINV __attribute__((section("sfrs")));
extern volatile unsigned int        DCH1DSIZ __attribute__((section("sfrs")));
typedef struct {
  unsigned CHDSIZ:16;
} __DCH1DSIZbits_t;
extern volatile __DCH1DSIZbits_t DCH1DSIZbits __asm__ ("DCH1DSIZ") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH1DSIZCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH1DSIZSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH1DSIZINV __attribute__((section("sfrs")));
extern volatile unsigned int        DCH1SPTR __attribute__((section("sfrs")));
typedef struct {
  unsigned CHSPTR:16;
} __DCH1SPTRbits_t;
extern volatile __DCH1SPTRbits_t DCH1SPTRbits __asm__ ("DCH1SPTR") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH1SPTRCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH1SPTRSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH1SPTRINV __attribute__((section("sfrs")));
extern volatile unsigned int        DCH1DPTR __attribute__((section("sfrs")));
typedef struct {
  unsigned CHDPTR:16;
} __DCH1DPTRbits_t;
extern volatile __DCH1DPTRbits_t DCH1DPTRbits __asm__ ("DCH1DPTR") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH1DPTRCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH1DPTRSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH1DPTRINV __attribute__((section("sfrs")));
extern volatile unsigned int        DCH1CSIZ __attribute__((section("sfrs")));
typedef struct {
  unsigned CHCSIZ:16;
} __DCH1CSIZbits_t;
extern volatile __DCH1CSIZbits_t DCH1CSIZbits __asm__ ("DCH1CSIZ") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH1CSIZCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH1CSIZSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH1CSIZINV __attribute__((section("sfrs")));
extern volatile unsigned int        DCS1CPTR __attribute__((section("sfrs")));
typedef struct {
  unsigned CHCPTR:16;
} __DCS1CPTRbits_t;
extern volatile __DCS1CPTRbits_t DCS1CPTRbits __asm__ ("DCS1CPTR") __attribute__((section("sfrs")));
extern volatile unsigned int        DCS1CPTRCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCS1CPTRSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCS1CPTRINV __attribute__((section("sfrs")));
extern volatile unsigned int        DCH1DAT __attribute__((section("sfrs")));
typedef struct {
  unsigned CHPDAT:16;
} __DCH1DATbits_t;
extern volatile __DCH1DATbits_t DCH1DATbits __asm__ ("DCH1DAT") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH1DATCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH1DATSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH1DATINV __attribute__((section("sfrs")));
extern volatile unsigned int        DCH2CON __attribute__((section("sfrs")));
typedef struct {
  unsigned CHPRI:2;
  unsigned CHEDET:1;
  unsigned :1;
  unsigned CHAEN:1;
  unsigned CHCHN:1;
  unsigned CHAED:1;
  unsigned CHEN:1;
  unsigned CHCHNS:1;
  unsigned :2;
  unsigned CHPATLEN:1;
  unsigned :1;
  unsigned CHPIGNEN:1;
  unsigned :1;
  unsigned CHBUSY:1;
  unsigned :8;
  unsigned CHPIGN:8;
} __DCH2CONbits_t;
extern volatile __DCH2CONbits_t DCH2CONbits __asm__ ("DCH2CON") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH2CONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH2CONSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH2CONINV __attribute__((section("sfrs")));
extern volatile unsigned int        DCH2ECON __attribute__((section("sfrs")));
typedef struct {
  unsigned :3;
  unsigned AIRQEN:1;
  unsigned SIRQEN:1;
  unsigned PATEN:1;
  unsigned CABORT:1;
  unsigned CFORCE:1;
  unsigned CHSIRQ:8;
  unsigned CHAIRQ:8;
} __DCH2ECONbits_t;
extern volatile __DCH2ECONbits_t DCH2ECONbits __asm__ ("DCH2ECON") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH2ECONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH2ECONSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH2ECONINV __attribute__((section("sfrs")));
extern volatile unsigned int        DCH2INT __attribute__((section("sfrs")));
typedef struct {
  unsigned CHERIF:1;
  unsigned CHTAIF:1;
  unsigned CHCCIF:1;
  unsigned CHBCIF:1;
  unsigned CHDHIF:1;
  unsigned CHDDIF:1;
  unsigned CHSHIF:1;
  unsigned CHSDIF:1;
  unsigned :8;
  unsigned CHERIE:1;
  unsigned CHTAIE:1;
  unsigned CHCCIE:1;
  unsigned CHBCIE:1;
  unsigned CHDHIE:1;
  unsigned CHDDIE:1;
  unsigned CHSHIE:1;
  unsigned CHSDIE:1;
} __DCH2INTbits_t;
extern volatile __DCH2INTbits_t DCH2INTbits __asm__ ("DCH2INT") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH2INTCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH2INTSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH2INTINV __attribute__((section("sfrs")));
extern volatile unsigned int        DCH2SSA __attribute__((section("sfrs")));
typedef struct {
  unsigned CHSSA:32;
} __DCH2SSAbits_t;
extern volatile __DCH2SSAbits_t DCH2SSAbits __asm__ ("DCH2SSA") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH2SSACLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH2SSASET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH2SSAINV __attribute__((section("sfrs")));
extern volatile unsigned int        DCH2DSA __attribute__((section("sfrs")));
typedef struct {
  unsigned CHDSA:32;
} __DCH2DSAbits_t;
extern volatile __DCH2DSAbits_t DCH2DSAbits __asm__ ("DCH2DSA") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH2DSACLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH2DSASET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH2DSAINV __attribute__((section("sfrs")));
extern volatile unsigned int        DCH2SSIZ __attribute__((section("sfrs")));
typedef struct {
  unsigned CHSSIZ:16;
} __DCH2SSIZbits_t;
extern volatile __DCH2SSIZbits_t DCH2SSIZbits __asm__ ("DCH2SSIZ") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH2SSIZCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH2SSIZSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH2SSIZINV __attribute__((section("sfrs")));
extern volatile unsigned int        DCH2DSIZ __attribute__((section("sfrs")));
typedef struct {
  unsigned CHDSIZ:16;
} __DCH2DSIZbits_t;
extern volatile __DCH2DSIZbits_t DCH2DSIZbits __asm__ ("DCH2DSIZ") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH2DSIZCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH2DSIZSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH2DSIZINV __attribute__((section("sfrs")));
extern volatile unsigned int        DCH2SPTR __attribute__((section("sfrs")));
typedef struct {
  unsigned CHSPTR:16;
} __DCH2SPTRbits_t;
extern volatile __DCH2SPTRbits_t DCH2SPTRbits __asm__ ("DCH2SPTR") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH2SPTRCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH2SPTRSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH2SPTRINV __attribute__((section("sfrs")));
extern volatile unsigned int        DCH2DPTR __attribute__((section("sfrs")));
typedef struct {
  unsigned CHDPTR:16;
} __DCH2DPTRbits_t;
extern volatile __DCH2DPTRbits_t DCH2DPTRbits __asm__ ("DCH2DPTR") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH2DPTRCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH2DPTRSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH2DPTRINV __attribute__((section("sfrs")));
extern volatile unsigned int        DCH2CSIZ __attribute__((section("sfrs")));
typedef struct {
  unsigned CHCSIZ:16;
} __DCH2CSIZbits_t;
extern volatile __DCH2CSIZbits_t DCH2CSIZbits __asm__ ("DCH2CSIZ") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH2CSIZCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH2CSIZSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH2CSIZINV __attribute__((section("sfrs")));
extern volatile unsigned int        DCS2CPTR __attribute__((section("sfrs")));
typedef struct {
  unsigned CHCPTR:16;
} __DCS2CPTRbits_t;
extern volatile __DCS2CPTRbits_t DCS2CPTRbits __asm__ ("DCS2CPTR") __attribute__((section("sfrs")));
extern volatile unsigned int        DCS2CPTRCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCS2CPTRSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCS2CPTRINV __attribute__((section("sfrs")));
extern volatile unsigned int        DCH2DAT __attribute__((section("sfrs")));
typedef struct {
  unsigned CHPDAT:16;
} __DCH2DATbits_t;
extern volatile __DCH2DATbits_t DCH2DATbits __asm__ ("DCH2DAT") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH2DATCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH2DATSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH2DATINV __attribute__((section("sfrs")));
extern volatile unsigned int        DCH3CON __attribute__((section("sfrs")));
typedef struct {
  unsigned CHPRI:2;
  unsigned CHEDET:1;
  unsigned :1;
  unsigned CHAEN:1;
  unsigned CHCHN:1;
  unsigned CHAED:1;
  unsigned CHEN:1;
  unsigned CHCHNS:1;
  unsigned :2;
  unsigned CHPATLEN:1;
  unsigned :1;
  unsigned CHPIGNEN:1;
  unsigned :1;
  unsigned CHBUSY:1;
  unsigned :8;
  unsigned CHPIGN:8;
} __DCH3CONbits_t;
extern volatile __DCH3CONbits_t DCH3CONbits __asm__ ("DCH3CON") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH3CONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH3CONSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH3CONINV __attribute__((section("sfrs")));
extern volatile unsigned int        DCH3ECON __attribute__((section("sfrs")));
typedef struct {
  unsigned :3;
  unsigned AIRQEN:1;
  unsigned SIRQEN:1;
  unsigned PATEN:1;
  unsigned CABORT:1;
  unsigned CFORCE:1;
  unsigned CHSIRQ:8;
  unsigned CHAIRQ:8;
} __DCH3ECONbits_t;
extern volatile __DCH3ECONbits_t DCH3ECONbits __asm__ ("DCH3ECON") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH3ECONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH3ECONSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH3ECONINV __attribute__((section("sfrs")));
extern volatile unsigned int        DCH3INT __attribute__((section("sfrs")));
typedef struct {
  unsigned CHERIF:1;
  unsigned CHTAIF:1;
  unsigned CHCCIF:1;
  unsigned CHBCIF:1;
  unsigned CHDHIF:1;
  unsigned CHDDIF:1;
  unsigned CHSHIF:1;
  unsigned CHSDIF:1;
  unsigned :8;
  unsigned CHERIE:1;
  unsigned CHTAIE:1;
  unsigned CHCCIE:1;
  unsigned CHBCIE:1;
  unsigned CHDHIE:1;
  unsigned CHDDIE:1;
  unsigned CHSHIE:1;
  unsigned CHSDIE:1;
} __DCH3INTbits_t;
extern volatile __DCH3INTbits_t DCH3INTbits __asm__ ("DCH3INT") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH3INTCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH3INTSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH3INTINV __attribute__((section("sfrs")));
extern volatile unsigned int        DCH3SSA __attribute__((section("sfrs")));
typedef struct {
  unsigned CHSSA:32;
} __DCH3SSAbits_t;
extern volatile __DCH3SSAbits_t DCH3SSAbits __asm__ ("DCH3SSA") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH3SSACLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH3SSASET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH3SSAINV __attribute__((section("sfrs")));
extern volatile unsigned int        DCH3DSA __attribute__((section("sfrs")));
typedef struct {
  unsigned CHDSA:32;
} __DCH3DSAbits_t;
extern volatile __DCH3DSAbits_t DCH3DSAbits __asm__ ("DCH3DSA") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH3DSACLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH3DSASET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH3DSAINV __attribute__((section("sfrs")));
extern volatile unsigned int        DCH3SSIZ __attribute__((section("sfrs")));
typedef struct {
  unsigned CHSSIZ:16;
} __DCH3SSIZbits_t;
extern volatile __DCH3SSIZbits_t DCH3SSIZbits __asm__ ("DCH3SSIZ") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH3SSIZCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH3SSIZSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH3SSIZINV __attribute__((section("sfrs")));
extern volatile unsigned int        DCH3DSIZ __attribute__((section("sfrs")));
typedef struct {
  unsigned CHDSIZ:16;
} __DCH3DSIZbits_t;
extern volatile __DCH3DSIZbits_t DCH3DSIZbits __asm__ ("DCH3DSIZ") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH3DSIZCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH3DSIZSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH3DSIZINV __attribute__((section("sfrs")));
extern volatile unsigned int        DCH3SPTR __attribute__((section("sfrs")));
typedef struct {
  unsigned CHSPTR:16;
} __DCH3SPTRbits_t;
extern volatile __DCH3SPTRbits_t DCH3SPTRbits __asm__ ("DCH3SPTR") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH3SPTRCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH3SPTRSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH3SPTRINV __attribute__((section("sfrs")));
extern volatile unsigned int        DCH3DPTR __attribute__((section("sfrs")));
typedef struct {
  unsigned CHDPTR:16;
} __DCH3DPTRbits_t;
extern volatile __DCH3DPTRbits_t DCH3DPTRbits __asm__ ("DCH3DPTR") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH3DPTRCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH3DPTRSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH3DPTRINV __attribute__((section("sfrs")));
extern volatile unsigned int        DCH3CSIZ __attribute__((section("sfrs")));
typedef struct {
  unsigned CHCSIZ:16;
} __DCH3CSIZbits_t;
extern volatile __DCH3CSIZbits_t DCH3CSIZbits __asm__ ("DCH3CSIZ") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH3CSIZCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH3CSIZSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH3CSIZINV __attribute__((section("sfrs")));
extern volatile unsigned int        DCS3CPTR __attribute__((section("sfrs")));
typedef struct {
  unsigned CHCPTR:16;
} __DCS3CPTRbits_t;
extern volatile __DCS3CPTRbits_t DCS3CPTRbits __asm__ ("DCS3CPTR") __attribute__((section("sfrs")));
extern volatile unsigned int        DCS3CPTRCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCS3CPTRSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCS3CPTRINV __attribute__((section("sfrs")));
extern volatile unsigned int        DCH3DAT __attribute__((section("sfrs")));
typedef struct {
  unsigned CHPDAT:16;
} __DCH3DATbits_t;
extern volatile __DCH3DATbits_t DCH3DATbits __asm__ ("DCH3DAT") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH3DATCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH3DATSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH3DATINV __attribute__((section("sfrs")));
extern volatile unsigned int        DCH4CON __attribute__((section("sfrs")));
typedef struct {
  unsigned CHPRI:2;
  unsigned CHEDET:1;
  unsigned :1;
  unsigned CHAEN:1;
  unsigned CHCHN:1;
  unsigned CHAED:1;
  unsigned CHEN:1;
  unsigned CHCHNS:1;
  unsigned :2;
  unsigned CHPATLEN:1;
  unsigned :1;
  unsigned CHPIGNEN:1;
  unsigned :1;
  unsigned CHBUSY:1;
  unsigned :8;
  unsigned CHPIGN:8;
} __DCH4CONbits_t;
extern volatile __DCH4CONbits_t DCH4CONbits __asm__ ("DCH4CON") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH4CONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH4CONSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH4CONINV __attribute__((section("sfrs")));
extern volatile unsigned int        DCH4ECON __attribute__((section("sfrs")));
typedef struct {
  unsigned :3;
  unsigned AIRQEN:1;
  unsigned SIRQEN:1;
  unsigned PATEN:1;
  unsigned CABORT:1;
  unsigned CFORCE:1;
  unsigned CHSIRQ:8;
  unsigned CHAIRQ:8;
} __DCH4ECONbits_t;
extern volatile __DCH4ECONbits_t DCH4ECONbits __asm__ ("DCH4ECON") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH4ECONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH4ECONSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH4ECONINV __attribute__((section("sfrs")));
extern volatile unsigned int        DCH4INT __attribute__((section("sfrs")));
typedef struct {
  unsigned CHERIF:1;
  unsigned CHTAIF:1;
  unsigned CHCCIF:1;
  unsigned CHBCIF:1;
  unsigned CHDHIF:1;
  unsigned CHDDIF:1;
  unsigned CHSHIF:1;
  unsigned CHSDIF:1;
  unsigned :8;
  unsigned CHERIE:1;
  unsigned CHTAIE:1;
  unsigned CHCCIE:1;
  unsigned CHBCIE:1;
  unsigned CHDHIE:1;
  unsigned CHDDIE:1;
  unsigned CHSHIE:1;
  unsigned CHSDIE:1;
} __DCH4INTbits_t;
extern volatile __DCH4INTbits_t DCH4INTbits __asm__ ("DCH4INT") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH4INTCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH4INTSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH4INTINV __attribute__((section("sfrs")));
extern volatile unsigned int        DCH4SSA __attribute__((section("sfrs")));
typedef struct {
  unsigned CHSSA:32;
} __DCH4SSAbits_t;
extern volatile __DCH4SSAbits_t DCH4SSAbits __asm__ ("DCH4SSA") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH4SSACLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH4SSASET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH4SSAINV __attribute__((section("sfrs")));
extern volatile unsigned int        DCH4DSA __attribute__((section("sfrs")));
typedef struct {
  unsigned CHDSA:32;
} __DCH4DSAbits_t;
extern volatile __DCH4DSAbits_t DCH4DSAbits __asm__ ("DCH4DSA") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH4DSACLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH4DSASET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH4DSAINV __attribute__((section("sfrs")));
extern volatile unsigned int        DCH4SSIZ __attribute__((section("sfrs")));
typedef struct {
  unsigned CHSSIZ:16;
} __DCH4SSIZbits_t;
extern volatile __DCH4SSIZbits_t DCH4SSIZbits __asm__ ("DCH4SSIZ") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH4SSIZCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH4SSIZSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH4SSIZINV __attribute__((section("sfrs")));
extern volatile unsigned int        DCH4DSIZ __attribute__((section("sfrs")));
typedef struct {
  unsigned CHDSIZ:16;
} __DCH4DSIZbits_t;
extern volatile __DCH4DSIZbits_t DCH4DSIZbits __asm__ ("DCH4DSIZ") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH4DSIZCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH4DSIZSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH4DSIZINV __attribute__((section("sfrs")));
extern volatile unsigned int        DCH4SPTR __attribute__((section("sfrs")));
typedef struct {
  unsigned CHSPTR:16;
} __DCH4SPTRbits_t;
extern volatile __DCH4SPTRbits_t DCH4SPTRbits __asm__ ("DCH4SPTR") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH4SPTRCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH4SPTRSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH4SPTRINV __attribute__((section("sfrs")));
extern volatile unsigned int        DCH4DPTR __attribute__((section("sfrs")));
typedef struct {
  unsigned CHDPTR:16;
} __DCH4DPTRbits_t;
extern volatile __DCH4DPTRbits_t DCH4DPTRbits __asm__ ("DCH4DPTR") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH4DPTRCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH4DPTRSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH4DPTRINV __attribute__((section("sfrs")));
extern volatile unsigned int        DCH4CSIZ __attribute__((section("sfrs")));
typedef struct {
  unsigned CHCSIZ:16;
} __DCH4CSIZbits_t;
extern volatile __DCH4CSIZbits_t DCH4CSIZbits __asm__ ("DCH4CSIZ") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH4CSIZCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH4CSIZSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH4CSIZINV __attribute__((section("sfrs")));
extern volatile unsigned int        DCS4CPTR __attribute__((section("sfrs")));
typedef struct {
  unsigned CHCPTR:16;
} __DCS4CPTRbits_t;
extern volatile __DCS4CPTRbits_t DCS4CPTRbits __asm__ ("DCS4CPTR") __attribute__((section("sfrs")));
extern volatile unsigned int        DCS4CPTRCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCS4CPTRSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCS4CPTRINV __attribute__((section("sfrs")));
extern volatile unsigned int        DCH4DAT __attribute__((section("sfrs")));
typedef struct {
  unsigned CHPDAT:16;
} __DCH4DATbits_t;
extern volatile __DCH4DATbits_t DCH4DATbits __asm__ ("DCH4DAT") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH4DATCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH4DATSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH4DATINV __attribute__((section("sfrs")));
extern volatile unsigned int        DCH5CON __attribute__((section("sfrs")));
typedef struct {
  unsigned CHPRI:2;
  unsigned CHEDET:1;
  unsigned :1;
  unsigned CHAEN:1;
  unsigned CHCHN:1;
  unsigned CHAED:1;
  unsigned CHEN:1;
  unsigned CHCHNS:1;
  unsigned :2;
  unsigned CHPATLEN:1;
  unsigned :1;
  unsigned CHPIGNEN:1;
  unsigned :1;
  unsigned CHBUSY:1;
  unsigned :8;
  unsigned CHPIGN:8;
} __DCH5CONbits_t;
extern volatile __DCH5CONbits_t DCH5CONbits __asm__ ("DCH5CON") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH5CONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH5CONSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH5CONINV __attribute__((section("sfrs")));
extern volatile unsigned int        DCH5ECON __attribute__((section("sfrs")));
typedef struct {
  unsigned :3;
  unsigned AIRQEN:1;
  unsigned SIRQEN:1;
  unsigned PATEN:1;
  unsigned CABORT:1;
  unsigned CFORCE:1;
  unsigned CHSIRQ:8;
  unsigned CHAIRQ:8;
} __DCH5ECONbits_t;
extern volatile __DCH5ECONbits_t DCH5ECONbits __asm__ ("DCH5ECON") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH5ECONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH5ECONSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH5ECONINV __attribute__((section("sfrs")));
extern volatile unsigned int        DCH5INT __attribute__((section("sfrs")));
typedef struct {
  unsigned CHERIF:1;
  unsigned CHTAIF:1;
  unsigned CHCCIF:1;
  unsigned CHBCIF:1;
  unsigned CHDHIF:1;
  unsigned CHDDIF:1;
  unsigned CHSHIF:1;
  unsigned CHSDIF:1;
  unsigned :8;
  unsigned CHERIE:1;
  unsigned CHTAIE:1;
  unsigned CHCCIE:1;
  unsigned CHBCIE:1;
  unsigned CHDHIE:1;
  unsigned CHDDIE:1;
  unsigned CHSHIE:1;
  unsigned CHSDIE:1;
} __DCH5INTbits_t;
extern volatile __DCH5INTbits_t DCH5INTbits __asm__ ("DCH5INT") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH5INTCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH5INTSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH5INTINV __attribute__((section("sfrs")));
extern volatile unsigned int        DCH5SSA __attribute__((section("sfrs")));
typedef struct {
  unsigned CHSSA:32;
} __DCH5SSAbits_t;
extern volatile __DCH5SSAbits_t DCH5SSAbits __asm__ ("DCH5SSA") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH5SSACLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH5SSASET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH5SSAINV __attribute__((section("sfrs")));
extern volatile unsigned int        DCH5DSA __attribute__((section("sfrs")));
typedef struct {
  unsigned CHDSA:32;
} __DCH5DSAbits_t;
extern volatile __DCH5DSAbits_t DCH5DSAbits __asm__ ("DCH5DSA") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH5DSACLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH5DSASET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH5DSAINV __attribute__((section("sfrs")));
extern volatile unsigned int        DCH5SSIZ __attribute__((section("sfrs")));
typedef struct {
  unsigned CHSSIZ:16;
} __DCH5SSIZbits_t;
extern volatile __DCH5SSIZbits_t DCH5SSIZbits __asm__ ("DCH5SSIZ") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH5SSIZCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH5SSIZSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH5SSIZINV __attribute__((section("sfrs")));
extern volatile unsigned int        DCH5DSIZ __attribute__((section("sfrs")));
typedef struct {
  unsigned CHDSIZ:16;
} __DCH5DSIZbits_t;
extern volatile __DCH5DSIZbits_t DCH5DSIZbits __asm__ ("DCH5DSIZ") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH5DSIZCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH5DSIZSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH5DSIZINV __attribute__((section("sfrs")));
extern volatile unsigned int        DCH5SPTR __attribute__((section("sfrs")));
typedef struct {
  unsigned CHSPTR:16;
} __DCH5SPTRbits_t;
extern volatile __DCH5SPTRbits_t DCH5SPTRbits __asm__ ("DCH5SPTR") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH5SPTRCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH5SPTRSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH5SPTRINV __attribute__((section("sfrs")));
extern volatile unsigned int        DCH5DPTR __attribute__((section("sfrs")));
typedef struct {
  unsigned CHDPTR:16;
} __DCH5DPTRbits_t;
extern volatile __DCH5DPTRbits_t DCH5DPTRbits __asm__ ("DCH5DPTR") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH5DPTRCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH5DPTRSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH5DPTRINV __attribute__((section("sfrs")));
extern volatile unsigned int        DCH5CSIZ __attribute__((section("sfrs")));
typedef struct {
  unsigned CHCSIZ:16;
} __DCH5CSIZbits_t;
extern volatile __DCH5CSIZbits_t DCH5CSIZbits __asm__ ("DCH5CSIZ") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH5CSIZCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH5CSIZSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH5CSIZINV __attribute__((section("sfrs")));
extern volatile unsigned int        DCS5CPTR __attribute__((section("sfrs")));
typedef struct {
  unsigned CHCPTR:16;
} __DCS5CPTRbits_t;
extern volatile __DCS5CPTRbits_t DCS5CPTRbits __asm__ ("DCS5CPTR") __attribute__((section("sfrs")));
extern volatile unsigned int        DCS5CPTRCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCS5CPTRSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCS5CPTRINV __attribute__((section("sfrs")));
extern volatile unsigned int        DCH5DAT __attribute__((section("sfrs")));
typedef struct {
  unsigned CHPDAT:16;
} __DCH5DATbits_t;
extern volatile __DCH5DATbits_t DCH5DATbits __asm__ ("DCH5DAT") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH5DATCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH5DATSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH5DATINV __attribute__((section("sfrs")));
extern volatile unsigned int        DCH6CON __attribute__((section("sfrs")));
typedef struct {
  unsigned CHPRI:2;
  unsigned CHEDET:1;
  unsigned :1;
  unsigned CHAEN:1;
  unsigned CHCHN:1;
  unsigned CHAED:1;
  unsigned CHEN:1;
  unsigned CHCHNS:1;
  unsigned :2;
  unsigned CHPATLEN:1;
  unsigned :1;
  unsigned CHPIGNEN:1;
  unsigned :1;
  unsigned CHBUSY:1;
  unsigned :8;
  unsigned CHPIGN:8;
} __DCH6CONbits_t;
extern volatile __DCH6CONbits_t DCH6CONbits __asm__ ("DCH6CON") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH6CONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH6CONSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH6CONINV __attribute__((section("sfrs")));
extern volatile unsigned int        DCH6ECON __attribute__((section("sfrs")));
typedef struct {
  unsigned :3;
  unsigned AIRQEN:1;
  unsigned SIRQEN:1;
  unsigned PATEN:1;
  unsigned CABORT:1;
  unsigned CFORCE:1;
  unsigned CHSIRQ:8;
  unsigned CHAIRQ:8;
} __DCH6ECONbits_t;
extern volatile __DCH6ECONbits_t DCH6ECONbits __asm__ ("DCH6ECON") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH6ECONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH6ECONSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH6ECONINV __attribute__((section("sfrs")));
extern volatile unsigned int        DCH6INT __attribute__((section("sfrs")));
typedef struct {
  unsigned CHERIF:1;
  unsigned CHTAIF:1;
  unsigned CHCCIF:1;
  unsigned CHBCIF:1;
  unsigned CHDHIF:1;
  unsigned CHDDIF:1;
  unsigned CHSHIF:1;
  unsigned CHSDIF:1;
  unsigned :8;
  unsigned CHERIE:1;
  unsigned CHTAIE:1;
  unsigned CHCCIE:1;
  unsigned CHBCIE:1;
  unsigned CHDHIE:1;
  unsigned CHDDIE:1;
  unsigned CHSHIE:1;
  unsigned CHSDIE:1;
} __DCH6INTbits_t;
extern volatile __DCH6INTbits_t DCH6INTbits __asm__ ("DCH6INT") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH6INTCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH6INTSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH6INTINV __attribute__((section("sfrs")));
extern volatile unsigned int        DCH6SSA __attribute__((section("sfrs")));
typedef struct {
  unsigned CHSSA:32;
} __DCH6SSAbits_t;
extern volatile __DCH6SSAbits_t DCH6SSAbits __asm__ ("DCH6SSA") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH6SSACLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH6SSASET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH6SSAINV __attribute__((section("sfrs")));
extern volatile unsigned int        DCH6DSA __attribute__((section("sfrs")));
typedef struct {
  unsigned CHDSA:32;
} __DCH6DSAbits_t;
extern volatile __DCH6DSAbits_t DCH6DSAbits __asm__ ("DCH6DSA") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH6DSACLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH6DSASET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH6DSAINV __attribute__((section("sfrs")));
extern volatile unsigned int        DCH6SSIZ __attribute__((section("sfrs")));
typedef struct {
  unsigned CHSSIZ:16;
} __DCH6SSIZbits_t;
extern volatile __DCH6SSIZbits_t DCH6SSIZbits __asm__ ("DCH6SSIZ") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH6SSIZCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH6SSIZSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH6SSIZINV __attribute__((section("sfrs")));
extern volatile unsigned int        DCH6DSIZ __attribute__((section("sfrs")));
typedef struct {
  unsigned CHDSIZ:16;
} __DCH6DSIZbits_t;
extern volatile __DCH6DSIZbits_t DCH6DSIZbits __asm__ ("DCH6DSIZ") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH6DSIZCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH6DSIZSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH6DSIZINV __attribute__((section("sfrs")));
extern volatile unsigned int        DCH6SPTR __attribute__((section("sfrs")));
typedef struct {
  unsigned CHSPTR:16;
} __DCH6SPTRbits_t;
extern volatile __DCH6SPTRbits_t DCH6SPTRbits __asm__ ("DCH6SPTR") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH6SPTRCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH6SPTRSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH6SPTRINV __attribute__((section("sfrs")));
extern volatile unsigned int        DCH6DPTR __attribute__((section("sfrs")));
typedef struct {
  unsigned CHDPTR:16;
} __DCH6DPTRbits_t;
extern volatile __DCH6DPTRbits_t DCH6DPTRbits __asm__ ("DCH6DPTR") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH6DPTRCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH6DPTRSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH6DPTRINV __attribute__((section("sfrs")));
extern volatile unsigned int        DCH6CSIZ __attribute__((section("sfrs")));
typedef struct {
  unsigned CHCSIZ:16;
} __DCH6CSIZbits_t;
extern volatile __DCH6CSIZbits_t DCH6CSIZbits __asm__ ("DCH6CSIZ") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH6CSIZCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH6CSIZSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH6CSIZINV __attribute__((section("sfrs")));
extern volatile unsigned int        DCS6CPTR __attribute__((section("sfrs")));
typedef struct {
  unsigned CHCPTR:16;
} __DCS6CPTRbits_t;
extern volatile __DCS6CPTRbits_t DCS6CPTRbits __asm__ ("DCS6CPTR") __attribute__((section("sfrs")));
extern volatile unsigned int        DCS6CPTRCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCS6CPTRSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCS6CPTRINV __attribute__((section("sfrs")));
extern volatile unsigned int        DCH6DAT __attribute__((section("sfrs")));
typedef struct {
  unsigned CHPDAT:16;
} __DCH6DATbits_t;
extern volatile __DCH6DATbits_t DCH6DATbits __asm__ ("DCH6DAT") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH6DATCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH6DATSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH6DATINV __attribute__((section("sfrs")));
extern volatile unsigned int        DCH7CON __attribute__((section("sfrs")));
typedef struct {
  unsigned CHPRI:2;
  unsigned CHEDET:1;
  unsigned :1;
  unsigned CHAEN:1;
  unsigned CHCHN:1;
  unsigned CHAED:1;
  unsigned CHEN:1;
  unsigned CHCHNS:1;
  unsigned :2;
  unsigned CHPATLEN:1;
  unsigned :1;
  unsigned CHPIGNEN:1;
  unsigned :1;
  unsigned CHBUSY:1;
  unsigned :8;
  unsigned CHPIGN:8;
} __DCH7CONbits_t;
extern volatile __DCH7CONbits_t DCH7CONbits __asm__ ("DCH7CON") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH7CONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH7CONSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH7CONINV __attribute__((section("sfrs")));
extern volatile unsigned int        DCH7ECON __attribute__((section("sfrs")));
typedef struct {
  unsigned :3;
  unsigned AIRQEN:1;
  unsigned SIRQEN:1;
  unsigned PATEN:1;
  unsigned CABORT:1;
  unsigned CFORCE:1;
  unsigned CHSIRQ:8;
  unsigned CHAIRQ:8;
} __DCH7ECONbits_t;
extern volatile __DCH7ECONbits_t DCH7ECONbits __asm__ ("DCH7ECON") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH7ECONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH7ECONSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH7ECONINV __attribute__((section("sfrs")));
extern volatile unsigned int        DCH7INT __attribute__((section("sfrs")));
typedef struct {
  unsigned CHERIF:1;
  unsigned CHTAIF:1;
  unsigned CHCCIF:1;
  unsigned CHBCIF:1;
  unsigned CHDHIF:1;
  unsigned CHDDIF:1;
  unsigned CHSHIF:1;
  unsigned CHSDIF:1;
  unsigned :8;
  unsigned CHERIE:1;
  unsigned CHTAIE:1;
  unsigned CHCCIE:1;
  unsigned CHBCIE:1;
  unsigned CHDHIE:1;
  unsigned CHDDIE:1;
  unsigned CHSHIE:1;
  unsigned CHSDIE:1;
} __DCH7INTbits_t;
extern volatile __DCH7INTbits_t DCH7INTbits __asm__ ("DCH7INT") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH7INTCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH7INTSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH7INTINV __attribute__((section("sfrs")));
extern volatile unsigned int        DCH7SSA __attribute__((section("sfrs")));
typedef struct {
  unsigned CHSSA:32;
} __DCH7SSAbits_t;
extern volatile __DCH7SSAbits_t DCH7SSAbits __asm__ ("DCH7SSA") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH7SSACLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH7SSASET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH7SSAINV __attribute__((section("sfrs")));
extern volatile unsigned int        DCH7DSA __attribute__((section("sfrs")));
typedef struct {
  unsigned CHDSA:32;
} __DCH7DSAbits_t;
extern volatile __DCH7DSAbits_t DCH7DSAbits __asm__ ("DCH7DSA") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH7DSACLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH7DSASET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH7DSAINV __attribute__((section("sfrs")));
extern volatile unsigned int        DCH7SSIZ __attribute__((section("sfrs")));
typedef struct {
  unsigned CHSSIZ:16;
} __DCH7SSIZbits_t;
extern volatile __DCH7SSIZbits_t DCH7SSIZbits __asm__ ("DCH7SSIZ") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH7SSIZCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH7SSIZSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH7SSIZINV __attribute__((section("sfrs")));
extern volatile unsigned int        DCH7DSIZ __attribute__((section("sfrs")));
typedef struct {
  unsigned CHDSIZ:16;
} __DCH7DSIZbits_t;
extern volatile __DCH7DSIZbits_t DCH7DSIZbits __asm__ ("DCH7DSIZ") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH7DSIZCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH7DSIZSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH7DSIZINV __attribute__((section("sfrs")));
extern volatile unsigned int        DCH7SPTR __attribute__((section("sfrs")));
typedef struct {
  unsigned CHSPTR:16;
} __DCH7SPTRbits_t;
extern volatile __DCH7SPTRbits_t DCH7SPTRbits __asm__ ("DCH7SPTR") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH7SPTRCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH7SPTRSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH7SPTRINV __attribute__((section("sfrs")));
extern volatile unsigned int        DCH7DPTR __attribute__((section("sfrs")));
typedef struct {
  unsigned CHDPTR:16;
} __DCH7DPTRbits_t;
extern volatile __DCH7DPTRbits_t DCH7DPTRbits __asm__ ("DCH7DPTR") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH7DPTRCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH7DPTRSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH7DPTRINV __attribute__((section("sfrs")));
extern volatile unsigned int        DCH7CSIZ __attribute__((section("sfrs")));
typedef struct {
  unsigned CHCSIZ:16;
} __DCH7CSIZbits_t;
extern volatile __DCH7CSIZbits_t DCH7CSIZbits __asm__ ("DCH7CSIZ") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH7CSIZCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH7CSIZSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH7CSIZINV __attribute__((section("sfrs")));
extern volatile unsigned int        DCS7CPTR __attribute__((section("sfrs")));
typedef struct {
  unsigned CHCPTR:16;
} __DCS7CPTRbits_t;
extern volatile __DCS7CPTRbits_t DCS7CPTRbits __asm__ ("DCS7CPTR") __attribute__((section("sfrs")));
extern volatile unsigned int        DCS7CPTRCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCS7CPTRSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCS7CPTRINV __attribute__((section("sfrs")));
extern volatile unsigned int        DCH7DAT __attribute__((section("sfrs")));
typedef struct {
  unsigned CHPDAT:16;
} __DCH7DATbits_t;
extern volatile __DCH7DATbits_t DCH7DATbits __asm__ ("DCH7DAT") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH7DATCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH7DATSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH7DATINV __attribute__((section("sfrs")));
extern volatile unsigned int        I2C1CON __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned SEN:1;
    unsigned RSEN:1;
    unsigned PEN:1;
    unsigned RCEN:1;
    unsigned ACKEN:1;
    unsigned ACKDT:1;
    unsigned STREN:1;
    unsigned GCEN:1;
    unsigned SMEN:1;
    unsigned DISSLW:1;
    unsigned A10M:1;
    unsigned STRICT:1;
    unsigned SCLREL:1;
    unsigned SIDL:1;
    unsigned :1;
    unsigned ON:1;
    unsigned DHEN:1;
    unsigned AHEN:1;
    unsigned SBCDE:1;
    unsigned SDAHT:1;
    unsigned BOEN:1;
    unsigned SCIE:1;
    unsigned PCIE:1;
  };
  struct {
    unsigned :11;
    unsigned IPMIEN:1;
    unsigned :1;
    unsigned I2CSIDL:1;
    unsigned :1;
    unsigned I2CEN:1;
  };
} __I2C1CONbits_t;
extern volatile __I2C1CONbits_t I2C1CONbits __asm__ ("I2C1CON") __attribute__((section("sfrs")));
extern volatile unsigned int        I2C1CONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        I2C1CONSET __attribute__((section("sfrs")));
extern volatile unsigned int        I2C1CONINV __attribute__((section("sfrs")));
extern volatile unsigned int        I2C1STAT __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TBF:1;
    unsigned RBF:1;
    unsigned R_W:1;
    unsigned S:1;
    unsigned P:1;
    unsigned D_A:1;
    unsigned I2COV:1;
    unsigned IWCOL:1;
    unsigned ADD10:1;
    unsigned GCSTAT:1;
    unsigned BCL:1;
    unsigned :2;
    unsigned ACKTIM:1;
    unsigned TRSTAT:1;
    unsigned ACKSTAT:1;
  };
  struct {
    unsigned :6;
    unsigned I2CPOV:1;
  };
} __I2C1STATbits_t;
extern volatile __I2C1STATbits_t I2C1STATbits __asm__ ("I2C1STAT") __attribute__((section("sfrs")));
extern volatile unsigned int        I2C1STATCLR __attribute__((section("sfrs")));
extern volatile unsigned int        I2C1STATSET __attribute__((section("sfrs")));
extern volatile unsigned int        I2C1STATINV __attribute__((section("sfrs")));
extern volatile unsigned int        I2C1ADD __attribute__((section("sfrs")));
typedef struct {
  unsigned I2CADD:10;
} __I2C1ADDbits_t;
extern volatile __I2C1ADDbits_t I2C1ADDbits __asm__ ("I2C1ADD") __attribute__((section("sfrs")));
extern volatile unsigned int        I2C1ADDCLR __attribute__((section("sfrs")));
extern volatile unsigned int        I2C1ADDSET __attribute__((section("sfrs")));
extern volatile unsigned int        I2C1ADDINV __attribute__((section("sfrs")));
extern volatile unsigned int        I2C1MSK __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned I2CMSK:10;
  };
  struct {
    unsigned AMSK:10;
  };
} __I2C1MSKbits_t;
extern volatile __I2C1MSKbits_t I2C1MSKbits __asm__ ("I2C1MSK") __attribute__((section("sfrs")));
extern volatile unsigned int        I2C1MSKCLR __attribute__((section("sfrs")));
extern volatile unsigned int        I2C1MSKSET __attribute__((section("sfrs")));
extern volatile unsigned int        I2C1MSKINV __attribute__((section("sfrs")));
extern volatile unsigned int        I2C1BRG __attribute__((section("sfrs")));
typedef struct {
  unsigned I2CBRG:16;
} __I2C1BRGbits_t;
extern volatile __I2C1BRGbits_t I2C1BRGbits __asm__ ("I2C1BRG") __attribute__((section("sfrs")));
extern volatile unsigned int        I2C1BRGCLR __attribute__((section("sfrs")));
extern volatile unsigned int        I2C1BRGSET __attribute__((section("sfrs")));
extern volatile unsigned int        I2C1BRGINV __attribute__((section("sfrs")));
extern volatile unsigned int        I2C1TRN __attribute__((section("sfrs")));
typedef struct {
  unsigned I2CTRN:8;
} __I2C1TRNbits_t;
extern volatile __I2C1TRNbits_t I2C1TRNbits __asm__ ("I2C1TRN") __attribute__((section("sfrs")));
extern volatile unsigned int        I2C1TRNCLR __attribute__((section("sfrs")));
extern volatile unsigned int        I2C1TRNSET __attribute__((section("sfrs")));
extern volatile unsigned int        I2C1TRNINV __attribute__((section("sfrs")));
extern volatile unsigned int        I2C1RCV __attribute__((section("sfrs")));
typedef struct {
  unsigned I2CRCV:8;
} __I2C1RCVbits_t;
extern volatile __I2C1RCVbits_t I2C1RCVbits __asm__ ("I2C1RCV") __attribute__((section("sfrs")));
extern volatile unsigned int        I2C1RCVCLR __attribute__((section("sfrs")));
extern volatile unsigned int        I2C1RCVSET __attribute__((section("sfrs")));
extern volatile unsigned int        I2C1RCVINV __attribute__((section("sfrs")));
extern volatile unsigned int        I2C2CON __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned SEN:1;
    unsigned RSEN:1;
    unsigned PEN:1;
    unsigned RCEN:1;
    unsigned ACKEN:1;
    unsigned ACKDT:1;
    unsigned STREN:1;
    unsigned GCEN:1;
    unsigned SMEN:1;
    unsigned DISSLW:1;
    unsigned A10M:1;
    unsigned STRICT:1;
    unsigned SCLREL:1;
    unsigned SIDL:1;
    unsigned :1;
    unsigned ON:1;
    unsigned DHEN:1;
    unsigned AHEN:1;
    unsigned SBCDE:1;
    unsigned SDAHT:1;
    unsigned BOEN:1;
    unsigned SCIE:1;
    unsigned PCIE:1;
  };
  struct {
    unsigned :11;
    unsigned IPMIEN:1;
    unsigned :1;
    unsigned I2CSIDL:1;
    unsigned :1;
    unsigned I2CEN:1;
  };
} __I2C2CONbits_t;
extern volatile __I2C2CONbits_t I2C2CONbits __asm__ ("I2C2CON") __attribute__((section("sfrs")));
extern volatile unsigned int        I2C2CONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        I2C2CONSET __attribute__((section("sfrs")));
extern volatile unsigned int        I2C2CONINV __attribute__((section("sfrs")));
extern volatile unsigned int        I2C2STAT __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TBF:1;
    unsigned RBF:1;
    unsigned R_W:1;
    unsigned S:1;
    unsigned P:1;
    unsigned D_A:1;
    unsigned I2COV:1;
    unsigned IWCOL:1;
    unsigned ADD10:1;
    unsigned GCSTAT:1;
    unsigned BCL:1;
    unsigned :2;
    unsigned ACKTIM:1;
    unsigned TRSTAT:1;
    unsigned ACKSTAT:1;
  };
  struct {
    unsigned :6;
    unsigned I2CPOV:1;
  };
} __I2C2STATbits_t;
extern volatile __I2C2STATbits_t I2C2STATbits __asm__ ("I2C2STAT") __attribute__((section("sfrs")));
extern volatile unsigned int        I2C2STATCLR __attribute__((section("sfrs")));
extern volatile unsigned int        I2C2STATSET __attribute__((section("sfrs")));
extern volatile unsigned int        I2C2STATINV __attribute__((section("sfrs")));
extern volatile unsigned int        I2C2ADD __attribute__((section("sfrs")));
typedef struct {
  unsigned I2CADD:10;
} __I2C2ADDbits_t;
extern volatile __I2C2ADDbits_t I2C2ADDbits __asm__ ("I2C2ADD") __attribute__((section("sfrs")));
extern volatile unsigned int        I2C2ADDCLR __attribute__((section("sfrs")));
extern volatile unsigned int        I2C2ADDSET __attribute__((section("sfrs")));
extern volatile unsigned int        I2C2ADDINV __attribute__((section("sfrs")));
extern volatile unsigned int        I2C2MSK __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned I2CMSK:10;
  };
  struct {
    unsigned AMSK:10;
  };
} __I2C2MSKbits_t;
extern volatile __I2C2MSKbits_t I2C2MSKbits __asm__ ("I2C2MSK") __attribute__((section("sfrs")));
extern volatile unsigned int        I2C2MSKCLR __attribute__((section("sfrs")));
extern volatile unsigned int        I2C2MSKSET __attribute__((section("sfrs")));
extern volatile unsigned int        I2C2MSKINV __attribute__((section("sfrs")));
extern volatile unsigned int        I2C2BRG __attribute__((section("sfrs")));
typedef struct {
  unsigned I2CBRG:16;
} __I2C2BRGbits_t;
extern volatile __I2C2BRGbits_t I2C2BRGbits __asm__ ("I2C2BRG") __attribute__((section("sfrs")));
extern volatile unsigned int        I2C2BRGCLR __attribute__((section("sfrs")));
extern volatile unsigned int        I2C2BRGSET __attribute__((section("sfrs")));
extern volatile unsigned int        I2C2BRGINV __attribute__((section("sfrs")));
extern volatile unsigned int        I2C2TRN __attribute__((section("sfrs")));
typedef struct {
  unsigned I2CTRN:8;
} __I2C2TRNbits_t;
extern volatile __I2C2TRNbits_t I2C2TRNbits __asm__ ("I2C2TRN") __attribute__((section("sfrs")));
extern volatile unsigned int        I2C2TRNCLR __attribute__((section("sfrs")));
extern volatile unsigned int        I2C2TRNSET __attribute__((section("sfrs")));
extern volatile unsigned int        I2C2TRNINV __attribute__((section("sfrs")));
extern volatile unsigned int        I2C2RCV __attribute__((section("sfrs")));
typedef struct {
  unsigned I2CRCV:8;
} __I2C2RCVbits_t;
extern volatile __I2C2RCVbits_t I2C2RCVbits __asm__ ("I2C2RCV") __attribute__((section("sfrs")));
extern volatile unsigned int        I2C2RCVCLR __attribute__((section("sfrs")));
extern volatile unsigned int        I2C2RCVSET __attribute__((section("sfrs")));
extern volatile unsigned int        I2C2RCVINV __attribute__((section("sfrs")));
extern volatile unsigned int        I2C3CON __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned SEN:1;
    unsigned RSEN:1;
    unsigned PEN:1;
    unsigned RCEN:1;
    unsigned ACKEN:1;
    unsigned ACKDT:1;
    unsigned STREN:1;
    unsigned GCEN:1;
    unsigned SMEN:1;
    unsigned DISSLW:1;
    unsigned A10M:1;
    unsigned STRICT:1;
    unsigned SCLREL:1;
    unsigned SIDL:1;
    unsigned :1;
    unsigned ON:1;
    unsigned DHEN:1;
    unsigned AHEN:1;
    unsigned SBCDE:1;
    unsigned SDAHT:1;
    unsigned BOEN:1;
    unsigned SCIE:1;
    unsigned PCIE:1;
  };
  struct {
    unsigned :11;
    unsigned IPMIEN:1;
    unsigned :1;
    unsigned I2CSIDL:1;
    unsigned :1;
    unsigned I2CEN:1;
  };
} __I2C3CONbits_t;
extern volatile __I2C3CONbits_t I2C3CONbits __asm__ ("I2C3CON") __attribute__((section("sfrs")));
extern volatile unsigned int        I2C3CONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        I2C3CONSET __attribute__((section("sfrs")));
extern volatile unsigned int        I2C3CONINV __attribute__((section("sfrs")));
extern volatile unsigned int        I2C3STAT __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TBF:1;
    unsigned RBF:1;
    unsigned R_W:1;
    unsigned S:1;
    unsigned P:1;
    unsigned D_A:1;
    unsigned I2COV:1;
    unsigned IWCOL:1;
    unsigned ADD10:1;
    unsigned GCSTAT:1;
    unsigned BCL:1;
    unsigned :2;
    unsigned ACKTIM:1;
    unsigned TRSTAT:1;
    unsigned ACKSTAT:1;
  };
  struct {
    unsigned :6;
    unsigned I2CPOV:1;
  };
} __I2C3STATbits_t;
extern volatile __I2C3STATbits_t I2C3STATbits __asm__ ("I2C3STAT") __attribute__((section("sfrs")));
extern volatile unsigned int        I2C3STATCLR __attribute__((section("sfrs")));
extern volatile unsigned int        I2C3STATSET __attribute__((section("sfrs")));
extern volatile unsigned int        I2C3STATINV __attribute__((section("sfrs")));
extern volatile unsigned int        I2C3ADD __attribute__((section("sfrs")));
typedef struct {
  unsigned I2CADD:10;
} __I2C3ADDbits_t;
extern volatile __I2C3ADDbits_t I2C3ADDbits __asm__ ("I2C3ADD") __attribute__((section("sfrs")));
extern volatile unsigned int        I2C3ADDCLR __attribute__((section("sfrs")));
extern volatile unsigned int        I2C3ADDSET __attribute__((section("sfrs")));
extern volatile unsigned int        I2C3ADDINV __attribute__((section("sfrs")));
extern volatile unsigned int        I2C3MSK __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned I2CMSK:10;
  };
  struct {
    unsigned AMSK:10;
  };
} __I2C3MSKbits_t;
extern volatile __I2C3MSKbits_t I2C3MSKbits __asm__ ("I2C3MSK") __attribute__((section("sfrs")));
extern volatile unsigned int        I2C3MSKCLR __attribute__((section("sfrs")));
extern volatile unsigned int        I2C3MSKSET __attribute__((section("sfrs")));
extern volatile unsigned int        I2C3MSKINV __attribute__((section("sfrs")));
extern volatile unsigned int        I2C3BRG __attribute__((section("sfrs")));
typedef struct {
  unsigned I2CBRG:16;
} __I2C3BRGbits_t;
extern volatile __I2C3BRGbits_t I2C3BRGbits __asm__ ("I2C3BRG") __attribute__((section("sfrs")));
extern volatile unsigned int        I2C3BRGCLR __attribute__((section("sfrs")));
extern volatile unsigned int        I2C3BRGSET __attribute__((section("sfrs")));
extern volatile unsigned int        I2C3BRGINV __attribute__((section("sfrs")));
extern volatile unsigned int        I2C3TRN __attribute__((section("sfrs")));
typedef struct {
  unsigned I2CTRN:8;
} __I2C3TRNbits_t;
extern volatile __I2C3TRNbits_t I2C3TRNbits __asm__ ("I2C3TRN") __attribute__((section("sfrs")));
extern volatile unsigned int        I2C3TRNCLR __attribute__((section("sfrs")));
extern volatile unsigned int        I2C3TRNSET __attribute__((section("sfrs")));
extern volatile unsigned int        I2C3TRNINV __attribute__((section("sfrs")));
extern volatile unsigned int        I2C3RCV __attribute__((section("sfrs")));
typedef struct {
  unsigned I2CRCV:8;
} __I2C3RCVbits_t;
extern volatile __I2C3RCVbits_t I2C3RCVbits __asm__ ("I2C3RCV") __attribute__((section("sfrs")));
extern volatile unsigned int        I2C3RCVCLR __attribute__((section("sfrs")));
extern volatile unsigned int        I2C3RCVSET __attribute__((section("sfrs")));
extern volatile unsigned int        I2C3RCVINV __attribute__((section("sfrs")));
extern volatile unsigned int        I2C4CON __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned SEN:1;
    unsigned RSEN:1;
    unsigned PEN:1;
    unsigned RCEN:1;
    unsigned ACKEN:1;
    unsigned ACKDT:1;
    unsigned STREN:1;
    unsigned GCEN:1;
    unsigned SMEN:1;
    unsigned DISSLW:1;
    unsigned A10M:1;
    unsigned STRICT:1;
    unsigned SCLREL:1;
    unsigned SIDL:1;
    unsigned :1;
    unsigned ON:1;
    unsigned DHEN:1;
    unsigned AHEN:1;
    unsigned SBCDE:1;
    unsigned SDAHT:1;
    unsigned BOEN:1;
    unsigned SCIE:1;
    unsigned PCIE:1;
  };
  struct {
    unsigned :11;
    unsigned IPMIEN:1;
    unsigned :1;
    unsigned I2CSIDL:1;
    unsigned :1;
    unsigned I2CEN:1;
  };
} __I2C4CONbits_t;
extern volatile __I2C4CONbits_t I2C4CONbits __asm__ ("I2C4CON") __attribute__((section("sfrs")));
extern volatile unsigned int        I2C4CONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        I2C4CONSET __attribute__((section("sfrs")));
extern volatile unsigned int        I2C4CONINV __attribute__((section("sfrs")));
extern volatile unsigned int        I2C4STAT __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TBF:1;
    unsigned RBF:1;
    unsigned R_W:1;
    unsigned S:1;
    unsigned P:1;
    unsigned D_A:1;
    unsigned I2COV:1;
    unsigned IWCOL:1;
    unsigned ADD10:1;
    unsigned GCSTAT:1;
    unsigned BCL:1;
    unsigned :2;
    unsigned ACKTIM:1;
    unsigned TRSTAT:1;
    unsigned ACKSTAT:1;
  };
  struct {
    unsigned :6;
    unsigned I2CPOV:1;
  };
} __I2C4STATbits_t;
extern volatile __I2C4STATbits_t I2C4STATbits __asm__ ("I2C4STAT") __attribute__((section("sfrs")));
extern volatile unsigned int        I2C4STATCLR __attribute__((section("sfrs")));
extern volatile unsigned int        I2C4STATSET __attribute__((section("sfrs")));
extern volatile unsigned int        I2C4STATINV __attribute__((section("sfrs")));
extern volatile unsigned int        I2C4ADD __attribute__((section("sfrs")));
typedef struct {
  unsigned I2CADD:10;
} __I2C4ADDbits_t;
extern volatile __I2C4ADDbits_t I2C4ADDbits __asm__ ("I2C4ADD") __attribute__((section("sfrs")));
extern volatile unsigned int        I2C4ADDCLR __attribute__((section("sfrs")));
extern volatile unsigned int        I2C4ADDSET __attribute__((section("sfrs")));
extern volatile unsigned int        I2C4ADDINV __attribute__((section("sfrs")));
extern volatile unsigned int        I2C4MSK __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned I2CMSK:10;
  };
  struct {
    unsigned AMSK:10;
  };
} __I2C4MSKbits_t;
extern volatile __I2C4MSKbits_t I2C4MSKbits __asm__ ("I2C4MSK") __attribute__((section("sfrs")));
extern volatile unsigned int        I2C4MSKCLR __attribute__((section("sfrs")));
extern volatile unsigned int        I2C4MSKSET __attribute__((section("sfrs")));
extern volatile unsigned int        I2C4MSKINV __attribute__((section("sfrs")));
extern volatile unsigned int        I2C4BRG __attribute__((section("sfrs")));
typedef struct {
  unsigned I2CBRG:16;
} __I2C4BRGbits_t;
extern volatile __I2C4BRGbits_t I2C4BRGbits __asm__ ("I2C4BRG") __attribute__((section("sfrs")));
extern volatile unsigned int        I2C4BRGCLR __attribute__((section("sfrs")));
extern volatile unsigned int        I2C4BRGSET __attribute__((section("sfrs")));
extern volatile unsigned int        I2C4BRGINV __attribute__((section("sfrs")));
extern volatile unsigned int        I2C4TRN __attribute__((section("sfrs")));
typedef struct {
  unsigned I2CTRN:8;
} __I2C4TRNbits_t;
extern volatile __I2C4TRNbits_t I2C4TRNbits __asm__ ("I2C4TRN") __attribute__((section("sfrs")));
extern volatile unsigned int        I2C4TRNCLR __attribute__((section("sfrs")));
extern volatile unsigned int        I2C4TRNSET __attribute__((section("sfrs")));
extern volatile unsigned int        I2C4TRNINV __attribute__((section("sfrs")));
extern volatile unsigned int        I2C4RCV __attribute__((section("sfrs")));
typedef struct {
  unsigned I2CRCV:8;
} __I2C4RCVbits_t;
extern volatile __I2C4RCVbits_t I2C4RCVbits __asm__ ("I2C4RCV") __attribute__((section("sfrs")));
extern volatile unsigned int        I2C4RCVCLR __attribute__((section("sfrs")));
extern volatile unsigned int        I2C4RCVSET __attribute__((section("sfrs")));
extern volatile unsigned int        I2C4RCVINV __attribute__((section("sfrs")));
extern volatile unsigned int        I2C5CON __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned SEN:1;
    unsigned RSEN:1;
    unsigned PEN:1;
    unsigned RCEN:1;
    unsigned ACKEN:1;
    unsigned ACKDT:1;
    unsigned STREN:1;
    unsigned GCEN:1;
    unsigned SMEN:1;
    unsigned DISSLW:1;
    unsigned A10M:1;
    unsigned STRICT:1;
    unsigned SCLREL:1;
    unsigned SIDL:1;
    unsigned :1;
    unsigned ON:1;
    unsigned DHEN:1;
    unsigned AHEN:1;
    unsigned SBCDE:1;
    unsigned SDAHT:1;
    unsigned BOEN:1;
    unsigned SCIE:1;
    unsigned PCIE:1;
  };
  struct {
    unsigned :11;
    unsigned IPMIEN:1;
    unsigned :1;
    unsigned I2CSIDL:1;
    unsigned :1;
    unsigned I2CEN:1;
  };
} __I2C5CONbits_t;
extern volatile __I2C5CONbits_t I2C5CONbits __asm__ ("I2C5CON") __attribute__((section("sfrs")));
extern volatile unsigned int        I2C5CONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        I2C5CONSET __attribute__((section("sfrs")));
extern volatile unsigned int        I2C5CONINV __attribute__((section("sfrs")));
extern volatile unsigned int        I2C5STAT __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TBF:1;
    unsigned RBF:1;
    unsigned R_W:1;
    unsigned S:1;
    unsigned P:1;
    unsigned D_A:1;
    unsigned I2COV:1;
    unsigned IWCOL:1;
    unsigned ADD10:1;
    unsigned GCSTAT:1;
    unsigned BCL:1;
    unsigned :2;
    unsigned ACKTIM:1;
    unsigned TRSTAT:1;
    unsigned ACKSTAT:1;
  };
  struct {
    unsigned :6;
    unsigned I2CPOV:1;
  };
} __I2C5STATbits_t;
extern volatile __I2C5STATbits_t I2C5STATbits __asm__ ("I2C5STAT") __attribute__((section("sfrs")));
extern volatile unsigned int        I2C5STATCLR __attribute__((section("sfrs")));
extern volatile unsigned int        I2C5STATSET __attribute__((section("sfrs")));
extern volatile unsigned int        I2C5STATINV __attribute__((section("sfrs")));
extern volatile unsigned int        I2C5ADD __attribute__((section("sfrs")));
typedef struct {
  unsigned I2CADD:10;
} __I2C5ADDbits_t;
extern volatile __I2C5ADDbits_t I2C5ADDbits __asm__ ("I2C5ADD") __attribute__((section("sfrs")));
extern volatile unsigned int        I2C5ADDCLR __attribute__((section("sfrs")));
extern volatile unsigned int        I2C5ADDSET __attribute__((section("sfrs")));
extern volatile unsigned int        I2C5ADDINV __attribute__((section("sfrs")));
extern volatile unsigned int        I2C5MSK __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned I2CMSK:10;
  };
  struct {
    unsigned AMSK:10;
  };
} __I2C5MSKbits_t;
extern volatile __I2C5MSKbits_t I2C5MSKbits __asm__ ("I2C5MSK") __attribute__((section("sfrs")));
extern volatile unsigned int        I2C5MSKCLR __attribute__((section("sfrs")));
extern volatile unsigned int        I2C5MSKSET __attribute__((section("sfrs")));
extern volatile unsigned int        I2C5MSKINV __attribute__((section("sfrs")));
extern volatile unsigned int        I2C5BRG __attribute__((section("sfrs")));
typedef struct {
  unsigned I2CBRG:16;
} __I2C5BRGbits_t;
extern volatile __I2C5BRGbits_t I2C5BRGbits __asm__ ("I2C5BRG") __attribute__((section("sfrs")));
extern volatile unsigned int        I2C5BRGCLR __attribute__((section("sfrs")));
extern volatile unsigned int        I2C5BRGSET __attribute__((section("sfrs")));
extern volatile unsigned int        I2C5BRGINV __attribute__((section("sfrs")));
extern volatile unsigned int        I2C5TRN __attribute__((section("sfrs")));
typedef struct {
  unsigned I2CTRN:8;
} __I2C5TRNbits_t;
extern volatile __I2C5TRNbits_t I2C5TRNbits __asm__ ("I2C5TRN") __attribute__((section("sfrs")));
extern volatile unsigned int        I2C5TRNCLR __attribute__((section("sfrs")));
extern volatile unsigned int        I2C5TRNSET __attribute__((section("sfrs")));
extern volatile unsigned int        I2C5TRNINV __attribute__((section("sfrs")));
extern volatile unsigned int        I2C5RCV __attribute__((section("sfrs")));
typedef struct {
  unsigned I2CRCV:8;
} __I2C5RCVbits_t;
extern volatile __I2C5RCVbits_t I2C5RCVbits __asm__ ("I2C5RCV") __attribute__((section("sfrs")));
extern volatile unsigned int        I2C5RCVCLR __attribute__((section("sfrs")));
extern volatile unsigned int        I2C5RCVSET __attribute__((section("sfrs")));
extern volatile unsigned int        I2C5RCVINV __attribute__((section("sfrs")));
extern volatile unsigned int        SPI1CON __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned SRXISEL:2;
    unsigned STXISEL:2;
    unsigned DISSDI:1;
    unsigned MSTEN:1;
    unsigned CKP:1;
    unsigned SSEN:1;
    unsigned CKE:1;
    unsigned SMP:1;
    unsigned MODE16:1;
    unsigned MODE32:1;
    unsigned DISSDO:1;
    unsigned SIDL:1;
    unsigned :1;
    unsigned ON:1;
    unsigned ENHBUF:1;
    unsigned SPIFE:1;
    unsigned :5;
    unsigned MCLKSEL:1;
    unsigned FRMCNT:3;
    unsigned FRMSYPW:1;
    unsigned MSSEN:1;
    unsigned FRMPOL:1;
    unsigned FRMSYNC:1;
    unsigned FRMEN:1;
  };
  struct {
    unsigned w:32;
  };
} __SPI1CONbits_t;
extern volatile __SPI1CONbits_t SPI1CONbits __asm__ ("SPI1CON") __attribute__((section("sfrs")));
extern volatile unsigned int        SPI1CONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        SPI1CONSET __attribute__((section("sfrs")));
extern volatile unsigned int        SPI1CONINV __attribute__((section("sfrs")));
extern volatile unsigned int        SPI1STAT __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned SPIRBF:1;
    unsigned SPITBF:1;
    unsigned :1;
    unsigned SPITBE:1;
    unsigned :1;
    unsigned SPIRBE:1;
    unsigned SPIROV:1;
    unsigned SRMT:1;
    unsigned SPITUR:1;
    unsigned :2;
    unsigned SPIBUSY:1;
    unsigned FRMERR:1;
    unsigned :3;
    unsigned TXBUFELM:5;
    unsigned :3;
    unsigned RXBUFELM:5;
  };
  struct {
    unsigned w:32;
  };
} __SPI1STATbits_t;
extern volatile __SPI1STATbits_t SPI1STATbits __asm__ ("SPI1STAT") __attribute__((section("sfrs")));
extern volatile unsigned int        SPI1STATCLR __attribute__((section("sfrs")));
extern volatile unsigned int        SPI1STATSET __attribute__((section("sfrs")));
extern volatile unsigned int        SPI1STATINV __attribute__((section("sfrs")));
extern volatile unsigned int        SPI1BUF __attribute__((section("sfrs")));
extern volatile unsigned int        SPI1BRG __attribute__((section("sfrs")));
extern volatile unsigned int        SPI1BRGCLR __attribute__((section("sfrs")));
extern volatile unsigned int        SPI1BRGSET __attribute__((section("sfrs")));
extern volatile unsigned int        SPI1BRGINV __attribute__((section("sfrs")));
extern volatile unsigned int        SPI1CON2 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned AUDMOD:2;
    unsigned :1;
    unsigned AUDMONO:1;
    unsigned :3;
    unsigned AUDEN:1;
    unsigned IGNTUR:1;
    unsigned IGNROV:1;
    unsigned SPITUREN:1;
    unsigned SPIROVEN:1;
    unsigned FRMERREN:1;
    unsigned :2;
    unsigned SPISGNEXT:1;
  };
  struct {
    unsigned AUDMOD0:1;
    unsigned AUDMOD1:1;
  };
  struct {
    unsigned w:32;
  };
} __SPI1CON2bits_t;
extern volatile __SPI1CON2bits_t SPI1CON2bits __asm__ ("SPI1CON2") __attribute__((section("sfrs")));
extern volatile unsigned int        SPI1CON2CLR __attribute__((section("sfrs")));
extern volatile unsigned int        SPI1CON2SET __attribute__((section("sfrs")));
extern volatile unsigned int        SPI1CON2INV __attribute__((section("sfrs")));
extern volatile unsigned int        SPI2CON __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned SRXISEL:2;
    unsigned STXISEL:2;
    unsigned DISSDI:1;
    unsigned MSTEN:1;
    unsigned CKP:1;
    unsigned SSEN:1;
    unsigned CKE:1;
    unsigned SMP:1;
    unsigned MODE16:1;
    unsigned MODE32:1;
    unsigned DISSDO:1;
    unsigned SIDL:1;
    unsigned :1;
    unsigned ON:1;
    unsigned ENHBUF:1;
    unsigned SPIFE:1;
    unsigned :5;
    unsigned MCLKSEL:1;
    unsigned FRMCNT:3;
    unsigned FRMSYPW:1;
    unsigned MSSEN:1;
    unsigned FRMPOL:1;
    unsigned FRMSYNC:1;
    unsigned FRMEN:1;
  };
  struct {
    unsigned w:32;
  };
} __SPI2CONbits_t;
extern volatile __SPI2CONbits_t SPI2CONbits __asm__ ("SPI2CON") __attribute__((section("sfrs")));
extern volatile unsigned int        SPI2CONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        SPI2CONSET __attribute__((section("sfrs")));
extern volatile unsigned int        SPI2CONINV __attribute__((section("sfrs")));
extern volatile unsigned int        SPI2STAT __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned SPIRBF:1;
    unsigned SPITBF:1;
    unsigned :1;
    unsigned SPITBE:1;
    unsigned :1;
    unsigned SPIRBE:1;
    unsigned SPIROV:1;
    unsigned SRMT:1;
    unsigned SPITUR:1;
    unsigned :2;
    unsigned SPIBUSY:1;
    unsigned FRMERR:1;
    unsigned :3;
    unsigned TXBUFELM:5;
    unsigned :3;
    unsigned RXBUFELM:5;
  };
  struct {
    unsigned w:32;
  };
} __SPI2STATbits_t;
extern volatile __SPI2STATbits_t SPI2STATbits __asm__ ("SPI2STAT") __attribute__((section("sfrs")));
extern volatile unsigned int        SPI2STATCLR __attribute__((section("sfrs")));
extern volatile unsigned int        SPI2STATSET __attribute__((section("sfrs")));
extern volatile unsigned int        SPI2STATINV __attribute__((section("sfrs")));
extern volatile unsigned int        SPI2BUF __attribute__((section("sfrs")));
extern volatile unsigned int        SPI2BRG __attribute__((section("sfrs")));
extern volatile unsigned int        SPI2BRGCLR __attribute__((section("sfrs")));
extern volatile unsigned int        SPI2BRGSET __attribute__((section("sfrs")));
extern volatile unsigned int        SPI2BRGINV __attribute__((section("sfrs")));
extern volatile unsigned int        SPI2CON2 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned AUDMOD:2;
    unsigned :1;
    unsigned AUDMONO:1;
    unsigned :3;
    unsigned AUDEN:1;
    unsigned IGNTUR:1;
    unsigned IGNROV:1;
    unsigned SPITUREN:1;
    unsigned SPIROVEN:1;
    unsigned FRMERREN:1;
    unsigned :2;
    unsigned SPISGNEXT:1;
  };
  struct {
    unsigned AUDMOD0:1;
    unsigned AUDMOD1:1;
  };
  struct {
    unsigned w:32;
  };
} __SPI2CON2bits_t;
extern volatile __SPI2CON2bits_t SPI2CON2bits __asm__ ("SPI2CON2") __attribute__((section("sfrs")));
extern volatile unsigned int        SPI2CON2CLR __attribute__((section("sfrs")));
extern volatile unsigned int        SPI2CON2SET __attribute__((section("sfrs")));
extern volatile unsigned int        SPI2CON2INV __attribute__((section("sfrs")));
extern volatile unsigned int        SPI3CON __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned SRXISEL:2;
    unsigned STXISEL:2;
    unsigned DISSDI:1;
    unsigned MSTEN:1;
    unsigned CKP:1;
    unsigned SSEN:1;
    unsigned CKE:1;
    unsigned SMP:1;
    unsigned MODE16:1;
    unsigned MODE32:1;
    unsigned DISSDO:1;
    unsigned SIDL:1;
    unsigned :1;
    unsigned ON:1;
    unsigned ENHBUF:1;
    unsigned SPIFE:1;
    unsigned :5;
    unsigned MCLKSEL:1;
    unsigned FRMCNT:3;
    unsigned FRMSYPW:1;
    unsigned MSSEN:1;
    unsigned FRMPOL:1;
    unsigned FRMSYNC:1;
    unsigned FRMEN:1;
  };
  struct {
    unsigned w:32;
  };
} __SPI3CONbits_t;
extern volatile __SPI3CONbits_t SPI3CONbits __asm__ ("SPI3CON") __attribute__((section("sfrs")));
extern volatile unsigned int        SPI3CONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        SPI3CONSET __attribute__((section("sfrs")));
extern volatile unsigned int        SPI3CONINV __attribute__((section("sfrs")));
extern volatile unsigned int        SPI3STAT __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned SPIRBF:1;
    unsigned SPITBF:1;
    unsigned :1;
    unsigned SPITBE:1;
    unsigned :1;
    unsigned SPIRBE:1;
    unsigned SPIROV:1;
    unsigned SRMT:1;
    unsigned SPITUR:1;
    unsigned :2;
    unsigned SPIBUSY:1;
    unsigned FRMERR:1;
    unsigned :3;
    unsigned TXBUFELM:5;
    unsigned :3;
    unsigned RXBUFELM:5;
  };
  struct {
    unsigned w:32;
  };
} __SPI3STATbits_t;
extern volatile __SPI3STATbits_t SPI3STATbits __asm__ ("SPI3STAT") __attribute__((section("sfrs")));
extern volatile unsigned int        SPI3STATCLR __attribute__((section("sfrs")));
extern volatile unsigned int        SPI3STATSET __attribute__((section("sfrs")));
extern volatile unsigned int        SPI3STATINV __attribute__((section("sfrs")));
extern volatile unsigned int        SPI3BUF __attribute__((section("sfrs")));
extern volatile unsigned int        SPI3BRG __attribute__((section("sfrs")));
extern volatile unsigned int        SPI3BRGCLR __attribute__((section("sfrs")));
extern volatile unsigned int        SPI3BRGSET __attribute__((section("sfrs")));
extern volatile unsigned int        SPI3BRGINV __attribute__((section("sfrs")));
extern volatile unsigned int        SPI3CON2 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned AUDMOD:2;
    unsigned :1;
    unsigned AUDMONO:1;
    unsigned :3;
    unsigned AUDEN:1;
    unsigned IGNTUR:1;
    unsigned IGNROV:1;
    unsigned SPITUREN:1;
    unsigned SPIROVEN:1;
    unsigned FRMERREN:1;
    unsigned :2;
    unsigned SPISGNEXT:1;
  };
  struct {
    unsigned AUDMOD0:1;
    unsigned AUDMOD1:1;
  };
  struct {
    unsigned w:32;
  };
} __SPI3CON2bits_t;
extern volatile __SPI3CON2bits_t SPI3CON2bits __asm__ ("SPI3CON2") __attribute__((section("sfrs")));
extern volatile unsigned int        SPI3CON2CLR __attribute__((section("sfrs")));
extern volatile unsigned int        SPI3CON2SET __attribute__((section("sfrs")));
extern volatile unsigned int        SPI3CON2INV __attribute__((section("sfrs")));
extern volatile unsigned int        SPI4CON __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned SRXISEL:2;
    unsigned STXISEL:2;
    unsigned DISSDI:1;
    unsigned MSTEN:1;
    unsigned CKP:1;
    unsigned SSEN:1;
    unsigned CKE:1;
    unsigned SMP:1;
    unsigned MODE16:1;
    unsigned MODE32:1;
    unsigned DISSDO:1;
    unsigned SIDL:1;
    unsigned :1;
    unsigned ON:1;
    unsigned ENHBUF:1;
    unsigned SPIFE:1;
    unsigned :5;
    unsigned MCLKSEL:1;
    unsigned FRMCNT:3;
    unsigned FRMSYPW:1;
    unsigned MSSEN:1;
    unsigned FRMPOL:1;
    unsigned FRMSYNC:1;
    unsigned FRMEN:1;
  };
  struct {
    unsigned w:32;
  };
} __SPI4CONbits_t;
extern volatile __SPI4CONbits_t SPI4CONbits __asm__ ("SPI4CON") __attribute__((section("sfrs")));
extern volatile unsigned int        SPI4CONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        SPI4CONSET __attribute__((section("sfrs")));
extern volatile unsigned int        SPI4CONINV __attribute__((section("sfrs")));
extern volatile unsigned int        SPI4STAT __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned SPIRBF:1;
    unsigned SPITBF:1;
    unsigned :1;
    unsigned SPITBE:1;
    unsigned :1;
    unsigned SPIRBE:1;
    unsigned SPIROV:1;
    unsigned SRMT:1;
    unsigned SPITUR:1;
    unsigned :2;
    unsigned SPIBUSY:1;
    unsigned FRMERR:1;
    unsigned :3;
    unsigned TXBUFELM:5;
    unsigned :3;
    unsigned RXBUFELM:5;
  };
  struct {
    unsigned w:32;
  };
} __SPI4STATbits_t;
extern volatile __SPI4STATbits_t SPI4STATbits __asm__ ("SPI4STAT") __attribute__((section("sfrs")));
extern volatile unsigned int        SPI4STATCLR __attribute__((section("sfrs")));
extern volatile unsigned int        SPI4STATSET __attribute__((section("sfrs")));
extern volatile unsigned int        SPI4STATINV __attribute__((section("sfrs")));
extern volatile unsigned int        SPI4BUF __attribute__((section("sfrs")));
extern volatile unsigned int        SPI4BRG __attribute__((section("sfrs")));
extern volatile unsigned int        SPI4BRGCLR __attribute__((section("sfrs")));
extern volatile unsigned int        SPI4BRGSET __attribute__((section("sfrs")));
extern volatile unsigned int        SPI4BRGINV __attribute__((section("sfrs")));
extern volatile unsigned int        SPI4CON2 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned AUDMOD:2;
    unsigned :1;
    unsigned AUDMONO:1;
    unsigned :3;
    unsigned AUDEN:1;
    unsigned IGNTUR:1;
    unsigned IGNROV:1;
    unsigned SPITUREN:1;
    unsigned SPIROVEN:1;
    unsigned FRMERREN:1;
    unsigned :2;
    unsigned SPISGNEXT:1;
  };
  struct {
    unsigned AUDMOD0:1;
    unsigned AUDMOD1:1;
  };
  struct {
    unsigned w:32;
  };
} __SPI4CON2bits_t;
extern volatile __SPI4CON2bits_t SPI4CON2bits __asm__ ("SPI4CON2") __attribute__((section("sfrs")));
extern volatile unsigned int        SPI4CON2CLR __attribute__((section("sfrs")));
extern volatile unsigned int        SPI4CON2SET __attribute__((section("sfrs")));
extern volatile unsigned int        SPI4CON2INV __attribute__((section("sfrs")));
extern volatile unsigned int        SPI5CON __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned SRXISEL:2;
    unsigned STXISEL:2;
    unsigned DISSDI:1;
    unsigned MSTEN:1;
    unsigned CKP:1;
    unsigned SSEN:1;
    unsigned CKE:1;
    unsigned SMP:1;
    unsigned MODE16:1;
    unsigned MODE32:1;
    unsigned DISSDO:1;
    unsigned SIDL:1;
    unsigned :1;
    unsigned ON:1;
    unsigned ENHBUF:1;
    unsigned SPIFE:1;
    unsigned :5;
    unsigned MCLKSEL:1;
    unsigned FRMCNT:3;
    unsigned FRMSYPW:1;
    unsigned MSSEN:1;
    unsigned FRMPOL:1;
    unsigned FRMSYNC:1;
    unsigned FRMEN:1;
  };
  struct {
    unsigned w:32;
  };
} __SPI5CONbits_t;
extern volatile __SPI5CONbits_t SPI5CONbits __asm__ ("SPI5CON") __attribute__((section("sfrs")));
extern volatile unsigned int        SPI5CONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        SPI5CONSET __attribute__((section("sfrs")));
extern volatile unsigned int        SPI5CONINV __attribute__((section("sfrs")));
extern volatile unsigned int        SPI5STAT __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned SPIRBF:1;
    unsigned SPITBF:1;
    unsigned :1;
    unsigned SPITBE:1;
    unsigned :1;
    unsigned SPIRBE:1;
    unsigned SPIROV:1;
    unsigned SRMT:1;
    unsigned SPITUR:1;
    unsigned :2;
    unsigned SPIBUSY:1;
    unsigned FRMERR:1;
    unsigned :3;
    unsigned TXBUFELM:5;
    unsigned :3;
    unsigned RXBUFELM:5;
  };
  struct {
    unsigned w:32;
  };
} __SPI5STATbits_t;
extern volatile __SPI5STATbits_t SPI5STATbits __asm__ ("SPI5STAT") __attribute__((section("sfrs")));
extern volatile unsigned int        SPI5STATCLR __attribute__((section("sfrs")));
extern volatile unsigned int        SPI5STATSET __attribute__((section("sfrs")));
extern volatile unsigned int        SPI5STATINV __attribute__((section("sfrs")));
extern volatile unsigned int        SPI5BUF __attribute__((section("sfrs")));
extern volatile unsigned int        SPI5BRG __attribute__((section("sfrs")));
extern volatile unsigned int        SPI5BRGCLR __attribute__((section("sfrs")));
extern volatile unsigned int        SPI5BRGSET __attribute__((section("sfrs")));
extern volatile unsigned int        SPI5BRGINV __attribute__((section("sfrs")));
extern volatile unsigned int        SPI5CON2 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned AUDMOD:2;
    unsigned :1;
    unsigned AUDMONO:1;
    unsigned :3;
    unsigned AUDEN:1;
    unsigned IGNTUR:1;
    unsigned IGNROV:1;
    unsigned SPITUREN:1;
    unsigned SPIROVEN:1;
    unsigned FRMERREN:1;
    unsigned :2;
    unsigned SPISGNEXT:1;
  };
  struct {
    unsigned AUDMOD0:1;
    unsigned AUDMOD1:1;
  };
  struct {
    unsigned w:32;
  };
} __SPI5CON2bits_t;
extern volatile __SPI5CON2bits_t SPI5CON2bits __asm__ ("SPI5CON2") __attribute__((section("sfrs")));
extern volatile unsigned int        SPI5CON2CLR __attribute__((section("sfrs")));
extern volatile unsigned int        SPI5CON2SET __attribute__((section("sfrs")));
extern volatile unsigned int        SPI5CON2INV __attribute__((section("sfrs")));
extern volatile unsigned int        SPI6CON __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned SRXISEL:2;
    unsigned STXISEL:2;
    unsigned DISSDI:1;
    unsigned MSTEN:1;
    unsigned CKP:1;
    unsigned SSEN:1;
    unsigned CKE:1;
    unsigned SMP:1;
    unsigned MODE16:1;
    unsigned MODE32:1;
    unsigned DISSDO:1;
    unsigned SIDL:1;
    unsigned :1;
    unsigned ON:1;
    unsigned ENHBUF:1;
    unsigned SPIFE:1;
    unsigned :5;
    unsigned MCLKSEL:1;
    unsigned FRMCNT:3;
    unsigned FRMSYPW:1;
    unsigned MSSEN:1;
    unsigned FRMPOL:1;
    unsigned FRMSYNC:1;
    unsigned FRMEN:1;
  };
  struct {
    unsigned w:32;
  };
} __SPI6CONbits_t;
extern volatile __SPI6CONbits_t SPI6CONbits __asm__ ("SPI6CON") __attribute__((section("sfrs")));
extern volatile unsigned int        SPI6CONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        SPI6CONSET __attribute__((section("sfrs")));
extern volatile unsigned int        SPI6CONINV __attribute__((section("sfrs")));
extern volatile unsigned int        SPI6STAT __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned SPIRBF:1;
    unsigned SPITBF:1;
    unsigned :1;
    unsigned SPITBE:1;
    unsigned :1;
    unsigned SPIRBE:1;
    unsigned SPIROV:1;
    unsigned SRMT:1;
    unsigned SPITUR:1;
    unsigned :2;
    unsigned SPIBUSY:1;
    unsigned FRMERR:1;
    unsigned :3;
    unsigned TXBUFELM:5;
    unsigned :3;
    unsigned RXBUFELM:5;
  };
  struct {
    unsigned w:32;
  };
} __SPI6STATbits_t;
extern volatile __SPI6STATbits_t SPI6STATbits __asm__ ("SPI6STAT") __attribute__((section("sfrs")));
extern volatile unsigned int        SPI6STATCLR __attribute__((section("sfrs")));
extern volatile unsigned int        SPI6STATSET __attribute__((section("sfrs")));
extern volatile unsigned int        SPI6STATINV __attribute__((section("sfrs")));
extern volatile unsigned int        SPI6BUF __attribute__((section("sfrs")));
extern volatile unsigned int        SPI6BRG __attribute__((section("sfrs")));
extern volatile unsigned int        SPI6BRGCLR __attribute__((section("sfrs")));
extern volatile unsigned int        SPI6BRGSET __attribute__((section("sfrs")));
extern volatile unsigned int        SPI6BRGINV __attribute__((section("sfrs")));
extern volatile unsigned int        SPI6CON2 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned AUDMOD:2;
    unsigned :1;
    unsigned AUDMONO:1;
    unsigned :3;
    unsigned AUDEN:1;
    unsigned IGNTUR:1;
    unsigned IGNROV:1;
    unsigned SPITUREN:1;
    unsigned SPIROVEN:1;
    unsigned FRMERREN:1;
    unsigned :2;
    unsigned SPISGNEXT:1;
  };
  struct {
    unsigned AUDMOD0:1;
    unsigned AUDMOD1:1;
  };
  struct {
    unsigned w:32;
  };
} __SPI6CON2bits_t;
extern volatile __SPI6CON2bits_t SPI6CON2bits __asm__ ("SPI6CON2") __attribute__((section("sfrs")));
extern volatile unsigned int        SPI6CON2CLR __attribute__((section("sfrs")));
extern volatile unsigned int        SPI6CON2SET __attribute__((section("sfrs")));
extern volatile unsigned int        SPI6CON2INV __attribute__((section("sfrs")));
extern volatile unsigned int        U1MODE __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned STSEL:1;
    unsigned PDSEL:2;
    unsigned BRGH:1;
    unsigned RXINV:1;
    unsigned ABAUD:1;
    unsigned LPBACK:1;
    unsigned WAKE:1;
    unsigned UEN:2;
    unsigned :1;
    unsigned RTSMD:1;
    unsigned IREN:1;
    unsigned SIDL:1;
    unsigned :1;
    unsigned ON:1;
  };
  struct {
    unsigned :1;
    unsigned PDSEL0:1;
    unsigned PDSEL1:1;
    unsigned :5;
    unsigned UEN0:1;
    unsigned UEN1:1;
  };
  struct {
    unsigned :13;
    unsigned USIDL:1;
    unsigned :1;
    unsigned UARTEN:1;
  };
  struct {
    unsigned w:32;
  };
} __U1MODEbits_t;
extern volatile __U1MODEbits_t U1MODEbits __asm__ ("U1MODE") __attribute__((section("sfrs")));
extern volatile unsigned int        UABMODE __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned STSEL:1;
    unsigned PDSEL:2;
    unsigned BRGH:1;
    unsigned RXINV:1;
    unsigned ABAUD:1;
    unsigned LPBACK:1;
    unsigned WAKE:1;
    unsigned UEN:2;
    unsigned :1;
    unsigned RTSMD:1;
    unsigned IREN:1;
    unsigned SIDL:1;
    unsigned :1;
    unsigned ON:1;
  };
  struct {
    unsigned :1;
    unsigned PDSEL0:1;
    unsigned PDSEL1:1;
    unsigned :5;
    unsigned UEN0:1;
    unsigned UEN1:1;
  };
  struct {
    unsigned :13;
    unsigned USIDL:1;
    unsigned :1;
    unsigned UARTEN:1;
  };
  struct {
    unsigned w:32;
  };
} __UABMODEbits_t;
extern volatile __UABMODEbits_t UABMODEbits __asm__ ("UABMODE") __attribute__((section("sfrs")));
extern volatile unsigned int        U1MODECLR __attribute__((section("sfrs")));
extern volatile unsigned int        UABMODECLR __attribute__((section("sfrs")));
extern volatile unsigned int        U1MODESET __attribute__((section("sfrs")));
extern volatile unsigned int        UABMODESET __attribute__((section("sfrs")));
extern volatile unsigned int        U1MODEINV __attribute__((section("sfrs")));
extern volatile unsigned int        UABMODEINV __attribute__((section("sfrs")));
extern volatile unsigned int        U1STA __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned URXDA:1;
    unsigned OERR:1;
    unsigned FERR:1;
    unsigned PERR:1;
    unsigned RIDLE:1;
    unsigned ADDEN:1;
    unsigned URXISEL:2;
    unsigned TRMT:1;
    unsigned UTXBF:1;
    unsigned UTXEN:1;
    unsigned UTXBRK:1;
    unsigned URXEN:1;
    unsigned UTXINV:1;
    unsigned UTXISEL:2;
    unsigned ADDR:8;
    unsigned ADM_EN:1;
  };
  struct {
    unsigned :6;
    unsigned URXISEL0:1;
    unsigned URXISEL1:1;
    unsigned :6;
    unsigned UTXISEL0:1;
    unsigned UTXISEL1:1;
  };
  struct {
    unsigned :14;
    unsigned UTXSEL:2;
  };
  struct {
    unsigned w:32;
  };
} __U1STAbits_t;
extern volatile __U1STAbits_t U1STAbits __asm__ ("U1STA") __attribute__((section("sfrs")));
extern volatile unsigned int        UABSTA __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned URXDA:1;
    unsigned OERR:1;
    unsigned FERR:1;
    unsigned PERR:1;
    unsigned RIDLE:1;
    unsigned ADDEN:1;
    unsigned URXISEL:2;
    unsigned TRMT:1;
    unsigned UTXBF:1;
    unsigned UTXEN:1;
    unsigned UTXBRK:1;
    unsigned URXEN:1;
    unsigned UTXINV:1;
    unsigned UTXISEL:2;
    unsigned ADDR:8;
    unsigned ADM_EN:1;
  };
  struct {
    unsigned :6;
    unsigned URXISEL0:1;
    unsigned URXISEL1:1;
    unsigned :6;
    unsigned UTXISEL0:1;
    unsigned UTXISEL1:1;
  };
  struct {
    unsigned :14;
    unsigned UTXSEL:2;
  };
  struct {
    unsigned w:32;
  };
} __UABSTAbits_t;
extern volatile __UABSTAbits_t UABSTAbits __asm__ ("UABSTA") __attribute__((section("sfrs")));
extern volatile unsigned int        U1STACLR __attribute__((section("sfrs")));
extern volatile unsigned int        UABSTACLR __attribute__((section("sfrs")));
extern volatile unsigned int        U1STASET __attribute__((section("sfrs")));
extern volatile unsigned int        UABSTASET __attribute__((section("sfrs")));
extern volatile unsigned int        U1STAINV __attribute__((section("sfrs")));
extern volatile unsigned int        UABSTAINV __attribute__((section("sfrs")));
extern volatile unsigned int        U1TXREG __attribute__((section("sfrs")));
extern volatile unsigned int        UABTXREG __attribute__((section("sfrs")));
extern volatile unsigned int        U1RXREG __attribute__((section("sfrs")));
extern volatile unsigned int        UABRXREG __attribute__((section("sfrs")));
extern volatile unsigned int        U1BRG __attribute__((section("sfrs")));
extern volatile unsigned int        UABBRG __attribute__((section("sfrs")));
extern volatile unsigned int        U1BRGCLR __attribute__((section("sfrs")));
extern volatile unsigned int        UABBRGCLR __attribute__((section("sfrs")));
extern volatile unsigned int        U1BRGSET __attribute__((section("sfrs")));
extern volatile unsigned int        UABBRGSET __attribute__((section("sfrs")));
extern volatile unsigned int        U1BRGINV __attribute__((section("sfrs")));
extern volatile unsigned int        UABBRGINV __attribute__((section("sfrs")));
extern volatile unsigned int        U2MODE __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned STSEL:1;
    unsigned PDSEL:2;
    unsigned BRGH:1;
    unsigned RXINV:1;
    unsigned ABAUD:1;
    unsigned LPBACK:1;
    unsigned WAKE:1;
    unsigned UEN:2;
    unsigned :1;
    unsigned RTSMD:1;
    unsigned IREN:1;
    unsigned SIDL:1;
    unsigned :1;
    unsigned ON:1;
  };
  struct {
    unsigned :1;
    unsigned PDSEL0:1;
    unsigned PDSEL1:1;
    unsigned :5;
    unsigned UEN0:1;
    unsigned UEN1:1;
  };
  struct {
    unsigned :13;
    unsigned USIDL:1;
    unsigned :1;
    unsigned UARTEN:1;
  };
  struct {
    unsigned w:32;
  };
} __U2MODEbits_t;
extern volatile __U2MODEbits_t U2MODEbits __asm__ ("U2MODE") __attribute__((section("sfrs")));
extern volatile unsigned int        UCDMODE __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned STSEL:1;
    unsigned PDSEL:2;
    unsigned BRGH:1;
    unsigned RXINV:1;
    unsigned ABAUD:1;
    unsigned LPBACK:1;
    unsigned WAKE:1;
    unsigned UEN:2;
    unsigned :1;
    unsigned RTSMD:1;
    unsigned IREN:1;
    unsigned SIDL:1;
    unsigned :1;
    unsigned ON:1;
  };
  struct {
    unsigned :1;
    unsigned PDSEL0:1;
    unsigned PDSEL1:1;
    unsigned :5;
    unsigned UEN0:1;
    unsigned UEN1:1;
  };
  struct {
    unsigned :13;
    unsigned USIDL:1;
    unsigned :1;
    unsigned UARTEN:1;
  };
  struct {
    unsigned w:32;
  };
} __UCDMODEbits_t;
extern volatile __UCDMODEbits_t UCDMODEbits __asm__ ("UCDMODE") __attribute__((section("sfrs")));
extern volatile unsigned int        U2MODECLR __attribute__((section("sfrs")));
extern volatile unsigned int        UCDMODECLR __attribute__((section("sfrs")));
extern volatile unsigned int        U2MODESET __attribute__((section("sfrs")));
extern volatile unsigned int        UCDMODESET __attribute__((section("sfrs")));
extern volatile unsigned int        U2MODEINV __attribute__((section("sfrs")));
extern volatile unsigned int        UCDMODEINV __attribute__((section("sfrs")));
extern volatile unsigned int        U2STA __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned URXDA:1;
    unsigned OERR:1;
    unsigned FERR:1;
    unsigned PERR:1;
    unsigned RIDLE:1;
    unsigned ADDEN:1;
    unsigned URXISEL:2;
    unsigned TRMT:1;
    unsigned UTXBF:1;
    unsigned UTXEN:1;
    unsigned UTXBRK:1;
    unsigned URXEN:1;
    unsigned UTXINV:1;
    unsigned UTXISEL:2;
    unsigned ADDR:8;
    unsigned ADM_EN:1;
  };
  struct {
    unsigned :6;
    unsigned URXISEL0:1;
    unsigned URXISEL1:1;
    unsigned :6;
    unsigned UTXISEL0:1;
    unsigned UTXISEL1:1;
  };
  struct {
    unsigned :14;
    unsigned UTXSEL:2;
  };
  struct {
    unsigned w:32;
  };
} __U2STAbits_t;
extern volatile __U2STAbits_t U2STAbits __asm__ ("U2STA") __attribute__((section("sfrs")));
extern volatile unsigned int        UCDSTA __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned URXDA:1;
    unsigned OERR:1;
    unsigned FERR:1;
    unsigned PERR:1;
    unsigned RIDLE:1;
    unsigned ADDEN:1;
    unsigned URXISEL:2;
    unsigned TRMT:1;
    unsigned UTXBF:1;
    unsigned UTXEN:1;
    unsigned UTXBRK:1;
    unsigned URXEN:1;
    unsigned UTXINV:1;
    unsigned UTXISEL:2;
    unsigned ADDR:8;
    unsigned ADM_EN:1;
  };
  struct {
    unsigned :6;
    unsigned URXISEL0:1;
    unsigned URXISEL1:1;
    unsigned :6;
    unsigned UTXISEL0:1;
    unsigned UTXISEL1:1;
  };
  struct {
    unsigned :14;
    unsigned UTXSEL:2;
  };
  struct {
    unsigned w:32;
  };
} __UCDSTAbits_t;
extern volatile __UCDSTAbits_t UCDSTAbits __asm__ ("UCDSTA") __attribute__((section("sfrs")));
extern volatile unsigned int        U2STACLR __attribute__((section("sfrs")));
extern volatile unsigned int        UCDSTACLR __attribute__((section("sfrs")));
extern volatile unsigned int        U2STASET __attribute__((section("sfrs")));
extern volatile unsigned int        UCDSTASET __attribute__((section("sfrs")));
extern volatile unsigned int        U2STAINV __attribute__((section("sfrs")));
extern volatile unsigned int        UCDSTAINV __attribute__((section("sfrs")));
extern volatile unsigned int        U2TXREG __attribute__((section("sfrs")));
extern volatile unsigned int        UCDTXREG __attribute__((section("sfrs")));
extern volatile unsigned int        U2RXREG __attribute__((section("sfrs")));
extern volatile unsigned int        UCDRXREG __attribute__((section("sfrs")));
extern volatile unsigned int        U2BRG __attribute__((section("sfrs")));
extern volatile unsigned int        UCDBRG __attribute__((section("sfrs")));
extern volatile unsigned int        U2BRGCLR __attribute__((section("sfrs")));
extern volatile unsigned int        UCDBRGCLR __attribute__((section("sfrs")));
extern volatile unsigned int        U2BRGSET __attribute__((section("sfrs")));
extern volatile unsigned int        UCDBRGSET __attribute__((section("sfrs")));
extern volatile unsigned int        U2BRGINV __attribute__((section("sfrs")));
extern volatile unsigned int        UCDBRGINV __attribute__((section("sfrs")));
extern volatile unsigned int        U3MODE __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned STSEL:1;
    unsigned PDSEL:2;
    unsigned BRGH:1;
    unsigned RXINV:1;
    unsigned ABAUD:1;
    unsigned LPBACK:1;
    unsigned WAKE:1;
    unsigned UEN:2;
    unsigned :1;
    unsigned RTSMD:1;
    unsigned IREN:1;
    unsigned SIDL:1;
    unsigned :1;
    unsigned ON:1;
  };
  struct {
    unsigned :1;
    unsigned PDSEL0:1;
    unsigned PDSEL1:1;
    unsigned :5;
    unsigned UEN0:1;
    unsigned UEN1:1;
  };
  struct {
    unsigned :13;
    unsigned USIDL:1;
    unsigned :1;
    unsigned UARTEN:1;
  };
  struct {
    unsigned w:32;
  };
} __U3MODEbits_t;
extern volatile __U3MODEbits_t U3MODEbits __asm__ ("U3MODE") __attribute__((section("sfrs")));
extern volatile unsigned int        UEFMODE __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned STSEL:1;
    unsigned PDSEL:2;
    unsigned BRGH:1;
    unsigned RXINV:1;
    unsigned ABAUD:1;
    unsigned LPBACK:1;
    unsigned WAKE:1;
    unsigned UEN:2;
    unsigned :1;
    unsigned RTSMD:1;
    unsigned IREN:1;
    unsigned SIDL:1;
    unsigned :1;
    unsigned ON:1;
  };
  struct {
    unsigned :1;
    unsigned PDSEL0:1;
    unsigned PDSEL1:1;
    unsigned :5;
    unsigned UEN0:1;
    unsigned UEN1:1;
  };
  struct {
    unsigned :13;
    unsigned USIDL:1;
    unsigned :1;
    unsigned UARTEN:1;
  };
  struct {
    unsigned w:32;
  };
} __UEFMODEbits_t;
extern volatile __UEFMODEbits_t UEFMODEbits __asm__ ("UEFMODE") __attribute__((section("sfrs")));
extern volatile unsigned int        U3MODECLR __attribute__((section("sfrs")));
extern volatile unsigned int        UEFMODECLR __attribute__((section("sfrs")));
extern volatile unsigned int        U3MODESET __attribute__((section("sfrs")));
extern volatile unsigned int        UEFMODESET __attribute__((section("sfrs")));
extern volatile unsigned int        U3MODEINV __attribute__((section("sfrs")));
extern volatile unsigned int        UEFMODEINV __attribute__((section("sfrs")));
extern volatile unsigned int        U3STA __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned URXDA:1;
    unsigned OERR:1;
    unsigned FERR:1;
    unsigned PERR:1;
    unsigned RIDLE:1;
    unsigned ADDEN:1;
    unsigned URXISEL:2;
    unsigned TRMT:1;
    unsigned UTXBF:1;
    unsigned UTXEN:1;
    unsigned UTXBRK:1;
    unsigned URXEN:1;
    unsigned UTXINV:1;
    unsigned UTXISEL:2;
    unsigned ADDR:8;
    unsigned ADM_EN:1;
  };
  struct {
    unsigned :6;
    unsigned URXISEL0:1;
    unsigned URXISEL1:1;
    unsigned :6;
    unsigned UTXISEL0:1;
    unsigned UTXISEL1:1;
  };
  struct {
    unsigned :14;
    unsigned UTXSEL:2;
  };
  struct {
    unsigned w:32;
  };
} __U3STAbits_t;
extern volatile __U3STAbits_t U3STAbits __asm__ ("U3STA") __attribute__((section("sfrs")));
extern volatile unsigned int        UEFSTA __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned URXDA:1;
    unsigned OERR:1;
    unsigned FERR:1;
    unsigned PERR:1;
    unsigned RIDLE:1;
    unsigned ADDEN:1;
    unsigned URXISEL:2;
    unsigned TRMT:1;
    unsigned UTXBF:1;
    unsigned UTXEN:1;
    unsigned UTXBRK:1;
    unsigned URXEN:1;
    unsigned UTXINV:1;
    unsigned UTXISEL:2;
    unsigned ADDR:8;
    unsigned ADM_EN:1;
  };
  struct {
    unsigned :6;
    unsigned URXISEL0:1;
    unsigned URXISEL1:1;
    unsigned :6;
    unsigned UTXISEL0:1;
    unsigned UTXISEL1:1;
  };
  struct {
    unsigned :14;
    unsigned UTXSEL:2;
  };
  struct {
    unsigned w:32;
  };
} __UEFSTAbits_t;
extern volatile __UEFSTAbits_t UEFSTAbits __asm__ ("UEFSTA") __attribute__((section("sfrs")));
extern volatile unsigned int        U3STACLR __attribute__((section("sfrs")));
extern volatile unsigned int        UEFSTACLR __attribute__((section("sfrs")));
extern volatile unsigned int        U3STASET __attribute__((section("sfrs")));
extern volatile unsigned int        UEFSTASET __attribute__((section("sfrs")));
extern volatile unsigned int        U3STAINV __attribute__((section("sfrs")));
extern volatile unsigned int        UEFSTAINV __attribute__((section("sfrs")));
extern volatile unsigned int        U3TXREG __attribute__((section("sfrs")));
extern volatile unsigned int        UEFTXREG __attribute__((section("sfrs")));
extern volatile unsigned int        U3RXREG __attribute__((section("sfrs")));
extern volatile unsigned int        UEFRXREG __attribute__((section("sfrs")));
extern volatile unsigned int        U3BRG __attribute__((section("sfrs")));
extern volatile unsigned int        UEFBRG __attribute__((section("sfrs")));
extern volatile unsigned int        U3BRGCLR __attribute__((section("sfrs")));
extern volatile unsigned int        UEFBRGCLR __attribute__((section("sfrs")));
extern volatile unsigned int        U3BRGSET __attribute__((section("sfrs")));
extern volatile unsigned int        UEFBRGSET __attribute__((section("sfrs")));
extern volatile unsigned int        U3BRGINV __attribute__((section("sfrs")));
extern volatile unsigned int        UEFBRGINV __attribute__((section("sfrs")));
extern volatile unsigned int        U4MODE __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned STSEL:1;
    unsigned PDSEL:2;
    unsigned BRGH:1;
    unsigned RXINV:1;
    unsigned ABAUD:1;
    unsigned LPBACK:1;
    unsigned WAKE:1;
    unsigned UEN:2;
    unsigned :1;
    unsigned RTSMD:1;
    unsigned IREN:1;
    unsigned SIDL:1;
    unsigned :1;
    unsigned ON:1;
  };
  struct {
    unsigned :1;
    unsigned PDSEL0:1;
    unsigned PDSEL1:1;
    unsigned :5;
    unsigned UEN0:1;
    unsigned UEN1:1;
  };
  struct {
    unsigned :13;
    unsigned USIDL:1;
    unsigned :1;
    unsigned UARTEN:1;
  };
  struct {
    unsigned w:32;
  };
} __U4MODEbits_t;
extern volatile __U4MODEbits_t U4MODEbits __asm__ ("U4MODE") __attribute__((section("sfrs")));
extern volatile unsigned int        UGHMODE __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned STSEL:1;
    unsigned PDSEL:2;
    unsigned BRGH:1;
    unsigned RXINV:1;
    unsigned ABAUD:1;
    unsigned LPBACK:1;
    unsigned WAKE:1;
    unsigned UEN:2;
    unsigned :1;
    unsigned RTSMD:1;
    unsigned IREN:1;
    unsigned SIDL:1;
    unsigned :1;
    unsigned ON:1;
  };
  struct {
    unsigned :1;
    unsigned PDSEL0:1;
    unsigned PDSEL1:1;
    unsigned :5;
    unsigned UEN0:1;
    unsigned UEN1:1;
  };
  struct {
    unsigned :13;
    unsigned USIDL:1;
    unsigned :1;
    unsigned UARTEN:1;
  };
  struct {
    unsigned w:32;
  };
} __UGHMODEbits_t;
extern volatile __UGHMODEbits_t UGHMODEbits __asm__ ("UGHMODE") __attribute__((section("sfrs")));
extern volatile unsigned int        U4MODECLR __attribute__((section("sfrs")));
extern volatile unsigned int        UGHMODECLR __attribute__((section("sfrs")));
extern volatile unsigned int        U4MODESET __attribute__((section("sfrs")));
extern volatile unsigned int        UGHMODESET __attribute__((section("sfrs")));
extern volatile unsigned int        U4MODEINV __attribute__((section("sfrs")));
extern volatile unsigned int        UGHMODEINV __attribute__((section("sfrs")));
extern volatile unsigned int        U4STA __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned URXDA:1;
    unsigned OERR:1;
    unsigned FERR:1;
    unsigned PERR:1;
    unsigned RIDLE:1;
    unsigned ADDEN:1;
    unsigned URXISEL:2;
    unsigned TRMT:1;
    unsigned UTXBF:1;
    unsigned UTXEN:1;
    unsigned UTXBRK:1;
    unsigned URXEN:1;
    unsigned UTXINV:1;
    unsigned UTXISEL:2;
    unsigned ADDR:8;
    unsigned ADM_EN:1;
  };
  struct {
    unsigned :6;
    unsigned URXISEL0:1;
    unsigned URXISEL1:1;
    unsigned :6;
    unsigned UTXISEL0:1;
    unsigned UTXISEL1:1;
  };
  struct {
    unsigned :14;
    unsigned UTXSEL:2;
  };
  struct {
    unsigned w:32;
  };
} __U4STAbits_t;
extern volatile __U4STAbits_t U4STAbits __asm__ ("U4STA") __attribute__((section("sfrs")));
extern volatile unsigned int        UGHSTA __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned URXDA:1;
    unsigned OERR:1;
    unsigned FERR:1;
    unsigned PERR:1;
    unsigned RIDLE:1;
    unsigned ADDEN:1;
    unsigned URXISEL:2;
    unsigned TRMT:1;
    unsigned UTXBF:1;
    unsigned UTXEN:1;
    unsigned UTXBRK:1;
    unsigned URXEN:1;
    unsigned UTXINV:1;
    unsigned UTXISEL:2;
    unsigned ADDR:8;
    unsigned ADM_EN:1;
  };
  struct {
    unsigned :6;
    unsigned URXISEL0:1;
    unsigned URXISEL1:1;
    unsigned :6;
    unsigned UTXISEL0:1;
    unsigned UTXISEL1:1;
  };
  struct {
    unsigned :14;
    unsigned UTXSEL:2;
  };
  struct {
    unsigned w:32;
  };
} __UGHSTAbits_t;
extern volatile __UGHSTAbits_t UGHSTAbits __asm__ ("UGHSTA") __attribute__((section("sfrs")));
extern volatile unsigned int        U4STACLR __attribute__((section("sfrs")));
extern volatile unsigned int        UGHSTACLR __attribute__((section("sfrs")));
extern volatile unsigned int        U4STASET __attribute__((section("sfrs")));
extern volatile unsigned int        UGHSTASET __attribute__((section("sfrs")));
extern volatile unsigned int        U4STAINV __attribute__((section("sfrs")));
extern volatile unsigned int        UGHSTAINV __attribute__((section("sfrs")));
extern volatile unsigned int        U4TXREG __attribute__((section("sfrs")));
extern volatile unsigned int        UGHTXREG __attribute__((section("sfrs")));
extern volatile unsigned int        U4RXREG __attribute__((section("sfrs")));
extern volatile unsigned int        UGHRXREG __attribute__((section("sfrs")));
extern volatile unsigned int        U4BRG __attribute__((section("sfrs")));
extern volatile unsigned int        UGHBRG __attribute__((section("sfrs")));
extern volatile unsigned int        U4BRGCLR __attribute__((section("sfrs")));
extern volatile unsigned int        UGHBRGCLR __attribute__((section("sfrs")));
extern volatile unsigned int        U4BRGSET __attribute__((section("sfrs")));
extern volatile unsigned int        UGHBRGSET __attribute__((section("sfrs")));
extern volatile unsigned int        U4BRGINV __attribute__((section("sfrs")));
extern volatile unsigned int        UGHBRGINV __attribute__((section("sfrs")));
extern volatile unsigned int        U5MODE __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned STSEL:1;
    unsigned PDSEL:2;
    unsigned BRGH:1;
    unsigned RXINV:1;
    unsigned ABAUD:1;
    unsigned LPBACK:1;
    unsigned WAKE:1;
    unsigned UEN:2;
    unsigned :1;
    unsigned RTSMD:1;
    unsigned IREN:1;
    unsigned SIDL:1;
    unsigned :1;
    unsigned ON:1;
  };
  struct {
    unsigned :1;
    unsigned PDSEL0:1;
    unsigned PDSEL1:1;
    unsigned :5;
    unsigned UEN0:1;
    unsigned UEN1:1;
  };
  struct {
    unsigned :13;
    unsigned USIDL:1;
    unsigned :1;
    unsigned UARTEN:1;
  };
  struct {
    unsigned w:32;
  };
} __U5MODEbits_t;
extern volatile __U5MODEbits_t U5MODEbits __asm__ ("U5MODE") __attribute__((section("sfrs")));
extern volatile unsigned int        UJKMODE __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned STSEL:1;
    unsigned PDSEL:2;
    unsigned BRGH:1;
    unsigned RXINV:1;
    unsigned ABAUD:1;
    unsigned LPBACK:1;
    unsigned WAKE:1;
    unsigned UEN:2;
    unsigned :1;
    unsigned RTSMD:1;
    unsigned IREN:1;
    unsigned SIDL:1;
    unsigned :1;
    unsigned ON:1;
  };
  struct {
    unsigned :1;
    unsigned PDSEL0:1;
    unsigned PDSEL1:1;
    unsigned :5;
    unsigned UEN0:1;
    unsigned UEN1:1;
  };
  struct {
    unsigned :13;
    unsigned USIDL:1;
    unsigned :1;
    unsigned UARTEN:1;
  };
  struct {
    unsigned w:32;
  };
} __UJKMODEbits_t;
extern volatile __UJKMODEbits_t UJKMODEbits __asm__ ("UJKMODE") __attribute__((section("sfrs")));
extern volatile unsigned int        U5MODECLR __attribute__((section("sfrs")));
extern volatile unsigned int        UJKMODECLR __attribute__((section("sfrs")));
extern volatile unsigned int        U5MODESET __attribute__((section("sfrs")));
extern volatile unsigned int        UJKMODESET __attribute__((section("sfrs")));
extern volatile unsigned int        U5MODEINV __attribute__((section("sfrs")));
extern volatile unsigned int        UJKMODEINV __attribute__((section("sfrs")));
extern volatile unsigned int        U5STA __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned URXDA:1;
    unsigned OERR:1;
    unsigned FERR:1;
    unsigned PERR:1;
    unsigned RIDLE:1;
    unsigned ADDEN:1;
    unsigned URXISEL:2;
    unsigned TRMT:1;
    unsigned UTXBF:1;
    unsigned UTXEN:1;
    unsigned UTXBRK:1;
    unsigned URXEN:1;
    unsigned UTXINV:1;
    unsigned UTXISEL:2;
    unsigned ADDR:8;
    unsigned ADM_EN:1;
  };
  struct {
    unsigned :6;
    unsigned URXISEL0:1;
    unsigned URXISEL1:1;
    unsigned :6;
    unsigned UTXISEL0:1;
    unsigned UTXISEL1:1;
  };
  struct {
    unsigned :14;
    unsigned UTXSEL:2;
  };
  struct {
    unsigned w:32;
  };
} __U5STAbits_t;
extern volatile __U5STAbits_t U5STAbits __asm__ ("U5STA") __attribute__((section("sfrs")));
extern volatile unsigned int        UJKSTA __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned URXDA:1;
    unsigned OERR:1;
    unsigned FERR:1;
    unsigned PERR:1;
    unsigned RIDLE:1;
    unsigned ADDEN:1;
    unsigned URXISEL:2;
    unsigned TRMT:1;
    unsigned UTXBF:1;
    unsigned UTXEN:1;
    unsigned UTXBRK:1;
    unsigned URXEN:1;
    unsigned UTXINV:1;
    unsigned UTXISEL:2;
    unsigned ADDR:8;
    unsigned ADM_EN:1;
  };
  struct {
    unsigned :6;
    unsigned URXISEL0:1;
    unsigned URXISEL1:1;
    unsigned :6;
    unsigned UTXISEL0:1;
    unsigned UTXISEL1:1;
  };
  struct {
    unsigned :14;
    unsigned UTXSEL:2;
  };
  struct {
    unsigned w:32;
  };
} __UJKSTAbits_t;
extern volatile __UJKSTAbits_t UJKSTAbits __asm__ ("UJKSTA") __attribute__((section("sfrs")));
extern volatile unsigned int        U5STACLR __attribute__((section("sfrs")));
extern volatile unsigned int        UJKSTACLR __attribute__((section("sfrs")));
extern volatile unsigned int        U5STASET __attribute__((section("sfrs")));
extern volatile unsigned int        UJKSTASET __attribute__((section("sfrs")));
extern volatile unsigned int        U5STAINV __attribute__((section("sfrs")));
extern volatile unsigned int        UJKSTAINV __attribute__((section("sfrs")));
extern volatile unsigned int        U5TXREG __attribute__((section("sfrs")));
extern volatile unsigned int        UJKTXREG __attribute__((section("sfrs")));
extern volatile unsigned int        U5RXREG __attribute__((section("sfrs")));
extern volatile unsigned int        UJKRXREG __attribute__((section("sfrs")));
extern volatile unsigned int        U5BRG __attribute__((section("sfrs")));
extern volatile unsigned int        UJKBRG __attribute__((section("sfrs")));
extern volatile unsigned int        U5BRGCLR __attribute__((section("sfrs")));
extern volatile unsigned int        UJKBRGCLR __attribute__((section("sfrs")));
extern volatile unsigned int        U5BRGSET __attribute__((section("sfrs")));
extern volatile unsigned int        UJKBRGSET __attribute__((section("sfrs")));
extern volatile unsigned int        U5BRGINV __attribute__((section("sfrs")));
extern volatile unsigned int        UJKBRGINV __attribute__((section("sfrs")));
extern volatile unsigned int        U6MODE __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned STSEL:1;
    unsigned PDSEL:2;
    unsigned BRGH:1;
    unsigned RXINV:1;
    unsigned ABAUD:1;
    unsigned LPBACK:1;
    unsigned WAKE:1;
    unsigned UEN:2;
    unsigned :1;
    unsigned RTSMD:1;
    unsigned IREN:1;
    unsigned SIDL:1;
    unsigned :1;
    unsigned ON:1;
  };
  struct {
    unsigned :1;
    unsigned PDSEL0:1;
    unsigned PDSEL1:1;
    unsigned :5;
    unsigned UEN0:1;
    unsigned UEN1:1;
  };
  struct {
    unsigned :13;
    unsigned USIDL:1;
    unsigned :1;
    unsigned UARTEN:1;
  };
  struct {
    unsigned w:32;
  };
} __U6MODEbits_t;
extern volatile __U6MODEbits_t U6MODEbits __asm__ ("U6MODE") __attribute__((section("sfrs")));
extern volatile unsigned int        ULMMODE __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned STSEL:1;
    unsigned PDSEL:2;
    unsigned BRGH:1;
    unsigned RXINV:1;
    unsigned ABAUD:1;
    unsigned LPBACK:1;
    unsigned WAKE:1;
    unsigned UEN:2;
    unsigned :1;
    unsigned RTSMD:1;
    unsigned IREN:1;
    unsigned SIDL:1;
    unsigned :1;
    unsigned ON:1;
  };
  struct {
    unsigned :1;
    unsigned PDSEL0:1;
    unsigned PDSEL1:1;
    unsigned :5;
    unsigned UEN0:1;
    unsigned UEN1:1;
  };
  struct {
    unsigned :13;
    unsigned USIDL:1;
    unsigned :1;
    unsigned UARTEN:1;
  };
  struct {
    unsigned w:32;
  };
} __ULMMODEbits_t;
extern volatile __ULMMODEbits_t ULMMODEbits __asm__ ("ULMMODE") __attribute__((section("sfrs")));
extern volatile unsigned int        U6MODECLR __attribute__((section("sfrs")));
extern volatile unsigned int        ULMMODECLR __attribute__((section("sfrs")));
extern volatile unsigned int        U6MODESET __attribute__((section("sfrs")));
extern volatile unsigned int        ULMMODESET __attribute__((section("sfrs")));
extern volatile unsigned int        U6MODEINV __attribute__((section("sfrs")));
extern volatile unsigned int        ULMMODEINV __attribute__((section("sfrs")));
extern volatile unsigned int        U6STA __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned URXDA:1;
    unsigned OERR:1;
    unsigned FERR:1;
    unsigned PERR:1;
    unsigned RIDLE:1;
    unsigned ADDEN:1;
    unsigned URXISEL:2;
    unsigned TRMT:1;
    unsigned UTXBF:1;
    unsigned UTXEN:1;
    unsigned UTXBRK:1;
    unsigned URXEN:1;
    unsigned UTXINV:1;
    unsigned UTXISEL:2;
    unsigned ADDR:8;
    unsigned ADM_EN:1;
  };
  struct {
    unsigned :6;
    unsigned URXISEL0:1;
    unsigned URXISEL1:1;
    unsigned :6;
    unsigned UTXISEL0:1;
    unsigned UTXISEL1:1;
  };
  struct {
    unsigned :14;
    unsigned UTXSEL:2;
  };
  struct {
    unsigned w:32;
  };
} __U6STAbits_t;
extern volatile __U6STAbits_t U6STAbits __asm__ ("U6STA") __attribute__((section("sfrs")));
extern volatile unsigned int        ULMSTA __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned URXDA:1;
    unsigned OERR:1;
    unsigned FERR:1;
    unsigned PERR:1;
    unsigned RIDLE:1;
    unsigned ADDEN:1;
    unsigned URXISEL:2;
    unsigned TRMT:1;
    unsigned UTXBF:1;
    unsigned UTXEN:1;
    unsigned UTXBRK:1;
    unsigned URXEN:1;
    unsigned UTXINV:1;
    unsigned UTXISEL:2;
    unsigned ADDR:8;
    unsigned ADM_EN:1;
  };
  struct {
    unsigned :6;
    unsigned URXISEL0:1;
    unsigned URXISEL1:1;
    unsigned :6;
    unsigned UTXISEL0:1;
    unsigned UTXISEL1:1;
  };
  struct {
    unsigned :14;
    unsigned UTXSEL:2;
  };
  struct {
    unsigned w:32;
  };
} __ULMSTAbits_t;
extern volatile __ULMSTAbits_t ULMSTAbits __asm__ ("ULMSTA") __attribute__((section("sfrs")));
extern volatile unsigned int        U6STACLR __attribute__((section("sfrs")));
extern volatile unsigned int        ULMSTACLR __attribute__((section("sfrs")));
extern volatile unsigned int        U6STASET __attribute__((section("sfrs")));
extern volatile unsigned int        ULMSTASET __attribute__((section("sfrs")));
extern volatile unsigned int        U6STAINV __attribute__((section("sfrs")));
extern volatile unsigned int        ULMSTAINV __attribute__((section("sfrs")));
extern volatile unsigned int        U6TXREG __attribute__((section("sfrs")));
extern volatile unsigned int        ULMTXREG __attribute__((section("sfrs")));
extern volatile unsigned int        U6RXREG __attribute__((section("sfrs")));
extern volatile unsigned int        ULMRXREG __attribute__((section("sfrs")));
extern volatile unsigned int        U6BRG __attribute__((section("sfrs")));
extern volatile unsigned int        ULMBRG __attribute__((section("sfrs")));
extern volatile unsigned int        U6BRGCLR __attribute__((section("sfrs")));
extern volatile unsigned int        ULMBRGCLR __attribute__((section("sfrs")));
extern volatile unsigned int        U6BRGSET __attribute__((section("sfrs")));
extern volatile unsigned int        ULMBRGSET __attribute__((section("sfrs")));
extern volatile unsigned int        U6BRGINV __attribute__((section("sfrs")));
extern volatile unsigned int        ULMBRGINV __attribute__((section("sfrs")));
extern volatile unsigned int        PMCON __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RDSP:1;
    unsigned WRSP:1;
    unsigned :1;
    unsigned CS1P:1;
    unsigned CS2P:1;
    unsigned ALP:1;
    unsigned CSF:2;
    unsigned PTRDEN:1;
    unsigned PTWREN:1;
    unsigned PMPTTL:1;
    unsigned ADRMUX:2;
    unsigned SIDL:1;
    unsigned :1;
    unsigned ON:1;
  };
  struct {
    unsigned :6;
    unsigned CSF0:1;
    unsigned CSF1:1;
    unsigned :3;
    unsigned ADRMUX0:1;
    unsigned ADRMUX1:1;
  };
  struct {
    unsigned :13;
    unsigned PSIDL:1;
    unsigned :1;
    unsigned PMPEN:1;
  };
  struct {
    unsigned w:32;
  };
} __PMCONbits_t;
extern volatile __PMCONbits_t PMCONbits __asm__ ("PMCON") __attribute__((section("sfrs")));
extern volatile unsigned int        PMCONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        PMCONSET __attribute__((section("sfrs")));
extern volatile unsigned int        PMCONINV __attribute__((section("sfrs")));
extern volatile unsigned int        PMMODE __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned WAITE:2;
    unsigned WAITM:4;
    unsigned WAITB:2;
    unsigned MODE:2;
    unsigned MODE16:1;
    unsigned INCM:2;
    unsigned IRQM:2;
    unsigned BUSY:1;
  };
  struct {
    unsigned WAITE0:1;
    unsigned WAITE1:1;
    unsigned WAITM0:1;
    unsigned WAITM1:1;
    unsigned WAITM2:1;
    unsigned WAITM3:1;
    unsigned WAITB0:1;
    unsigned WAITB1:1;
    unsigned MODE0:1;
    unsigned MODE1:1;
    unsigned :1;
    unsigned INCM0:1;
    unsigned INCM1:1;
    unsigned IRQM0:1;
    unsigned IRQM1:1;
  };
  struct {
    unsigned w:32;
  };
} __PMMODEbits_t;
extern volatile __PMMODEbits_t PMMODEbits __asm__ ("PMMODE") __attribute__((section("sfrs")));
extern volatile unsigned int        PMMODECLR __attribute__((section("sfrs")));
extern volatile unsigned int        PMMODESET __attribute__((section("sfrs")));
extern volatile unsigned int        PMMODEINV __attribute__((section("sfrs")));
extern volatile unsigned int        PMADDR __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned ADDR:14;
    unsigned CS:2;
  };
  struct {
    unsigned PADDR:14;
  };
  struct {
    unsigned :14;
    unsigned CS1:1;
    unsigned CS2:1;
  };
  struct {
    unsigned w:32;
  };
} __PMADDRbits_t;
extern volatile __PMADDRbits_t PMADDRbits __asm__ ("PMADDR") __attribute__((section("sfrs")));
extern volatile unsigned int        PMADDRCLR __attribute__((section("sfrs")));
extern volatile unsigned int        PMADDRSET __attribute__((section("sfrs")));
extern volatile unsigned int        PMADDRINV __attribute__((section("sfrs")));
extern volatile unsigned int        PMDOUT __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned DATAOUT:32;
  };
  struct {
    unsigned w:32;
  };
} __PMDOUTbits_t;
extern volatile __PMDOUTbits_t PMDOUTbits __asm__ ("PMDOUT") __attribute__((section("sfrs")));
extern volatile unsigned int        PMDOUTCLR __attribute__((section("sfrs")));
extern volatile unsigned int        PMDOUTSET __attribute__((section("sfrs")));
extern volatile unsigned int        PMDOUTINV __attribute__((section("sfrs")));
extern volatile unsigned int        PMDIN __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned DATAIN:32;
  };
  struct {
    unsigned w:32;
  };
} __PMDINbits_t;
extern volatile __PMDINbits_t PMDINbits __asm__ ("PMDIN") __attribute__((section("sfrs")));
extern volatile unsigned int        PMDINCLR __attribute__((section("sfrs")));
extern volatile unsigned int        PMDINSET __attribute__((section("sfrs")));
extern volatile unsigned int        PMDININV __attribute__((section("sfrs")));
extern volatile unsigned int        PMAEN __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned PTEN:16;
  };
  struct {
    unsigned PTEN0:1;
    unsigned PTEN1:1;
    unsigned PTEN2:1;
    unsigned PTEN3:1;
    unsigned PTEN4:1;
    unsigned PTEN5:1;
    unsigned PTEN6:1;
    unsigned PTEN7:1;
    unsigned PTEN8:1;
    unsigned PTEN9:1;
    unsigned PTEN10:1;
    unsigned PTEN11:1;
    unsigned PTEN12:1;
    unsigned PTEN13:1;
    unsigned PTEN14:1;
    unsigned PTEN15:1;
  };
  struct {
    unsigned w:32;
  };
} __PMAENbits_t;
extern volatile __PMAENbits_t PMAENbits __asm__ ("PMAEN") __attribute__((section("sfrs")));
extern volatile unsigned int        PMAENCLR __attribute__((section("sfrs")));
extern volatile unsigned int        PMAENSET __attribute__((section("sfrs")));
extern volatile unsigned int        PMAENINV __attribute__((section("sfrs")));
extern volatile unsigned int        PMSTAT __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned OB0E:1;
    unsigned OB1E:1;
    unsigned OB2E:1;
    unsigned OB3E:1;
    unsigned :2;
    unsigned OBUF:1;
    unsigned OBE:1;
    unsigned IB0F:1;
    unsigned IB1F:1;
    unsigned IB2F:1;
    unsigned IB3F:1;
    unsigned :2;
    unsigned IBOV:1;
    unsigned IBF:1;
  };
  struct {
    unsigned w:32;
  };
} __PMSTATbits_t;
extern volatile __PMSTATbits_t PMSTATbits __asm__ ("PMSTAT") __attribute__((section("sfrs")));
extern volatile unsigned int        PMSTATCLR __attribute__((section("sfrs")));
extern volatile unsigned int        PMSTATSET __attribute__((section("sfrs")));
extern volatile unsigned int        PMSTATINV __attribute__((section("sfrs")));
extern volatile unsigned int        T1CON __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned :1;
    unsigned TCS:1;
    unsigned TSYNC:1;
    unsigned :1;
    unsigned TCKPS:2;
    unsigned :1;
    unsigned TGATE:1;
    unsigned :3;
    unsigned TWIP:1;
    unsigned TWDIS:1;
    unsigned SIDL:1;
    unsigned :1;
    unsigned ON:1;
  };
  struct {
    unsigned :4;
    unsigned TCKPS0:1;
    unsigned TCKPS1:1;
  };
  struct {
    unsigned :13;
    unsigned TSIDL:1;
    unsigned :1;
    unsigned TON:1;
  };
  struct {
    unsigned w:32;
  };
} __T1CONbits_t;
extern volatile __T1CONbits_t T1CONbits __asm__ ("T1CON") __attribute__((section("sfrs")));
extern volatile unsigned int        T1CONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        T1CONSET __attribute__((section("sfrs")));
extern volatile unsigned int        T1CONINV __attribute__((section("sfrs")));
extern volatile unsigned int        TMR1 __attribute__((section("sfrs")));
extern volatile unsigned int        TMR1CLR __attribute__((section("sfrs")));
extern volatile unsigned int        TMR1SET __attribute__((section("sfrs")));
extern volatile unsigned int        TMR1INV __attribute__((section("sfrs")));
extern volatile unsigned int        PR1 __attribute__((section("sfrs")));
extern volatile unsigned int        PR1CLR __attribute__((section("sfrs")));
extern volatile unsigned int        PR1SET __attribute__((section("sfrs")));
extern volatile unsigned int        PR1INV __attribute__((section("sfrs")));
extern volatile unsigned int        T2CON __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned :1;
    unsigned TCS:1;
    unsigned :1;
    unsigned T32:1;
    unsigned TCKPS:3;
    unsigned TGATE:1;
    unsigned :5;
    unsigned SIDL:1;
    unsigned :1;
    unsigned ON:1;
  };
  struct {
    unsigned :4;
    unsigned TCKPS0:1;
    unsigned TCKPS1:1;
    unsigned TCKPS2:1;
  };
  struct {
    unsigned :13;
    unsigned TSIDL:1;
    unsigned :1;
    unsigned TON:1;
  };
  struct {
    unsigned w:32;
  };
} __T2CONbits_t;
extern volatile __T2CONbits_t T2CONbits __asm__ ("T2CON") __attribute__((section("sfrs")));
extern volatile unsigned int        T2CONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        T2CONSET __attribute__((section("sfrs")));
extern volatile unsigned int        T2CONINV __attribute__((section("sfrs")));
extern volatile unsigned int        TMR2 __attribute__((section("sfrs")));
extern volatile unsigned int        TMR2CLR __attribute__((section("sfrs")));
extern volatile unsigned int        TMR2SET __attribute__((section("sfrs")));
extern volatile unsigned int        TMR2INV __attribute__((section("sfrs")));
extern volatile unsigned int        PR2 __attribute__((section("sfrs")));
extern volatile unsigned int        PR2CLR __attribute__((section("sfrs")));
extern volatile unsigned int        PR2SET __attribute__((section("sfrs")));
extern volatile unsigned int        PR2INV __attribute__((section("sfrs")));
extern volatile unsigned int        T3CON __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned :1;
    unsigned TCS:1;
    unsigned :2;
    unsigned TCKPS:3;
    unsigned TGATE:1;
    unsigned :5;
    unsigned SIDL:1;
    unsigned :1;
    unsigned ON:1;
  };
  struct {
    unsigned :4;
    unsigned TCKPS0:1;
    unsigned TCKPS1:1;
    unsigned TCKPS2:1;
  };
  struct {
    unsigned :13;
    unsigned TSIDL:1;
    unsigned :1;
    unsigned TON:1;
  };
  struct {
    unsigned w:32;
  };
} __T3CONbits_t;
extern volatile __T3CONbits_t T3CONbits __asm__ ("T3CON") __attribute__((section("sfrs")));
extern volatile unsigned int        T3CONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        T3CONSET __attribute__((section("sfrs")));
extern volatile unsigned int        T3CONINV __attribute__((section("sfrs")));
extern volatile unsigned int        TMR3 __attribute__((section("sfrs")));
extern volatile unsigned int        TMR3CLR __attribute__((section("sfrs")));
extern volatile unsigned int        TMR3SET __attribute__((section("sfrs")));
extern volatile unsigned int        TMR3INV __attribute__((section("sfrs")));
extern volatile unsigned int        PR3 __attribute__((section("sfrs")));
extern volatile unsigned int        PR3CLR __attribute__((section("sfrs")));
extern volatile unsigned int        PR3SET __attribute__((section("sfrs")));
extern volatile unsigned int        PR3INV __attribute__((section("sfrs")));
extern volatile unsigned int        T4CON __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned :1;
    unsigned TCS:1;
    unsigned :1;
    unsigned T32:1;
    unsigned TCKPS:3;
    unsigned TGATE:1;
    unsigned :5;
    unsigned SIDL:1;
    unsigned :1;
    unsigned ON:1;
  };
  struct {
    unsigned :4;
    unsigned TCKPS0:1;
    unsigned TCKPS1:1;
    unsigned TCKPS2:1;
  };
  struct {
    unsigned :13;
    unsigned TSIDL:1;
    unsigned :1;
    unsigned TON:1;
  };
  struct {
    unsigned w:32;
  };
} __T4CONbits_t;
extern volatile __T4CONbits_t T4CONbits __asm__ ("T4CON") __attribute__((section("sfrs")));
extern volatile unsigned int        T4CONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        T4CONSET __attribute__((section("sfrs")));
extern volatile unsigned int        T4CONINV __attribute__((section("sfrs")));
extern volatile unsigned int        TMR4 __attribute__((section("sfrs")));
extern volatile unsigned int        TMR4CLR __attribute__((section("sfrs")));
extern volatile unsigned int        TMR4SET __attribute__((section("sfrs")));
extern volatile unsigned int        TMR4INV __attribute__((section("sfrs")));
extern volatile unsigned int        PR4 __attribute__((section("sfrs")));
extern volatile unsigned int        PR4CLR __attribute__((section("sfrs")));
extern volatile unsigned int        PR4SET __attribute__((section("sfrs")));
extern volatile unsigned int        PR4INV __attribute__((section("sfrs")));
extern volatile unsigned int        T5CON __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned :1;
    unsigned TCS:1;
    unsigned :2;
    unsigned TCKPS:3;
    unsigned TGATE:1;
    unsigned :5;
    unsigned SIDL:1;
    unsigned :1;
    unsigned ON:1;
  };
  struct {
    unsigned :4;
    unsigned TCKPS0:1;
    unsigned TCKPS1:1;
    unsigned TCKPS2:1;
  };
  struct {
    unsigned :13;
    unsigned TSIDL:1;
    unsigned :1;
    unsigned TON:1;
  };
  struct {
    unsigned w:32;
  };
} __T5CONbits_t;
extern volatile __T5CONbits_t T5CONbits __asm__ ("T5CON") __attribute__((section("sfrs")));
extern volatile unsigned int        T5CONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        T5CONSET __attribute__((section("sfrs")));
extern volatile unsigned int        T5CONINV __attribute__((section("sfrs")));
extern volatile unsigned int        TMR5 __attribute__((section("sfrs")));
extern volatile unsigned int        TMR5CLR __attribute__((section("sfrs")));
extern volatile unsigned int        TMR5SET __attribute__((section("sfrs")));
extern volatile unsigned int        TMR5INV __attribute__((section("sfrs")));
extern volatile unsigned int        PR5 __attribute__((section("sfrs")));
extern volatile unsigned int        PR5CLR __attribute__((section("sfrs")));
extern volatile unsigned int        PR5SET __attribute__((section("sfrs")));
extern volatile unsigned int        PR5INV __attribute__((section("sfrs")));
extern volatile unsigned int        T6CON __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned :1;
    unsigned TCS:1;
    unsigned :1;
    unsigned T32:1;
    unsigned TCKPS:3;
    unsigned TGATE:1;
    unsigned :5;
    unsigned SIDL:1;
    unsigned :1;
    unsigned ON:1;
  };
  struct {
    unsigned :4;
    unsigned TCKPS0:1;
    unsigned TCKPS1:1;
    unsigned TCKPS2:1;
  };
  struct {
    unsigned :13;
    unsigned TSIDL:1;
    unsigned :1;
    unsigned TON:1;
  };
  struct {
    unsigned w:32;
  };
} __T6CONbits_t;
extern volatile __T6CONbits_t T6CONbits __asm__ ("T6CON") __attribute__((section("sfrs")));
extern volatile unsigned int        T6CONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        T6CONSET __attribute__((section("sfrs")));
extern volatile unsigned int        T6CONINV __attribute__((section("sfrs")));
extern volatile unsigned int        TMR6 __attribute__((section("sfrs")));
extern volatile unsigned int        TMR6CLR __attribute__((section("sfrs")));
extern volatile unsigned int        TMR6SET __attribute__((section("sfrs")));
extern volatile unsigned int        TMR6INV __attribute__((section("sfrs")));
extern volatile unsigned int        PR6 __attribute__((section("sfrs")));
extern volatile unsigned int        PR6CLR __attribute__((section("sfrs")));
extern volatile unsigned int        PR6SET __attribute__((section("sfrs")));
extern volatile unsigned int        PR6INV __attribute__((section("sfrs")));
extern volatile unsigned int        T7CON __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned :1;
    unsigned TCS:1;
    unsigned :2;
    unsigned TCKPS:3;
    unsigned TGATE:1;
    unsigned :5;
    unsigned SIDL:1;
    unsigned :1;
    unsigned ON:1;
  };
  struct {
    unsigned :4;
    unsigned TCKPS0:1;
    unsigned TCKPS1:1;
    unsigned TCKPS2:1;
  };
  struct {
    unsigned :13;
    unsigned TSIDL:1;
    unsigned :1;
    unsigned TON:1;
  };
  struct {
    unsigned w:32;
  };
} __T7CONbits_t;
extern volatile __T7CONbits_t T7CONbits __asm__ ("T7CON") __attribute__((section("sfrs")));
extern volatile unsigned int        T7CONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        T7CONSET __attribute__((section("sfrs")));
extern volatile unsigned int        T7CONINV __attribute__((section("sfrs")));
extern volatile unsigned int        TMR7 __attribute__((section("sfrs")));
extern volatile unsigned int        TMR7CLR __attribute__((section("sfrs")));
extern volatile unsigned int        TMR7SET __attribute__((section("sfrs")));
extern volatile unsigned int        TMR7INV __attribute__((section("sfrs")));
extern volatile unsigned int        PR7 __attribute__((section("sfrs")));
extern volatile unsigned int        PR7CLR __attribute__((section("sfrs")));
extern volatile unsigned int        PR7SET __attribute__((section("sfrs")));
extern volatile unsigned int        PR7INV __attribute__((section("sfrs")));
extern volatile unsigned int        T8CON __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned :1;
    unsigned TCS:1;
    unsigned :1;
    unsigned T32:1;
    unsigned TCKPS:3;
    unsigned TGATE:1;
    unsigned :5;
    unsigned SIDL:1;
    unsigned :1;
    unsigned ON:1;
  };
  struct {
    unsigned :4;
    unsigned TCKPS0:1;
    unsigned TCKPS1:1;
    unsigned TCKPS2:1;
  };
  struct {
    unsigned :13;
    unsigned TSIDL:1;
    unsigned :1;
    unsigned TON:1;
  };
  struct {
    unsigned w:32;
  };
} __T8CONbits_t;
extern volatile __T8CONbits_t T8CONbits __asm__ ("T8CON") __attribute__((section("sfrs")));
extern volatile unsigned int        T8CONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        T8CONSET __attribute__((section("sfrs")));
extern volatile unsigned int        T8CONINV __attribute__((section("sfrs")));
extern volatile unsigned int        TMR8 __attribute__((section("sfrs")));
extern volatile unsigned int        TMR8CLR __attribute__((section("sfrs")));
extern volatile unsigned int        TMR8SET __attribute__((section("sfrs")));
extern volatile unsigned int        TMR8INV __attribute__((section("sfrs")));
extern volatile unsigned int        PR8 __attribute__((section("sfrs")));
extern volatile unsigned int        PR8CLR __attribute__((section("sfrs")));
extern volatile unsigned int        PR8SET __attribute__((section("sfrs")));
extern volatile unsigned int        PR8INV __attribute__((section("sfrs")));
extern volatile unsigned int        T9CON __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned :1;
    unsigned TCS:1;
    unsigned :2;
    unsigned TCKPS:3;
    unsigned TGATE:1;
    unsigned :5;
    unsigned SIDL:1;
    unsigned :1;
    unsigned ON:1;
  };
  struct {
    unsigned :4;
    unsigned TCKPS0:1;
    unsigned TCKPS1:1;
    unsigned TCKPS2:1;
  };
  struct {
    unsigned :13;
    unsigned TSIDL:1;
    unsigned :1;
    unsigned TON:1;
  };
  struct {
    unsigned w:32;
  };
} __T9CONbits_t;
extern volatile __T9CONbits_t T9CONbits __asm__ ("T9CON") __attribute__((section("sfrs")));
extern volatile unsigned int        T9CONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        T9CONSET __attribute__((section("sfrs")));
extern volatile unsigned int        T9CONINV __attribute__((section("sfrs")));
extern volatile unsigned int        TMR9 __attribute__((section("sfrs")));
extern volatile unsigned int        TMR9CLR __attribute__((section("sfrs")));
extern volatile unsigned int        TMR9SET __attribute__((section("sfrs")));
extern volatile unsigned int        TMR9INV __attribute__((section("sfrs")));
extern volatile unsigned int        PR9 __attribute__((section("sfrs")));
extern volatile unsigned int        PR9CLR __attribute__((section("sfrs")));
extern volatile unsigned int        PR9SET __attribute__((section("sfrs")));
extern volatile unsigned int        PR9INV __attribute__((section("sfrs")));
extern volatile unsigned int        IC1CON __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned ICM:3;
    unsigned ICBNE:1;
    unsigned ICOV:1;
    unsigned ICI:2;
    unsigned ICTMR:1;
    unsigned C32:1;
    unsigned FEDGE:1;
    unsigned :3;
    unsigned SIDL:1;
    unsigned :1;
    unsigned ON:1;
  };
  struct {
    unsigned ICM0:1;
    unsigned ICM1:1;
    unsigned ICM2:1;
    unsigned :2;
    unsigned ICI0:1;
    unsigned ICI1:1;
  };
  struct {
    unsigned :13;
    unsigned ICSIDL:1;
  };
  struct {
    unsigned w:32;
  };
} __IC1CONbits_t;
extern volatile __IC1CONbits_t IC1CONbits __asm__ ("IC1CON") __attribute__((section("sfrs")));
extern volatile unsigned int        IC1CONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        IC1CONSET __attribute__((section("sfrs")));
extern volatile unsigned int        IC1CONINV __attribute__((section("sfrs")));
extern volatile unsigned int        IC1BUF __attribute__((section("sfrs")));
extern volatile unsigned int        IC2CON __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned ICM:3;
    unsigned ICBNE:1;
    unsigned ICOV:1;
    unsigned ICI:2;
    unsigned ICTMR:1;
    unsigned C32:1;
    unsigned FEDGE:1;
    unsigned :3;
    unsigned SIDL:1;
    unsigned :1;
    unsigned ON:1;
  };
  struct {
    unsigned ICM0:1;
    unsigned ICM1:1;
    unsigned ICM2:1;
    unsigned :2;
    unsigned ICI0:1;
    unsigned ICI1:1;
  };
  struct {
    unsigned :13;
    unsigned ICSIDL:1;
  };
  struct {
    unsigned w:32;
  };
} __IC2CONbits_t;
extern volatile __IC2CONbits_t IC2CONbits __asm__ ("IC2CON") __attribute__((section("sfrs")));
extern volatile unsigned int        IC2CONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        IC2CONSET __attribute__((section("sfrs")));
extern volatile unsigned int        IC2CONINV __attribute__((section("sfrs")));
extern volatile unsigned int        IC2BUF __attribute__((section("sfrs")));
extern volatile unsigned int        IC3CON __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned ICM:3;
    unsigned ICBNE:1;
    unsigned ICOV:1;
    unsigned ICI:2;
    unsigned ICTMR:1;
    unsigned C32:1;
    unsigned FEDGE:1;
    unsigned :3;
    unsigned SIDL:1;
    unsigned :1;
    unsigned ON:1;
  };
  struct {
    unsigned ICM0:1;
    unsigned ICM1:1;
    unsigned ICM2:1;
    unsigned :2;
    unsigned ICI0:1;
    unsigned ICI1:1;
  };
  struct {
    unsigned :13;
    unsigned ICSIDL:1;
  };
  struct {
    unsigned w:32;
  };
} __IC3CONbits_t;
extern volatile __IC3CONbits_t IC3CONbits __asm__ ("IC3CON") __attribute__((section("sfrs")));
extern volatile unsigned int        IC3CONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        IC3CONSET __attribute__((section("sfrs")));
extern volatile unsigned int        IC3CONINV __attribute__((section("sfrs")));
extern volatile unsigned int        IC3BUF __attribute__((section("sfrs")));
extern volatile unsigned int        IC4CON __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned ICM:3;
    unsigned ICBNE:1;
    unsigned ICOV:1;
    unsigned ICI:2;
    unsigned ICTMR:1;
    unsigned C32:1;
    unsigned FEDGE:1;
    unsigned :3;
    unsigned SIDL:1;
    unsigned :1;
    unsigned ON:1;
  };
  struct {
    unsigned ICM0:1;
    unsigned ICM1:1;
    unsigned ICM2:1;
    unsigned :2;
    unsigned ICI0:1;
    unsigned ICI1:1;
  };
  struct {
    unsigned :13;
    unsigned ICSIDL:1;
  };
  struct {
    unsigned w:32;
  };
} __IC4CONbits_t;
extern volatile __IC4CONbits_t IC4CONbits __asm__ ("IC4CON") __attribute__((section("sfrs")));
extern volatile unsigned int        IC4CONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        IC4CONSET __attribute__((section("sfrs")));
extern volatile unsigned int        IC4CONINV __attribute__((section("sfrs")));
extern volatile unsigned int        IC4BUF __attribute__((section("sfrs")));
extern volatile unsigned int        IC5CON __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned ICM:3;
    unsigned ICBNE:1;
    unsigned ICOV:1;
    unsigned ICI:2;
    unsigned ICTMR:1;
    unsigned C32:1;
    unsigned FEDGE:1;
    unsigned :3;
    unsigned SIDL:1;
    unsigned :1;
    unsigned ON:1;
  };
  struct {
    unsigned ICM0:1;
    unsigned ICM1:1;
    unsigned ICM2:1;
    unsigned :2;
    unsigned ICI0:1;
    unsigned ICI1:1;
  };
  struct {
    unsigned :13;
    unsigned ICSIDL:1;
  };
  struct {
    unsigned w:32;
  };
} __IC5CONbits_t;
extern volatile __IC5CONbits_t IC5CONbits __asm__ ("IC5CON") __attribute__((section("sfrs")));
extern volatile unsigned int        IC5CONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        IC5CONSET __attribute__((section("sfrs")));
extern volatile unsigned int        IC5CONINV __attribute__((section("sfrs")));
extern volatile unsigned int        IC5BUF __attribute__((section("sfrs")));
extern volatile unsigned int        IC6CON __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned ICM:3;
    unsigned ICBNE:1;
    unsigned ICOV:1;
    unsigned ICI:2;
    unsigned ICTMR:1;
    unsigned C32:1;
    unsigned FEDGE:1;
    unsigned :3;
    unsigned SIDL:1;
    unsigned :1;
    unsigned ON:1;
  };
  struct {
    unsigned ICM0:1;
    unsigned ICM1:1;
    unsigned ICM2:1;
    unsigned :2;
    unsigned ICI0:1;
    unsigned ICI1:1;
  };
  struct {
    unsigned :13;
    unsigned ICSIDL:1;
  };
  struct {
    unsigned w:32;
  };
} __IC6CONbits_t;
extern volatile __IC6CONbits_t IC6CONbits __asm__ ("IC6CON") __attribute__((section("sfrs")));
extern volatile unsigned int        IC6CONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        IC6CONSET __attribute__((section("sfrs")));
extern volatile unsigned int        IC6CONINV __attribute__((section("sfrs")));
extern volatile unsigned int        IC6BUF __attribute__((section("sfrs")));
extern volatile unsigned int        IC7CON __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned ICM:3;
    unsigned ICBNE:1;
    unsigned ICOV:1;
    unsigned ICI:2;
    unsigned ICTMR:1;
    unsigned C32:1;
    unsigned FEDGE:1;
    unsigned :3;
    unsigned SIDL:1;
    unsigned :1;
    unsigned ON:1;
  };
  struct {
    unsigned ICM0:1;
    unsigned ICM1:1;
    unsigned ICM2:1;
    unsigned :2;
    unsigned ICI0:1;
    unsigned ICI1:1;
  };
  struct {
    unsigned :13;
    unsigned ICSIDL:1;
  };
  struct {
    unsigned w:32;
  };
} __IC7CONbits_t;
extern volatile __IC7CONbits_t IC7CONbits __asm__ ("IC7CON") __attribute__((section("sfrs")));
extern volatile unsigned int        IC7CONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        IC7CONSET __attribute__((section("sfrs")));
extern volatile unsigned int        IC7CONINV __attribute__((section("sfrs")));
extern volatile unsigned int        IC7BUF __attribute__((section("sfrs")));
extern volatile unsigned int        IC8CON __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned ICM:3;
    unsigned ICBNE:1;
    unsigned ICOV:1;
    unsigned ICI:2;
    unsigned ICTMR:1;
    unsigned C32:1;
    unsigned FEDGE:1;
    unsigned :3;
    unsigned SIDL:1;
    unsigned :1;
    unsigned ON:1;
  };
  struct {
    unsigned ICM0:1;
    unsigned ICM1:1;
    unsigned ICM2:1;
    unsigned :2;
    unsigned ICI0:1;
    unsigned ICI1:1;
  };
  struct {
    unsigned :13;
    unsigned ICSIDL:1;
  };
  struct {
    unsigned w:32;
  };
} __IC8CONbits_t;
extern volatile __IC8CONbits_t IC8CONbits __asm__ ("IC8CON") __attribute__((section("sfrs")));
extern volatile unsigned int        IC8CONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        IC8CONSET __attribute__((section("sfrs")));
extern volatile unsigned int        IC8CONINV __attribute__((section("sfrs")));
extern volatile unsigned int        IC8BUF __attribute__((section("sfrs")));
extern volatile unsigned int        IC9CON __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned ICM:3;
    unsigned ICBNE:1;
    unsigned ICOV:1;
    unsigned ICI:2;
    unsigned ICTMR:1;
    unsigned C32:1;
    unsigned FEDGE:1;
    unsigned :3;
    unsigned SIDL:1;
    unsigned :1;
    unsigned ON:1;
  };
  struct {
    unsigned ICM0:1;
    unsigned ICM1:1;
    unsigned ICM2:1;
    unsigned :2;
    unsigned ICI0:1;
    unsigned ICI1:1;
  };
  struct {
    unsigned :13;
    unsigned ICSIDL:1;
  };
  struct {
    unsigned w:32;
  };
} __IC9CONbits_t;
extern volatile __IC9CONbits_t IC9CONbits __asm__ ("IC9CON") __attribute__((section("sfrs")));
extern volatile unsigned int        IC9CONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        IC9CONSET __attribute__((section("sfrs")));
extern volatile unsigned int        IC9CONINV __attribute__((section("sfrs")));
extern volatile unsigned int        IC9BUF __attribute__((section("sfrs")));
extern volatile unsigned int        OC1CON __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned OCM:3;
    unsigned OCTSEL:1;
    unsigned OCFLT:1;
    unsigned OC32:1;
    unsigned :7;
    unsigned SIDL:1;
    unsigned :1;
    unsigned ON:1;
  };
  struct {
    unsigned OCM0:1;
    unsigned OCM1:1;
    unsigned OCM2:1;
  };
  struct {
    unsigned :13;
    unsigned OCSIDL:1;
  };
  struct {
    unsigned w:32;
  };
} __OC1CONbits_t;
extern volatile __OC1CONbits_t OC1CONbits __asm__ ("OC1CON") __attribute__((section("sfrs")));
extern volatile unsigned int        OC1CONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        OC1CONSET __attribute__((section("sfrs")));
extern volatile unsigned int        OC1CONINV __attribute__((section("sfrs")));
extern volatile unsigned int        OC1R __attribute__((section("sfrs")));
extern volatile unsigned int        OC1RCLR __attribute__((section("sfrs")));
extern volatile unsigned int        OC1RSET __attribute__((section("sfrs")));
extern volatile unsigned int        OC1RINV __attribute__((section("sfrs")));
extern volatile unsigned int        OC1RS __attribute__((section("sfrs")));
extern volatile unsigned int        OC1RSCLR __attribute__((section("sfrs")));
extern volatile unsigned int        OC1RSSET __attribute__((section("sfrs")));
extern volatile unsigned int        OC1RSINV __attribute__((section("sfrs")));
extern volatile unsigned int        OC2CON __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned OCM:3;
    unsigned OCTSEL:1;
    unsigned OCFLT:1;
    unsigned OC32:1;
    unsigned :7;
    unsigned SIDL:1;
    unsigned :1;
    unsigned ON:1;
  };
  struct {
    unsigned OCM0:1;
    unsigned OCM1:1;
    unsigned OCM2:1;
  };
  struct {
    unsigned :13;
    unsigned OCSIDL:1;
  };
  struct {
    unsigned w:32;
  };
} __OC2CONbits_t;
extern volatile __OC2CONbits_t OC2CONbits __asm__ ("OC2CON") __attribute__((section("sfrs")));
extern volatile unsigned int        OC2CONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        OC2CONSET __attribute__((section("sfrs")));
extern volatile unsigned int        OC2CONINV __attribute__((section("sfrs")));
extern volatile unsigned int        OC2R __attribute__((section("sfrs")));
extern volatile unsigned int        OC2RCLR __attribute__((section("sfrs")));
extern volatile unsigned int        OC2RSET __attribute__((section("sfrs")));
extern volatile unsigned int        OC2RINV __attribute__((section("sfrs")));
extern volatile unsigned int        OC2RS __attribute__((section("sfrs")));
extern volatile unsigned int        OC2RSCLR __attribute__((section("sfrs")));
extern volatile unsigned int        OC2RSSET __attribute__((section("sfrs")));
extern volatile unsigned int        OC2RSINV __attribute__((section("sfrs")));
extern volatile unsigned int        OC3CON __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned OCM:3;
    unsigned OCTSEL:1;
    unsigned OCFLT:1;
    unsigned OC32:1;
    unsigned :7;
    unsigned SIDL:1;
    unsigned :1;
    unsigned ON:1;
  };
  struct {
    unsigned OCM0:1;
    unsigned OCM1:1;
    unsigned OCM2:1;
  };
  struct {
    unsigned :13;
    unsigned OCSIDL:1;
  };
  struct {
    unsigned w:32;
  };
} __OC3CONbits_t;
extern volatile __OC3CONbits_t OC3CONbits __asm__ ("OC3CON") __attribute__((section("sfrs")));
extern volatile unsigned int        OC3CONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        OC3CONSET __attribute__((section("sfrs")));
extern volatile unsigned int        OC3CONINV __attribute__((section("sfrs")));
extern volatile unsigned int        OC3R __attribute__((section("sfrs")));
extern volatile unsigned int        OC3RCLR __attribute__((section("sfrs")));
extern volatile unsigned int        OC3RSET __attribute__((section("sfrs")));
extern volatile unsigned int        OC3RINV __attribute__((section("sfrs")));
extern volatile unsigned int        OC3RS __attribute__((section("sfrs")));
extern volatile unsigned int        OC3RSCLR __attribute__((section("sfrs")));
extern volatile unsigned int        OC3RSSET __attribute__((section("sfrs")));
extern volatile unsigned int        OC3RSINV __attribute__((section("sfrs")));
extern volatile unsigned int        OC4CON __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned OCM:3;
    unsigned OCTSEL:1;
    unsigned OCFLT:1;
    unsigned OC32:1;
    unsigned :7;
    unsigned SIDL:1;
    unsigned :1;
    unsigned ON:1;
  };
  struct {
    unsigned OCM0:1;
    unsigned OCM1:1;
    unsigned OCM2:1;
  };
  struct {
    unsigned :13;
    unsigned OCSIDL:1;
  };
  struct {
    unsigned w:32;
  };
} __OC4CONbits_t;
extern volatile __OC4CONbits_t OC4CONbits __asm__ ("OC4CON") __attribute__((section("sfrs")));
extern volatile unsigned int        OC4CONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        OC4CONSET __attribute__((section("sfrs")));
extern volatile unsigned int        OC4CONINV __attribute__((section("sfrs")));
extern volatile unsigned int        OC4R __attribute__((section("sfrs")));
extern volatile unsigned int        OC4RCLR __attribute__((section("sfrs")));
extern volatile unsigned int        OC4RSET __attribute__((section("sfrs")));
extern volatile unsigned int        OC4RINV __attribute__((section("sfrs")));
extern volatile unsigned int        OC4RS __attribute__((section("sfrs")));
extern volatile unsigned int        OC4RSCLR __attribute__((section("sfrs")));
extern volatile unsigned int        OC4RSSET __attribute__((section("sfrs")));
extern volatile unsigned int        OC4RSINV __attribute__((section("sfrs")));
extern volatile unsigned int        OC5CON __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned OCM:3;
    unsigned OCTSEL:1;
    unsigned OCFLT:1;
    unsigned OC32:1;
    unsigned :7;
    unsigned SIDL:1;
    unsigned :1;
    unsigned ON:1;
  };
  struct {
    unsigned OCM0:1;
    unsigned OCM1:1;
    unsigned OCM2:1;
  };
  struct {
    unsigned :13;
    unsigned OCSIDL:1;
  };
  struct {
    unsigned w:32;
  };
} __OC5CONbits_t;
extern volatile __OC5CONbits_t OC5CONbits __asm__ ("OC5CON") __attribute__((section("sfrs")));
extern volatile unsigned int        OC5CONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        OC5CONSET __attribute__((section("sfrs")));
extern volatile unsigned int        OC5CONINV __attribute__((section("sfrs")));
extern volatile unsigned int        OC5R __attribute__((section("sfrs")));
extern volatile unsigned int        OC5RCLR __attribute__((section("sfrs")));
extern volatile unsigned int        OC5RSET __attribute__((section("sfrs")));
extern volatile unsigned int        OC5RINV __attribute__((section("sfrs")));
extern volatile unsigned int        OC5RS __attribute__((section("sfrs")));
extern volatile unsigned int        OC5RSCLR __attribute__((section("sfrs")));
extern volatile unsigned int        OC5RSSET __attribute__((section("sfrs")));
extern volatile unsigned int        OC5RSINV __attribute__((section("sfrs")));
extern volatile unsigned int        OC6CON __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned OCM:3;
    unsigned OCTSEL:1;
    unsigned OCFLT:1;
    unsigned OC32:1;
    unsigned :7;
    unsigned SIDL:1;
    unsigned :1;
    unsigned ON:1;
  };
  struct {
    unsigned OCM0:1;
    unsigned OCM1:1;
    unsigned OCM2:1;
  };
  struct {
    unsigned :13;
    unsigned OCSIDL:1;
  };
  struct {
    unsigned w:32;
  };
} __OC6CONbits_t;
extern volatile __OC6CONbits_t OC6CONbits __asm__ ("OC6CON") __attribute__((section("sfrs")));
extern volatile unsigned int        OC6CONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        OC6CONSET __attribute__((section("sfrs")));
extern volatile unsigned int        OC6CONINV __attribute__((section("sfrs")));
extern volatile unsigned int        OC6R __attribute__((section("sfrs")));
extern volatile unsigned int        OC6RCLR __attribute__((section("sfrs")));
extern volatile unsigned int        OC6RSET __attribute__((section("sfrs")));
extern volatile unsigned int        OC6RINV __attribute__((section("sfrs")));
extern volatile unsigned int        OC6RS __attribute__((section("sfrs")));
extern volatile unsigned int        OC6RSCLR __attribute__((section("sfrs")));
extern volatile unsigned int        OC6RSSET __attribute__((section("sfrs")));
extern volatile unsigned int        OC6RSINV __attribute__((section("sfrs")));
extern volatile unsigned int        OC7CON __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned OCM:3;
    unsigned OCTSEL:1;
    unsigned OCFLT:1;
    unsigned OC32:1;
    unsigned :7;
    unsigned SIDL:1;
    unsigned :1;
    unsigned ON:1;
  };
  struct {
    unsigned OCM0:1;
    unsigned OCM1:1;
    unsigned OCM2:1;
  };
  struct {
    unsigned :13;
    unsigned OCSIDL:1;
  };
  struct {
    unsigned w:32;
  };
} __OC7CONbits_t;
extern volatile __OC7CONbits_t OC7CONbits __asm__ ("OC7CON") __attribute__((section("sfrs")));
extern volatile unsigned int        OC7CONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        OC7CONSET __attribute__((section("sfrs")));
extern volatile unsigned int        OC7CONINV __attribute__((section("sfrs")));
extern volatile unsigned int        OC7R __attribute__((section("sfrs")));
extern volatile unsigned int        OC7RCLR __attribute__((section("sfrs")));
extern volatile unsigned int        OC7RSET __attribute__((section("sfrs")));
extern volatile unsigned int        OC7RINV __attribute__((section("sfrs")));
extern volatile unsigned int        OC7RS __attribute__((section("sfrs")));
extern volatile unsigned int        OC7RSCLR __attribute__((section("sfrs")));
extern volatile unsigned int        OC7RSSET __attribute__((section("sfrs")));
extern volatile unsigned int        OC7RSINV __attribute__((section("sfrs")));
extern volatile unsigned int        OC8CON __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned OCM:3;
    unsigned OCTSEL:1;
    unsigned OCFLT:1;
    unsigned OC32:1;
    unsigned :7;
    unsigned SIDL:1;
    unsigned :1;
    unsigned ON:1;
  };
  struct {
    unsigned OCM0:1;
    unsigned OCM1:1;
    unsigned OCM2:1;
  };
  struct {
    unsigned :13;
    unsigned OCSIDL:1;
  };
  struct {
    unsigned w:32;
  };
} __OC8CONbits_t;
extern volatile __OC8CONbits_t OC8CONbits __asm__ ("OC8CON") __attribute__((section("sfrs")));
extern volatile unsigned int        OC8CONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        OC8CONSET __attribute__((section("sfrs")));
extern volatile unsigned int        OC8CONINV __attribute__((section("sfrs")));
extern volatile unsigned int        OC8R __attribute__((section("sfrs")));
extern volatile unsigned int        OC8RCLR __attribute__((section("sfrs")));
extern volatile unsigned int        OC8RSET __attribute__((section("sfrs")));
extern volatile unsigned int        OC8RINV __attribute__((section("sfrs")));
extern volatile unsigned int        OC8RS __attribute__((section("sfrs")));
extern volatile unsigned int        OC8RSCLR __attribute__((section("sfrs")));
extern volatile unsigned int        OC8RSSET __attribute__((section("sfrs")));
extern volatile unsigned int        OC8RSINV __attribute__((section("sfrs")));
extern volatile unsigned int        OC9CON __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned OCM:3;
    unsigned OCTSEL:1;
    unsigned OCFLT:1;
    unsigned OC32:1;
    unsigned :7;
    unsigned SIDL:1;
    unsigned :1;
    unsigned ON:1;
  };
  struct {
    unsigned OCM0:1;
    unsigned OCM1:1;
    unsigned OCM2:1;
  };
  struct {
    unsigned :13;
    unsigned OCSIDL:1;
  };
  struct {
    unsigned w:32;
  };
} __OC9CONbits_t;
extern volatile __OC9CONbits_t OC9CONbits __asm__ ("OC9CON") __attribute__((section("sfrs")));
extern volatile unsigned int        OC9CONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        OC9CONSET __attribute__((section("sfrs")));
extern volatile unsigned int        OC9CONINV __attribute__((section("sfrs")));
extern volatile unsigned int        OC9R __attribute__((section("sfrs")));
extern volatile unsigned int        OC9RCLR __attribute__((section("sfrs")));
extern volatile unsigned int        OC9RSET __attribute__((section("sfrs")));
extern volatile unsigned int        OC9RINV __attribute__((section("sfrs")));
extern volatile unsigned int        OC9RS __attribute__((section("sfrs")));
extern volatile unsigned int        OC9RSCLR __attribute__((section("sfrs")));
extern volatile unsigned int        OC9RSSET __attribute__((section("sfrs")));
extern volatile unsigned int        OC9RSINV __attribute__((section("sfrs")));
extern volatile unsigned int        AD1CON1 __attribute__((section("sfrs")));
typedef struct {
  unsigned :11;
  unsigned FRACT:1;
  unsigned :1;
  unsigned ADSIDL:1;
  unsigned :1;
  unsigned ADCEN:1;
  unsigned EIE:3;
  unsigned :3;
  unsigned STRGSRC:5;
  unsigned FILTRDLY:5;
} __AD1CON1bits_t;
extern volatile __AD1CON1bits_t AD1CON1bits __asm__ ("AD1CON1") __attribute__((section("sfrs")));
extern volatile unsigned int        AD1CON2 __attribute__((section("sfrs")));
typedef struct {
  unsigned ADCDIV:7;
  unsigned :1;
  unsigned ADCSEL:2;
  unsigned :3;
  unsigned LOWPWR:1;
  unsigned BOOST:1;
  unsigned :1;
  unsigned SAMC:8;
  unsigned :7;
  unsigned ADCRDY:1;
} __AD1CON2bits_t;
extern volatile __AD1CON2bits_t AD1CON2bits __asm__ ("AD1CON2") __attribute__((section("sfrs")));
extern volatile unsigned int        AD1CON3 __attribute__((section("sfrs")));
typedef struct {
  unsigned ADINSEL:6;
  unsigned :4;
  unsigned VREFSEL:3;
  unsigned :16;
  unsigned RQCONVRT:1;
  unsigned GSWTRG:1;
  unsigned CAL:1;
} __AD1CON3bits_t;
extern volatile __AD1CON3bits_t AD1CON3bits __asm__ ("AD1CON3") __attribute__((section("sfrs")));
extern volatile unsigned int        AD1IMOD __attribute__((section("sfrs")));
typedef struct {
  unsigned SH0MOD:2;
  unsigned SH1MOD:2;
  unsigned SH2MOD:2;
  unsigned SH3MOD:2;
  unsigned SH4MOD:2;
  unsigned SH5MOD:2;
  unsigned :4;
  unsigned SH0ALT:2;
  unsigned SH1ALT:2;
  unsigned SH2ALT:2;
  unsigned SH3ALT:2;
  unsigned SH4ALT:2;
} __AD1IMODbits_t;
extern volatile __AD1IMODbits_t AD1IMODbits __asm__ ("AD1IMOD") __attribute__((section("sfrs")));
extern volatile unsigned int        AD1GIRQEN1 __attribute__((section("sfrs")));
typedef struct {
  unsigned AGIEN0:1;
  unsigned AGIEN1:1;
  unsigned AGIEN2:1;
  unsigned AGIEN3:1;
  unsigned AGIEN4:1;
  unsigned AGIEN5:1;
  unsigned AGIEN6:1;
  unsigned AGIEN7:1;
  unsigned AGIEN8:1;
  unsigned AGIEN9:1;
  unsigned AGIEN10:1;
  unsigned AGIEN11:1;
  unsigned AGIEN12:1;
  unsigned AGIEN13:1;
  unsigned AGIEN14:1;
  unsigned AGIEN15:1;
  unsigned AGIEN16:1;
  unsigned AGIEN17:1;
  unsigned AGIEN18:1;
  unsigned AGIEN19:1;
  unsigned AGIEN20:1;
  unsigned AGIEN21:1;
  unsigned AGIEN22:1;
  unsigned AGIEN23:1;
  unsigned AGIEN24:1;
  unsigned AGIEN25:1;
  unsigned AGIEN26:1;
  unsigned AGIEN27:1;
  unsigned AGIEN28:1;
  unsigned AGIEN29:1;
  unsigned AGIEN30:1;
  unsigned AGIEN31:1;
} __AD1GIRQEN1bits_t;
extern volatile __AD1GIRQEN1bits_t AD1GIRQEN1bits __asm__ ("AD1GIRQEN1") __attribute__((section("sfrs")));
extern volatile unsigned int        AD1GIRQEN2 __attribute__((section("sfrs")));
typedef struct {
  unsigned AGIEN32:1;
  unsigned AGIEN33:1;
  unsigned AGIEN34:1;
  unsigned AGIEN35:1;
  unsigned AGIEN36:1;
  unsigned AGIEN37:1;
  unsigned AGIEN38:1;
  unsigned AGIEN39:1;
  unsigned AGIEN40:1;
  unsigned AGIEN41:1;
  unsigned AGIEN42:1;
  unsigned AGIEN43:1;
  unsigned AGIEN44:1;
} __AD1GIRQEN2bits_t;
extern volatile __AD1GIRQEN2bits_t AD1GIRQEN2bits __asm__ ("AD1GIRQEN2") __attribute__((section("sfrs")));
extern volatile unsigned int        AD1CSS1 __attribute__((section("sfrs")));
typedef struct {
  unsigned CSS0:1;
  unsigned CSS1:1;
  unsigned CSS2:1;
  unsigned CSS3:1;
  unsigned CSS4:1;
  unsigned CSS5:1;
  unsigned CSS6:1;
  unsigned CSS7:1;
  unsigned CSS8:1;
  unsigned CSS9:1;
  unsigned CSS10:1;
  unsigned CSS11:1;
  unsigned CSS12:1;
  unsigned CSS13:1;
  unsigned CSS14:1;
  unsigned CSS15:1;
  unsigned CSS16:1;
  unsigned CSS17:1;
  unsigned CSS18:1;
  unsigned CSS19:1;
  unsigned CSS20:1;
  unsigned CSS21:1;
  unsigned CSS22:1;
  unsigned CSS23:1;
  unsigned CSS24:1;
  unsigned CSS25:1;
  unsigned CSS26:1;
  unsigned CSS27:1;
  unsigned CSS28:1;
  unsigned CSS29:1;
  unsigned CSS30:1;
  unsigned CSS31:1;
} __AD1CSS1bits_t;
extern volatile __AD1CSS1bits_t AD1CSS1bits __asm__ ("AD1CSS1") __attribute__((section("sfrs")));
extern volatile unsigned int        AD1CSS2 __attribute__((section("sfrs")));
typedef struct {
  unsigned CSS32:1;
  unsigned CSS33:1;
  unsigned CSS34:1;
  unsigned CSS35:1;
  unsigned CSS36:1;
  unsigned CSS37:1;
  unsigned CSS38:1;
  unsigned CSS39:1;
  unsigned CSS40:1;
  unsigned CSS41:1;
  unsigned CSS42:1;
  unsigned CSS43:1;
  unsigned CSS44:1;
} __AD1CSS2bits_t;
extern volatile __AD1CSS2bits_t AD1CSS2bits __asm__ ("AD1CSS2") __attribute__((section("sfrs")));
extern volatile unsigned int        AD1DSTAT1 __attribute__((section("sfrs")));
typedef struct {
  unsigned ARDY0:1;
  unsigned ARDY1:1;
  unsigned ARDY2:1;
  unsigned ARDY3:1;
  unsigned ARDY4:1;
  unsigned ARDY5:1;
  unsigned ARDY6:1;
  unsigned ARDY7:1;
  unsigned ARDY8:1;
  unsigned ARDY9:1;
  unsigned ARDY10:1;
  unsigned ARDY11:1;
  unsigned ARDY12:1;
  unsigned ARDY13:1;
  unsigned ARDY14:1;
  unsigned ARDY15:1;
  unsigned ARDY16:1;
  unsigned ARDY17:1;
  unsigned ARDY18:1;
  unsigned ARDY19:1;
  unsigned ARDY20:1;
  unsigned ARDY21:1;
  unsigned ARDY22:1;
  unsigned ARDY23:1;
  unsigned ARDY24:1;
  unsigned ARDY25:1;
  unsigned ARDY26:1;
  unsigned ARDY27:1;
  unsigned ARDY28:1;
  unsigned ARDY29:1;
  unsigned ARDY30:1;
  unsigned ARDY31:1;
} __AD1DSTAT1bits_t;
extern volatile __AD1DSTAT1bits_t AD1DSTAT1bits __asm__ ("AD1DSTAT1") __attribute__((section("sfrs")));
extern volatile unsigned int        AD1DSTAT2 __attribute__((section("sfrs")));
typedef struct {
  unsigned ARDY32:1;
  unsigned ARDY33:1;
  unsigned ARDY34:1;
  unsigned ARDY35:1;
  unsigned ARDY36:1;
  unsigned ARDY37:1;
  unsigned ARDY38:1;
  unsigned ARDY39:1;
  unsigned ARDY40:1;
  unsigned ARDY41:1;
  unsigned ARDY42:1;
  unsigned ARDY43:1;
  unsigned ARDY44:1;
} __AD1DSTAT2bits_t;
extern volatile __AD1DSTAT2bits_t AD1DSTAT2bits __asm__ ("AD1DSTAT2") __attribute__((section("sfrs")));
extern volatile unsigned int        AD1CMPEN1 __attribute__((section("sfrs")));
typedef struct {
  unsigned CMPE0:1;
  unsigned CMPE1:1;
  unsigned CMPE2:1;
  unsigned CMPE3:1;
  unsigned CMPE4:1;
  unsigned CMPE5:1;
  unsigned CMPE6:1;
  unsigned CMPE7:1;
  unsigned CMPE8:1;
  unsigned CMPE9:1;
  unsigned CMPE10:1;
  unsigned CMPE11:1;
  unsigned CMPE12:1;
  unsigned CMPE13:1;
  unsigned CMPE14:1;
  unsigned CMPE15:1;
  unsigned CMPE16:1;
  unsigned CMPE17:1;
  unsigned CMPE18:1;
  unsigned CMPE19:1;
  unsigned CMPE20:1;
  unsigned CMPE21:1;
  unsigned CMPE22:1;
  unsigned CMPE23:1;
  unsigned CMPE24:1;
  unsigned CMPE25:1;
  unsigned CMPE26:1;
  unsigned CMPE27:1;
  unsigned CMPE28:1;
  unsigned CMPE29:1;
  unsigned CMPE30:1;
  unsigned CMPE31:1;
} __AD1CMPEN1bits_t;
extern volatile __AD1CMPEN1bits_t AD1CMPEN1bits __asm__ ("AD1CMPEN1") __attribute__((section("sfrs")));
extern volatile unsigned int        AD1CMP1 __attribute__((section("sfrs")));
typedef struct {
  unsigned ADCMPLO:16;
  unsigned ADCMPHI:16;
} __AD1CMP1bits_t;
extern volatile __AD1CMP1bits_t AD1CMP1bits __asm__ ("AD1CMP1") __attribute__((section("sfrs")));
extern volatile unsigned int        AD1CMPEN2 __attribute__((section("sfrs")));
typedef struct {
  unsigned CMPE0:1;
  unsigned CMPE1:1;
  unsigned CMPE2:1;
  unsigned CMPE3:1;
  unsigned CMPE4:1;
  unsigned CMPE5:1;
  unsigned CMPE6:1;
  unsigned CMPE7:1;
  unsigned CMPE8:1;
  unsigned CMPE9:1;
  unsigned CMPE10:1;
  unsigned CMPE11:1;
  unsigned CMPE12:1;
  unsigned CMPE13:1;
  unsigned CMPE14:1;
  unsigned CMPE15:1;
  unsigned CMPE16:1;
  unsigned CMPE17:1;
  unsigned CMPE18:1;
  unsigned CMPE19:1;
  unsigned CMPE20:1;
  unsigned CMPE21:1;
  unsigned CMPE22:1;
  unsigned CMPE23:1;
  unsigned CMPE24:1;
  unsigned CMPE25:1;
  unsigned CMPE26:1;
  unsigned CMPE27:1;
  unsigned CMPE28:1;
  unsigned CMPE29:1;
  unsigned CMPE30:1;
  unsigned CMPE31:1;
} __AD1CMPEN2bits_t;
extern volatile __AD1CMPEN2bits_t AD1CMPEN2bits __asm__ ("AD1CMPEN2") __attribute__((section("sfrs")));
extern volatile unsigned int        AD1CMP2 __attribute__((section("sfrs")));
typedef struct {
  unsigned ADCMPLO:16;
  unsigned ADCMPHI:16;
} __AD1CMP2bits_t;
extern volatile __AD1CMP2bits_t AD1CMP2bits __asm__ ("AD1CMP2") __attribute__((section("sfrs")));
extern volatile unsigned int        AD1CMPEN3 __attribute__((section("sfrs")));
typedef struct {
  unsigned CMPE0:1;
  unsigned CMPE1:1;
  unsigned CMPE2:1;
  unsigned CMPE3:1;
  unsigned CMPE4:1;
  unsigned CMPE5:1;
  unsigned CMPE6:1;
  unsigned CMPE7:1;
  unsigned CMPE8:1;
  unsigned CMPE9:1;
  unsigned CMPE10:1;
  unsigned CMPE11:1;
  unsigned CMPE12:1;
  unsigned CMPE13:1;
  unsigned CMPE14:1;
  unsigned CMPE15:1;
  unsigned CMPE16:1;
  unsigned CMPE17:1;
  unsigned CMPE18:1;
  unsigned CMPE19:1;
  unsigned CMPE20:1;
  unsigned CMPE21:1;
  unsigned CMPE22:1;
  unsigned CMPE23:1;
  unsigned CMPE24:1;
  unsigned CMPE25:1;
  unsigned CMPE26:1;
  unsigned CMPE27:1;
  unsigned CMPE28:1;
  unsigned CMPE29:1;
  unsigned CMPE30:1;
  unsigned CMPE31:1;
} __AD1CMPEN3bits_t;
extern volatile __AD1CMPEN3bits_t AD1CMPEN3bits __asm__ ("AD1CMPEN3") __attribute__((section("sfrs")));
extern volatile unsigned int        AD1CMP3 __attribute__((section("sfrs")));
typedef struct {
  unsigned ADCMPLO:16;
  unsigned ADCMPHI:16;
} __AD1CMP3bits_t;
extern volatile __AD1CMP3bits_t AD1CMP3bits __asm__ ("AD1CMP3") __attribute__((section("sfrs")));
extern volatile unsigned int        AD1CMPEN4 __attribute__((section("sfrs")));
typedef struct {
  unsigned CMPE0:1;
  unsigned CMPE1:1;
  unsigned CMPE2:1;
  unsigned CMPE3:1;
  unsigned CMPE4:1;
  unsigned CMPE5:1;
  unsigned CMPE6:1;
  unsigned CMPE7:1;
  unsigned CMPE8:1;
  unsigned CMPE9:1;
  unsigned CMPE10:1;
  unsigned CMPE11:1;
  unsigned CMPE12:1;
  unsigned CMPE13:1;
  unsigned CMPE14:1;
  unsigned CMPE15:1;
  unsigned CMPE16:1;
  unsigned CMPE17:1;
  unsigned CMPE18:1;
  unsigned CMPE19:1;
  unsigned CMPE20:1;
  unsigned CMPE21:1;
  unsigned CMPE22:1;
  unsigned CMPE23:1;
  unsigned CMPE24:1;
  unsigned CMPE25:1;
  unsigned CMPE26:1;
  unsigned CMPE27:1;
  unsigned CMPE28:1;
  unsigned CMPE29:1;
  unsigned CMPE30:1;
  unsigned CMPE31:1;
} __AD1CMPEN4bits_t;
extern volatile __AD1CMPEN4bits_t AD1CMPEN4bits __asm__ ("AD1CMPEN4") __attribute__((section("sfrs")));
extern volatile unsigned int        AD1CMP4 __attribute__((section("sfrs")));
typedef struct {
  unsigned ADCMPLO:16;
  unsigned ADCMPHI:16;
} __AD1CMP4bits_t;
extern volatile __AD1CMP4bits_t AD1CMP4bits __asm__ ("AD1CMP4") __attribute__((section("sfrs")));
extern volatile unsigned int        AD1CMPEN5 __attribute__((section("sfrs")));
typedef struct {
  unsigned CMPE0:1;
  unsigned CMPE1:1;
  unsigned CMPE2:1;
  unsigned CMPE3:1;
  unsigned CMPE4:1;
  unsigned CMPE5:1;
  unsigned CMPE6:1;
  unsigned CMPE7:1;
  unsigned CMPE8:1;
  unsigned CMPE9:1;
  unsigned CMPE10:1;
  unsigned CMPE11:1;
  unsigned CMPE12:1;
  unsigned CMPE13:1;
  unsigned CMPE14:1;
  unsigned CMPE15:1;
  unsigned CMPE16:1;
  unsigned CMPE17:1;
  unsigned CMPE18:1;
  unsigned CMPE19:1;
  unsigned CMPE20:1;
  unsigned CMPE21:1;
  unsigned CMPE22:1;
  unsigned CMPE23:1;
  unsigned CMPE24:1;
  unsigned CMPE25:1;
  unsigned CMPE26:1;
  unsigned CMPE27:1;
  unsigned CMPE28:1;
  unsigned CMPE29:1;
  unsigned CMPE30:1;
  unsigned CMPE31:1;
} __AD1CMPEN5bits_t;
extern volatile __AD1CMPEN5bits_t AD1CMPEN5bits __asm__ ("AD1CMPEN5") __attribute__((section("sfrs")));
extern volatile unsigned int        AD1CMP5 __attribute__((section("sfrs")));
typedef struct {
  unsigned ADCMPLO:16;
  unsigned ADCMPHI:16;
} __AD1CMP5bits_t;
extern volatile __AD1CMP5bits_t AD1CMP5bits __asm__ ("AD1CMP5") __attribute__((section("sfrs")));
extern volatile unsigned int        AD1CMPEN6 __attribute__((section("sfrs")));
typedef struct {
  unsigned CMPE0:1;
  unsigned CMPE1:1;
  unsigned CMPE2:1;
  unsigned CMPE3:1;
  unsigned CMPE4:1;
  unsigned CMPE5:1;
  unsigned CMPE6:1;
  unsigned CMPE7:1;
  unsigned CMPE8:1;
  unsigned CMPE9:1;
  unsigned CMPE10:1;
  unsigned CMPE11:1;
  unsigned CMPE12:1;
  unsigned CMPE13:1;
  unsigned CMPE14:1;
  unsigned CMPE15:1;
  unsigned CMPE16:1;
  unsigned CMPE17:1;
  unsigned CMPE18:1;
  unsigned CMPE19:1;
  unsigned CMPE20:1;
  unsigned CMPE21:1;
  unsigned CMPE22:1;
  unsigned CMPE23:1;
  unsigned CMPE24:1;
  unsigned CMPE25:1;
  unsigned CMPE26:1;
  unsigned CMPE27:1;
  unsigned CMPE28:1;
  unsigned CMPE29:1;
  unsigned CMPE30:1;
  unsigned CMPE31:1;
} __AD1CMPEN6bits_t;
extern volatile __AD1CMPEN6bits_t AD1CMPEN6bits __asm__ ("AD1CMPEN6") __attribute__((section("sfrs")));
extern volatile unsigned int        AD1CMP6 __attribute__((section("sfrs")));
typedef struct {
  unsigned ADCMPLO:16;
  unsigned ADCMPHI:16;
} __AD1CMP6bits_t;
extern volatile __AD1CMP6bits_t AD1CMP6bits __asm__ ("AD1CMP6") __attribute__((section("sfrs")));
extern volatile unsigned int        AD1FLTR1 __attribute__((section("sfrs")));
typedef struct {
  unsigned FLTRDATA:16;
  unsigned CHNLID:6;
  unsigned :2;
  unsigned AFRDY:1;
  unsigned AFGIEN:1;
  unsigned OVRSAM:3;
  unsigned :2;
  unsigned AFEN:1;
} __AD1FLTR1bits_t;
extern volatile __AD1FLTR1bits_t AD1FLTR1bits __asm__ ("AD1FLTR1") __attribute__((section("sfrs")));
extern volatile unsigned int        AD1FLTR2 __attribute__((section("sfrs")));
typedef struct {
  unsigned FLTRDATA:16;
  unsigned CHNLID:6;
  unsigned :2;
  unsigned AFRDY:1;
  unsigned AFGIEN:1;
  unsigned OVRSAM:3;
  unsigned :2;
  unsigned AFEN:1;
} __AD1FLTR2bits_t;
extern volatile __AD1FLTR2bits_t AD1FLTR2bits __asm__ ("AD1FLTR2") __attribute__((section("sfrs")));
extern volatile unsigned int        AD1FLTR3 __attribute__((section("sfrs")));
typedef struct {
  unsigned FLTRDATA:16;
  unsigned CHNLID:6;
  unsigned :2;
  unsigned AFRDY:1;
  unsigned AFGIEN:1;
  unsigned OVRSAM:3;
  unsigned :2;
  unsigned AFEN:1;
} __AD1FLTR3bits_t;
extern volatile __AD1FLTR3bits_t AD1FLTR3bits __asm__ ("AD1FLTR3") __attribute__((section("sfrs")));
extern volatile unsigned int        AD1FLTR4 __attribute__((section("sfrs")));
typedef struct {
  unsigned FLTRDATA:16;
  unsigned CHNLID:6;
  unsigned :2;
  unsigned AFRDY:1;
  unsigned AFGIEN:1;
  unsigned OVRSAM:3;
  unsigned :2;
  unsigned AFEN:1;
} __AD1FLTR4bits_t;
extern volatile __AD1FLTR4bits_t AD1FLTR4bits __asm__ ("AD1FLTR4") __attribute__((section("sfrs")));
extern volatile unsigned int        AD1FLTR5 __attribute__((section("sfrs")));
typedef struct {
  unsigned FLTRDATA:16;
  unsigned CHNLID:6;
  unsigned :2;
  unsigned AFRDY:1;
  unsigned AFGIEN:1;
  unsigned OVRSAM:3;
  unsigned :2;
  unsigned AFEN:1;
} __AD1FLTR5bits_t;
extern volatile __AD1FLTR5bits_t AD1FLTR5bits __asm__ ("AD1FLTR5") __attribute__((section("sfrs")));
extern volatile unsigned int        AD1FLTR6 __attribute__((section("sfrs")));
typedef struct {
  unsigned FLTRDATA:16;
  unsigned CHNLID:6;
  unsigned :2;
  unsigned AFRDY:1;
  unsigned AFGIEN:1;
  unsigned OVRSAM:3;
  unsigned :2;
  unsigned AFEN:1;
} __AD1FLTR6bits_t;
extern volatile __AD1FLTR6bits_t AD1FLTR6bits __asm__ ("AD1FLTR6") __attribute__((section("sfrs")));
extern volatile unsigned int        AD1TRG1 __attribute__((section("sfrs")));
typedef struct {
  unsigned TRGSRC0:5;
  unsigned :3;
  unsigned TRGSRC1:5;
  unsigned :3;
  unsigned TRGSRC2:5;
  unsigned :3;
  unsigned TRGSRC3:5;
} __AD1TRG1bits_t;
extern volatile __AD1TRG1bits_t AD1TRG1bits __asm__ ("AD1TRG1") __attribute__((section("sfrs")));
extern volatile unsigned int        AD1TRG2 __attribute__((section("sfrs")));
typedef struct {
  unsigned TRGSRC4:5;
  unsigned :3;
  unsigned TRGSRC5:5;
  unsigned :3;
  unsigned TRGSRC6:5;
  unsigned :3;
  unsigned TRGSRC7:5;
} __AD1TRG2bits_t;
extern volatile __AD1TRG2bits_t AD1TRG2bits __asm__ ("AD1TRG2") __attribute__((section("sfrs")));
extern volatile unsigned int        AD1TRG3 __attribute__((section("sfrs")));
typedef struct {
  unsigned TRGSRC8:5;
  unsigned :3;
  unsigned TRGSRC9:5;
  unsigned :3;
  unsigned TRGSRC10:5;
  unsigned :3;
  unsigned TRGSRC11:5;
} __AD1TRG3bits_t;
extern volatile __AD1TRG3bits_t AD1TRG3bits __asm__ ("AD1TRG3") __attribute__((section("sfrs")));
extern volatile unsigned int        AD1CMPCON1 __attribute__((section("sfrs")));
typedef struct {
  unsigned IELOLO:1;
  unsigned IELOHI:1;
  unsigned IEHILO:1;
  unsigned IEHIHI:1;
  unsigned IEBTWN:1;
  unsigned DCMPED:1;
  unsigned DCMPGIEN:1;
  unsigned ENDCMP:1;
  unsigned AINID:5;
} __AD1CMPCON1bits_t;
extern volatile __AD1CMPCON1bits_t AD1CMPCON1bits __asm__ ("AD1CMPCON1") __attribute__((section("sfrs")));
extern volatile unsigned int        AD1CMPCON2 __attribute__((section("sfrs")));
typedef struct {
  unsigned IELOLO:1;
  unsigned IELOHI:1;
  unsigned IEHILO:1;
  unsigned IEHIHI:1;
  unsigned IEBTWN:1;
  unsigned DCMPED:1;
  unsigned DCMPGIEN:1;
  unsigned ENDCMP:1;
  unsigned AINID:5;
} __AD1CMPCON2bits_t;
extern volatile __AD1CMPCON2bits_t AD1CMPCON2bits __asm__ ("AD1CMPCON2") __attribute__((section("sfrs")));
extern volatile unsigned int        AD1CMPCON3 __attribute__((section("sfrs")));
typedef struct {
  unsigned IELOLO:1;
  unsigned IELOHI:1;
  unsigned IEHILO:1;
  unsigned IEHIHI:1;
  unsigned IEBTWN:1;
  unsigned DCMPED:1;
  unsigned DCMPGIEN:1;
  unsigned ENDCMP:1;
  unsigned AINID:5;
} __AD1CMPCON3bits_t;
extern volatile __AD1CMPCON3bits_t AD1CMPCON3bits __asm__ ("AD1CMPCON3") __attribute__((section("sfrs")));
extern volatile unsigned int        AD1CMPCON4 __attribute__((section("sfrs")));
typedef struct {
  unsigned IELOLO:1;
  unsigned IELOHI:1;
  unsigned IEHILO:1;
  unsigned IEHIHI:1;
  unsigned IEBTWN:1;
  unsigned DCMPED:1;
  unsigned DCMPGIEN:1;
  unsigned ENDCMP:1;
  unsigned AINID:5;
} __AD1CMPCON4bits_t;
extern volatile __AD1CMPCON4bits_t AD1CMPCON4bits __asm__ ("AD1CMPCON4") __attribute__((section("sfrs")));
extern volatile unsigned int        AD1CMPCON5 __attribute__((section("sfrs")));
typedef struct {
  unsigned IELOLO:1;
  unsigned IELOHI:1;
  unsigned IEHILO:1;
  unsigned IEHIHI:1;
  unsigned IEBTWN:1;
  unsigned DCMPED:1;
  unsigned DCMPGIEN:1;
  unsigned ENDCMP:1;
  unsigned AINID:5;
} __AD1CMPCON5bits_t;
extern volatile __AD1CMPCON5bits_t AD1CMPCON5bits __asm__ ("AD1CMPCON5") __attribute__((section("sfrs")));
extern volatile unsigned int        AD1CMPCON6 __attribute__((section("sfrs")));
typedef struct {
  unsigned IELOLO:1;
  unsigned IELOHI:1;
  unsigned IEHILO:1;
  unsigned IEHIHI:1;
  unsigned IEBTWN:1;
  unsigned DCMPED:1;
  unsigned DCMPGIEN:1;
  unsigned ENDCMP:1;
  unsigned AINID:5;
} __AD1CMPCON6bits_t;
extern volatile __AD1CMPCON6bits_t AD1CMPCON6bits __asm__ ("AD1CMPCON6") __attribute__((section("sfrs")));
extern volatile unsigned int        AD1DATA0 __attribute__((section("sfrs")));
typedef struct {
  unsigned DATA:32;
} __AD1DATA0bits_t;
extern volatile __AD1DATA0bits_t AD1DATA0bits __asm__ ("AD1DATA0") __attribute__((section("sfrs")));
extern volatile unsigned int        AD1DATA1 __attribute__((section("sfrs")));
typedef struct {
  unsigned DATA:32;
} __AD1DATA1bits_t;
extern volatile __AD1DATA1bits_t AD1DATA1bits __asm__ ("AD1DATA1") __attribute__((section("sfrs")));
extern volatile unsigned int        AD1DATA2 __attribute__((section("sfrs")));
typedef struct {
  unsigned DATA:32;
} __AD1DATA2bits_t;
extern volatile __AD1DATA2bits_t AD1DATA2bits __asm__ ("AD1DATA2") __attribute__((section("sfrs")));
extern volatile unsigned int        AD1DATA3 __attribute__((section("sfrs")));
typedef struct {
  unsigned DATA:32;
} __AD1DATA3bits_t;
extern volatile __AD1DATA3bits_t AD1DATA3bits __asm__ ("AD1DATA3") __attribute__((section("sfrs")));
extern volatile unsigned int        AD1DATA4 __attribute__((section("sfrs")));
typedef struct {
  unsigned DATA:32;
} __AD1DATA4bits_t;
extern volatile __AD1DATA4bits_t AD1DATA4bits __asm__ ("AD1DATA4") __attribute__((section("sfrs")));
extern volatile unsigned int        AD1DATA5 __attribute__((section("sfrs")));
typedef struct {
  unsigned DATA:32;
} __AD1DATA5bits_t;
extern volatile __AD1DATA5bits_t AD1DATA5bits __asm__ ("AD1DATA5") __attribute__((section("sfrs")));
extern volatile unsigned int        AD1DATA6 __attribute__((section("sfrs")));
typedef struct {
  unsigned DATA:32;
} __AD1DATA6bits_t;
extern volatile __AD1DATA6bits_t AD1DATA6bits __asm__ ("AD1DATA6") __attribute__((section("sfrs")));
extern volatile unsigned int        AD1DATA7 __attribute__((section("sfrs")));
typedef struct {
  unsigned DATA:32;
} __AD1DATA7bits_t;
extern volatile __AD1DATA7bits_t AD1DATA7bits __asm__ ("AD1DATA7") __attribute__((section("sfrs")));
extern volatile unsigned int        AD1DATA8 __attribute__((section("sfrs")));
typedef struct {
  unsigned DATA:32;
} __AD1DATA8bits_t;
extern volatile __AD1DATA8bits_t AD1DATA8bits __asm__ ("AD1DATA8") __attribute__((section("sfrs")));
extern volatile unsigned int        AD1DATA9 __attribute__((section("sfrs")));
typedef struct {
  unsigned DATA:32;
} __AD1DATA9bits_t;
extern volatile __AD1DATA9bits_t AD1DATA9bits __asm__ ("AD1DATA9") __attribute__((section("sfrs")));
extern volatile unsigned int        AD1DATA10 __attribute__((section("sfrs")));
typedef struct {
  unsigned DATA:32;
} __AD1DATA10bits_t;
extern volatile __AD1DATA10bits_t AD1DATA10bits __asm__ ("AD1DATA10") __attribute__((section("sfrs")));
extern volatile unsigned int        AD1DATA11 __attribute__((section("sfrs")));
typedef struct {
  unsigned DATA:32;
} __AD1DATA11bits_t;
extern volatile __AD1DATA11bits_t AD1DATA11bits __asm__ ("AD1DATA11") __attribute__((section("sfrs")));
extern volatile unsigned int        AD1DATA12 __attribute__((section("sfrs")));
typedef struct {
  unsigned DATA:32;
} __AD1DATA12bits_t;
extern volatile __AD1DATA12bits_t AD1DATA12bits __asm__ ("AD1DATA12") __attribute__((section("sfrs")));
extern volatile unsigned int        AD1DATA13 __attribute__((section("sfrs")));
typedef struct {
  unsigned DATA:32;
} __AD1DATA13bits_t;
extern volatile __AD1DATA13bits_t AD1DATA13bits __asm__ ("AD1DATA13") __attribute__((section("sfrs")));
extern volatile unsigned int        AD1DATA14 __attribute__((section("sfrs")));
typedef struct {
  unsigned DATA:32;
} __AD1DATA14bits_t;
extern volatile __AD1DATA14bits_t AD1DATA14bits __asm__ ("AD1DATA14") __attribute__((section("sfrs")));
extern volatile unsigned int        AD1DATA15 __attribute__((section("sfrs")));
typedef struct {
  unsigned DATA:32;
} __AD1DATA15bits_t;
extern volatile __AD1DATA15bits_t AD1DATA15bits __asm__ ("AD1DATA15") __attribute__((section("sfrs")));
extern volatile unsigned int        AD1DATA16 __attribute__((section("sfrs")));
typedef struct {
  unsigned DATA:32;
} __AD1DATA16bits_t;
extern volatile __AD1DATA16bits_t AD1DATA16bits __asm__ ("AD1DATA16") __attribute__((section("sfrs")));
extern volatile unsigned int        AD1DATA17 __attribute__((section("sfrs")));
typedef struct {
  unsigned DATA:32;
} __AD1DATA17bits_t;
extern volatile __AD1DATA17bits_t AD1DATA17bits __asm__ ("AD1DATA17") __attribute__((section("sfrs")));
extern volatile unsigned int        AD1DATA18 __attribute__((section("sfrs")));
typedef struct {
  unsigned DATA:32;
} __AD1DATA18bits_t;
extern volatile __AD1DATA18bits_t AD1DATA18bits __asm__ ("AD1DATA18") __attribute__((section("sfrs")));
extern volatile unsigned int        AD1DATA19 __attribute__((section("sfrs")));
typedef struct {
  unsigned DATA:32;
} __AD1DATA19bits_t;
extern volatile __AD1DATA19bits_t AD1DATA19bits __asm__ ("AD1DATA19") __attribute__((section("sfrs")));
extern volatile unsigned int        AD1DATA20 __attribute__((section("sfrs")));
typedef struct {
  unsigned DATA:32;
} __AD1DATA20bits_t;
extern volatile __AD1DATA20bits_t AD1DATA20bits __asm__ ("AD1DATA20") __attribute__((section("sfrs")));
extern volatile unsigned int        AD1DATA21 __attribute__((section("sfrs")));
typedef struct {
  unsigned DATA:32;
} __AD1DATA21bits_t;
extern volatile __AD1DATA21bits_t AD1DATA21bits __asm__ ("AD1DATA21") __attribute__((section("sfrs")));
extern volatile unsigned int        AD1DATA22 __attribute__((section("sfrs")));
typedef struct {
  unsigned DATA:32;
} __AD1DATA22bits_t;
extern volatile __AD1DATA22bits_t AD1DATA22bits __asm__ ("AD1DATA22") __attribute__((section("sfrs")));
extern volatile unsigned int        AD1DATA23 __attribute__((section("sfrs")));
typedef struct {
  unsigned DATA:32;
} __AD1DATA23bits_t;
extern volatile __AD1DATA23bits_t AD1DATA23bits __asm__ ("AD1DATA23") __attribute__((section("sfrs")));
extern volatile unsigned int        AD1DATA24 __attribute__((section("sfrs")));
typedef struct {
  unsigned DATA:32;
} __AD1DATA24bits_t;
extern volatile __AD1DATA24bits_t AD1DATA24bits __asm__ ("AD1DATA24") __attribute__((section("sfrs")));
extern volatile unsigned int        AD1DATA25 __attribute__((section("sfrs")));
typedef struct {
  unsigned DATA:32;
} __AD1DATA25bits_t;
extern volatile __AD1DATA25bits_t AD1DATA25bits __asm__ ("AD1DATA25") __attribute__((section("sfrs")));
extern volatile unsigned int        AD1DATA26 __attribute__((section("sfrs")));
typedef struct {
  unsigned DATA:32;
} __AD1DATA26bits_t;
extern volatile __AD1DATA26bits_t AD1DATA26bits __asm__ ("AD1DATA26") __attribute__((section("sfrs")));
extern volatile unsigned int        AD1DATA27 __attribute__((section("sfrs")));
typedef struct {
  unsigned DATA:32;
} __AD1DATA27bits_t;
extern volatile __AD1DATA27bits_t AD1DATA27bits __asm__ ("AD1DATA27") __attribute__((section("sfrs")));
extern volatile unsigned int        AD1DATA28 __attribute__((section("sfrs")));
typedef struct {
  unsigned DATA:32;
} __AD1DATA28bits_t;
extern volatile __AD1DATA28bits_t AD1DATA28bits __asm__ ("AD1DATA28") __attribute__((section("sfrs")));
extern volatile unsigned int        AD1DATA29 __attribute__((section("sfrs")));
typedef struct {
  unsigned DATA:32;
} __AD1DATA29bits_t;
extern volatile __AD1DATA29bits_t AD1DATA29bits __asm__ ("AD1DATA29") __attribute__((section("sfrs")));
extern volatile unsigned int        AD1DATA30 __attribute__((section("sfrs")));
typedef struct {
  unsigned DATA:32;
} __AD1DATA30bits_t;
extern volatile __AD1DATA30bits_t AD1DATA30bits __asm__ ("AD1DATA30") __attribute__((section("sfrs")));
extern volatile unsigned int        AD1DATA31 __attribute__((section("sfrs")));
typedef struct {
  unsigned DATA:32;
} __AD1DATA31bits_t;
extern volatile __AD1DATA31bits_t AD1DATA31bits __asm__ ("AD1DATA31") __attribute__((section("sfrs")));
extern volatile unsigned int        AD1DATA32 __attribute__((section("sfrs")));
typedef struct {
  unsigned DATA:32;
} __AD1DATA32bits_t;
extern volatile __AD1DATA32bits_t AD1DATA32bits __asm__ ("AD1DATA32") __attribute__((section("sfrs")));
extern volatile unsigned int        AD1DATA33 __attribute__((section("sfrs")));
typedef struct {
  unsigned DATA:32;
} __AD1DATA33bits_t;
extern volatile __AD1DATA33bits_t AD1DATA33bits __asm__ ("AD1DATA33") __attribute__((section("sfrs")));
extern volatile unsigned int        AD1DATA34 __attribute__((section("sfrs")));
typedef struct {
  unsigned DATA:32;
} __AD1DATA34bits_t;
extern volatile __AD1DATA34bits_t AD1DATA34bits __asm__ ("AD1DATA34") __attribute__((section("sfrs")));
extern volatile unsigned int        AD1DATA35 __attribute__((section("sfrs")));
typedef struct {
  unsigned DATA:32;
} __AD1DATA35bits_t;
extern volatile __AD1DATA35bits_t AD1DATA35bits __asm__ ("AD1DATA35") __attribute__((section("sfrs")));
extern volatile unsigned int        AD1DATA36 __attribute__((section("sfrs")));
typedef struct {
  unsigned DATA:32;
} __AD1DATA36bits_t;
extern volatile __AD1DATA36bits_t AD1DATA36bits __asm__ ("AD1DATA36") __attribute__((section("sfrs")));
extern volatile unsigned int        AD1DATA37 __attribute__((section("sfrs")));
typedef struct {
  unsigned DATA:32;
} __AD1DATA37bits_t;
extern volatile __AD1DATA37bits_t AD1DATA37bits __asm__ ("AD1DATA37") __attribute__((section("sfrs")));
extern volatile unsigned int        AD1DATA38 __attribute__((section("sfrs")));
typedef struct {
  unsigned DATA:32;
} __AD1DATA38bits_t;
extern volatile __AD1DATA38bits_t AD1DATA38bits __asm__ ("AD1DATA38") __attribute__((section("sfrs")));
extern volatile unsigned int        AD1DATA39 __attribute__((section("sfrs")));
typedef struct {
  unsigned DATA:32;
} __AD1DATA39bits_t;
extern volatile __AD1DATA39bits_t AD1DATA39bits __asm__ ("AD1DATA39") __attribute__((section("sfrs")));
extern volatile unsigned int        AD1DATA40 __attribute__((section("sfrs")));
typedef struct {
  unsigned DATA:32;
} __AD1DATA40bits_t;
extern volatile __AD1DATA40bits_t AD1DATA40bits __asm__ ("AD1DATA40") __attribute__((section("sfrs")));
extern volatile unsigned int        AD1DATA41 __attribute__((section("sfrs")));
typedef struct {
  unsigned DATA:32;
} __AD1DATA41bits_t;
extern volatile __AD1DATA41bits_t AD1DATA41bits __asm__ ("AD1DATA41") __attribute__((section("sfrs")));
extern volatile unsigned int        AD1DATA42 __attribute__((section("sfrs")));
typedef struct {
  unsigned DATA:32;
} __AD1DATA42bits_t;
extern volatile __AD1DATA42bits_t AD1DATA42bits __asm__ ("AD1DATA42") __attribute__((section("sfrs")));
extern volatile unsigned int        AD1DATA43 __attribute__((section("sfrs")));
typedef struct {
  unsigned DATA:32;
} __AD1DATA43bits_t;
extern volatile __AD1DATA43bits_t AD1DATA43bits __asm__ ("AD1DATA43") __attribute__((section("sfrs")));
extern volatile unsigned int        AD1DATA44 __attribute__((section("sfrs")));
typedef struct {
  unsigned DATA:32;
} __AD1DATA44bits_t;
extern volatile __AD1DATA44bits_t AD1DATA44bits __asm__ ("AD1DATA44") __attribute__((section("sfrs")));
extern volatile unsigned int        AD1CAL1 __attribute__((section("sfrs")));
typedef struct {
  unsigned ADCAL:32;
} __AD1CAL1bits_t;
extern volatile __AD1CAL1bits_t AD1CAL1bits __asm__ ("AD1CAL1") __attribute__((section("sfrs")));
extern volatile unsigned int        AD1CAL2 __attribute__((section("sfrs")));
typedef struct {
  unsigned ADCAL:32;
} __AD1CAL2bits_t;
extern volatile __AD1CAL2bits_t AD1CAL2bits __asm__ ("AD1CAL2") __attribute__((section("sfrs")));
extern volatile unsigned int        AD1CAL3 __attribute__((section("sfrs")));
typedef struct {
  unsigned ADCAL:32;
} __AD1CAL3bits_t;
extern volatile __AD1CAL3bits_t AD1CAL3bits __asm__ ("AD1CAL3") __attribute__((section("sfrs")));
extern volatile unsigned int        AD1CAL4 __attribute__((section("sfrs")));
typedef struct {
  unsigned ADCAL:32;
} __AD1CAL4bits_t;
extern volatile __AD1CAL4bits_t AD1CAL4bits __asm__ ("AD1CAL4") __attribute__((section("sfrs")));
extern volatile unsigned int        AD1CAL5 __attribute__((section("sfrs")));
typedef struct {
  unsigned ADCAL:32;
} __AD1CAL5bits_t;
extern volatile __AD1CAL5bits_t AD1CAL5bits __asm__ ("AD1CAL5") __attribute__((section("sfrs")));
extern volatile unsigned int        CM1CON __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CCH:2;
    unsigned :2;
    unsigned CREF:1;
    unsigned :1;
    unsigned EVPOL:2;
    unsigned COUT:1;
    unsigned :4;
    unsigned CPOL:1;
    unsigned COE:1;
    unsigned ON:1;
  };
  struct {
    unsigned CCH0:1;
    unsigned CCH1:1;
    unsigned :4;
    unsigned EVPOL0:1;
    unsigned EVPOL1:1;
  };
  struct {
    unsigned w:32;
  };
} __CM1CONbits_t;
extern volatile __CM1CONbits_t CM1CONbits __asm__ ("CM1CON") __attribute__((section("sfrs")));
extern volatile unsigned int        CM1CONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        CM1CONSET __attribute__((section("sfrs")));
extern volatile unsigned int        CM1CONINV __attribute__((section("sfrs")));
extern volatile unsigned int        CM2CON __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CCH:2;
    unsigned :2;
    unsigned CREF:1;
    unsigned :1;
    unsigned EVPOL:2;
    unsigned COUT:1;
    unsigned :4;
    unsigned CPOL:1;
    unsigned COE:1;
    unsigned ON:1;
  };
  struct {
    unsigned CCH0:1;
    unsigned CCH1:1;
    unsigned :4;
    unsigned EVPOL0:1;
    unsigned EVPOL1:1;
  };
  struct {
    unsigned w:32;
  };
} __CM2CONbits_t;
extern volatile __CM2CONbits_t CM2CONbits __asm__ ("CM2CON") __attribute__((section("sfrs")));
extern volatile unsigned int        CM2CONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        CM2CONSET __attribute__((section("sfrs")));
extern volatile unsigned int        CM2CONINV __attribute__((section("sfrs")));
extern volatile unsigned int        CMSTAT __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned C1OUT:1;
    unsigned C2OUT:1;
    unsigned :11;
    unsigned SIDL:1;
  };
  struct {
    unsigned w:32;
  };
} __CMSTATbits_t;
extern volatile __CMSTATbits_t CMSTATbits __asm__ ("CMSTAT") __attribute__((section("sfrs")));
extern volatile unsigned int        CMSTATCLR __attribute__((section("sfrs")));
extern volatile unsigned int        CMSTATSET __attribute__((section("sfrs")));
extern volatile unsigned int        CMSTATINV __attribute__((section("sfrs")));
extern volatile unsigned int        ANSELA __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned ANSA0:1;
    unsigned ANSA1:1;
    unsigned :3;
    unsigned ANSA5:1;
    unsigned :3;
    unsigned ANSA9:1;
    unsigned ANSA10:1;
  };
  struct {
    unsigned w:32;
  };
} __ANSELAbits_t;
extern volatile __ANSELAbits_t ANSELAbits __asm__ ("ANSELA") __attribute__((section("sfrs")));
extern volatile unsigned int        ANSELACLR __attribute__((section("sfrs")));
extern volatile unsigned int        ANSELASET __attribute__((section("sfrs")));
extern volatile unsigned int        ANSELAINV __attribute__((section("sfrs")));
extern volatile unsigned int        TRISA __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TRISA0:1;
    unsigned TRISA1:1;
    unsigned TRISA2:1;
    unsigned TRISA3:1;
    unsigned TRISA4:1;
    unsigned TRISA5:1;
    unsigned TRISA6:1;
    unsigned TRISA7:1;
    unsigned :1;
    unsigned TRISA9:1;
    unsigned TRISA10:1;
    unsigned :3;
    unsigned TRISA14:1;
    unsigned TRISA15:1;
  };
  struct {
    unsigned w:32;
  };
} __TRISAbits_t;
extern volatile __TRISAbits_t TRISAbits __asm__ ("TRISA") __attribute__((section("sfrs")));
extern volatile unsigned int        TRISACLR __attribute__((section("sfrs")));
extern volatile unsigned int        TRISASET __attribute__((section("sfrs")));
extern volatile unsigned int        TRISAINV __attribute__((section("sfrs")));
extern volatile unsigned int        PORTA __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RA0:1;
    unsigned RA1:1;
    unsigned RA2:1;
    unsigned RA3:1;
    unsigned RA4:1;
    unsigned RA5:1;
    unsigned RA6:1;
    unsigned RA7:1;
    unsigned :1;
    unsigned RA9:1;
    unsigned RA10:1;
    unsigned :3;
    unsigned RA14:1;
    unsigned RA15:1;
  };
  struct {
    unsigned w:32;
  };
} __PORTAbits_t;
extern volatile __PORTAbits_t PORTAbits __asm__ ("PORTA") __attribute__((section("sfrs")));
extern volatile unsigned int        PORTACLR __attribute__((section("sfrs")));
extern volatile unsigned int        PORTASET __attribute__((section("sfrs")));
extern volatile unsigned int        PORTAINV __attribute__((section("sfrs")));
extern volatile unsigned int        LATA __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned LATA0:1;
    unsigned LATA1:1;
    unsigned LATA2:1;
    unsigned LATA3:1;
    unsigned LATA4:1;
    unsigned LATA5:1;
    unsigned LATA6:1;
    unsigned LATA7:1;
    unsigned :1;
    unsigned LATA9:1;
    unsigned LATA10:1;
    unsigned :3;
    unsigned LATA14:1;
    unsigned LATA15:1;
  };
  struct {
    unsigned w:32;
  };
} __LATAbits_t;
extern volatile __LATAbits_t LATAbits __asm__ ("LATA") __attribute__((section("sfrs")));
extern volatile unsigned int        LATACLR __attribute__((section("sfrs")));
extern volatile unsigned int        LATASET __attribute__((section("sfrs")));
extern volatile unsigned int        LATAINV __attribute__((section("sfrs")));
extern volatile unsigned int        ODCA __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned ODCA0:1;
    unsigned ODCA1:1;
    unsigned ODCA2:1;
    unsigned ODCA3:1;
    unsigned ODCA4:1;
    unsigned ODCA5:1;
    unsigned ODCA6:1;
    unsigned ODCA7:1;
    unsigned :1;
    unsigned ODCA9:1;
    unsigned ODCA10:1;
    unsigned :3;
    unsigned ODCA14:1;
    unsigned ODCA15:1;
  };
  struct {
    unsigned w:32;
  };
} __ODCAbits_t;
extern volatile __ODCAbits_t ODCAbits __asm__ ("ODCA") __attribute__((section("sfrs")));
extern volatile unsigned int        ODCACLR __attribute__((section("sfrs")));
extern volatile unsigned int        ODCASET __attribute__((section("sfrs")));
extern volatile unsigned int        ODCAINV __attribute__((section("sfrs")));
extern volatile unsigned int        CNPUA __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CNPUA0:1;
    unsigned CNPUA1:1;
    unsigned CNPUA2:1;
    unsigned CNPUA3:1;
    unsigned CNPUA4:1;
    unsigned CNPUA5:1;
    unsigned CNPUA6:1;
    unsigned CNPUA7:1;
    unsigned :1;
    unsigned CNPUA9:1;
    unsigned CNPUA10:1;
    unsigned :3;
    unsigned CNPUA14:1;
    unsigned CNPUA15:1;
  };
  struct {
    unsigned w:32;
  };
} __CNPUAbits_t;
extern volatile __CNPUAbits_t CNPUAbits __asm__ ("CNPUA") __attribute__((section("sfrs")));
extern volatile unsigned int        CNPUACLR __attribute__((section("sfrs")));
extern volatile unsigned int        CNPUASET __attribute__((section("sfrs")));
extern volatile unsigned int        CNPUAINV __attribute__((section("sfrs")));
extern volatile unsigned int        CNPDA __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CNPDA0:1;
    unsigned CNPDA1:1;
    unsigned CNPDA2:1;
    unsigned CNPDA3:1;
    unsigned CNPDA4:1;
    unsigned CNPDA5:1;
    unsigned CNPDA6:1;
    unsigned CNPDA7:1;
    unsigned :1;
    unsigned CNPDA9:1;
    unsigned CNPDA10:1;
    unsigned :3;
    unsigned CNPDA14:1;
    unsigned CNPDA15:1;
  };
  struct {
    unsigned w:32;
  };
} __CNPDAbits_t;
extern volatile __CNPDAbits_t CNPDAbits __asm__ ("CNPDA") __attribute__((section("sfrs")));
extern volatile unsigned int        CNPDACLR __attribute__((section("sfrs")));
extern volatile unsigned int        CNPDASET __attribute__((section("sfrs")));
extern volatile unsigned int        CNPDAINV __attribute__((section("sfrs")));
extern volatile unsigned int        CNCONA __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned :13;
    unsigned SIDL:1;
    unsigned :1;
    unsigned ON:1;
  };
  struct {
    unsigned w:32;
  };
} __CNCONAbits_t;
extern volatile __CNCONAbits_t CNCONAbits __asm__ ("CNCONA") __attribute__((section("sfrs")));
extern volatile unsigned int        CNCONACLR __attribute__((section("sfrs")));
extern volatile unsigned int        CNCONASET __attribute__((section("sfrs")));
extern volatile unsigned int        CNCONAINV __attribute__((section("sfrs")));
extern volatile unsigned int        CNENA __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CNIEA0:1;
    unsigned CNIEA1:1;
    unsigned CNIEA2:1;
    unsigned CNIEA3:1;
    unsigned CNIEA4:1;
    unsigned CNIEA5:1;
    unsigned CNIEA6:1;
    unsigned CNIEA7:1;
    unsigned :1;
    unsigned CNIEA9:1;
    unsigned CNIEA10:1;
    unsigned :3;
    unsigned CNIEA14:1;
    unsigned CNIEA15:1;
  };
  struct {
    unsigned w:32;
  };
} __CNENAbits_t;
extern volatile __CNENAbits_t CNENAbits __asm__ ("CNENA") __attribute__((section("sfrs")));
extern volatile unsigned int        CNENACLR __attribute__((section("sfrs")));
extern volatile unsigned int        CNENASET __attribute__((section("sfrs")));
extern volatile unsigned int        CNENAINV __attribute__((section("sfrs")));
extern volatile unsigned int        CNSTATA __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CNSTATA0:1;
    unsigned CNSTATA1:1;
    unsigned CNSTATA2:1;
    unsigned CNSTATA3:1;
    unsigned CNSTATA4:1;
    unsigned CNSTATA5:1;
    unsigned CNSTATA6:1;
    unsigned CNSTATA7:1;
    unsigned :1;
    unsigned CNSTATA9:1;
    unsigned CNSTATA10:1;
    unsigned :3;
    unsigned CNSTATA14:1;
    unsigned CNSTATA15:1;
  };
  struct {
    unsigned w:32;
  };
} __CNSTATAbits_t;
extern volatile __CNSTATAbits_t CNSTATAbits __asm__ ("CNSTATA") __attribute__((section("sfrs")));
extern volatile unsigned int        CNSTATACLR __attribute__((section("sfrs")));
extern volatile unsigned int        CNSTATASET __attribute__((section("sfrs")));
extern volatile unsigned int        CNSTATAINV __attribute__((section("sfrs")));
extern volatile unsigned int        ANSELB __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned ANSB0:1;
    unsigned ANSB1:1;
    unsigned ANSB2:1;
    unsigned ANSB3:1;
    unsigned ANSB4:1;
    unsigned ANSB5:1;
    unsigned ANSB6:1;
    unsigned ANSB7:1;
    unsigned ANSB8:1;
    unsigned ANSB9:1;
    unsigned ANSB10:1;
    unsigned ANSB11:1;
    unsigned ANSB12:1;
    unsigned ANSB13:1;
    unsigned ANSB14:1;
    unsigned ANSB15:1;
  };
  struct {
    unsigned w:32;
  };
} __ANSELBbits_t;
extern volatile __ANSELBbits_t ANSELBbits __asm__ ("ANSELB") __attribute__((section("sfrs")));
extern volatile unsigned int        ANSELBCLR __attribute__((section("sfrs")));
extern volatile unsigned int        ANSELBSET __attribute__((section("sfrs")));
extern volatile unsigned int        ANSELBINV __attribute__((section("sfrs")));
extern volatile unsigned int        TRISB __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TRISB0:1;
    unsigned TRISB1:1;
    unsigned TRISB2:1;
    unsigned TRISB3:1;
    unsigned TRISB4:1;
    unsigned TRISB5:1;
    unsigned TRISB6:1;
    unsigned TRISB7:1;
    unsigned TRISB8:1;
    unsigned TRISB9:1;
    unsigned TRISB10:1;
    unsigned TRISB11:1;
    unsigned TRISB12:1;
    unsigned TRISB13:1;
    unsigned TRISB14:1;
    unsigned TRISB15:1;
  };
  struct {
    unsigned w:32;
  };
} __TRISBbits_t;
extern volatile __TRISBbits_t TRISBbits __asm__ ("TRISB") __attribute__((section("sfrs")));
extern volatile unsigned int        TRISBCLR __attribute__((section("sfrs")));
extern volatile unsigned int        TRISBSET __attribute__((section("sfrs")));
extern volatile unsigned int        TRISBINV __attribute__((section("sfrs")));
extern volatile unsigned int        PORTB __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RB0:1;
    unsigned RB1:1;
    unsigned RB2:1;
    unsigned RB3:1;
    unsigned RB4:1;
    unsigned RB5:1;
    unsigned RB6:1;
    unsigned RB7:1;
    unsigned RB8:1;
    unsigned RB9:1;
    unsigned RB10:1;
    unsigned RB11:1;
    unsigned RB12:1;
    unsigned RB13:1;
    unsigned RB14:1;
    unsigned RB15:1;
  };
  struct {
    unsigned w:32;
  };
} __PORTBbits_t;
extern volatile __PORTBbits_t PORTBbits __asm__ ("PORTB") __attribute__((section("sfrs")));
extern volatile unsigned int        PORTBCLR __attribute__((section("sfrs")));
extern volatile unsigned int        PORTBSET __attribute__((section("sfrs")));
extern volatile unsigned int        PORTBINV __attribute__((section("sfrs")));
extern volatile unsigned int        LATB __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned LATB0:1;
    unsigned LATB1:1;
    unsigned LATB2:1;
    unsigned LATB3:1;
    unsigned LATB4:1;
    unsigned LATB5:1;
    unsigned LATB6:1;
    unsigned LATB7:1;
    unsigned LATB8:1;
    unsigned LATB9:1;
    unsigned LATB10:1;
    unsigned LATB11:1;
    unsigned LATB12:1;
    unsigned LATB13:1;
    unsigned LATB14:1;
    unsigned LATB15:1;
  };
  struct {
    unsigned w:32;
  };
} __LATBbits_t;
extern volatile __LATBbits_t LATBbits __asm__ ("LATB") __attribute__((section("sfrs")));
extern volatile unsigned int        LATBCLR __attribute__((section("sfrs")));
extern volatile unsigned int        LATBSET __attribute__((section("sfrs")));
extern volatile unsigned int        LATBINV __attribute__((section("sfrs")));
extern volatile unsigned int        ODCB __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned ODCB0:1;
    unsigned ODCB1:1;
    unsigned ODCB2:1;
    unsigned ODCB3:1;
    unsigned ODCB4:1;
    unsigned ODCB5:1;
    unsigned ODCB6:1;
    unsigned ODCB7:1;
    unsigned ODCB8:1;
    unsigned ODCB9:1;
    unsigned ODCB10:1;
    unsigned ODCB11:1;
    unsigned ODCB12:1;
    unsigned ODCB13:1;
    unsigned ODCB14:1;
    unsigned ODCB15:1;
  };
  struct {
    unsigned w:32;
  };
} __ODCBbits_t;
extern volatile __ODCBbits_t ODCBbits __asm__ ("ODCB") __attribute__((section("sfrs")));
extern volatile unsigned int        ODCBCLR __attribute__((section("sfrs")));
extern volatile unsigned int        ODCBSET __attribute__((section("sfrs")));
extern volatile unsigned int        ODCBINV __attribute__((section("sfrs")));
extern volatile unsigned int        CNPUB __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CNPUB0:1;
    unsigned CNPUB1:1;
    unsigned CNPUB2:1;
    unsigned CNPUB3:1;
    unsigned CNPUB4:1;
    unsigned CNPUB5:1;
    unsigned CNPUB6:1;
    unsigned CNPUB7:1;
    unsigned CNPUB8:1;
    unsigned CNPUB9:1;
    unsigned CNPUB10:1;
    unsigned CNPUB11:1;
    unsigned CNPUB12:1;
    unsigned CNPUB13:1;
    unsigned CNPUB14:1;
    unsigned CNPUB15:1;
  };
  struct {
    unsigned w:32;
  };
} __CNPUBbits_t;
extern volatile __CNPUBbits_t CNPUBbits __asm__ ("CNPUB") __attribute__((section("sfrs")));
extern volatile unsigned int        CNPUBCLR __attribute__((section("sfrs")));
extern volatile unsigned int        CNPUBSET __attribute__((section("sfrs")));
extern volatile unsigned int        CNPUBINV __attribute__((section("sfrs")));
extern volatile unsigned int        CNPDB __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CNPDB0:1;
    unsigned CNPDB1:1;
    unsigned CNPDB2:1;
    unsigned CNPDB3:1;
    unsigned CNPDB4:1;
    unsigned CNPDB5:1;
    unsigned CNPDB6:1;
    unsigned CNPDB7:1;
    unsigned CNPDB8:1;
    unsigned CNPDB9:1;
    unsigned CNPDB10:1;
    unsigned CNPDB11:1;
    unsigned CNPDB12:1;
    unsigned CNPDB13:1;
    unsigned CNPDB14:1;
    unsigned CNPDB15:1;
  };
  struct {
    unsigned w:32;
  };
} __CNPDBbits_t;
extern volatile __CNPDBbits_t CNPDBbits __asm__ ("CNPDB") __attribute__((section("sfrs")));
extern volatile unsigned int        CNPDBCLR __attribute__((section("sfrs")));
extern volatile unsigned int        CNPDBSET __attribute__((section("sfrs")));
extern volatile unsigned int        CNPDBINV __attribute__((section("sfrs")));
extern volatile unsigned int        CNCONB __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned :13;
    unsigned SIDL:1;
    unsigned :1;
    unsigned ON:1;
  };
  struct {
    unsigned w:32;
  };
} __CNCONBbits_t;
extern volatile __CNCONBbits_t CNCONBbits __asm__ ("CNCONB") __attribute__((section("sfrs")));
extern volatile unsigned int        CNCONBCLR __attribute__((section("sfrs")));
extern volatile unsigned int        CNCONBSET __attribute__((section("sfrs")));
extern volatile unsigned int        CNCONBINV __attribute__((section("sfrs")));
extern volatile unsigned int        CNENB __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CNIEB0:1;
    unsigned CNIEB1:1;
    unsigned CNIEB2:1;
    unsigned CNIEB3:1;
    unsigned CNIEB4:1;
    unsigned CNIEB5:1;
    unsigned CNIEB6:1;
    unsigned CNIEB7:1;
    unsigned CNIEB8:1;
    unsigned CNIEB9:1;
    unsigned CNIEB10:1;
    unsigned CNIEB11:1;
    unsigned CNIEB12:1;
    unsigned CNIEB13:1;
    unsigned CNIEB14:1;
    unsigned CNIEB15:1;
  };
  struct {
    unsigned w:32;
  };
} __CNENBbits_t;
extern volatile __CNENBbits_t CNENBbits __asm__ ("CNENB") __attribute__((section("sfrs")));
extern volatile unsigned int        CNENBCLR __attribute__((section("sfrs")));
extern volatile unsigned int        CNENBSET __attribute__((section("sfrs")));
extern volatile unsigned int        CNENBINV __attribute__((section("sfrs")));
extern volatile unsigned int        CNSTATB __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CNSTATB0:1;
    unsigned CNSTATB1:1;
    unsigned CNSTATB2:1;
    unsigned CNSTATB3:1;
    unsigned CNSTATB4:1;
    unsigned CNSTATB5:1;
    unsigned CNSTATB6:1;
    unsigned CNSTATB7:1;
    unsigned CNSTATB8:1;
    unsigned CNSTATB9:1;
    unsigned CNSTATB10:1;
    unsigned CNSTATB11:1;
    unsigned CNSTATB12:1;
    unsigned CNSTATB13:1;
    unsigned CNSTATB14:1;
    unsigned CNSTATB15:1;
  };
  struct {
    unsigned w:32;
  };
} __CNSTATBbits_t;
extern volatile __CNSTATBbits_t CNSTATBbits __asm__ ("CNSTATB") __attribute__((section("sfrs")));
extern volatile unsigned int        CNSTATBCLR __attribute__((section("sfrs")));
extern volatile unsigned int        CNSTATBSET __attribute__((section("sfrs")));
extern volatile unsigned int        CNSTATBINV __attribute__((section("sfrs")));
extern volatile unsigned int        ANSELC __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned :1;
    unsigned ANSC1:1;
    unsigned ANSC2:1;
    unsigned ANSC3:1;
    unsigned ANSC4:1;
  };
  struct {
    unsigned w:32;
  };
} __ANSELCbits_t;
extern volatile __ANSELCbits_t ANSELCbits __asm__ ("ANSELC") __attribute__((section("sfrs")));
extern volatile unsigned int        ANSELCCLR __attribute__((section("sfrs")));
extern volatile unsigned int        ANSELCSET __attribute__((section("sfrs")));
extern volatile unsigned int        ANSELCINV __attribute__((section("sfrs")));
extern volatile unsigned int        TRISC __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned :1;
    unsigned TRISC1:1;
    unsigned TRISC2:1;
    unsigned TRISC3:1;
    unsigned TRISC4:1;
    unsigned :7;
    unsigned TRISC12:1;
    unsigned TRISC13:1;
    unsigned TRISC14:1;
    unsigned TRISC15:1;
  };
  struct {
    unsigned w:32;
  };
} __TRISCbits_t;
extern volatile __TRISCbits_t TRISCbits __asm__ ("TRISC") __attribute__((section("sfrs")));
extern volatile unsigned int        TRISCCLR __attribute__((section("sfrs")));
extern volatile unsigned int        TRISCSET __attribute__((section("sfrs")));
extern volatile unsigned int        TRISCINV __attribute__((section("sfrs")));
extern volatile unsigned int        PORTC __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned :1;
    unsigned RC1:1;
    unsigned RC2:1;
    unsigned RC3:1;
    unsigned RC4:1;
    unsigned :7;
    unsigned RC12:1;
    unsigned RC13:1;
    unsigned RC14:1;
    unsigned RC15:1;
  };
  struct {
    unsigned w:32;
  };
} __PORTCbits_t;
extern volatile __PORTCbits_t PORTCbits __asm__ ("PORTC") __attribute__((section("sfrs")));
extern volatile unsigned int        PORTCCLR __attribute__((section("sfrs")));
extern volatile unsigned int        PORTCSET __attribute__((section("sfrs")));
extern volatile unsigned int        PORTCINV __attribute__((section("sfrs")));
extern volatile unsigned int        LATC __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned :1;
    unsigned LATC1:1;
    unsigned LATC2:1;
    unsigned LATC3:1;
    unsigned LATC4:1;
    unsigned :7;
    unsigned LATC12:1;
    unsigned LATC13:1;
    unsigned LATC14:1;
    unsigned LATC15:1;
  };
  struct {
    unsigned w:32;
  };
} __LATCbits_t;
extern volatile __LATCbits_t LATCbits __asm__ ("LATC") __attribute__((section("sfrs")));
extern volatile unsigned int        LATCCLR __attribute__((section("sfrs")));
extern volatile unsigned int        LATCSET __attribute__((section("sfrs")));
extern volatile unsigned int        LATCINV __attribute__((section("sfrs")));
extern volatile unsigned int        ODCC __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned :1;
    unsigned ODCC1:1;
    unsigned ODCC2:1;
    unsigned ODCC3:1;
    unsigned ODCC4:1;
    unsigned :7;
    unsigned ODCC12:1;
    unsigned ODCC13:1;
    unsigned ODCC14:1;
    unsigned ODCC15:1;
  };
  struct {
    unsigned w:32;
  };
} __ODCCbits_t;
extern volatile __ODCCbits_t ODCCbits __asm__ ("ODCC") __attribute__((section("sfrs")));
extern volatile unsigned int        ODCCCLR __attribute__((section("sfrs")));
extern volatile unsigned int        ODCCSET __attribute__((section("sfrs")));
extern volatile unsigned int        ODCCINV __attribute__((section("sfrs")));
extern volatile unsigned int        CNPUC __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned :1;
    unsigned CNPUC1:1;
    unsigned CNPUC2:1;
    unsigned CNPUC3:1;
    unsigned CNPUC4:1;
    unsigned :7;
    unsigned CNPUC12:1;
    unsigned CNPUC13:1;
    unsigned CNPUC14:1;
    unsigned CNPUC15:1;
  };
  struct {
    unsigned w:32;
  };
} __CNPUCbits_t;
extern volatile __CNPUCbits_t CNPUCbits __asm__ ("CNPUC") __attribute__((section("sfrs")));
extern volatile unsigned int        CNPUCCLR __attribute__((section("sfrs")));
extern volatile unsigned int        CNPUCSET __attribute__((section("sfrs")));
extern volatile unsigned int        CNPUCINV __attribute__((section("sfrs")));
extern volatile unsigned int        CNPDC __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned :1;
    unsigned CNPDC1:1;
    unsigned CNPDC2:1;
    unsigned CNPDC3:1;
    unsigned CNPDC4:1;
    unsigned :7;
    unsigned CNPDC12:1;
    unsigned CNPDC13:1;
    unsigned CNPDC14:1;
    unsigned CNPDC15:1;
  };
  struct {
    unsigned w:32;
  };
} __CNPDCbits_t;
extern volatile __CNPDCbits_t CNPDCbits __asm__ ("CNPDC") __attribute__((section("sfrs")));
extern volatile unsigned int        CNPDCCLR __attribute__((section("sfrs")));
extern volatile unsigned int        CNPDCSET __attribute__((section("sfrs")));
extern volatile unsigned int        CNPDCINV __attribute__((section("sfrs")));
extern volatile unsigned int        CNCONC __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned :13;
    unsigned SIDL:1;
    unsigned :1;
    unsigned ON:1;
  };
  struct {
    unsigned w:32;
  };
} __CNCONCbits_t;
extern volatile __CNCONCbits_t CNCONCbits __asm__ ("CNCONC") __attribute__((section("sfrs")));
extern volatile unsigned int        CNCONCCLR __attribute__((section("sfrs")));
extern volatile unsigned int        CNCONCSET __attribute__((section("sfrs")));
extern volatile unsigned int        CNCONCINV __attribute__((section("sfrs")));
extern volatile unsigned int        CNENC __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned :1;
    unsigned CNIEC1:1;
    unsigned CNIEC2:1;
    unsigned CNIEC3:1;
    unsigned CNIEC4:1;
    unsigned :7;
    unsigned CNIEC12:1;
    unsigned CNIEC13:1;
    unsigned CNIEC14:1;
    unsigned CNIEC15:1;
  };
  struct {
    unsigned w:32;
  };
} __CNENCbits_t;
extern volatile __CNENCbits_t CNENCbits __asm__ ("CNENC") __attribute__((section("sfrs")));
extern volatile unsigned int        CNENCCLR __attribute__((section("sfrs")));
extern volatile unsigned int        CNENCSET __attribute__((section("sfrs")));
extern volatile unsigned int        CNENCINV __attribute__((section("sfrs")));
extern volatile unsigned int        CNSTATC __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned :1;
    unsigned CNSTATC1:1;
    unsigned CNSTATC2:1;
    unsigned CNSTATC3:1;
    unsigned CNSTATC4:1;
    unsigned :7;
    unsigned CNSTATC12:1;
    unsigned CNSTATC13:1;
    unsigned CNSTATC14:1;
    unsigned CNSTATC15:1;
  };
  struct {
    unsigned w:32;
  };
} __CNSTATCbits_t;
extern volatile __CNSTATCbits_t CNSTATCbits __asm__ ("CNSTATC") __attribute__((section("sfrs")));
extern volatile unsigned int        CNSTATCCLR __attribute__((section("sfrs")));
extern volatile unsigned int        CNSTATCSET __attribute__((section("sfrs")));
extern volatile unsigned int        CNSTATCINV __attribute__((section("sfrs")));
extern volatile unsigned int        ANSELD __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned :14;
    unsigned ANSD14:1;
    unsigned ANSD15:1;
  };
  struct {
    unsigned w:32;
  };
} __ANSELDbits_t;
extern volatile __ANSELDbits_t ANSELDbits __asm__ ("ANSELD") __attribute__((section("sfrs")));
extern volatile unsigned int        ANSELDCLR __attribute__((section("sfrs")));
extern volatile unsigned int        ANSELDSET __attribute__((section("sfrs")));
extern volatile unsigned int        ANSELDINV __attribute__((section("sfrs")));
extern volatile unsigned int        TRISD __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TRISD0:1;
    unsigned TRISD1:1;
    unsigned TRISD2:1;
    unsigned TRISD3:1;
    unsigned TRISD4:1;
    unsigned TRISD5:1;
    unsigned TRISD6:1;
    unsigned TRISD7:1;
    unsigned :1;
    unsigned TRISD9:1;
    unsigned TRISD10:1;
    unsigned TRISD11:1;
    unsigned TRISD12:1;
    unsigned TRISD13:1;
    unsigned TRISD14:1;
    unsigned TRISD15:1;
  };
  struct {
    unsigned w:32;
  };
} __TRISDbits_t;
extern volatile __TRISDbits_t TRISDbits __asm__ ("TRISD") __attribute__((section("sfrs")));
extern volatile unsigned int        TRISDCLR __attribute__((section("sfrs")));
extern volatile unsigned int        TRISDSET __attribute__((section("sfrs")));
extern volatile unsigned int        TRISDINV __attribute__((section("sfrs")));
extern volatile unsigned int        PORTD __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RD0:1;
    unsigned RD1:1;
    unsigned RD2:1;
    unsigned RD3:1;
    unsigned RD4:1;
    unsigned RD5:1;
    unsigned RD6:1;
    unsigned RD7:1;
    unsigned :1;
    unsigned RD9:1;
    unsigned RD10:1;
    unsigned RD11:1;
    unsigned RD12:1;
    unsigned RD13:1;
    unsigned RD14:1;
    unsigned RD15:1;
  };
  struct {
    unsigned w:32;
  };
} __PORTDbits_t;
extern volatile __PORTDbits_t PORTDbits __asm__ ("PORTD") __attribute__((section("sfrs")));
extern volatile unsigned int        PORTDCLR __attribute__((section("sfrs")));
extern volatile unsigned int        PORTDSET __attribute__((section("sfrs")));
extern volatile unsigned int        PORTDINV __attribute__((section("sfrs")));
extern volatile unsigned int        LATD __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned LATD0:1;
    unsigned LATD1:1;
    unsigned LATD2:1;
    unsigned LATD3:1;
    unsigned LATD4:1;
    unsigned LATD5:1;
    unsigned LATD6:1;
    unsigned LATD7:1;
    unsigned :1;
    unsigned LATD9:1;
    unsigned LATD10:1;
    unsigned LATD11:1;
    unsigned LATD12:1;
    unsigned LATD13:1;
    unsigned LATD14:1;
    unsigned LATD15:1;
  };
  struct {
    unsigned w:32;
  };
} __LATDbits_t;
extern volatile __LATDbits_t LATDbits __asm__ ("LATD") __attribute__((section("sfrs")));
extern volatile unsigned int        LATDCLR __attribute__((section("sfrs")));
extern volatile unsigned int        LATDSET __attribute__((section("sfrs")));
extern volatile unsigned int        LATDINV __attribute__((section("sfrs")));
extern volatile unsigned int        ODCD __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned ODCD0:1;
    unsigned ODCD1:1;
    unsigned ODCD2:1;
    unsigned ODCD3:1;
    unsigned ODCD4:1;
    unsigned ODCD5:1;
    unsigned ODCD6:1;
    unsigned ODCD7:1;
    unsigned :1;
    unsigned ODCD9:1;
    unsigned ODCD10:1;
    unsigned ODCD11:1;
    unsigned ODCD12:1;
    unsigned ODCD13:1;
    unsigned ODCD14:1;
    unsigned ODCD15:1;
  };
  struct {
    unsigned w:32;
  };
} __ODCDbits_t;
extern volatile __ODCDbits_t ODCDbits __asm__ ("ODCD") __attribute__((section("sfrs")));
extern volatile unsigned int        ODCDCLR __attribute__((section("sfrs")));
extern volatile unsigned int        ODCDSET __attribute__((section("sfrs")));
extern volatile unsigned int        ODCDINV __attribute__((section("sfrs")));
extern volatile unsigned int        CNPUD __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CNPUD0:1;
    unsigned CNPUD1:1;
    unsigned CNPUD2:1;
    unsigned CNPUD3:1;
    unsigned CNPUD4:1;
    unsigned CNPUD5:1;
    unsigned CNPUD6:1;
    unsigned CNPUD7:1;
    unsigned :1;
    unsigned CNPUD9:1;
    unsigned CNPUD10:1;
    unsigned CNPUD11:1;
    unsigned CNPUD12:1;
    unsigned CNPUD13:1;
    unsigned CNPUD14:1;
    unsigned CNPUD15:1;
  };
  struct {
    unsigned w:32;
  };
} __CNPUDbits_t;
extern volatile __CNPUDbits_t CNPUDbits __asm__ ("CNPUD") __attribute__((section("sfrs")));
extern volatile unsigned int        CNPUDCLR __attribute__((section("sfrs")));
extern volatile unsigned int        CNPUDSET __attribute__((section("sfrs")));
extern volatile unsigned int        CNPUDINV __attribute__((section("sfrs")));
extern volatile unsigned int        CNPDD __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CNPDD0:1;
    unsigned CNPDD1:1;
    unsigned CNPDD2:1;
    unsigned CNPDD3:1;
    unsigned CNPDD4:1;
    unsigned CNPDD5:1;
    unsigned CNPDD6:1;
    unsigned CNPDD7:1;
    unsigned :1;
    unsigned CNPDD9:1;
    unsigned CNPDD10:1;
    unsigned CNPDD11:1;
    unsigned CNPDD12:1;
    unsigned CNPDD13:1;
    unsigned CNPDD14:1;
    unsigned CNPDD15:1;
  };
  struct {
    unsigned w:32;
  };
} __CNPDDbits_t;
extern volatile __CNPDDbits_t CNPDDbits __asm__ ("CNPDD") __attribute__((section("sfrs")));
extern volatile unsigned int        CNPDDCLR __attribute__((section("sfrs")));
extern volatile unsigned int        CNPDDSET __attribute__((section("sfrs")));
extern volatile unsigned int        CNPDDINV __attribute__((section("sfrs")));
extern volatile unsigned int        CNCOND __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned :13;
    unsigned SIDL:1;
    unsigned :1;
    unsigned ON:1;
  };
  struct {
    unsigned w:32;
  };
} __CNCONDbits_t;
extern volatile __CNCONDbits_t CNCONDbits __asm__ ("CNCOND") __attribute__((section("sfrs")));
extern volatile unsigned int        CNCONDCLR __attribute__((section("sfrs")));
extern volatile unsigned int        CNCONDSET __attribute__((section("sfrs")));
extern volatile unsigned int        CNCONDINV __attribute__((section("sfrs")));
extern volatile unsigned int        CNEND __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CNIED0:1;
    unsigned CNIED1:1;
    unsigned CNIED2:1;
    unsigned CNIED3:1;
    unsigned CNIED4:1;
    unsigned CNIED5:1;
    unsigned CNIED6:1;
    unsigned CNIED7:1;
    unsigned :1;
    unsigned CNIED9:1;
    unsigned CNIED10:1;
    unsigned CNIED11:1;
    unsigned CNIED12:1;
    unsigned CNIED13:1;
    unsigned CNIED14:1;
    unsigned CNIED15:1;
  };
  struct {
    unsigned w:32;
  };
} __CNENDbits_t;
extern volatile __CNENDbits_t CNENDbits __asm__ ("CNEND") __attribute__((section("sfrs")));
extern volatile unsigned int        CNENDCLR __attribute__((section("sfrs")));
extern volatile unsigned int        CNENDSET __attribute__((section("sfrs")));
extern volatile unsigned int        CNENDINV __attribute__((section("sfrs")));
extern volatile unsigned int        CNSTATD __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CNSTATD0:1;
    unsigned CNSTATD1:1;
    unsigned CNSTATD2:1;
    unsigned CNSTATD3:1;
    unsigned CNSTATD4:1;
    unsigned CNSTATD5:1;
    unsigned CNSTATD6:1;
    unsigned CNSTATD7:1;
    unsigned :1;
    unsigned CNSTATD9:1;
    unsigned CNSTATD10:1;
    unsigned CNSTATD11:1;
    unsigned CNSTATD12:1;
    unsigned CNSTATD13:1;
    unsigned CNSTATD14:1;
    unsigned CNSTATD15:1;
  };
  struct {
    unsigned w:32;
  };
} __CNSTATDbits_t;
extern volatile __CNSTATDbits_t CNSTATDbits __asm__ ("CNSTATD") __attribute__((section("sfrs")));
extern volatile unsigned int        CNSTATDCLR __attribute__((section("sfrs")));
extern volatile unsigned int        CNSTATDSET __attribute__((section("sfrs")));
extern volatile unsigned int        CNSTATDINV __attribute__((section("sfrs")));
extern volatile unsigned int        ANSELE __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned :4;
    unsigned ANSE4:1;
    unsigned ANSE5:1;
    unsigned ANSE6:1;
    unsigned ANSE7:1;
    unsigned ANSE8:1;
    unsigned ANSE9:1;
  };
  struct {
    unsigned w:32;
  };
} __ANSELEbits_t;
extern volatile __ANSELEbits_t ANSELEbits __asm__ ("ANSELE") __attribute__((section("sfrs")));
extern volatile unsigned int        ANSELECLR __attribute__((section("sfrs")));
extern volatile unsigned int        ANSELESET __attribute__((section("sfrs")));
extern volatile unsigned int        ANSELEINV __attribute__((section("sfrs")));
extern volatile unsigned int        TRISE __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TRISE0:1;
    unsigned TRISE1:1;
    unsigned TRISE2:1;
    unsigned TRISE3:1;
    unsigned TRISE4:1;
    unsigned TRISE5:1;
    unsigned TRISE6:1;
    unsigned TRISE7:1;
    unsigned TRISE8:1;
    unsigned TRISE9:1;
  };
  struct {
    unsigned w:32;
  };
} __TRISEbits_t;
extern volatile __TRISEbits_t TRISEbits __asm__ ("TRISE") __attribute__((section("sfrs")));
extern volatile unsigned int        TRISECLR __attribute__((section("sfrs")));
extern volatile unsigned int        TRISESET __attribute__((section("sfrs")));
extern volatile unsigned int        TRISEINV __attribute__((section("sfrs")));
extern volatile unsigned int        PORTE __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RE0:1;
    unsigned RE1:1;
    unsigned RE2:1;
    unsigned RE3:1;
    unsigned RE4:1;
    unsigned RE5:1;
    unsigned RE6:1;
    unsigned RE7:1;
    unsigned RE8:1;
    unsigned RE9:1;
  };
  struct {
    unsigned w:32;
  };
} __PORTEbits_t;
extern volatile __PORTEbits_t PORTEbits __asm__ ("PORTE") __attribute__((section("sfrs")));
extern volatile unsigned int        PORTECLR __attribute__((section("sfrs")));
extern volatile unsigned int        PORTESET __attribute__((section("sfrs")));
extern volatile unsigned int        PORTEINV __attribute__((section("sfrs")));
extern volatile unsigned int        LATE __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned LATE0:1;
    unsigned LATE1:1;
    unsigned LATE2:1;
    unsigned LATE3:1;
    unsigned LATE4:1;
    unsigned LATE5:1;
    unsigned LATE6:1;
    unsigned LATE7:1;
    unsigned LATE8:1;
    unsigned LATE9:1;
  };
  struct {
    unsigned w:32;
  };
} __LATEbits_t;
extern volatile __LATEbits_t LATEbits __asm__ ("LATE") __attribute__((section("sfrs")));
extern volatile unsigned int        LATECLR __attribute__((section("sfrs")));
extern volatile unsigned int        LATESET __attribute__((section("sfrs")));
extern volatile unsigned int        LATEINV __attribute__((section("sfrs")));
extern volatile unsigned int        ODCE __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned ODCE0:1;
    unsigned ODCE1:1;
    unsigned ODCE2:1;
    unsigned ODCE3:1;
    unsigned ODCE4:1;
    unsigned ODCE5:1;
    unsigned ODCE6:1;
    unsigned ODCE7:1;
    unsigned ODCE8:1;
    unsigned ODCE9:1;
  };
  struct {
    unsigned w:32;
  };
} __ODCEbits_t;
extern volatile __ODCEbits_t ODCEbits __asm__ ("ODCE") __attribute__((section("sfrs")));
extern volatile unsigned int        ODCECLR __attribute__((section("sfrs")));
extern volatile unsigned int        ODCESET __attribute__((section("sfrs")));
extern volatile unsigned int        ODCEINV __attribute__((section("sfrs")));
extern volatile unsigned int        CNPUE __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CNPUE0:1;
    unsigned CNPUE1:1;
    unsigned CNPUE2:1;
    unsigned CNPUE3:1;
    unsigned CNPUE4:1;
    unsigned CNPUE5:1;
    unsigned CNPUE6:1;
    unsigned CNPUE7:1;
    unsigned CNPUE8:1;
    unsigned CNPUE9:1;
  };
  struct {
    unsigned w:32;
  };
} __CNPUEbits_t;
extern volatile __CNPUEbits_t CNPUEbits __asm__ ("CNPUE") __attribute__((section("sfrs")));
extern volatile unsigned int        CNPUECLR __attribute__((section("sfrs")));
extern volatile unsigned int        CNPUESET __attribute__((section("sfrs")));
extern volatile unsigned int        CNPUEINV __attribute__((section("sfrs")));
extern volatile unsigned int        CNPDE __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CNPDE0:1;
    unsigned CNPDE1:1;
    unsigned CNPDE2:1;
    unsigned CNPDE3:1;
    unsigned CNPDE4:1;
    unsigned CNPDE5:1;
    unsigned CNPDE6:1;
    unsigned CNPDE7:1;
    unsigned CNPDE8:1;
    unsigned CNPDE9:1;
  };
  struct {
    unsigned w:32;
  };
} __CNPDEbits_t;
extern volatile __CNPDEbits_t CNPDEbits __asm__ ("CNPDE") __attribute__((section("sfrs")));
extern volatile unsigned int        CNPDECLR __attribute__((section("sfrs")));
extern volatile unsigned int        CNPDESET __attribute__((section("sfrs")));
extern volatile unsigned int        CNPDEINV __attribute__((section("sfrs")));
extern volatile unsigned int        CNCONE __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned :13;
    unsigned SIDL:1;
    unsigned :1;
    unsigned ON:1;
  };
  struct {
    unsigned w:32;
  };
} __CNCONEbits_t;
extern volatile __CNCONEbits_t CNCONEbits __asm__ ("CNCONE") __attribute__((section("sfrs")));
extern volatile unsigned int        CNCONECLR __attribute__((section("sfrs")));
extern volatile unsigned int        CNCONESET __attribute__((section("sfrs")));
extern volatile unsigned int        CNCONEINV __attribute__((section("sfrs")));
extern volatile unsigned int        CNENE __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CNIEE0:1;
    unsigned CNIEE1:1;
    unsigned CNIEE2:1;
    unsigned CNIEE3:1;
    unsigned CNIEE4:1;
    unsigned CNIEE5:1;
    unsigned CNIEE6:1;
    unsigned CNIEE7:1;
    unsigned CNIEE8:1;
    unsigned CNIEE9:1;
  };
  struct {
    unsigned w:32;
  };
} __CNENEbits_t;
extern volatile __CNENEbits_t CNENEbits __asm__ ("CNENE") __attribute__((section("sfrs")));
extern volatile unsigned int        CNENECLR __attribute__((section("sfrs")));
extern volatile unsigned int        CNENESET __attribute__((section("sfrs")));
extern volatile unsigned int        CNENEINV __attribute__((section("sfrs")));
extern volatile unsigned int        CNSTATE __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CNSTATE0:1;
    unsigned CNSTATE1:1;
    unsigned CNSTATE2:1;
    unsigned CNSTATE3:1;
    unsigned CNSTATE4:1;
    unsigned CNSTATE5:1;
    unsigned CNSTATE6:1;
    unsigned CNSTATE7:1;
    unsigned CNSTATE8:1;
    unsigned CNSTATE9:1;
  };
  struct {
    unsigned w:32;
  };
} __CNSTATEbits_t;
extern volatile __CNSTATEbits_t CNSTATEbits __asm__ ("CNSTATE") __attribute__((section("sfrs")));
extern volatile unsigned int        CNSTATECLR __attribute__((section("sfrs")));
extern volatile unsigned int        CNSTATESET __attribute__((section("sfrs")));
extern volatile unsigned int        CNSTATEINV __attribute__((section("sfrs")));
extern volatile unsigned int        ANSELF __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned :12;
    unsigned ANSF12:1;
    unsigned ANSF13:1;
  };
  struct {
    unsigned w:32;
  };
} __ANSELFbits_t;
extern volatile __ANSELFbits_t ANSELFbits __asm__ ("ANSELF") __attribute__((section("sfrs")));
extern volatile unsigned int        ANSELFCLR __attribute__((section("sfrs")));
extern volatile unsigned int        ANSELFSET __attribute__((section("sfrs")));
extern volatile unsigned int        ANSELFINV __attribute__((section("sfrs")));
extern volatile unsigned int        TRISF __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TRISF0:1;
    unsigned TRISF1:1;
    unsigned TRISF2:1;
    unsigned TRISF3:1;
    unsigned TRISF4:1;
    unsigned TRISF5:1;
    unsigned :2;
    unsigned TRISF8:1;
    unsigned :3;
    unsigned TRISF12:1;
    unsigned TRISF13:1;
  };
  struct {
    unsigned w:32;
  };
} __TRISFbits_t;
extern volatile __TRISFbits_t TRISFbits __asm__ ("TRISF") __attribute__((section("sfrs")));
extern volatile unsigned int        TRISFCLR __attribute__((section("sfrs")));
extern volatile unsigned int        TRISFSET __attribute__((section("sfrs")));
extern volatile unsigned int        TRISFINV __attribute__((section("sfrs")));
extern volatile unsigned int        PORTF __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RF0:1;
    unsigned RF1:1;
    unsigned RF2:1;
    unsigned RF3:1;
    unsigned RF4:1;
    unsigned RF5:1;
    unsigned :2;
    unsigned RF8:1;
    unsigned :3;
    unsigned RF12:1;
    unsigned RF13:1;
  };
  struct {
    unsigned w:32;
  };
} __PORTFbits_t;
extern volatile __PORTFbits_t PORTFbits __asm__ ("PORTF") __attribute__((section("sfrs")));
extern volatile unsigned int        PORTFCLR __attribute__((section("sfrs")));
extern volatile unsigned int        PORTFSET __attribute__((section("sfrs")));
extern volatile unsigned int        PORTFINV __attribute__((section("sfrs")));
extern volatile unsigned int        LATF __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned LATF0:1;
    unsigned LATF1:1;
    unsigned LATF2:1;
    unsigned LATF3:1;
    unsigned LATF4:1;
    unsigned LATF5:1;
    unsigned :2;
    unsigned LATF8:1;
    unsigned :3;
    unsigned LATF12:1;
    unsigned LATF13:1;
  };
  struct {
    unsigned w:32;
  };
} __LATFbits_t;
extern volatile __LATFbits_t LATFbits __asm__ ("LATF") __attribute__((section("sfrs")));
extern volatile unsigned int        LATFCLR __attribute__((section("sfrs")));
extern volatile unsigned int        LATFSET __attribute__((section("sfrs")));
extern volatile unsigned int        LATFINV __attribute__((section("sfrs")));
extern volatile unsigned int        ODCF __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned ODCF0:1;
    unsigned ODCF1:1;
    unsigned ODCF2:1;
    unsigned ODCF3:1;
    unsigned ODCF4:1;
    unsigned ODCF5:1;
    unsigned :2;
    unsigned ODCF8:1;
    unsigned :3;
    unsigned ODCF12:1;
    unsigned ODCF13:1;
  };
  struct {
    unsigned w:32;
  };
} __ODCFbits_t;
extern volatile __ODCFbits_t ODCFbits __asm__ ("ODCF") __attribute__((section("sfrs")));
extern volatile unsigned int        ODCFCLR __attribute__((section("sfrs")));
extern volatile unsigned int        ODCFSET __attribute__((section("sfrs")));
extern volatile unsigned int        ODCFINV __attribute__((section("sfrs")));
extern volatile unsigned int        CNPUF __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CNPUF0:1;
    unsigned CNPUF1:1;
    unsigned CNPUF2:1;
    unsigned CNPUF3:1;
    unsigned CNPUF4:1;
    unsigned CNPUF5:1;
    unsigned :2;
    unsigned CNPUF8:1;
    unsigned :3;
    unsigned CNPUF12:1;
    unsigned CNPUF13:1;
  };
  struct {
    unsigned w:32;
  };
} __CNPUFbits_t;
extern volatile __CNPUFbits_t CNPUFbits __asm__ ("CNPUF") __attribute__((section("sfrs")));
extern volatile unsigned int        CNPUFCLR __attribute__((section("sfrs")));
extern volatile unsigned int        CNPUFSET __attribute__((section("sfrs")));
extern volatile unsigned int        CNPUFINV __attribute__((section("sfrs")));
extern volatile unsigned int        CNPDF __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CNPDF0:1;
    unsigned CNPDF1:1;
    unsigned CNPDF2:1;
    unsigned CNPDF3:1;
    unsigned CNPDF4:1;
    unsigned CNPDF5:1;
    unsigned :2;
    unsigned CNPDF8:1;
    unsigned :3;
    unsigned CNPDF12:1;
    unsigned CNPDF13:1;
  };
  struct {
    unsigned w:32;
  };
} __CNPDFbits_t;
extern volatile __CNPDFbits_t CNPDFbits __asm__ ("CNPDF") __attribute__((section("sfrs")));
extern volatile unsigned int        CNPDFCLR __attribute__((section("sfrs")));
extern volatile unsigned int        CNPDFSET __attribute__((section("sfrs")));
extern volatile unsigned int        CNPDFINV __attribute__((section("sfrs")));
extern volatile unsigned int        CNCONF __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned :13;
    unsigned SIDL:1;
    unsigned :1;
    unsigned ON:1;
  };
  struct {
    unsigned w:32;
  };
} __CNCONFbits_t;
extern volatile __CNCONFbits_t CNCONFbits __asm__ ("CNCONF") __attribute__((section("sfrs")));
extern volatile unsigned int        CNCONFCLR __attribute__((section("sfrs")));
extern volatile unsigned int        CNCONFSET __attribute__((section("sfrs")));
extern volatile unsigned int        CNCONFINV __attribute__((section("sfrs")));
extern volatile unsigned int        CNENF __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CNIEF0:1;
    unsigned CNIEF1:1;
    unsigned CNIEF2:1;
    unsigned CNIEF3:1;
    unsigned CNIEF4:1;
    unsigned CNIEF5:1;
    unsigned :2;
    unsigned CNIEF8:1;
    unsigned :3;
    unsigned CNIEF12:1;
    unsigned CNIEF13:1;
  };
  struct {
    unsigned w:32;
  };
} __CNENFbits_t;
extern volatile __CNENFbits_t CNENFbits __asm__ ("CNENF") __attribute__((section("sfrs")));
extern volatile unsigned int        CNENFCLR __attribute__((section("sfrs")));
extern volatile unsigned int        CNENFSET __attribute__((section("sfrs")));
extern volatile unsigned int        CNENFINV __attribute__((section("sfrs")));
extern volatile unsigned int        CNSTATF __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CNSTATF0:1;
    unsigned CNSTATF1:1;
    unsigned CNSTATF2:1;
    unsigned CNSTATF3:1;
    unsigned CNSTATF4:1;
    unsigned CNSTATF5:1;
    unsigned :2;
    unsigned CNSTATF8:1;
    unsigned :3;
    unsigned CNSTATF12:1;
    unsigned CNSTATF13:1;
  };
  struct {
    unsigned w:32;
  };
} __CNSTATFbits_t;
extern volatile __CNSTATFbits_t CNSTATFbits __asm__ ("CNSTATF") __attribute__((section("sfrs")));
extern volatile unsigned int        CNSTATFCLR __attribute__((section("sfrs")));
extern volatile unsigned int        CNSTATFSET __attribute__((section("sfrs")));
extern volatile unsigned int        CNSTATFINV __attribute__((section("sfrs")));
extern volatile unsigned int        ANSELG __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned :6;
    unsigned ANSG6:1;
    unsigned ANSG7:1;
    unsigned ANSG8:1;
    unsigned ANSG9:1;
    unsigned :5;
    unsigned ANSG15:1;
  };
  struct {
    unsigned w:32;
  };
} __ANSELGbits_t;
extern volatile __ANSELGbits_t ANSELGbits __asm__ ("ANSELG") __attribute__((section("sfrs")));
extern volatile unsigned int        ANSELGCLR __attribute__((section("sfrs")));
extern volatile unsigned int        ANSELGSET __attribute__((section("sfrs")));
extern volatile unsigned int        ANSELGINV __attribute__((section("sfrs")));
extern volatile unsigned int        TRISG __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TRISG0:1;
    unsigned TRISG1:1;
    unsigned :4;
    unsigned TRISG6:1;
    unsigned TRISG7:1;
    unsigned TRISG8:1;
    unsigned TRISG9:1;
    unsigned :2;
    unsigned TRISG12:1;
    unsigned TRISG13:1;
    unsigned TRISG14:1;
    unsigned TRISG15:1;
  };
  struct {
    unsigned w:32;
  };
} __TRISGbits_t;
extern volatile __TRISGbits_t TRISGbits __asm__ ("TRISG") __attribute__((section("sfrs")));
extern volatile unsigned int        TRISGCLR __attribute__((section("sfrs")));
extern volatile unsigned int        TRISGSET __attribute__((section("sfrs")));
extern volatile unsigned int        TRISGINV __attribute__((section("sfrs")));
extern volatile unsigned int        PORTG __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RG0:1;
    unsigned RG1:1;
    unsigned :4;
    unsigned RG6:1;
    unsigned RG7:1;
    unsigned RG8:1;
    unsigned RG9:1;
    unsigned :2;
    unsigned RG12:1;
    unsigned RG13:1;
    unsigned RG14:1;
    unsigned RG15:1;
  };
  struct {
    unsigned w:32;
  };
} __PORTGbits_t;
extern volatile __PORTGbits_t PORTGbits __asm__ ("PORTG") __attribute__((section("sfrs")));
extern volatile unsigned int        PORTGCLR __attribute__((section("sfrs")));
extern volatile unsigned int        PORTGSET __attribute__((section("sfrs")));
extern volatile unsigned int        PORTGINV __attribute__((section("sfrs")));
extern volatile unsigned int        LATG __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned LATG0:1;
    unsigned LATG1:1;
    unsigned :4;
    unsigned LATG6:1;
    unsigned LATG7:1;
    unsigned LATG8:1;
    unsigned LATG9:1;
    unsigned :2;
    unsigned LATG12:1;
    unsigned LATG13:1;
    unsigned LATG14:1;
    unsigned LATG15:1;
  };
  struct {
    unsigned w:32;
  };
} __LATGbits_t;
extern volatile __LATGbits_t LATGbits __asm__ ("LATG") __attribute__((section("sfrs")));
extern volatile unsigned int        LATGCLR __attribute__((section("sfrs")));
extern volatile unsigned int        LATGSET __attribute__((section("sfrs")));
extern volatile unsigned int        LATGINV __attribute__((section("sfrs")));
extern volatile unsigned int        ODCG __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned ODCG0:1;
    unsigned ODCG1:1;
    unsigned :4;
    unsigned ODCG6:1;
    unsigned ODCG7:1;
    unsigned ODCG8:1;
    unsigned ODCG9:1;
    unsigned :2;
    unsigned ODCG12:1;
    unsigned ODCG13:1;
    unsigned ODCG14:1;
    unsigned ODCG15:1;
  };
  struct {
    unsigned w:32;
  };
} __ODCGbits_t;
extern volatile __ODCGbits_t ODCGbits __asm__ ("ODCG") __attribute__((section("sfrs")));
extern volatile unsigned int        ODCGCLR __attribute__((section("sfrs")));
extern volatile unsigned int        ODCGSET __attribute__((section("sfrs")));
extern volatile unsigned int        ODCGINV __attribute__((section("sfrs")));
extern volatile unsigned int        CNPUG __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CNPUG0:1;
    unsigned CNPUG1:1;
    unsigned :4;
    unsigned CNPUG6:1;
    unsigned CNPUG7:1;
    unsigned CNPUG8:1;
    unsigned CNPUG9:1;
    unsigned :2;
    unsigned CNPUG12:1;
    unsigned CNPUG13:1;
    unsigned CNPUG14:1;
    unsigned CNPUG15:1;
  };
  struct {
    unsigned w:32;
  };
} __CNPUGbits_t;
extern volatile __CNPUGbits_t CNPUGbits __asm__ ("CNPUG") __attribute__((section("sfrs")));
extern volatile unsigned int        CNPUGCLR __attribute__((section("sfrs")));
extern volatile unsigned int        CNPUGSET __attribute__((section("sfrs")));
extern volatile unsigned int        CNPUGINV __attribute__((section("sfrs")));
extern volatile unsigned int        CNPDG __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CNPDG0:1;
    unsigned CNPDG1:1;
    unsigned :4;
    unsigned CNPDG6:1;
    unsigned CNPDG7:1;
    unsigned CNPDG8:1;
    unsigned CNPDG9:1;
    unsigned :2;
    unsigned CNPDG12:1;
    unsigned CNPDG13:1;
    unsigned CNPDG14:1;
    unsigned CNPDG15:1;
  };
  struct {
    unsigned w:32;
  };
} __CNPDGbits_t;
extern volatile __CNPDGbits_t CNPDGbits __asm__ ("CNPDG") __attribute__((section("sfrs")));
extern volatile unsigned int        CNPDGCLR __attribute__((section("sfrs")));
extern volatile unsigned int        CNPDGSET __attribute__((section("sfrs")));
extern volatile unsigned int        CNPDGINV __attribute__((section("sfrs")));
extern volatile unsigned int        CNCONG __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned :13;
    unsigned SIDL:1;
    unsigned :1;
    unsigned ON:1;
  };
  struct {
    unsigned w:32;
  };
} __CNCONGbits_t;
extern volatile __CNCONGbits_t CNCONGbits __asm__ ("CNCONG") __attribute__((section("sfrs")));
extern volatile unsigned int        CNCONGCLR __attribute__((section("sfrs")));
extern volatile unsigned int        CNCONGSET __attribute__((section("sfrs")));
extern volatile unsigned int        CNCONGINV __attribute__((section("sfrs")));
extern volatile unsigned int        CNENG __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CNIEG0:1;
    unsigned CNIEG1:1;
    unsigned :4;
    unsigned CNIEG6:1;
    unsigned CNIEG7:1;
    unsigned CNIEG8:1;
    unsigned CNIEG9:1;
    unsigned :2;
    unsigned CNIEG12:1;
    unsigned CNIEG13:1;
    unsigned CNIEG14:1;
    unsigned CNIEG15:1;
  };
  struct {
    unsigned w:32;
  };
} __CNENGbits_t;
extern volatile __CNENGbits_t CNENGbits __asm__ ("CNENG") __attribute__((section("sfrs")));
extern volatile unsigned int        CNENGCLR __attribute__((section("sfrs")));
extern volatile unsigned int        CNENGSET __attribute__((section("sfrs")));
extern volatile unsigned int        CNENGINV __attribute__((section("sfrs")));
extern volatile unsigned int        CNSTATG __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CNSTATG0:1;
    unsigned CNSTATG1:1;
    unsigned :4;
    unsigned CNSTATG6:1;
    unsigned CNSTATG7:1;
    unsigned CNSTATG8:1;
    unsigned CNSTATG9:1;
    unsigned :2;
    unsigned CNSTATG12:1;
    unsigned CNSTATG13:1;
    unsigned CNSTATG14:1;
    unsigned CNSTATG15:1;
  };
  struct {
    unsigned w:32;
  };
} __CNSTATGbits_t;
extern volatile __CNSTATGbits_t CNSTATGbits __asm__ ("CNSTATG") __attribute__((section("sfrs")));
extern volatile unsigned int        CNSTATGCLR __attribute__((section("sfrs")));
extern volatile unsigned int        CNSTATGSET __attribute__((section("sfrs")));
extern volatile unsigned int        CNSTATGINV __attribute__((section("sfrs")));
extern volatile unsigned int        ANSELH __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned ANSH0:1;
    unsigned ANSH1:1;
    unsigned :2;
    unsigned ANSH4:1;
    unsigned ANSH5:1;
    unsigned ANSH6:1;
  };
  struct {
    unsigned w:32;
  };
} __ANSELHbits_t;
extern volatile __ANSELHbits_t ANSELHbits __asm__ ("ANSELH") __attribute__((section("sfrs")));
extern volatile unsigned int        ANSELHCLR __attribute__((section("sfrs")));
extern volatile unsigned int        ANSELHSET __attribute__((section("sfrs")));
extern volatile unsigned int        ANSELHINV __attribute__((section("sfrs")));
extern volatile unsigned int        TRISH __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TRISH0:1;
    unsigned TRISH1:1;
    unsigned TRISH2:1;
    unsigned TRISH3:1;
    unsigned TRISH4:1;
    unsigned TRISH5:1;
    unsigned TRISH6:1;
    unsigned TRISH7:1;
    unsigned TRISH8:1;
    unsigned TRISH9:1;
    unsigned TRISH10:1;
    unsigned TRISH11:1;
    unsigned TRISH12:1;
    unsigned TRISH13:1;
    unsigned TRISH14:1;
    unsigned TRISH15:1;
  };
  struct {
    unsigned w:32;
  };
} __TRISHbits_t;
extern volatile __TRISHbits_t TRISHbits __asm__ ("TRISH") __attribute__((section("sfrs")));
extern volatile unsigned int        TRISHCLR __attribute__((section("sfrs")));
extern volatile unsigned int        TRISHSET __attribute__((section("sfrs")));
extern volatile unsigned int        TRISHINV __attribute__((section("sfrs")));
extern volatile unsigned int        PORTH __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RH0:1;
    unsigned RH1:1;
    unsigned RH2:1;
    unsigned RH3:1;
    unsigned RH4:1;
    unsigned RH5:1;
    unsigned RH6:1;
    unsigned RH7:1;
    unsigned RH8:1;
    unsigned RH9:1;
    unsigned RH10:1;
    unsigned RH11:1;
    unsigned RH12:1;
    unsigned RH13:1;
    unsigned RH14:1;
    unsigned RH15:1;
  };
  struct {
    unsigned w:32;
  };
} __PORTHbits_t;
extern volatile __PORTHbits_t PORTHbits __asm__ ("PORTH") __attribute__((section("sfrs")));
extern volatile unsigned int        PORTHCLR __attribute__((section("sfrs")));
extern volatile unsigned int        PORTHSET __attribute__((section("sfrs")));
extern volatile unsigned int        PORTHINV __attribute__((section("sfrs")));
extern volatile unsigned int        LATH __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned LATH0:1;
    unsigned LATH1:1;
    unsigned LATH2:1;
    unsigned LATH3:1;
    unsigned LATH4:1;
    unsigned LATH5:1;
    unsigned LATH6:1;
    unsigned LATH7:1;
    unsigned LATH8:1;
    unsigned LATH9:1;
    unsigned LATH10:1;
    unsigned LATH11:1;
    unsigned LATH12:1;
    unsigned LATH13:1;
    unsigned LATH14:1;
    unsigned LATH15:1;
  };
  struct {
    unsigned w:32;
  };
} __LATHbits_t;
extern volatile __LATHbits_t LATHbits __asm__ ("LATH") __attribute__((section("sfrs")));
extern volatile unsigned int        LATHCLR __attribute__((section("sfrs")));
extern volatile unsigned int        LATHSET __attribute__((section("sfrs")));
extern volatile unsigned int        LATHINV __attribute__((section("sfrs")));
extern volatile unsigned int        ODCH __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned ODCH0:1;
    unsigned ODCH1:1;
    unsigned ODCH2:1;
    unsigned ODCH3:1;
    unsigned ODCH4:1;
    unsigned ODCH5:1;
    unsigned ODCH6:1;
    unsigned ODCH7:1;
    unsigned ODCH8:1;
    unsigned ODCH9:1;
    unsigned ODCH10:1;
    unsigned ODCH11:1;
    unsigned ODCH12:1;
    unsigned ODCH13:1;
    unsigned ODCH14:1;
    unsigned ODCH15:1;
  };
  struct {
    unsigned w:32;
  };
} __ODCHbits_t;
extern volatile __ODCHbits_t ODCHbits __asm__ ("ODCH") __attribute__((section("sfrs")));
extern volatile unsigned int        ODCHCLR __attribute__((section("sfrs")));
extern volatile unsigned int        ODCHSET __attribute__((section("sfrs")));
extern volatile unsigned int        ODCHINV __attribute__((section("sfrs")));
extern volatile unsigned int        CNPUH __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CNPUH0:1;
    unsigned CNPUH1:1;
    unsigned CNPUH2:1;
    unsigned CNPUH3:1;
    unsigned CNPUH4:1;
    unsigned CNPUH5:1;
    unsigned CNPUH6:1;
    unsigned CNPUH7:1;
    unsigned CNPUH8:1;
    unsigned CNPUH9:1;
    unsigned CNPUH10:1;
    unsigned CNPUH11:1;
    unsigned CNPUH12:1;
    unsigned CNPUH13:1;
    unsigned CNPUH14:1;
    unsigned CNPUH15:1;
  };
  struct {
    unsigned w:32;
  };
} __CNPUHbits_t;
extern volatile __CNPUHbits_t CNPUHbits __asm__ ("CNPUH") __attribute__((section("sfrs")));
extern volatile unsigned int        CNPUHCLR __attribute__((section("sfrs")));
extern volatile unsigned int        CNPUHSET __attribute__((section("sfrs")));
extern volatile unsigned int        CNPUHINV __attribute__((section("sfrs")));
extern volatile unsigned int        CNPDH __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CNPDH0:1;
    unsigned CNPDH1:1;
    unsigned CNPDH2:1;
    unsigned CNPDH3:1;
    unsigned CNPDH4:1;
    unsigned CNPDH5:1;
    unsigned CNPDH6:1;
    unsigned CNPDH7:1;
    unsigned CNPDH8:1;
    unsigned CNPDH9:1;
    unsigned CNPDH10:1;
    unsigned CNPDH11:1;
    unsigned CNPDH12:1;
    unsigned CNPDH13:1;
    unsigned CNPDH14:1;
    unsigned CNPDH15:1;
  };
  struct {
    unsigned w:32;
  };
} __CNPDHbits_t;
extern volatile __CNPDHbits_t CNPDHbits __asm__ ("CNPDH") __attribute__((section("sfrs")));
extern volatile unsigned int        CNPDHCLR __attribute__((section("sfrs")));
extern volatile unsigned int        CNPDHSET __attribute__((section("sfrs")));
extern volatile unsigned int        CNPDHINV __attribute__((section("sfrs")));
extern volatile unsigned int        CNCONH __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned :13;
    unsigned SIDL:1;
    unsigned :1;
    unsigned ON:1;
  };
  struct {
    unsigned w:32;
  };
} __CNCONHbits_t;
extern volatile __CNCONHbits_t CNCONHbits __asm__ ("CNCONH") __attribute__((section("sfrs")));
extern volatile unsigned int        CNCONHCLR __attribute__((section("sfrs")));
extern volatile unsigned int        CNCONHSET __attribute__((section("sfrs")));
extern volatile unsigned int        CNCONHINV __attribute__((section("sfrs")));
extern volatile unsigned int        CNENH __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CNIEH0:1;
    unsigned CNIEH1:1;
    unsigned CNIEH2:1;
    unsigned CNIEH3:1;
    unsigned CNIEH4:1;
    unsigned CNIEH5:1;
    unsigned CNIEH6:1;
    unsigned CNIEH7:1;
    unsigned CNIEH8:1;
    unsigned CNIEH9:1;
    unsigned CNIEH10:1;
    unsigned CNIEH11:1;
    unsigned CNIEH12:1;
    unsigned CNIEH13:1;
    unsigned CNIEH14:1;
    unsigned CNIEH15:1;
  };
  struct {
    unsigned w:32;
  };
} __CNENHbits_t;
extern volatile __CNENHbits_t CNENHbits __asm__ ("CNENH") __attribute__((section("sfrs")));
extern volatile unsigned int        CNENHCLR __attribute__((section("sfrs")));
extern volatile unsigned int        CNENHSET __attribute__((section("sfrs")));
extern volatile unsigned int        CNENHINV __attribute__((section("sfrs")));
extern volatile unsigned int        CNSTATH __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CNSTATH0:1;
    unsigned CNSTATH1:1;
    unsigned CNSTATH2:1;
    unsigned CNSTATH3:1;
    unsigned CNSTATH4:1;
    unsigned CNSTATH5:1;
    unsigned CNSTATH6:1;
    unsigned CNSTATH7:1;
    unsigned CNSTATH8:1;
    unsigned CNSTATH9:1;
    unsigned CNSTATH10:1;
    unsigned CNSTATH11:1;
    unsigned CNSTATH12:1;
    unsigned CNSTATH13:1;
    unsigned CNSTATH14:1;
    unsigned CNSTATH15:1;
  };
  struct {
    unsigned w:32;
  };
} __CNSTATHbits_t;
extern volatile __CNSTATHbits_t CNSTATHbits __asm__ ("CNSTATH") __attribute__((section("sfrs")));
extern volatile unsigned int        CNSTATHCLR __attribute__((section("sfrs")));
extern volatile unsigned int        CNSTATHSET __attribute__((section("sfrs")));
extern volatile unsigned int        CNSTATHINV __attribute__((section("sfrs")));
extern volatile unsigned int        ANSELJ __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned :8;
    unsigned ANSJ8:1;
    unsigned ANSJ9:1;
    unsigned :1;
    unsigned ANSJ11:1;
  };
  struct {
    unsigned w:32;
  };
} __ANSELJbits_t;
extern volatile __ANSELJbits_t ANSELJbits __asm__ ("ANSELJ") __attribute__((section("sfrs")));
extern volatile unsigned int        ANSELJCLR __attribute__((section("sfrs")));
extern volatile unsigned int        ANSELJSET __attribute__((section("sfrs")));
extern volatile unsigned int        ANSELJINV __attribute__((section("sfrs")));
extern volatile unsigned int        TRISJ __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TRISJ0:1;
    unsigned TRISJ1:1;
    unsigned TRISJ2:1;
    unsigned TRISJ3:1;
    unsigned TRISJ4:1;
    unsigned TRISJ5:1;
    unsigned TRISJ6:1;
    unsigned TRISJ7:1;
    unsigned TRISJ8:1;
    unsigned TRISJ9:1;
    unsigned TRISJ10:1;
    unsigned TRISJ11:1;
    unsigned TRISJ12:1;
    unsigned TRISJ13:1;
    unsigned TRISJ14:1;
    unsigned TRISJ15:1;
  };
  struct {
    unsigned w:32;
  };
} __TRISJbits_t;
extern volatile __TRISJbits_t TRISJbits __asm__ ("TRISJ") __attribute__((section("sfrs")));
extern volatile unsigned int        TRISJCLR __attribute__((section("sfrs")));
extern volatile unsigned int        TRISJSET __attribute__((section("sfrs")));
extern volatile unsigned int        TRISJINV __attribute__((section("sfrs")));
extern volatile unsigned int        PORTJ __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RJ0:1;
    unsigned RJ1:1;
    unsigned RJ2:1;
    unsigned RJ3:1;
    unsigned RJ4:1;
    unsigned RJ5:1;
    unsigned RJ6:1;
    unsigned RJ7:1;
    unsigned RJ8:1;
    unsigned RJ9:1;
    unsigned RJ10:1;
    unsigned RJ11:1;
    unsigned RJ12:1;
    unsigned RJ13:1;
    unsigned RJ14:1;
    unsigned RJ15:1;
  };
  struct {
    unsigned w:32;
  };
} __PORTJbits_t;
extern volatile __PORTJbits_t PORTJbits __asm__ ("PORTJ") __attribute__((section("sfrs")));
extern volatile unsigned int        PORTJCLR __attribute__((section("sfrs")));
extern volatile unsigned int        PORTJSET __attribute__((section("sfrs")));
extern volatile unsigned int        PORTJINV __attribute__((section("sfrs")));
extern volatile unsigned int        LATJ __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned LATJ0:1;
    unsigned LATJ1:1;
    unsigned LATJ2:1;
    unsigned LATJ3:1;
    unsigned LATJ4:1;
    unsigned LATJ5:1;
    unsigned LATJ6:1;
    unsigned LATJ7:1;
    unsigned LATJ8:1;
    unsigned LATJ9:1;
    unsigned LATJ10:1;
    unsigned LATJ11:1;
    unsigned LATJ12:1;
    unsigned LATJ13:1;
    unsigned LATJ14:1;
    unsigned LATJ15:1;
  };
  struct {
    unsigned w:32;
  };
} __LATJbits_t;
extern volatile __LATJbits_t LATJbits __asm__ ("LATJ") __attribute__((section("sfrs")));
extern volatile unsigned int        LATJCLR __attribute__((section("sfrs")));
extern volatile unsigned int        LATJSET __attribute__((section("sfrs")));
extern volatile unsigned int        LATJINV __attribute__((section("sfrs")));
extern volatile unsigned int        ODCJ __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned ODCJ0:1;
    unsigned ODCJ1:1;
    unsigned ODCJ2:1;
    unsigned ODCJ3:1;
    unsigned ODCJ4:1;
    unsigned ODCJ5:1;
    unsigned ODCJ6:1;
    unsigned ODCJ7:1;
    unsigned ODCJ8:1;
    unsigned ODCJ9:1;
    unsigned ODCJ10:1;
    unsigned ODCJ11:1;
    unsigned ODCJ12:1;
    unsigned ODCJ13:1;
    unsigned ODCJ14:1;
    unsigned ODCJ15:1;
  };
  struct {
    unsigned w:32;
  };
} __ODCJbits_t;
extern volatile __ODCJbits_t ODCJbits __asm__ ("ODCJ") __attribute__((section("sfrs")));
extern volatile unsigned int        ODCJCLR __attribute__((section("sfrs")));
extern volatile unsigned int        ODCJSET __attribute__((section("sfrs")));
extern volatile unsigned int        ODCJINV __attribute__((section("sfrs")));
extern volatile unsigned int        CNPUJ __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CNPUJ0:1;
    unsigned CNPUJ1:1;
    unsigned CNPUJ2:1;
    unsigned CNPUJ3:1;
    unsigned CNPUJ4:1;
    unsigned CNPUJ5:1;
    unsigned CNPUJ6:1;
    unsigned CNPUJ7:1;
    unsigned CNPUJ8:1;
    unsigned CNPUJ9:1;
    unsigned CNPUJ10:1;
    unsigned CNPUJ11:1;
    unsigned CNPUJ12:1;
    unsigned CNPUJ13:1;
    unsigned CNPUJ14:1;
    unsigned CNPUJ15:1;
  };
  struct {
    unsigned w:32;
  };
} __CNPUJbits_t;
extern volatile __CNPUJbits_t CNPUJbits __asm__ ("CNPUJ") __attribute__((section("sfrs")));
extern volatile unsigned int        CNPUJCLR __attribute__((section("sfrs")));
extern volatile unsigned int        CNPUJSET __attribute__((section("sfrs")));
extern volatile unsigned int        CNPUJINV __attribute__((section("sfrs")));
extern volatile unsigned int        CNPDJ __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CNPDJ0:1;
    unsigned CNPDJ1:1;
    unsigned CNPDJ2:1;
    unsigned CNPDJ3:1;
    unsigned CNPDJ4:1;
    unsigned CNPDJ5:1;
    unsigned CNPDJ6:1;
    unsigned CNPDJ7:1;
    unsigned CNPDJ8:1;
    unsigned CNPDJ9:1;
    unsigned CNPDJ10:1;
    unsigned CNPDJ11:1;
    unsigned CNPDJ12:1;
    unsigned CNPDJ13:1;
    unsigned CNPDJ14:1;
    unsigned CNPDJ15:1;
  };
  struct {
    unsigned w:32;
  };
} __CNPDJbits_t;
extern volatile __CNPDJbits_t CNPDJbits __asm__ ("CNPDJ") __attribute__((section("sfrs")));
extern volatile unsigned int        CNPDJCLR __attribute__((section("sfrs")));
extern volatile unsigned int        CNPDJSET __attribute__((section("sfrs")));
extern volatile unsigned int        CNPDJINV __attribute__((section("sfrs")));
extern volatile unsigned int        CNCONJ __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned :13;
    unsigned SIDL:1;
    unsigned :1;
    unsigned ON:1;
  };
  struct {
    unsigned w:32;
  };
} __CNCONJbits_t;
extern volatile __CNCONJbits_t CNCONJbits __asm__ ("CNCONJ") __attribute__((section("sfrs")));
extern volatile unsigned int        CNCONJCLR __attribute__((section("sfrs")));
extern volatile unsigned int        CNCONJSET __attribute__((section("sfrs")));
extern volatile unsigned int        CNCONJINV __attribute__((section("sfrs")));
extern volatile unsigned int        CNENJ __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CNIEJ0:1;
    unsigned CNIEJ1:1;
    unsigned CNIEJ2:1;
    unsigned CNIEJ3:1;
    unsigned CNIEJ4:1;
    unsigned CNIEJ5:1;
    unsigned CNIEJ6:1;
    unsigned CNIEJ7:1;
    unsigned CNIEJ8:1;
    unsigned CNIEJ9:1;
    unsigned CNIEJ10:1;
    unsigned CNIEJ11:1;
    unsigned CNIEJ12:1;
    unsigned CNIEJ13:1;
    unsigned CNIEJ14:1;
    unsigned CNIEJ15:1;
  };
  struct {
    unsigned w:32;
  };
} __CNENJbits_t;
extern volatile __CNENJbits_t CNENJbits __asm__ ("CNENJ") __attribute__((section("sfrs")));
extern volatile unsigned int        CNENJCLR __attribute__((section("sfrs")));
extern volatile unsigned int        CNENJSET __attribute__((section("sfrs")));
extern volatile unsigned int        CNENJINV __attribute__((section("sfrs")));
extern volatile unsigned int        CNSTATJ __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CNSTATJ0:1;
    unsigned CNSTATJ1:1;
    unsigned CNSTATJ2:1;
    unsigned CNSTATJ3:1;
    unsigned CNSTATJ4:1;
    unsigned CNSTATJ5:1;
    unsigned CNSTATJ6:1;
    unsigned CNSTATJ7:1;
    unsigned CNSTATJ8:1;
    unsigned CNSTATJ9:1;
    unsigned CNSTATJ10:1;
    unsigned CNSTATJ11:1;
    unsigned CNSTATJ12:1;
    unsigned CNSTATJ13:1;
    unsigned CNSTATJ14:1;
    unsigned CNSTATJ15:1;
  };
  struct {
    unsigned w:32;
  };
} __CNSTATJbits_t;
extern volatile __CNSTATJbits_t CNSTATJbits __asm__ ("CNSTATJ") __attribute__((section("sfrs")));
extern volatile unsigned int        CNSTATJCLR __attribute__((section("sfrs")));
extern volatile unsigned int        CNSTATJSET __attribute__((section("sfrs")));
extern volatile unsigned int        CNSTATJINV __attribute__((section("sfrs")));
extern volatile unsigned int        ANSELK __attribute__((section("sfrs")));
typedef struct {
  unsigned w:32;
} __ANSELKbits_t;
extern volatile __ANSELKbits_t ANSELKbits __asm__ ("ANSELK") __attribute__((section("sfrs")));
extern volatile unsigned int        ANSELKCLR __attribute__((section("sfrs")));
extern volatile unsigned int        ANSELKSET __attribute__((section("sfrs")));
extern volatile unsigned int        ANSELKINV __attribute__((section("sfrs")));
extern volatile unsigned int        TRISK __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TRISK0:1;
    unsigned TRISK1:1;
    unsigned TRISK2:1;
    unsigned TRISK3:1;
    unsigned TRISK4:1;
    unsigned TRISK5:1;
    unsigned TRISK6:1;
    unsigned TRISK7:1;
  };
  struct {
    unsigned w:32;
  };
} __TRISKbits_t;
extern volatile __TRISKbits_t TRISKbits __asm__ ("TRISK") __attribute__((section("sfrs")));
extern volatile unsigned int        TRISKCLR __attribute__((section("sfrs")));
extern volatile unsigned int        TRISKSET __attribute__((section("sfrs")));
extern volatile unsigned int        TRISKINV __attribute__((section("sfrs")));
extern volatile unsigned int        PORTK __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RK0:1;
    unsigned RK1:1;
    unsigned RK2:1;
    unsigned RK3:1;
    unsigned RK4:1;
    unsigned RK5:1;
    unsigned RK6:1;
    unsigned RK7:1;
  };
  struct {
    unsigned w:32;
  };
} __PORTKbits_t;
extern volatile __PORTKbits_t PORTKbits __asm__ ("PORTK") __attribute__((section("sfrs")));
extern volatile unsigned int        PORTKCLR __attribute__((section("sfrs")));
extern volatile unsigned int        PORTKSET __attribute__((section("sfrs")));
extern volatile unsigned int        PORTKINV __attribute__((section("sfrs")));
extern volatile unsigned int        LATK __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned LATK0:1;
    unsigned LATK1:1;
    unsigned LATK2:1;
    unsigned LATK3:1;
    unsigned LATK4:1;
    unsigned LATK5:1;
    unsigned LATK6:1;
    unsigned LATK7:1;
  };
  struct {
    unsigned w:32;
  };
} __LATKbits_t;
extern volatile __LATKbits_t LATKbits __asm__ ("LATK") __attribute__((section("sfrs")));
extern volatile unsigned int        LATKCLR __attribute__((section("sfrs")));
extern volatile unsigned int        LATKSET __attribute__((section("sfrs")));
extern volatile unsigned int        LATKINV __attribute__((section("sfrs")));
extern volatile unsigned int        ODCK __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned ODCK0:1;
    unsigned ODCK1:1;
    unsigned ODCK2:1;
    unsigned ODCK3:1;
    unsigned ODCK4:1;
    unsigned ODCK5:1;
    unsigned ODCK6:1;
    unsigned ODCK7:1;
  };
  struct {
    unsigned w:32;
  };
} __ODCKbits_t;
extern volatile __ODCKbits_t ODCKbits __asm__ ("ODCK") __attribute__((section("sfrs")));
extern volatile unsigned int        ODCKCLR __attribute__((section("sfrs")));
extern volatile unsigned int        ODCKSET __attribute__((section("sfrs")));
extern volatile unsigned int        ODCKINV __attribute__((section("sfrs")));
extern volatile unsigned int        CNPUK __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CNPUK0:1;
    unsigned CNPUK1:1;
    unsigned CNPUK2:1;
    unsigned CNPUK3:1;
    unsigned CNPUK4:1;
    unsigned CNPUK5:1;
    unsigned CNPUK6:1;
    unsigned CNPUK7:1;
  };
  struct {
    unsigned w:32;
  };
} __CNPUKbits_t;
extern volatile __CNPUKbits_t CNPUKbits __asm__ ("CNPUK") __attribute__((section("sfrs")));
extern volatile unsigned int        CNPUKCLR __attribute__((section("sfrs")));
extern volatile unsigned int        CNPUKSET __attribute__((section("sfrs")));
extern volatile unsigned int        CNPUKINV __attribute__((section("sfrs")));
extern volatile unsigned int        CNPDK __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CNPDK0:1;
    unsigned CNPDK1:1;
    unsigned CNPDK2:1;
    unsigned CNPDK3:1;
    unsigned CNPDK4:1;
    unsigned CNPDK5:1;
    unsigned CNPDK6:1;
    unsigned CNPDK7:1;
  };
  struct {
    unsigned w:32;
  };
} __CNPDKbits_t;
extern volatile __CNPDKbits_t CNPDKbits __asm__ ("CNPDK") __attribute__((section("sfrs")));
extern volatile unsigned int        CNPDKCLR __attribute__((section("sfrs")));
extern volatile unsigned int        CNPDKSET __attribute__((section("sfrs")));
extern volatile unsigned int        CNPDKINV __attribute__((section("sfrs")));
extern volatile unsigned int        CNCONK __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned :13;
    unsigned SIDL:1;
    unsigned :1;
    unsigned ON:1;
  };
  struct {
    unsigned w:32;
  };
} __CNCONKbits_t;
extern volatile __CNCONKbits_t CNCONKbits __asm__ ("CNCONK") __attribute__((section("sfrs")));
extern volatile unsigned int        CNCONKCLR __attribute__((section("sfrs")));
extern volatile unsigned int        CNCONKSET __attribute__((section("sfrs")));
extern volatile unsigned int        CNCONKINV __attribute__((section("sfrs")));
extern volatile unsigned int        CNENK __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CNIEK0:1;
    unsigned CNIEK1:1;
    unsigned CNIEK2:1;
    unsigned CNIEK3:1;
    unsigned CNIEK4:1;
    unsigned CNIEK5:1;
    unsigned CNIEK6:1;
    unsigned CNIEK7:1;
  };
  struct {
    unsigned w:32;
  };
} __CNENKbits_t;
extern volatile __CNENKbits_t CNENKbits __asm__ ("CNENK") __attribute__((section("sfrs")));
extern volatile unsigned int        CNENKCLR __attribute__((section("sfrs")));
extern volatile unsigned int        CNENKSET __attribute__((section("sfrs")));
extern volatile unsigned int        CNENKINV __attribute__((section("sfrs")));
extern volatile unsigned int        CNSTATK __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CNSTATK0:1;
    unsigned CNSTATK1:1;
    unsigned CNSTATK2:1;
    unsigned CNSTATK3:1;
    unsigned CNSTATK4:1;
    unsigned CNSTATK5:1;
    unsigned CNSTATK6:1;
    unsigned CNSTATK7:1;
  };
  struct {
    unsigned w:32;
  };
} __CNSTATKbits_t;
extern volatile __CNSTATKbits_t CNSTATKbits __asm__ ("CNSTATK") __attribute__((section("sfrs")));
extern volatile unsigned int        CNSTATKCLR __attribute__((section("sfrs")));
extern volatile unsigned int        CNSTATKSET __attribute__((section("sfrs")));
extern volatile unsigned int        CNSTATKINV __attribute__((section("sfrs")));
extern volatile unsigned int        C1CON __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned DNCNT:5;
    unsigned :6;
    unsigned CANBUSY:1;
    unsigned :1;
    unsigned SIDL:1;
    unsigned :1;
    unsigned ON:1;
    unsigned :4;
    unsigned CANCAP:1;
    unsigned OPMOD:3;
    unsigned REQOP:3;
    unsigned ABAT:1;
  };
  struct {
    unsigned w:32;
  };
} __C1CONbits_t;
extern volatile __C1CONbits_t C1CONbits __asm__ ("C1CON") __attribute__((section("sfrs")));
extern volatile unsigned int        C1CONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1CONSET __attribute__((section("sfrs")));
extern volatile unsigned int        C1CONINV __attribute__((section("sfrs")));
extern volatile unsigned int        C1CFG __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned BRP:6;
    unsigned SJW:2;
    unsigned PRSEG:3;
    unsigned SEG1PH:3;
    unsigned SAM:1;
    unsigned SEG2PHTS:1;
    unsigned SEG2PH:3;
    unsigned :3;
    unsigned WAKFIL:1;
  };
  struct {
    unsigned w:32;
  };
} __C1CFGbits_t;
extern volatile __C1CFGbits_t C1CFGbits __asm__ ("C1CFG") __attribute__((section("sfrs")));
extern volatile unsigned int        C1CFGCLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1CFGSET __attribute__((section("sfrs")));
extern volatile unsigned int        C1CFGINV __attribute__((section("sfrs")));
extern volatile unsigned int        C1INT __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TBIF:1;
    unsigned RBIF:1;
    unsigned CTMRIF:1;
    unsigned MODIF:1;
    unsigned :7;
    unsigned RBOVIF:1;
    unsigned SERRIF:1;
    unsigned CERRIF:1;
    unsigned WAKIF:1;
    unsigned IVRIF:1;
    unsigned TBIE:1;
    unsigned RBIE:1;
    unsigned CTMRIE:1;
    unsigned MODIE:1;
    unsigned :7;
    unsigned RBOVIE:1;
    unsigned SERRIE:1;
    unsigned CERRIE:1;
    unsigned WAKIE:1;
    unsigned IVRIE:1;
  };
  struct {
    unsigned w:32;
  };
} __C1INTbits_t;
extern volatile __C1INTbits_t C1INTbits __asm__ ("C1INT") __attribute__((section("sfrs")));
extern volatile unsigned int        C1INTCLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1INTSET __attribute__((section("sfrs")));
extern volatile unsigned int        C1INTINV __attribute__((section("sfrs")));
extern volatile unsigned int        C1VEC __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned ICODE:7;
    unsigned :1;
    unsigned FILHIT:5;
  };
  struct {
    unsigned w:32;
  };
} __C1VECbits_t;
extern volatile __C1VECbits_t C1VECbits __asm__ ("C1VEC") __attribute__((section("sfrs")));
extern volatile unsigned int        C1VECCLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1VECSET __attribute__((section("sfrs")));
extern volatile unsigned int        C1VECINV __attribute__((section("sfrs")));
extern volatile unsigned int        C1TREC __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RERRCNT:8;
    unsigned TERRCNT:8;
    unsigned EWARN:1;
    unsigned RXWARN:1;
    unsigned TXWARN:1;
    unsigned RXBP:1;
    unsigned TXBP:1;
    unsigned TXBO:1;
  };
  struct {
    unsigned w:32;
  };
} __C1TRECbits_t;
extern volatile __C1TRECbits_t C1TRECbits __asm__ ("C1TREC") __attribute__((section("sfrs")));
extern volatile unsigned int        C1TRECCLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1TRECSET __attribute__((section("sfrs")));
extern volatile unsigned int        C1TRECINV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FSTAT __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned FIFOIP:32;
  };
  struct {
    unsigned FIFOIP0:1;
    unsigned FIFOIP1:1;
    unsigned FIFOIP2:1;
    unsigned FIFOIP3:1;
    unsigned FIFOIP4:1;
    unsigned FIFOIP5:1;
    unsigned FIFOIP6:1;
    unsigned FIFOIP7:1;
    unsigned FIFOIP8:1;
    unsigned FIFOIP9:1;
    unsigned FIFOIP10:1;
    unsigned FIFOIP11:1;
    unsigned FIFOIP12:1;
    unsigned FIFOIP13:1;
    unsigned FIFOIP14:1;
    unsigned FIFOIP15:1;
    unsigned FIFOIP16:1;
    unsigned FIFOIP17:1;
    unsigned FIFOIP18:1;
    unsigned FIFOIP19:1;
    unsigned FIFOIP20:1;
    unsigned FIFOIP21:1;
    unsigned FIFOIP22:1;
    unsigned FIFOIP23:1;
    unsigned FIFOIP24:1;
    unsigned FIFOIP25:1;
    unsigned FIFOIP26:1;
    unsigned FIFOIP27:1;
    unsigned FIFOIP28:1;
    unsigned FIFOIP29:1;
    unsigned FIFOIP30:1;
    unsigned FIFOIP31:1;
  };
  struct {
    unsigned w:32;
  };
} __C1FSTATbits_t;
extern volatile __C1FSTATbits_t C1FSTATbits __asm__ ("C1FSTAT") __attribute__((section("sfrs")));
extern volatile unsigned int        C1FSTATCLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FSTATSET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FSTATINV __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXOVF __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RXOVF:32;
  };
  struct {
    unsigned RXOVF0:1;
    unsigned RXOVF1:1;
    unsigned RXOVF2:1;
    unsigned RXOVF3:1;
    unsigned RXOVF4:1;
    unsigned RXOVF5:1;
    unsigned RXOVF6:1;
    unsigned RXOVF7:1;
    unsigned RXOVF8:1;
    unsigned RXOVF9:1;
    unsigned RXOVF10:1;
    unsigned RXOVF11:1;
    unsigned RXOVF12:1;
    unsigned RXOVF13:1;
    unsigned RXOVF14:1;
    unsigned RXOVF15:1;
    unsigned RXOVF16:1;
    unsigned RXOVF17:1;
    unsigned RXOVF18:1;
    unsigned RXOVF19:1;
    unsigned RXOVF20:1;
    unsigned RXOVF21:1;
    unsigned RXOVF22:1;
    unsigned RXOVF23:1;
    unsigned RXOVF24:1;
    unsigned RXOVF25:1;
    unsigned RXOVF26:1;
    unsigned RXOVF27:1;
    unsigned RXOVF28:1;
    unsigned RXOVF29:1;
    unsigned RXOVF30:1;
    unsigned RXOVF31:1;
  };
  struct {
    unsigned w:32;
  };
} __C1RXOVFbits_t;
extern volatile __C1RXOVFbits_t C1RXOVFbits __asm__ ("C1RXOVF") __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXOVFCLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXOVFSET __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXOVFINV __attribute__((section("sfrs")));
extern volatile unsigned int        C1TMR __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CANTSPRE:16;
    unsigned CANTS:16;
  };
  struct {
    unsigned w:32;
  };
} __C1TMRbits_t;
extern volatile __C1TMRbits_t C1TMRbits __asm__ ("C1TMR") __attribute__((section("sfrs")));
extern volatile unsigned int        C1TMRCLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1TMRSET __attribute__((section("sfrs")));
extern volatile unsigned int        C1TMRINV __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXM0 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned EID:18;
    unsigned :1;
    unsigned MIDE:1;
    unsigned :1;
    unsigned SID:11;
  };
  struct {
    unsigned w:32;
  };
} __C1RXM0bits_t;
extern volatile __C1RXM0bits_t C1RXM0bits __asm__ ("C1RXM0") __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXM0CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXM0SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXM0INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXM1 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned EID:18;
    unsigned :1;
    unsigned MIDE:1;
    unsigned :1;
    unsigned SID:11;
  };
  struct {
    unsigned w:32;
  };
} __C1RXM1bits_t;
extern volatile __C1RXM1bits_t C1RXM1bits __asm__ ("C1RXM1") __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXM1CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXM1SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXM1INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXM2 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned EID:18;
    unsigned :1;
    unsigned MIDE:1;
    unsigned :1;
    unsigned SID:11;
  };
  struct {
    unsigned w:32;
  };
} __C1RXM2bits_t;
extern volatile __C1RXM2bits_t C1RXM2bits __asm__ ("C1RXM2") __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXM2CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXM2SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXM2INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXM3 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned EID:18;
    unsigned :1;
    unsigned MIDE:1;
    unsigned :1;
    unsigned SID:11;
  };
  struct {
    unsigned w:32;
  };
} __C1RXM3bits_t;
extern volatile __C1RXM3bits_t C1RXM3bits __asm__ ("C1RXM3") __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXM3CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXM3SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXM3INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FLTCON0 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned FSEL0:5;
    unsigned MSEL0:2;
    unsigned FLTEN0:1;
    unsigned FSEL1:5;
    unsigned MSEL1:2;
    unsigned FLTEN1:1;
    unsigned FSEL2:5;
    unsigned MSEL2:2;
    unsigned FLTEN2:1;
    unsigned FSEL3:5;
    unsigned MSEL3:2;
    unsigned FLTEN3:1;
  };
  struct {
    unsigned w:32;
  };
} __C1FLTCON0bits_t;
extern volatile __C1FLTCON0bits_t C1FLTCON0bits __asm__ ("C1FLTCON0") __attribute__((section("sfrs")));
extern volatile unsigned int        C1FLTCON0CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FLTCON0SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FLTCON0INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FLTCON1 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned FSEL4:5;
    unsigned MSEL4:2;
    unsigned FLTEN4:1;
    unsigned FSEL5:5;
    unsigned MSEL5:2;
    unsigned FLTEN5:1;
    unsigned FSEL6:5;
    unsigned MSEL6:2;
    unsigned FLTEN6:1;
    unsigned FSEL7:5;
    unsigned MSEL7:2;
    unsigned FLTEN7:1;
  };
  struct {
    unsigned w:32;
  };
} __C1FLTCON1bits_t;
extern volatile __C1FLTCON1bits_t C1FLTCON1bits __asm__ ("C1FLTCON1") __attribute__((section("sfrs")));
extern volatile unsigned int        C1FLTCON1CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FLTCON1SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FLTCON1INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FLTCON2 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned FSEL8:5;
    unsigned MSEL8:2;
    unsigned FLTEN8:1;
    unsigned FSEL9:5;
    unsigned MSEL9:2;
    unsigned FLTEN9:1;
    unsigned FSEL10:5;
    unsigned MSEL10:2;
    unsigned FLTEN10:1;
    unsigned FSEL11:5;
    unsigned MSEL11:2;
    unsigned FLTEN11:1;
  };
  struct {
    unsigned w:32;
  };
} __C1FLTCON2bits_t;
extern volatile __C1FLTCON2bits_t C1FLTCON2bits __asm__ ("C1FLTCON2") __attribute__((section("sfrs")));
extern volatile unsigned int        C1FLTCON2CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FLTCON2SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FLTCON2INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FLTCON3 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned FSEL12:5;
    unsigned MSEL12:2;
    unsigned FLTEN12:1;
    unsigned FSEL13:5;
    unsigned MSEL13:2;
    unsigned FLTEN13:1;
    unsigned FSEL14:5;
    unsigned MSEL14:2;
    unsigned FLTEN14:1;
    unsigned FSEL15:5;
    unsigned MSEL15:2;
    unsigned FLTEN15:1;
  };
  struct {
    unsigned w:32;
  };
} __C1FLTCON3bits_t;
extern volatile __C1FLTCON3bits_t C1FLTCON3bits __asm__ ("C1FLTCON3") __attribute__((section("sfrs")));
extern volatile unsigned int        C1FLTCON3CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FLTCON3SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FLTCON3INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FLTCON4 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned FSEL16:5;
    unsigned MSEL16:2;
    unsigned FLTEN16:1;
    unsigned FSEL17:5;
    unsigned MSEL17:2;
    unsigned FLTEN17:1;
    unsigned FSEL18:5;
    unsigned MSEL18:2;
    unsigned FLTEN18:1;
    unsigned FSEL19:5;
    unsigned MSEL19:2;
    unsigned FLTEN19:1;
  };
  struct {
    unsigned w:32;
  };
} __C1FLTCON4bits_t;
extern volatile __C1FLTCON4bits_t C1FLTCON4bits __asm__ ("C1FLTCON4") __attribute__((section("sfrs")));
extern volatile unsigned int        C1FLTCON4CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FLTCON4SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FLTCON4INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FLTCON5 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned FSEL20:5;
    unsigned MSEL20:2;
    unsigned FLTEN20:1;
    unsigned FSEL21:5;
    unsigned MSEL21:2;
    unsigned FLTEN21:1;
    unsigned FSEL22:5;
    unsigned MSEL22:2;
    unsigned FLTEN22:1;
    unsigned FSEL23:5;
    unsigned MSEL23:2;
    unsigned FLTEN23:1;
  };
  struct {
    unsigned w:32;
  };
} __C1FLTCON5bits_t;
extern volatile __C1FLTCON5bits_t C1FLTCON5bits __asm__ ("C1FLTCON5") __attribute__((section("sfrs")));
extern volatile unsigned int        C1FLTCON5CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FLTCON5SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FLTCON5INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FLTCON6 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned FSEL24:5;
    unsigned MSEL24:2;
    unsigned FLTEN24:1;
    unsigned FSEL25:5;
    unsigned MSEL25:2;
    unsigned FLTEN25:1;
    unsigned FSEL26:5;
    unsigned MSEL26:2;
    unsigned FLTEN26:1;
    unsigned FSEL27:5;
    unsigned MSEL27:2;
    unsigned FLTEN27:1;
  };
  struct {
    unsigned w:32;
  };
} __C1FLTCON6bits_t;
extern volatile __C1FLTCON6bits_t C1FLTCON6bits __asm__ ("C1FLTCON6") __attribute__((section("sfrs")));
extern volatile unsigned int        C1FLTCON6CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FLTCON6SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FLTCON6INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FLTCON7 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned FSEL28:5;
    unsigned MSEL28:2;
    unsigned FLTEN28:1;
    unsigned FSEL29:5;
    unsigned MSEL29:2;
    unsigned FLTEN29:1;
    unsigned FSEL30:5;
    unsigned MSEL30:2;
    unsigned FLTEN30:1;
    unsigned FSEL31:5;
    unsigned MSEL31:2;
    unsigned FLTEN31:1;
  };
  struct {
    unsigned w:32;
  };
} __C1FLTCON7bits_t;
extern volatile __C1FLTCON7bits_t C1FLTCON7bits __asm__ ("C1FLTCON7") __attribute__((section("sfrs")));
extern volatile unsigned int        C1FLTCON7CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FLTCON7SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FLTCON7INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF0 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned EID:18;
    unsigned :1;
    unsigned EXID:1;
    unsigned :1;
    unsigned SID:11;
  };
  struct {
    unsigned w:32;
  };
} __C1RXF0bits_t;
extern volatile __C1RXF0bits_t C1RXF0bits __asm__ ("C1RXF0") __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF0CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF0SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF0INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF1 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned EID:18;
    unsigned :1;
    unsigned EXID:1;
    unsigned :1;
    unsigned SID:11;
  };
  struct {
    unsigned w:32;
  };
} __C1RXF1bits_t;
extern volatile __C1RXF1bits_t C1RXF1bits __asm__ ("C1RXF1") __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF1CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF1SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF1INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF2 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned EID:18;
    unsigned :1;
    unsigned EXID:1;
    unsigned :1;
    unsigned SID:11;
  };
  struct {
    unsigned w:32;
  };
} __C1RXF2bits_t;
extern volatile __C1RXF2bits_t C1RXF2bits __asm__ ("C1RXF2") __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF2CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF2SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF2INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF3 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned EID:18;
    unsigned :1;
    unsigned EXID:1;
    unsigned :1;
    unsigned SID:11;
  };
  struct {
    unsigned w:32;
  };
} __C1RXF3bits_t;
extern volatile __C1RXF3bits_t C1RXF3bits __asm__ ("C1RXF3") __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF3CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF3SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF3INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF4 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned EID:18;
    unsigned :1;
    unsigned EXID:1;
    unsigned :1;
    unsigned SID:11;
  };
  struct {
    unsigned w:32;
  };
} __C1RXF4bits_t;
extern volatile __C1RXF4bits_t C1RXF4bits __asm__ ("C1RXF4") __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF4CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF4SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF4INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF5 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned EID:18;
    unsigned :1;
    unsigned EXID:1;
    unsigned :1;
    unsigned SID:11;
  };
  struct {
    unsigned w:32;
  };
} __C1RXF5bits_t;
extern volatile __C1RXF5bits_t C1RXF5bits __asm__ ("C1RXF5") __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF5CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF5SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF5INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF6 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned EID:18;
    unsigned :1;
    unsigned EXID:1;
    unsigned :1;
    unsigned SID:11;
  };
  struct {
    unsigned w:32;
  };
} __C1RXF6bits_t;
extern volatile __C1RXF6bits_t C1RXF6bits __asm__ ("C1RXF6") __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF6CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF6SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF6INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF7 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned EID:18;
    unsigned :1;
    unsigned EXID:1;
    unsigned :1;
    unsigned SID:11;
  };
  struct {
    unsigned w:32;
  };
} __C1RXF7bits_t;
extern volatile __C1RXF7bits_t C1RXF7bits __asm__ ("C1RXF7") __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF7CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF7SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF7INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF8 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned EID:18;
    unsigned :1;
    unsigned EXID:1;
    unsigned :1;
    unsigned SID:11;
  };
  struct {
    unsigned w:32;
  };
} __C1RXF8bits_t;
extern volatile __C1RXF8bits_t C1RXF8bits __asm__ ("C1RXF8") __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF8CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF8SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF8INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF9 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned EID:18;
    unsigned :1;
    unsigned EXID:1;
    unsigned :1;
    unsigned SID:11;
  };
  struct {
    unsigned w:32;
  };
} __C1RXF9bits_t;
extern volatile __C1RXF9bits_t C1RXF9bits __asm__ ("C1RXF9") __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF9CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF9SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF9INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF10 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned EID:18;
    unsigned :1;
    unsigned EXID:1;
    unsigned :1;
    unsigned SID:11;
  };
  struct {
    unsigned w:32;
  };
} __C1RXF10bits_t;
extern volatile __C1RXF10bits_t C1RXF10bits __asm__ ("C1RXF10") __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF10CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF10SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF10INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF11 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned EID:18;
    unsigned :1;
    unsigned EXID:1;
    unsigned :1;
    unsigned SID:11;
  };
  struct {
    unsigned w:32;
  };
} __C1RXF11bits_t;
extern volatile __C1RXF11bits_t C1RXF11bits __asm__ ("C1RXF11") __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF11CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF11SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF11INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF12 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned EID:18;
    unsigned :1;
    unsigned EXID:1;
    unsigned :1;
    unsigned SID:11;
  };
  struct {
    unsigned w:32;
  };
} __C1RXF12bits_t;
extern volatile __C1RXF12bits_t C1RXF12bits __asm__ ("C1RXF12") __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF12CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF12SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF12INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF13 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned EID:18;
    unsigned :1;
    unsigned EXID:1;
    unsigned :1;
    unsigned SID:11;
  };
  struct {
    unsigned w:32;
  };
} __C1RXF13bits_t;
extern volatile __C1RXF13bits_t C1RXF13bits __asm__ ("C1RXF13") __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF13CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF13SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF13INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF14 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned EID:18;
    unsigned :1;
    unsigned EXID:1;
    unsigned :1;
    unsigned SID:11;
  };
  struct {
    unsigned w:32;
  };
} __C1RXF14bits_t;
extern volatile __C1RXF14bits_t C1RXF14bits __asm__ ("C1RXF14") __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF14CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF14SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF14INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF15 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned EID:18;
    unsigned :1;
    unsigned EXID:1;
    unsigned :1;
    unsigned SID:11;
  };
  struct {
    unsigned w:32;
  };
} __C1RXF15bits_t;
extern volatile __C1RXF15bits_t C1RXF15bits __asm__ ("C1RXF15") __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF15CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF15SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF15INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF16 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned EID:18;
    unsigned :1;
    unsigned EXID:1;
    unsigned :1;
    unsigned SID:11;
  };
  struct {
    unsigned w:32;
  };
} __C1RXF16bits_t;
extern volatile __C1RXF16bits_t C1RXF16bits __asm__ ("C1RXF16") __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF16CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF16SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF16INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF17 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned EID:18;
    unsigned :1;
    unsigned EXID:1;
    unsigned :1;
    unsigned SID:11;
  };
  struct {
    unsigned w:32;
  };
} __C1RXF17bits_t;
extern volatile __C1RXF17bits_t C1RXF17bits __asm__ ("C1RXF17") __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF17CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF17SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF17INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF18 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned EID:18;
    unsigned :1;
    unsigned EXID:1;
    unsigned :1;
    unsigned SID:11;
  };
  struct {
    unsigned w:32;
  };
} __C1RXF18bits_t;
extern volatile __C1RXF18bits_t C1RXF18bits __asm__ ("C1RXF18") __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF18CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF18SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF18INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF19 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned EID:18;
    unsigned :1;
    unsigned EXID:1;
    unsigned :1;
    unsigned SID:11;
  };
  struct {
    unsigned w:32;
  };
} __C1RXF19bits_t;
extern volatile __C1RXF19bits_t C1RXF19bits __asm__ ("C1RXF19") __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF19CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF19SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF19INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF20 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned EID:18;
    unsigned :1;
    unsigned EXID:1;
    unsigned :1;
    unsigned SID:11;
  };
  struct {
    unsigned w:32;
  };
} __C1RXF20bits_t;
extern volatile __C1RXF20bits_t C1RXF20bits __asm__ ("C1RXF20") __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF20CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF20SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF20INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF21 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned EID:18;
    unsigned :1;
    unsigned EXID:1;
    unsigned :1;
    unsigned SID:11;
  };
  struct {
    unsigned w:32;
  };
} __C1RXF21bits_t;
extern volatile __C1RXF21bits_t C1RXF21bits __asm__ ("C1RXF21") __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF21CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF21SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF21INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF22 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned EID:18;
    unsigned :1;
    unsigned EXID:1;
    unsigned :1;
    unsigned SID:11;
  };
  struct {
    unsigned w:32;
  };
} __C1RXF22bits_t;
extern volatile __C1RXF22bits_t C1RXF22bits __asm__ ("C1RXF22") __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF22CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF22SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF22INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF23 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned EID:18;
    unsigned :1;
    unsigned EXID:1;
    unsigned :1;
    unsigned SID:11;
  };
  struct {
    unsigned w:32;
  };
} __C1RXF23bits_t;
extern volatile __C1RXF23bits_t C1RXF23bits __asm__ ("C1RXF23") __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF23CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF23SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF23INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF24 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned EID:18;
    unsigned :1;
    unsigned EXID:1;
    unsigned :1;
    unsigned SID:11;
  };
  struct {
    unsigned w:32;
  };
} __C1RXF24bits_t;
extern volatile __C1RXF24bits_t C1RXF24bits __asm__ ("C1RXF24") __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF24CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF24SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF24INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF25 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned EID:18;
    unsigned :1;
    unsigned EXID:1;
    unsigned :1;
    unsigned SID:11;
  };
  struct {
    unsigned w:32;
  };
} __C1RXF25bits_t;
extern volatile __C1RXF25bits_t C1RXF25bits __asm__ ("C1RXF25") __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF25CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF25SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF25INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF26 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned EID:18;
    unsigned :1;
    unsigned EXID:1;
    unsigned :1;
    unsigned SID:11;
  };
  struct {
    unsigned w:32;
  };
} __C1RXF26bits_t;
extern volatile __C1RXF26bits_t C1RXF26bits __asm__ ("C1RXF26") __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF26CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF26SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF26INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF27 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned EID:18;
    unsigned :1;
    unsigned EXID:1;
    unsigned :1;
    unsigned SID:11;
  };
  struct {
    unsigned w:32;
  };
} __C1RXF27bits_t;
extern volatile __C1RXF27bits_t C1RXF27bits __asm__ ("C1RXF27") __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF27CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF27SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF27INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF28 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned EID:18;
    unsigned :1;
    unsigned EXID:1;
    unsigned :1;
    unsigned SID:11;
  };
  struct {
    unsigned w:32;
  };
} __C1RXF28bits_t;
extern volatile __C1RXF28bits_t C1RXF28bits __asm__ ("C1RXF28") __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF28CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF28SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF28INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF29 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned EID:18;
    unsigned :1;
    unsigned EXID:1;
    unsigned :1;
    unsigned SID:11;
  };
  struct {
    unsigned w:32;
  };
} __C1RXF29bits_t;
extern volatile __C1RXF29bits_t C1RXF29bits __asm__ ("C1RXF29") __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF29CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF29SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF29INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF30 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned EID:18;
    unsigned :1;
    unsigned EXID:1;
    unsigned :1;
    unsigned SID:11;
  };
  struct {
    unsigned w:32;
  };
} __C1RXF30bits_t;
extern volatile __C1RXF30bits_t C1RXF30bits __asm__ ("C1RXF30") __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF30CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF30SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF30INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF31 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned EID:18;
    unsigned :1;
    unsigned EXID:1;
    unsigned :1;
    unsigned SID:11;
  };
  struct {
    unsigned w:32;
  };
} __C1RXF31bits_t;
extern volatile __C1RXF31bits_t C1RXF31bits __asm__ ("C1RXF31") __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF31CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF31SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1RXF31INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOBA __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOBACLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOBASET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOBAINV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON0 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TXPRI:2;
    unsigned RTREN:1;
    unsigned TXREQ:1;
    unsigned TXERR:1;
    unsigned TXLARB:1;
    unsigned TXABAT:1;
    unsigned TXEN:1;
    unsigned :4;
    unsigned DONLY:1;
    unsigned UINC:1;
    unsigned FRESET:1;
    unsigned :1;
    unsigned FSIZE:5;
  };
  struct {
    unsigned w:32;
  };
} __C1FIFOCON0bits_t;
extern volatile __C1FIFOCON0bits_t C1FIFOCON0bits __asm__ ("C1FIFOCON0") __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON0CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON0SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON0INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT0 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RXNEMPTYIF:1;
    unsigned RXHALFIF:1;
    unsigned RXFULLIF:1;
    unsigned RXOVFLIF:1;
    unsigned :4;
    unsigned TXEMPTYIF:1;
    unsigned TXHALFIF:1;
    unsigned TXNFULLIF:1;
    unsigned :5;
    unsigned RXNEMPTYIE:1;
    unsigned RXHALFIE:1;
    unsigned RXFULLIE:1;
    unsigned RXOVFLIE:1;
    unsigned :4;
    unsigned TXEMPTYIE:1;
    unsigned TXHALFIE:1;
    unsigned TXNFULLIE:1;
  };
  struct {
    unsigned w:32;
  };
} __C1FIFOINT0bits_t;
extern volatile __C1FIFOINT0bits_t C1FIFOINT0bits __asm__ ("C1FIFOINT0") __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT0CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT0SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT0INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA0 __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA0CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA0SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA0INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI0 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CFIFOCI:5;
  };
  struct {
    unsigned w:32;
  };
} __C1FIFOCI0bits_t;
extern volatile __C1FIFOCI0bits_t C1FIFOCI0bits __asm__ ("C1FIFOCI0") __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI0CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI0SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI0INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON1 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TXPRI:2;
    unsigned RTREN:1;
    unsigned TXREQ:1;
    unsigned TXERR:1;
    unsigned TXLARB:1;
    unsigned TXABAT:1;
    unsigned TXEN:1;
    unsigned :4;
    unsigned DONLY:1;
    unsigned UINC:1;
    unsigned FRESET:1;
    unsigned :1;
    unsigned FSIZE:5;
  };
  struct {
    unsigned w:32;
  };
} __C1FIFOCON1bits_t;
extern volatile __C1FIFOCON1bits_t C1FIFOCON1bits __asm__ ("C1FIFOCON1") __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON1CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON1SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON1INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT1 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RXNEMPTYIF:1;
    unsigned RXHALFIF:1;
    unsigned RXFULLIF:1;
    unsigned RXOVFLIF:1;
    unsigned :4;
    unsigned TXEMPTYIF:1;
    unsigned TXHALFIF:1;
    unsigned TXNFULLIF:1;
    unsigned :5;
    unsigned RXNEMPTYIE:1;
    unsigned RXHALFIE:1;
    unsigned RXFULLIE:1;
    unsigned RXOVFLIE:1;
    unsigned :4;
    unsigned TXEMPTYIE:1;
    unsigned TXHALFIE:1;
    unsigned TXNFULLIE:1;
  };
  struct {
    unsigned w:32;
  };
} __C1FIFOINT1bits_t;
extern volatile __C1FIFOINT1bits_t C1FIFOINT1bits __asm__ ("C1FIFOINT1") __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT1CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT1SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT1INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA1 __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA1CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA1SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA1INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI1 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CFIFOCI:5;
  };
  struct {
    unsigned w:32;
  };
} __C1FIFOCI1bits_t;
extern volatile __C1FIFOCI1bits_t C1FIFOCI1bits __asm__ ("C1FIFOCI1") __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI1CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI1SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI1INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON2 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TXPRI:2;
    unsigned RTREN:1;
    unsigned TXREQ:1;
    unsigned TXERR:1;
    unsigned TXLARB:1;
    unsigned TXABAT:1;
    unsigned TXEN:1;
    unsigned :4;
    unsigned DONLY:1;
    unsigned UINC:1;
    unsigned FRESET:1;
    unsigned :1;
    unsigned FSIZE:5;
  };
  struct {
    unsigned w:32;
  };
} __C1FIFOCON2bits_t;
extern volatile __C1FIFOCON2bits_t C1FIFOCON2bits __asm__ ("C1FIFOCON2") __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON2CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON2SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON2INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT2 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RXNEMPTYIF:1;
    unsigned RXHALFIF:1;
    unsigned RXFULLIF:1;
    unsigned RXOVFLIF:1;
    unsigned :4;
    unsigned TXEMPTYIF:1;
    unsigned TXHALFIF:1;
    unsigned TXNFULLIF:1;
    unsigned :5;
    unsigned RXNEMPTYIE:1;
    unsigned RXHALFIE:1;
    unsigned RXFULLIE:1;
    unsigned RXOVFLIE:1;
    unsigned :4;
    unsigned TXEMPTYIE:1;
    unsigned TXHALFIE:1;
    unsigned TXNFULLIE:1;
  };
  struct {
    unsigned w:32;
  };
} __C1FIFOINT2bits_t;
extern volatile __C1FIFOINT2bits_t C1FIFOINT2bits __asm__ ("C1FIFOINT2") __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT2CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT2SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT2INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA2 __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA2CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA2SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA2INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI2 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CFIFOCI:5;
  };
  struct {
    unsigned w:32;
  };
} __C1FIFOCI2bits_t;
extern volatile __C1FIFOCI2bits_t C1FIFOCI2bits __asm__ ("C1FIFOCI2") __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI2CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI2SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI2INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON3 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TXPRI:2;
    unsigned RTREN:1;
    unsigned TXREQ:1;
    unsigned TXERR:1;
    unsigned TXLARB:1;
    unsigned TXABAT:1;
    unsigned TXEN:1;
    unsigned :4;
    unsigned DONLY:1;
    unsigned UINC:1;
    unsigned FRESET:1;
    unsigned :1;
    unsigned FSIZE:5;
  };
  struct {
    unsigned w:32;
  };
} __C1FIFOCON3bits_t;
extern volatile __C1FIFOCON3bits_t C1FIFOCON3bits __asm__ ("C1FIFOCON3") __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON3CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON3SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON3INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT3 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RXNEMPTYIF:1;
    unsigned RXHALFIF:1;
    unsigned RXFULLIF:1;
    unsigned RXOVFLIF:1;
    unsigned :4;
    unsigned TXEMPTYIF:1;
    unsigned TXHALFIF:1;
    unsigned TXNFULLIF:1;
    unsigned :5;
    unsigned RXNEMPTYIE:1;
    unsigned RXHALFIE:1;
    unsigned RXFULLIE:1;
    unsigned RXOVFLIE:1;
    unsigned :4;
    unsigned TXEMPTYIE:1;
    unsigned TXHALFIE:1;
    unsigned TXNFULLIE:1;
  };
  struct {
    unsigned w:32;
  };
} __C1FIFOINT3bits_t;
extern volatile __C1FIFOINT3bits_t C1FIFOINT3bits __asm__ ("C1FIFOINT3") __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT3CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT3SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT3INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA3 __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA3CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA3SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA3INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI3 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CFIFOCI:5;
  };
  struct {
    unsigned w:32;
  };
} __C1FIFOCI3bits_t;
extern volatile __C1FIFOCI3bits_t C1FIFOCI3bits __asm__ ("C1FIFOCI3") __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI3CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI3SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI3INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON4 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TXPRI:2;
    unsigned RTREN:1;
    unsigned TXREQ:1;
    unsigned TXERR:1;
    unsigned TXLARB:1;
    unsigned TXABAT:1;
    unsigned TXEN:1;
    unsigned :4;
    unsigned DONLY:1;
    unsigned UINC:1;
    unsigned FRESET:1;
    unsigned :1;
    unsigned FSIZE:5;
  };
  struct {
    unsigned w:32;
  };
} __C1FIFOCON4bits_t;
extern volatile __C1FIFOCON4bits_t C1FIFOCON4bits __asm__ ("C1FIFOCON4") __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON4CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON4SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON4INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT4 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RXNEMPTYIF:1;
    unsigned RXHALFIF:1;
    unsigned RXFULLIF:1;
    unsigned RXOVFLIF:1;
    unsigned :4;
    unsigned TXEMPTYIF:1;
    unsigned TXHALFIF:1;
    unsigned TXNFULLIF:1;
    unsigned :5;
    unsigned RXNEMPTYIE:1;
    unsigned RXHALFIE:1;
    unsigned RXFULLIE:1;
    unsigned RXOVFLIE:1;
    unsigned :4;
    unsigned TXEMPTYIE:1;
    unsigned TXHALFIE:1;
    unsigned TXNFULLIE:1;
  };
  struct {
    unsigned w:32;
  };
} __C1FIFOINT4bits_t;
extern volatile __C1FIFOINT4bits_t C1FIFOINT4bits __asm__ ("C1FIFOINT4") __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT4CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT4SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT4INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA4 __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA4CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA4SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA4INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI4 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CFIFOCI:5;
  };
  struct {
    unsigned w:32;
  };
} __C1FIFOCI4bits_t;
extern volatile __C1FIFOCI4bits_t C1FIFOCI4bits __asm__ ("C1FIFOCI4") __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI4CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI4SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI4INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON5 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TXPRI:2;
    unsigned RTREN:1;
    unsigned TXREQ:1;
    unsigned TXERR:1;
    unsigned TXLARB:1;
    unsigned TXABAT:1;
    unsigned TXEN:1;
    unsigned :4;
    unsigned DONLY:1;
    unsigned UINC:1;
    unsigned FRESET:1;
    unsigned :1;
    unsigned FSIZE:5;
  };
  struct {
    unsigned w:32;
  };
} __C1FIFOCON5bits_t;
extern volatile __C1FIFOCON5bits_t C1FIFOCON5bits __asm__ ("C1FIFOCON5") __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON5CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON5SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON5INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT5 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RXNEMPTYIF:1;
    unsigned RXHALFIF:1;
    unsigned RXFULLIF:1;
    unsigned RXOVFLIF:1;
    unsigned :4;
    unsigned TXEMPTYIF:1;
    unsigned TXHALFIF:1;
    unsigned TXNFULLIF:1;
    unsigned :5;
    unsigned RXNEMPTYIE:1;
    unsigned RXHALFIE:1;
    unsigned RXFULLIE:1;
    unsigned RXOVFLIE:1;
    unsigned :4;
    unsigned TXEMPTYIE:1;
    unsigned TXHALFIE:1;
    unsigned TXNFULLIE:1;
  };
  struct {
    unsigned w:32;
  };
} __C1FIFOINT5bits_t;
extern volatile __C1FIFOINT5bits_t C1FIFOINT5bits __asm__ ("C1FIFOINT5") __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT5CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT5SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT5INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA5 __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA5CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA5SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA5INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI5 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CFIFOCI:5;
  };
  struct {
    unsigned w:32;
  };
} __C1FIFOCI5bits_t;
extern volatile __C1FIFOCI5bits_t C1FIFOCI5bits __asm__ ("C1FIFOCI5") __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI5CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI5SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI5INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON6 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TXPRI:2;
    unsigned RTREN:1;
    unsigned TXREQ:1;
    unsigned TXERR:1;
    unsigned TXLARB:1;
    unsigned TXABAT:1;
    unsigned TXEN:1;
    unsigned :4;
    unsigned DONLY:1;
    unsigned UINC:1;
    unsigned FRESET:1;
    unsigned :1;
    unsigned FSIZE:5;
  };
  struct {
    unsigned w:32;
  };
} __C1FIFOCON6bits_t;
extern volatile __C1FIFOCON6bits_t C1FIFOCON6bits __asm__ ("C1FIFOCON6") __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON6CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON6SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON6INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT6 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RXNEMPTYIF:1;
    unsigned RXHALFIF:1;
    unsigned RXFULLIF:1;
    unsigned RXOVFLIF:1;
    unsigned :4;
    unsigned TXEMPTYIF:1;
    unsigned TXHALFIF:1;
    unsigned TXNFULLIF:1;
    unsigned :5;
    unsigned RXNEMPTYIE:1;
    unsigned RXHALFIE:1;
    unsigned RXFULLIE:1;
    unsigned RXOVFLIE:1;
    unsigned :4;
    unsigned TXEMPTYIE:1;
    unsigned TXHALFIE:1;
    unsigned TXNFULLIE:1;
  };
  struct {
    unsigned w:32;
  };
} __C1FIFOINT6bits_t;
extern volatile __C1FIFOINT6bits_t C1FIFOINT6bits __asm__ ("C1FIFOINT6") __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT6CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT6SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT6INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA6 __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA6CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA6SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA6INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI6 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CFIFOCI:5;
  };
  struct {
    unsigned w:32;
  };
} __C1FIFOCI6bits_t;
extern volatile __C1FIFOCI6bits_t C1FIFOCI6bits __asm__ ("C1FIFOCI6") __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI6CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI6SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI6INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON7 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TXPRI:2;
    unsigned RTREN:1;
    unsigned TXREQ:1;
    unsigned TXERR:1;
    unsigned TXLARB:1;
    unsigned TXABAT:1;
    unsigned TXEN:1;
    unsigned :4;
    unsigned DONLY:1;
    unsigned UINC:1;
    unsigned FRESET:1;
    unsigned :1;
    unsigned FSIZE:5;
  };
  struct {
    unsigned w:32;
  };
} __C1FIFOCON7bits_t;
extern volatile __C1FIFOCON7bits_t C1FIFOCON7bits __asm__ ("C1FIFOCON7") __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON7CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON7SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON7INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT7 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RXNEMPTYIF:1;
    unsigned RXHALFIF:1;
    unsigned RXFULLIF:1;
    unsigned RXOVFLIF:1;
    unsigned :4;
    unsigned TXEMPTYIF:1;
    unsigned TXHALFIF:1;
    unsigned TXNFULLIF:1;
    unsigned :5;
    unsigned RXNEMPTYIE:1;
    unsigned RXHALFIE:1;
    unsigned RXFULLIE:1;
    unsigned RXOVFLIE:1;
    unsigned :4;
    unsigned TXEMPTYIE:1;
    unsigned TXHALFIE:1;
    unsigned TXNFULLIE:1;
  };
  struct {
    unsigned w:32;
  };
} __C1FIFOINT7bits_t;
extern volatile __C1FIFOINT7bits_t C1FIFOINT7bits __asm__ ("C1FIFOINT7") __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT7CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT7SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT7INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA7 __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA7CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA7SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA7INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI7 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CFIFOCI:5;
  };
  struct {
    unsigned w:32;
  };
} __C1FIFOCI7bits_t;
extern volatile __C1FIFOCI7bits_t C1FIFOCI7bits __asm__ ("C1FIFOCI7") __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI7CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI7SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI7INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON8 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TXPRI:2;
    unsigned RTREN:1;
    unsigned TXREQ:1;
    unsigned TXERR:1;
    unsigned TXLARB:1;
    unsigned TXABAT:1;
    unsigned TXEN:1;
    unsigned :4;
    unsigned DONLY:1;
    unsigned UINC:1;
    unsigned FRESET:1;
    unsigned :1;
    unsigned FSIZE:5;
  };
  struct {
    unsigned w:32;
  };
} __C1FIFOCON8bits_t;
extern volatile __C1FIFOCON8bits_t C1FIFOCON8bits __asm__ ("C1FIFOCON8") __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON8CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON8SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON8INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT8 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RXNEMPTYIF:1;
    unsigned RXHALFIF:1;
    unsigned RXFULLIF:1;
    unsigned RXOVFLIF:1;
    unsigned :4;
    unsigned TXEMPTYIF:1;
    unsigned TXHALFIF:1;
    unsigned TXNFULLIF:1;
    unsigned :5;
    unsigned RXNEMPTYIE:1;
    unsigned RXHALFIE:1;
    unsigned RXFULLIE:1;
    unsigned RXOVFLIE:1;
    unsigned :4;
    unsigned TXEMPTYIE:1;
    unsigned TXHALFIE:1;
    unsigned TXNFULLIE:1;
  };
  struct {
    unsigned w:32;
  };
} __C1FIFOINT8bits_t;
extern volatile __C1FIFOINT8bits_t C1FIFOINT8bits __asm__ ("C1FIFOINT8") __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT8CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT8SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT8INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA8 __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA8CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA8SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA8INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI8 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CFIFOCI:5;
  };
  struct {
    unsigned w:32;
  };
} __C1FIFOCI8bits_t;
extern volatile __C1FIFOCI8bits_t C1FIFOCI8bits __asm__ ("C1FIFOCI8") __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI8CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI8SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI8INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON9 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TXPRI:2;
    unsigned RTREN:1;
    unsigned TXREQ:1;
    unsigned TXERR:1;
    unsigned TXLARB:1;
    unsigned TXABAT:1;
    unsigned TXEN:1;
    unsigned :4;
    unsigned DONLY:1;
    unsigned UINC:1;
    unsigned FRESET:1;
    unsigned :1;
    unsigned FSIZE:5;
  };
  struct {
    unsigned w:32;
  };
} __C1FIFOCON9bits_t;
extern volatile __C1FIFOCON9bits_t C1FIFOCON9bits __asm__ ("C1FIFOCON9") __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON9CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON9SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON9INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT9 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RXNEMPTYIF:1;
    unsigned RXHALFIF:1;
    unsigned RXFULLIF:1;
    unsigned RXOVFLIF:1;
    unsigned :4;
    unsigned TXEMPTYIF:1;
    unsigned TXHALFIF:1;
    unsigned TXNFULLIF:1;
    unsigned :5;
    unsigned RXNEMPTYIE:1;
    unsigned RXHALFIE:1;
    unsigned RXFULLIE:1;
    unsigned RXOVFLIE:1;
    unsigned :4;
    unsigned TXEMPTYIE:1;
    unsigned TXHALFIE:1;
    unsigned TXNFULLIE:1;
  };
  struct {
    unsigned w:32;
  };
} __C1FIFOINT9bits_t;
extern volatile __C1FIFOINT9bits_t C1FIFOINT9bits __asm__ ("C1FIFOINT9") __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT9CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT9SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT9INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA9 __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA9CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA9SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA9INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI9 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CFIFOCI:5;
  };
  struct {
    unsigned w:32;
  };
} __C1FIFOCI9bits_t;
extern volatile __C1FIFOCI9bits_t C1FIFOCI9bits __asm__ ("C1FIFOCI9") __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI9CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI9SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI9INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON10 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TXPRI:2;
    unsigned RTREN:1;
    unsigned TXREQ:1;
    unsigned TXERR:1;
    unsigned TXLARB:1;
    unsigned TXABAT:1;
    unsigned TXEN:1;
    unsigned :4;
    unsigned DONLY:1;
    unsigned UINC:1;
    unsigned FRESET:1;
    unsigned :1;
    unsigned FSIZE:5;
  };
  struct {
    unsigned w:32;
  };
} __C1FIFOCON10bits_t;
extern volatile __C1FIFOCON10bits_t C1FIFOCON10bits __asm__ ("C1FIFOCON10") __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON10CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON10SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON10INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT10 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RXNEMPTYIF:1;
    unsigned RXHALFIF:1;
    unsigned RXFULLIF:1;
    unsigned RXOVFLIF:1;
    unsigned :4;
    unsigned TXEMPTYIF:1;
    unsigned TXHALFIF:1;
    unsigned TXNFULLIF:1;
    unsigned :5;
    unsigned RXNEMPTYIE:1;
    unsigned RXHALFIE:1;
    unsigned RXFULLIE:1;
    unsigned RXOVFLIE:1;
    unsigned :4;
    unsigned TXEMPTYIE:1;
    unsigned TXHALFIE:1;
    unsigned TXNFULLIE:1;
  };
  struct {
    unsigned w:32;
  };
} __C1FIFOINT10bits_t;
extern volatile __C1FIFOINT10bits_t C1FIFOINT10bits __asm__ ("C1FIFOINT10") __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT10CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT10SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT10INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA10 __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA10CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA10SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA10INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI10 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CFIFOCI:5;
  };
  struct {
    unsigned w:32;
  };
} __C1FIFOCI10bits_t;
extern volatile __C1FIFOCI10bits_t C1FIFOCI10bits __asm__ ("C1FIFOCI10") __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI10CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI10SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI10INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON11 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TXPRI:2;
    unsigned RTREN:1;
    unsigned TXREQ:1;
    unsigned TXERR:1;
    unsigned TXLARB:1;
    unsigned TXABAT:1;
    unsigned TXEN:1;
    unsigned :4;
    unsigned DONLY:1;
    unsigned UINC:1;
    unsigned FRESET:1;
    unsigned :1;
    unsigned FSIZE:5;
  };
  struct {
    unsigned w:32;
  };
} __C1FIFOCON11bits_t;
extern volatile __C1FIFOCON11bits_t C1FIFOCON11bits __asm__ ("C1FIFOCON11") __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON11CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON11SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON11INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT11 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RXNEMPTYIF:1;
    unsigned RXHALFIF:1;
    unsigned RXFULLIF:1;
    unsigned RXOVFLIF:1;
    unsigned :4;
    unsigned TXEMPTYIF:1;
    unsigned TXHALFIF:1;
    unsigned TXNFULLIF:1;
    unsigned :5;
    unsigned RXNEMPTYIE:1;
    unsigned RXHALFIE:1;
    unsigned RXFULLIE:1;
    unsigned RXOVFLIE:1;
    unsigned :4;
    unsigned TXEMPTYIE:1;
    unsigned TXHALFIE:1;
    unsigned TXNFULLIE:1;
  };
  struct {
    unsigned w:32;
  };
} __C1FIFOINT11bits_t;
extern volatile __C1FIFOINT11bits_t C1FIFOINT11bits __asm__ ("C1FIFOINT11") __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT11CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT11SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT11INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA11 __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA11CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA11SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA11INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI11 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CFIFOCI:5;
  };
  struct {
    unsigned w:32;
  };
} __C1FIFOCI11bits_t;
extern volatile __C1FIFOCI11bits_t C1FIFOCI11bits __asm__ ("C1FIFOCI11") __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI11CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI11SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI11INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON12 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TXPRI:2;
    unsigned RTREN:1;
    unsigned TXREQ:1;
    unsigned TXERR:1;
    unsigned TXLARB:1;
    unsigned TXABAT:1;
    unsigned TXEN:1;
    unsigned :4;
    unsigned DONLY:1;
    unsigned UINC:1;
    unsigned FRESET:1;
    unsigned :1;
    unsigned FSIZE:5;
  };
  struct {
    unsigned w:32;
  };
} __C1FIFOCON12bits_t;
extern volatile __C1FIFOCON12bits_t C1FIFOCON12bits __asm__ ("C1FIFOCON12") __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON12CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON12SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON12INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT12 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RXNEMPTYIF:1;
    unsigned RXHALFIF:1;
    unsigned RXFULLIF:1;
    unsigned RXOVFLIF:1;
    unsigned :4;
    unsigned TXEMPTYIF:1;
    unsigned TXHALFIF:1;
    unsigned TXNFULLIF:1;
    unsigned :5;
    unsigned RXNEMPTYIE:1;
    unsigned RXHALFIE:1;
    unsigned RXFULLIE:1;
    unsigned RXOVFLIE:1;
    unsigned :4;
    unsigned TXEMPTYIE:1;
    unsigned TXHALFIE:1;
    unsigned TXNFULLIE:1;
  };
  struct {
    unsigned w:32;
  };
} __C1FIFOINT12bits_t;
extern volatile __C1FIFOINT12bits_t C1FIFOINT12bits __asm__ ("C1FIFOINT12") __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT12CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT12SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT12INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA12 __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA12CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA12SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA12INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI12 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CFIFOCI:5;
  };
  struct {
    unsigned w:32;
  };
} __C1FIFOCI12bits_t;
extern volatile __C1FIFOCI12bits_t C1FIFOCI12bits __asm__ ("C1FIFOCI12") __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI12CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI12SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI12INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON13 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TXPRI:2;
    unsigned RTREN:1;
    unsigned TXREQ:1;
    unsigned TXERR:1;
    unsigned TXLARB:1;
    unsigned TXABAT:1;
    unsigned TXEN:1;
    unsigned :4;
    unsigned DONLY:1;
    unsigned UINC:1;
    unsigned FRESET:1;
    unsigned :1;
    unsigned FSIZE:5;
  };
  struct {
    unsigned w:32;
  };
} __C1FIFOCON13bits_t;
extern volatile __C1FIFOCON13bits_t C1FIFOCON13bits __asm__ ("C1FIFOCON13") __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON13CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON13SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON13INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT13 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RXNEMPTYIF:1;
    unsigned RXHALFIF:1;
    unsigned RXFULLIF:1;
    unsigned RXOVFLIF:1;
    unsigned :4;
    unsigned TXEMPTYIF:1;
    unsigned TXHALFIF:1;
    unsigned TXNFULLIF:1;
    unsigned :5;
    unsigned RXNEMPTYIE:1;
    unsigned RXHALFIE:1;
    unsigned RXFULLIE:1;
    unsigned RXOVFLIE:1;
    unsigned :4;
    unsigned TXEMPTYIE:1;
    unsigned TXHALFIE:1;
    unsigned TXNFULLIE:1;
  };
  struct {
    unsigned w:32;
  };
} __C1FIFOINT13bits_t;
extern volatile __C1FIFOINT13bits_t C1FIFOINT13bits __asm__ ("C1FIFOINT13") __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT13CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT13SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT13INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA13 __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA13CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA13SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA13INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI13 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CFIFOCI:5;
  };
  struct {
    unsigned w:32;
  };
} __C1FIFOCI13bits_t;
extern volatile __C1FIFOCI13bits_t C1FIFOCI13bits __asm__ ("C1FIFOCI13") __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI13CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI13SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI13INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON14 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TXPRI:2;
    unsigned RTREN:1;
    unsigned TXREQ:1;
    unsigned TXERR:1;
    unsigned TXLARB:1;
    unsigned TXABAT:1;
    unsigned TXEN:1;
    unsigned :4;
    unsigned DONLY:1;
    unsigned UINC:1;
    unsigned FRESET:1;
    unsigned :1;
    unsigned FSIZE:5;
  };
  struct {
    unsigned w:32;
  };
} __C1FIFOCON14bits_t;
extern volatile __C1FIFOCON14bits_t C1FIFOCON14bits __asm__ ("C1FIFOCON14") __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON14CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON14SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON14INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT14 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RXNEMPTYIF:1;
    unsigned RXHALFIF:1;
    unsigned RXFULLIF:1;
    unsigned RXOVFLIF:1;
    unsigned :4;
    unsigned TXEMPTYIF:1;
    unsigned TXHALFIF:1;
    unsigned TXNFULLIF:1;
    unsigned :5;
    unsigned RXNEMPTYIE:1;
    unsigned RXHALFIE:1;
    unsigned RXFULLIE:1;
    unsigned RXOVFLIE:1;
    unsigned :4;
    unsigned TXEMPTYIE:1;
    unsigned TXHALFIE:1;
    unsigned TXNFULLIE:1;
  };
  struct {
    unsigned w:32;
  };
} __C1FIFOINT14bits_t;
extern volatile __C1FIFOINT14bits_t C1FIFOINT14bits __asm__ ("C1FIFOINT14") __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT14CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT14SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT14INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA14 __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA14CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA14SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA14INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI14 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CFIFOCI:5;
  };
  struct {
    unsigned w:32;
  };
} __C1FIFOCI14bits_t;
extern volatile __C1FIFOCI14bits_t C1FIFOCI14bits __asm__ ("C1FIFOCI14") __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI14CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI14SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI14INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON15 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TXPRI:2;
    unsigned RTREN:1;
    unsigned TXREQ:1;
    unsigned TXERR:1;
    unsigned TXLARB:1;
    unsigned TXABAT:1;
    unsigned TXEN:1;
    unsigned :4;
    unsigned DONLY:1;
    unsigned UINC:1;
    unsigned FRESET:1;
    unsigned :1;
    unsigned FSIZE:5;
  };
  struct {
    unsigned w:32;
  };
} __C1FIFOCON15bits_t;
extern volatile __C1FIFOCON15bits_t C1FIFOCON15bits __asm__ ("C1FIFOCON15") __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON15CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON15SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON15INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT15 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RXNEMPTYIF:1;
    unsigned RXHALFIF:1;
    unsigned RXFULLIF:1;
    unsigned RXOVFLIF:1;
    unsigned :4;
    unsigned TXEMPTYIF:1;
    unsigned TXHALFIF:1;
    unsigned TXNFULLIF:1;
    unsigned :5;
    unsigned RXNEMPTYIE:1;
    unsigned RXHALFIE:1;
    unsigned RXFULLIE:1;
    unsigned RXOVFLIE:1;
    unsigned :4;
    unsigned TXEMPTYIE:1;
    unsigned TXHALFIE:1;
    unsigned TXNFULLIE:1;
  };
  struct {
    unsigned w:32;
  };
} __C1FIFOINT15bits_t;
extern volatile __C1FIFOINT15bits_t C1FIFOINT15bits __asm__ ("C1FIFOINT15") __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT15CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT15SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT15INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA15 __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA15CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA15SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA15INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI15 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CFIFOCI:5;
  };
  struct {
    unsigned w:32;
  };
} __C1FIFOCI15bits_t;
extern volatile __C1FIFOCI15bits_t C1FIFOCI15bits __asm__ ("C1FIFOCI15") __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI15CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI15SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI15INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON16 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TXPRI:2;
    unsigned RTREN:1;
    unsigned TXREQ:1;
    unsigned TXERR:1;
    unsigned TXLARB:1;
    unsigned TXABAT:1;
    unsigned TXEN:1;
    unsigned :4;
    unsigned DONLY:1;
    unsigned UINC:1;
    unsigned FRESET:1;
    unsigned :1;
    unsigned FSIZE:5;
  };
  struct {
    unsigned w:32;
  };
} __C1FIFOCON16bits_t;
extern volatile __C1FIFOCON16bits_t C1FIFOCON16bits __asm__ ("C1FIFOCON16") __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON16CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON16SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON16INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT16 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RXNEMPTYIF:1;
    unsigned RXHALFIF:1;
    unsigned RXFULLIF:1;
    unsigned RXOVFLIF:1;
    unsigned :4;
    unsigned TXEMPTYIF:1;
    unsigned TXHALFIF:1;
    unsigned TXNFULLIF:1;
    unsigned :5;
    unsigned RXNEMPTYIE:1;
    unsigned RXHALFIE:1;
    unsigned RXFULLIE:1;
    unsigned RXOVFLIE:1;
    unsigned :4;
    unsigned TXEMPTYIE:1;
    unsigned TXHALFIE:1;
    unsigned TXNFULLIE:1;
  };
  struct {
    unsigned w:32;
  };
} __C1FIFOINT16bits_t;
extern volatile __C1FIFOINT16bits_t C1FIFOINT16bits __asm__ ("C1FIFOINT16") __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT16CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT16SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT16INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA16 __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA16CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA16SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA16INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI16 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CFIFOCI:5;
  };
  struct {
    unsigned w:32;
  };
} __C1FIFOCI16bits_t;
extern volatile __C1FIFOCI16bits_t C1FIFOCI16bits __asm__ ("C1FIFOCI16") __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI16CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI16SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI16INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON17 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TXPRI:2;
    unsigned RTREN:1;
    unsigned TXREQ:1;
    unsigned TXERR:1;
    unsigned TXLARB:1;
    unsigned TXABAT:1;
    unsigned TXEN:1;
    unsigned :4;
    unsigned DONLY:1;
    unsigned UINC:1;
    unsigned FRESET:1;
    unsigned :1;
    unsigned FSIZE:5;
  };
  struct {
    unsigned w:32;
  };
} __C1FIFOCON17bits_t;
extern volatile __C1FIFOCON17bits_t C1FIFOCON17bits __asm__ ("C1FIFOCON17") __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON17CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON17SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON17INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT17 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RXNEMPTYIF:1;
    unsigned RXHALFIF:1;
    unsigned RXFULLIF:1;
    unsigned RXOVFLIF:1;
    unsigned :4;
    unsigned TXEMPTYIF:1;
    unsigned TXHALFIF:1;
    unsigned TXNFULLIF:1;
    unsigned :5;
    unsigned RXNEMPTYIE:1;
    unsigned RXHALFIE:1;
    unsigned RXFULLIE:1;
    unsigned RXOVFLIE:1;
    unsigned :4;
    unsigned TXEMPTYIE:1;
    unsigned TXHALFIE:1;
    unsigned TXNFULLIE:1;
  };
  struct {
    unsigned w:32;
  };
} __C1FIFOINT17bits_t;
extern volatile __C1FIFOINT17bits_t C1FIFOINT17bits __asm__ ("C1FIFOINT17") __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT17CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT17SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT17INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA17 __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA17CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA17SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA17INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI17 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CFIFOCI:5;
  };
  struct {
    unsigned w:32;
  };
} __C1FIFOCI17bits_t;
extern volatile __C1FIFOCI17bits_t C1FIFOCI17bits __asm__ ("C1FIFOCI17") __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI17CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI17SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI17INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON18 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TXPRI:2;
    unsigned RTREN:1;
    unsigned TXREQ:1;
    unsigned TXERR:1;
    unsigned TXLARB:1;
    unsigned TXABAT:1;
    unsigned TXEN:1;
    unsigned :4;
    unsigned DONLY:1;
    unsigned UINC:1;
    unsigned FRESET:1;
    unsigned :1;
    unsigned FSIZE:5;
  };
  struct {
    unsigned w:32;
  };
} __C1FIFOCON18bits_t;
extern volatile __C1FIFOCON18bits_t C1FIFOCON18bits __asm__ ("C1FIFOCON18") __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON18CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON18SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON18INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT18 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RXNEMPTYIF:1;
    unsigned RXHALFIF:1;
    unsigned RXFULLIF:1;
    unsigned RXOVFLIF:1;
    unsigned :4;
    unsigned TXEMPTYIF:1;
    unsigned TXHALFIF:1;
    unsigned TXNFULLIF:1;
    unsigned :5;
    unsigned RXNEMPTYIE:1;
    unsigned RXHALFIE:1;
    unsigned RXFULLIE:1;
    unsigned RXOVFLIE:1;
    unsigned :4;
    unsigned TXEMPTYIE:1;
    unsigned TXHALFIE:1;
    unsigned TXNFULLIE:1;
  };
  struct {
    unsigned w:32;
  };
} __C1FIFOINT18bits_t;
extern volatile __C1FIFOINT18bits_t C1FIFOINT18bits __asm__ ("C1FIFOINT18") __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT18CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT18SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT18INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA18 __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA18CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA18SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA18INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI18 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CFIFOCI:5;
  };
  struct {
    unsigned w:32;
  };
} __C1FIFOCI18bits_t;
extern volatile __C1FIFOCI18bits_t C1FIFOCI18bits __asm__ ("C1FIFOCI18") __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI18CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI18SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI18INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON19 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TXPRI:2;
    unsigned RTREN:1;
    unsigned TXREQ:1;
    unsigned TXERR:1;
    unsigned TXLARB:1;
    unsigned TXABAT:1;
    unsigned TXEN:1;
    unsigned :4;
    unsigned DONLY:1;
    unsigned UINC:1;
    unsigned FRESET:1;
    unsigned :1;
    unsigned FSIZE:5;
  };
  struct {
    unsigned w:32;
  };
} __C1FIFOCON19bits_t;
extern volatile __C1FIFOCON19bits_t C1FIFOCON19bits __asm__ ("C1FIFOCON19") __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON19CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON19SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON19INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT19 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RXNEMPTYIF:1;
    unsigned RXHALFIF:1;
    unsigned RXFULLIF:1;
    unsigned RXOVFLIF:1;
    unsigned :4;
    unsigned TXEMPTYIF:1;
    unsigned TXHALFIF:1;
    unsigned TXNFULLIF:1;
    unsigned :5;
    unsigned RXNEMPTYIE:1;
    unsigned RXHALFIE:1;
    unsigned RXFULLIE:1;
    unsigned RXOVFLIE:1;
    unsigned :4;
    unsigned TXEMPTYIE:1;
    unsigned TXHALFIE:1;
    unsigned TXNFULLIE:1;
  };
  struct {
    unsigned w:32;
  };
} __C1FIFOINT19bits_t;
extern volatile __C1FIFOINT19bits_t C1FIFOINT19bits __asm__ ("C1FIFOINT19") __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT19CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT19SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT19INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA19 __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA19CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA19SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA19INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI19 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CFIFOCI:5;
  };
  struct {
    unsigned w:32;
  };
} __C1FIFOCI19bits_t;
extern volatile __C1FIFOCI19bits_t C1FIFOCI19bits __asm__ ("C1FIFOCI19") __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI19CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI19SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI19INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON20 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TXPRI:2;
    unsigned RTREN:1;
    unsigned TXREQ:1;
    unsigned TXERR:1;
    unsigned TXLARB:1;
    unsigned TXABAT:1;
    unsigned TXEN:1;
    unsigned :4;
    unsigned DONLY:1;
    unsigned UINC:1;
    unsigned FRESET:1;
    unsigned :1;
    unsigned FSIZE:5;
  };
  struct {
    unsigned w:32;
  };
} __C1FIFOCON20bits_t;
extern volatile __C1FIFOCON20bits_t C1FIFOCON20bits __asm__ ("C1FIFOCON20") __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON20CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON20SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON20INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT20 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RXNEMPTYIF:1;
    unsigned RXHALFIF:1;
    unsigned RXFULLIF:1;
    unsigned RXOVFLIF:1;
    unsigned :4;
    unsigned TXEMPTYIF:1;
    unsigned TXHALFIF:1;
    unsigned TXNFULLIF:1;
    unsigned :5;
    unsigned RXNEMPTYIE:1;
    unsigned RXHALFIE:1;
    unsigned RXFULLIE:1;
    unsigned RXOVFLIE:1;
    unsigned :4;
    unsigned TXEMPTYIE:1;
    unsigned TXHALFIE:1;
    unsigned TXNFULLIE:1;
  };
  struct {
    unsigned w:32;
  };
} __C1FIFOINT20bits_t;
extern volatile __C1FIFOINT20bits_t C1FIFOINT20bits __asm__ ("C1FIFOINT20") __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT20CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT20SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT20INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA20 __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA20CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA20SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA20INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI20 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CFIFOCI:5;
  };
  struct {
    unsigned w:32;
  };
} __C1FIFOCI20bits_t;
extern volatile __C1FIFOCI20bits_t C1FIFOCI20bits __asm__ ("C1FIFOCI20") __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI20CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI20SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI20INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON21 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TXPRI:2;
    unsigned RTREN:1;
    unsigned TXREQ:1;
    unsigned TXERR:1;
    unsigned TXLARB:1;
    unsigned TXABAT:1;
    unsigned TXEN:1;
    unsigned :4;
    unsigned DONLY:1;
    unsigned UINC:1;
    unsigned FRESET:1;
    unsigned :1;
    unsigned FSIZE:5;
  };
  struct {
    unsigned w:32;
  };
} __C1FIFOCON21bits_t;
extern volatile __C1FIFOCON21bits_t C1FIFOCON21bits __asm__ ("C1FIFOCON21") __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON21CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON21SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON21INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT21 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RXNEMPTYIF:1;
    unsigned RXHALFIF:1;
    unsigned RXFULLIF:1;
    unsigned RXOVFLIF:1;
    unsigned :4;
    unsigned TXEMPTYIF:1;
    unsigned TXHALFIF:1;
    unsigned TXNFULLIF:1;
    unsigned :5;
    unsigned RXNEMPTYIE:1;
    unsigned RXHALFIE:1;
    unsigned RXFULLIE:1;
    unsigned RXOVFLIE:1;
    unsigned :4;
    unsigned TXEMPTYIE:1;
    unsigned TXHALFIE:1;
    unsigned TXNFULLIE:1;
  };
  struct {
    unsigned w:32;
  };
} __C1FIFOINT21bits_t;
extern volatile __C1FIFOINT21bits_t C1FIFOINT21bits __asm__ ("C1FIFOINT21") __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT21CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT21SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT21INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA21 __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA21CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA21SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA21INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI21 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CFIFOCI:5;
  };
  struct {
    unsigned w:32;
  };
} __C1FIFOCI21bits_t;
extern volatile __C1FIFOCI21bits_t C1FIFOCI21bits __asm__ ("C1FIFOCI21") __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI21CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI21SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI21INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON22 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TXPRI:2;
    unsigned RTREN:1;
    unsigned TXREQ:1;
    unsigned TXERR:1;
    unsigned TXLARB:1;
    unsigned TXABAT:1;
    unsigned TXEN:1;
    unsigned :4;
    unsigned DONLY:1;
    unsigned UINC:1;
    unsigned FRESET:1;
    unsigned :1;
    unsigned FSIZE:5;
  };
  struct {
    unsigned w:32;
  };
} __C1FIFOCON22bits_t;
extern volatile __C1FIFOCON22bits_t C1FIFOCON22bits __asm__ ("C1FIFOCON22") __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON22CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON22SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON22INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT22 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RXNEMPTYIF:1;
    unsigned RXHALFIF:1;
    unsigned RXFULLIF:1;
    unsigned RXOVFLIF:1;
    unsigned :4;
    unsigned TXEMPTYIF:1;
    unsigned TXHALFIF:1;
    unsigned TXNFULLIF:1;
    unsigned :5;
    unsigned RXNEMPTYIE:1;
    unsigned RXHALFIE:1;
    unsigned RXFULLIE:1;
    unsigned RXOVFLIE:1;
    unsigned :4;
    unsigned TXEMPTYIE:1;
    unsigned TXHALFIE:1;
    unsigned TXNFULLIE:1;
  };
  struct {
    unsigned w:32;
  };
} __C1FIFOINT22bits_t;
extern volatile __C1FIFOINT22bits_t C1FIFOINT22bits __asm__ ("C1FIFOINT22") __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT22CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT22SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT22INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA22 __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA22CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA22SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA22INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI22 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CFIFOCI:5;
  };
  struct {
    unsigned w:32;
  };
} __C1FIFOCI22bits_t;
extern volatile __C1FIFOCI22bits_t C1FIFOCI22bits __asm__ ("C1FIFOCI22") __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI22CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI22SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI22INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON23 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TXPRI:2;
    unsigned RTREN:1;
    unsigned TXREQ:1;
    unsigned TXERR:1;
    unsigned TXLARB:1;
    unsigned TXABAT:1;
    unsigned TXEN:1;
    unsigned :4;
    unsigned DONLY:1;
    unsigned UINC:1;
    unsigned FRESET:1;
    unsigned :1;
    unsigned FSIZE:5;
  };
  struct {
    unsigned w:32;
  };
} __C1FIFOCON23bits_t;
extern volatile __C1FIFOCON23bits_t C1FIFOCON23bits __asm__ ("C1FIFOCON23") __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON23CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON23SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON23INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT23 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RXNEMPTYIF:1;
    unsigned RXHALFIF:1;
    unsigned RXFULLIF:1;
    unsigned RXOVFLIF:1;
    unsigned :4;
    unsigned TXEMPTYIF:1;
    unsigned TXHALFIF:1;
    unsigned TXNFULLIF:1;
    unsigned :5;
    unsigned RXNEMPTYIE:1;
    unsigned RXHALFIE:1;
    unsigned RXFULLIE:1;
    unsigned RXOVFLIE:1;
    unsigned :4;
    unsigned TXEMPTYIE:1;
    unsigned TXHALFIE:1;
    unsigned TXNFULLIE:1;
  };
  struct {
    unsigned w:32;
  };
} __C1FIFOINT23bits_t;
extern volatile __C1FIFOINT23bits_t C1FIFOINT23bits __asm__ ("C1FIFOINT23") __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT23CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT23SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT23INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA23 __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA23CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA23SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA23INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI23 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CFIFOCI:5;
  };
  struct {
    unsigned w:32;
  };
} __C1FIFOCI23bits_t;
extern volatile __C1FIFOCI23bits_t C1FIFOCI23bits __asm__ ("C1FIFOCI23") __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI23CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI23SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI23INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON24 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TXPRI:2;
    unsigned RTREN:1;
    unsigned TXREQ:1;
    unsigned TXERR:1;
    unsigned TXLARB:1;
    unsigned TXABAT:1;
    unsigned TXEN:1;
    unsigned :4;
    unsigned DONLY:1;
    unsigned UINC:1;
    unsigned FRESET:1;
    unsigned :1;
    unsigned FSIZE:5;
  };
  struct {
    unsigned w:32;
  };
} __C1FIFOCON24bits_t;
extern volatile __C1FIFOCON24bits_t C1FIFOCON24bits __asm__ ("C1FIFOCON24") __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON24CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON24SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON24INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT24 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RXNEMPTYIF:1;
    unsigned RXHALFIF:1;
    unsigned RXFULLIF:1;
    unsigned RXOVFLIF:1;
    unsigned :4;
    unsigned TXEMPTYIF:1;
    unsigned TXHALFIF:1;
    unsigned TXNFULLIF:1;
    unsigned :5;
    unsigned RXNEMPTYIE:1;
    unsigned RXHALFIE:1;
    unsigned RXFULLIE:1;
    unsigned RXOVFLIE:1;
    unsigned :4;
    unsigned TXEMPTYIE:1;
    unsigned TXHALFIE:1;
    unsigned TXNFULLIE:1;
  };
  struct {
    unsigned w:32;
  };
} __C1FIFOINT24bits_t;
extern volatile __C1FIFOINT24bits_t C1FIFOINT24bits __asm__ ("C1FIFOINT24") __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT24CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT24SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT24INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA24 __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA24CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA24SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA24INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI24 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CFIFOCI:5;
  };
  struct {
    unsigned w:32;
  };
} __C1FIFOCI24bits_t;
extern volatile __C1FIFOCI24bits_t C1FIFOCI24bits __asm__ ("C1FIFOCI24") __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI24CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI24SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI24INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON25 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TXPRI:2;
    unsigned RTREN:1;
    unsigned TXREQ:1;
    unsigned TXERR:1;
    unsigned TXLARB:1;
    unsigned TXABAT:1;
    unsigned TXEN:1;
    unsigned :4;
    unsigned DONLY:1;
    unsigned UINC:1;
    unsigned FRESET:1;
    unsigned :1;
    unsigned FSIZE:5;
  };
  struct {
    unsigned w:32;
  };
} __C1FIFOCON25bits_t;
extern volatile __C1FIFOCON25bits_t C1FIFOCON25bits __asm__ ("C1FIFOCON25") __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON25CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON25SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON25INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT25 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RXNEMPTYIF:1;
    unsigned RXHALFIF:1;
    unsigned RXFULLIF:1;
    unsigned RXOVFLIF:1;
    unsigned :4;
    unsigned TXEMPTYIF:1;
    unsigned TXHALFIF:1;
    unsigned TXNFULLIF:1;
    unsigned :5;
    unsigned RXNEMPTYIE:1;
    unsigned RXHALFIE:1;
    unsigned RXFULLIE:1;
    unsigned RXOVFLIE:1;
    unsigned :4;
    unsigned TXEMPTYIE:1;
    unsigned TXHALFIE:1;
    unsigned TXNFULLIE:1;
  };
  struct {
    unsigned w:32;
  };
} __C1FIFOINT25bits_t;
extern volatile __C1FIFOINT25bits_t C1FIFOINT25bits __asm__ ("C1FIFOINT25") __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT25CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT25SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT25INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA25 __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA25CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA25SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA25INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI25 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CFIFOCI:5;
  };
  struct {
    unsigned w:32;
  };
} __C1FIFOCI25bits_t;
extern volatile __C1FIFOCI25bits_t C1FIFOCI25bits __asm__ ("C1FIFOCI25") __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI25CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI25SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI25INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON26 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TXPRI:2;
    unsigned RTREN:1;
    unsigned TXREQ:1;
    unsigned TXERR:1;
    unsigned TXLARB:1;
    unsigned TXABAT:1;
    unsigned TXEN:1;
    unsigned :4;
    unsigned DONLY:1;
    unsigned UINC:1;
    unsigned FRESET:1;
    unsigned :1;
    unsigned FSIZE:5;
  };
  struct {
    unsigned w:32;
  };
} __C1FIFOCON26bits_t;
extern volatile __C1FIFOCON26bits_t C1FIFOCON26bits __asm__ ("C1FIFOCON26") __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON26CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON26SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON26INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT26 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RXNEMPTYIF:1;
    unsigned RXHALFIF:1;
    unsigned RXFULLIF:1;
    unsigned RXOVFLIF:1;
    unsigned :4;
    unsigned TXEMPTYIF:1;
    unsigned TXHALFIF:1;
    unsigned TXNFULLIF:1;
    unsigned :5;
    unsigned RXNEMPTYIE:1;
    unsigned RXHALFIE:1;
    unsigned RXFULLIE:1;
    unsigned RXOVFLIE:1;
    unsigned :4;
    unsigned TXEMPTYIE:1;
    unsigned TXHALFIE:1;
    unsigned TXNFULLIE:1;
  };
  struct {
    unsigned w:32;
  };
} __C1FIFOINT26bits_t;
extern volatile __C1FIFOINT26bits_t C1FIFOINT26bits __asm__ ("C1FIFOINT26") __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT26CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT26SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT26INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA26 __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA26CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA26SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA26INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI26 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CFIFOCI:5;
  };
  struct {
    unsigned w:32;
  };
} __C1FIFOCI26bits_t;
extern volatile __C1FIFOCI26bits_t C1FIFOCI26bits __asm__ ("C1FIFOCI26") __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI26CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI26SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI26INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON27 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TXPRI:2;
    unsigned RTREN:1;
    unsigned TXREQ:1;
    unsigned TXERR:1;
    unsigned TXLARB:1;
    unsigned TXABAT:1;
    unsigned TXEN:1;
    unsigned :4;
    unsigned DONLY:1;
    unsigned UINC:1;
    unsigned FRESET:1;
    unsigned :1;
    unsigned FSIZE:5;
  };
  struct {
    unsigned w:32;
  };
} __C1FIFOCON27bits_t;
extern volatile __C1FIFOCON27bits_t C1FIFOCON27bits __asm__ ("C1FIFOCON27") __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON27CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON27SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON27INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT27 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RXNEMPTYIF:1;
    unsigned RXHALFIF:1;
    unsigned RXFULLIF:1;
    unsigned RXOVFLIF:1;
    unsigned :4;
    unsigned TXEMPTYIF:1;
    unsigned TXHALFIF:1;
    unsigned TXNFULLIF:1;
    unsigned :5;
    unsigned RXNEMPTYIE:1;
    unsigned RXHALFIE:1;
    unsigned RXFULLIE:1;
    unsigned RXOVFLIE:1;
    unsigned :4;
    unsigned TXEMPTYIE:1;
    unsigned TXHALFIE:1;
    unsigned TXNFULLIE:1;
  };
  struct {
    unsigned w:32;
  };
} __C1FIFOINT27bits_t;
extern volatile __C1FIFOINT27bits_t C1FIFOINT27bits __asm__ ("C1FIFOINT27") __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT27CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT27SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT27INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA27 __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA27CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA27SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA27INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI27 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CFIFOCI:5;
  };
  struct {
    unsigned w:32;
  };
} __C1FIFOCI27bits_t;
extern volatile __C1FIFOCI27bits_t C1FIFOCI27bits __asm__ ("C1FIFOCI27") __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI27CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI27SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI27INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON28 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TXPRI:2;
    unsigned RTREN:1;
    unsigned TXREQ:1;
    unsigned TXERR:1;
    unsigned TXLARB:1;
    unsigned TXABAT:1;
    unsigned TXEN:1;
    unsigned :4;
    unsigned DONLY:1;
    unsigned UINC:1;
    unsigned FRESET:1;
    unsigned :1;
    unsigned FSIZE:5;
  };
  struct {
    unsigned w:32;
  };
} __C1FIFOCON28bits_t;
extern volatile __C1FIFOCON28bits_t C1FIFOCON28bits __asm__ ("C1FIFOCON28") __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON28CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON28SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON28INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT28 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RXNEMPTYIF:1;
    unsigned RXHALFIF:1;
    unsigned RXFULLIF:1;
    unsigned RXOVFLIF:1;
    unsigned :4;
    unsigned TXEMPTYIF:1;
    unsigned TXHALFIF:1;
    unsigned TXNFULLIF:1;
    unsigned :5;
    unsigned RXNEMPTYIE:1;
    unsigned RXHALFIE:1;
    unsigned RXFULLIE:1;
    unsigned RXOVFLIE:1;
    unsigned :4;
    unsigned TXEMPTYIE:1;
    unsigned TXHALFIE:1;
    unsigned TXNFULLIE:1;
  };
  struct {
    unsigned w:32;
  };
} __C1FIFOINT28bits_t;
extern volatile __C1FIFOINT28bits_t C1FIFOINT28bits __asm__ ("C1FIFOINT28") __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT28CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT28SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT28INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA28 __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA28CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA28SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA28INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI28 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CFIFOCI:5;
  };
  struct {
    unsigned w:32;
  };
} __C1FIFOCI28bits_t;
extern volatile __C1FIFOCI28bits_t C1FIFOCI28bits __asm__ ("C1FIFOCI28") __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI28CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI28SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI28INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON29 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TXPRI:2;
    unsigned RTREN:1;
    unsigned TXREQ:1;
    unsigned TXERR:1;
    unsigned TXLARB:1;
    unsigned TXABAT:1;
    unsigned TXEN:1;
    unsigned :4;
    unsigned DONLY:1;
    unsigned UINC:1;
    unsigned FRESET:1;
    unsigned :1;
    unsigned FSIZE:5;
  };
  struct {
    unsigned w:32;
  };
} __C1FIFOCON29bits_t;
extern volatile __C1FIFOCON29bits_t C1FIFOCON29bits __asm__ ("C1FIFOCON29") __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON29CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON29SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON29INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT29 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RXNEMPTYIF:1;
    unsigned RXHALFIF:1;
    unsigned RXFULLIF:1;
    unsigned RXOVFLIF:1;
    unsigned :4;
    unsigned TXEMPTYIF:1;
    unsigned TXHALFIF:1;
    unsigned TXNFULLIF:1;
    unsigned :5;
    unsigned RXNEMPTYIE:1;
    unsigned RXHALFIE:1;
    unsigned RXFULLIE:1;
    unsigned RXOVFLIE:1;
    unsigned :4;
    unsigned TXEMPTYIE:1;
    unsigned TXHALFIE:1;
    unsigned TXNFULLIE:1;
  };
  struct {
    unsigned w:32;
  };
} __C1FIFOINT29bits_t;
extern volatile __C1FIFOINT29bits_t C1FIFOINT29bits __asm__ ("C1FIFOINT29") __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT29CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT29SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT29INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA29 __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA29CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA29SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA29INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI29 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CFIFOCI:5;
  };
  struct {
    unsigned w:32;
  };
} __C1FIFOCI29bits_t;
extern volatile __C1FIFOCI29bits_t C1FIFOCI29bits __asm__ ("C1FIFOCI29") __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI29CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI29SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI29INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON30 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TXPRI:2;
    unsigned RTREN:1;
    unsigned TXREQ:1;
    unsigned TXERR:1;
    unsigned TXLARB:1;
    unsigned TXABAT:1;
    unsigned TXEN:1;
    unsigned :4;
    unsigned DONLY:1;
    unsigned UINC:1;
    unsigned FRESET:1;
    unsigned :1;
    unsigned FSIZE:5;
  };
  struct {
    unsigned w:32;
  };
} __C1FIFOCON30bits_t;
extern volatile __C1FIFOCON30bits_t C1FIFOCON30bits __asm__ ("C1FIFOCON30") __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON30CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON30SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON30INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT30 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RXNEMPTYIF:1;
    unsigned RXHALFIF:1;
    unsigned RXFULLIF:1;
    unsigned RXOVFLIF:1;
    unsigned :4;
    unsigned TXEMPTYIF:1;
    unsigned TXHALFIF:1;
    unsigned TXNFULLIF:1;
    unsigned :5;
    unsigned RXNEMPTYIE:1;
    unsigned RXHALFIE:1;
    unsigned RXFULLIE:1;
    unsigned RXOVFLIE:1;
    unsigned :4;
    unsigned TXEMPTYIE:1;
    unsigned TXHALFIE:1;
    unsigned TXNFULLIE:1;
  };
  struct {
    unsigned w:32;
  };
} __C1FIFOINT30bits_t;
extern volatile __C1FIFOINT30bits_t C1FIFOINT30bits __asm__ ("C1FIFOINT30") __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT30CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT30SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT30INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA30 __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA30CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA30SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA30INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI30 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CFIFOCI:5;
  };
  struct {
    unsigned w:32;
  };
} __C1FIFOCI30bits_t;
extern volatile __C1FIFOCI30bits_t C1FIFOCI30bits __asm__ ("C1FIFOCI30") __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI30CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI30SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI30INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON31 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TXPRI:2;
    unsigned RTREN:1;
    unsigned TXREQ:1;
    unsigned TXERR:1;
    unsigned TXLARB:1;
    unsigned TXABAT:1;
    unsigned TXEN:1;
    unsigned :4;
    unsigned DONLY:1;
    unsigned UINC:1;
    unsigned FRESET:1;
    unsigned :1;
    unsigned FSIZE:5;
  };
  struct {
    unsigned w:32;
  };
} __C1FIFOCON31bits_t;
extern volatile __C1FIFOCON31bits_t C1FIFOCON31bits __asm__ ("C1FIFOCON31") __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON31CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON31SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCON31INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT31 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RXNEMPTYIF:1;
    unsigned RXHALFIF:1;
    unsigned RXFULLIF:1;
    unsigned RXOVFLIF:1;
    unsigned :4;
    unsigned TXEMPTYIF:1;
    unsigned TXHALFIF:1;
    unsigned TXNFULLIF:1;
    unsigned :5;
    unsigned RXNEMPTYIE:1;
    unsigned RXHALFIE:1;
    unsigned RXFULLIE:1;
    unsigned RXOVFLIE:1;
    unsigned :4;
    unsigned TXEMPTYIE:1;
    unsigned TXHALFIE:1;
    unsigned TXNFULLIE:1;
  };
  struct {
    unsigned w:32;
  };
} __C1FIFOINT31bits_t;
extern volatile __C1FIFOINT31bits_t C1FIFOINT31bits __asm__ ("C1FIFOINT31") __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT31CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT31SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOINT31INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA31 __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA31CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA31SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOUA31INV __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI31 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CFIFOCI:5;
  };
  struct {
    unsigned w:32;
  };
} __C1FIFOCI31bits_t;
extern volatile __C1FIFOCI31bits_t C1FIFOCI31bits __asm__ ("C1FIFOCI31") __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI31CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI31SET __attribute__((section("sfrs")));
extern volatile unsigned int        C1FIFOCI31INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2CON __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned DNCNT:5;
    unsigned :6;
    unsigned CANBUSY:1;
    unsigned :1;
    unsigned SIDL:1;
    unsigned :1;
    unsigned ON:1;
    unsigned :4;
    unsigned CANCAP:1;
    unsigned OPMOD:3;
    unsigned REQOP:3;
    unsigned ABAT:1;
  };
  struct {
    unsigned w:32;
  };
} __C2CONbits_t;
extern volatile __C2CONbits_t C2CONbits __asm__ ("C2CON") __attribute__((section("sfrs")));
extern volatile unsigned int        C2CONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2CONSET __attribute__((section("sfrs")));
extern volatile unsigned int        C2CONINV __attribute__((section("sfrs")));
extern volatile unsigned int        C2CFG __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned BRP:6;
    unsigned SJW:2;
    unsigned PRSEG:3;
    unsigned SEG1PH:3;
    unsigned SAM:1;
    unsigned SEG2PHTS:1;
    unsigned SEG2PH:3;
    unsigned :3;
    unsigned WAKFIL:1;
  };
  struct {
    unsigned w:32;
  };
} __C2CFGbits_t;
extern volatile __C2CFGbits_t C2CFGbits __asm__ ("C2CFG") __attribute__((section("sfrs")));
extern volatile unsigned int        C2CFGCLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2CFGSET __attribute__((section("sfrs")));
extern volatile unsigned int        C2CFGINV __attribute__((section("sfrs")));
extern volatile unsigned int        C2INT __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TBIF:1;
    unsigned RBIF:1;
    unsigned CTMRIF:1;
    unsigned MODIF:1;
    unsigned :7;
    unsigned RBOVIF:1;
    unsigned SERRIF:1;
    unsigned CERRIF:1;
    unsigned WAKIF:1;
    unsigned IVRIF:1;
    unsigned TBIE:1;
    unsigned RBIE:1;
    unsigned CTMRIE:1;
    unsigned MODIE:1;
    unsigned :7;
    unsigned RBOVIE:1;
    unsigned SERRIE:1;
    unsigned CERRIE:1;
    unsigned WAKIE:1;
    unsigned IVRIE:1;
  };
  struct {
    unsigned w:32;
  };
} __C2INTbits_t;
extern volatile __C2INTbits_t C2INTbits __asm__ ("C2INT") __attribute__((section("sfrs")));
extern volatile unsigned int        C2INTCLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2INTSET __attribute__((section("sfrs")));
extern volatile unsigned int        C2INTINV __attribute__((section("sfrs")));
extern volatile unsigned int        C2VEC __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned ICODE:7;
    unsigned :1;
    unsigned FILHIT:5;
  };
  struct {
    unsigned w:32;
  };
} __C2VECbits_t;
extern volatile __C2VECbits_t C2VECbits __asm__ ("C2VEC") __attribute__((section("sfrs")));
extern volatile unsigned int        C2VECCLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2VECSET __attribute__((section("sfrs")));
extern volatile unsigned int        C2VECINV __attribute__((section("sfrs")));
extern volatile unsigned int        C2TREC __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RERRCNT:8;
    unsigned TERRCNT:8;
    unsigned EWARN:1;
    unsigned RXWARN:1;
    unsigned TXWARN:1;
    unsigned RXBP:1;
    unsigned TXBP:1;
    unsigned TXBO:1;
  };
  struct {
    unsigned w:32;
  };
} __C2TRECbits_t;
extern volatile __C2TRECbits_t C2TRECbits __asm__ ("C2TREC") __attribute__((section("sfrs")));
extern volatile unsigned int        C2TRECCLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2TRECSET __attribute__((section("sfrs")));
extern volatile unsigned int        C2TRECINV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FSTAT __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned FIFOIP:32;
  };
  struct {
    unsigned FIFOIP0:1;
    unsigned FIFOIP1:1;
    unsigned FIFOIP2:1;
    unsigned FIFOIP3:1;
    unsigned FIFOIP4:1;
    unsigned FIFOIP5:1;
    unsigned FIFOIP6:1;
    unsigned FIFOIP7:1;
    unsigned FIFOIP8:1;
    unsigned FIFOIP9:1;
    unsigned FIFOIP10:1;
    unsigned FIFOIP11:1;
    unsigned FIFOIP12:1;
    unsigned FIFOIP13:1;
    unsigned FIFOIP14:1;
    unsigned FIFOIP15:1;
    unsigned FIFOIP16:1;
    unsigned FIFOIP17:1;
    unsigned FIFOIP18:1;
    unsigned FIFOIP19:1;
    unsigned FIFOIP20:1;
    unsigned FIFOIP21:1;
    unsigned FIFOIP22:1;
    unsigned FIFOIP23:1;
    unsigned FIFOIP24:1;
    unsigned FIFOIP25:1;
    unsigned FIFOIP26:1;
    unsigned FIFOIP27:1;
    unsigned FIFOIP28:1;
    unsigned FIFOIP29:1;
    unsigned FIFOIP30:1;
    unsigned FIFOIP31:1;
  };
  struct {
    unsigned w:32;
  };
} __C2FSTATbits_t;
extern volatile __C2FSTATbits_t C2FSTATbits __asm__ ("C2FSTAT") __attribute__((section("sfrs")));
extern volatile unsigned int        C2FSTATCLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FSTATSET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FSTATINV __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXOVF __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RXOVF:32;
  };
  struct {
    unsigned RXOVF0:1;
    unsigned RXOVF1:1;
    unsigned RXOVF2:1;
    unsigned RXOVF3:1;
    unsigned RXOVF4:1;
    unsigned RXOVF5:1;
    unsigned RXOVF6:1;
    unsigned RXOVF7:1;
    unsigned RXOVF8:1;
    unsigned RXOVF9:1;
    unsigned RXOVF10:1;
    unsigned RXOVF11:1;
    unsigned RXOVF12:1;
    unsigned RXOVF13:1;
    unsigned RXOVF14:1;
    unsigned RXOVF15:1;
    unsigned RXOVF16:1;
    unsigned RXOVF17:1;
    unsigned RXOVF18:1;
    unsigned RXOVF19:1;
    unsigned RXOVF20:1;
    unsigned RXOVF21:1;
    unsigned RXOVF22:1;
    unsigned RXOVF23:1;
    unsigned RXOVF24:1;
    unsigned RXOVF25:1;
    unsigned RXOVF26:1;
    unsigned RXOVF27:1;
    unsigned RXOVF28:1;
    unsigned RXOVF29:1;
    unsigned RXOVF30:1;
    unsigned RXOVF31:1;
  };
  struct {
    unsigned w:32;
  };
} __C2RXOVFbits_t;
extern volatile __C2RXOVFbits_t C2RXOVFbits __asm__ ("C2RXOVF") __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXOVFCLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXOVFSET __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXOVFINV __attribute__((section("sfrs")));
extern volatile unsigned int        C2TMR __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CANTSPRE:16;
    unsigned CANTS:16;
  };
  struct {
    unsigned w:32;
  };
} __C2TMRbits_t;
extern volatile __C2TMRbits_t C2TMRbits __asm__ ("C2TMR") __attribute__((section("sfrs")));
extern volatile unsigned int        C2TMRCLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2TMRSET __attribute__((section("sfrs")));
extern volatile unsigned int        C2TMRINV __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXM0 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned EID:18;
    unsigned :1;
    unsigned MIDE:1;
    unsigned :1;
    unsigned SID:11;
  };
  struct {
    unsigned w:32;
  };
} __C2RXM0bits_t;
extern volatile __C2RXM0bits_t C2RXM0bits __asm__ ("C2RXM0") __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXM0CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXM0SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXM0INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXM1 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned EID:18;
    unsigned :1;
    unsigned MIDE:1;
    unsigned :1;
    unsigned SID:11;
  };
  struct {
    unsigned w:32;
  };
} __C2RXM1bits_t;
extern volatile __C2RXM1bits_t C2RXM1bits __asm__ ("C2RXM1") __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXM1CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXM1SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXM1INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXM2 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned EID:18;
    unsigned :1;
    unsigned MIDE:1;
    unsigned :1;
    unsigned SID:11;
  };
  struct {
    unsigned w:32;
  };
} __C2RXM2bits_t;
extern volatile __C2RXM2bits_t C2RXM2bits __asm__ ("C2RXM2") __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXM2CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXM2SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXM2INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXM3 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned EID:18;
    unsigned :1;
    unsigned MIDE:1;
    unsigned :1;
    unsigned SID:11;
  };
  struct {
    unsigned w:32;
  };
} __C2RXM3bits_t;
extern volatile __C2RXM3bits_t C2RXM3bits __asm__ ("C2RXM3") __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXM3CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXM3SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXM3INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FLTCON0 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned FSEL0:5;
    unsigned MSEL0:2;
    unsigned FLTEN0:1;
    unsigned FSEL1:5;
    unsigned MSEL1:2;
    unsigned FLTEN1:1;
    unsigned FSEL2:5;
    unsigned MSEL2:2;
    unsigned FLTEN2:1;
    unsigned FSEL3:5;
    unsigned MSEL3:2;
    unsigned FLTEN3:1;
  };
  struct {
    unsigned w:32;
  };
} __C2FLTCON0bits_t;
extern volatile __C2FLTCON0bits_t C2FLTCON0bits __asm__ ("C2FLTCON0") __attribute__((section("sfrs")));
extern volatile unsigned int        C2FLTCON0CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FLTCON0SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FLTCON0INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FLTCON1 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned FSEL4:5;
    unsigned MSEL4:2;
    unsigned FLTEN4:1;
    unsigned FSEL5:5;
    unsigned MSEL5:2;
    unsigned FLTEN5:1;
    unsigned FSEL6:5;
    unsigned MSEL6:2;
    unsigned FLTEN6:1;
    unsigned FSEL7:5;
    unsigned MSEL7:2;
    unsigned FLTEN7:1;
  };
  struct {
    unsigned w:32;
  };
} __C2FLTCON1bits_t;
extern volatile __C2FLTCON1bits_t C2FLTCON1bits __asm__ ("C2FLTCON1") __attribute__((section("sfrs")));
extern volatile unsigned int        C2FLTCON1CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FLTCON1SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FLTCON1INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FLTCON2 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned FSEL8:5;
    unsigned MSEL8:2;
    unsigned FLTEN8:1;
    unsigned FSEL9:5;
    unsigned MSEL9:2;
    unsigned FLTEN9:1;
    unsigned FSEL10:5;
    unsigned MSEL10:2;
    unsigned FLTEN10:1;
    unsigned FSEL11:5;
    unsigned MSEL11:2;
    unsigned FLTEN11:1;
  };
  struct {
    unsigned w:32;
  };
} __C2FLTCON2bits_t;
extern volatile __C2FLTCON2bits_t C2FLTCON2bits __asm__ ("C2FLTCON2") __attribute__((section("sfrs")));
extern volatile unsigned int        C2FLTCON2CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FLTCON2SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FLTCON2INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FLTCON3 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned FSEL12:5;
    unsigned MSEL12:2;
    unsigned FLTEN12:1;
    unsigned FSEL13:5;
    unsigned MSEL13:2;
    unsigned FLTEN13:1;
    unsigned FSEL14:5;
    unsigned MSEL14:2;
    unsigned FLTEN14:1;
    unsigned FSEL15:5;
    unsigned MSEL15:2;
    unsigned FLTEN15:1;
  };
  struct {
    unsigned w:32;
  };
} __C2FLTCON3bits_t;
extern volatile __C2FLTCON3bits_t C2FLTCON3bits __asm__ ("C2FLTCON3") __attribute__((section("sfrs")));
extern volatile unsigned int        C2FLTCON3CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FLTCON3SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FLTCON3INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FLTCON4 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned FSEL16:5;
    unsigned MSEL16:2;
    unsigned FLTEN16:1;
    unsigned FSEL17:5;
    unsigned MSEL17:2;
    unsigned FLTEN17:1;
    unsigned FSEL18:5;
    unsigned MSEL18:2;
    unsigned FLTEN18:1;
    unsigned FSEL19:5;
    unsigned MSEL19:2;
    unsigned FLTEN19:1;
  };
  struct {
    unsigned w:32;
  };
} __C2FLTCON4bits_t;
extern volatile __C2FLTCON4bits_t C2FLTCON4bits __asm__ ("C2FLTCON4") __attribute__((section("sfrs")));
extern volatile unsigned int        C2FLTCON4CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FLTCON4SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FLTCON4INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FLTCON5 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned FSEL20:5;
    unsigned MSEL20:2;
    unsigned FLTEN20:1;
    unsigned FSEL21:5;
    unsigned MSEL21:2;
    unsigned FLTEN21:1;
    unsigned FSEL22:5;
    unsigned MSEL22:2;
    unsigned FLTEN22:1;
    unsigned FSEL23:5;
    unsigned MSEL23:2;
    unsigned FLTEN23:1;
  };
  struct {
    unsigned w:32;
  };
} __C2FLTCON5bits_t;
extern volatile __C2FLTCON5bits_t C2FLTCON5bits __asm__ ("C2FLTCON5") __attribute__((section("sfrs")));
extern volatile unsigned int        C2FLTCON5CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FLTCON5SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FLTCON5INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FLTCON6 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned FSEL24:5;
    unsigned MSEL24:2;
    unsigned FLTEN24:1;
    unsigned FSEL25:5;
    unsigned MSEL25:2;
    unsigned FLTEN25:1;
    unsigned FSEL26:5;
    unsigned MSEL26:2;
    unsigned FLTEN26:1;
    unsigned FSEL27:5;
    unsigned MSEL27:2;
    unsigned FLTEN27:1;
  };
  struct {
    unsigned w:32;
  };
} __C2FLTCON6bits_t;
extern volatile __C2FLTCON6bits_t C2FLTCON6bits __asm__ ("C2FLTCON6") __attribute__((section("sfrs")));
extern volatile unsigned int        C2FLTCON6CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FLTCON6SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FLTCON6INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FLTCON7 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned FSEL28:5;
    unsigned MSEL28:2;
    unsigned FLTEN28:1;
    unsigned FSEL29:5;
    unsigned MSEL29:2;
    unsigned FLTEN29:1;
    unsigned FSEL30:5;
    unsigned MSEL30:2;
    unsigned FLTEN30:1;
    unsigned FSEL31:5;
    unsigned MSEL31:2;
    unsigned FLTEN31:1;
  };
  struct {
    unsigned w:32;
  };
} __C2FLTCON7bits_t;
extern volatile __C2FLTCON7bits_t C2FLTCON7bits __asm__ ("C2FLTCON7") __attribute__((section("sfrs")));
extern volatile unsigned int        C2FLTCON7CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FLTCON7SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FLTCON7INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF0 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned EID:18;
    unsigned :1;
    unsigned EXID:1;
    unsigned :1;
    unsigned SID:11;
  };
  struct {
    unsigned w:32;
  };
} __C2RXF0bits_t;
extern volatile __C2RXF0bits_t C2RXF0bits __asm__ ("C2RXF0") __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF0CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF0SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF0INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF1 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned EID:18;
    unsigned :1;
    unsigned EXID:1;
    unsigned :1;
    unsigned SID:11;
  };
  struct {
    unsigned w:32;
  };
} __C2RXF1bits_t;
extern volatile __C2RXF1bits_t C2RXF1bits __asm__ ("C2RXF1") __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF1CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF1SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF1INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF2 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned EID:18;
    unsigned :1;
    unsigned EXID:1;
    unsigned :1;
    unsigned SID:11;
  };
  struct {
    unsigned w:32;
  };
} __C2RXF2bits_t;
extern volatile __C2RXF2bits_t C2RXF2bits __asm__ ("C2RXF2") __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF2CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF2SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF2INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF3 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned EID:18;
    unsigned :1;
    unsigned EXID:1;
    unsigned :1;
    unsigned SID:11;
  };
  struct {
    unsigned w:32;
  };
} __C2RXF3bits_t;
extern volatile __C2RXF3bits_t C2RXF3bits __asm__ ("C2RXF3") __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF3CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF3SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF3INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF4 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned EID:18;
    unsigned :1;
    unsigned EXID:1;
    unsigned :1;
    unsigned SID:11;
  };
  struct {
    unsigned w:32;
  };
} __C2RXF4bits_t;
extern volatile __C2RXF4bits_t C2RXF4bits __asm__ ("C2RXF4") __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF4CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF4SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF4INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF5 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned EID:18;
    unsigned :1;
    unsigned EXID:1;
    unsigned :1;
    unsigned SID:11;
  };
  struct {
    unsigned w:32;
  };
} __C2RXF5bits_t;
extern volatile __C2RXF5bits_t C2RXF5bits __asm__ ("C2RXF5") __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF5CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF5SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF5INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF6 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned EID:18;
    unsigned :1;
    unsigned EXID:1;
    unsigned :1;
    unsigned SID:11;
  };
  struct {
    unsigned w:32;
  };
} __C2RXF6bits_t;
extern volatile __C2RXF6bits_t C2RXF6bits __asm__ ("C2RXF6") __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF6CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF6SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF6INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF7 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned EID:18;
    unsigned :1;
    unsigned EXID:1;
    unsigned :1;
    unsigned SID:11;
  };
  struct {
    unsigned w:32;
  };
} __C2RXF7bits_t;
extern volatile __C2RXF7bits_t C2RXF7bits __asm__ ("C2RXF7") __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF7CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF7SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF7INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF8 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned EID:18;
    unsigned :1;
    unsigned EXID:1;
    unsigned :1;
    unsigned SID:11;
  };
  struct {
    unsigned w:32;
  };
} __C2RXF8bits_t;
extern volatile __C2RXF8bits_t C2RXF8bits __asm__ ("C2RXF8") __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF8CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF8SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF8INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF9 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned EID:18;
    unsigned :1;
    unsigned EXID:1;
    unsigned :1;
    unsigned SID:11;
  };
  struct {
    unsigned w:32;
  };
} __C2RXF9bits_t;
extern volatile __C2RXF9bits_t C2RXF9bits __asm__ ("C2RXF9") __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF9CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF9SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF9INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF10 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned EID:18;
    unsigned :1;
    unsigned EXID:1;
    unsigned :1;
    unsigned SID:11;
  };
  struct {
    unsigned w:32;
  };
} __C2RXF10bits_t;
extern volatile __C2RXF10bits_t C2RXF10bits __asm__ ("C2RXF10") __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF10CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF10SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF10INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF11 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned EID:18;
    unsigned :1;
    unsigned EXID:1;
    unsigned :1;
    unsigned SID:11;
  };
  struct {
    unsigned w:32;
  };
} __C2RXF11bits_t;
extern volatile __C2RXF11bits_t C2RXF11bits __asm__ ("C2RXF11") __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF11CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF11SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF11INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF12 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned EID:18;
    unsigned :1;
    unsigned EXID:1;
    unsigned :1;
    unsigned SID:11;
  };
  struct {
    unsigned w:32;
  };
} __C2RXF12bits_t;
extern volatile __C2RXF12bits_t C2RXF12bits __asm__ ("C2RXF12") __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF12CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF12SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF12INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF13 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned EID:18;
    unsigned :1;
    unsigned EXID:1;
    unsigned :1;
    unsigned SID:11;
  };
  struct {
    unsigned w:32;
  };
} __C2RXF13bits_t;
extern volatile __C2RXF13bits_t C2RXF13bits __asm__ ("C2RXF13") __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF13CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF13SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF13INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF14 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned EID:18;
    unsigned :1;
    unsigned EXID:1;
    unsigned :1;
    unsigned SID:11;
  };
  struct {
    unsigned w:32;
  };
} __C2RXF14bits_t;
extern volatile __C2RXF14bits_t C2RXF14bits __asm__ ("C2RXF14") __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF14CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF14SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF14INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF15 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned EID:18;
    unsigned :1;
    unsigned EXID:1;
    unsigned :1;
    unsigned SID:11;
  };
  struct {
    unsigned w:32;
  };
} __C2RXF15bits_t;
extern volatile __C2RXF15bits_t C2RXF15bits __asm__ ("C2RXF15") __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF15CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF15SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF15INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF16 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned EID:18;
    unsigned :1;
    unsigned EXID:1;
    unsigned :1;
    unsigned SID:11;
  };
  struct {
    unsigned w:32;
  };
} __C2RXF16bits_t;
extern volatile __C2RXF16bits_t C2RXF16bits __asm__ ("C2RXF16") __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF16CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF16SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF16INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF17 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned EID:18;
    unsigned :1;
    unsigned EXID:1;
    unsigned :1;
    unsigned SID:11;
  };
  struct {
    unsigned w:32;
  };
} __C2RXF17bits_t;
extern volatile __C2RXF17bits_t C2RXF17bits __asm__ ("C2RXF17") __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF17CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF17SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF17INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF18 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned EID:18;
    unsigned :1;
    unsigned EXID:1;
    unsigned :1;
    unsigned SID:11;
  };
  struct {
    unsigned w:32;
  };
} __C2RXF18bits_t;
extern volatile __C2RXF18bits_t C2RXF18bits __asm__ ("C2RXF18") __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF18CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF18SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF18INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF19 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned EID:18;
    unsigned :1;
    unsigned EXID:1;
    unsigned :1;
    unsigned SID:11;
  };
  struct {
    unsigned w:32;
  };
} __C2RXF19bits_t;
extern volatile __C2RXF19bits_t C2RXF19bits __asm__ ("C2RXF19") __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF19CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF19SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF19INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF20 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned EID:18;
    unsigned :1;
    unsigned EXID:1;
    unsigned :1;
    unsigned SID:11;
  };
  struct {
    unsigned w:32;
  };
} __C2RXF20bits_t;
extern volatile __C2RXF20bits_t C2RXF20bits __asm__ ("C2RXF20") __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF20CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF20SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF20INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF21 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned EID:18;
    unsigned :1;
    unsigned EXID:1;
    unsigned :1;
    unsigned SID:11;
  };
  struct {
    unsigned w:32;
  };
} __C2RXF21bits_t;
extern volatile __C2RXF21bits_t C2RXF21bits __asm__ ("C2RXF21") __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF21CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF21SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF21INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF22 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned EID:18;
    unsigned :1;
    unsigned EXID:1;
    unsigned :1;
    unsigned SID:11;
  };
  struct {
    unsigned w:32;
  };
} __C2RXF22bits_t;
extern volatile __C2RXF22bits_t C2RXF22bits __asm__ ("C2RXF22") __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF22CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF22SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF22INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF23 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned EID:18;
    unsigned :1;
    unsigned EXID:1;
    unsigned :1;
    unsigned SID:11;
  };
  struct {
    unsigned w:32;
  };
} __C2RXF23bits_t;
extern volatile __C2RXF23bits_t C2RXF23bits __asm__ ("C2RXF23") __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF23CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF23SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF23INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF24 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned EID:18;
    unsigned :1;
    unsigned EXID:1;
    unsigned :1;
    unsigned SID:11;
  };
  struct {
    unsigned w:32;
  };
} __C2RXF24bits_t;
extern volatile __C2RXF24bits_t C2RXF24bits __asm__ ("C2RXF24") __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF24CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF24SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF24INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF25 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned EID:18;
    unsigned :1;
    unsigned EXID:1;
    unsigned :1;
    unsigned SID:11;
  };
  struct {
    unsigned w:32;
  };
} __C2RXF25bits_t;
extern volatile __C2RXF25bits_t C2RXF25bits __asm__ ("C2RXF25") __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF25CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF25SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF25INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF26 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned EID:18;
    unsigned :1;
    unsigned EXID:1;
    unsigned :1;
    unsigned SID:11;
  };
  struct {
    unsigned w:32;
  };
} __C2RXF26bits_t;
extern volatile __C2RXF26bits_t C2RXF26bits __asm__ ("C2RXF26") __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF26CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF26SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF26INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF27 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned EID:18;
    unsigned :1;
    unsigned EXID:1;
    unsigned :1;
    unsigned SID:11;
  };
  struct {
    unsigned w:32;
  };
} __C2RXF27bits_t;
extern volatile __C2RXF27bits_t C2RXF27bits __asm__ ("C2RXF27") __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF27CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF27SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF27INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF28 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned EID:18;
    unsigned :1;
    unsigned EXID:1;
    unsigned :1;
    unsigned SID:11;
  };
  struct {
    unsigned w:32;
  };
} __C2RXF28bits_t;
extern volatile __C2RXF28bits_t C2RXF28bits __asm__ ("C2RXF28") __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF28CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF28SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF28INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF29 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned EID:18;
    unsigned :1;
    unsigned EXID:1;
    unsigned :1;
    unsigned SID:11;
  };
  struct {
    unsigned w:32;
  };
} __C2RXF29bits_t;
extern volatile __C2RXF29bits_t C2RXF29bits __asm__ ("C2RXF29") __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF29CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF29SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF29INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF30 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned EID:18;
    unsigned :1;
    unsigned EXID:1;
    unsigned :1;
    unsigned SID:11;
  };
  struct {
    unsigned w:32;
  };
} __C2RXF30bits_t;
extern volatile __C2RXF30bits_t C2RXF30bits __asm__ ("C2RXF30") __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF30CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF30SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF30INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF31 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned EID:18;
    unsigned :1;
    unsigned EXID:1;
    unsigned :1;
    unsigned SID:11;
  };
  struct {
    unsigned w:32;
  };
} __C2RXF31bits_t;
extern volatile __C2RXF31bits_t C2RXF31bits __asm__ ("C2RXF31") __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF31CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF31SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2RXF31INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOBA __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOBACLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOBASET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOBAINV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON0 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TXPRI:2;
    unsigned RTREN:1;
    unsigned TXREQ:1;
    unsigned TXERR:1;
    unsigned TXLARB:1;
    unsigned TXABAT:1;
    unsigned TXEN:1;
    unsigned :4;
    unsigned DONLY:1;
    unsigned UINC:1;
    unsigned FRESET:1;
    unsigned :1;
    unsigned FSIZE:5;
  };
  struct {
    unsigned w:32;
  };
} __C2FIFOCON0bits_t;
extern volatile __C2FIFOCON0bits_t C2FIFOCON0bits __asm__ ("C2FIFOCON0") __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON0CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON0SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON0INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT0 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RXNEMPTYIF:1;
    unsigned RXHALFIF:1;
    unsigned RXFULLIF:1;
    unsigned RXOVFLIF:1;
    unsigned :4;
    unsigned TXEMPTYIF:1;
    unsigned TXHALFIF:1;
    unsigned TXNFULLIF:1;
    unsigned :5;
    unsigned RXNEMPTYIE:1;
    unsigned RXHALFIE:1;
    unsigned RXFULLIE:1;
    unsigned RXOVFLIE:1;
    unsigned :4;
    unsigned TXEMPTYIE:1;
    unsigned TXHALFIE:1;
    unsigned TXNFULLIE:1;
  };
  struct {
    unsigned w:32;
  };
} __C2FIFOINT0bits_t;
extern volatile __C2FIFOINT0bits_t C2FIFOINT0bits __asm__ ("C2FIFOINT0") __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT0CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT0SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT0INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA0 __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA0CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA0SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA0INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI0 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CFIFOCI:5;
  };
  struct {
    unsigned w:32;
  };
} __C2FIFOCI0bits_t;
extern volatile __C2FIFOCI0bits_t C2FIFOCI0bits __asm__ ("C2FIFOCI0") __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI0CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI0SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI0INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON1 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TXPRI:2;
    unsigned RTREN:1;
    unsigned TXREQ:1;
    unsigned TXERR:1;
    unsigned TXLARB:1;
    unsigned TXABAT:1;
    unsigned TXEN:1;
    unsigned :4;
    unsigned DONLY:1;
    unsigned UINC:1;
    unsigned FRESET:1;
    unsigned :1;
    unsigned FSIZE:5;
  };
  struct {
    unsigned w:32;
  };
} __C2FIFOCON1bits_t;
extern volatile __C2FIFOCON1bits_t C2FIFOCON1bits __asm__ ("C2FIFOCON1") __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON1CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON1SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON1INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT1 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RXNEMPTYIF:1;
    unsigned RXHALFIF:1;
    unsigned RXFULLIF:1;
    unsigned RXOVFLIF:1;
    unsigned :4;
    unsigned TXEMPTYIF:1;
    unsigned TXHALFIF:1;
    unsigned TXNFULLIF:1;
    unsigned :5;
    unsigned RXNEMPTYIE:1;
    unsigned RXHALFIE:1;
    unsigned RXFULLIE:1;
    unsigned RXOVFLIE:1;
    unsigned :4;
    unsigned TXEMPTYIE:1;
    unsigned TXHALFIE:1;
    unsigned TXNFULLIE:1;
  };
  struct {
    unsigned w:32;
  };
} __C2FIFOINT1bits_t;
extern volatile __C2FIFOINT1bits_t C2FIFOINT1bits __asm__ ("C2FIFOINT1") __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT1CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT1SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT1INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA1 __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA1CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA1SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA1INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI1 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CFIFOCI:5;
  };
  struct {
    unsigned w:32;
  };
} __C2FIFOCI1bits_t;
extern volatile __C2FIFOCI1bits_t C2FIFOCI1bits __asm__ ("C2FIFOCI1") __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI1CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI1SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI1INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON2 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TXPRI:2;
    unsigned RTREN:1;
    unsigned TXREQ:1;
    unsigned TXERR:1;
    unsigned TXLARB:1;
    unsigned TXABAT:1;
    unsigned TXEN:1;
    unsigned :4;
    unsigned DONLY:1;
    unsigned UINC:1;
    unsigned FRESET:1;
    unsigned :1;
    unsigned FSIZE:5;
  };
  struct {
    unsigned w:32;
  };
} __C2FIFOCON2bits_t;
extern volatile __C2FIFOCON2bits_t C2FIFOCON2bits __asm__ ("C2FIFOCON2") __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON2CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON2SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON2INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT2 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RXNEMPTYIF:1;
    unsigned RXHALFIF:1;
    unsigned RXFULLIF:1;
    unsigned RXOVFLIF:1;
    unsigned :4;
    unsigned TXEMPTYIF:1;
    unsigned TXHALFIF:1;
    unsigned TXNFULLIF:1;
    unsigned :5;
    unsigned RXNEMPTYIE:1;
    unsigned RXHALFIE:1;
    unsigned RXFULLIE:1;
    unsigned RXOVFLIE:1;
    unsigned :4;
    unsigned TXEMPTYIE:1;
    unsigned TXHALFIE:1;
    unsigned TXNFULLIE:1;
  };
  struct {
    unsigned w:32;
  };
} __C2FIFOINT2bits_t;
extern volatile __C2FIFOINT2bits_t C2FIFOINT2bits __asm__ ("C2FIFOINT2") __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT2CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT2SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT2INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA2 __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA2CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA2SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA2INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI2 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CFIFOCI:5;
  };
  struct {
    unsigned w:32;
  };
} __C2FIFOCI2bits_t;
extern volatile __C2FIFOCI2bits_t C2FIFOCI2bits __asm__ ("C2FIFOCI2") __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI2CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI2SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI2INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON3 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TXPRI:2;
    unsigned RTREN:1;
    unsigned TXREQ:1;
    unsigned TXERR:1;
    unsigned TXLARB:1;
    unsigned TXABAT:1;
    unsigned TXEN:1;
    unsigned :4;
    unsigned DONLY:1;
    unsigned UINC:1;
    unsigned FRESET:1;
    unsigned :1;
    unsigned FSIZE:5;
  };
  struct {
    unsigned w:32;
  };
} __C2FIFOCON3bits_t;
extern volatile __C2FIFOCON3bits_t C2FIFOCON3bits __asm__ ("C2FIFOCON3") __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON3CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON3SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON3INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT3 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RXNEMPTYIF:1;
    unsigned RXHALFIF:1;
    unsigned RXFULLIF:1;
    unsigned RXOVFLIF:1;
    unsigned :4;
    unsigned TXEMPTYIF:1;
    unsigned TXHALFIF:1;
    unsigned TXNFULLIF:1;
    unsigned :5;
    unsigned RXNEMPTYIE:1;
    unsigned RXHALFIE:1;
    unsigned RXFULLIE:1;
    unsigned RXOVFLIE:1;
    unsigned :4;
    unsigned TXEMPTYIE:1;
    unsigned TXHALFIE:1;
    unsigned TXNFULLIE:1;
  };
  struct {
    unsigned w:32;
  };
} __C2FIFOINT3bits_t;
extern volatile __C2FIFOINT3bits_t C2FIFOINT3bits __asm__ ("C2FIFOINT3") __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT3CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT3SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT3INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA3 __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA3CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA3SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA3INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI3 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CFIFOCI:5;
  };
  struct {
    unsigned w:32;
  };
} __C2FIFOCI3bits_t;
extern volatile __C2FIFOCI3bits_t C2FIFOCI3bits __asm__ ("C2FIFOCI3") __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI3CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI3SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI3INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON4 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TXPRI:2;
    unsigned RTREN:1;
    unsigned TXREQ:1;
    unsigned TXERR:1;
    unsigned TXLARB:1;
    unsigned TXABAT:1;
    unsigned TXEN:1;
    unsigned :4;
    unsigned DONLY:1;
    unsigned UINC:1;
    unsigned FRESET:1;
    unsigned :1;
    unsigned FSIZE:5;
  };
  struct {
    unsigned w:32;
  };
} __C2FIFOCON4bits_t;
extern volatile __C2FIFOCON4bits_t C2FIFOCON4bits __asm__ ("C2FIFOCON4") __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON4CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON4SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON4INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT4 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RXNEMPTYIF:1;
    unsigned RXHALFIF:1;
    unsigned RXFULLIF:1;
    unsigned RXOVFLIF:1;
    unsigned :4;
    unsigned TXEMPTYIF:1;
    unsigned TXHALFIF:1;
    unsigned TXNFULLIF:1;
    unsigned :5;
    unsigned RXNEMPTYIE:1;
    unsigned RXHALFIE:1;
    unsigned RXFULLIE:1;
    unsigned RXOVFLIE:1;
    unsigned :4;
    unsigned TXEMPTYIE:1;
    unsigned TXHALFIE:1;
    unsigned TXNFULLIE:1;
  };
  struct {
    unsigned w:32;
  };
} __C2FIFOINT4bits_t;
extern volatile __C2FIFOINT4bits_t C2FIFOINT4bits __asm__ ("C2FIFOINT4") __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT4CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT4SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT4INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA4 __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA4CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA4SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA4INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI4 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CFIFOCI:5;
  };
  struct {
    unsigned w:32;
  };
} __C2FIFOCI4bits_t;
extern volatile __C2FIFOCI4bits_t C2FIFOCI4bits __asm__ ("C2FIFOCI4") __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI4CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI4SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI4INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON5 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TXPRI:2;
    unsigned RTREN:1;
    unsigned TXREQ:1;
    unsigned TXERR:1;
    unsigned TXLARB:1;
    unsigned TXABAT:1;
    unsigned TXEN:1;
    unsigned :4;
    unsigned DONLY:1;
    unsigned UINC:1;
    unsigned FRESET:1;
    unsigned :1;
    unsigned FSIZE:5;
  };
  struct {
    unsigned w:32;
  };
} __C2FIFOCON5bits_t;
extern volatile __C2FIFOCON5bits_t C2FIFOCON5bits __asm__ ("C2FIFOCON5") __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON5CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON5SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON5INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT5 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RXNEMPTYIF:1;
    unsigned RXHALFIF:1;
    unsigned RXFULLIF:1;
    unsigned RXOVFLIF:1;
    unsigned :4;
    unsigned TXEMPTYIF:1;
    unsigned TXHALFIF:1;
    unsigned TXNFULLIF:1;
    unsigned :5;
    unsigned RXNEMPTYIE:1;
    unsigned RXHALFIE:1;
    unsigned RXFULLIE:1;
    unsigned RXOVFLIE:1;
    unsigned :4;
    unsigned TXEMPTYIE:1;
    unsigned TXHALFIE:1;
    unsigned TXNFULLIE:1;
  };
  struct {
    unsigned w:32;
  };
} __C2FIFOINT5bits_t;
extern volatile __C2FIFOINT5bits_t C2FIFOINT5bits __asm__ ("C2FIFOINT5") __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT5CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT5SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT5INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA5 __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA5CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA5SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA5INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI5 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CFIFOCI:5;
  };
  struct {
    unsigned w:32;
  };
} __C2FIFOCI5bits_t;
extern volatile __C2FIFOCI5bits_t C2FIFOCI5bits __asm__ ("C2FIFOCI5") __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI5CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI5SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI5INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON6 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TXPRI:2;
    unsigned RTREN:1;
    unsigned TXREQ:1;
    unsigned TXERR:1;
    unsigned TXLARB:1;
    unsigned TXABAT:1;
    unsigned TXEN:1;
    unsigned :4;
    unsigned DONLY:1;
    unsigned UINC:1;
    unsigned FRESET:1;
    unsigned :1;
    unsigned FSIZE:5;
  };
  struct {
    unsigned w:32;
  };
} __C2FIFOCON6bits_t;
extern volatile __C2FIFOCON6bits_t C2FIFOCON6bits __asm__ ("C2FIFOCON6") __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON6CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON6SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON6INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT6 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RXNEMPTYIF:1;
    unsigned RXHALFIF:1;
    unsigned RXFULLIF:1;
    unsigned RXOVFLIF:1;
    unsigned :4;
    unsigned TXEMPTYIF:1;
    unsigned TXHALFIF:1;
    unsigned TXNFULLIF:1;
    unsigned :5;
    unsigned RXNEMPTYIE:1;
    unsigned RXHALFIE:1;
    unsigned RXFULLIE:1;
    unsigned RXOVFLIE:1;
    unsigned :4;
    unsigned TXEMPTYIE:1;
    unsigned TXHALFIE:1;
    unsigned TXNFULLIE:1;
  };
  struct {
    unsigned w:32;
  };
} __C2FIFOINT6bits_t;
extern volatile __C2FIFOINT6bits_t C2FIFOINT6bits __asm__ ("C2FIFOINT6") __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT6CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT6SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT6INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA6 __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA6CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA6SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA6INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI6 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CFIFOCI:5;
  };
  struct {
    unsigned w:32;
  };
} __C2FIFOCI6bits_t;
extern volatile __C2FIFOCI6bits_t C2FIFOCI6bits __asm__ ("C2FIFOCI6") __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI6CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI6SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI6INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON7 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TXPRI:2;
    unsigned RTREN:1;
    unsigned TXREQ:1;
    unsigned TXERR:1;
    unsigned TXLARB:1;
    unsigned TXABAT:1;
    unsigned TXEN:1;
    unsigned :4;
    unsigned DONLY:1;
    unsigned UINC:1;
    unsigned FRESET:1;
    unsigned :1;
    unsigned FSIZE:5;
  };
  struct {
    unsigned w:32;
  };
} __C2FIFOCON7bits_t;
extern volatile __C2FIFOCON7bits_t C2FIFOCON7bits __asm__ ("C2FIFOCON7") __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON7CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON7SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON7INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT7 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RXNEMPTYIF:1;
    unsigned RXHALFIF:1;
    unsigned RXFULLIF:1;
    unsigned RXOVFLIF:1;
    unsigned :4;
    unsigned TXEMPTYIF:1;
    unsigned TXHALFIF:1;
    unsigned TXNFULLIF:1;
    unsigned :5;
    unsigned RXNEMPTYIE:1;
    unsigned RXHALFIE:1;
    unsigned RXFULLIE:1;
    unsigned RXOVFLIE:1;
    unsigned :4;
    unsigned TXEMPTYIE:1;
    unsigned TXHALFIE:1;
    unsigned TXNFULLIE:1;
  };
  struct {
    unsigned w:32;
  };
} __C2FIFOINT7bits_t;
extern volatile __C2FIFOINT7bits_t C2FIFOINT7bits __asm__ ("C2FIFOINT7") __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT7CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT7SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT7INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA7 __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA7CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA7SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA7INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI7 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CFIFOCI:5;
  };
  struct {
    unsigned w:32;
  };
} __C2FIFOCI7bits_t;
extern volatile __C2FIFOCI7bits_t C2FIFOCI7bits __asm__ ("C2FIFOCI7") __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI7CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI7SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI7INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON8 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TXPRI:2;
    unsigned RTREN:1;
    unsigned TXREQ:1;
    unsigned TXERR:1;
    unsigned TXLARB:1;
    unsigned TXABAT:1;
    unsigned TXEN:1;
    unsigned :4;
    unsigned DONLY:1;
    unsigned UINC:1;
    unsigned FRESET:1;
    unsigned :1;
    unsigned FSIZE:5;
  };
  struct {
    unsigned w:32;
  };
} __C2FIFOCON8bits_t;
extern volatile __C2FIFOCON8bits_t C2FIFOCON8bits __asm__ ("C2FIFOCON8") __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON8CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON8SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON8INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT8 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RXNEMPTYIF:1;
    unsigned RXHALFIF:1;
    unsigned RXFULLIF:1;
    unsigned RXOVFLIF:1;
    unsigned :4;
    unsigned TXEMPTYIF:1;
    unsigned TXHALFIF:1;
    unsigned TXNFULLIF:1;
    unsigned :5;
    unsigned RXNEMPTYIE:1;
    unsigned RXHALFIE:1;
    unsigned RXFULLIE:1;
    unsigned RXOVFLIE:1;
    unsigned :4;
    unsigned TXEMPTYIE:1;
    unsigned TXHALFIE:1;
    unsigned TXNFULLIE:1;
  };
  struct {
    unsigned w:32;
  };
} __C2FIFOINT8bits_t;
extern volatile __C2FIFOINT8bits_t C2FIFOINT8bits __asm__ ("C2FIFOINT8") __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT8CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT8SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT8INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA8 __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA8CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA8SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA8INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI8 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CFIFOCI:5;
  };
  struct {
    unsigned w:32;
  };
} __C2FIFOCI8bits_t;
extern volatile __C2FIFOCI8bits_t C2FIFOCI8bits __asm__ ("C2FIFOCI8") __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI8CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI8SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI8INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON9 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TXPRI:2;
    unsigned RTREN:1;
    unsigned TXREQ:1;
    unsigned TXERR:1;
    unsigned TXLARB:1;
    unsigned TXABAT:1;
    unsigned TXEN:1;
    unsigned :4;
    unsigned DONLY:1;
    unsigned UINC:1;
    unsigned FRESET:1;
    unsigned :1;
    unsigned FSIZE:5;
  };
  struct {
    unsigned w:32;
  };
} __C2FIFOCON9bits_t;
extern volatile __C2FIFOCON9bits_t C2FIFOCON9bits __asm__ ("C2FIFOCON9") __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON9CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON9SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON9INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT9 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RXNEMPTYIF:1;
    unsigned RXHALFIF:1;
    unsigned RXFULLIF:1;
    unsigned RXOVFLIF:1;
    unsigned :4;
    unsigned TXEMPTYIF:1;
    unsigned TXHALFIF:1;
    unsigned TXNFULLIF:1;
    unsigned :5;
    unsigned RXNEMPTYIE:1;
    unsigned RXHALFIE:1;
    unsigned RXFULLIE:1;
    unsigned RXOVFLIE:1;
    unsigned :4;
    unsigned TXEMPTYIE:1;
    unsigned TXHALFIE:1;
    unsigned TXNFULLIE:1;
  };
  struct {
    unsigned w:32;
  };
} __C2FIFOINT9bits_t;
extern volatile __C2FIFOINT9bits_t C2FIFOINT9bits __asm__ ("C2FIFOINT9") __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT9CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT9SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT9INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA9 __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA9CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA9SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA9INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI9 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CFIFOCI:5;
  };
  struct {
    unsigned w:32;
  };
} __C2FIFOCI9bits_t;
extern volatile __C2FIFOCI9bits_t C2FIFOCI9bits __asm__ ("C2FIFOCI9") __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI9CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI9SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI9INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON10 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TXPRI:2;
    unsigned RTREN:1;
    unsigned TXREQ:1;
    unsigned TXERR:1;
    unsigned TXLARB:1;
    unsigned TXABAT:1;
    unsigned TXEN:1;
    unsigned :4;
    unsigned DONLY:1;
    unsigned UINC:1;
    unsigned FRESET:1;
    unsigned :1;
    unsigned FSIZE:5;
  };
  struct {
    unsigned w:32;
  };
} __C2FIFOCON10bits_t;
extern volatile __C2FIFOCON10bits_t C2FIFOCON10bits __asm__ ("C2FIFOCON10") __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON10CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON10SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON10INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT10 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RXNEMPTYIF:1;
    unsigned RXHALFIF:1;
    unsigned RXFULLIF:1;
    unsigned RXOVFLIF:1;
    unsigned :4;
    unsigned TXEMPTYIF:1;
    unsigned TXHALFIF:1;
    unsigned TXNFULLIF:1;
    unsigned :5;
    unsigned RXNEMPTYIE:1;
    unsigned RXHALFIE:1;
    unsigned RXFULLIE:1;
    unsigned RXOVFLIE:1;
    unsigned :4;
    unsigned TXEMPTYIE:1;
    unsigned TXHALFIE:1;
    unsigned TXNFULLIE:1;
  };
  struct {
    unsigned w:32;
  };
} __C2FIFOINT10bits_t;
extern volatile __C2FIFOINT10bits_t C2FIFOINT10bits __asm__ ("C2FIFOINT10") __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT10CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT10SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT10INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA10 __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA10CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA10SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA10INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI10 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CFIFOCI:5;
  };
  struct {
    unsigned w:32;
  };
} __C2FIFOCI10bits_t;
extern volatile __C2FIFOCI10bits_t C2FIFOCI10bits __asm__ ("C2FIFOCI10") __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI10CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI10SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI10INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON11 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TXPRI:2;
    unsigned RTREN:1;
    unsigned TXREQ:1;
    unsigned TXERR:1;
    unsigned TXLARB:1;
    unsigned TXABAT:1;
    unsigned TXEN:1;
    unsigned :4;
    unsigned DONLY:1;
    unsigned UINC:1;
    unsigned FRESET:1;
    unsigned :1;
    unsigned FSIZE:5;
  };
  struct {
    unsigned w:32;
  };
} __C2FIFOCON11bits_t;
extern volatile __C2FIFOCON11bits_t C2FIFOCON11bits __asm__ ("C2FIFOCON11") __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON11CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON11SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON11INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT11 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RXNEMPTYIF:1;
    unsigned RXHALFIF:1;
    unsigned RXFULLIF:1;
    unsigned RXOVFLIF:1;
    unsigned :4;
    unsigned TXEMPTYIF:1;
    unsigned TXHALFIF:1;
    unsigned TXNFULLIF:1;
    unsigned :5;
    unsigned RXNEMPTYIE:1;
    unsigned RXHALFIE:1;
    unsigned RXFULLIE:1;
    unsigned RXOVFLIE:1;
    unsigned :4;
    unsigned TXEMPTYIE:1;
    unsigned TXHALFIE:1;
    unsigned TXNFULLIE:1;
  };
  struct {
    unsigned w:32;
  };
} __C2FIFOINT11bits_t;
extern volatile __C2FIFOINT11bits_t C2FIFOINT11bits __asm__ ("C2FIFOINT11") __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT11CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT11SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT11INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA11 __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA11CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA11SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA11INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI11 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CFIFOCI:5;
  };
  struct {
    unsigned w:32;
  };
} __C2FIFOCI11bits_t;
extern volatile __C2FIFOCI11bits_t C2FIFOCI11bits __asm__ ("C2FIFOCI11") __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI11CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI11SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI11INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON12 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TXPRI:2;
    unsigned RTREN:1;
    unsigned TXREQ:1;
    unsigned TXERR:1;
    unsigned TXLARB:1;
    unsigned TXABAT:1;
    unsigned TXEN:1;
    unsigned :4;
    unsigned DONLY:1;
    unsigned UINC:1;
    unsigned FRESET:1;
    unsigned :1;
    unsigned FSIZE:5;
  };
  struct {
    unsigned w:32;
  };
} __C2FIFOCON12bits_t;
extern volatile __C2FIFOCON12bits_t C2FIFOCON12bits __asm__ ("C2FIFOCON12") __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON12CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON12SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON12INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT12 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RXNEMPTYIF:1;
    unsigned RXHALFIF:1;
    unsigned RXFULLIF:1;
    unsigned RXOVFLIF:1;
    unsigned :4;
    unsigned TXEMPTYIF:1;
    unsigned TXHALFIF:1;
    unsigned TXNFULLIF:1;
    unsigned :5;
    unsigned RXNEMPTYIE:1;
    unsigned RXHALFIE:1;
    unsigned RXFULLIE:1;
    unsigned RXOVFLIE:1;
    unsigned :4;
    unsigned TXEMPTYIE:1;
    unsigned TXHALFIE:1;
    unsigned TXNFULLIE:1;
  };
  struct {
    unsigned w:32;
  };
} __C2FIFOINT12bits_t;
extern volatile __C2FIFOINT12bits_t C2FIFOINT12bits __asm__ ("C2FIFOINT12") __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT12CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT12SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT12INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA12 __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA12CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA12SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA12INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI12 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CFIFOCI:5;
  };
  struct {
    unsigned w:32;
  };
} __C2FIFOCI12bits_t;
extern volatile __C2FIFOCI12bits_t C2FIFOCI12bits __asm__ ("C2FIFOCI12") __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI12CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI12SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI12INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON13 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TXPRI:2;
    unsigned RTREN:1;
    unsigned TXREQ:1;
    unsigned TXERR:1;
    unsigned TXLARB:1;
    unsigned TXABAT:1;
    unsigned TXEN:1;
    unsigned :4;
    unsigned DONLY:1;
    unsigned UINC:1;
    unsigned FRESET:1;
    unsigned :1;
    unsigned FSIZE:5;
  };
  struct {
    unsigned w:32;
  };
} __C2FIFOCON13bits_t;
extern volatile __C2FIFOCON13bits_t C2FIFOCON13bits __asm__ ("C2FIFOCON13") __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON13CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON13SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON13INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT13 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RXNEMPTYIF:1;
    unsigned RXHALFIF:1;
    unsigned RXFULLIF:1;
    unsigned RXOVFLIF:1;
    unsigned :4;
    unsigned TXEMPTYIF:1;
    unsigned TXHALFIF:1;
    unsigned TXNFULLIF:1;
    unsigned :5;
    unsigned RXNEMPTYIE:1;
    unsigned RXHALFIE:1;
    unsigned RXFULLIE:1;
    unsigned RXOVFLIE:1;
    unsigned :4;
    unsigned TXEMPTYIE:1;
    unsigned TXHALFIE:1;
    unsigned TXNFULLIE:1;
  };
  struct {
    unsigned w:32;
  };
} __C2FIFOINT13bits_t;
extern volatile __C2FIFOINT13bits_t C2FIFOINT13bits __asm__ ("C2FIFOINT13") __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT13CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT13SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT13INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA13 __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA13CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA13SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA13INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI13 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CFIFOCI:5;
  };
  struct {
    unsigned w:32;
  };
} __C2FIFOCI13bits_t;
extern volatile __C2FIFOCI13bits_t C2FIFOCI13bits __asm__ ("C2FIFOCI13") __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI13CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI13SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI13INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON14 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TXPRI:2;
    unsigned RTREN:1;
    unsigned TXREQ:1;
    unsigned TXERR:1;
    unsigned TXLARB:1;
    unsigned TXABAT:1;
    unsigned TXEN:1;
    unsigned :4;
    unsigned DONLY:1;
    unsigned UINC:1;
    unsigned FRESET:1;
    unsigned :1;
    unsigned FSIZE:5;
  };
  struct {
    unsigned w:32;
  };
} __C2FIFOCON14bits_t;
extern volatile __C2FIFOCON14bits_t C2FIFOCON14bits __asm__ ("C2FIFOCON14") __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON14CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON14SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON14INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT14 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RXNEMPTYIF:1;
    unsigned RXHALFIF:1;
    unsigned RXFULLIF:1;
    unsigned RXOVFLIF:1;
    unsigned :4;
    unsigned TXEMPTYIF:1;
    unsigned TXHALFIF:1;
    unsigned TXNFULLIF:1;
    unsigned :5;
    unsigned RXNEMPTYIE:1;
    unsigned RXHALFIE:1;
    unsigned RXFULLIE:1;
    unsigned RXOVFLIE:1;
    unsigned :4;
    unsigned TXEMPTYIE:1;
    unsigned TXHALFIE:1;
    unsigned TXNFULLIE:1;
  };
  struct {
    unsigned w:32;
  };
} __C2FIFOINT14bits_t;
extern volatile __C2FIFOINT14bits_t C2FIFOINT14bits __asm__ ("C2FIFOINT14") __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT14CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT14SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT14INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA14 __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA14CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA14SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA14INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI14 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CFIFOCI:5;
  };
  struct {
    unsigned w:32;
  };
} __C2FIFOCI14bits_t;
extern volatile __C2FIFOCI14bits_t C2FIFOCI14bits __asm__ ("C2FIFOCI14") __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI14CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI14SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI14INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON15 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TXPRI:2;
    unsigned RTREN:1;
    unsigned TXREQ:1;
    unsigned TXERR:1;
    unsigned TXLARB:1;
    unsigned TXABAT:1;
    unsigned TXEN:1;
    unsigned :4;
    unsigned DONLY:1;
    unsigned UINC:1;
    unsigned FRESET:1;
    unsigned :1;
    unsigned FSIZE:5;
  };
  struct {
    unsigned w:32;
  };
} __C2FIFOCON15bits_t;
extern volatile __C2FIFOCON15bits_t C2FIFOCON15bits __asm__ ("C2FIFOCON15") __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON15CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON15SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON15INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT15 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RXNEMPTYIF:1;
    unsigned RXHALFIF:1;
    unsigned RXFULLIF:1;
    unsigned RXOVFLIF:1;
    unsigned :4;
    unsigned TXEMPTYIF:1;
    unsigned TXHALFIF:1;
    unsigned TXNFULLIF:1;
    unsigned :5;
    unsigned RXNEMPTYIE:1;
    unsigned RXHALFIE:1;
    unsigned RXFULLIE:1;
    unsigned RXOVFLIE:1;
    unsigned :4;
    unsigned TXEMPTYIE:1;
    unsigned TXHALFIE:1;
    unsigned TXNFULLIE:1;
  };
  struct {
    unsigned w:32;
  };
} __C2FIFOINT15bits_t;
extern volatile __C2FIFOINT15bits_t C2FIFOINT15bits __asm__ ("C2FIFOINT15") __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT15CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT15SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT15INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA15 __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA15CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA15SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA15INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI15 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CFIFOCI:5;
  };
  struct {
    unsigned w:32;
  };
} __C2FIFOCI15bits_t;
extern volatile __C2FIFOCI15bits_t C2FIFOCI15bits __asm__ ("C2FIFOCI15") __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI15CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI15SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI15INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON16 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TXPRI:2;
    unsigned RTREN:1;
    unsigned TXREQ:1;
    unsigned TXERR:1;
    unsigned TXLARB:1;
    unsigned TXABAT:1;
    unsigned TXEN:1;
    unsigned :4;
    unsigned DONLY:1;
    unsigned UINC:1;
    unsigned FRESET:1;
    unsigned :1;
    unsigned FSIZE:5;
  };
  struct {
    unsigned w:32;
  };
} __C2FIFOCON16bits_t;
extern volatile __C2FIFOCON16bits_t C2FIFOCON16bits __asm__ ("C2FIFOCON16") __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON16CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON16SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON16INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT16 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RXNEMPTYIF:1;
    unsigned RXHALFIF:1;
    unsigned RXFULLIF:1;
    unsigned RXOVFLIF:1;
    unsigned :4;
    unsigned TXEMPTYIF:1;
    unsigned TXHALFIF:1;
    unsigned TXNFULLIF:1;
    unsigned :5;
    unsigned RXNEMPTYIE:1;
    unsigned RXHALFIE:1;
    unsigned RXFULLIE:1;
    unsigned RXOVFLIE:1;
    unsigned :4;
    unsigned TXEMPTYIE:1;
    unsigned TXHALFIE:1;
    unsigned TXNFULLIE:1;
  };
  struct {
    unsigned w:32;
  };
} __C2FIFOINT16bits_t;
extern volatile __C2FIFOINT16bits_t C2FIFOINT16bits __asm__ ("C2FIFOINT16") __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT16CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT16SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT16INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA16 __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA16CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA16SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA16INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI16 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CFIFOCI:5;
  };
  struct {
    unsigned w:32;
  };
} __C2FIFOCI16bits_t;
extern volatile __C2FIFOCI16bits_t C2FIFOCI16bits __asm__ ("C2FIFOCI16") __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI16CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI16SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI16INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON17 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TXPRI:2;
    unsigned RTREN:1;
    unsigned TXREQ:1;
    unsigned TXERR:1;
    unsigned TXLARB:1;
    unsigned TXABAT:1;
    unsigned TXEN:1;
    unsigned :4;
    unsigned DONLY:1;
    unsigned UINC:1;
    unsigned FRESET:1;
    unsigned :1;
    unsigned FSIZE:5;
  };
  struct {
    unsigned w:32;
  };
} __C2FIFOCON17bits_t;
extern volatile __C2FIFOCON17bits_t C2FIFOCON17bits __asm__ ("C2FIFOCON17") __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON17CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON17SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON17INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT17 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RXNEMPTYIF:1;
    unsigned RXHALFIF:1;
    unsigned RXFULLIF:1;
    unsigned RXOVFLIF:1;
    unsigned :4;
    unsigned TXEMPTYIF:1;
    unsigned TXHALFIF:1;
    unsigned TXNFULLIF:1;
    unsigned :5;
    unsigned RXNEMPTYIE:1;
    unsigned RXHALFIE:1;
    unsigned RXFULLIE:1;
    unsigned RXOVFLIE:1;
    unsigned :4;
    unsigned TXEMPTYIE:1;
    unsigned TXHALFIE:1;
    unsigned TXNFULLIE:1;
  };
  struct {
    unsigned w:32;
  };
} __C2FIFOINT17bits_t;
extern volatile __C2FIFOINT17bits_t C2FIFOINT17bits __asm__ ("C2FIFOINT17") __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT17CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT17SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT17INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA17 __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA17CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA17SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA17INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI17 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CFIFOCI:5;
  };
  struct {
    unsigned w:32;
  };
} __C2FIFOCI17bits_t;
extern volatile __C2FIFOCI17bits_t C2FIFOCI17bits __asm__ ("C2FIFOCI17") __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI17CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI17SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI17INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON18 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TXPRI:2;
    unsigned RTREN:1;
    unsigned TXREQ:1;
    unsigned TXERR:1;
    unsigned TXLARB:1;
    unsigned TXABAT:1;
    unsigned TXEN:1;
    unsigned :4;
    unsigned DONLY:1;
    unsigned UINC:1;
    unsigned FRESET:1;
    unsigned :1;
    unsigned FSIZE:5;
  };
  struct {
    unsigned w:32;
  };
} __C2FIFOCON18bits_t;
extern volatile __C2FIFOCON18bits_t C2FIFOCON18bits __asm__ ("C2FIFOCON18") __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON18CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON18SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON18INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT18 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RXNEMPTYIF:1;
    unsigned RXHALFIF:1;
    unsigned RXFULLIF:1;
    unsigned RXOVFLIF:1;
    unsigned :4;
    unsigned TXEMPTYIF:1;
    unsigned TXHALFIF:1;
    unsigned TXNFULLIF:1;
    unsigned :5;
    unsigned RXNEMPTYIE:1;
    unsigned RXHALFIE:1;
    unsigned RXFULLIE:1;
    unsigned RXOVFLIE:1;
    unsigned :4;
    unsigned TXEMPTYIE:1;
    unsigned TXHALFIE:1;
    unsigned TXNFULLIE:1;
  };
  struct {
    unsigned w:32;
  };
} __C2FIFOINT18bits_t;
extern volatile __C2FIFOINT18bits_t C2FIFOINT18bits __asm__ ("C2FIFOINT18") __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT18CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT18SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT18INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA18 __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA18CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA18SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA18INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI18 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CFIFOCI:5;
  };
  struct {
    unsigned w:32;
  };
} __C2FIFOCI18bits_t;
extern volatile __C2FIFOCI18bits_t C2FIFOCI18bits __asm__ ("C2FIFOCI18") __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI18CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI18SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI18INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON19 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TXPRI:2;
    unsigned RTREN:1;
    unsigned TXREQ:1;
    unsigned TXERR:1;
    unsigned TXLARB:1;
    unsigned TXABAT:1;
    unsigned TXEN:1;
    unsigned :4;
    unsigned DONLY:1;
    unsigned UINC:1;
    unsigned FRESET:1;
    unsigned :1;
    unsigned FSIZE:5;
  };
  struct {
    unsigned w:32;
  };
} __C2FIFOCON19bits_t;
extern volatile __C2FIFOCON19bits_t C2FIFOCON19bits __asm__ ("C2FIFOCON19") __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON19CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON19SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON19INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT19 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RXNEMPTYIF:1;
    unsigned RXHALFIF:1;
    unsigned RXFULLIF:1;
    unsigned RXOVFLIF:1;
    unsigned :4;
    unsigned TXEMPTYIF:1;
    unsigned TXHALFIF:1;
    unsigned TXNFULLIF:1;
    unsigned :5;
    unsigned RXNEMPTYIE:1;
    unsigned RXHALFIE:1;
    unsigned RXFULLIE:1;
    unsigned RXOVFLIE:1;
    unsigned :4;
    unsigned TXEMPTYIE:1;
    unsigned TXHALFIE:1;
    unsigned TXNFULLIE:1;
  };
  struct {
    unsigned w:32;
  };
} __C2FIFOINT19bits_t;
extern volatile __C2FIFOINT19bits_t C2FIFOINT19bits __asm__ ("C2FIFOINT19") __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT19CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT19SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT19INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA19 __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA19CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA19SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA19INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI19 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CFIFOCI:5;
  };
  struct {
    unsigned w:32;
  };
} __C2FIFOCI19bits_t;
extern volatile __C2FIFOCI19bits_t C2FIFOCI19bits __asm__ ("C2FIFOCI19") __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI19CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI19SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI19INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON20 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TXPRI:2;
    unsigned RTREN:1;
    unsigned TXREQ:1;
    unsigned TXERR:1;
    unsigned TXLARB:1;
    unsigned TXABAT:1;
    unsigned TXEN:1;
    unsigned :4;
    unsigned DONLY:1;
    unsigned UINC:1;
    unsigned FRESET:1;
    unsigned :1;
    unsigned FSIZE:5;
  };
  struct {
    unsigned w:32;
  };
} __C2FIFOCON20bits_t;
extern volatile __C2FIFOCON20bits_t C2FIFOCON20bits __asm__ ("C2FIFOCON20") __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON20CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON20SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON20INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT20 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RXNEMPTYIF:1;
    unsigned RXHALFIF:1;
    unsigned RXFULLIF:1;
    unsigned RXOVFLIF:1;
    unsigned :4;
    unsigned TXEMPTYIF:1;
    unsigned TXHALFIF:1;
    unsigned TXNFULLIF:1;
    unsigned :5;
    unsigned RXNEMPTYIE:1;
    unsigned RXHALFIE:1;
    unsigned RXFULLIE:1;
    unsigned RXOVFLIE:1;
    unsigned :4;
    unsigned TXEMPTYIE:1;
    unsigned TXHALFIE:1;
    unsigned TXNFULLIE:1;
  };
  struct {
    unsigned w:32;
  };
} __C2FIFOINT20bits_t;
extern volatile __C2FIFOINT20bits_t C2FIFOINT20bits __asm__ ("C2FIFOINT20") __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT20CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT20SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT20INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA20 __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA20CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA20SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA20INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI20 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CFIFOCI:5;
  };
  struct {
    unsigned w:32;
  };
} __C2FIFOCI20bits_t;
extern volatile __C2FIFOCI20bits_t C2FIFOCI20bits __asm__ ("C2FIFOCI20") __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI20CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI20SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI20INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON21 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TXPRI:2;
    unsigned RTREN:1;
    unsigned TXREQ:1;
    unsigned TXERR:1;
    unsigned TXLARB:1;
    unsigned TXABAT:1;
    unsigned TXEN:1;
    unsigned :4;
    unsigned DONLY:1;
    unsigned UINC:1;
    unsigned FRESET:1;
    unsigned :1;
    unsigned FSIZE:5;
  };
  struct {
    unsigned w:32;
  };
} __C2FIFOCON21bits_t;
extern volatile __C2FIFOCON21bits_t C2FIFOCON21bits __asm__ ("C2FIFOCON21") __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON21CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON21SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON21INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT21 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RXNEMPTYIF:1;
    unsigned RXHALFIF:1;
    unsigned RXFULLIF:1;
    unsigned RXOVFLIF:1;
    unsigned :4;
    unsigned TXEMPTYIF:1;
    unsigned TXHALFIF:1;
    unsigned TXNFULLIF:1;
    unsigned :5;
    unsigned RXNEMPTYIE:1;
    unsigned RXHALFIE:1;
    unsigned RXFULLIE:1;
    unsigned RXOVFLIE:1;
    unsigned :4;
    unsigned TXEMPTYIE:1;
    unsigned TXHALFIE:1;
    unsigned TXNFULLIE:1;
  };
  struct {
    unsigned w:32;
  };
} __C2FIFOINT21bits_t;
extern volatile __C2FIFOINT21bits_t C2FIFOINT21bits __asm__ ("C2FIFOINT21") __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT21CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT21SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT21INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA21 __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA21CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA21SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA21INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI21 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CFIFOCI:5;
  };
  struct {
    unsigned w:32;
  };
} __C2FIFOCI21bits_t;
extern volatile __C2FIFOCI21bits_t C2FIFOCI21bits __asm__ ("C2FIFOCI21") __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI21CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI21SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI21INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON22 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TXPRI:2;
    unsigned RTREN:1;
    unsigned TXREQ:1;
    unsigned TXERR:1;
    unsigned TXLARB:1;
    unsigned TXABAT:1;
    unsigned TXEN:1;
    unsigned :4;
    unsigned DONLY:1;
    unsigned UINC:1;
    unsigned FRESET:1;
    unsigned :1;
    unsigned FSIZE:5;
  };
  struct {
    unsigned w:32;
  };
} __C2FIFOCON22bits_t;
extern volatile __C2FIFOCON22bits_t C2FIFOCON22bits __asm__ ("C2FIFOCON22") __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON22CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON22SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON22INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT22 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RXNEMPTYIF:1;
    unsigned RXHALFIF:1;
    unsigned RXFULLIF:1;
    unsigned RXOVFLIF:1;
    unsigned :4;
    unsigned TXEMPTYIF:1;
    unsigned TXHALFIF:1;
    unsigned TXNFULLIF:1;
    unsigned :5;
    unsigned RXNEMPTYIE:1;
    unsigned RXHALFIE:1;
    unsigned RXFULLIE:1;
    unsigned RXOVFLIE:1;
    unsigned :4;
    unsigned TXEMPTYIE:1;
    unsigned TXHALFIE:1;
    unsigned TXNFULLIE:1;
  };
  struct {
    unsigned w:32;
  };
} __C2FIFOINT22bits_t;
extern volatile __C2FIFOINT22bits_t C2FIFOINT22bits __asm__ ("C2FIFOINT22") __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT22CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT22SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT22INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA22 __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA22CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA22SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA22INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI22 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CFIFOCI:5;
  };
  struct {
    unsigned w:32;
  };
} __C2FIFOCI22bits_t;
extern volatile __C2FIFOCI22bits_t C2FIFOCI22bits __asm__ ("C2FIFOCI22") __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI22CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI22SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI22INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON23 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TXPRI:2;
    unsigned RTREN:1;
    unsigned TXREQ:1;
    unsigned TXERR:1;
    unsigned TXLARB:1;
    unsigned TXABAT:1;
    unsigned TXEN:1;
    unsigned :4;
    unsigned DONLY:1;
    unsigned UINC:1;
    unsigned FRESET:1;
    unsigned :1;
    unsigned FSIZE:5;
  };
  struct {
    unsigned w:32;
  };
} __C2FIFOCON23bits_t;
extern volatile __C2FIFOCON23bits_t C2FIFOCON23bits __asm__ ("C2FIFOCON23") __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON23CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON23SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON23INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT23 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RXNEMPTYIF:1;
    unsigned RXHALFIF:1;
    unsigned RXFULLIF:1;
    unsigned RXOVFLIF:1;
    unsigned :4;
    unsigned TXEMPTYIF:1;
    unsigned TXHALFIF:1;
    unsigned TXNFULLIF:1;
    unsigned :5;
    unsigned RXNEMPTYIE:1;
    unsigned RXHALFIE:1;
    unsigned RXFULLIE:1;
    unsigned RXOVFLIE:1;
    unsigned :4;
    unsigned TXEMPTYIE:1;
    unsigned TXHALFIE:1;
    unsigned TXNFULLIE:1;
  };
  struct {
    unsigned w:32;
  };
} __C2FIFOINT23bits_t;
extern volatile __C2FIFOINT23bits_t C2FIFOINT23bits __asm__ ("C2FIFOINT23") __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT23CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT23SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT23INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA23 __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA23CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA23SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA23INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI23 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CFIFOCI:5;
  };
  struct {
    unsigned w:32;
  };
} __C2FIFOCI23bits_t;
extern volatile __C2FIFOCI23bits_t C2FIFOCI23bits __asm__ ("C2FIFOCI23") __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI23CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI23SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI23INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON24 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TXPRI:2;
    unsigned RTREN:1;
    unsigned TXREQ:1;
    unsigned TXERR:1;
    unsigned TXLARB:1;
    unsigned TXABAT:1;
    unsigned TXEN:1;
    unsigned :4;
    unsigned DONLY:1;
    unsigned UINC:1;
    unsigned FRESET:1;
    unsigned :1;
    unsigned FSIZE:5;
  };
  struct {
    unsigned w:32;
  };
} __C2FIFOCON24bits_t;
extern volatile __C2FIFOCON24bits_t C2FIFOCON24bits __asm__ ("C2FIFOCON24") __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON24CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON24SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON24INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT24 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RXNEMPTYIF:1;
    unsigned RXHALFIF:1;
    unsigned RXFULLIF:1;
    unsigned RXOVFLIF:1;
    unsigned :4;
    unsigned TXEMPTYIF:1;
    unsigned TXHALFIF:1;
    unsigned TXNFULLIF:1;
    unsigned :5;
    unsigned RXNEMPTYIE:1;
    unsigned RXHALFIE:1;
    unsigned RXFULLIE:1;
    unsigned RXOVFLIE:1;
    unsigned :4;
    unsigned TXEMPTYIE:1;
    unsigned TXHALFIE:1;
    unsigned TXNFULLIE:1;
  };
  struct {
    unsigned w:32;
  };
} __C2FIFOINT24bits_t;
extern volatile __C2FIFOINT24bits_t C2FIFOINT24bits __asm__ ("C2FIFOINT24") __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT24CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT24SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT24INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA24 __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA24CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA24SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA24INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI24 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CFIFOCI:5;
  };
  struct {
    unsigned w:32;
  };
} __C2FIFOCI24bits_t;
extern volatile __C2FIFOCI24bits_t C2FIFOCI24bits __asm__ ("C2FIFOCI24") __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI24CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI24SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI24INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON25 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TXPRI:2;
    unsigned RTREN:1;
    unsigned TXREQ:1;
    unsigned TXERR:1;
    unsigned TXLARB:1;
    unsigned TXABAT:1;
    unsigned TXEN:1;
    unsigned :4;
    unsigned DONLY:1;
    unsigned UINC:1;
    unsigned FRESET:1;
    unsigned :1;
    unsigned FSIZE:5;
  };
  struct {
    unsigned w:32;
  };
} __C2FIFOCON25bits_t;
extern volatile __C2FIFOCON25bits_t C2FIFOCON25bits __asm__ ("C2FIFOCON25") __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON25CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON25SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON25INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT25 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RXNEMPTYIF:1;
    unsigned RXHALFIF:1;
    unsigned RXFULLIF:1;
    unsigned RXOVFLIF:1;
    unsigned :4;
    unsigned TXEMPTYIF:1;
    unsigned TXHALFIF:1;
    unsigned TXNFULLIF:1;
    unsigned :5;
    unsigned RXNEMPTYIE:1;
    unsigned RXHALFIE:1;
    unsigned RXFULLIE:1;
    unsigned RXOVFLIE:1;
    unsigned :4;
    unsigned TXEMPTYIE:1;
    unsigned TXHALFIE:1;
    unsigned TXNFULLIE:1;
  };
  struct {
    unsigned w:32;
  };
} __C2FIFOINT25bits_t;
extern volatile __C2FIFOINT25bits_t C2FIFOINT25bits __asm__ ("C2FIFOINT25") __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT25CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT25SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT25INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA25 __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA25CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA25SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA25INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI25 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CFIFOCI:5;
  };
  struct {
    unsigned w:32;
  };
} __C2FIFOCI25bits_t;
extern volatile __C2FIFOCI25bits_t C2FIFOCI25bits __asm__ ("C2FIFOCI25") __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI25CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI25SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI25INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON26 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TXPRI:2;
    unsigned RTREN:1;
    unsigned TXREQ:1;
    unsigned TXERR:1;
    unsigned TXLARB:1;
    unsigned TXABAT:1;
    unsigned TXEN:1;
    unsigned :4;
    unsigned DONLY:1;
    unsigned UINC:1;
    unsigned FRESET:1;
    unsigned :1;
    unsigned FSIZE:5;
  };
  struct {
    unsigned w:32;
  };
} __C2FIFOCON26bits_t;
extern volatile __C2FIFOCON26bits_t C2FIFOCON26bits __asm__ ("C2FIFOCON26") __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON26CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON26SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON26INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT26 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RXNEMPTYIF:1;
    unsigned RXHALFIF:1;
    unsigned RXFULLIF:1;
    unsigned RXOVFLIF:1;
    unsigned :4;
    unsigned TXEMPTYIF:1;
    unsigned TXHALFIF:1;
    unsigned TXNFULLIF:1;
    unsigned :5;
    unsigned RXNEMPTYIE:1;
    unsigned RXHALFIE:1;
    unsigned RXFULLIE:1;
    unsigned RXOVFLIE:1;
    unsigned :4;
    unsigned TXEMPTYIE:1;
    unsigned TXHALFIE:1;
    unsigned TXNFULLIE:1;
  };
  struct {
    unsigned w:32;
  };
} __C2FIFOINT26bits_t;
extern volatile __C2FIFOINT26bits_t C2FIFOINT26bits __asm__ ("C2FIFOINT26") __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT26CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT26SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT26INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA26 __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA26CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA26SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA26INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI26 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CFIFOCI:5;
  };
  struct {
    unsigned w:32;
  };
} __C2FIFOCI26bits_t;
extern volatile __C2FIFOCI26bits_t C2FIFOCI26bits __asm__ ("C2FIFOCI26") __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI26CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI26SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI26INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON27 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TXPRI:2;
    unsigned RTREN:1;
    unsigned TXREQ:1;
    unsigned TXERR:1;
    unsigned TXLARB:1;
    unsigned TXABAT:1;
    unsigned TXEN:1;
    unsigned :4;
    unsigned DONLY:1;
    unsigned UINC:1;
    unsigned FRESET:1;
    unsigned :1;
    unsigned FSIZE:5;
  };
  struct {
    unsigned w:32;
  };
} __C2FIFOCON27bits_t;
extern volatile __C2FIFOCON27bits_t C2FIFOCON27bits __asm__ ("C2FIFOCON27") __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON27CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON27SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON27INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT27 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RXNEMPTYIF:1;
    unsigned RXHALFIF:1;
    unsigned RXFULLIF:1;
    unsigned RXOVFLIF:1;
    unsigned :4;
    unsigned TXEMPTYIF:1;
    unsigned TXHALFIF:1;
    unsigned TXNFULLIF:1;
    unsigned :5;
    unsigned RXNEMPTYIE:1;
    unsigned RXHALFIE:1;
    unsigned RXFULLIE:1;
    unsigned RXOVFLIE:1;
    unsigned :4;
    unsigned TXEMPTYIE:1;
    unsigned TXHALFIE:1;
    unsigned TXNFULLIE:1;
  };
  struct {
    unsigned w:32;
  };
} __C2FIFOINT27bits_t;
extern volatile __C2FIFOINT27bits_t C2FIFOINT27bits __asm__ ("C2FIFOINT27") __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT27CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT27SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT27INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA27 __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA27CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA27SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA27INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI27 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CFIFOCI:5;
  };
  struct {
    unsigned w:32;
  };
} __C2FIFOCI27bits_t;
extern volatile __C2FIFOCI27bits_t C2FIFOCI27bits __asm__ ("C2FIFOCI27") __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI27CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI27SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI27INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON28 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TXPRI:2;
    unsigned RTREN:1;
    unsigned TXREQ:1;
    unsigned TXERR:1;
    unsigned TXLARB:1;
    unsigned TXABAT:1;
    unsigned TXEN:1;
    unsigned :4;
    unsigned DONLY:1;
    unsigned UINC:1;
    unsigned FRESET:1;
    unsigned :1;
    unsigned FSIZE:5;
  };
  struct {
    unsigned w:32;
  };
} __C2FIFOCON28bits_t;
extern volatile __C2FIFOCON28bits_t C2FIFOCON28bits __asm__ ("C2FIFOCON28") __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON28CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON28SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON28INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT28 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RXNEMPTYIF:1;
    unsigned RXHALFIF:1;
    unsigned RXFULLIF:1;
    unsigned RXOVFLIF:1;
    unsigned :4;
    unsigned TXEMPTYIF:1;
    unsigned TXHALFIF:1;
    unsigned TXNFULLIF:1;
    unsigned :5;
    unsigned RXNEMPTYIE:1;
    unsigned RXHALFIE:1;
    unsigned RXFULLIE:1;
    unsigned RXOVFLIE:1;
    unsigned :4;
    unsigned TXEMPTYIE:1;
    unsigned TXHALFIE:1;
    unsigned TXNFULLIE:1;
  };
  struct {
    unsigned w:32;
  };
} __C2FIFOINT28bits_t;
extern volatile __C2FIFOINT28bits_t C2FIFOINT28bits __asm__ ("C2FIFOINT28") __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT28CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT28SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT28INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA28 __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA28CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA28SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA28INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI28 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CFIFOCI:5;
  };
  struct {
    unsigned w:32;
  };
} __C2FIFOCI28bits_t;
extern volatile __C2FIFOCI28bits_t C2FIFOCI28bits __asm__ ("C2FIFOCI28") __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI28CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI28SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI28INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON29 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TXPRI:2;
    unsigned RTREN:1;
    unsigned TXREQ:1;
    unsigned TXERR:1;
    unsigned TXLARB:1;
    unsigned TXABAT:1;
    unsigned TXEN:1;
    unsigned :4;
    unsigned DONLY:1;
    unsigned UINC:1;
    unsigned FRESET:1;
    unsigned :1;
    unsigned FSIZE:5;
  };
  struct {
    unsigned w:32;
  };
} __C2FIFOCON29bits_t;
extern volatile __C2FIFOCON29bits_t C2FIFOCON29bits __asm__ ("C2FIFOCON29") __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON29CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON29SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON29INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT29 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RXNEMPTYIF:1;
    unsigned RXHALFIF:1;
    unsigned RXFULLIF:1;
    unsigned RXOVFLIF:1;
    unsigned :4;
    unsigned TXEMPTYIF:1;
    unsigned TXHALFIF:1;
    unsigned TXNFULLIF:1;
    unsigned :5;
    unsigned RXNEMPTYIE:1;
    unsigned RXHALFIE:1;
    unsigned RXFULLIE:1;
    unsigned RXOVFLIE:1;
    unsigned :4;
    unsigned TXEMPTYIE:1;
    unsigned TXHALFIE:1;
    unsigned TXNFULLIE:1;
  };
  struct {
    unsigned w:32;
  };
} __C2FIFOINT29bits_t;
extern volatile __C2FIFOINT29bits_t C2FIFOINT29bits __asm__ ("C2FIFOINT29") __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT29CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT29SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT29INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA29 __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA29CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA29SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA29INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI29 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CFIFOCI:5;
  };
  struct {
    unsigned w:32;
  };
} __C2FIFOCI29bits_t;
extern volatile __C2FIFOCI29bits_t C2FIFOCI29bits __asm__ ("C2FIFOCI29") __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI29CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI29SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI29INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON30 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TXPRI:2;
    unsigned RTREN:1;
    unsigned TXREQ:1;
    unsigned TXERR:1;
    unsigned TXLARB:1;
    unsigned TXABAT:1;
    unsigned TXEN:1;
    unsigned :4;
    unsigned DONLY:1;
    unsigned UINC:1;
    unsigned FRESET:1;
    unsigned :1;
    unsigned FSIZE:5;
  };
  struct {
    unsigned w:32;
  };
} __C2FIFOCON30bits_t;
extern volatile __C2FIFOCON30bits_t C2FIFOCON30bits __asm__ ("C2FIFOCON30") __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON30CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON30SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON30INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT30 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RXNEMPTYIF:1;
    unsigned RXHALFIF:1;
    unsigned RXFULLIF:1;
    unsigned RXOVFLIF:1;
    unsigned :4;
    unsigned TXEMPTYIF:1;
    unsigned TXHALFIF:1;
    unsigned TXNFULLIF:1;
    unsigned :5;
    unsigned RXNEMPTYIE:1;
    unsigned RXHALFIE:1;
    unsigned RXFULLIE:1;
    unsigned RXOVFLIE:1;
    unsigned :4;
    unsigned TXEMPTYIE:1;
    unsigned TXHALFIE:1;
    unsigned TXNFULLIE:1;
  };
  struct {
    unsigned w:32;
  };
} __C2FIFOINT30bits_t;
extern volatile __C2FIFOINT30bits_t C2FIFOINT30bits __asm__ ("C2FIFOINT30") __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT30CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT30SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT30INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA30 __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA30CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA30SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA30INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI30 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CFIFOCI:5;
  };
  struct {
    unsigned w:32;
  };
} __C2FIFOCI30bits_t;
extern volatile __C2FIFOCI30bits_t C2FIFOCI30bits __asm__ ("C2FIFOCI30") __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI30CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI30SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI30INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON31 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TXPRI:2;
    unsigned RTREN:1;
    unsigned TXREQ:1;
    unsigned TXERR:1;
    unsigned TXLARB:1;
    unsigned TXABAT:1;
    unsigned TXEN:1;
    unsigned :4;
    unsigned DONLY:1;
    unsigned UINC:1;
    unsigned FRESET:1;
    unsigned :1;
    unsigned FSIZE:5;
  };
  struct {
    unsigned w:32;
  };
} __C2FIFOCON31bits_t;
extern volatile __C2FIFOCON31bits_t C2FIFOCON31bits __asm__ ("C2FIFOCON31") __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON31CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON31SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCON31INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT31 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RXNEMPTYIF:1;
    unsigned RXHALFIF:1;
    unsigned RXFULLIF:1;
    unsigned RXOVFLIF:1;
    unsigned :4;
    unsigned TXEMPTYIF:1;
    unsigned TXHALFIF:1;
    unsigned TXNFULLIF:1;
    unsigned :5;
    unsigned RXNEMPTYIE:1;
    unsigned RXHALFIE:1;
    unsigned RXFULLIE:1;
    unsigned RXOVFLIE:1;
    unsigned :4;
    unsigned TXEMPTYIE:1;
    unsigned TXHALFIE:1;
    unsigned TXNFULLIE:1;
  };
  struct {
    unsigned w:32;
  };
} __C2FIFOINT31bits_t;
extern volatile __C2FIFOINT31bits_t C2FIFOINT31bits __asm__ ("C2FIFOINT31") __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT31CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT31SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOINT31INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA31 __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA31CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA31SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOUA31INV __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI31 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CFIFOCI:5;
  };
  struct {
    unsigned w:32;
  };
} __C2FIFOCI31bits_t;
extern volatile __C2FIFOCI31bits_t C2FIFOCI31bits __asm__ ("C2FIFOCI31") __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI31CLR __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI31SET __attribute__((section("sfrs")));
extern volatile unsigned int        C2FIFOCI31INV __attribute__((section("sfrs")));
extern volatile unsigned int        ETHCON1 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned BUFCDEC:1;
    unsigned :3;
    unsigned MANFC:1;
    unsigned :2;
    unsigned AUTOFC:1;
    unsigned RXEN:1;
    unsigned TXRTS:1;
    unsigned :3;
    unsigned SIDL:1;
    unsigned :1;
    unsigned ON:1;
    unsigned PTV:16;
  };
  struct {
    unsigned w:32;
  };
} __ETHCON1bits_t;
extern volatile __ETHCON1bits_t ETHCON1bits __asm__ ("ETHCON1") __attribute__((section("sfrs")));
extern volatile unsigned int        ETHCON1CLR __attribute__((section("sfrs")));
extern volatile unsigned int        ETHCON1SET __attribute__((section("sfrs")));
extern volatile unsigned int        ETHCON1INV __attribute__((section("sfrs")));
extern volatile unsigned int        ETHCON2 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned :4;
    unsigned RXBUF_SZ:7;
  };
  struct {
    unsigned w:32;
  };
} __ETHCON2bits_t;
extern volatile __ETHCON2bits_t ETHCON2bits __asm__ ("ETHCON2") __attribute__((section("sfrs")));
extern volatile unsigned int        ETHCON2CLR __attribute__((section("sfrs")));
extern volatile unsigned int        ETHCON2SET __attribute__((section("sfrs")));
extern volatile unsigned int        ETHCON2INV __attribute__((section("sfrs")));
extern volatile unsigned int        ETHTXST __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned :2;
    unsigned TXSTADDR:30;
  };
  struct {
    unsigned w:32;
  };
} __ETHTXSTbits_t;
extern volatile __ETHTXSTbits_t ETHTXSTbits __asm__ ("ETHTXST") __attribute__((section("sfrs")));
extern volatile unsigned int        ETHTXSTCLR __attribute__((section("sfrs")));
extern volatile unsigned int        ETHTXSTSET __attribute__((section("sfrs")));
extern volatile unsigned int        ETHTXSTINV __attribute__((section("sfrs")));
extern volatile unsigned int        ETHRXST __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned :2;
    unsigned RXSTADDR:30;
  };
  struct {
    unsigned w:32;
  };
} __ETHRXSTbits_t;
extern volatile __ETHRXSTbits_t ETHRXSTbits __asm__ ("ETHRXST") __attribute__((section("sfrs")));
extern volatile unsigned int        ETHRXSTCLR __attribute__((section("sfrs")));
extern volatile unsigned int        ETHRXSTSET __attribute__((section("sfrs")));
extern volatile unsigned int        ETHRXSTINV __attribute__((section("sfrs")));
extern volatile unsigned int        ETHHT0 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned w:32;
  };
  struct {
    unsigned HTLOWER:32;
  };
} __ETHHT0bits_t;
extern volatile __ETHHT0bits_t ETHHT0bits __asm__ ("ETHHT0") __attribute__((section("sfrs")));
extern volatile unsigned int        ETHHT0CLR __attribute__((section("sfrs")));
extern volatile unsigned int        ETHHT0SET __attribute__((section("sfrs")));
extern volatile unsigned int        ETHHT0INV __attribute__((section("sfrs")));
extern volatile unsigned int        ETHHT1 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned w:32;
  };
  struct {
    unsigned HTUPPER:32;
  };
} __ETHHT1bits_t;
extern volatile __ETHHT1bits_t ETHHT1bits __asm__ ("ETHHT1") __attribute__((section("sfrs")));
extern volatile unsigned int        ETHHT1CLR __attribute__((section("sfrs")));
extern volatile unsigned int        ETHHT1SET __attribute__((section("sfrs")));
extern volatile unsigned int        ETHHT1INV __attribute__((section("sfrs")));
extern volatile unsigned int        ETHPMM0 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned w:32;
  };
  struct {
    unsigned PMMLOWER:32;
  };
} __ETHPMM0bits_t;
extern volatile __ETHPMM0bits_t ETHPMM0bits __asm__ ("ETHPMM0") __attribute__((section("sfrs")));
extern volatile unsigned int        ETHPMM0CLR __attribute__((section("sfrs")));
extern volatile unsigned int        ETHPMM0SET __attribute__((section("sfrs")));
extern volatile unsigned int        ETHPMM0INV __attribute__((section("sfrs")));
extern volatile unsigned int        ETHPMM1 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned w:32;
  };
  struct {
    unsigned PMMUPPER:32;
  };
} __ETHPMM1bits_t;
extern volatile __ETHPMM1bits_t ETHPMM1bits __asm__ ("ETHPMM1") __attribute__((section("sfrs")));
extern volatile unsigned int        ETHPMM1CLR __attribute__((section("sfrs")));
extern volatile unsigned int        ETHPMM1SET __attribute__((section("sfrs")));
extern volatile unsigned int        ETHPMM1INV __attribute__((section("sfrs")));
extern volatile unsigned int        ETHPMCS __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned PMCS:16;
  };
  struct {
    unsigned w:32;
  };
} __ETHPMCSbits_t;
extern volatile __ETHPMCSbits_t ETHPMCSbits __asm__ ("ETHPMCS") __attribute__((section("sfrs")));
extern volatile unsigned int        ETHPMCSCLR __attribute__((section("sfrs")));
extern volatile unsigned int        ETHPMCSSET __attribute__((section("sfrs")));
extern volatile unsigned int        ETHPMCSINV __attribute__((section("sfrs")));
extern volatile unsigned int        ETHPMO __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned PMO:16;
  };
  struct {
    unsigned w:32;
  };
} __ETHPMObits_t;
extern volatile __ETHPMObits_t ETHPMObits __asm__ ("ETHPMO") __attribute__((section("sfrs")));
extern volatile unsigned int        ETHPMOCLR __attribute__((section("sfrs")));
extern volatile unsigned int        ETHPMOSET __attribute__((section("sfrs")));
extern volatile unsigned int        ETHPMOINV __attribute__((section("sfrs")));
extern volatile unsigned int        ETHRXFC __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned BCEN:1;
    unsigned MCEN:1;
    unsigned NOTMEEN:1;
    unsigned UCEN:1;
    unsigned RUNTEN:1;
    unsigned RUNTERREN:1;
    unsigned CRCOKEN:1;
    unsigned CRCERREN:1;
    unsigned PMMODE:4;
    unsigned NOTPM:1;
    unsigned :1;
    unsigned MPEN:1;
    unsigned HTEN:1;
  };
  struct {
    unsigned w:32;
  };
} __ETHRXFCbits_t;
extern volatile __ETHRXFCbits_t ETHRXFCbits __asm__ ("ETHRXFC") __attribute__((section("sfrs")));
extern volatile unsigned int        ETHRXFCCLR __attribute__((section("sfrs")));
extern volatile unsigned int        ETHRXFCSET __attribute__((section("sfrs")));
extern volatile unsigned int        ETHRXFCINV __attribute__((section("sfrs")));
extern volatile unsigned int        ETHRXWM __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RXEWM:8;
    unsigned :8;
    unsigned RXFWM:8;
  };
  struct {
    unsigned w:32;
  };
} __ETHRXWMbits_t;
extern volatile __ETHRXWMbits_t ETHRXWMbits __asm__ ("ETHRXWM") __attribute__((section("sfrs")));
extern volatile unsigned int        ETHRXWMCLR __attribute__((section("sfrs")));
extern volatile unsigned int        ETHRXWMSET __attribute__((section("sfrs")));
extern volatile unsigned int        ETHRXWMINV __attribute__((section("sfrs")));
extern volatile unsigned int        ETHIEN __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RXOVFLWIE:1;
    unsigned RXBUFNAIE:1;
    unsigned TXABORTIE:1;
    unsigned TXDONEIE:1;
    unsigned :1;
    unsigned RXACTIE:1;
    unsigned PKTPENDIE:1;
    unsigned RXDONEIE:1;
    unsigned FWMARKIE:1;
    unsigned EWMARKIE:1;
    unsigned :3;
    unsigned RXBUSEIE:1;
    unsigned TXBUSEIE:1;
  };
  struct {
    unsigned w:32;
  };
} __ETHIENbits_t;
extern volatile __ETHIENbits_t ETHIENbits __asm__ ("ETHIEN") __attribute__((section("sfrs")));
extern volatile unsigned int        ETHIENCLR __attribute__((section("sfrs")));
extern volatile unsigned int        ETHIENSET __attribute__((section("sfrs")));
extern volatile unsigned int        ETHIENINV __attribute__((section("sfrs")));
extern volatile unsigned int        ETHIRQ __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RXOVFLW:1;
    unsigned RXBUFNA:1;
    unsigned TXABORT:1;
    unsigned TXDONE:1;
    unsigned :1;
    unsigned RXACT:1;
    unsigned PKTPEND:1;
    unsigned RXDONE:1;
    unsigned FWMARK:1;
    unsigned EWMARK:1;
    unsigned :3;
    unsigned RXBUSE:1;
    unsigned TXBUSE:1;
  };
  struct {
    unsigned w:32;
  };
} __ETHIRQbits_t;
extern volatile __ETHIRQbits_t ETHIRQbits __asm__ ("ETHIRQ") __attribute__((section("sfrs")));
extern volatile unsigned int        ETHIRQCLR __attribute__((section("sfrs")));
extern volatile unsigned int        ETHIRQSET __attribute__((section("sfrs")));
extern volatile unsigned int        ETHIRQINV __attribute__((section("sfrs")));
extern volatile unsigned int        ETHSTAT __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned :5;
    unsigned RXBUSY:1;
    unsigned TXBUSY:1;
    unsigned BUSY:1;
    unsigned :8;
    unsigned BUFCNT:8;
  };
  struct {
    unsigned :7;
    unsigned ETHBUSY:1;
  };
  struct {
    unsigned w:32;
  };
} __ETHSTATbits_t;
extern volatile __ETHSTATbits_t ETHSTATbits __asm__ ("ETHSTAT") __attribute__((section("sfrs")));
extern volatile unsigned int        ETHSTATCLR __attribute__((section("sfrs")));
extern volatile unsigned int        ETHSTATSET __attribute__((section("sfrs")));
extern volatile unsigned int        ETHSTATINV __attribute__((section("sfrs")));
extern volatile unsigned int        ETHRXOVFLOW __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RXOVFLWCNT:16;
  };
  struct {
    unsigned w:32;
  };
} __ETHRXOVFLOWbits_t;
extern volatile __ETHRXOVFLOWbits_t ETHRXOVFLOWbits __asm__ ("ETHRXOVFLOW") __attribute__((section("sfrs")));
extern volatile unsigned int        ETHRXOVFLOWCLR __attribute__((section("sfrs")));
extern volatile unsigned int        ETHRXOVFLOWSET __attribute__((section("sfrs")));
extern volatile unsigned int        ETHRXOVFLOWINV __attribute__((section("sfrs")));
extern volatile unsigned int        ETHFRMTXOK __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned FRMTXOKCNT:16;
  };
  struct {
    unsigned w:32;
  };
} __ETHFRMTXOKbits_t;
extern volatile __ETHFRMTXOKbits_t ETHFRMTXOKbits __asm__ ("ETHFRMTXOK") __attribute__((section("sfrs")));
extern volatile unsigned int        ETHFRMTXOKCLR __attribute__((section("sfrs")));
extern volatile unsigned int        ETHFRMTXOKSET __attribute__((section("sfrs")));
extern volatile unsigned int        ETHFRMTXOKINV __attribute__((section("sfrs")));
extern volatile unsigned int        ETHSCOLFRM __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned SCOLFRMCNT:16;
  };
  struct {
    unsigned w:32;
  };
} __ETHSCOLFRMbits_t;
extern volatile __ETHSCOLFRMbits_t ETHSCOLFRMbits __asm__ ("ETHSCOLFRM") __attribute__((section("sfrs")));
extern volatile unsigned int        ETHSCOLFRMCLR __attribute__((section("sfrs")));
extern volatile unsigned int        ETHSCOLFRMSET __attribute__((section("sfrs")));
extern volatile unsigned int        ETHSCOLFRMINV __attribute__((section("sfrs")));
extern volatile unsigned int        ETHMCOLFRM __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned MCOLFRMCNT:16;
  };
  struct {
    unsigned MCOLFRM_CNT:16;
  };
  struct {
    unsigned w:32;
  };
} __ETHMCOLFRMbits_t;
extern volatile __ETHMCOLFRMbits_t ETHMCOLFRMbits __asm__ ("ETHMCOLFRM") __attribute__((section("sfrs")));
extern volatile unsigned int        ETHMCOLFRMCLR __attribute__((section("sfrs")));
extern volatile unsigned int        ETHMCOLFRMSET __attribute__((section("sfrs")));
extern volatile unsigned int        ETHMCOLFRMINV __attribute__((section("sfrs")));
extern volatile unsigned int        ETHFRMRXOK __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned FRMRXOKCNT:16;
  };
  struct {
    unsigned w:32;
  };
} __ETHFRMRXOKbits_t;
extern volatile __ETHFRMRXOKbits_t ETHFRMRXOKbits __asm__ ("ETHFRMRXOK") __attribute__((section("sfrs")));
extern volatile unsigned int        ETHFRMRXOKCLR __attribute__((section("sfrs")));
extern volatile unsigned int        ETHFRMRXOKSET __attribute__((section("sfrs")));
extern volatile unsigned int        ETHFRMRXOKINV __attribute__((section("sfrs")));
extern volatile unsigned int        ETHFCSERR __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned FCSERRCNT:16;
  };
  struct {
    unsigned w:32;
  };
} __ETHFCSERRbits_t;
extern volatile __ETHFCSERRbits_t ETHFCSERRbits __asm__ ("ETHFCSERR") __attribute__((section("sfrs")));
extern volatile unsigned int        ETHFCSERRCLR __attribute__((section("sfrs")));
extern volatile unsigned int        ETHFCSERRSET __attribute__((section("sfrs")));
extern volatile unsigned int        ETHFCSERRINV __attribute__((section("sfrs")));
extern volatile unsigned int        ETHALGNERR __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned ALGNERRCNT:16;
  };
  struct {
    unsigned w:32;
  };
} __ETHALGNERRbits_t;
extern volatile __ETHALGNERRbits_t ETHALGNERRbits __asm__ ("ETHALGNERR") __attribute__((section("sfrs")));
extern volatile unsigned int        ETHALGNERRCLR __attribute__((section("sfrs")));
extern volatile unsigned int        ETHALGNERRSET __attribute__((section("sfrs")));
extern volatile unsigned int        ETHALGNERRINV __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1CFG1 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RXENABLE:1;
    unsigned PASSALL:1;
    unsigned RXPAUSE:1;
    unsigned TXPAUSE:1;
    unsigned LOOPBACK:1;
    unsigned :3;
    unsigned RESETTFUN:1;
    unsigned RESETTMCS:1;
    unsigned RESETRFUN:1;
    unsigned RESETRMCS:1;
    unsigned :2;
    unsigned SIMRESET:1;
    unsigned SOFTRESET:1;
  };
  struct {
    unsigned w:32;
  };
} __EMAC1CFG1bits_t;
extern volatile __EMAC1CFG1bits_t EMAC1CFG1bits __asm__ ("EMAC1CFG1") __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxCFG1 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RXENABLE:1;
    unsigned PASSALL:1;
    unsigned RXPAUSE:1;
    unsigned TXPAUSE:1;
    unsigned LOOPBACK:1;
    unsigned :3;
    unsigned RESETTFUN:1;
    unsigned RESETTMCS:1;
    unsigned RESETRFUN:1;
    unsigned RESETRMCS:1;
    unsigned :2;
    unsigned SIMRESET:1;
    unsigned SOFTRESET:1;
  };
  struct {
    unsigned w:32;
  };
} __EMACxCFG1bits_t;
extern volatile __EMACxCFG1bits_t EMACxCFG1bits __asm__ ("EMACxCFG1") __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1CFG1CLR __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxCFG1CLR __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1CFG1SET __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxCFG1SET __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1CFG1INV __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxCFG1INV __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1CFG2 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned FULLDPLX:1;
    unsigned LENGTHCK:1;
    unsigned HUGEFRM:1;
    unsigned DELAYCRC:1;
    unsigned CRCENABLE:1;
    unsigned PADENABLE:1;
    unsigned VLANPAD:1;
    unsigned AUTOPAD:1;
    unsigned PUREPRE:1;
    unsigned LONGPRE:1;
    unsigned :2;
    unsigned NOBKOFF:1;
    unsigned BPNOBKOFF:1;
    unsigned EXCESSDFR:1;
  };
  struct {
    unsigned w:32;
  };
} __EMAC1CFG2bits_t;
extern volatile __EMAC1CFG2bits_t EMAC1CFG2bits __asm__ ("EMAC1CFG2") __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxCFG2 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned FULLDPLX:1;
    unsigned LENGTHCK:1;
    unsigned HUGEFRM:1;
    unsigned DELAYCRC:1;
    unsigned CRCENABLE:1;
    unsigned PADENABLE:1;
    unsigned VLANPAD:1;
    unsigned AUTOPAD:1;
    unsigned PUREPRE:1;
    unsigned LONGPRE:1;
    unsigned :2;
    unsigned NOBKOFF:1;
    unsigned BPNOBKOFF:1;
    unsigned EXCESSDFR:1;
  };
  struct {
    unsigned w:32;
  };
} __EMACxCFG2bits_t;
extern volatile __EMACxCFG2bits_t EMACxCFG2bits __asm__ ("EMACxCFG2") __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1CFG2CLR __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxCFG2CLR __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1CFG2SET __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxCFG2SET __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1CFG2INV __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxCFG2INV __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1IPGT __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned B2BIPKTGP:7;
  };
  struct {
    unsigned w:32;
  };
} __EMAC1IPGTbits_t;
extern volatile __EMAC1IPGTbits_t EMAC1IPGTbits __asm__ ("EMAC1IPGT") __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxIPGT __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned B2BIPKTGP:7;
  };
  struct {
    unsigned w:32;
  };
} __EMACxIPGTbits_t;
extern volatile __EMACxIPGTbits_t EMACxIPGTbits __asm__ ("EMACxIPGT") __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1IPGTCLR __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxIPGTCLR __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1IPGTSET __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxIPGTSET __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1IPGTINV __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxIPGTINV __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1IPGR __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned NB2BIPKTGP2:7;
    unsigned :1;
    unsigned NB2BIPKTGP1:7;
  };
  struct {
    unsigned w:32;
  };
} __EMAC1IPGRbits_t;
extern volatile __EMAC1IPGRbits_t EMAC1IPGRbits __asm__ ("EMAC1IPGR") __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxIPGR __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned NB2BIPKTGP2:7;
    unsigned :1;
    unsigned NB2BIPKTGP1:7;
  };
  struct {
    unsigned w:32;
  };
} __EMACxIPGRbits_t;
extern volatile __EMACxIPGRbits_t EMACxIPGRbits __asm__ ("EMACxIPGR") __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1IPGRCLR __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxIPGRCLR __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1IPGRSET __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxIPGRSET __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1IPGRINV __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxIPGRINV __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1CLRT __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RETX:4;
    unsigned :4;
    unsigned CWINDOW:6;
  };
  struct {
    unsigned w:32;
  };
} __EMAC1CLRTbits_t;
extern volatile __EMAC1CLRTbits_t EMAC1CLRTbits __asm__ ("EMAC1CLRT") __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxCLRT __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RETX:4;
    unsigned :4;
    unsigned CWINDOW:6;
  };
  struct {
    unsigned w:32;
  };
} __EMACxCLRTbits_t;
extern volatile __EMACxCLRTbits_t EMACxCLRTbits __asm__ ("EMACxCLRT") __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1CLRTCLR __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxCLRTCLR __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1CLRTSET __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxCLRTSET __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1CLRTINV __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxCLRTINV __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1MAXF __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned MACMAXF:16;
  };
  struct {
    unsigned w:32;
  };
} __EMAC1MAXFbits_t;
extern volatile __EMAC1MAXFbits_t EMAC1MAXFbits __asm__ ("EMAC1MAXF") __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxMAXF __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned MACMAXF:16;
  };
  struct {
    unsigned w:32;
  };
} __EMACxMAXFbits_t;
extern volatile __EMACxMAXFbits_t EMACxMAXFbits __asm__ ("EMACxMAXF") __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1MAXFCLR __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxMAXFCLR __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1MAXFSET __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxMAXFSET __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1MAXFINV __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxMAXFINV __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1SUPP __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned :8;
    unsigned SPEEDRMII:1;
    unsigned :2;
    unsigned RESETRMII:1;
  };
  struct {
    unsigned w:32;
  };
} __EMAC1SUPPbits_t;
extern volatile __EMAC1SUPPbits_t EMAC1SUPPbits __asm__ ("EMAC1SUPP") __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxSUPP __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned :8;
    unsigned SPEEDRMII:1;
    unsigned :2;
    unsigned RESETRMII:1;
  };
  struct {
    unsigned w:32;
  };
} __EMACxSUPPbits_t;
extern volatile __EMACxSUPPbits_t EMACxSUPPbits __asm__ ("EMACxSUPP") __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1SUPPCLR __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxSUPPCLR __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1SUPPSET __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxSUPPSET __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1SUPPINV __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxSUPPINV __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1TEST __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned SHRTQNTA:1;
    unsigned TESTPAUSE:1;
    unsigned TESTBP:1;
  };
  struct {
    unsigned w:32;
  };
} __EMAC1TESTbits_t;
extern volatile __EMAC1TESTbits_t EMAC1TESTbits __asm__ ("EMAC1TEST") __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxTEST __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned SHRTQNTA:1;
    unsigned TESTPAUSE:1;
    unsigned TESTBP:1;
  };
  struct {
    unsigned w:32;
  };
} __EMACxTESTbits_t;
extern volatile __EMACxTESTbits_t EMACxTESTbits __asm__ ("EMACxTEST") __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1TESTCLR __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxTESTCLR __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1TESTSET __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxTESTSET __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1TESTINV __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxTESTINV __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1MCFG __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned SCANINC:1;
    unsigned NOPRE:1;
    unsigned CLKSEL:4;
    unsigned :9;
    unsigned RESETMGMT:1;
  };
  struct {
    unsigned w:32;
  };
} __EMAC1MCFGbits_t;
extern volatile __EMAC1MCFGbits_t EMAC1MCFGbits __asm__ ("EMAC1MCFG") __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxMCFG __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned SCANINC:1;
    unsigned NOPRE:1;
    unsigned CLKSEL:4;
    unsigned :9;
    unsigned RESETMGMT:1;
  };
  struct {
    unsigned w:32;
  };
} __EMACxMCFGbits_t;
extern volatile __EMACxMCFGbits_t EMACxMCFGbits __asm__ ("EMACxMCFG") __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1MCFGCLR __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxMCFGCLR __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1MCFGSET __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxMCFGSET __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1MCFGINV __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxMCFGINV __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1MCMD __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned READ:1;
    unsigned SCAN:1;
  };
  struct {
    unsigned w:32;
  };
} __EMAC1MCMDbits_t;
extern volatile __EMAC1MCMDbits_t EMAC1MCMDbits __asm__ ("EMAC1MCMD") __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxMCMD __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned READ:1;
    unsigned SCAN:1;
  };
  struct {
    unsigned w:32;
  };
} __EMACxMCMDbits_t;
extern volatile __EMACxMCMDbits_t EMACxMCMDbits __asm__ ("EMACxMCMD") __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1MCMDCLR __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxMCMDCLR __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1MCMDSET __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxMCMDSET __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1MCMDINV __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxMCMDINV __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1MADR __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned REGADDR:5;
    unsigned :3;
    unsigned PHYADDR:5;
  };
  struct {
    unsigned w:32;
  };
} __EMAC1MADRbits_t;
extern volatile __EMAC1MADRbits_t EMAC1MADRbits __asm__ ("EMAC1MADR") __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxMADR __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned REGADDR:5;
    unsigned :3;
    unsigned PHYADDR:5;
  };
  struct {
    unsigned w:32;
  };
} __EMACxMADRbits_t;
extern volatile __EMACxMADRbits_t EMACxMADRbits __asm__ ("EMACxMADR") __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1MADRCLR __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxMADRCLR __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1MADRSET __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxMADRSET __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1MADRINV __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxMADRINV __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1MWTD __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned MWTD:16;
  };
  struct {
    unsigned w:32;
  };
} __EMAC1MWTDbits_t;
extern volatile __EMAC1MWTDbits_t EMAC1MWTDbits __asm__ ("EMAC1MWTD") __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxMWTD __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned MWTD:16;
  };
  struct {
    unsigned w:32;
  };
} __EMACxMWTDbits_t;
extern volatile __EMACxMWTDbits_t EMACxMWTDbits __asm__ ("EMACxMWTD") __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1MWTDCLR __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxMWTDCLR __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1MWTDSET __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxMWTDSET __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1MWTDINV __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxMWTDINV __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1MRDD __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned MRDD:16;
  };
  struct {
    unsigned w:32;
  };
} __EMAC1MRDDbits_t;
extern volatile __EMAC1MRDDbits_t EMAC1MRDDbits __asm__ ("EMAC1MRDD") __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxMRDD __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned MRDD:16;
  };
  struct {
    unsigned w:32;
  };
} __EMACxMRDDbits_t;
extern volatile __EMACxMRDDbits_t EMACxMRDDbits __asm__ ("EMACxMRDD") __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1MRDDCLR __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxMRDDCLR __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1MRDDSET __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxMRDDSET __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1MRDDINV __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxMRDDINV __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1MIND __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned MIIMBUSY:1;
    unsigned SCAN:1;
    unsigned NOTVALID:1;
    unsigned LINKFAIL:1;
  };
  struct {
    unsigned w:32;
  };
} __EMAC1MINDbits_t;
extern volatile __EMAC1MINDbits_t EMAC1MINDbits __asm__ ("EMAC1MIND") __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxMIND __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned MIIMBUSY:1;
    unsigned SCAN:1;
    unsigned NOTVALID:1;
    unsigned LINKFAIL:1;
  };
  struct {
    unsigned w:32;
  };
} __EMACxMINDbits_t;
extern volatile __EMACxMINDbits_t EMACxMINDbits __asm__ ("EMACxMIND") __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1MINDCLR __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxMINDCLR __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1MINDSET __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxMINDSET __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1MINDINV __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxMINDINV __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1SA0 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned STNADDR5:8;
    unsigned STNADDR6:8;
  };
  struct {
    unsigned w:32;
  };
} __EMAC1SA0bits_t;
extern volatile __EMAC1SA0bits_t EMAC1SA0bits __asm__ ("EMAC1SA0") __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxSA0 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned STNADDR5:8;
    unsigned STNADDR6:8;
  };
  struct {
    unsigned w:32;
  };
} __EMACxSA0bits_t;
extern volatile __EMACxSA0bits_t EMACxSA0bits __asm__ ("EMACxSA0") __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1SA0CLR __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxSA0CLR __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1SA0SET __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxSA0SET __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1SA0INV __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxSA0INV __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1SA1 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned STNADDR3:8;
    unsigned STNADDR4:8;
  };
  struct {
    unsigned w:32;
  };
} __EMAC1SA1bits_t;
extern volatile __EMAC1SA1bits_t EMAC1SA1bits __asm__ ("EMAC1SA1") __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxSA1 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned STNADDR3:8;
    unsigned STNADDR4:8;
  };
  struct {
    unsigned w:32;
  };
} __EMACxSA1bits_t;
extern volatile __EMACxSA1bits_t EMACxSA1bits __asm__ ("EMACxSA1") __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1SA1CLR __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxSA1CLR __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1SA1SET __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxSA1SET __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1SA1INV __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxSA1INV __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1SA2 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned STNADDR1:8;
    unsigned STNADDR2:8;
  };
  struct {
    unsigned w:32;
  };
} __EMAC1SA2bits_t;
extern volatile __EMAC1SA2bits_t EMAC1SA2bits __asm__ ("EMAC1SA2") __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxSA2 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned STNADDR1:8;
    unsigned STNADDR2:8;
  };
  struct {
    unsigned w:32;
  };
} __EMACxSA2bits_t;
extern volatile __EMACxSA2bits_t EMACxSA2bits __asm__ ("EMACxSA2") __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1SA2CLR __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxSA2CLR __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1SA2SET __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxSA2SET __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1SA2INV __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxSA2INV __attribute__((section("sfrs")));
extern volatile unsigned int        PRECON __attribute__((section("sfrs")));
typedef struct {
  unsigned PFMWS:3;
  unsigned :1;
  unsigned PREFEN:2;
  unsigned :20;
  unsigned PFMSECEN:1;
} __PRECONbits_t;
extern volatile __PRECONbits_t PRECONbits __asm__ ("PRECON") __attribute__((section("sfrs")));
extern volatile unsigned int        PRECONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        PRECONSET __attribute__((section("sfrs")));
extern volatile unsigned int        PRECONINV __attribute__((section("sfrs")));
extern volatile unsigned int        PRESTAT __attribute__((section("sfrs")));
typedef struct {
  unsigned PFMSECCNT:8;
  unsigned :18;
  unsigned PFMSEC:1;
  unsigned PFMDED:1;
} __PRESTATbits_t;
extern volatile __PRESTATbits_t PRESTATbits __asm__ ("PRESTAT") __attribute__((section("sfrs")));
extern volatile unsigned int        PRESTATCLR __attribute__((section("sfrs")));
extern volatile unsigned int        PRESTATSET __attribute__((section("sfrs")));
extern volatile unsigned int        PRESTATINV __attribute__((section("sfrs")));
extern volatile unsigned int        EBICS0 __attribute__((section("sfrs")));
typedef struct {
  unsigned :16;
  unsigned CSADDR:16;
} __EBICS0bits_t;
extern volatile __EBICS0bits_t EBICS0bits __asm__ ("EBICS0") __attribute__((section("sfrs")));
extern volatile unsigned int        EBICS1 __attribute__((section("sfrs")));
typedef struct {
  unsigned :16;
  unsigned CSADDR:16;
} __EBICS1bits_t;
extern volatile __EBICS1bits_t EBICS1bits __asm__ ("EBICS1") __attribute__((section("sfrs")));
extern volatile unsigned int        EBICS2 __attribute__((section("sfrs")));
typedef struct {
  unsigned :16;
  unsigned CSADDR:16;
} __EBICS2bits_t;
extern volatile __EBICS2bits_t EBICS2bits __asm__ ("EBICS2") __attribute__((section("sfrs")));
extern volatile unsigned int        EBICS3 __attribute__((section("sfrs")));
typedef struct {
  unsigned :16;
  unsigned CSADDR:16;
} __EBICS3bits_t;
extern volatile __EBICS3bits_t EBICS3bits __asm__ ("EBICS3") __attribute__((section("sfrs")));
extern volatile unsigned int        EBIMSK0 __attribute__((section("sfrs")));
typedef struct {
  unsigned MEMSIZE:5;
  unsigned MEMTYPE:3;
  unsigned REGSEL:3;
} __EBIMSK0bits_t;
extern volatile __EBIMSK0bits_t EBIMSK0bits __asm__ ("EBIMSK0") __attribute__((section("sfrs")));
extern volatile unsigned int        EBIMSK1 __attribute__((section("sfrs")));
typedef struct {
  unsigned MEMSIZE:5;
  unsigned MEMTYPE:3;
  unsigned REGSEL:3;
} __EBIMSK1bits_t;
extern volatile __EBIMSK1bits_t EBIMSK1bits __asm__ ("EBIMSK1") __attribute__((section("sfrs")));
extern volatile unsigned int        EBIMSK2 __attribute__((section("sfrs")));
typedef struct {
  unsigned MEMSIZE:5;
  unsigned MEMTYPE:3;
  unsigned REGSEL:3;
} __EBIMSK2bits_t;
extern volatile __EBIMSK2bits_t EBIMSK2bits __asm__ ("EBIMSK2") __attribute__((section("sfrs")));
extern volatile unsigned int        EBIMSK3 __attribute__((section("sfrs")));
typedef struct {
  unsigned MEMSIZE:5;
  unsigned MEMTYPE:3;
  unsigned REGSEL:3;
} __EBIMSK3bits_t;
extern volatile __EBIMSK3bits_t EBIMSK3bits __asm__ ("EBIMSK3") __attribute__((section("sfrs")));
extern volatile unsigned int        EBISMT0 __attribute__((section("sfrs")));
typedef struct {
  unsigned TRC:6;
  unsigned TAS:2;
  unsigned TWR:2;
  unsigned TWP:6;
  unsigned TBTA:3;
  unsigned TPRC:4;
  unsigned PAGEMODE:1;
  unsigned PAGESIZE:2;
  unsigned RDYMODE:1;
} __EBISMT0bits_t;
extern volatile __EBISMT0bits_t EBISMT0bits __asm__ ("EBISMT0") __attribute__((section("sfrs")));
extern volatile unsigned int        EBISMT1 __attribute__((section("sfrs")));
typedef struct {
  unsigned TRC:6;
  unsigned TAS:2;
  unsigned TWR:2;
  unsigned TWP:6;
  unsigned TBTA:3;
  unsigned TPRC:4;
  unsigned PAGEMODE:1;
  unsigned PAGESIZE:2;
  unsigned RDYMODE:1;
} __EBISMT1bits_t;
extern volatile __EBISMT1bits_t EBISMT1bits __asm__ ("EBISMT1") __attribute__((section("sfrs")));
extern volatile unsigned int        EBISMT2 __attribute__((section("sfrs")));
typedef struct {
  unsigned TRC:6;
  unsigned TAS:2;
  unsigned TWR:2;
  unsigned TWP:6;
  unsigned TBTA:3;
  unsigned TPRC:4;
  unsigned PAGEMODE:1;
  unsigned PAGESIZE:2;
  unsigned RDYMODE:1;
} __EBISMT2bits_t;
extern volatile __EBISMT2bits_t EBISMT2bits __asm__ ("EBISMT2") __attribute__((section("sfrs")));
extern volatile unsigned int        EBIFTRPD __attribute__((section("sfrs")));
typedef struct {
  unsigned TRPD:32;
} __EBIFTRPDbits_t;
extern volatile __EBIFTRPDbits_t EBIFTRPDbits __asm__ ("EBIFTRPD") __attribute__((section("sfrs")));
extern volatile unsigned int        EBISMCON __attribute__((section("sfrs")));
typedef struct {
  unsigned SMRP:1;
  unsigned :6;
  unsigned SMDWIDTH0:3;
  unsigned SMDWIDTH1:3;
  unsigned SMDWIDTH2:3;
} __EBISMCONbits_t;
extern volatile __EBISMCONbits_t EBISMCONbits __asm__ ("EBISMCON") __attribute__((section("sfrs")));
extern volatile unsigned int        SQI1XCON1 __attribute__((section("sfrs")));
typedef struct {
  unsigned TYPECMD:2;
  unsigned TYPEADDR:2;
  unsigned TYPEMODE:2;
  unsigned TYPEDUMMY:2;
  unsigned TYPEDATA:2;
  unsigned READOPCODE:8;
  unsigned ADDRBYTES:3;
  unsigned DUMMYBYTES:3;
} __SQI1XCON1bits_t;
extern volatile __SQI1XCON1bits_t SQI1XCON1bits __asm__ ("SQI1XCON1") __attribute__((section("sfrs")));
extern volatile unsigned int        SQI1XCON2 __attribute__((section("sfrs")));
typedef struct {
  unsigned MODECODE:8;
  unsigned MODEBYTES:2;
  unsigned DEVSEL:2;
} __SQI1XCON2bits_t;
extern volatile __SQI1XCON2bits_t SQI1XCON2bits __asm__ ("SQI1XCON2") __attribute__((section("sfrs")));
extern volatile unsigned int        SQI1CFG __attribute__((section("sfrs")));
typedef struct {
  unsigned MODE:3;
  unsigned CPHA:1;
  unsigned CPOL:1;
  unsigned LSBF:1;
  unsigned RXLATCH:1;
  unsigned SERMODE:1;
  unsigned WP:1;
  unsigned HOLD:1;
  unsigned :1;
  unsigned BURSTEN:1;
  unsigned :2;
  unsigned RESET:1;
  unsigned :3;
  unsigned DATAEN:2;
  unsigned :2;
  unsigned CSEN:2;
  unsigned :5;
  unsigned SQIEN:1;
} __SQI1CFGbits_t;
extern volatile __SQI1CFGbits_t SQI1CFGbits __asm__ ("SQI1CFG") __attribute__((section("sfrs")));
extern volatile unsigned int        SQI1CON __attribute__((section("sfrs")));
typedef struct {
  unsigned TXRXCOUNT:16;
  unsigned CMDINIT:2;
  unsigned LANEMODE:2;
  unsigned DEVSEL:2;
  unsigned DASSERT:1;
} __SQI1CONbits_t;
extern volatile __SQI1CONbits_t SQI1CONbits __asm__ ("SQI1CON") __attribute__((section("sfrs")));
extern volatile unsigned int        SQI1CLKCON __attribute__((section("sfrs")));
typedef struct {
  unsigned EN:1;
  unsigned STABLE:1;
  unsigned :6;
  unsigned CLKDIV:8;
} __SQI1CLKCONbits_t;
extern volatile __SQI1CLKCONbits_t SQI1CLKCONbits __asm__ ("SQI1CLKCON") __attribute__((section("sfrs")));
extern volatile unsigned int        SQI1CMDTHR __attribute__((section("sfrs")));
typedef struct {
  unsigned RXCMDTHR:5;
  unsigned :3;
  unsigned TXCMDTHR:5;
} __SQI1CMDTHRbits_t;
extern volatile __SQI1CMDTHRbits_t SQI1CMDTHRbits __asm__ ("SQI1CMDTHR") __attribute__((section("sfrs")));
extern volatile unsigned int        SQI1INTTHR __attribute__((section("sfrs")));
typedef struct {
  unsigned RXINTTHR:5;
  unsigned :3;
  unsigned TXINTTHR:5;
} __SQI1INTTHRbits_t;
extern volatile __SQI1INTTHRbits_t SQI1INTTHRbits __asm__ ("SQI1INTTHR") __attribute__((section("sfrs")));
extern volatile unsigned int        SQI1INTEN __attribute__((section("sfrs")));
typedef struct {
  unsigned TXEMPTYIE:1;
  unsigned TXFULLIE:1;
  unsigned TXTHRIE:1;
  unsigned RXEMPTYIE:1;
  unsigned RXFULLIE:1;
  unsigned RXTHRIE:1;
  unsigned CONFULLIE:1;
  unsigned CONEMPTYIE:1;
  unsigned CONTHRIE:1;
  unsigned BDDONEIE:1;
  unsigned PKTCOMPIE:1;
} __SQI1INTENbits_t;
extern volatile __SQI1INTENbits_t SQI1INTENbits __asm__ ("SQI1INTEN") __attribute__((section("sfrs")));
extern volatile unsigned int        SQI1INTSTAT __attribute__((section("sfrs")));
typedef struct {
  unsigned TXEMPTYIF:1;
  unsigned TXFULLIF:1;
  unsigned TXTHRIF:1;
  unsigned RXEMPTYIF:1;
  unsigned RXFULLIF:1;
  unsigned RXTHRIF:1;
  unsigned CONFULLIF:1;
  unsigned CONEMPTYIF:1;
  unsigned CONTHRIF:1;
  unsigned BDDONEIF:1;
  unsigned PKTCOMPIF:1;
} __SQI1INTSTATbits_t;
extern volatile __SQI1INTSTATbits_t SQI1INTSTATbits __asm__ ("SQI1INTSTAT") __attribute__((section("sfrs")));
extern volatile unsigned int        SQI1TXBUF __attribute__((section("sfrs")));
typedef struct {
  unsigned TXDATA:32;
} __SQI1TXBUFbits_t;
extern volatile __SQI1TXBUFbits_t SQI1TXBUFbits __asm__ ("SQI1TXBUF") __attribute__((section("sfrs")));
extern volatile unsigned int        SQI1RXBUF __attribute__((section("sfrs")));
typedef struct {
  unsigned RXDATA:32;
} __SQI1RXBUFbits_t;
extern volatile __SQI1RXBUFbits_t SQI1RXBUFbits __asm__ ("SQI1RXBUF") __attribute__((section("sfrs")));
extern volatile unsigned int        SQI1STAT1 __attribute__((section("sfrs")));
typedef struct {
  unsigned RXBUFCNT:8;
  unsigned :8;
  unsigned TXBUFFREE:8;
} __SQI1STAT1bits_t;
extern volatile __SQI1STAT1bits_t SQI1STAT1bits __asm__ ("SQI1STAT1") __attribute__((section("sfrs")));
extern volatile unsigned int        SQI1STAT2 __attribute__((section("sfrs")));
typedef struct {
  unsigned TXOV:1;
  unsigned RXUN:1;
  unsigned :1;
  unsigned SQID0:1;
  unsigned SQID1:1;
  unsigned SQID2:1;
  unsigned SQID3:1;
} __SQI1STAT2bits_t;
extern volatile __SQI1STAT2bits_t SQI1STAT2bits __asm__ ("SQI1STAT2") __attribute__((section("sfrs")));
extern volatile unsigned int        SQI1BDCON __attribute__((section("sfrs")));
typedef struct {
  unsigned DMAEN:1;
  unsigned POLLEN:1;
  unsigned START:1;
} __SQI1BDCONbits_t;
extern volatile __SQI1BDCONbits_t SQI1BDCONbits __asm__ ("SQI1BDCON") __attribute__((section("sfrs")));
extern volatile unsigned int        SQI1BDCURADD __attribute__((section("sfrs")));
typedef struct {
  unsigned BDCURRADDR:32;
} __SQI1BDCURADDbits_t;
extern volatile __SQI1BDCURADDbits_t SQI1BDCURADDbits __asm__ ("SQI1BDCURADD") __attribute__((section("sfrs")));
extern volatile unsigned int        SQI1BDBASEADDR __attribute__((section("sfrs")));
typedef struct {
  unsigned BDADDR:32;
} __SQI1BDBASEADDRbits_t;
extern volatile __SQI1BDBASEADDRbits_t SQI1BDBASEADDRbits __asm__ ("SQI1BDBASEADDR") __attribute__((section("sfrs")));
extern volatile unsigned int        SQI1BDSTAT __attribute__((section("sfrs")));
typedef struct {
  unsigned BDCON:16;
  unsigned DMAACTV:1;
  unsigned DMASTART:1;
  unsigned BDSTATE:4;
} __SQI1BDSTATbits_t;
extern volatile __SQI1BDSTATbits_t SQI1BDSTATbits __asm__ ("SQI1BDSTAT") __attribute__((section("sfrs")));
extern volatile unsigned int        SQI1BDPOLLCON __attribute__((section("sfrs")));
typedef struct {
  unsigned POLLCON:16;
} __SQI1BDPOLLCONbits_t;
extern volatile __SQI1BDPOLLCONbits_t SQI1BDPOLLCONbits __asm__ ("SQI1BDPOLLCON") __attribute__((section("sfrs")));
extern volatile unsigned int        SQI1BDTXDSTAT __attribute__((section("sfrs")));
typedef struct {
  unsigned TXCURBUFLEN:8;
  unsigned :8;
  unsigned TXBUFCNT:5;
  unsigned :4;
  unsigned TXSTATE:4;
} __SQI1BDTXDSTATbits_t;
extern volatile __SQI1BDTXDSTATbits_t SQI1BDTXDSTATbits __asm__ ("SQI1BDTXDSTAT") __attribute__((section("sfrs")));
extern volatile unsigned int        SQI1BDRXDSTAT __attribute__((section("sfrs")));
typedef struct {
  unsigned RXCURBUFLEN:8;
  unsigned :8;
  unsigned RXBUFCNT:5;
  unsigned :4;
  unsigned RXSTATE:4;
} __SQI1BDRXDSTATbits_t;
extern volatile __SQI1BDRXDSTATbits_t SQI1BDRXDSTATbits __asm__ ("SQI1BDRXDSTAT") __attribute__((section("sfrs")));
extern volatile unsigned int        SQI1THR __attribute__((section("sfrs")));
typedef struct {
  unsigned THRES:7;
} __SQI1THRbits_t;
extern volatile __SQI1THRbits_t SQI1THRbits __asm__ ("SQI1THR") __attribute__((section("sfrs")));
extern volatile unsigned int        SQI1INTSEN __attribute__((section("sfrs")));
typedef struct {
  unsigned TXEMPTYISE:1;
  unsigned TXFULLISE:1;
  unsigned TXTHRISE:1;
  unsigned RXEMPTYISE:1;
  unsigned RXFULLISE:1;
  unsigned RXTHRISE:1;
  unsigned CONFULLISE:1;
  unsigned CONEMPTYISE:1;
  unsigned CONTHRISE:1;
  unsigned BDDONEISE:1;
  unsigned PKTCOMPISE:1;
} __SQI1INTSENbits_t;
extern volatile __SQI1INTSENbits_t SQI1INTSENbits __asm__ ("SQI1INTSEN") __attribute__((section("sfrs")));
extern volatile unsigned int        USBCSR0 __attribute__((section("sfrs")));
typedef struct {
  unsigned FUNC:7;
  unsigned :1;
  unsigned SUSPEN:1;
  unsigned SUSPMODE:1;
  unsigned RESUME:1;
  unsigned RESET:1;
  unsigned HSMODE:1;
  unsigned HSEN:1;
  unsigned SOFTCONN:1;
  unsigned ISOUPD:1;
  unsigned EP0IF:1;
  unsigned EP1TXIF:1;
  unsigned EP2TXIF:1;
  unsigned EP3TXIF:1;
  unsigned EP4TXIF:1;
  unsigned EP5TXIF:1;
  unsigned EP6TXIF:1;
  unsigned EP7TXIF:1;
} __USBCSR0bits_t;
extern volatile __USBCSR0bits_t USBCSR0bits __asm__ ("USBCSR0") __attribute__((section("sfrs")));
extern volatile unsigned int        USBCSR1 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned EP1RXIF:1;
  unsigned EP2RXIF:1;
  unsigned EP3RXIF:1;
  unsigned EP4RXIF:1;
  unsigned EP5RXIF:1;
  unsigned EP6RXIF:1;
  unsigned EP7RXIF:1;
  unsigned :8;
  unsigned EP0IE:1;
  unsigned EP1TXIE:1;
  unsigned EP2TXIE:1;
  unsigned EP3TXIE:1;
  unsigned EP4TXIE:1;
  unsigned EP5TXIE:1;
  unsigned EP6TXIE:1;
  unsigned EP7TXIE:1;
} __USBCSR1bits_t;
extern volatile __USBCSR1bits_t USBCSR1bits __asm__ ("USBCSR1") __attribute__((section("sfrs")));
extern volatile unsigned int        USBCSR2 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned EP1RXIE:1;
  unsigned EP2RXIE:1;
  unsigned EP3RXIE:1;
  unsigned EP4RXIE:1;
  unsigned EP5RXIE:1;
  unsigned EP6RXIE:1;
  unsigned EP7RXIE:1;
  unsigned :8;
  unsigned SUSPIF:1;
  unsigned RESUMEIF:1;
  unsigned RESETIF:1;
  unsigned SOFIF:1;
  unsigned CONNIF:1;
  unsigned DISCONIF:1;
  unsigned SESSRQIF:1;
  unsigned VBUSERRIF:1;
  unsigned SUSPIE:1;
  unsigned RESUMEIE:1;
  unsigned RESETIE:1;
  unsigned SOFIE:1;
  unsigned CONNIE:1;
  unsigned DISCONIE:1;
  unsigned SESSRQIE:1;
  unsigned VBUSERRIE:1;
} __USBCSR2bits_t;
extern volatile __USBCSR2bits_t USBCSR2bits __asm__ ("USBCSR2") __attribute__((section("sfrs")));
extern volatile unsigned int        USBCSR3 __attribute__((section("sfrs")));
typedef struct {
  unsigned RFRMNUM:11;
  unsigned :5;
  unsigned ENDPOINT:4;
  unsigned :4;
  unsigned NAK:1;
  unsigned TESTJ:1;
  unsigned TESTK:1;
  unsigned PACKET:1;
  unsigned FORCEHS:1;
  unsigned FORCEFS:1;
  unsigned FIFOACC:1;
  unsigned FORCEHST:1;
} __USBCSR3bits_t;
extern volatile __USBCSR3bits_t USBCSR3bits __asm__ ("USBCSR3") __attribute__((section("sfrs")));
extern volatile unsigned int        USBIENCSR0 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TXMAXP:11;
    unsigned MULT:5;
    unsigned TXPKTRDY:1;
    unsigned FIFONE:1;
    unsigned ERROR:1;
    unsigned FLUSH:1;
    unsigned SETUPPKT:1;
    unsigned RXSTALL:1;
    unsigned CLRDT:1;
    unsigned NAKTMOUT:1;
    unsigned DATATGGL:1;
    unsigned DTWREN:1;
    unsigned DMAREQMD:1;
    unsigned FRCDATTG:1;
    unsigned DMAREQEN:1;
    unsigned MODE:1;
    unsigned :1;
    unsigned AUTOSET:1;
  };
  struct {
    unsigned :18;
    unsigned UNDERRUN:1;
    unsigned :1;
    unsigned SENDSTALL:1;
    unsigned SENTSTALL:1;
    unsigned :1;
    unsigned INCOMPTX:1;
    unsigned :6;
    unsigned ISO:1;
  };
} __USBIENCSR0bits_t;
extern volatile __USBIENCSR0bits_t USBIENCSR0bits __asm__ ("USBIENCSR0") __attribute__((section("sfrs")));
extern volatile unsigned int        USBIENCSR1 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RXMAXP:11;
    unsigned MULT:5;
    unsigned RXPKTRDY:1;
    unsigned FIFOFULL:1;
    unsigned ERROR:1;
    unsigned DERRNAKT:1;
    unsigned FLUSH:1;
    unsigned REQPKT:1;
    unsigned RXSTALL:1;
    unsigned CLRDT:1;
    unsigned INCOMPRX:1;
    unsigned DATATGGL:1;
    unsigned DATATWEN:1;
    unsigned DMAREQMD:1;
    unsigned PIDERR:1;
    unsigned DMAREQEN:1;
    unsigned AUTORQ:1;
    unsigned AUTOCLR:1;
  };
  struct {
    unsigned :18;
    unsigned OVERRUN:1;
    unsigned DATAERR:1;
    unsigned :1;
    unsigned SENDSTALL:1;
    unsigned SENTSTALL:1;
    unsigned :5;
    unsigned DISNYET:1;
    unsigned :1;
    unsigned ISO:1;
  };
} __USBIENCSR1bits_t;
extern volatile __USBIENCSR1bits_t USBIENCSR1bits __asm__ ("USBIENCSR1") __attribute__((section("sfrs")));
extern volatile unsigned int        USBIENCSR2 __attribute__((section("sfrs")));
typedef struct {
  unsigned RXCNT:14;
  unsigned :2;
  unsigned TEP:4;
  unsigned PROTOCOL:2;
  unsigned SPEED:2;
  unsigned TXINTERV:8;
} __USBIENCSR2bits_t;
extern volatile __USBIENCSR2bits_t USBIENCSR2bits __asm__ ("USBIENCSR2") __attribute__((section("sfrs")));
extern volatile unsigned int        USBIENCSR3 __attribute__((section("sfrs")));
typedef struct {
  unsigned TEP:4;
  unsigned PROTOCOL:2;
  unsigned SPEED:2;
  unsigned RXINTERV:8;
  unsigned :8;
  unsigned TXFIFOSZ:4;
  unsigned RXFIFOSZ:4;
} __USBIENCSR3bits_t;
extern volatile __USBIENCSR3bits_t USBIENCSR3bits __asm__ ("USBIENCSR3") __attribute__((section("sfrs")));
extern volatile unsigned int        USBFIFO0 __attribute__((section("sfrs")));
typedef struct {
  unsigned DATA:32;
} __USBFIFO0bits_t;
extern volatile __USBFIFO0bits_t USBFIFO0bits __asm__ ("USBFIFO0") __attribute__((section("sfrs")));
extern volatile unsigned int        USBFIFO1 __attribute__((section("sfrs")));
typedef struct {
  unsigned DATA:32;
} __USBFIFO1bits_t;
extern volatile __USBFIFO1bits_t USBFIFO1bits __asm__ ("USBFIFO1") __attribute__((section("sfrs")));
extern volatile unsigned int        USBFIFO2 __attribute__((section("sfrs")));
typedef struct {
  unsigned DATA:32;
} __USBFIFO2bits_t;
extern volatile __USBFIFO2bits_t USBFIFO2bits __asm__ ("USBFIFO2") __attribute__((section("sfrs")));
extern volatile unsigned int        USBFIFO3 __attribute__((section("sfrs")));
typedef struct {
  unsigned DATA:32;
} __USBFIFO3bits_t;
extern volatile __USBFIFO3bits_t USBFIFO3bits __asm__ ("USBFIFO3") __attribute__((section("sfrs")));
extern volatile unsigned int        USBFIFO4 __attribute__((section("sfrs")));
typedef struct {
  unsigned DATA:32;
} __USBFIFO4bits_t;
extern volatile __USBFIFO4bits_t USBFIFO4bits __asm__ ("USBFIFO4") __attribute__((section("sfrs")));
extern volatile unsigned int        USBFIFO5 __attribute__((section("sfrs")));
typedef struct {
  unsigned DATA:32;
} __USBFIFO5bits_t;
extern volatile __USBFIFO5bits_t USBFIFO5bits __asm__ ("USBFIFO5") __attribute__((section("sfrs")));
extern volatile unsigned int        USBFIFO6 __attribute__((section("sfrs")));
typedef struct {
  unsigned DATA:32;
} __USBFIFO6bits_t;
extern volatile __USBFIFO6bits_t USBFIFO6bits __asm__ ("USBFIFO6") __attribute__((section("sfrs")));
extern volatile unsigned int        USBFIFO7 __attribute__((section("sfrs")));
typedef struct {
  unsigned DATA:32;
} __USBFIFO7bits_t;
extern volatile __USBFIFO7bits_t USBFIFO7bits __asm__ ("USBFIFO7") __attribute__((section("sfrs")));
extern volatile unsigned int        USBOTG __attribute__((section("sfrs")));
typedef struct {
  unsigned SESSION:1;
  unsigned HOSTREQ:1;
  unsigned HOSTMODE:1;
  unsigned VBUS:2;
  unsigned LSDEV:1;
  unsigned FSDEV:1;
  unsigned BDEV:1;
  unsigned RXEDMA:1;
  unsigned TXEDMA:1;
  unsigned :6;
  unsigned TXFIFOSZ:4;
  unsigned TXDPB:1;
  unsigned :3;
  unsigned RXFIFOSZ:4;
  unsigned RXDPB:1;
} __USBOTGbits_t;
extern volatile __USBOTGbits_t USBOTGbits __asm__ ("USBOTG") __attribute__((section("sfrs")));
extern volatile unsigned int        USBFIFOA __attribute__((section("sfrs")));
typedef struct {
  unsigned TXFIFOAD:13;
  unsigned :3;
  unsigned RXFIFOAD:13;
} __USBFIFOAbits_t;
extern volatile __USBFIFOAbits_t USBFIFOAbits __asm__ ("USBFIFOA") __attribute__((section("sfrs")));
extern volatile unsigned int        USBHWVER __attribute__((section("sfrs")));
typedef struct {
  unsigned VERMINOR:10;
  unsigned VERMAJOR:5;
  unsigned RC:1;
} __USBHWVERbits_t;
extern volatile __USBHWVERbits_t USBHWVERbits __asm__ ("USBHWVER") __attribute__((section("sfrs")));
extern volatile unsigned int        USBINFO __attribute__((section("sfrs")));
typedef struct {
  unsigned TXENDPTS:4;
  unsigned RXENDPTS:4;
  unsigned RAMBITS:4;
  unsigned DMACHANS:4;
  unsigned WTID:4;
  unsigned WTCON:4;
  unsigned VPLEN:8;
} __USBINFObits_t;
extern volatile __USBINFObits_t USBINFObits __asm__ ("USBINFO") __attribute__((section("sfrs")));
extern volatile unsigned int        USBEOFRST __attribute__((section("sfrs")));
typedef struct {
  unsigned HSEOF:8;
  unsigned FSEOF:8;
  unsigned LSEOF:8;
  unsigned SOFRST:8;
} __USBEOFRSTbits_t;
extern volatile __USBEOFRSTbits_t USBEOFRSTbits __asm__ ("USBEOFRST") __attribute__((section("sfrs")));
extern volatile unsigned int        USBE0TXA __attribute__((section("sfrs")));
typedef struct {
  unsigned TXFADDR:7;
  unsigned :9;
  unsigned TXHUBADD:7;
  unsigned MULTTRAN:1;
  unsigned TXHUBPRT:7;
} __USBE0TXAbits_t;
extern volatile __USBE0TXAbits_t USBE0TXAbits __asm__ ("USBE0TXA") __attribute__((section("sfrs")));
extern volatile unsigned int        USBE0RXA __attribute__((section("sfrs")));
typedef struct {
  unsigned :16;
  unsigned RXHUBADD:7;
  unsigned MULTTRAN:1;
  unsigned RXHUBPRT:7;
} __USBE0RXAbits_t;
extern volatile __USBE0RXAbits_t USBE0RXAbits __asm__ ("USBE0RXA") __attribute__((section("sfrs")));
extern volatile unsigned int        USBE1TXA __attribute__((section("sfrs")));
typedef struct {
  unsigned TXFADDR:7;
  unsigned :9;
  unsigned TXHUBADD:7;
  unsigned MULTTRAN:1;
  unsigned TXHUBPRT:7;
} __USBE1TXAbits_t;
extern volatile __USBE1TXAbits_t USBE1TXAbits __asm__ ("USBE1TXA") __attribute__((section("sfrs")));
extern volatile unsigned int        USBE1RXA __attribute__((section("sfrs")));
typedef struct {
  unsigned RXFADDR:7;
  unsigned :9;
  unsigned RXHUBADD:7;
  unsigned MULTTRAN:1;
  unsigned RXHUBPRT:7;
} __USBE1RXAbits_t;
extern volatile __USBE1RXAbits_t USBE1RXAbits __asm__ ("USBE1RXA") __attribute__((section("sfrs")));
extern volatile unsigned int        USBE2TXA __attribute__((section("sfrs")));
typedef struct {
  unsigned TXFADDR:7;
  unsigned :9;
  unsigned TXHUBADD:7;
  unsigned MULTTRAN:1;
  unsigned TXHUBPRT:7;
} __USBE2TXAbits_t;
extern volatile __USBE2TXAbits_t USBE2TXAbits __asm__ ("USBE2TXA") __attribute__((section("sfrs")));
extern volatile unsigned int        USBE2RXA __attribute__((section("sfrs")));
typedef struct {
  unsigned RXFADDR:7;
  unsigned :9;
  unsigned RXHUBADD:7;
  unsigned MULTTRAN:1;
  unsigned RXHUBPRT:7;
} __USBE2RXAbits_t;
extern volatile __USBE2RXAbits_t USBE2RXAbits __asm__ ("USBE2RXA") __attribute__((section("sfrs")));
extern volatile unsigned int        USBE3TXA __attribute__((section("sfrs")));
typedef struct {
  unsigned TXFADDR:7;
  unsigned :9;
  unsigned TXHUBADD:7;
  unsigned MULTTRAN:1;
  unsigned TXHUBPRT:7;
} __USBE3TXAbits_t;
extern volatile __USBE3TXAbits_t USBE3TXAbits __asm__ ("USBE3TXA") __attribute__((section("sfrs")));
extern volatile unsigned int        USBE3RXA __attribute__((section("sfrs")));
typedef struct {
  unsigned RXFADDR:7;
  unsigned :9;
  unsigned RXHUBADD:7;
  unsigned MULTTRAN:1;
  unsigned RXHUBPRT:7;
} __USBE3RXAbits_t;
extern volatile __USBE3RXAbits_t USBE3RXAbits __asm__ ("USBE3RXA") __attribute__((section("sfrs")));
extern volatile unsigned int        USBE4TXA __attribute__((section("sfrs")));
typedef struct {
  unsigned TXFADDR:7;
  unsigned :9;
  unsigned TXHUBADD:7;
  unsigned MULTTRAN:1;
  unsigned TXHUBPRT:7;
} __USBE4TXAbits_t;
extern volatile __USBE4TXAbits_t USBE4TXAbits __asm__ ("USBE4TXA") __attribute__((section("sfrs")));
extern volatile unsigned int        USBE4RXA __attribute__((section("sfrs")));
typedef struct {
  unsigned RXFADDR:7;
  unsigned :9;
  unsigned RXHUBADD:7;
  unsigned MULTTRAN:1;
  unsigned RXHUBPRT:7;
} __USBE4RXAbits_t;
extern volatile __USBE4RXAbits_t USBE4RXAbits __asm__ ("USBE4RXA") __attribute__((section("sfrs")));
extern volatile unsigned int        USBE5TXA __attribute__((section("sfrs")));
typedef struct {
  unsigned TXFADDR:7;
  unsigned :9;
  unsigned TXHUBADD:7;
  unsigned MULTTRAN:1;
  unsigned TXHUBPRT:7;
} __USBE5TXAbits_t;
extern volatile __USBE5TXAbits_t USBE5TXAbits __asm__ ("USBE5TXA") __attribute__((section("sfrs")));
extern volatile unsigned int        USBE5RXA __attribute__((section("sfrs")));
typedef struct {
  unsigned RXFADDR:7;
  unsigned :9;
  unsigned RXHUBADD:7;
  unsigned MULTTRAN:1;
  unsigned RXHUBPRT:7;
} __USBE5RXAbits_t;
extern volatile __USBE5RXAbits_t USBE5RXAbits __asm__ ("USBE5RXA") __attribute__((section("sfrs")));
extern volatile unsigned int        USBE6TXA __attribute__((section("sfrs")));
typedef struct {
  unsigned TXFADDR:7;
  unsigned :9;
  unsigned TXHUBADD:7;
  unsigned MULTTRAN:1;
  unsigned TXHUBPRT:7;
} __USBE6TXAbits_t;
extern volatile __USBE6TXAbits_t USBE6TXAbits __asm__ ("USBE6TXA") __attribute__((section("sfrs")));
extern volatile unsigned int        USBE6RXA __attribute__((section("sfrs")));
typedef struct {
  unsigned RXFADDR:7;
  unsigned :9;
  unsigned RXHUBADD:7;
  unsigned MULTTRAN:1;
  unsigned RXHUBPRT:7;
} __USBE6RXAbits_t;
extern volatile __USBE6RXAbits_t USBE6RXAbits __asm__ ("USBE6RXA") __attribute__((section("sfrs")));
extern volatile unsigned int        USBE7TXA __attribute__((section("sfrs")));
typedef struct {
  unsigned TXFADDR:7;
  unsigned :9;
  unsigned TXHUBADD:7;
  unsigned MULTTRAN:1;
  unsigned TXHUBPRT:7;
} __USBE7TXAbits_t;
extern volatile __USBE7TXAbits_t USBE7TXAbits __asm__ ("USBE7TXA") __attribute__((section("sfrs")));
extern volatile unsigned int        USBE7RXA __attribute__((section("sfrs")));
typedef struct {
  unsigned RXFADDR:7;
  unsigned :9;
  unsigned RXHUBADD:7;
  unsigned MULTTRAN:1;
  unsigned RXHUBPRT:7;
} __USBE7RXAbits_t;
extern volatile __USBE7RXAbits_t USBE7RXAbits __asm__ ("USBE7RXA") __attribute__((section("sfrs")));
extern volatile unsigned int        USBE0CSR0 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TXMAXP:11;
    unsigned :5;
    unsigned RXRDY:1;
    unsigned TXRDY:1;
    unsigned STALLED:1;
    unsigned SETUP:1;
    unsigned ERROR:1;
    unsigned REQPKT:1;
    unsigned STATUS:1;
    unsigned NAKTO:1;
    unsigned FLUSH:1;
    unsigned DT:1;
    unsigned DTWE:1;
  };
  struct {
    unsigned :19;
    unsigned DATAEND:1;
    unsigned SETEND:1;
    unsigned STALL:1;
    unsigned RXRDYC:1;
    unsigned SETENDC:1;
  };
} __USBE0CSR0bits_t;
extern volatile __USBE0CSR0bits_t USBE0CSR0bits __asm__ ("USBE0CSR0") __attribute__((section("sfrs")));
extern volatile unsigned int        USBE0CSR2 __attribute__((section("sfrs")));
typedef struct {
  unsigned RXCNT:7;
  unsigned :15;
  unsigned SPEED:2;
  unsigned NAKLIM:4;
} __USBE0CSR2bits_t;
extern volatile __USBE0CSR2bits_t USBE0CSR2bits __asm__ ("USBE0CSR2") __attribute__((section("sfrs")));
extern volatile unsigned int        USBE0CSR3 __attribute__((section("sfrs")));
typedef struct {
  unsigned :24;
  unsigned UTMIDWID:1;
  unsigned SOFTCONE:1;
  unsigned DYNFIFOS:1;
  unsigned HBTXEN:1;
  unsigned HBRXEN:1;
  unsigned BIGEND:1;
  unsigned MPTXEN:1;
  unsigned MPRXEN:1;
} __USBE0CSR3bits_t;
extern volatile __USBE0CSR3bits_t USBE0CSR3bits __asm__ ("USBE0CSR3") __attribute__((section("sfrs")));
extern volatile unsigned int        USBE1CSR0 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TXMAXP:11;
    unsigned MULT:5;
    unsigned TXPKTRDY:1;
    unsigned FIFONE:1;
    unsigned ERROR:1;
    unsigned FLUSH:1;
    unsigned SETUPPKT:1;
    unsigned RXSTALL:1;
    unsigned CLRDT:1;
    unsigned NAKTMOUT:1;
    unsigned DATATGGL:1;
    unsigned DTWREN:1;
    unsigned DMAREQMD:1;
    unsigned FRCDATTG:1;
    unsigned DMAREQEN:1;
    unsigned MODE:1;
    unsigned :1;
    unsigned AUTOSET:1;
  };
  struct {
    unsigned :18;
    unsigned UNDERRUN:1;
    unsigned :1;
    unsigned SENDSTALL:1;
    unsigned SENTSTALL:1;
    unsigned :1;
    unsigned INCOMPTX:1;
    unsigned :6;
    unsigned ISO:1;
  };
} __USBE1CSR0bits_t;
extern volatile __USBE1CSR0bits_t USBE1CSR0bits __asm__ ("USBE1CSR0") __attribute__((section("sfrs")));
extern volatile unsigned int        USBE1CSR1 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RXMAXP:11;
    unsigned MULT:5;
    unsigned RXPKTRDY:1;
    unsigned FIFOFULL:1;
    unsigned ERROR:1;
    unsigned DERRNAKT:1;
    unsigned FLUSH:1;
    unsigned REQPKT:1;
    unsigned RXSTALL:1;
    unsigned CLRDT:1;
    unsigned INCOMPRX:1;
    unsigned DATATGGL:1;
    unsigned DATATWEN:1;
    unsigned DMAREQMD:1;
    unsigned PIDERR:1;
    unsigned DMAREQEN:1;
    unsigned AUTORQ:1;
    unsigned AUTOCLR:1;
  };
  struct {
    unsigned :18;
    unsigned UNDERRUN:1;
    unsigned :1;
    unsigned SENDSTALL:1;
    unsigned SENTSTALL:1;
    unsigned :1;
    unsigned INCOMPTX:1;
    unsigned :6;
    unsigned ISO:1;
  };
} __USBE1CSR1bits_t;
extern volatile __USBE1CSR1bits_t USBE1CSR1bits __asm__ ("USBE1CSR1") __attribute__((section("sfrs")));
extern volatile unsigned int        USBE1CSR2 __attribute__((section("sfrs")));
typedef struct {
  unsigned RXCNT:14;
  unsigned :2;
  unsigned TEP:4;
  unsigned PROTOCOL:2;
  unsigned SPEED:2;
  unsigned TXINTERV:8;
} __USBE1CSR2bits_t;
extern volatile __USBE1CSR2bits_t USBE1CSR2bits __asm__ ("USBE1CSR2") __attribute__((section("sfrs")));
extern volatile unsigned int        USBE1CSR3 __attribute__((section("sfrs")));
typedef struct {
  unsigned TEP:4;
  unsigned PROTOCOL:2;
  unsigned SPEED:2;
  unsigned RXINTERV:8;
  unsigned :8;
  unsigned TXFIFOSZ:4;
  unsigned RXFIFOSZ:4;
} __USBE1CSR3bits_t;
extern volatile __USBE1CSR3bits_t USBE1CSR3bits __asm__ ("USBE1CSR3") __attribute__((section("sfrs")));
extern volatile unsigned int        USBE2CSR0 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TXMAXP:11;
    unsigned MULT:5;
    unsigned TXPKTRDY:1;
    unsigned FIFONE:1;
    unsigned ERROR:1;
    unsigned FLUSH:1;
    unsigned SETUPPKT:1;
    unsigned RXSTALL:1;
    unsigned CLRDT:1;
    unsigned NAKTMOUT:1;
    unsigned DATATGGL:1;
    unsigned DTWREN:1;
    unsigned DMAREQMD:1;
    unsigned FRCDATTG:1;
    unsigned DMAREQEN:1;
    unsigned MODE:1;
    unsigned :1;
    unsigned AUTOSET:1;
  };
  struct {
    unsigned :18;
    unsigned UNDERRUN:1;
    unsigned :1;
    unsigned SENDSTALL:1;
    unsigned SENTSTALL:1;
    unsigned :1;
    unsigned INCOMPTX:1;
    unsigned :6;
    unsigned ISO:1;
  };
} __USBE2CSR0bits_t;
extern volatile __USBE2CSR0bits_t USBE2CSR0bits __asm__ ("USBE2CSR0") __attribute__((section("sfrs")));
extern volatile unsigned int        USBE2CSR1 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RXMAXP:11;
    unsigned MULT:5;
    unsigned RXPKTRDY:1;
    unsigned FIFOFULL:1;
    unsigned ERROR:1;
    unsigned DERRNAKT:1;
    unsigned FLUSH:1;
    unsigned REQPKT:1;
    unsigned RXSTALL:1;
    unsigned CLRDT:1;
    unsigned INCOMPRX:1;
    unsigned DATATGGL:1;
    unsigned DATATWEN:1;
    unsigned DMAREQMD:1;
    unsigned PIDERR:1;
    unsigned DMAREQEN:1;
    unsigned AUTORQ:1;
    unsigned AUTOCLR:1;
  };
  struct {
    unsigned :18;
    unsigned UNDERRUN:1;
    unsigned :1;
    unsigned SENDSTALL:1;
    unsigned SENTSTALL:1;
    unsigned :1;
    unsigned INCOMPTX:1;
    unsigned :6;
    unsigned ISO:1;
  };
} __USBE2CSR1bits_t;
extern volatile __USBE2CSR1bits_t USBE2CSR1bits __asm__ ("USBE2CSR1") __attribute__((section("sfrs")));
extern volatile unsigned int        USBE2CSR2 __attribute__((section("sfrs")));
typedef struct {
  unsigned RXCNT:14;
  unsigned :2;
  unsigned TEP:4;
  unsigned PROTOCOL:2;
  unsigned SPEED:2;
  unsigned TXINTERV:8;
} __USBE2CSR2bits_t;
extern volatile __USBE2CSR2bits_t USBE2CSR2bits __asm__ ("USBE2CSR2") __attribute__((section("sfrs")));
extern volatile unsigned int        USBE2CSR3 __attribute__((section("sfrs")));
typedef struct {
  unsigned TEP:4;
  unsigned PROTOCOL:2;
  unsigned SPEED:2;
  unsigned RXINTERV:8;
  unsigned :8;
  unsigned TXFIFOSZ:4;
  unsigned RXFIFOSZ:4;
} __USBE2CSR3bits_t;
extern volatile __USBE2CSR3bits_t USBE2CSR3bits __asm__ ("USBE2CSR3") __attribute__((section("sfrs")));
extern volatile unsigned int        USBE3CSR0 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TXMAXP:11;
    unsigned MULT:5;
    unsigned TXPKTRDY:1;
    unsigned FIFONE:1;
    unsigned ERROR:1;
    unsigned FLUSH:1;
    unsigned SETUPPKT:1;
    unsigned RXSTALL:1;
    unsigned CLRDT:1;
    unsigned NAKTMOUT:1;
    unsigned DATATGGL:1;
    unsigned DTWREN:1;
    unsigned DMAREQMD:1;
    unsigned FRCDATTG:1;
    unsigned DMAREQEN:1;
    unsigned MODE:1;
    unsigned :1;
    unsigned AUTOSET:1;
  };
  struct {
    unsigned :18;
    unsigned UNDERRUN:1;
    unsigned :1;
    unsigned SENDSTALL:1;
    unsigned SENTSTALL:1;
    unsigned :1;
    unsigned INCOMPTX:1;
    unsigned :6;
    unsigned ISO:1;
  };
} __USBE3CSR0bits_t;
extern volatile __USBE3CSR0bits_t USBE3CSR0bits __asm__ ("USBE3CSR0") __attribute__((section("sfrs")));
extern volatile unsigned int        USBE3CSR1 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RXMAXP:11;
    unsigned MULT:5;
    unsigned RXPKTRDY:1;
    unsigned FIFOFULL:1;
    unsigned ERROR:1;
    unsigned DERRNAKT:1;
    unsigned FLUSH:1;
    unsigned REQPKT:1;
    unsigned RXSTALL:1;
    unsigned CLRDT:1;
    unsigned INCOMPRX:1;
    unsigned DATATGGL:1;
    unsigned DATATWEN:1;
    unsigned DMAREQMD:1;
    unsigned PIDERR:1;
    unsigned DMAREQEN:1;
    unsigned AUTORQ:1;
    unsigned AUTOCLR:1;
  };
  struct {
    unsigned :18;
    unsigned UNDERRUN:1;
    unsigned :1;
    unsigned SENDSTALL:1;
    unsigned SENTSTALL:1;
    unsigned :1;
    unsigned INCOMPTX:1;
    unsigned :6;
    unsigned ISO:1;
  };
} __USBE3CSR1bits_t;
extern volatile __USBE3CSR1bits_t USBE3CSR1bits __asm__ ("USBE3CSR1") __attribute__((section("sfrs")));
extern volatile unsigned int        USBE3CSR2 __attribute__((section("sfrs")));
typedef struct {
  unsigned RXCNT:14;
  unsigned :2;
  unsigned TEP:4;
  unsigned PROTOCOL:2;
  unsigned SPEED:2;
  unsigned TXINTERV:8;
} __USBE3CSR2bits_t;
extern volatile __USBE3CSR2bits_t USBE3CSR2bits __asm__ ("USBE3CSR2") __attribute__((section("sfrs")));
extern volatile unsigned int        USBE3CSR3 __attribute__((section("sfrs")));
typedef struct {
  unsigned TEP:4;
  unsigned PROTOCOL:2;
  unsigned SPEED:2;
  unsigned RXINTERV:8;
  unsigned :8;
  unsigned TXFIFOSZ:4;
  unsigned RXFIFOSZ:4;
} __USBE3CSR3bits_t;
extern volatile __USBE3CSR3bits_t USBE3CSR3bits __asm__ ("USBE3CSR3") __attribute__((section("sfrs")));
extern volatile unsigned int        USBE4CSR0 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TXMAXP:11;
    unsigned MULT:5;
    unsigned TXPKTRDY:1;
    unsigned FIFONE:1;
    unsigned ERROR:1;
    unsigned FLUSH:1;
    unsigned SETUPPKT:1;
    unsigned RXSTALL:1;
    unsigned CLRDT:1;
    unsigned NAKTMOUT:1;
    unsigned DATATGGL:1;
    unsigned DTWREN:1;
    unsigned DMAREQMD:1;
    unsigned FRCDATTG:1;
    unsigned DMAREQEN:1;
    unsigned MODE:1;
    unsigned :1;
    unsigned AUTOSET:1;
  };
  struct {
    unsigned :18;
    unsigned UNDERRUN:1;
    unsigned :1;
    unsigned SENDSTALL:1;
    unsigned SENTSTALL:1;
    unsigned :1;
    unsigned INCOMPTX:1;
    unsigned :6;
    unsigned ISO:1;
  };
} __USBE4CSR0bits_t;
extern volatile __USBE4CSR0bits_t USBE4CSR0bits __asm__ ("USBE4CSR0") __attribute__((section("sfrs")));
extern volatile unsigned int        USBE4CSR1 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RXMAXP:11;
    unsigned MULT:5;
    unsigned RXPKTRDY:1;
    unsigned FIFOFULL:1;
    unsigned ERROR:1;
    unsigned DERRNAKT:1;
    unsigned FLUSH:1;
    unsigned REQPKT:1;
    unsigned RXSTALL:1;
    unsigned CLRDT:1;
    unsigned INCOMPRX:1;
    unsigned DATATGGL:1;
    unsigned DATATWEN:1;
    unsigned DMAREQMD:1;
    unsigned PIDERR:1;
    unsigned DMAREQEN:1;
    unsigned AUTORQ:1;
    unsigned AUTOCLR:1;
  };
  struct {
    unsigned :18;
    unsigned UNDERRUN:1;
    unsigned :1;
    unsigned SENDSTALL:1;
    unsigned SENTSTALL:1;
    unsigned :1;
    unsigned INCOMPTX:1;
    unsigned :6;
    unsigned ISO:1;
  };
} __USBE4CSR1bits_t;
extern volatile __USBE4CSR1bits_t USBE4CSR1bits __asm__ ("USBE4CSR1") __attribute__((section("sfrs")));
extern volatile unsigned int        USBE4CSR2 __attribute__((section("sfrs")));
typedef struct {
  unsigned RXCNT:14;
  unsigned :2;
  unsigned TEP:4;
  unsigned PROTOCOL:2;
  unsigned SPEED:2;
  unsigned TXINTERV:8;
} __USBE4CSR2bits_t;
extern volatile __USBE4CSR2bits_t USBE4CSR2bits __asm__ ("USBE4CSR2") __attribute__((section("sfrs")));
extern volatile unsigned int        USBE4CSR3 __attribute__((section("sfrs")));
typedef struct {
  unsigned TEP:4;
  unsigned PROTOCOL:2;
  unsigned SPEED:2;
  unsigned RXINTERV:8;
  unsigned :8;
  unsigned TXFIFOSZ:4;
  unsigned RXFIFOSZ:4;
} __USBE4CSR3bits_t;
extern volatile __USBE4CSR3bits_t USBE4CSR3bits __asm__ ("USBE4CSR3") __attribute__((section("sfrs")));
extern volatile unsigned int        USBE5CSR0 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TXMAXP:11;
    unsigned MULT:5;
    unsigned TXPKTRDY:1;
    unsigned FIFONE:1;
    unsigned ERROR:1;
    unsigned FLUSH:1;
    unsigned SETUPPKT:1;
    unsigned RXSTALL:1;
    unsigned CLRDT:1;
    unsigned NAKTMOUT:1;
    unsigned DATATGGL:1;
    unsigned DTWREN:1;
    unsigned DMAREQMD:1;
    unsigned FRCDATTG:1;
    unsigned DMAREQEN:1;
    unsigned MODE:1;
    unsigned :1;
    unsigned AUTOSET:1;
  };
  struct {
    unsigned :18;
    unsigned UNDERRUN:1;
    unsigned :1;
    unsigned SENDSTALL:1;
    unsigned SENTSTALL:1;
    unsigned :1;
    unsigned INCOMPTX:1;
    unsigned :6;
    unsigned ISO:1;
  };
} __USBE5CSR0bits_t;
extern volatile __USBE5CSR0bits_t USBE5CSR0bits __asm__ ("USBE5CSR0") __attribute__((section("sfrs")));
extern volatile unsigned int        USBE5CSR1 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RXMAXP:11;
    unsigned MULT:5;
    unsigned RXPKTRDY:1;
    unsigned FIFOFULL:1;
    unsigned ERROR:1;
    unsigned DERRNAKT:1;
    unsigned FLUSH:1;
    unsigned REQPKT:1;
    unsigned RXSTALL:1;
    unsigned CLRDT:1;
    unsigned INCOMPRX:1;
    unsigned DATATGGL:1;
    unsigned DATATWEN:1;
    unsigned DMAREQMD:1;
    unsigned PIDERR:1;
    unsigned DMAREQEN:1;
    unsigned AUTORQ:1;
    unsigned AUTOCLR:1;
  };
  struct {
    unsigned :18;
    unsigned UNDERRUN:1;
    unsigned :1;
    unsigned SENDSTALL:1;
    unsigned SENTSTALL:1;
    unsigned :1;
    unsigned INCOMPTX:1;
    unsigned :6;
    unsigned ISO:1;
  };
} __USBE5CSR1bits_t;
extern volatile __USBE5CSR1bits_t USBE5CSR1bits __asm__ ("USBE5CSR1") __attribute__((section("sfrs")));
extern volatile unsigned int        USBE5CSR2 __attribute__((section("sfrs")));
typedef struct {
  unsigned RXCNT:14;
  unsigned :2;
  unsigned TEP:4;
  unsigned PROTOCOL:2;
  unsigned SPEED:2;
  unsigned TXINTERV:8;
} __USBE5CSR2bits_t;
extern volatile __USBE5CSR2bits_t USBE5CSR2bits __asm__ ("USBE5CSR2") __attribute__((section("sfrs")));
extern volatile unsigned int        USBE5CSR3 __attribute__((section("sfrs")));
typedef struct {
  unsigned TEP:4;
  unsigned PROTOCOL:2;
  unsigned SPEED:2;
  unsigned RXINTERV:8;
  unsigned :8;
  unsigned TXFIFOSZ:4;
  unsigned RXFIFOSZ:4;
} __USBE5CSR3bits_t;
extern volatile __USBE5CSR3bits_t USBE5CSR3bits __asm__ ("USBE5CSR3") __attribute__((section("sfrs")));
extern volatile unsigned int        USBE6CSR0 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TXMAXP:11;
    unsigned MULT:5;
    unsigned TXPKTRDY:1;
    unsigned FIFONE:1;
    unsigned ERROR:1;
    unsigned FLUSH:1;
    unsigned SETUPPKT:1;
    unsigned RXSTALL:1;
    unsigned CLRDT:1;
    unsigned NAKTMOUT:1;
    unsigned DATATGGL:1;
    unsigned DTWREN:1;
    unsigned DMAREQMD:1;
    unsigned FRCDATTG:1;
    unsigned DMAREQEN:1;
    unsigned MODE:1;
    unsigned :1;
    unsigned AUTOSET:1;
  };
  struct {
    unsigned :18;
    unsigned UNDERRUN:1;
    unsigned :1;
    unsigned SENDSTALL:1;
    unsigned SENTSTALL:1;
    unsigned :1;
    unsigned INCOMPTX:1;
    unsigned :6;
    unsigned ISO:1;
  };
} __USBE6CSR0bits_t;
extern volatile __USBE6CSR0bits_t USBE6CSR0bits __asm__ ("USBE6CSR0") __attribute__((section("sfrs")));
extern volatile unsigned int        USBE6CSR1 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RXMAXP:11;
    unsigned MULT:5;
    unsigned RXPKTRDY:1;
    unsigned FIFOFULL:1;
    unsigned ERROR:1;
    unsigned DERRNAKT:1;
    unsigned FLUSH:1;
    unsigned REQPKT:1;
    unsigned RXSTALL:1;
    unsigned CLRDT:1;
    unsigned INCOMPRX:1;
    unsigned DATATGGL:1;
    unsigned DATATWEN:1;
    unsigned DMAREQMD:1;
    unsigned PIDERR:1;
    unsigned DMAREQEN:1;
    unsigned AUTORQ:1;
    unsigned AUTOCLR:1;
  };
  struct {
    unsigned :18;
    unsigned UNDERRUN:1;
    unsigned :1;
    unsigned SENDSTALL:1;
    unsigned SENTSTALL:1;
    unsigned :1;
    unsigned INCOMPTX:1;
    unsigned :6;
    unsigned ISO:1;
  };
} __USBE6CSR1bits_t;
extern volatile __USBE6CSR1bits_t USBE6CSR1bits __asm__ ("USBE6CSR1") __attribute__((section("sfrs")));
extern volatile unsigned int        USBE6CSR2 __attribute__((section("sfrs")));
typedef struct {
  unsigned RXCNT:14;
  unsigned :2;
  unsigned TEP:4;
  unsigned PROTOCOL:2;
  unsigned SPEED:2;
  unsigned TXINTERV:8;
} __USBE6CSR2bits_t;
extern volatile __USBE6CSR2bits_t USBE6CSR2bits __asm__ ("USBE6CSR2") __attribute__((section("sfrs")));
extern volatile unsigned int        USBE6CSR3 __attribute__((section("sfrs")));
typedef struct {
  unsigned TEP:4;
  unsigned PROTOCOL:2;
  unsigned SPEED:2;
  unsigned RXINTERV:8;
  unsigned :8;
  unsigned TXFIFOSZ:4;
  unsigned RXFIFOSZ:4;
} __USBE6CSR3bits_t;
extern volatile __USBE6CSR3bits_t USBE6CSR3bits __asm__ ("USBE6CSR3") __attribute__((section("sfrs")));
extern volatile unsigned int        USBE7CSR0 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TXMAXP:11;
    unsigned MULT:5;
    unsigned TXPKTRDY:1;
    unsigned FIFONE:1;
    unsigned ERROR:1;
    unsigned FLUSH:1;
    unsigned SETUPPKT:1;
    unsigned RXSTALL:1;
    unsigned CLRDT:1;
    unsigned NAKTMOUT:1;
    unsigned DATATGGL:1;
    unsigned DTWREN:1;
    unsigned DMAREQMD:1;
    unsigned FRCDATTG:1;
    unsigned DMAREQEN:1;
    unsigned MODE:1;
    unsigned :1;
    unsigned AUTOSET:1;
  };
  struct {
    unsigned :18;
    unsigned UNDERRUN:1;
    unsigned :1;
    unsigned SENDSTALL:1;
    unsigned SENTSTALL:1;
    unsigned :1;
    unsigned INCOMPTX:1;
    unsigned :6;
    unsigned ISO:1;
  };
} __USBE7CSR0bits_t;
extern volatile __USBE7CSR0bits_t USBE7CSR0bits __asm__ ("USBE7CSR0") __attribute__((section("sfrs")));
extern volatile unsigned int        USBE7CSR1 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RXMAXP:11;
    unsigned MULT:5;
    unsigned RXPKTRDY:1;
    unsigned FIFOFULL:1;
    unsigned ERROR:1;
    unsigned DERRNAKT:1;
    unsigned FLUSH:1;
    unsigned REQPKT:1;
    unsigned RXSTALL:1;
    unsigned CLRDT:1;
    unsigned INCOMPRX:1;
    unsigned DATATGGL:1;
    unsigned DATATWEN:1;
    unsigned DMAREQMD:1;
    unsigned PIDERR:1;
    unsigned DMAREQEN:1;
    unsigned AUTORQ:1;
    unsigned AUTOCLR:1;
  };
  struct {
    unsigned :18;
    unsigned UNDERRUN:1;
    unsigned :1;
    unsigned SENDSTALL:1;
    unsigned SENTSTALL:1;
    unsigned :1;
    unsigned INCOMPTX:1;
    unsigned :6;
    unsigned ISO:1;
  };
} __USBE7CSR1bits_t;
extern volatile __USBE7CSR1bits_t USBE7CSR1bits __asm__ ("USBE7CSR1") __attribute__((section("sfrs")));
extern volatile unsigned int        USBE7CSR2 __attribute__((section("sfrs")));
typedef struct {
  unsigned RXCNT:14;
  unsigned :2;
  unsigned TEP:4;
  unsigned PROTOCOL:2;
  unsigned SPEED:2;
  unsigned TXINTERV:8;
} __USBE7CSR2bits_t;
extern volatile __USBE7CSR2bits_t USBE7CSR2bits __asm__ ("USBE7CSR2") __attribute__((section("sfrs")));
extern volatile unsigned int        USBE7CSR3 __attribute__((section("sfrs")));
typedef struct {
  unsigned TEP:4;
  unsigned PROTOCOL:2;
  unsigned SPEED:2;
  unsigned RXINTERV:8;
  unsigned :8;
  unsigned TXFIFOSZ:4;
  unsigned RXFIFOSZ:4;
} __USBE7CSR3bits_t;
extern volatile __USBE7CSR3bits_t USBE7CSR3bits __asm__ ("USBE7CSR3") __attribute__((section("sfrs")));
extern volatile unsigned int        USBDMAINT __attribute__((section("sfrs")));
typedef struct {
  unsigned DMA1IF:1;
  unsigned DMA2IF:1;
  unsigned DMA3IF:1;
  unsigned DMA4IF:1;
  unsigned DMA5IF:1;
  unsigned DMA6IF:1;
  unsigned DMA7IF:1;
  unsigned DMA8IF:1;
} __USBDMAINTbits_t;
extern volatile __USBDMAINTbits_t USBDMAINTbits __asm__ ("USBDMAINT") __attribute__((section("sfrs")));
extern volatile unsigned int        USBDMA1C __attribute__((section("sfrs")));
typedef struct {
  unsigned DMAEN:1;
  unsigned DMADIR:1;
  unsigned DMAMODE:1;
  unsigned DMAIE:1;
  unsigned DMAEP:4;
  unsigned DMAERR:1;
  unsigned DMABRSTM:2;
} __USBDMA1Cbits_t;
extern volatile __USBDMA1Cbits_t USBDMA1Cbits __asm__ ("USBDMA1C") __attribute__((section("sfrs")));
extern volatile unsigned int        USBDMA1A __attribute__((section("sfrs")));
typedef struct {
  unsigned DMAADDR:32;
} __USBDMA1Abits_t;
extern volatile __USBDMA1Abits_t USBDMA1Abits __asm__ ("USBDMA1A") __attribute__((section("sfrs")));
extern volatile unsigned int        USBDMA1N __attribute__((section("sfrs")));
typedef struct {
  unsigned DMACOUNT:32;
} __USBDMA1Nbits_t;
extern volatile __USBDMA1Nbits_t USBDMA1Nbits __asm__ ("USBDMA1N") __attribute__((section("sfrs")));
extern volatile unsigned int        USBDMA2C __attribute__((section("sfrs")));
typedef struct {
  unsigned DMAEN:1;
  unsigned DMADIR:1;
  unsigned DMAMODE:1;
  unsigned DMAIE:1;
  unsigned DMAEP:4;
  unsigned DMAERR:1;
  unsigned DMABRSTM:2;
} __USBDMA2Cbits_t;
extern volatile __USBDMA2Cbits_t USBDMA2Cbits __asm__ ("USBDMA2C") __attribute__((section("sfrs")));
extern volatile unsigned int        USBDMA2A __attribute__((section("sfrs")));
typedef struct {
  unsigned DMAADDR:32;
} __USBDMA2Abits_t;
extern volatile __USBDMA2Abits_t USBDMA2Abits __asm__ ("USBDMA2A") __attribute__((section("sfrs")));
extern volatile unsigned int        USBDMA2N __attribute__((section("sfrs")));
typedef struct {
  unsigned DMACOUNT:32;
} __USBDMA2Nbits_t;
extern volatile __USBDMA2Nbits_t USBDMA2Nbits __asm__ ("USBDMA2N") __attribute__((section("sfrs")));
extern volatile unsigned int        USBDMA3C __attribute__((section("sfrs")));
typedef struct {
  unsigned DMAEN:1;
  unsigned DMADIR:1;
  unsigned DMAMODE:1;
  unsigned DMAIE:1;
  unsigned DMAEP:4;
  unsigned DMAERR:1;
  unsigned DMABRSTM:2;
} __USBDMA3Cbits_t;
extern volatile __USBDMA3Cbits_t USBDMA3Cbits __asm__ ("USBDMA3C") __attribute__((section("sfrs")));
extern volatile unsigned int        USBDMA3A __attribute__((section("sfrs")));
typedef struct {
  unsigned DMAADDR:32;
} __USBDMA3Abits_t;
extern volatile __USBDMA3Abits_t USBDMA3Abits __asm__ ("USBDMA3A") __attribute__((section("sfrs")));
extern volatile unsigned int        USBDMA3N __attribute__((section("sfrs")));
typedef struct {
  unsigned DMACOUNT:32;
} __USBDMA3Nbits_t;
extern volatile __USBDMA3Nbits_t USBDMA3Nbits __asm__ ("USBDMA3N") __attribute__((section("sfrs")));
extern volatile unsigned int        USBDMA4C __attribute__((section("sfrs")));
typedef struct {
  unsigned DMAEN:1;
  unsigned DMADIR:1;
  unsigned DMAMODE:1;
  unsigned DMAIE:1;
  unsigned DMAEP:4;
  unsigned DMAERR:1;
  unsigned DMABRSTM:2;
} __USBDMA4Cbits_t;
extern volatile __USBDMA4Cbits_t USBDMA4Cbits __asm__ ("USBDMA4C") __attribute__((section("sfrs")));
extern volatile unsigned int        USBDMA4A __attribute__((section("sfrs")));
typedef struct {
  unsigned DMAADDR:32;
} __USBDMA4Abits_t;
extern volatile __USBDMA4Abits_t USBDMA4Abits __asm__ ("USBDMA4A") __attribute__((section("sfrs")));
extern volatile unsigned int        USBDMA4N __attribute__((section("sfrs")));
typedef struct {
  unsigned DMACOUNT:32;
} __USBDMA4Nbits_t;
extern volatile __USBDMA4Nbits_t USBDMA4Nbits __asm__ ("USBDMA4N") __attribute__((section("sfrs")));
extern volatile unsigned int        USBDMA5C __attribute__((section("sfrs")));
typedef struct {
  unsigned DMAEN:1;
  unsigned DMADIR:1;
  unsigned DMAMODE:1;
  unsigned DMAIE:1;
  unsigned DMAEP:4;
  unsigned DMAERR:1;
  unsigned DMABRSTM:2;
} __USBDMA5Cbits_t;
extern volatile __USBDMA5Cbits_t USBDMA5Cbits __asm__ ("USBDMA5C") __attribute__((section("sfrs")));
extern volatile unsigned int        USBDMA5A __attribute__((section("sfrs")));
typedef struct {
  unsigned DMAADDR:32;
} __USBDMA5Abits_t;
extern volatile __USBDMA5Abits_t USBDMA5Abits __asm__ ("USBDMA5A") __attribute__((section("sfrs")));
extern volatile unsigned int        USBDMA5N __attribute__((section("sfrs")));
typedef struct {
  unsigned DMACOUNT:32;
} __USBDMA5Nbits_t;
extern volatile __USBDMA5Nbits_t USBDMA5Nbits __asm__ ("USBDMA5N") __attribute__((section("sfrs")));
extern volatile unsigned int        USBDMA6C __attribute__((section("sfrs")));
typedef struct {
  unsigned DMAEN:1;
  unsigned DMADIR:1;
  unsigned DMAMODE:1;
  unsigned DMAIE:1;
  unsigned DMAEP:4;
  unsigned DMAERR:1;
  unsigned DMABRSTM:2;
} __USBDMA6Cbits_t;
extern volatile __USBDMA6Cbits_t USBDMA6Cbits __asm__ ("USBDMA6C") __attribute__((section("sfrs")));
extern volatile unsigned int        USBDMA6A __attribute__((section("sfrs")));
typedef struct {
  unsigned DMAADDR:32;
} __USBDMA6Abits_t;
extern volatile __USBDMA6Abits_t USBDMA6Abits __asm__ ("USBDMA6A") __attribute__((section("sfrs")));
extern volatile unsigned int        USBDMA6N __attribute__((section("sfrs")));
typedef struct {
  unsigned DMACOUNT:32;
} __USBDMA6Nbits_t;
extern volatile __USBDMA6Nbits_t USBDMA6Nbits __asm__ ("USBDMA6N") __attribute__((section("sfrs")));
extern volatile unsigned int        USBDMA7C __attribute__((section("sfrs")));
typedef struct {
  unsigned DMAEN:1;
  unsigned DMADIR:1;
  unsigned DMAMODE:1;
  unsigned DMAIE:1;
  unsigned DMAEP:4;
  unsigned DMAERR:1;
  unsigned DMABRSTM:2;
} __USBDMA7Cbits_t;
extern volatile __USBDMA7Cbits_t USBDMA7Cbits __asm__ ("USBDMA7C") __attribute__((section("sfrs")));
extern volatile unsigned int        USBDMA7A __attribute__((section("sfrs")));
typedef struct {
  unsigned DMAADDR:32;
} __USBDMA7Abits_t;
extern volatile __USBDMA7Abits_t USBDMA7Abits __asm__ ("USBDMA7A") __attribute__((section("sfrs")));
extern volatile unsigned int        USBDMA7N __attribute__((section("sfrs")));
typedef struct {
  unsigned DMACOUNT:32;
} __USBDMA7Nbits_t;
extern volatile __USBDMA7Nbits_t USBDMA7Nbits __asm__ ("USBDMA7N") __attribute__((section("sfrs")));
extern volatile unsigned int        USBDMA8C __attribute__((section("sfrs")));
typedef struct {
  unsigned DMAEN:1;
  unsigned DMADIR:1;
  unsigned DMAMODE:1;
  unsigned DMAIE:1;
  unsigned DMAEP:4;
  unsigned DMAERR:1;
  unsigned DMABRSTM:2;
} __USBDMA8Cbits_t;
extern volatile __USBDMA8Cbits_t USBDMA8Cbits __asm__ ("USBDMA8C") __attribute__((section("sfrs")));
extern volatile unsigned int        USBDMA8A __attribute__((section("sfrs")));
typedef struct {
  unsigned DMAADDR:32;
} __USBDMA8Abits_t;
extern volatile __USBDMA8Abits_t USBDMA8Abits __asm__ ("USBDMA8A") __attribute__((section("sfrs")));
extern volatile unsigned int        USBDMA8N __attribute__((section("sfrs")));
typedef struct {
  unsigned DMACOUNT:32;
} __USBDMA8Nbits_t;
extern volatile __USBDMA8Nbits_t USBDMA8Nbits __asm__ ("USBDMA8N") __attribute__((section("sfrs")));
extern volatile unsigned int        USBE1RPC __attribute__((section("sfrs")));
typedef struct {
  unsigned RQPKTCNT:16;
} __USBE1RPCbits_t;
extern volatile __USBE1RPCbits_t USBE1RPCbits __asm__ ("USBE1RPC") __attribute__((section("sfrs")));
extern volatile unsigned int        USBE2RPC __attribute__((section("sfrs")));
typedef struct {
  unsigned RQPKTCNT:16;
} __USBE2RPCbits_t;
extern volatile __USBE2RPCbits_t USBE2RPCbits __asm__ ("USBE2RPC") __attribute__((section("sfrs")));
extern volatile unsigned int        USBE3RPC __attribute__((section("sfrs")));
typedef struct {
  unsigned RQPKTCNT:16;
} __USBE3RPCbits_t;
extern volatile __USBE3RPCbits_t USBE3RPCbits __asm__ ("USBE3RPC") __attribute__((section("sfrs")));
extern volatile unsigned int        USBE4RPC __attribute__((section("sfrs")));
typedef struct {
  unsigned RQPKTCNT:16;
} __USBE4RPCbits_t;
extern volatile __USBE4RPCbits_t USBE4RPCbits __asm__ ("USBE4RPC") __attribute__((section("sfrs")));
extern volatile unsigned int        USBE5RPC __attribute__((section("sfrs")));
typedef struct {
  unsigned RQPKTCNT:16;
} __USBE5RPCbits_t;
extern volatile __USBE5RPCbits_t USBE5RPCbits __asm__ ("USBE5RPC") __attribute__((section("sfrs")));
extern volatile unsigned int        USBE6RPC __attribute__((section("sfrs")));
typedef struct {
  unsigned RQPKTCNT:16;
} __USBE6RPCbits_t;
extern volatile __USBE6RPCbits_t USBE6RPCbits __asm__ ("USBE6RPC") __attribute__((section("sfrs")));
extern volatile unsigned int        USBE7RPC __attribute__((section("sfrs")));
typedef struct {
  unsigned RQPKTCNT:16;
} __USBE7RPCbits_t;
extern volatile __USBE7RPCbits_t USBE7RPCbits __asm__ ("USBE7RPC") __attribute__((section("sfrs")));
extern volatile unsigned int        USBDPBFD __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned EP1RXD:1;
  unsigned EP2RXD:1;
  unsigned EP3RXD:1;
  unsigned EP4RXD:1;
  unsigned EP5RXD:1;
  unsigned EP6RXD:1;
  unsigned EP7RXD:1;
  unsigned :9;
  unsigned EP1TXD:1;
  unsigned EP2TXD:1;
  unsigned EP3TXD:1;
  unsigned EP4TXD:1;
  unsigned EP5TXD:1;
  unsigned EP6TXD:1;
  unsigned EP7TXD:1;
} __USBDPBFDbits_t;
extern volatile __USBDPBFDbits_t USBDPBFDbits __asm__ ("USBDPBFD") __attribute__((section("sfrs")));
extern volatile unsigned int        USBTMCON1 __attribute__((section("sfrs")));
typedef struct {
  unsigned TUCH:16;
  unsigned THHSRTN:16;
} __USBTMCON1bits_t;
extern volatile __USBTMCON1bits_t USBTMCON1bits __asm__ ("USBTMCON1") __attribute__((section("sfrs")));
extern volatile unsigned int        USBTMCON2 __attribute__((section("sfrs")));
typedef struct {
  unsigned THSBT:4;
} __USBTMCON2bits_t;
extern volatile __USBTMCON2bits_t USBTMCON2bits __asm__ ("USBTMCON2") __attribute__((section("sfrs")));
extern volatile unsigned int        USBLPMR1 __attribute__((section("sfrs")));
typedef struct {
  unsigned LNKSTATE:4;
  unsigned HIRD:4;
  unsigned RMTWAK:1;
  unsigned :3;
  unsigned ENDPOINT:4;
  unsigned LPMXMT:1;
  unsigned LPMRES:1;
  unsigned LPMEN:2;
  unsigned LPMNAK:1;
  unsigned :3;
  unsigned LPMTOIE:1;
  unsigned LPMSTIE:1;
  unsigned LPMNYIE:1;
  unsigned LPMACKIE:1;
  unsigned LPMRESIE:1;
  unsigned LPMERRIE:1;
} __USBLPMR1bits_t;
extern volatile __USBLPMR1bits_t USBLPMR1bits __asm__ ("USBLPMR1") __attribute__((section("sfrs")));
extern volatile unsigned int        USBLMPR2 __attribute__((section("sfrs")));
typedef struct {
  unsigned LPMST:1;
  unsigned LPMNY:1;
  unsigned LPMACK:1;
  unsigned LPMNC:1;
  unsigned LPMRES:1;
  unsigned LPMERR:1;
  unsigned :2;
  unsigned LPMFADDR:7;
} __USBLMPR2bits_t;
extern volatile __USBLMPR2bits_t USBLMPR2bits __asm__ ("USBLMPR2") __attribute__((section("sfrs")));
extern volatile unsigned int        CEVER __attribute__((section("sfrs")));
typedef struct {
  unsigned ID:16;
  unsigned VERSION:8;
  unsigned REVISION:8;
} __CEVERbits_t;
extern volatile __CEVERbits_t CEVERbits __asm__ ("CEVER") __attribute__((section("sfrs")));
extern volatile unsigned int        CECON __attribute__((section("sfrs")));
typedef struct {
  unsigned DMAEN:1;
  unsigned BDPPLEN:1;
  unsigned BDPCHST:1;
  unsigned :2;
  unsigned SWAPEN:1;
  unsigned SWRST:1;
} __CECONbits_t;
extern volatile __CECONbits_t CECONbits __asm__ ("CECON") __attribute__((section("sfrs")));
extern volatile unsigned int        CEBDADDR __attribute__((section("sfrs")));
typedef struct {
  unsigned BDPADDR:32;
} __CEBDADDRbits_t;
extern volatile __CEBDADDRbits_t CEBDADDRbits __asm__ ("CEBDADDR") __attribute__((section("sfrs")));
extern volatile unsigned int        CEBDPADDR __attribute__((section("sfrs")));
typedef struct {
  unsigned BASEADDR:32;
} __CEBDPADDRbits_t;
extern volatile __CEBDPADDRbits_t CEBDPADDRbits __asm__ ("CEBDPADDR") __attribute__((section("sfrs")));
extern volatile unsigned int        CESTAT __attribute__((section("sfrs")));
typedef struct {
  unsigned BDCTRL:16;
  unsigned ACTIVE:1;
  unsigned START:1;
  unsigned BDSTATE:4;
  unsigned :2;
  unsigned ERRPHASE:2;
  unsigned ERROP:3;
  unsigned ERRMODE:3;
} __CESTATbits_t;
extern volatile __CESTATbits_t CESTATbits __asm__ ("CESTAT") __attribute__((section("sfrs")));
extern volatile unsigned int        CEINTSRC __attribute__((section("sfrs")));
typedef struct {
  unsigned PENDIF:1;
  unsigned CBDIF:1;
  unsigned PKTIF:1;
  unsigned AREIF:1;
} __CEINTSRCbits_t;
extern volatile __CEINTSRCbits_t CEINTSRCbits __asm__ ("CEINTSRC") __attribute__((section("sfrs")));
extern volatile unsigned int        CEINTEN __attribute__((section("sfrs")));
typedef struct {
  unsigned PENDIE:1;
  unsigned CBDIE:1;
  unsigned PKTIE:1;
  unsigned AREIE:1;
} __CEINTENbits_t;
extern volatile __CEINTENbits_t CEINTENbits __asm__ ("CEINTEN") __attribute__((section("sfrs")));
extern volatile unsigned int        CEPOLLCON __attribute__((section("sfrs")));
typedef struct {
  unsigned BDPPLCON:16;
} __CEPOLLCONbits_t;
extern volatile __CEPOLLCONbits_t CEPOLLCONbits __asm__ ("CEPOLLCON") __attribute__((section("sfrs")));
extern volatile unsigned int        CEHDLEN __attribute__((section("sfrs")));
typedef struct {
  unsigned HDRLEN:8;
} __CEHDLENbits_t;
extern volatile __CEHDLENbits_t CEHDLENbits __asm__ ("CEHDLEN") __attribute__((section("sfrs")));
extern volatile unsigned int        CETRLLEN __attribute__((section("sfrs")));
typedef struct {
  unsigned TRLRLEN:8;
} __CETRLLENbits_t;
extern volatile __CETRLLENbits_t CETRLLENbits __asm__ ("CETRLLEN") __attribute__((section("sfrs")));
extern volatile unsigned int        RNGVER __attribute__((section("sfrs")));
typedef struct {
  unsigned REVISION:7;
  unsigned VERSION:9;
  unsigned ID:16;
} __RNGVERbits_t;
extern volatile __RNGVERbits_t RNGVERbits __asm__ ("RNGVER") __attribute__((section("sfrs")));
extern volatile unsigned int        RNGCON __attribute__((section("sfrs")));
typedef struct {
  unsigned PLEN:8;
  unsigned TRNGEN:1;
  unsigned PRNGEN:1;
  unsigned CONT:1;
  unsigned :1;
  unsigned LOAD:1;
} __RNGCONbits_t;
extern volatile __RNGCONbits_t RNGCONbits __asm__ ("RNGCON") __attribute__((section("sfrs")));
extern volatile unsigned int        RNGPOLY1 __attribute__((section("sfrs")));
typedef struct {
  unsigned POLY:32;
} __RNGPOLY1bits_t;
extern volatile __RNGPOLY1bits_t RNGPOLY1bits __asm__ ("RNGPOLY1") __attribute__((section("sfrs")));
extern volatile unsigned int        RNGPOLY2 __attribute__((section("sfrs")));
typedef struct {
  unsigned POLY:32;
} __RNGPOLY2bits_t;
extern volatile __RNGPOLY2bits_t RNGPOLY2bits __asm__ ("RNGPOLY2") __attribute__((section("sfrs")));
extern volatile unsigned int        RNGNUMGEN1 __attribute__((section("sfrs")));
typedef struct {
  unsigned RNG:32;
} __RNGNUMGEN1bits_t;
extern volatile __RNGNUMGEN1bits_t RNGNUMGEN1bits __asm__ ("RNGNUMGEN1") __attribute__((section("sfrs")));
extern volatile unsigned int        RNGNUMGEN2 __attribute__((section("sfrs")));
typedef struct {
  unsigned RNG:32;
} __RNGNUMGEN2bits_t;
extern volatile __RNGNUMGEN2bits_t RNGNUMGEN2bits __asm__ ("RNGNUMGEN2") __attribute__((section("sfrs")));
extern volatile unsigned int        RNGSEED1 __attribute__((section("sfrs")));
typedef struct {
  unsigned SEED:32;
} __RNGSEED1bits_t;
extern volatile __RNGSEED1bits_t RNGSEED1bits __asm__ ("RNGSEED1") __attribute__((section("sfrs")));
extern volatile unsigned int        RNGSEED2 __attribute__((section("sfrs")));
typedef struct {
  unsigned SEED:32;
} __RNGSEED2bits_t;
extern volatile __RNGSEED2bits_t RNGSEED2bits __asm__ ("RNGSEED2") __attribute__((section("sfrs")));
extern volatile unsigned int        RNGCNT __attribute__((section("sfrs")));
typedef struct {
  unsigned RCNT:7;
} __RNGCNTbits_t;
extern volatile __RNGCNTbits_t RNGCNTbits __asm__ ("RNGCNT") __attribute__((section("sfrs")));
extern volatile unsigned int        SBFLAG __attribute__((section("sfrs")));
typedef struct {
  unsigned T0PGV:1;
  unsigned T1PGV:1;
  unsigned T2PGV:1;
  unsigned T3PGV:1;
  unsigned T4PGV:1;
  unsigned T5PGV:1;
  unsigned T6PGV:1;
  unsigned T7PGV:1;
  unsigned T8PGV:1;
  unsigned T9PGV:1;
  unsigned T10PGV:1;
  unsigned T11PGV:1;
  unsigned T12PGV:1;
  unsigned T13PGV:1;
} __SBFLAGbits_t;
extern volatile __SBFLAGbits_t SBFLAGbits __asm__ ("SBFLAG") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT0ELOG1 __attribute__((section("sfrs")));
typedef struct {
  unsigned CMD:3;
  unsigned :1;
  unsigned REGION:4;
  unsigned INITID:8;
  unsigned :8;
  unsigned CODE:4;
  unsigned :3;
  unsigned MULTI:1;
} __SBT0ELOG1bits_t;
extern volatile __SBT0ELOG1bits_t SBT0ELOG1bits __asm__ ("SBT0ELOG1") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT0ELOG2 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP:2;
} __SBT0ELOG2bits_t;
extern volatile __SBT0ELOG2bits_t SBT0ELOG2bits __asm__ ("SBT0ELOG2") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT0ECON __attribute__((section("sfrs")));
typedef struct {
  unsigned :24;
  unsigned ERRP:1;
} __SBT0ECONbits_t;
extern volatile __SBT0ECONbits_t SBT0ECONbits __asm__ ("SBT0ECON") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT0ECLRS __attribute__((section("sfrs")));
typedef struct {
  unsigned CLEAR:1;
} __SBT0ECLRSbits_t;
extern volatile __SBT0ECLRSbits_t SBT0ECLRSbits __asm__ ("SBT0ECLRS") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT0ECLRM __attribute__((section("sfrs")));
typedef struct {
  unsigned CLEAR:1;
} __SBT0ECLRMbits_t;
extern volatile __SBT0ECLRMbits_t SBT0ECLRMbits __asm__ ("SBT0ECLRM") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT0REG0 __attribute__((section("sfrs")));
typedef struct {
  unsigned :3;
  unsigned SIZE:5;
  unsigned :1;
  unsigned PRI:1;
  unsigned BASE:22;
} __SBT0REG0bits_t;
extern volatile __SBT0REG0bits_t SBT0REG0bits __asm__ ("SBT0REG0") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT0RD0 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT0RD0bits_t;
extern volatile __SBT0RD0bits_t SBT0RD0bits __asm__ ("SBT0RD0") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT0WR0 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT0WR0bits_t;
extern volatile __SBT0WR0bits_t SBT0WR0bits __asm__ ("SBT0WR0") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT0REG1 __attribute__((section("sfrs")));
typedef struct {
  unsigned :3;
  unsigned SIZE:5;
  unsigned :1;
  unsigned PRI:1;
  unsigned BASE:22;
} __SBT0REG1bits_t;
extern volatile __SBT0REG1bits_t SBT0REG1bits __asm__ ("SBT0REG1") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT0RD1 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT0RD1bits_t;
extern volatile __SBT0RD1bits_t SBT0RD1bits __asm__ ("SBT0RD1") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT0WR1 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT0WR1bits_t;
extern volatile __SBT0WR1bits_t SBT0WR1bits __asm__ ("SBT0WR1") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT1ELOG1 __attribute__((section("sfrs")));
typedef struct {
  unsigned CMD:3;
  unsigned :1;
  unsigned REGION:4;
  unsigned INITID:8;
  unsigned :8;
  unsigned CODE:4;
  unsigned :3;
  unsigned MULTI:1;
} __SBT1ELOG1bits_t;
extern volatile __SBT1ELOG1bits_t SBT1ELOG1bits __asm__ ("SBT1ELOG1") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT1ELOG2 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP:2;
} __SBT1ELOG2bits_t;
extern volatile __SBT1ELOG2bits_t SBT1ELOG2bits __asm__ ("SBT1ELOG2") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT1ECON __attribute__((section("sfrs")));
typedef struct {
  unsigned :24;
  unsigned ERRP:1;
} __SBT1ECONbits_t;
extern volatile __SBT1ECONbits_t SBT1ECONbits __asm__ ("SBT1ECON") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT1ECLRS __attribute__((section("sfrs")));
typedef struct {
  unsigned CLEAR:1;
} __SBT1ECLRSbits_t;
extern volatile __SBT1ECLRSbits_t SBT1ECLRSbits __asm__ ("SBT1ECLRS") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT1ECLRM __attribute__((section("sfrs")));
typedef struct {
  unsigned CLEAR:1;
} __SBT1ECLRMbits_t;
extern volatile __SBT1ECLRMbits_t SBT1ECLRMbits __asm__ ("SBT1ECLRM") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT1REG0 __attribute__((section("sfrs")));
typedef struct {
  unsigned :3;
  unsigned SIZE:5;
  unsigned :1;
  unsigned PRI:1;
  unsigned BASE:22;
} __SBT1REG0bits_t;
extern volatile __SBT1REG0bits_t SBT1REG0bits __asm__ ("SBT1REG0") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT1RD0 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT1RD0bits_t;
extern volatile __SBT1RD0bits_t SBT1RD0bits __asm__ ("SBT1RD0") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT1WR0 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT1WR0bits_t;
extern volatile __SBT1WR0bits_t SBT1WR0bits __asm__ ("SBT1WR0") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT1REG2 __attribute__((section("sfrs")));
typedef struct {
  unsigned :3;
  unsigned SIZE:5;
  unsigned :1;
  unsigned PRI:1;
  unsigned BASE:22;
} __SBT1REG2bits_t;
extern volatile __SBT1REG2bits_t SBT1REG2bits __asm__ ("SBT1REG2") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT1RD2 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT1RD2bits_t;
extern volatile __SBT1RD2bits_t SBT1RD2bits __asm__ ("SBT1RD2") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT1WR2 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT1WR2bits_t;
extern volatile __SBT1WR2bits_t SBT1WR2bits __asm__ ("SBT1WR2") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT1REG3 __attribute__((section("sfrs")));
typedef struct {
  unsigned :3;
  unsigned SIZE:5;
  unsigned :1;
  unsigned PRI:1;
  unsigned BASE:22;
} __SBT1REG3bits_t;
extern volatile __SBT1REG3bits_t SBT1REG3bits __asm__ ("SBT1REG3") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT1RD3 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT1RD3bits_t;
extern volatile __SBT1RD3bits_t SBT1RD3bits __asm__ ("SBT1RD3") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT1WR3 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT1WR3bits_t;
extern volatile __SBT1WR3bits_t SBT1WR3bits __asm__ ("SBT1WR3") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT1REG4 __attribute__((section("sfrs")));
typedef struct {
  unsigned :3;
  unsigned SIZE:5;
  unsigned :1;
  unsigned PRI:1;
  unsigned BASE:22;
} __SBT1REG4bits_t;
extern volatile __SBT1REG4bits_t SBT1REG4bits __asm__ ("SBT1REG4") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT1RD4 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT1RD4bits_t;
extern volatile __SBT1RD4bits_t SBT1RD4bits __asm__ ("SBT1RD4") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT1WR4 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT1WR4bits_t;
extern volatile __SBT1WR4bits_t SBT1WR4bits __asm__ ("SBT1WR4") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT1REG5 __attribute__((section("sfrs")));
typedef struct {
  unsigned :3;
  unsigned SIZE:5;
  unsigned :1;
  unsigned PRI:1;
  unsigned BASE:22;
} __SBT1REG5bits_t;
extern volatile __SBT1REG5bits_t SBT1REG5bits __asm__ ("SBT1REG5") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT1RD5 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT1RD5bits_t;
extern volatile __SBT1RD5bits_t SBT1RD5bits __asm__ ("SBT1RD5") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT1WR5 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT1WR5bits_t;
extern volatile __SBT1WR5bits_t SBT1WR5bits __asm__ ("SBT1WR5") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT1REG6 __attribute__((section("sfrs")));
typedef struct {
  unsigned :3;
  unsigned SIZE:5;
  unsigned :1;
  unsigned PRI:1;
  unsigned BASE:22;
} __SBT1REG6bits_t;
extern volatile __SBT1REG6bits_t SBT1REG6bits __asm__ ("SBT1REG6") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT1RD6 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT1RD6bits_t;
extern volatile __SBT1RD6bits_t SBT1RD6bits __asm__ ("SBT1RD6") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT1WR6 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT1WR6bits_t;
extern volatile __SBT1WR6bits_t SBT1WR6bits __asm__ ("SBT1WR6") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT1REG7 __attribute__((section("sfrs")));
typedef struct {
  unsigned :3;
  unsigned SIZE:5;
  unsigned :1;
  unsigned PRI:1;
  unsigned BASE:22;
} __SBT1REG7bits_t;
extern volatile __SBT1REG7bits_t SBT1REG7bits __asm__ ("SBT1REG7") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT1RD7 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT1RD7bits_t;
extern volatile __SBT1RD7bits_t SBT1RD7bits __asm__ ("SBT1RD7") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT1WR7 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT1WR7bits_t;
extern volatile __SBT1WR7bits_t SBT1WR7bits __asm__ ("SBT1WR7") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT1REG8 __attribute__((section("sfrs")));
typedef struct {
  unsigned :3;
  unsigned SIZE:5;
  unsigned :1;
  unsigned PRI:1;
  unsigned BASE:22;
} __SBT1REG8bits_t;
extern volatile __SBT1REG8bits_t SBT1REG8bits __asm__ ("SBT1REG8") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT1RD8 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT1RD8bits_t;
extern volatile __SBT1RD8bits_t SBT1RD8bits __asm__ ("SBT1RD8") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT1WR8 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT1WR8bits_t;
extern volatile __SBT1WR8bits_t SBT1WR8bits __asm__ ("SBT1WR8") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT2ELOG1 __attribute__((section("sfrs")));
typedef struct {
  unsigned CMD:3;
  unsigned :1;
  unsigned REGION:4;
  unsigned INITID:8;
  unsigned :8;
  unsigned CODE:4;
  unsigned :3;
  unsigned MULTI:1;
} __SBT2ELOG1bits_t;
extern volatile __SBT2ELOG1bits_t SBT2ELOG1bits __asm__ ("SBT2ELOG1") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT2ELOG2 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP:2;
} __SBT2ELOG2bits_t;
extern volatile __SBT2ELOG2bits_t SBT2ELOG2bits __asm__ ("SBT2ELOG2") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT2ECON __attribute__((section("sfrs")));
typedef struct {
  unsigned :24;
  unsigned ERRP:1;
} __SBT2ECONbits_t;
extern volatile __SBT2ECONbits_t SBT2ECONbits __asm__ ("SBT2ECON") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT2ECLRS __attribute__((section("sfrs")));
typedef struct {
  unsigned CLEAR:1;
} __SBT2ECLRSbits_t;
extern volatile __SBT2ECLRSbits_t SBT2ECLRSbits __asm__ ("SBT2ECLRS") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT2ECLRM __attribute__((section("sfrs")));
typedef struct {
  unsigned CLEAR:1;
} __SBT2ECLRMbits_t;
extern volatile __SBT2ECLRMbits_t SBT2ECLRMbits __asm__ ("SBT2ECLRM") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT2REG0 __attribute__((section("sfrs")));
typedef struct {
  unsigned :3;
  unsigned SIZE:5;
  unsigned :1;
  unsigned PRI:1;
  unsigned BASE:22;
} __SBT2REG0bits_t;
extern volatile __SBT2REG0bits_t SBT2REG0bits __asm__ ("SBT2REG0") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT2RD0 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT2RD0bits_t;
extern volatile __SBT2RD0bits_t SBT2RD0bits __asm__ ("SBT2RD0") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT2WR0 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT2WR0bits_t;
extern volatile __SBT2WR0bits_t SBT2WR0bits __asm__ ("SBT2WR0") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT2REG1 __attribute__((section("sfrs")));
typedef struct {
  unsigned :3;
  unsigned SIZE:5;
  unsigned :1;
  unsigned PRI:1;
  unsigned BASE:22;
} __SBT2REG1bits_t;
extern volatile __SBT2REG1bits_t SBT2REG1bits __asm__ ("SBT2REG1") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT2RD1 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT2RD1bits_t;
extern volatile __SBT2RD1bits_t SBT2RD1bits __asm__ ("SBT2RD1") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT2WR1 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT2WR1bits_t;
extern volatile __SBT2WR1bits_t SBT2WR1bits __asm__ ("SBT2WR1") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT2REG2 __attribute__((section("sfrs")));
typedef struct {
  unsigned :3;
  unsigned SIZE:5;
  unsigned :1;
  unsigned PRI:1;
  unsigned BASE:22;
} __SBT2REG2bits_t;
extern volatile __SBT2REG2bits_t SBT2REG2bits __asm__ ("SBT2REG2") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT2RD2 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT2RD2bits_t;
extern volatile __SBT2RD2bits_t SBT2RD2bits __asm__ ("SBT2RD2") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT2WR2 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT2WR2bits_t;
extern volatile __SBT2WR2bits_t SBT2WR2bits __asm__ ("SBT2WR2") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT3ELOG1 __attribute__((section("sfrs")));
typedef struct {
  unsigned CMD:3;
  unsigned :1;
  unsigned REGION:4;
  unsigned INITID:8;
  unsigned :8;
  unsigned CODE:4;
  unsigned :3;
  unsigned MULTI:1;
} __SBT3ELOG1bits_t;
extern volatile __SBT3ELOG1bits_t SBT3ELOG1bits __asm__ ("SBT3ELOG1") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT3ELOG2 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP:2;
} __SBT3ELOG2bits_t;
extern volatile __SBT3ELOG2bits_t SBT3ELOG2bits __asm__ ("SBT3ELOG2") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT3ECON __attribute__((section("sfrs")));
typedef struct {
  unsigned :24;
  unsigned ERRP:1;
} __SBT3ECONbits_t;
extern volatile __SBT3ECONbits_t SBT3ECONbits __asm__ ("SBT3ECON") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT3ECLRS __attribute__((section("sfrs")));
typedef struct {
  unsigned CLEAR:1;
} __SBT3ECLRSbits_t;
extern volatile __SBT3ECLRSbits_t SBT3ECLRSbits __asm__ ("SBT3ECLRS") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT3ECLRM __attribute__((section("sfrs")));
typedef struct {
  unsigned CLEAR:1;
} __SBT3ECLRMbits_t;
extern volatile __SBT3ECLRMbits_t SBT3ECLRMbits __asm__ ("SBT3ECLRM") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT3REG0 __attribute__((section("sfrs")));
typedef struct {
  unsigned :3;
  unsigned SIZE:5;
  unsigned :1;
  unsigned PRI:1;
  unsigned BASE:22;
} __SBT3REG0bits_t;
extern volatile __SBT3REG0bits_t SBT3REG0bits __asm__ ("SBT3REG0") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT3RD0 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT3RD0bits_t;
extern volatile __SBT3RD0bits_t SBT3RD0bits __asm__ ("SBT3RD0") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT3WR0 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT3WR0bits_t;
extern volatile __SBT3WR0bits_t SBT3WR0bits __asm__ ("SBT3WR0") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT3REG1 __attribute__((section("sfrs")));
typedef struct {
  unsigned :3;
  unsigned SIZE:5;
  unsigned :1;
  unsigned PRI:1;
  unsigned BASE:22;
} __SBT3REG1bits_t;
extern volatile __SBT3REG1bits_t SBT3REG1bits __asm__ ("SBT3REG1") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT3RD1 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT3RD1bits_t;
extern volatile __SBT3RD1bits_t SBT3RD1bits __asm__ ("SBT3RD1") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT3WR1 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT3WR1bits_t;
extern volatile __SBT3WR1bits_t SBT3WR1bits __asm__ ("SBT3WR1") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT3REG2 __attribute__((section("sfrs")));
typedef struct {
  unsigned :3;
  unsigned SIZE:5;
  unsigned :1;
  unsigned PRI:1;
  unsigned BASE:22;
} __SBT3REG2bits_t;
extern volatile __SBT3REG2bits_t SBT3REG2bits __asm__ ("SBT3REG2") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT3RD2 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT3RD2bits_t;
extern volatile __SBT3RD2bits_t SBT3RD2bits __asm__ ("SBT3RD2") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT3WR2 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT3WR2bits_t;
extern volatile __SBT3WR2bits_t SBT3WR2bits __asm__ ("SBT3WR2") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT4ELOG1 __attribute__((section("sfrs")));
typedef struct {
  unsigned CMD:3;
  unsigned :1;
  unsigned REGION:4;
  unsigned INITID:8;
  unsigned :8;
  unsigned CODE:4;
  unsigned :3;
  unsigned MULTI:1;
} __SBT4ELOG1bits_t;
extern volatile __SBT4ELOG1bits_t SBT4ELOG1bits __asm__ ("SBT4ELOG1") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT4ELOG2 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP:2;
} __SBT4ELOG2bits_t;
extern volatile __SBT4ELOG2bits_t SBT4ELOG2bits __asm__ ("SBT4ELOG2") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT4ECON __attribute__((section("sfrs")));
typedef struct {
  unsigned :24;
  unsigned ERRP:1;
} __SBT4ECONbits_t;
extern volatile __SBT4ECONbits_t SBT4ECONbits __asm__ ("SBT4ECON") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT4ECLRS __attribute__((section("sfrs")));
typedef struct {
  unsigned CLEAR:1;
} __SBT4ECLRSbits_t;
extern volatile __SBT4ECLRSbits_t SBT4ECLRSbits __asm__ ("SBT4ECLRS") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT4ECLRM __attribute__((section("sfrs")));
typedef struct {
  unsigned CLEAR:1;
} __SBT4ECLRMbits_t;
extern volatile __SBT4ECLRMbits_t SBT4ECLRMbits __asm__ ("SBT4ECLRM") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT4REG0 __attribute__((section("sfrs")));
typedef struct {
  unsigned :3;
  unsigned SIZE:5;
  unsigned :1;
  unsigned PRI:1;
  unsigned BASE:22;
} __SBT4REG0bits_t;
extern volatile __SBT4REG0bits_t SBT4REG0bits __asm__ ("SBT4REG0") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT4RD0 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT4RD0bits_t;
extern volatile __SBT4RD0bits_t SBT4RD0bits __asm__ ("SBT4RD0") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT4WR0 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT4WR0bits_t;
extern volatile __SBT4WR0bits_t SBT4WR0bits __asm__ ("SBT4WR0") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT4REG2 __attribute__((section("sfrs")));
typedef struct {
  unsigned :3;
  unsigned SIZE:5;
  unsigned :1;
  unsigned PRI:1;
  unsigned BASE:22;
} __SBT4REG2bits_t;
extern volatile __SBT4REG2bits_t SBT4REG2bits __asm__ ("SBT4REG2") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT4RD2 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT4RD2bits_t;
extern volatile __SBT4RD2bits_t SBT4RD2bits __asm__ ("SBT4RD2") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT4WR2 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT4WR2bits_t;
extern volatile __SBT4WR2bits_t SBT4WR2bits __asm__ ("SBT4WR2") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT5ELOG1 __attribute__((section("sfrs")));
typedef struct {
  unsigned CMD:3;
  unsigned :1;
  unsigned REGION:4;
  unsigned INITID:8;
  unsigned :8;
  unsigned CODE:4;
  unsigned :3;
  unsigned MULTI:1;
} __SBT5ELOG1bits_t;
extern volatile __SBT5ELOG1bits_t SBT5ELOG1bits __asm__ ("SBT5ELOG1") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT5ELOG2 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP:2;
} __SBT5ELOG2bits_t;
extern volatile __SBT5ELOG2bits_t SBT5ELOG2bits __asm__ ("SBT5ELOG2") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT5ECON __attribute__((section("sfrs")));
typedef struct {
  unsigned :24;
  unsigned ERRP:1;
} __SBT5ECONbits_t;
extern volatile __SBT5ECONbits_t SBT5ECONbits __asm__ ("SBT5ECON") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT5ECLRS __attribute__((section("sfrs")));
typedef struct {
  unsigned CLEAR:1;
} __SBT5ECLRSbits_t;
extern volatile __SBT5ECLRSbits_t SBT5ECLRSbits __asm__ ("SBT5ECLRS") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT5ECLRM __attribute__((section("sfrs")));
typedef struct {
  unsigned CLEAR:1;
} __SBT5ECLRMbits_t;
extern volatile __SBT5ECLRMbits_t SBT5ECLRMbits __asm__ ("SBT5ECLRM") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT5REG0 __attribute__((section("sfrs")));
typedef struct {
  unsigned :3;
  unsigned SIZE:5;
  unsigned :1;
  unsigned PRI:1;
  unsigned BASE:22;
} __SBT5REG0bits_t;
extern volatile __SBT5REG0bits_t SBT5REG0bits __asm__ ("SBT5REG0") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT5RD0 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT5RD0bits_t;
extern volatile __SBT5RD0bits_t SBT5RD0bits __asm__ ("SBT5RD0") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT5WR0 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT5WR0bits_t;
extern volatile __SBT5WR0bits_t SBT5WR0bits __asm__ ("SBT5WR0") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT5REG1 __attribute__((section("sfrs")));
typedef struct {
  unsigned :3;
  unsigned SIZE:5;
  unsigned :1;
  unsigned PRI:1;
  unsigned BASE:22;
} __SBT5REG1bits_t;
extern volatile __SBT5REG1bits_t SBT5REG1bits __asm__ ("SBT5REG1") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT5RD1 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT5RD1bits_t;
extern volatile __SBT5RD1bits_t SBT5RD1bits __asm__ ("SBT5RD1") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT5WR1 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT5WR1bits_t;
extern volatile __SBT5WR1bits_t SBT5WR1bits __asm__ ("SBT5WR1") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT5REG2 __attribute__((section("sfrs")));
typedef struct {
  unsigned :3;
  unsigned SIZE:5;
  unsigned :1;
  unsigned PRI:1;
  unsigned BASE:22;
} __SBT5REG2bits_t;
extern volatile __SBT5REG2bits_t SBT5REG2bits __asm__ ("SBT5REG2") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT5RD2 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT5RD2bits_t;
extern volatile __SBT5RD2bits_t SBT5RD2bits __asm__ ("SBT5RD2") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT5WR2 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT5WR2bits_t;
extern volatile __SBT5WR2bits_t SBT5WR2bits __asm__ ("SBT5WR2") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT6ELOG1 __attribute__((section("sfrs")));
typedef struct {
  unsigned CMD:3;
  unsigned :1;
  unsigned REGION:4;
  unsigned INITID:8;
  unsigned :8;
  unsigned CODE:4;
  unsigned :3;
  unsigned MULTI:1;
} __SBT6ELOG1bits_t;
extern volatile __SBT6ELOG1bits_t SBT6ELOG1bits __asm__ ("SBT6ELOG1") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT6ELOG2 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP:2;
} __SBT6ELOG2bits_t;
extern volatile __SBT6ELOG2bits_t SBT6ELOG2bits __asm__ ("SBT6ELOG2") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT6ECON __attribute__((section("sfrs")));
typedef struct {
  unsigned :24;
  unsigned ERRP:1;
} __SBT6ECONbits_t;
extern volatile __SBT6ECONbits_t SBT6ECONbits __asm__ ("SBT6ECON") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT6ECLRS __attribute__((section("sfrs")));
typedef struct {
  unsigned CLEAR:1;
} __SBT6ECLRSbits_t;
extern volatile __SBT6ECLRSbits_t SBT6ECLRSbits __asm__ ("SBT6ECLRS") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT6ECLRM __attribute__((section("sfrs")));
typedef struct {
  unsigned CLEAR:1;
} __SBT6ECLRMbits_t;
extern volatile __SBT6ECLRMbits_t SBT6ECLRMbits __asm__ ("SBT6ECLRM") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT6REG0 __attribute__((section("sfrs")));
typedef struct {
  unsigned :3;
  unsigned SIZE:5;
  unsigned :1;
  unsigned PRI:1;
  unsigned BASE:22;
} __SBT6REG0bits_t;
extern volatile __SBT6REG0bits_t SBT6REG0bits __asm__ ("SBT6REG0") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT6RD0 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT6RD0bits_t;
extern volatile __SBT6RD0bits_t SBT6RD0bits __asm__ ("SBT6RD0") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT6WR0 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT6WR0bits_t;
extern volatile __SBT6WR0bits_t SBT6WR0bits __asm__ ("SBT6WR0") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT6REG1 __attribute__((section("sfrs")));
typedef struct {
  unsigned :3;
  unsigned SIZE:5;
  unsigned :1;
  unsigned PRI:1;
  unsigned BASE:22;
} __SBT6REG1bits_t;
extern volatile __SBT6REG1bits_t SBT6REG1bits __asm__ ("SBT6REG1") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT6RD1 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT6RD1bits_t;
extern volatile __SBT6RD1bits_t SBT6RD1bits __asm__ ("SBT6RD1") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT6WR1 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT6WR1bits_t;
extern volatile __SBT6WR1bits_t SBT6WR1bits __asm__ ("SBT6WR1") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT7ELOG1 __attribute__((section("sfrs")));
typedef struct {
  unsigned CMD:3;
  unsigned :1;
  unsigned REGION:4;
  unsigned INITID:8;
  unsigned :8;
  unsigned CODE:4;
  unsigned :3;
  unsigned MULTI:1;
} __SBT7ELOG1bits_t;
extern volatile __SBT7ELOG1bits_t SBT7ELOG1bits __asm__ ("SBT7ELOG1") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT7ELOG2 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP:2;
} __SBT7ELOG2bits_t;
extern volatile __SBT7ELOG2bits_t SBT7ELOG2bits __asm__ ("SBT7ELOG2") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT7ECON __attribute__((section("sfrs")));
typedef struct {
  unsigned :24;
  unsigned ERRP:1;
} __SBT7ECONbits_t;
extern volatile __SBT7ECONbits_t SBT7ECONbits __asm__ ("SBT7ECON") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT7ECLRS __attribute__((section("sfrs")));
typedef struct {
  unsigned CLEAR:1;
} __SBT7ECLRSbits_t;
extern volatile __SBT7ECLRSbits_t SBT7ECLRSbits __asm__ ("SBT7ECLRS") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT7ECLRM __attribute__((section("sfrs")));
typedef struct {
  unsigned CLEAR:1;
} __SBT7ECLRMbits_t;
extern volatile __SBT7ECLRMbits_t SBT7ECLRMbits __asm__ ("SBT7ECLRM") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT7REG0 __attribute__((section("sfrs")));
typedef struct {
  unsigned :3;
  unsigned SIZE:5;
  unsigned :1;
  unsigned PRI:1;
  unsigned BASE:22;
} __SBT7REG0bits_t;
extern volatile __SBT7REG0bits_t SBT7REG0bits __asm__ ("SBT7REG0") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT7RD0 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT7RD0bits_t;
extern volatile __SBT7RD0bits_t SBT7RD0bits __asm__ ("SBT7RD0") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT7WR0 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT7WR0bits_t;
extern volatile __SBT7WR0bits_t SBT7WR0bits __asm__ ("SBT7WR0") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT7REG1 __attribute__((section("sfrs")));
typedef struct {
  unsigned :3;
  unsigned SIZE:5;
  unsigned :1;
  unsigned PRI:1;
  unsigned BASE:22;
} __SBT7REG1bits_t;
extern volatile __SBT7REG1bits_t SBT7REG1bits __asm__ ("SBT7REG1") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT7RD1 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT7RD1bits_t;
extern volatile __SBT7RD1bits_t SBT7RD1bits __asm__ ("SBT7RD1") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT7WR1 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT7WR1bits_t;
extern volatile __SBT7WR1bits_t SBT7WR1bits __asm__ ("SBT7WR1") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT8ELOG1 __attribute__((section("sfrs")));
typedef struct {
  unsigned CMD:3;
  unsigned :1;
  unsigned REGION:4;
  unsigned INITID:8;
  unsigned :8;
  unsigned CODE:4;
  unsigned :3;
  unsigned MULTI:1;
} __SBT8ELOG1bits_t;
extern volatile __SBT8ELOG1bits_t SBT8ELOG1bits __asm__ ("SBT8ELOG1") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT8ELOG2 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP:2;
} __SBT8ELOG2bits_t;
extern volatile __SBT8ELOG2bits_t SBT8ELOG2bits __asm__ ("SBT8ELOG2") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT8ECON __attribute__((section("sfrs")));
typedef struct {
  unsigned :24;
  unsigned ERRP:1;
} __SBT8ECONbits_t;
extern volatile __SBT8ECONbits_t SBT8ECONbits __asm__ ("SBT8ECON") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT8ECLRS __attribute__((section("sfrs")));
typedef struct {
  unsigned CLEAR:1;
} __SBT8ECLRSbits_t;
extern volatile __SBT8ECLRSbits_t SBT8ECLRSbits __asm__ ("SBT8ECLRS") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT8ECLRM __attribute__((section("sfrs")));
typedef struct {
  unsigned CLEAR:1;
} __SBT8ECLRMbits_t;
extern volatile __SBT8ECLRMbits_t SBT8ECLRMbits __asm__ ("SBT8ECLRM") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT8REG0 __attribute__((section("sfrs")));
typedef struct {
  unsigned :3;
  unsigned SIZE:5;
  unsigned :1;
  unsigned PRI:1;
  unsigned BASE:22;
} __SBT8REG0bits_t;
extern volatile __SBT8REG0bits_t SBT8REG0bits __asm__ ("SBT8REG0") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT8RD0 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT8RD0bits_t;
extern volatile __SBT8RD0bits_t SBT8RD0bits __asm__ ("SBT8RD0") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT8WR0 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT8WR0bits_t;
extern volatile __SBT8WR0bits_t SBT8WR0bits __asm__ ("SBT8WR0") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT8REG1 __attribute__((section("sfrs")));
typedef struct {
  unsigned :3;
  unsigned SIZE:5;
  unsigned :1;
  unsigned PRI:1;
  unsigned BASE:22;
} __SBT8REG1bits_t;
extern volatile __SBT8REG1bits_t SBT8REG1bits __asm__ ("SBT8REG1") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT8RD1 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT8RD1bits_t;
extern volatile __SBT8RD1bits_t SBT8RD1bits __asm__ ("SBT8RD1") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT8WR1 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT8WR1bits_t;
extern volatile __SBT8WR1bits_t SBT8WR1bits __asm__ ("SBT8WR1") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT9ELOG1 __attribute__((section("sfrs")));
typedef struct {
  unsigned CMD:3;
  unsigned :1;
  unsigned REGION:4;
  unsigned INITID:8;
  unsigned :8;
  unsigned CODE:4;
  unsigned :3;
  unsigned MULTI:1;
} __SBT9ELOG1bits_t;
extern volatile __SBT9ELOG1bits_t SBT9ELOG1bits __asm__ ("SBT9ELOG1") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT9ELOG2 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP:2;
} __SBT9ELOG2bits_t;
extern volatile __SBT9ELOG2bits_t SBT9ELOG2bits __asm__ ("SBT9ELOG2") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT9ECON __attribute__((section("sfrs")));
typedef struct {
  unsigned :24;
  unsigned ERRP:1;
} __SBT9ECONbits_t;
extern volatile __SBT9ECONbits_t SBT9ECONbits __asm__ ("SBT9ECON") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT9ECLRS __attribute__((section("sfrs")));
typedef struct {
  unsigned CLEAR:1;
} __SBT9ECLRSbits_t;
extern volatile __SBT9ECLRSbits_t SBT9ECLRSbits __asm__ ("SBT9ECLRS") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT9ECLRM __attribute__((section("sfrs")));
typedef struct {
  unsigned CLEAR:1;
} __SBT9ECLRMbits_t;
extern volatile __SBT9ECLRMbits_t SBT9ECLRMbits __asm__ ("SBT9ECLRM") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT9REG0 __attribute__((section("sfrs")));
typedef struct {
  unsigned :3;
  unsigned SIZE:5;
  unsigned :1;
  unsigned PRI:1;
  unsigned BASE:22;
} __SBT9REG0bits_t;
extern volatile __SBT9REG0bits_t SBT9REG0bits __asm__ ("SBT9REG0") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT9RD0 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT9RD0bits_t;
extern volatile __SBT9RD0bits_t SBT9RD0bits __asm__ ("SBT9RD0") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT9WR0 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT9WR0bits_t;
extern volatile __SBT9WR0bits_t SBT9WR0bits __asm__ ("SBT9WR0") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT9REG1 __attribute__((section("sfrs")));
typedef struct {
  unsigned :3;
  unsigned SIZE:5;
  unsigned :1;
  unsigned PRI:1;
  unsigned BASE:22;
} __SBT9REG1bits_t;
extern volatile __SBT9REG1bits_t SBT9REG1bits __asm__ ("SBT9REG1") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT9RD1 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT9RD1bits_t;
extern volatile __SBT9RD1bits_t SBT9RD1bits __asm__ ("SBT9RD1") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT9WR1 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT9WR1bits_t;
extern volatile __SBT9WR1bits_t SBT9WR1bits __asm__ ("SBT9WR1") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT10ELOG1 __attribute__((section("sfrs")));
typedef struct {
  unsigned CMD:3;
  unsigned :1;
  unsigned REGION:4;
  unsigned INITID:8;
  unsigned :8;
  unsigned CODE:4;
  unsigned :3;
  unsigned MULTI:1;
} __SBT10ELOG1bits_t;
extern volatile __SBT10ELOG1bits_t SBT10ELOG1bits __asm__ ("SBT10ELOG1") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT10ELOG2 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP:2;
} __SBT10ELOG2bits_t;
extern volatile __SBT10ELOG2bits_t SBT10ELOG2bits __asm__ ("SBT10ELOG2") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT10ECON __attribute__((section("sfrs")));
typedef struct {
  unsigned :24;
  unsigned ERRP:1;
} __SBT10ECONbits_t;
extern volatile __SBT10ECONbits_t SBT10ECONbits __asm__ ("SBT10ECON") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT10ECLRS __attribute__((section("sfrs")));
typedef struct {
  unsigned CLEAR:1;
} __SBT10ECLRSbits_t;
extern volatile __SBT10ECLRSbits_t SBT10ECLRSbits __asm__ ("SBT10ECLRS") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT10ECLRM __attribute__((section("sfrs")));
typedef struct {
  unsigned CLEAR:1;
} __SBT10ECLRMbits_t;
extern volatile __SBT10ECLRMbits_t SBT10ECLRMbits __asm__ ("SBT10ECLRM") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT10REG0 __attribute__((section("sfrs")));
typedef struct {
  unsigned :3;
  unsigned SIZE:5;
  unsigned :1;
  unsigned PRI:1;
  unsigned BASE:22;
} __SBT10REG0bits_t;
extern volatile __SBT10REG0bits_t SBT10REG0bits __asm__ ("SBT10REG0") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT10RD0 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT10RD0bits_t;
extern volatile __SBT10RD0bits_t SBT10RD0bits __asm__ ("SBT10RD0") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT10WR0 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT10WR0bits_t;
extern volatile __SBT10WR0bits_t SBT10WR0bits __asm__ ("SBT10WR0") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT11ELOG1 __attribute__((section("sfrs")));
typedef struct {
  unsigned CMD:3;
  unsigned :1;
  unsigned REGION:4;
  unsigned INITID:8;
  unsigned :8;
  unsigned CODE:4;
  unsigned :3;
  unsigned MULTI:1;
} __SBT11ELOG1bits_t;
extern volatile __SBT11ELOG1bits_t SBT11ELOG1bits __asm__ ("SBT11ELOG1") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT11ELOG2 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP:2;
} __SBT11ELOG2bits_t;
extern volatile __SBT11ELOG2bits_t SBT11ELOG2bits __asm__ ("SBT11ELOG2") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT11ECON __attribute__((section("sfrs")));
typedef struct {
  unsigned :24;
  unsigned ERRP:1;
} __SBT11ECONbits_t;
extern volatile __SBT11ECONbits_t SBT11ECONbits __asm__ ("SBT11ECON") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT11ECLRS __attribute__((section("sfrs")));
typedef struct {
  unsigned CLEAR:1;
} __SBT11ECLRSbits_t;
extern volatile __SBT11ECLRSbits_t SBT11ECLRSbits __asm__ ("SBT11ECLRS") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT11ECLRM __attribute__((section("sfrs")));
typedef struct {
  unsigned CLEAR:1;
} __SBT11ECLRMbits_t;
extern volatile __SBT11ECLRMbits_t SBT11ECLRMbits __asm__ ("SBT11ECLRM") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT11REG0 __attribute__((section("sfrs")));
typedef struct {
  unsigned :3;
  unsigned SIZE:5;
  unsigned :1;
  unsigned PRI:1;
  unsigned BASE:22;
} __SBT11REG0bits_t;
extern volatile __SBT11REG0bits_t SBT11REG0bits __asm__ ("SBT11REG0") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT11RD0 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT11RD0bits_t;
extern volatile __SBT11RD0bits_t SBT11RD0bits __asm__ ("SBT11RD0") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT11WR0 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT11WR0bits_t;
extern volatile __SBT11WR0bits_t SBT11WR0bits __asm__ ("SBT11WR0") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT11REG1 __attribute__((section("sfrs")));
typedef struct {
  unsigned :3;
  unsigned SIZE:5;
  unsigned :1;
  unsigned PRI:1;
  unsigned BASE:22;
} __SBT11REG1bits_t;
extern volatile __SBT11REG1bits_t SBT11REG1bits __asm__ ("SBT11REG1") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT11RD1 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT11RD1bits_t;
extern volatile __SBT11RD1bits_t SBT11RD1bits __asm__ ("SBT11RD1") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT11WR1 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT11WR1bits_t;
extern volatile __SBT11WR1bits_t SBT11WR1bits __asm__ ("SBT11WR1") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT12ELOG1 __attribute__((section("sfrs")));
typedef struct {
  unsigned CMD:3;
  unsigned :1;
  unsigned REGION:4;
  unsigned INITID:8;
  unsigned :8;
  unsigned CODE:4;
  unsigned :3;
  unsigned MULTI:1;
} __SBT12ELOG1bits_t;
extern volatile __SBT12ELOG1bits_t SBT12ELOG1bits __asm__ ("SBT12ELOG1") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT12ELOG2 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP:2;
} __SBT12ELOG2bits_t;
extern volatile __SBT12ELOG2bits_t SBT12ELOG2bits __asm__ ("SBT12ELOG2") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT12ECON __attribute__((section("sfrs")));
typedef struct {
  unsigned :24;
  unsigned ERRP:1;
} __SBT12ECONbits_t;
extern volatile __SBT12ECONbits_t SBT12ECONbits __asm__ ("SBT12ECON") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT12ECLRS __attribute__((section("sfrs")));
typedef struct {
  unsigned CLEAR:1;
} __SBT12ECLRSbits_t;
extern volatile __SBT12ECLRSbits_t SBT12ECLRSbits __asm__ ("SBT12ECLRS") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT12ECLRM __attribute__((section("sfrs")));
typedef struct {
  unsigned CLEAR:1;
} __SBT12ECLRMbits_t;
extern volatile __SBT12ECLRMbits_t SBT12ECLRMbits __asm__ ("SBT12ECLRM") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT12REG0 __attribute__((section("sfrs")));
typedef struct {
  unsigned :3;
  unsigned SIZE:5;
  unsigned :1;
  unsigned PRI:1;
  unsigned BASE:22;
} __SBT12REG0bits_t;
extern volatile __SBT12REG0bits_t SBT12REG0bits __asm__ ("SBT12REG0") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT12RD0 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT12RD0bits_t;
extern volatile __SBT12RD0bits_t SBT12RD0bits __asm__ ("SBT12RD0") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT12WR0 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT12WR0bits_t;
extern volatile __SBT12WR0bits_t SBT12WR0bits __asm__ ("SBT12WR0") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT13ELOG1 __attribute__((section("sfrs")));
typedef struct {
  unsigned CMD:3;
  unsigned :1;
  unsigned REGION:4;
  unsigned INITID:8;
  unsigned :8;
  unsigned CODE:4;
  unsigned :3;
  unsigned MULTI:1;
} __SBT13ELOG1bits_t;
extern volatile __SBT13ELOG1bits_t SBT13ELOG1bits __asm__ ("SBT13ELOG1") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT13ELOG2 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP:2;
} __SBT13ELOG2bits_t;
extern volatile __SBT13ELOG2bits_t SBT13ELOG2bits __asm__ ("SBT13ELOG2") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT13ECON __attribute__((section("sfrs")));
typedef struct {
  unsigned :24;
  unsigned ERRP:1;
} __SBT13ECONbits_t;
extern volatile __SBT13ECONbits_t SBT13ECONbits __asm__ ("SBT13ECON") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT13ECLRS __attribute__((section("sfrs")));
typedef struct {
  unsigned CLEAR:1;
} __SBT13ECLRSbits_t;
extern volatile __SBT13ECLRSbits_t SBT13ECLRSbits __asm__ ("SBT13ECLRS") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT13ECLRM __attribute__((section("sfrs")));
typedef struct {
  unsigned CLEAR:1;
} __SBT13ECLRMbits_t;
extern volatile __SBT13ECLRMbits_t SBT13ECLRMbits __asm__ ("SBT13ECLRM") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT13REG0 __attribute__((section("sfrs")));
typedef struct {
  unsigned :3;
  unsigned SIZE:5;
  unsigned :1;
  unsigned PRI:1;
  unsigned BASE:22;
} __SBT13REG0bits_t;
extern volatile __SBT13REG0bits_t SBT13REG0bits __asm__ ("SBT13REG0") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT13RD0 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT13RD0bits_t;
extern volatile __SBT13RD0bits_t SBT13RD0bits __asm__ ("SBT13RD0") __attribute__((section("sfrs")));
extern volatile unsigned int        SBT13WR0 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT13WR0bits_t;
extern volatile __SBT13WR0bits_t SBT13WR0bits __asm__ ("SBT13WR0") __attribute__((section("sfrs")));
extern volatile unsigned int        DEVCFG3 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned USERID:16;
    unsigned :8;
    unsigned FMIIEN:1;
    unsigned FETHIO:1;
    unsigned :1;
    unsigned PGL1WAY:1;
    unsigned PMDL1WAY:1;
    unsigned IOL1WAY:1;
    unsigned FUSBIDIO:1;
  };
  struct {
    unsigned w:32;
  };
} __DEVCFG3bits_t;
extern volatile __DEVCFG3bits_t DEVCFG3bits __asm__ ("DEVCFG3") __attribute__((section("sfrs")));
extern volatile unsigned int        DEVCFG2 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned FPLLIDIV:3;
    unsigned :1;
    unsigned FPLLRNG:3;
    unsigned FPLLICLK:1;
    unsigned FPLLMULT:7;
    unsigned :1;
    unsigned FPLLODIV:3;
    unsigned :11;
    unsigned UPLLFSEL:1;
    unsigned UPLLEN:1;
  };
  struct {
    unsigned w:32;
  };
} __DEVCFG2bits_t;
extern volatile __DEVCFG2bits_t DEVCFG2bits __asm__ ("DEVCFG2") __attribute__((section("sfrs")));
extern volatile unsigned int        DEVCFG1 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned FNOSC:3;
    unsigned DMTINTV:3;
    unsigned FSOSCEN:1;
    unsigned IESO:1;
    unsigned POSCMOD:2;
    unsigned OSCIOFNC:1;
    unsigned :3;
    unsigned FCKSM:2;
    unsigned WDTPS:5;
    unsigned WDTSPGM:1;
    unsigned WINDIS:1;
    unsigned FWDTEN:1;
    unsigned FWDTWINSZ:2;
    unsigned DMTCNT:5;
    unsigned FDMTEN:1;
  };
  struct {
    unsigned w:32;
  };
} __DEVCFG1bits_t;
extern volatile __DEVCFG1bits_t DEVCFG1bits __asm__ ("DEVCFG1") __attribute__((section("sfrs")));
extern volatile unsigned int        DEVCFG0 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned DEBUG:2;
    unsigned JTAGEN:1;
    unsigned ICESEL:2;
    unsigned TRCEN:1;
    unsigned BOOTISA:1;
    unsigned :1;
    unsigned FECCCON:2;
    unsigned FSLEEP:1;
    unsigned :1;
    unsigned DBGPER:3;
    unsigned :15;
    unsigned EJTAGBEN:1;
  };
  struct {
    unsigned FDEBUG:2;
  };
  struct {
    unsigned w:32;
  };
} __DEVCFG0bits_t;
extern volatile __DEVCFG0bits_t DEVCFG0bits __asm__ ("DEVCFG0") __attribute__((section("sfrs")));
extern volatile unsigned int        DEVCP3 __attribute__((section("sfrs")));
extern volatile unsigned int        DEVCP2 __attribute__((section("sfrs")));
extern volatile unsigned int        DEVCP1 __attribute__((section("sfrs")));
extern volatile unsigned int        DEVCP0 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned :28;
    unsigned CP:1;
  };
  struct {
    unsigned w:32;
  };
} __DEVCP0bits_t;
extern volatile __DEVCP0bits_t DEVCP0bits __asm__ ("DEVCP0") __attribute__((section("sfrs")));
extern volatile unsigned int        DEVSIGN3 __attribute__((section("sfrs")));
extern volatile unsigned int        DEVSIGN2 __attribute__((section("sfrs")));
extern volatile unsigned int        DEVSIGN1 __attribute__((section("sfrs")));
extern volatile unsigned int        DEVSIGN0 __attribute__((section("sfrs")));
extern volatile unsigned int        SEQ3 __attribute__((section("sfrs")));
extern volatile unsigned int        SEQ2 __attribute__((section("sfrs")));
extern volatile unsigned int        SEQ1 __attribute__((section("sfrs")));
extern volatile unsigned int        SEQ0 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TSEQ:16;
    unsigned CSEQ:16;
  };
  struct {
    unsigned w:32;
  };
} __SEQ0bits_t;
extern volatile __SEQ0bits_t SEQ0bits __asm__ ("SEQ0") __attribute__((section("sfrs")));
extern volatile unsigned int        DEVADC1 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned ADCCALDATA:32;
  };
  struct {
    unsigned w:32;
  };
} __DEVADC1bits_t;
extern volatile __DEVADC1bits_t DEVADC1bits __asm__ ("DEVADC1") __attribute__((section("sfrs")));
extern volatile unsigned int        DEVADC2 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned ADCCALDATA:32;
  };
  struct {
    unsigned w:32;
  };
} __DEVADC2bits_t;
extern volatile __DEVADC2bits_t DEVADC2bits __asm__ ("DEVADC2") __attribute__((section("sfrs")));
extern volatile unsigned int        DEVADC3 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned ADCCALDATA:32;
  };
  struct {
    unsigned w:32;
  };
} __DEVADC3bits_t;
extern volatile __DEVADC3bits_t DEVADC3bits __asm__ ("DEVADC3") __attribute__((section("sfrs")));
extern volatile unsigned int        DEVADC4 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned ADCCALDATA:32;
  };
  struct {
    unsigned w:32;
  };
} __DEVADC4bits_t;
extern volatile __DEVADC4bits_t DEVADC4bits __asm__ ("DEVADC4") __attribute__((section("sfrs")));
extern volatile unsigned int        DEVADC5 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned ADCCALDATA:32;
  };
  struct {
    unsigned w:32;
  };
} __DEVADC5bits_t;
extern volatile __DEVADC5bits_t DEVADC5bits __asm__ ("DEVADC5") __attribute__((section("sfrs")));
extern volatile unsigned int        DEVSN0 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned SN:32;
  };
  struct {
    unsigned w:32;
  };
} __DEVSN0bits_t;
extern volatile __DEVSN0bits_t DEVSN0bits __asm__ ("DEVSN0") __attribute__((section("sfrs")));
extern volatile unsigned int        DEVSN1 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned SN:32;
  };
  struct {
    unsigned w:32;
  };
} __DEVSN1bits_t;
extern volatile __DEVSN1bits_t DEVSN1bits __asm__ ("DEVSN1") __attribute__((section("sfrs")));
extern volatile unsigned int        ADEVCFG3 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned USERID:16;
    unsigned :8;
    unsigned FMIIEN:1;
    unsigned FETHIO:1;
    unsigned :1;
    unsigned PGL1WAY:1;
    unsigned PMDL1WAY:1;
    unsigned IOL1WAY:1;
    unsigned FUSBIDIO:1;
  };
  struct {
    unsigned w:32;
  };
} __ADEVCFG3bits_t;
extern volatile __ADEVCFG3bits_t ADEVCFG3bits __asm__ ("ADEVCFG3") __attribute__((section("sfrs")));
extern volatile unsigned int        ADEVCFG2 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned FPLLIDIV:3;
    unsigned :1;
    unsigned FPLLRNG:3;
    unsigned FPLLICLK:1;
    unsigned FPLLMULT:7;
    unsigned :1;
    unsigned FPLLODIV:3;
    unsigned :11;
    unsigned UPLLFSEL:1;
    unsigned UPLLEN:1;
  };
  struct {
    unsigned w:32;
  };
} __ADEVCFG2bits_t;
extern volatile __ADEVCFG2bits_t ADEVCFG2bits __asm__ ("ADEVCFG2") __attribute__((section("sfrs")));
extern volatile unsigned int        ADEVCFG1 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned FNOSC:3;
    unsigned DMTINTV:3;
    unsigned FSOSCEN:1;
    unsigned IESO:1;
    unsigned POSCMOD:2;
    unsigned OSCIOFNC:1;
    unsigned :3;
    unsigned FCKSM:2;
    unsigned WDTPS:5;
    unsigned WDTSPGM:1;
    unsigned WINDIS:1;
    unsigned FWDTEN:1;
    unsigned FWDTWINSZ:2;
    unsigned DMTCNT:5;
    unsigned FDMTEN:1;
  };
  struct {
    unsigned w:32;
  };
} __ADEVCFG1bits_t;
extern volatile __ADEVCFG1bits_t ADEVCFG1bits __asm__ ("ADEVCFG1") __attribute__((section("sfrs")));
extern volatile unsigned int        ADEVCFG0 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned DEBUG:2;
    unsigned JTAGEN:1;
    unsigned ICESEL:2;
    unsigned TRCEN:1;
    unsigned BOOTISA:1;
    unsigned :1;
    unsigned FECCCON:2;
    unsigned FSLEEP:1;
    unsigned :1;
    unsigned DBGPER:3;
    unsigned :15;
    unsigned EJTAGBEN:1;
  };
  struct {
    unsigned FDEBUG:2;
  };
  struct {
    unsigned w:32;
  };
} __ADEVCFG0bits_t;
extern volatile __ADEVCFG0bits_t ADEVCFG0bits __asm__ ("ADEVCFG0") __attribute__((section("sfrs")));
extern volatile unsigned int        ADEVCP3 __attribute__((section("sfrs")));
extern volatile unsigned int        ADEVCP2 __attribute__((section("sfrs")));
extern volatile unsigned int        ADEVCP1 __attribute__((section("sfrs")));
extern volatile unsigned int        ADEVCP0 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned :28;
    unsigned CP:1;
  };
  struct {
    unsigned w:32;
  };
} __ADEVCP0bits_t;
extern volatile __ADEVCP0bits_t ADEVCP0bits __asm__ ("ADEVCP0") __attribute__((section("sfrs")));
extern volatile unsigned int        ADEVSIGN3 __attribute__((section("sfrs")));
extern volatile unsigned int        ADEVSIGN2 __attribute__((section("sfrs")));
extern volatile unsigned int        ADEVSIGN1 __attribute__((section("sfrs")));
extern volatile unsigned int        ADEVSIGN0 __attribute__((section("sfrs")));
extern volatile unsigned int        ASEQ3 __attribute__((section("sfrs")));
extern volatile unsigned int        ASEQ2 __attribute__((section("sfrs")));
extern volatile unsigned int        ASEQ1 __attribute__((section("sfrs")));
extern volatile unsigned int        ASEQ0 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TSEQ:16;
    unsigned CSEQ:16;
  };
  struct {
    unsigned w:32;
  };
} __ASEQ0bits_t;
extern volatile __ASEQ0bits_t ASEQ0bits __asm__ ("ASEQ0") __attribute__((section("sfrs")));
extern volatile unsigned int        ABF1DEVCFG3 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned USERID:16;
    unsigned :8;
    unsigned FMIIEN:1;
    unsigned FETHIO:1;
    unsigned :1;
    unsigned PGL1WAY:1;
    unsigned PMDL1WAY:1;
    unsigned IOL1WAY:1;
    unsigned FUSBIDIO:1;
  };
  struct {
    unsigned w:32;
  };
} __ABF1DEVCFG3bits_t;
extern volatile __ABF1DEVCFG3bits_t ABF1DEVCFG3bits __asm__ ("ABF1DEVCFG3") __attribute__((section("sfrs")));
extern volatile unsigned int        ABF1DEVCFG2 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned FPLLIDIV:3;
    unsigned :1;
    unsigned FPLLRNG:3;
    unsigned FPLLICLK:1;
    unsigned FPLLMULT:7;
    unsigned :1;
    unsigned FPLLODIV:3;
    unsigned :11;
    unsigned UPLLFSEL:1;
    unsigned UPLLEN:1;
  };
  struct {
    unsigned w:32;
  };
} __ABF1DEVCFG2bits_t;
extern volatile __ABF1DEVCFG2bits_t ABF1DEVCFG2bits __asm__ ("ABF1DEVCFG2") __attribute__((section("sfrs")));
extern volatile unsigned int        ABF1DEVCFG1 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned FNOSC:3;
    unsigned DMTINTV:3;
    unsigned FSOSCEN:1;
    unsigned IESO:1;
    unsigned POSCMOD:2;
    unsigned OSCIOFNC:1;
    unsigned :3;
    unsigned FCKSM:2;
    unsigned WDTPS:5;
    unsigned WDTSPGM:1;
    unsigned WINDIS:1;
    unsigned FWDTEN:1;
    unsigned FWDTWINSZ:2;
    unsigned DMTCNT:5;
    unsigned FDMTEN:1;
  };
  struct {
    unsigned w:32;
  };
} __ABF1DEVCFG1bits_t;
extern volatile __ABF1DEVCFG1bits_t ABF1DEVCFG1bits __asm__ ("ABF1DEVCFG1") __attribute__((section("sfrs")));
extern volatile unsigned int        ABF1DEVCFG0 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned DEBUG:2;
    unsigned JTAGEN:1;
    unsigned ICESEL:2;
    unsigned TRCEN:1;
    unsigned BOOTISA:1;
    unsigned :1;
    unsigned FECCCON:2;
    unsigned FSLEEP:1;
    unsigned :1;
    unsigned DBGPER:3;
    unsigned :15;
    unsigned EJTAGBEN:1;
  };
  struct {
    unsigned FDEBUG:2;
  };
  struct {
    unsigned w:32;
  };
} __ABF1DEVCFG0bits_t;
extern volatile __ABF1DEVCFG0bits_t ABF1DEVCFG0bits __asm__ ("ABF1DEVCFG0") __attribute__((section("sfrs")));
extern volatile unsigned int        ABF1DEVCP3 __attribute__((section("sfrs")));
extern volatile unsigned int        ABF1DEVCP2 __attribute__((section("sfrs")));
extern volatile unsigned int        ABF1DEVCP1 __attribute__((section("sfrs")));
extern volatile unsigned int        ABF1DEVCP0 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned :28;
    unsigned CP:1;
  };
  struct {
    unsigned w:32;
  };
} __ABF1DEVCP0bits_t;
extern volatile __ABF1DEVCP0bits_t ABF1DEVCP0bits __asm__ ("ABF1DEVCP0") __attribute__((section("sfrs")));
extern volatile unsigned int        ABF1DEVSIGN3 __attribute__((section("sfrs")));
extern volatile unsigned int        ABF1DEVSIGN2 __attribute__((section("sfrs")));
extern volatile unsigned int        ABF1DEVSIGN1 __attribute__((section("sfrs")));
extern volatile unsigned int        ABF1DEVSIGN0 __attribute__((section("sfrs")));
extern volatile unsigned int        ABF1SEQ3 __attribute__((section("sfrs")));
extern volatile unsigned int        ABF1SEQ2 __attribute__((section("sfrs")));
extern volatile unsigned int        ABF1SEQ1 __attribute__((section("sfrs")));
extern volatile unsigned int        ABF1SEQ0 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TSEQ:16;
    unsigned CSEQ:16;
  };
  struct {
    unsigned w:32;
  };
} __ABF1SEQ0bits_t;
extern volatile __ABF1SEQ0bits_t ABF1SEQ0bits __asm__ ("ABF1SEQ0") __attribute__((section("sfrs")));
extern volatile unsigned int        BF1DEVCFG3 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned USERID:16;
    unsigned :8;
    unsigned FMIIEN:1;
    unsigned FETHIO:1;
    unsigned :1;
    unsigned PGL1WAY:1;
    unsigned PMDL1WAY:1;
    unsigned IOL1WAY:1;
    unsigned FUSBIDIO:1;
  };
  struct {
    unsigned w:32;
  };
} __BF1DEVCFG3bits_t;
extern volatile __BF1DEVCFG3bits_t BF1DEVCFG3bits __asm__ ("BF1DEVCFG3") __attribute__((section("sfrs")));
extern volatile unsigned int        BF1DEVCFG2 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned FPLLIDIV:3;
    unsigned :1;
    unsigned FPLLRNG:3;
    unsigned FPLLICLK:1;
    unsigned FPLLMULT:7;
    unsigned :1;
    unsigned FPLLODIV:3;
    unsigned :11;
    unsigned UPLLFSEL:1;
    unsigned UPLLEN:1;
  };
  struct {
    unsigned w:32;
  };
} __BF1DEVCFG2bits_t;
extern volatile __BF1DEVCFG2bits_t BF1DEVCFG2bits __asm__ ("BF1DEVCFG2") __attribute__((section("sfrs")));
extern volatile unsigned int        BF1DEVCFG1 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned FNOSC:3;
    unsigned DMTINTV:3;
    unsigned FSOSCEN:1;
    unsigned IESO:1;
    unsigned POSCMOD:2;
    unsigned OSCIOFNC:1;
    unsigned :3;
    unsigned FCKSM:2;
    unsigned WDTPS:5;
    unsigned WDTSPGM:1;
    unsigned WINDIS:1;
    unsigned FWDTEN:1;
    unsigned FWDTWINSZ:2;
    unsigned DMTCNT:5;
    unsigned FDMTEN:1;
  };
  struct {
    unsigned w:32;
  };
} __BF1DEVCFG1bits_t;
extern volatile __BF1DEVCFG1bits_t BF1DEVCFG1bits __asm__ ("BF1DEVCFG1") __attribute__((section("sfrs")));
extern volatile unsigned int        BF1DEVCFG0 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned DEBUG:2;
    unsigned JTAGEN:1;
    unsigned ICESEL:2;
    unsigned TRCEN:1;
    unsigned BOOTISA:1;
    unsigned :1;
    unsigned FECCCON:2;
    unsigned FSLEEP:1;
    unsigned :1;
    unsigned DBGPER:3;
    unsigned :15;
    unsigned EJTAGBEN:1;
  };
  struct {
    unsigned FDEBUG:2;
  };
  struct {
    unsigned w:32;
  };
} __BF1DEVCFG0bits_t;
extern volatile __BF1DEVCFG0bits_t BF1DEVCFG0bits __asm__ ("BF1DEVCFG0") __attribute__((section("sfrs")));
extern volatile unsigned int        BF1DEVCP3 __attribute__((section("sfrs")));
extern volatile unsigned int        BF1DEVCP2 __attribute__((section("sfrs")));
extern volatile unsigned int        BF1DEVCP1 __attribute__((section("sfrs")));
extern volatile unsigned int        BF1DEVCP0 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned :28;
    unsigned CP:1;
  };
  struct {
    unsigned w:32;
  };
} __BF1DEVCP0bits_t;
extern volatile __BF1DEVCP0bits_t BF1DEVCP0bits __asm__ ("BF1DEVCP0") __attribute__((section("sfrs")));
extern volatile unsigned int        BF1DEVSIGN3 __attribute__((section("sfrs")));
extern volatile unsigned int        BF1DEVSIGN2 __attribute__((section("sfrs")));
extern volatile unsigned int        BF1DEVSIGN1 __attribute__((section("sfrs")));
extern volatile unsigned int        BF1DEVSIGN0 __attribute__((section("sfrs")));
extern volatile unsigned int        BF1SEQ3 __attribute__((section("sfrs")));
extern volatile unsigned int        BF1SEQ2 __attribute__((section("sfrs")));
extern volatile unsigned int        BF1SEQ1 __attribute__((section("sfrs")));
extern volatile unsigned int        BF1SEQ0 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TSEQ:16;
    unsigned CSEQ:16;
  };
  struct {
    unsigned w:32;
  };
} __BF1SEQ0bits_t;
extern volatile __BF1SEQ0bits_t BF1SEQ0bits __asm__ ("BF1SEQ0") __attribute__((section("sfrs")));
extern volatile unsigned int        ABF2DEVCFG3 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned USERID:16;
    unsigned :8;
    unsigned FMIIEN:1;
    unsigned FETHIO:1;
    unsigned :1;
    unsigned PGL1WAY:1;
    unsigned PMDL1WAY:1;
    unsigned IOL1WAY:1;
    unsigned FUSBIDIO:1;
  };
  struct {
    unsigned w:32;
  };
} __ABF2DEVCFG3bits_t;
extern volatile __ABF2DEVCFG3bits_t ABF2DEVCFG3bits __asm__ ("ABF2DEVCFG3") __attribute__((section("sfrs")));
extern volatile unsigned int        ABF2DEVCFG2 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned FPLLIDIV:3;
    unsigned :1;
    unsigned FPLLRNG:3;
    unsigned FPLLICLK:1;
    unsigned FPLLMULT:7;
    unsigned :1;
    unsigned FPLLODIV:3;
    unsigned :11;
    unsigned UPLLFSEL:1;
    unsigned UPLLEN:1;
  };
  struct {
    unsigned w:32;
  };
} __ABF2DEVCFG2bits_t;
extern volatile __ABF2DEVCFG2bits_t ABF2DEVCFG2bits __asm__ ("ABF2DEVCFG2") __attribute__((section("sfrs")));
extern volatile unsigned int        ABF2DEVCFG1 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned FNOSC:3;
    unsigned DMTINTV:3;
    unsigned FSOSCEN:1;
    unsigned IESO:1;
    unsigned POSCMOD:2;
    unsigned OSCIOFNC:1;
    unsigned :3;
    unsigned FCKSM:2;
    unsigned WDTPS:5;
    unsigned WDTSPGM:1;
    unsigned WINDIS:1;
    unsigned FWDTEN:1;
    unsigned FWDTWINSZ:2;
    unsigned DMTCNT:5;
    unsigned FDMTEN:1;
  };
  struct {
    unsigned w:32;
  };
} __ABF2DEVCFG1bits_t;
extern volatile __ABF2DEVCFG1bits_t ABF2DEVCFG1bits __asm__ ("ABF2DEVCFG1") __attribute__((section("sfrs")));
extern volatile unsigned int        ABF2DEVCFG0 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned DEBUG:2;
    unsigned JTAGEN:1;
    unsigned ICESEL:2;
    unsigned TRCEN:1;
    unsigned BOOTISA:1;
    unsigned :1;
    unsigned FECCCON:2;
    unsigned FSLEEP:1;
    unsigned :1;
    unsigned DBGPER:3;
    unsigned :15;
    unsigned EJTAGBEN:1;
  };
  struct {
    unsigned FDEBUG:2;
  };
  struct {
    unsigned w:32;
  };
} __ABF2DEVCFG0bits_t;
extern volatile __ABF2DEVCFG0bits_t ABF2DEVCFG0bits __asm__ ("ABF2DEVCFG0") __attribute__((section("sfrs")));
extern volatile unsigned int        ABF2DEVCP3 __attribute__((section("sfrs")));
extern volatile unsigned int        ABF2DEVCP2 __attribute__((section("sfrs")));
extern volatile unsigned int        ABF2DEVCP1 __attribute__((section("sfrs")));
extern volatile unsigned int        ABF2DEVCP0 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned :28;
    unsigned CP:1;
  };
  struct {
    unsigned w:32;
  };
} __ABF2DEVCP0bits_t;
extern volatile __ABF2DEVCP0bits_t ABF2DEVCP0bits __asm__ ("ABF2DEVCP0") __attribute__((section("sfrs")));
extern volatile unsigned int        ABF2DEVSIGN3 __attribute__((section("sfrs")));
extern volatile unsigned int        ABF2DEVSIGN2 __attribute__((section("sfrs")));
extern volatile unsigned int        ABF2DEVSIGN1 __attribute__((section("sfrs")));
extern volatile unsigned int        ABF2DEVSIGN0 __attribute__((section("sfrs")));
extern volatile unsigned int        ABF2SEQ3 __attribute__((section("sfrs")));
extern volatile unsigned int        ABF2SEQ2 __attribute__((section("sfrs")));
extern volatile unsigned int        ABF2SEQ1 __attribute__((section("sfrs")));
extern volatile unsigned int        ABF2SEQ0 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TSEQ:16;
    unsigned CSEQ:16;
  };
  struct {
    unsigned w:32;
  };
} __ABF2SEQ0bits_t;
extern volatile __ABF2SEQ0bits_t ABF2SEQ0bits __asm__ ("ABF2SEQ0") __attribute__((section("sfrs")));
extern volatile unsigned int        BF2DEVCFG3 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned USERID:16;
    unsigned :8;
    unsigned FMIIEN:1;
    unsigned FETHIO:1;
    unsigned :1;
    unsigned PGL1WAY:1;
    unsigned PMDL1WAY:1;
    unsigned IOL1WAY:1;
    unsigned FUSBIDIO:1;
  };
  struct {
    unsigned w:32;
  };
} __BF2DEVCFG3bits_t;
extern volatile __BF2DEVCFG3bits_t BF2DEVCFG3bits __asm__ ("BF2DEVCFG3") __attribute__((section("sfrs")));
extern volatile unsigned int        BF2DEVCFG2 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned FPLLIDIV:3;
    unsigned :1;
    unsigned FPLLRNG:3;
    unsigned FPLLICLK:1;
    unsigned FPLLMULT:7;
    unsigned :1;
    unsigned FPLLODIV:3;
    unsigned :11;
    unsigned UPLLFSEL:1;
    unsigned UPLLEN:1;
  };
  struct {
    unsigned w:32;
  };
} __BF2DEVCFG2bits_t;
extern volatile __BF2DEVCFG2bits_t BF2DEVCFG2bits __asm__ ("BF2DEVCFG2") __attribute__((section("sfrs")));
extern volatile unsigned int        BF2DEVCFG1 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned FNOSC:3;
    unsigned DMTINTV:3;
    unsigned FSOSCEN:1;
    unsigned IESO:1;
    unsigned POSCMOD:2;
    unsigned OSCIOFNC:1;
    unsigned :3;
    unsigned FCKSM:2;
    unsigned WDTPS:5;
    unsigned WDTSPGM:1;
    unsigned WINDIS:1;
    unsigned FWDTEN:1;
    unsigned FWDTWINSZ:2;
    unsigned DMTCNT:5;
    unsigned FDMTEN:1;
  };
  struct {
    unsigned w:32;
  };
} __BF2DEVCFG1bits_t;
extern volatile __BF2DEVCFG1bits_t BF2DEVCFG1bits __asm__ ("BF2DEVCFG1") __attribute__((section("sfrs")));
extern volatile unsigned int        BF2DEVCFG0 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned DEBUG:2;
    unsigned JTAGEN:1;
    unsigned ICESEL:2;
    unsigned TRCEN:1;
    unsigned BOOTISA:1;
    unsigned :1;
    unsigned FECCCON:2;
    unsigned FSLEEP:1;
    unsigned :1;
    unsigned DBGPER:3;
    unsigned :15;
    unsigned EJTAGBEN:1;
  };
  struct {
    unsigned FDEBUG:2;
  };
  struct {
    unsigned w:32;
  };
} __BF2DEVCFG0bits_t;
extern volatile __BF2DEVCFG0bits_t BF2DEVCFG0bits __asm__ ("BF2DEVCFG0") __attribute__((section("sfrs")));
extern volatile unsigned int        BF2DEVCP3 __attribute__((section("sfrs")));
extern volatile unsigned int        BF2DEVCP2 __attribute__((section("sfrs")));
extern volatile unsigned int        BF2DEVCP1 __attribute__((section("sfrs")));
extern volatile unsigned int        BF2DEVCP0 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned :28;
    unsigned CP:1;
  };
  struct {
    unsigned w:32;
  };
} __BF2DEVCP0bits_t;
extern volatile __BF2DEVCP0bits_t BF2DEVCP0bits __asm__ ("BF2DEVCP0") __attribute__((section("sfrs")));
extern volatile unsigned int        BF2DEVSIGN3 __attribute__((section("sfrs")));
extern volatile unsigned int        BF2DEVSIGN2 __attribute__((section("sfrs")));
extern volatile unsigned int        BF2DEVSIGN1 __attribute__((section("sfrs")));
extern volatile unsigned int        BF2DEVSIGN0 __attribute__((section("sfrs")));
extern volatile unsigned int        BF2SEQ3 __attribute__((section("sfrs")));
extern volatile unsigned int        BF2SEQ2 __attribute__((section("sfrs")));
extern volatile unsigned int        BF2SEQ1 __attribute__((section("sfrs")));
extern volatile unsigned int        BF2SEQ0 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TSEQ:16;
    unsigned CSEQ:16;
  };
  struct {
    unsigned w:32;
  };
} __BF2SEQ0bits_t;
extern volatile __BF2SEQ0bits_t BF2SEQ0bits __asm__ ("BF2SEQ0") __attribute__((section("sfrs")));
#ifdef __cplusplus
}
#endif

#elif defined (__LANGUAGE_ASSEMBLY__)
  .extern CFGCON           /* 0xBF800000 */
  .extern DEVID            /* 0xBF800020 */
  .extern SYSKEY           /* 0xBF800030 */
  .extern PMD1             /* 0xBF800040 */
  .extern PMD1CLR          /* 0xBF800044 */
  .extern PMD1SET          /* 0xBF800048 */
  .extern PMD1INV          /* 0xBF80004C */
  .extern PMD2             /* 0xBF800050 */
  .extern PMD2CLR          /* 0xBF800054 */
  .extern PMD2SET          /* 0xBF800058 */
  .extern PMD2INV          /* 0xBF80005C */
  .extern PMD3             /* 0xBF800060 */
  .extern PMD3CLR          /* 0xBF800064 */
  .extern PMD3SET          /* 0xBF800068 */
  .extern PMD3INV          /* 0xBF80006C */
  .extern PMD4             /* 0xBF800070 */
  .extern PMD4CLR          /* 0xBF800074 */
  .extern PMD4SET          /* 0xBF800078 */
  .extern PMD4INV          /* 0xBF80007C */
  .extern PMD5             /* 0xBF800080 */
  .extern PMD5CLR          /* 0xBF800084 */
  .extern PMD5SET          /* 0xBF800088 */
  .extern PMD5INV          /* 0xBF80008C */
  .extern PMD6             /* 0xBF800090 */
  .extern PMD6CLR          /* 0xBF800094 */
  .extern PMD6SET          /* 0xBF800098 */
  .extern PMD6INV          /* 0xBF80009C */
  .extern PMD7             /* 0xBF8000A0 */
  .extern PMD7CLR          /* 0xBF8000A4 */
  .extern PMD7SET          /* 0xBF8000A8 */
  .extern PMD7INV          /* 0xBF8000AC */
  .extern CFGEBIA          /* 0xBF8000C0 */
  .extern CFGEBIACLR       /* 0xBF8000C4 */
  .extern CFGEBIASET       /* 0xBF8000C8 */
  .extern CFGEBIAINV       /* 0xBF8000CC */
  .extern CFGEBIC          /* 0xBF8000D0 */
  .extern CFGEBICCLR       /* 0xBF8000D4 */
  .extern CFGEBICSET       /* 0xBF8000D8 */
  .extern CFGEBICINV       /* 0xBF8000DC */
  .extern CFGPG            /* 0xBF8000E0 */
  .extern CFGPGCLR         /* 0xBF8000E4 */
  .extern CFGPGSET         /* 0xBF8000E8 */
  .extern CFGPGINV         /* 0xBF8000EC */
  .extern NVMCON           /* 0xBF800600 */
  .extern NVMCONCLR        /* 0xBF800604 */
  .extern NVMCONSET        /* 0xBF800608 */
  .extern NVMCONINV        /* 0xBF80060C */
  .extern NVMKEY           /* 0xBF800610 */
  .extern NVMADDR          /* 0xBF800620 */
  .extern NVMADDRCLR       /* 0xBF800624 */
  .extern NVMADDRSET       /* 0xBF800628 */
  .extern NVMADDRINV       /* 0xBF80062C */
  .extern NVMDATA0         /* 0xBF800630 */
  .extern NVMDATA1         /* 0xBF800640 */
  .extern NVMDATA2         /* 0xBF800650 */
  .extern NVMDATA3         /* 0xBF800660 */
  .extern NVMSRCADDR       /* 0xBF800670 */
  .extern NVMPWP           /* 0xBF800680 */
  .extern NVMBWP           /* 0xBF800690 */
  .extern NVMBWPCLR        /* 0xBF800694 */
  .extern NVMBWPSET        /* 0xBF800698 */
  .extern NVMBWPINV        /* 0xBF80069C */
  .extern WDTCON           /* 0xBF800800 */
  .extern WDTCONCLR        /* 0xBF800804 */
  .extern WDTCONSET        /* 0xBF800808 */
  .extern WDTCONINV        /* 0xBF80080C */
  .extern DMTCON           /* 0xBF800A00 */
  .extern DMTPRECLR        /* 0xBF800A10 */
  .extern DMTCLR           /* 0xBF800A20 */
  .extern DMTSTAT          /* 0xBF800A30 */
  .extern DMTCNT           /* 0xBF800A40 */
  .extern DMTPSCNT         /* 0xBF800A60 */
  .extern DMTPSINTV        /* 0xBF800A70 */
  .extern RTCCON           /* 0xBF800C00 */
  .extern RTCCONCLR        /* 0xBF800C04 */
  .extern RTCCONSET        /* 0xBF800C08 */
  .extern RTCCONINV        /* 0xBF800C0C */
  .extern RTCALRM          /* 0xBF800C10 */
  .extern RTCALRMCLR       /* 0xBF800C14 */
  .extern RTCALRMSET       /* 0xBF800C18 */
  .extern RTCALRMINV       /* 0xBF800C1C */
  .extern RTCTIME          /* 0xBF800C20 */
  .extern RTCTIMECLR       /* 0xBF800C24 */
  .extern RTCTIMESET       /* 0xBF800C28 */
  .extern RTCTIMEINV       /* 0xBF800C2C */
  .extern RTCDATE          /* 0xBF800C30 */
  .extern RTCDATECLR       /* 0xBF800C34 */
  .extern RTCDATESET       /* 0xBF800C38 */
  .extern RTCDATEINV       /* 0xBF800C3C */
  .extern ALRMTIME         /* 0xBF800C40 */
  .extern ALRMTIMECLR      /* 0xBF800C44 */
  .extern ALRMTIMESET      /* 0xBF800C48 */
  .extern ALRMTIMEINV      /* 0xBF800C4C */
  .extern ALRMDATE         /* 0xBF800C50 */
  .extern ALRMDATECLR      /* 0xBF800C54 */
  .extern ALRMDATESET      /* 0xBF800C58 */
  .extern ALRMDATEINV      /* 0xBF800C5C */
  .extern CVRCON           /* 0xBF800E00 */
  .extern CVRCONCLR        /* 0xBF800E04 */
  .extern CVRCONSET        /* 0xBF800E08 */
  .extern CVRCONINV        /* 0xBF800E0C */
  .extern _ICDCON          /* 0xBF801130 */
  .extern _ICDSTAT         /* 0xBF801140 */
  .extern OSCCON           /* 0xBF801200 */
  .extern OSCCONCLR        /* 0xBF801204 */
  .extern OSCCONSET        /* 0xBF801208 */
  .extern OSCCONINV        /* 0xBF80120C */
  .extern OSCTUN           /* 0xBF801210 */
  .extern OSCTUNCLR        /* 0xBF801214 */
  .extern OSCTUNSET        /* 0xBF801218 */
  .extern OSCTUNINV        /* 0xBF80121C */
  .extern SPLLCON          /* 0xBF801220 */
  .extern SPLLCONCLR       /* 0xBF801224 */
  .extern SPLLCONSET       /* 0xBF801228 */
  .extern SPLLCONINV       /* 0xBF80122C */
  .extern RCON             /* 0xBF801240 */
  .extern RCONCLR          /* 0xBF801244 */
  .extern RCONSET          /* 0xBF801248 */
  .extern RCONINV          /* 0xBF80124C */
  .extern RSWRST           /* 0xBF801250 */
  .extern RSWRSTCLR        /* 0xBF801254 */
  .extern RSWRSTSET        /* 0xBF801258 */
  .extern RSWRSTINV        /* 0xBF80125C */
  .extern RNMICON          /* 0xBF801260 */
  .extern RNMICONCLR       /* 0xBF801264 */
  .extern RNMICONSET       /* 0xBF801268 */
  .extern RNMICONINV       /* 0xBF80126C */
  .extern PWRCON           /* 0xBF801270 */
  .extern PWRCONCLR        /* 0xBF801274 */
  .extern PWRCONSET        /* 0xBF801278 */
  .extern PWRCONINV        /* 0xBF80127C */
  .extern REFO1CON         /* 0xBF801280 */
  .extern REFO1CONCLR      /* 0xBF801284 */
  .extern REFO1CONSET      /* 0xBF801288 */
  .extern REFO1CONINV      /* 0xBF80128C */
  .extern REFO1TRIM        /* 0xBF801290 */
  .extern REFO1TRIMCLR     /* 0xBF801294 */
  .extern REFO1TRIMSET     /* 0xBF801298 */
  .extern REFO1TRIMINV     /* 0xBF80129C */
  .extern REFO2CON         /* 0xBF8012A0 */
  .extern REFO2CONCLR      /* 0xBF8012A4 */
  .extern REFO2CONSET      /* 0xBF8012A8 */
  .extern REFO2CONINV      /* 0xBF8012AC */
  .extern REFO2TRIM        /* 0xBF8012B0 */
  .extern REFO2TRIMCLR     /* 0xBF8012B4 */
  .extern REFO2TRIMSET     /* 0xBF8012B8 */
  .extern REFO2TRIMINV     /* 0xBF8012BC */
  .extern REFO3CON         /* 0xBF8012C0 */
  .extern REFO3CONCLR      /* 0xBF8012C4 */
  .extern REFO3CONSET      /* 0xBF8012C8 */
  .extern REFO3CONINV      /* 0xBF8012CC */
  .extern REFO3TRIM        /* 0xBF8012D0 */
  .extern REFO3TRIMCLR     /* 0xBF8012D4 */
  .extern REFO3TRIMSET     /* 0xBF8012D8 */
  .extern REFO3TRIMINV     /* 0xBF8012DC */
  .extern REFO4CON         /* 0xBF8012E0 */
  .extern REFO4CONCLR      /* 0xBF8012E4 */
  .extern REFO4CONSET      /* 0xBF8012E8 */
  .extern REFO4CONINV      /* 0xBF8012EC */
  .extern REFO4TRIM        /* 0xBF8012F0 */
  .extern REFO4TRIMCLR     /* 0xBF8012F4 */
  .extern REFO4TRIMSET     /* 0xBF8012F8 */
  .extern REFO4TRIMINV     /* 0xBF8012FC */
  .extern PB1DIV           /* 0xBF801300 */
  .extern PB1DIVCLR        /* 0xBF801304 */
  .extern PB1DIVSET        /* 0xBF801308 */
  .extern PB1DIVINV        /* 0xBF80130C */
  .extern PB2DIV           /* 0xBF801310 */
  .extern PB2DIVCLR        /* 0xBF801314 */
  .extern PB2DIVSET        /* 0xBF801318 */
  .extern PB2DIVINV        /* 0xBF80131C */
  .extern PB3DIV           /* 0xBF801320 */
  .extern PB3DIVCLR        /* 0xBF801324 */
  .extern PB3DIVSET        /* 0xBF801328 */
  .extern PB3DIVINV        /* 0xBF80132C */
  .extern PB4DIV           /* 0xBF801330 */
  .extern PB4DIVCLR        /* 0xBF801334 */
  .extern PB4DIVSET        /* 0xBF801338 */
  .extern PB4DIVINV        /* 0xBF80133C */
  .extern PB5DIV           /* 0xBF801340 */
  .extern PB5DIVCLR        /* 0xBF801344 */
  .extern PB5DIVSET        /* 0xBF801348 */
  .extern PB5DIVINV        /* 0xBF80134C */
  .extern PB7DIV           /* 0xBF801360 */
  .extern PB7DIVCLR        /* 0xBF801364 */
  .extern PB7DIVSET        /* 0xBF801368 */
  .extern PB7DIVINV        /* 0xBF80136C */
  .extern PB8DIV           /* 0xBF801370 */
  .extern PB8DIVCLR        /* 0xBF801374 */
  .extern PB8DIVSET        /* 0xBF801378 */
  .extern PB8DIVINV        /* 0xBF80137C */
  .extern INT1R            /* 0xBF801404 */
  .extern INT2R            /* 0xBF801408 */
  .extern INT3R            /* 0xBF80140C */
  .extern INT4R            /* 0xBF801410 */
  .extern T2CKR            /* 0xBF801418 */
  .extern T3CKR            /* 0xBF80141C */
  .extern T4CKR            /* 0xBF801420 */
  .extern T5CKR            /* 0xBF801424 */
  .extern T6CKR            /* 0xBF801428 */
  .extern T7CKR            /* 0xBF80142C */
  .extern T8CKR            /* 0xBF801430 */
  .extern T9CKR            /* 0xBF801434 */
  .extern IC1R             /* 0xBF801438 */
  .extern IC2R             /* 0xBF80143C */
  .extern IC3R             /* 0xBF801440 */
  .extern IC4R             /* 0xBF801444 */
  .extern IC5R             /* 0xBF801448 */
  .extern IC6R             /* 0xBF80144C */
  .extern IC7R             /* 0xBF801450 */
  .extern IC8R             /* 0xBF801454 */
  .extern IC9R             /* 0xBF801458 */
  .extern OCFAR            /* 0xBF801460 */
  .extern U1RXR            /* 0xBF801468 */
  .extern U1CTSR           /* 0xBF80146C */
  .extern U2RXR            /* 0xBF801470 */
  .extern U2CTSR           /* 0xBF801474 */
  .extern U3RXR            /* 0xBF801478 */
  .extern U3CTSR           /* 0xBF80147C */
  .extern U4RXR            /* 0xBF801480 */
  .extern U4CTSR           /* 0xBF801484 */
  .extern U5RXR            /* 0xBF801488 */
  .extern U5CTSR           /* 0xBF80148C */
  .extern U6RXR            /* 0xBF801490 */
  .extern U6CTSR           /* 0xBF801494 */
  .extern SDI1R            /* 0xBF80149C */
  .extern SS1R             /* 0xBF8014A0 */
  .extern SDI2R            /* 0xBF8014A8 */
  .extern SS2R             /* 0xBF8014AC */
  .extern SDI3R            /* 0xBF8014B4 */
  .extern SS3R             /* 0xBF8014B8 */
  .extern SDI4R            /* 0xBF8014C0 */
  .extern SS4R             /* 0xBF8014C4 */
  .extern SDI5R            /* 0xBF8014CC */
  .extern SS5R             /* 0xBF8014D0 */
  .extern SDI6R            /* 0xBF8014D8 */
  .extern SS6R             /* 0xBF8014DC */
  .extern C1RXR            /* 0xBF8014E0 */
  .extern C2RXR            /* 0xBF8014E4 */
  .extern REFCLKI1R        /* 0xBF8014E8 */
  .extern REFCLKI3R        /* 0xBF8014F0 */
  .extern REFCLKI4R        /* 0xBF8014F4 */
  .extern RPA14R           /* 0xBF801538 */
  .extern RPA15R           /* 0xBF80153C */
  .extern RPB0R            /* 0xBF801540 */
  .extern RPB1R            /* 0xBF801544 */
  .extern RPB2R            /* 0xBF801548 */
  .extern RPB3R            /* 0xBF80154C */
  .extern RPB5R            /* 0xBF801554 */
  .extern RPB6R            /* 0xBF801558 */
  .extern RPB7R            /* 0xBF80155C */
  .extern RPB8R            /* 0xBF801560 */
  .extern RPB9R            /* 0xBF801564 */
  .extern RPB10R           /* 0xBF801568 */
  .extern RPB14R           /* 0xBF801578 */
  .extern RPB15R           /* 0xBF80157C */
  .extern RPC1R            /* 0xBF801584 */
  .extern RPC2R            /* 0xBF801588 */
  .extern RPC3R            /* 0xBF80158C */
  .extern RPC4R            /* 0xBF801590 */
  .extern RPC13R           /* 0xBF8015B4 */
  .extern RPC14R           /* 0xBF8015B8 */
  .extern RPD0R            /* 0xBF8015C0 */
  .extern RPD1R            /* 0xBF8015C4 */
  .extern RPD2R            /* 0xBF8015C8 */
  .extern RPD3R            /* 0xBF8015CC */
  .extern RPD4R            /* 0xBF8015D0 */
  .extern RPD5R            /* 0xBF8015D4 */
  .extern RPD6R            /* 0xBF8015D8 */
  .extern RPD7R            /* 0xBF8015DC */
  .extern RPD9R            /* 0xBF8015E4 */
  .extern RPD10R           /* 0xBF8015E8 */
  .extern RPD11R           /* 0xBF8015EC */
  .extern RPD12R           /* 0xBF8015F0 */
  .extern RPD14R           /* 0xBF8015F8 */
  .extern RPD15R           /* 0xBF8015FC */
  .extern RPE3R            /* 0xBF80160C */
  .extern RPE5R            /* 0xBF801614 */
  .extern RPE8R            /* 0xBF801620 */
  .extern RPE9R            /* 0xBF801624 */
  .extern RPF0R            /* 0xBF801640 */
  .extern RPF1R            /* 0xBF801644 */
  .extern RPF2R            /* 0xBF801648 */
  .extern RPF3R            /* 0xBF80164C */
  .extern RPF4R            /* 0xBF801650 */
  .extern RPF5R            /* 0xBF801654 */
  .extern RPF8R            /* 0xBF801660 */
  .extern RPF12R           /* 0xBF801670 */
  .extern RPF13R           /* 0xBF801674 */
  .extern RPG0R            /* 0xBF801680 */
  .extern RPG1R            /* 0xBF801684 */
  .extern RPG6R            /* 0xBF801698 */
  .extern RPG7R            /* 0xBF80169C */
  .extern RPG8R            /* 0xBF8016A0 */
  .extern RPG9R            /* 0xBF8016A4 */
  .extern INTCON           /* 0xBF810000 */
  .extern INTCONCLR        /* 0xBF810004 */
  .extern INTCONSET        /* 0xBF810008 */
  .extern INTCONINV        /* 0xBF81000C */
  .extern PRISS            /* 0xBF810010 */
  .extern PRISSCLR         /* 0xBF810014 */
  .extern PRISSSET         /* 0xBF810018 */
  .extern PRISSINV         /* 0xBF81001C */
  .extern INTSTAT          /* 0xBF810020 */
  .extern INTSTATCLR       /* 0xBF810024 */
  .extern INTSTATSET       /* 0xBF810028 */
  .extern INTSTATINV       /* 0xBF81002C */
  .extern IPTMR            /* 0xBF810030 */
  .extern IPTMRCLR         /* 0xBF810034 */
  .extern IPTMRSET         /* 0xBF810038 */
  .extern IPTMRINV         /* 0xBF81003C */
  .extern IFS0             /* 0xBF810040 */
  .extern IFS0CLR          /* 0xBF810044 */
  .extern IFS0SET          /* 0xBF810048 */
  .extern IFS0INV          /* 0xBF81004C */
  .extern IFS1             /* 0xBF810050 */
  .extern IFS1CLR          /* 0xBF810054 */
  .extern IFS1SET          /* 0xBF810058 */
  .extern IFS1INV          /* 0xBF81005C */
  .extern IFS2             /* 0xBF810060 */
  .extern IFS2CLR          /* 0xBF810064 */
  .extern IFS2SET          /* 0xBF810068 */
  .extern IFS2INV          /* 0xBF81006C */
  .extern IFS3             /* 0xBF810070 */
  .extern IFS3CLR          /* 0xBF810074 */
  .extern IFS3SET          /* 0xBF810078 */
  .extern IFS3INV          /* 0xBF81007C */
  .extern IFS4             /* 0xBF810080 */
  .extern IFS4CLR          /* 0xBF810084 */
  .extern IFS4SET          /* 0xBF810088 */
  .extern IFS4INV          /* 0xBF81008C */
  .extern IFS5             /* 0xBF810090 */
  .extern IFS5CLR          /* 0xBF810094 */
  .extern IFS5SET          /* 0xBF810098 */
  .extern IFS5INV          /* 0xBF81009C */
  .extern IEC0             /* 0xBF8100C0 */
  .extern IEC0CLR          /* 0xBF8100C4 */
  .extern IEC0SET          /* 0xBF8100C8 */
  .extern IEC0INV          /* 0xBF8100CC */
  .extern IEC1             /* 0xBF8100D0 */
  .extern IEC1CLR          /* 0xBF8100D4 */
  .extern IEC1SET          /* 0xBF8100D8 */
  .extern IEC1INV          /* 0xBF8100DC */
  .extern IEC2             /* 0xBF8100E0 */
  .extern IEC2CLR          /* 0xBF8100E4 */
  .extern IEC2SET          /* 0xBF8100E8 */
  .extern IEC2INV          /* 0xBF8100EC */
  .extern IEC3             /* 0xBF8100F0 */
  .extern IEC3CLR          /* 0xBF8100F4 */
  .extern IEC3SET          /* 0xBF8100F8 */
  .extern IEC3INV          /* 0xBF8100FC */
  .extern IEC4             /* 0xBF810100 */
  .extern IEC4CLR          /* 0xBF810104 */
  .extern IEC4SET          /* 0xBF810108 */
  .extern IEC4INV          /* 0xBF81010C */
  .extern IEC5             /* 0xBF810110 */
  .extern IEC5CLR          /* 0xBF810114 */
  .extern IEC5SET          /* 0xBF810118 */
  .extern IEC5INV          /* 0xBF81011C */
  .extern IPC0             /* 0xBF810140 */
  .extern IPC0CLR          /* 0xBF810144 */
  .extern IPC0SET          /* 0xBF810148 */
  .extern IPC0INV          /* 0xBF81014C */
  .extern IPC1             /* 0xBF810150 */
  .extern IPC1CLR          /* 0xBF810154 */
  .extern IPC1SET          /* 0xBF810158 */
  .extern IPC1INV          /* 0xBF81015C */
  .extern IPC2             /* 0xBF810160 */
  .extern IPC2CLR          /* 0xBF810164 */
  .extern IPC2SET          /* 0xBF810168 */
  .extern IPC2INV          /* 0xBF81016C */
  .extern IPC3             /* 0xBF810170 */
  .extern IPC3CLR          /* 0xBF810174 */
  .extern IPC3SET          /* 0xBF810178 */
  .extern IPC3INV          /* 0xBF81017C */
  .extern IPC4             /* 0xBF810180 */
  .extern IPC4CLR          /* 0xBF810184 */
  .extern IPC4SET          /* 0xBF810188 */
  .extern IPC4INV          /* 0xBF81018C */
  .extern IPC5             /* 0xBF810190 */
  .extern IPC5CLR          /* 0xBF810194 */
  .extern IPC5SET          /* 0xBF810198 */
  .extern IPC5INV          /* 0xBF81019C */
  .extern IPC6             /* 0xBF8101A0 */
  .extern IPC6CLR          /* 0xBF8101A4 */
  .extern IPC6SET          /* 0xBF8101A8 */
  .extern IPC6INV          /* 0xBF8101AC */
  .extern IPC7             /* 0xBF8101B0 */
  .extern IPC7CLR          /* 0xBF8101B4 */
  .extern IPC7SET          /* 0xBF8101B8 */
  .extern IPC7INV          /* 0xBF8101BC */
  .extern IPC8             /* 0xBF8101C0 */
  .extern IPC8CLR          /* 0xBF8101C4 */
  .extern IPC8SET          /* 0xBF8101C8 */
  .extern IPC8INV          /* 0xBF8101CC */
  .extern IPC9             /* 0xBF8101D0 */
  .extern IPC9CLR          /* 0xBF8101D4 */
  .extern IPC9SET          /* 0xBF8101D8 */
  .extern IPC9INV          /* 0xBF8101DC */
  .extern IPC10            /* 0xBF8101E0 */
  .extern IPC10CLR         /* 0xBF8101E4 */
  .extern IPC10SET         /* 0xBF8101E8 */
  .extern IPC10INV         /* 0xBF8101EC */
  .extern IPC11            /* 0xBF8101F0 */
  .extern IPC11CLR         /* 0xBF8101F4 */
  .extern IPC11SET         /* 0xBF8101F8 */
  .extern IPC11INV         /* 0xBF8101FC */
  .extern IPC12            /* 0xBF810200 */
  .extern IPC12CLR         /* 0xBF810204 */
  .extern IPC12SET         /* 0xBF810208 */
  .extern IPC12INV         /* 0xBF81020C */
  .extern IPC13            /* 0xBF810210 */
  .extern IPC13CLR         /* 0xBF810214 */
  .extern IPC13SET         /* 0xBF810218 */
  .extern IPC13INV         /* 0xBF81021C */
  .extern IPC14            /* 0xBF810220 */
  .extern IPC14CLR         /* 0xBF810224 */
  .extern IPC14SET         /* 0xBF810228 */
  .extern IPC14INV         /* 0xBF81022C */
  .extern IPC15            /* 0xBF810230 */
  .extern IPC15CLR         /* 0xBF810234 */
  .extern IPC15SET         /* 0xBF810238 */
  .extern IPC15INV         /* 0xBF81023C */
  .extern IPC16            /* 0xBF810240 */
  .extern IPC16CLR         /* 0xBF810244 */
  .extern IPC16SET         /* 0xBF810248 */
  .extern IPC16INV         /* 0xBF81024C */
  .extern IPC17            /* 0xBF810250 */
  .extern IPC17CLR         /* 0xBF810254 */
  .extern IPC17SET         /* 0xBF810258 */
  .extern IPC17INV         /* 0xBF81025C */
  .extern IPC18            /* 0xBF810260 */
  .extern IPC18CLR         /* 0xBF810264 */
  .extern IPC18SET         /* 0xBF810268 */
  .extern IPC18INV         /* 0xBF81026C */
  .extern IPC19            /* 0xBF810270 */
  .extern IPC19CLR         /* 0xBF810274 */
  .extern IPC19SET         /* 0xBF810278 */
  .extern IPC19INV         /* 0xBF81027C */
  .extern IPC20            /* 0xBF810280 */
  .extern IPC20CLR         /* 0xBF810284 */
  .extern IPC20SET         /* 0xBF810288 */
  .extern IPC20INV         /* 0xBF81028C */
  .extern IPC21            /* 0xBF810290 */
  .extern IPC21CLR         /* 0xBF810294 */
  .extern IPC21SET         /* 0xBF810298 */
  .extern IPC21INV         /* 0xBF81029C */
  .extern IPC22            /* 0xBF8102A0 */
  .extern IPC22CLR         /* 0xBF8102A4 */
  .extern IPC22SET         /* 0xBF8102A8 */
  .extern IPC22INV         /* 0xBF8102AC */
  .extern IPC23            /* 0xBF8102B0 */
  .extern IPC23CLR         /* 0xBF8102B4 */
  .extern IPC23SET         /* 0xBF8102B8 */
  .extern IPC23INV         /* 0xBF8102BC */
  .extern IPC24            /* 0xBF8102C0 */
  .extern IPC24CLR         /* 0xBF8102C4 */
  .extern IPC24SET         /* 0xBF8102C8 */
  .extern IPC24INV         /* 0xBF8102CC */
  .extern IPC25            /* 0xBF8102D0 */
  .extern IPC25CLR         /* 0xBF8102D4 */
  .extern IPC25SET         /* 0xBF8102D8 */
  .extern IPC25INV         /* 0xBF8102DC */
  .extern IPC26            /* 0xBF8102E0 */
  .extern IPC26CLR         /* 0xBF8102E4 */
  .extern IPC26SET         /* 0xBF8102E8 */
  .extern IPC26INV         /* 0xBF8102EC */
  .extern IPC27            /* 0xBF8102F0 */
  .extern IPC27CLR         /* 0xBF8102F4 */
  .extern IPC27SET         /* 0xBF8102F8 */
  .extern IPC27INV         /* 0xBF8102FC */
  .extern IPC28            /* 0xBF810300 */
  .extern IPC28CLR         /* 0xBF810304 */
  .extern IPC28SET         /* 0xBF810308 */
  .extern IPC28INV         /* 0xBF81030C */
  .extern IPC29            /* 0xBF810310 */
  .extern IPC29CLR         /* 0xBF810314 */
  .extern IPC29SET         /* 0xBF810318 */
  .extern IPC29INV         /* 0xBF81031C */
  .extern IPC30            /* 0xBF810320 */
  .extern IPC30CLR         /* 0xBF810324 */
  .extern IPC30SET         /* 0xBF810328 */
  .extern IPC30INV         /* 0xBF81032C */
  .extern IPC31            /* 0xBF810330 */
  .extern IPC31CLR         /* 0xBF810334 */
  .extern IPC31SET         /* 0xBF810338 */
  .extern IPC31INV         /* 0xBF81033C */
  .extern IPC32            /* 0xBF810340 */
  .extern IPC32CLR         /* 0xBF810344 */
  .extern IPC32SET         /* 0xBF810348 */
  .extern IPC32INV         /* 0xBF81034C */
  .extern IPC33            /* 0xBF810350 */
  .extern IPC33CLR         /* 0xBF810354 */
  .extern IPC33SET         /* 0xBF810358 */
  .extern IPC33INV         /* 0xBF81035C */
  .extern IPC34            /* 0xBF810360 */
  .extern IPC34CLR         /* 0xBF810364 */
  .extern IPC34SET         /* 0xBF810368 */
  .extern IPC34INV         /* 0xBF81036C */
  .extern IPC35            /* 0xBF810370 */
  .extern IPC35CLR         /* 0xBF810374 */
  .extern IPC35SET         /* 0xBF810378 */
  .extern IPC35INV         /* 0xBF81037C */
  .extern IPC36            /* 0xBF810380 */
  .extern IPC36CLR         /* 0xBF810384 */
  .extern IPC36SET         /* 0xBF810388 */
  .extern IPC36INV         /* 0xBF81038C */
  .extern IPC37            /* 0xBF810390 */
  .extern IPC37CLR         /* 0xBF810394 */
  .extern IPC37SET         /* 0xBF810398 */
  .extern IPC37INV         /* 0xBF81039C */
  .extern IPC38            /* 0xBF8103A0 */
  .extern IPC38CLR         /* 0xBF8103A4 */
  .extern IPC38SET         /* 0xBF8103A8 */
  .extern IPC38INV         /* 0xBF8103AC */
  .extern IPC39            /* 0xBF8103B0 */
  .extern IPC39CLR         /* 0xBF8103B4 */
  .extern IPC39SET         /* 0xBF8103B8 */
  .extern IPC39INV         /* 0xBF8103BC */
  .extern IPC40            /* 0xBF8103C0 */
  .extern IPC40CLR         /* 0xBF8103C4 */
  .extern IPC40SET         /* 0xBF8103C8 */
  .extern IPC40INV         /* 0xBF8103CC */
  .extern IPC41            /* 0xBF8103D0 */
  .extern IPC41CLR         /* 0xBF8103D4 */
  .extern IPC41SET         /* 0xBF8103D8 */
  .extern IPC41INV         /* 0xBF8103DC */
  .extern IPC42            /* 0xBF8103E0 */
  .extern IPC42CLR         /* 0xBF8103E4 */
  .extern IPC42SET         /* 0xBF8103E8 */
  .extern IPC42INV         /* 0xBF8103EC */
  .extern IPC43            /* 0xBF8103F0 */
  .extern IPC43CLR         /* 0xBF8103F4 */
  .extern IPC43SET         /* 0xBF8103F8 */
  .extern IPC43INV         /* 0xBF8103FC */
  .extern IPC44            /* 0xBF810400 */
  .extern IPC44CLR         /* 0xBF810404 */
  .extern IPC44SET         /* 0xBF810408 */
  .extern IPC44INV         /* 0xBF81040C */
  .extern IPC45            /* 0xBF810410 */
  .extern IPC45CLR         /* 0xBF810414 */
  .extern IPC45SET         /* 0xBF810418 */
  .extern IPC45INV         /* 0xBF81041C */
  .extern IPC46            /* 0xBF810420 */
  .extern IPC46CLR         /* 0xBF810424 */
  .extern IPC46SET         /* 0xBF810428 */
  .extern IPC46INV         /* 0xBF81042C */
  .extern IPC47            /* 0xBF810430 */
  .extern IPC47CLR         /* 0xBF810434 */
  .extern IPC47SET         /* 0xBF810438 */
  .extern IPC47INV         /* 0xBF81043C */
  .extern OFF000           /* 0xBF810540 */
  .extern OFF001           /* 0xBF810544 */
  .extern OFF002           /* 0xBF810548 */
  .extern OFF003           /* 0xBF81054C */
  .extern OFF004           /* 0xBF810550 */
  .extern OFF005           /* 0xBF810554 */
  .extern OFF006           /* 0xBF810558 */
  .extern OFF007           /* 0xBF81055C */
  .extern OFF008           /* 0xBF810560 */
  .extern OFF009           /* 0xBF810564 */
  .extern OFF010           /* 0xBF810568 */
  .extern OFF011           /* 0xBF81056C */
  .extern OFF012           /* 0xBF810570 */
  .extern OFF013           /* 0xBF810574 */
  .extern OFF014           /* 0xBF810578 */
  .extern OFF015           /* 0xBF81057C */
  .extern OFF016           /* 0xBF810580 */
  .extern OFF017           /* 0xBF810584 */
  .extern OFF018           /* 0xBF810588 */
  .extern OFF019           /* 0xBF81058C */
  .extern OFF020           /* 0xBF810590 */
  .extern OFF021           /* 0xBF810594 */
  .extern OFF022           /* 0xBF810598 */
  .extern OFF023           /* 0xBF81059C */
  .extern OFF024           /* 0xBF8105A0 */
  .extern OFF025           /* 0xBF8105A4 */
  .extern OFF026           /* 0xBF8105A8 */
  .extern OFF027           /* 0xBF8105AC */
  .extern OFF028           /* 0xBF8105B0 */
  .extern OFF029           /* 0xBF8105B4 */
  .extern OFF030           /* 0xBF8105B8 */
  .extern OFF031           /* 0xBF8105BC */
  .extern OFF032           /* 0xBF8105C0 */
  .extern OFF033           /* 0xBF8105C4 */
  .extern OFF034           /* 0xBF8105C8 */
  .extern OFF035           /* 0xBF8105CC */
  .extern OFF036           /* 0xBF8105D0 */
  .extern OFF037           /* 0xBF8105D4 */
  .extern OFF038           /* 0xBF8105D8 */
  .extern OFF039           /* 0xBF8105DC */
  .extern OFF040           /* 0xBF8105E0 */
  .extern OFF041           /* 0xBF8105E4 */
  .extern OFF042           /* 0xBF8105E8 */
  .extern OFF043           /* 0xBF8105EC */
  .extern OFF044           /* 0xBF8105F0 */
  .extern OFF046           /* 0xBF8105F8 */
  .extern OFF047           /* 0xBF8105FC */
  .extern OFF048           /* 0xBF810600 */
  .extern OFF049           /* 0xBF810604 */
  .extern OFF050           /* 0xBF810608 */
  .extern OFF051           /* 0xBF81060C */
  .extern OFF052           /* 0xBF810610 */
  .extern OFF053           /* 0xBF810614 */
  .extern OFF054           /* 0xBF810618 */
  .extern OFF055           /* 0xBF81061C */
  .extern OFF056           /* 0xBF810620 */
  .extern OFF057           /* 0xBF810624 */
  .extern OFF059           /* 0xBF81062C */
  .extern OFF060           /* 0xBF810630 */
  .extern OFF061           /* 0xBF810634 */
  .extern OFF062           /* 0xBF810638 */
  .extern OFF063           /* 0xBF81063C */
  .extern OFF064           /* 0xBF810640 */
  .extern OFF065           /* 0xBF810644 */
  .extern OFF066           /* 0xBF810648 */
  .extern OFF067           /* 0xBF81064C */
  .extern OFF068           /* 0xBF810650 */
  .extern OFF069           /* 0xBF810654 */
  .extern OFF070           /* 0xBF810658 */
  .extern OFF071           /* 0xBF81065C */
  .extern OFF072           /* 0xBF810660 */
  .extern OFF073           /* 0xBF810664 */
  .extern OFF074           /* 0xBF810668 */
  .extern OFF075           /* 0xBF81066C */
  .extern OFF076           /* 0xBF810670 */
  .extern OFF077           /* 0xBF810674 */
  .extern OFF078           /* 0xBF810678 */
  .extern OFF079           /* 0xBF81067C */
  .extern OFF080           /* 0xBF810680 */
  .extern OFF081           /* 0xBF810684 */
  .extern OFF082           /* 0xBF810688 */
  .extern OFF083           /* 0xBF81068C */
  .extern OFF084           /* 0xBF810690 */
  .extern OFF085           /* 0xBF810694 */
  .extern OFF086           /* 0xBF810698 */
  .extern OFF087           /* 0xBF81069C */
  .extern OFF088           /* 0xBF8106A0 */
  .extern OFF089           /* 0xBF8106A4 */
  .extern OFF090           /* 0xBF8106A8 */
  .extern OFF091           /* 0xBF8106AC */
  .extern OFF092           /* 0xBF8106B0 */
  .extern OFF093           /* 0xBF8106B4 */
  .extern OFF094           /* 0xBF8106B8 */
  .extern OFF095           /* 0xBF8106BC */
  .extern OFF096           /* 0xBF8106C0 */
  .extern OFF097           /* 0xBF8106C4 */
  .extern OFF098           /* 0xBF8106C8 */
  .extern OFF099           /* 0xBF8106CC */
  .extern OFF100           /* 0xBF8106D0 */
  .extern OFF101           /* 0xBF8106D4 */
  .extern OFF102           /* 0xBF8106D8 */
  .extern OFF103           /* 0xBF8106DC */
  .extern OFF104           /* 0xBF8106E0 */
  .extern OFF105           /* 0xBF8106E4 */
  .extern OFF106           /* 0xBF8106E8 */
  .extern OFF107           /* 0xBF8106EC */
  .extern OFF109           /* 0xBF8106F4 */
  .extern OFF110           /* 0xBF8106F8 */
  .extern OFF111           /* 0xBF8106FC */
  .extern OFF112           /* 0xBF810700 */
  .extern OFF113           /* 0xBF810704 */
  .extern OFF114           /* 0xBF810708 */
  .extern OFF115           /* 0xBF81070C */
  .extern OFF116           /* 0xBF810710 */
  .extern OFF117           /* 0xBF810714 */
  .extern OFF118           /* 0xBF810718 */
  .extern OFF119           /* 0xBF81071C */
  .extern OFF120           /* 0xBF810720 */
  .extern OFF121           /* 0xBF810724 */
  .extern OFF122           /* 0xBF810728 */
  .extern OFF123           /* 0xBF81072C */
  .extern OFF124           /* 0xBF810730 */
  .extern OFF125           /* 0xBF810734 */
  .extern OFF126           /* 0xBF810738 */
  .extern OFF127           /* 0xBF81073C */
  .extern OFF128           /* 0xBF810740 */
  .extern OFF129           /* 0xBF810744 */
  .extern OFF130           /* 0xBF810748 */
  .extern OFF131           /* 0xBF81074C */
  .extern OFF132           /* 0xBF810750 */
  .extern OFF133           /* 0xBF810754 */
  .extern OFF134           /* 0xBF810758 */
  .extern OFF135           /* 0xBF81075C */
  .extern OFF136           /* 0xBF810760 */
  .extern OFF137           /* 0xBF810764 */
  .extern OFF138           /* 0xBF810768 */
  .extern OFF139           /* 0xBF81076C */
  .extern OFF140           /* 0xBF810770 */
  .extern OFF141           /* 0xBF810774 */
  .extern OFF142           /* 0xBF810778 */
  .extern OFF143           /* 0xBF81077C */
  .extern OFF144           /* 0xBF810780 */
  .extern OFF145           /* 0xBF810784 */
  .extern OFF146           /* 0xBF810788 */
  .extern OFF147           /* 0xBF81078C */
  .extern OFF148           /* 0xBF810790 */
  .extern OFF149           /* 0xBF810794 */
  .extern OFF150           /* 0xBF810798 */
  .extern OFF151           /* 0xBF81079C */
  .extern OFF152           /* 0xBF8107A0 */
  .extern OFF153           /* 0xBF8107A4 */
  .extern OFF154           /* 0xBF8107A8 */
  .extern OFF155           /* 0xBF8107AC */
  .extern OFF156           /* 0xBF8107B0 */
  .extern OFF157           /* 0xBF8107B4 */
  .extern OFF158           /* 0xBF8107B8 */
  .extern OFF159           /* 0xBF8107BC */
  .extern OFF160           /* 0xBF8107C0 */
  .extern OFF161           /* 0xBF8107C4 */
  .extern OFF162           /* 0xBF8107C8 */
  .extern OFF163           /* 0xBF8107CC */
  .extern OFF164           /* 0xBF8107D0 */
  .extern OFF165           /* 0xBF8107D4 */
  .extern OFF166           /* 0xBF8107D8 */
  .extern OFF167           /* 0xBF8107DC */
  .extern OFF168           /* 0xBF8107E0 */
  .extern OFF169           /* 0xBF8107E4 */
  .extern OFF170           /* 0xBF8107E8 */
  .extern OFF171           /* 0xBF8107EC */
  .extern OFF172           /* 0xBF8107F0 */
  .extern OFF173           /* 0xBF8107F4 */
  .extern OFF174           /* 0xBF8107F8 */
  .extern OFF175           /* 0xBF8107FC */
  .extern OFF176           /* 0xBF810800 */
  .extern OFF177           /* 0xBF810804 */
  .extern OFF178           /* 0xBF810808 */
  .extern OFF179           /* 0xBF81080C */
  .extern OFF180           /* 0xBF810810 */
  .extern OFF181           /* 0xBF810814 */
  .extern OFF182           /* 0xBF810818 */
  .extern OFF183           /* 0xBF81081C */
  .extern OFF184           /* 0xBF810820 */
  .extern OFF185           /* 0xBF810824 */
  .extern OFF186           /* 0xBF810828 */
  .extern OFF187           /* 0xBF81082C */
  .extern OFF188           /* 0xBF810830 */
  .extern OFF189           /* 0xBF810834 */
  .extern OFF190           /* 0xBF810838 */
  .extern DMACON           /* 0xBF811000 */
  .extern DMACONCLR        /* 0xBF811004 */
  .extern DMACONSET        /* 0xBF811008 */
  .extern DMACONINV        /* 0xBF81100C */
  .extern DMASTAT          /* 0xBF811010 */
  .extern DMASTATCLR       /* 0xBF811014 */
  .extern DMASTATSET       /* 0xBF811018 */
  .extern DMASTATINV       /* 0xBF81101C */
  .extern DMAADDR          /* 0xBF811020 */
  .extern DMAADDRCLR       /* 0xBF811024 */
  .extern DMAADDRSET       /* 0xBF811028 */
  .extern DMAADDRINV       /* 0xBF81102C */
  .extern DCRCCON          /* 0xBF811030 */
  .extern DCRCCONCLR       /* 0xBF811034 */
  .extern DCRCCONSET       /* 0xBF811038 */
  .extern DCRCCONINV       /* 0xBF81103C */
  .extern DCRCDATA         /* 0xBF811040 */
  .extern DCRCDATACLR      /* 0xBF811044 */
  .extern DCRCDATASET      /* 0xBF811048 */
  .extern DCRCDATAINV      /* 0xBF81104C */
  .extern DCRCXOR          /* 0xBF811050 */
  .extern DCRCXORCLR       /* 0xBF811054 */
  .extern DCRCXORSET       /* 0xBF811058 */
  .extern DCRCXORINV       /* 0xBF81105C */
  .extern DCH0CON          /* 0xBF811060 */
  .extern DCH0CONCLR       /* 0xBF811064 */
  .extern DCH0CONSET       /* 0xBF811068 */
  .extern DCH0CONINV       /* 0xBF81106C */
  .extern DCH0ECON         /* 0xBF811070 */
  .extern DCH0ECONCLR      /* 0xBF811074 */
  .extern DCH0ECONSET      /* 0xBF811078 */
  .extern DCH0ECONINV      /* 0xBF81107C */
  .extern DCH0INT          /* 0xBF811080 */
  .extern DCH0INTCLR       /* 0xBF811084 */
  .extern DCH0INTSET       /* 0xBF811088 */
  .extern DCH0INTINV       /* 0xBF81108C */
  .extern DCH0SSA          /* 0xBF811090 */
  .extern DCH0SSACLR       /* 0xBF811094 */
  .extern DCH0SSASET       /* 0xBF811098 */
  .extern DCH0SSAINV       /* 0xBF81109C */
  .extern DCH0DSA          /* 0xBF8110A0 */
  .extern DCH0DSACLR       /* 0xBF8110A4 */
  .extern DCH0DSASET       /* 0xBF8110A8 */
  .extern DCH0DSAINV       /* 0xBF8110AC */
  .extern DCH0SSIZ         /* 0xBF8110B0 */
  .extern DCH0SSIZCLR      /* 0xBF8110B4 */
  .extern DCH0SSIZSET      /* 0xBF8110B8 */
  .extern DCH0SSIZINV      /* 0xBF8110BC */
  .extern DCH0DSIZ         /* 0xBF8110C0 */
  .extern DCH0DSIZCLR      /* 0xBF8110C4 */
  .extern DCH0DSIZSET      /* 0xBF8110C8 */
  .extern DCH0DSIZINV      /* 0xBF8110CC */
  .extern DCH0SPTR         /* 0xBF8110D0 */
  .extern DCH0SPTRCLR      /* 0xBF8110D4 */
  .extern DCH0SPTRSET      /* 0xBF8110D8 */
  .extern DCH0SPTRINV      /* 0xBF8110DC */
  .extern DCH0DPTR         /* 0xBF8110E0 */
  .extern DCH0DPTRCLR      /* 0xBF8110E4 */
  .extern DCH0DPTRSET      /* 0xBF8110E8 */
  .extern DCH0DPTRINV      /* 0xBF8110EC */
  .extern DCH0CSIZ         /* 0xBF8110F0 */
  .extern DCH0CSIZCLR      /* 0xBF8110F4 */
  .extern DCH0CSIZSET      /* 0xBF8110F8 */
  .extern DCH0CSIZINV      /* 0xBF8110FC */
  .extern DCS0CPTR         /* 0xBF811100 */
  .extern DCS0CPTRCLR      /* 0xBF811104 */
  .extern DCS0CPTRSET      /* 0xBF811108 */
  .extern DCS0CPTRINV      /* 0xBF81110C */
  .extern DCH0DAT          /* 0xBF811110 */
  .extern DCH0DATCLR       /* 0xBF811114 */
  .extern DCH0DATSET       /* 0xBF811118 */
  .extern DCH0DATINV       /* 0xBF81111C */
  .extern DCH1CON          /* 0xBF811120 */
  .extern DCH1CONCLR       /* 0xBF811124 */
  .extern DCH1CONSET       /* 0xBF811128 */
  .extern DCH1CONINV       /* 0xBF81112C */
  .extern DCH1ECON         /* 0xBF811130 */
  .extern DCH1ECONCLR      /* 0xBF811134 */
  .extern DCH1ECONSET      /* 0xBF811138 */
  .extern DCH1ECONINV      /* 0xBF81113C */
  .extern DCH1INT          /* 0xBF811140 */
  .extern DCH1INTCLR       /* 0xBF811144 */
  .extern DCH1INTSET       /* 0xBF811148 */
  .extern DCH1INTINV       /* 0xBF81114C */
  .extern DCH1SSA          /* 0xBF811150 */
  .extern DCH1SSACLR       /* 0xBF811154 */
  .extern DCH1SSASET       /* 0xBF811158 */
  .extern DCH1SSAINV       /* 0xBF81115C */
  .extern DCH1DSA          /* 0xBF811160 */
  .extern DCH1DSACLR       /* 0xBF811164 */
  .extern DCH1DSASET       /* 0xBF811168 */
  .extern DCH1DSAINV       /* 0xBF81116C */
  .extern DCH1SSIZ         /* 0xBF811170 */
  .extern DCH1SSIZCLR      /* 0xBF811174 */
  .extern DCH1SSIZSET      /* 0xBF811178 */
  .extern DCH1SSIZINV      /* 0xBF81117C */
  .extern DCH1DSIZ         /* 0xBF811180 */
  .extern DCH1DSIZCLR      /* 0xBF811184 */
  .extern DCH1DSIZSET      /* 0xBF811188 */
  .extern DCH1DSIZINV      /* 0xBF81118C */
  .extern DCH1SPTR         /* 0xBF811190 */
  .extern DCH1SPTRCLR      /* 0xBF811194 */
  .extern DCH1SPTRSET      /* 0xBF811198 */
  .extern DCH1SPTRINV      /* 0xBF81119C */
  .extern DCH1DPTR         /* 0xBF8111A0 */
  .extern DCH1DPTRCLR      /* 0xBF8111A4 */
  .extern DCH1DPTRSET      /* 0xBF8111A8 */
  .extern DCH1DPTRINV      /* 0xBF8111AC */
  .extern DCH1CSIZ         /* 0xBF8111B0 */
  .extern DCH1CSIZCLR      /* 0xBF8111B4 */
  .extern DCH1CSIZSET      /* 0xBF8111B8 */
  .extern DCH1CSIZINV      /* 0xBF8111BC */
  .extern DCS1CPTR         /* 0xBF8111C0 */
  .extern DCS1CPTRCLR      /* 0xBF8111C4 */
  .extern DCS1CPTRSET      /* 0xBF8111C8 */
  .extern DCS1CPTRINV      /* 0xBF8111CC */
  .extern DCH1DAT          /* 0xBF8111D0 */
  .extern DCH1DATCLR       /* 0xBF8111D4 */
  .extern DCH1DATSET       /* 0xBF8111D8 */
  .extern DCH1DATINV       /* 0xBF8111DC */
  .extern DCH2CON          /* 0xBF8111E0 */
  .extern DCH2CONCLR       /* 0xBF8111E4 */
  .extern DCH2CONSET       /* 0xBF8111E8 */
  .extern DCH2CONINV       /* 0xBF8111EC */
  .extern DCH2ECON         /* 0xBF8111F0 */
  .extern DCH2ECONCLR      /* 0xBF8111F4 */
  .extern DCH2ECONSET      /* 0xBF8111F8 */
  .extern DCH2ECONINV      /* 0xBF8111FC */
  .extern DCH2INT          /* 0xBF811200 */
  .extern DCH2INTCLR       /* 0xBF811204 */
  .extern DCH2INTSET       /* 0xBF811208 */
  .extern DCH2INTINV       /* 0xBF81120C */
  .extern DCH2SSA          /* 0xBF811210 */
  .extern DCH2SSACLR       /* 0xBF811214 */
  .extern DCH2SSASET       /* 0xBF811218 */
  .extern DCH2SSAINV       /* 0xBF81121C */
  .extern DCH2DSA          /* 0xBF811220 */
  .extern DCH2DSACLR       /* 0xBF811224 */
  .extern DCH2DSASET       /* 0xBF811228 */
  .extern DCH2DSAINV       /* 0xBF81122C */
  .extern DCH2SSIZ         /* 0xBF811230 */
  .extern DCH2SSIZCLR      /* 0xBF811234 */
  .extern DCH2SSIZSET      /* 0xBF811238 */
  .extern DCH2SSIZINV      /* 0xBF81123C */
  .extern DCH2DSIZ         /* 0xBF811240 */
  .extern DCH2DSIZCLR      /* 0xBF811244 */
  .extern DCH2DSIZSET      /* 0xBF811248 */
  .extern DCH2DSIZINV      /* 0xBF81124C */
  .extern DCH2SPTR         /* 0xBF811250 */
  .extern DCH2SPTRCLR      /* 0xBF811254 */
  .extern DCH2SPTRSET      /* 0xBF811258 */
  .extern DCH2SPTRINV      /* 0xBF81125C */
  .extern DCH2DPTR         /* 0xBF811260 */
  .extern DCH2DPTRCLR      /* 0xBF811264 */
  .extern DCH2DPTRSET      /* 0xBF811268 */
  .extern DCH2DPTRINV      /* 0xBF81126C */
  .extern DCH2CSIZ         /* 0xBF811270 */
  .extern DCH2CSIZCLR      /* 0xBF811274 */
  .extern DCH2CSIZSET      /* 0xBF811278 */
  .extern DCH2CSIZINV      /* 0xBF81127C */
  .extern DCS2CPTR         /* 0xBF811280 */
  .extern DCS2CPTRCLR      /* 0xBF811284 */
  .extern DCS2CPTRSET      /* 0xBF811288 */
  .extern DCS2CPTRINV      /* 0xBF81128C */
  .extern DCH2DAT          /* 0xBF811290 */
  .extern DCH2DATCLR       /* 0xBF811294 */
  .extern DCH2DATSET       /* 0xBF811298 */
  .extern DCH2DATINV       /* 0xBF81129C */
  .extern DCH3CON          /* 0xBF8112A0 */
  .extern DCH3CONCLR       /* 0xBF8112A4 */
  .extern DCH3CONSET       /* 0xBF8112A8 */
  .extern DCH3CONINV       /* 0xBF8112AC */
  .extern DCH3ECON         /* 0xBF8112B0 */
  .extern DCH3ECONCLR      /* 0xBF8112B4 */
  .extern DCH3ECONSET      /* 0xBF8112B8 */
  .extern DCH3ECONINV      /* 0xBF8112BC */
  .extern DCH3INT          /* 0xBF8112C0 */
  .extern DCH3INTCLR       /* 0xBF8112C4 */
  .extern DCH3INTSET       /* 0xBF8112C8 */
  .extern DCH3INTINV       /* 0xBF8112CC */
  .extern DCH3SSA          /* 0xBF8112D0 */
  .extern DCH3SSACLR       /* 0xBF8112D4 */
  .extern DCH3SSASET       /* 0xBF8112D8 */
  .extern DCH3SSAINV       /* 0xBF8112DC */
  .extern DCH3DSA          /* 0xBF8112E0 */
  .extern DCH3DSACLR       /* 0xBF8112E4 */
  .extern DCH3DSASET       /* 0xBF8112E8 */
  .extern DCH3DSAINV       /* 0xBF8112EC */
  .extern DCH3SSIZ         /* 0xBF8112F0 */
  .extern DCH3SSIZCLR      /* 0xBF8112F4 */
  .extern DCH3SSIZSET      /* 0xBF8112F8 */
  .extern DCH3SSIZINV      /* 0xBF8112FC */
  .extern DCH3DSIZ         /* 0xBF811300 */
  .extern DCH3DSIZCLR      /* 0xBF811304 */
  .extern DCH3DSIZSET      /* 0xBF811308 */
  .extern DCH3DSIZINV      /* 0xBF81130C */
  .extern DCH3SPTR         /* 0xBF811310 */
  .extern DCH3SPTRCLR      /* 0xBF811314 */
  .extern DCH3SPTRSET      /* 0xBF811318 */
  .extern DCH3SPTRINV      /* 0xBF81131C */
  .extern DCH3DPTR         /* 0xBF811320 */
  .extern DCH3DPTRCLR      /* 0xBF811324 */
  .extern DCH3DPTRSET      /* 0xBF811328 */
  .extern DCH3DPTRINV      /* 0xBF81132C */
  .extern DCH3CSIZ         /* 0xBF811330 */
  .extern DCH3CSIZCLR      /* 0xBF811334 */
  .extern DCH3CSIZSET      /* 0xBF811338 */
  .extern DCH3CSIZINV      /* 0xBF81133C */
  .extern DCS3CPTR         /* 0xBF811340 */
  .extern DCS3CPTRCLR      /* 0xBF811344 */
  .extern DCS3CPTRSET      /* 0xBF811348 */
  .extern DCS3CPTRINV      /* 0xBF81134C */
  .extern DCH3DAT          /* 0xBF811350 */
  .extern DCH3DATCLR       /* 0xBF811354 */
  .extern DCH3DATSET       /* 0xBF811358 */
  .extern DCH3DATINV       /* 0xBF81135C */
  .extern DCH4CON          /* 0xBF811360 */
  .extern DCH4CONCLR       /* 0xBF811364 */
  .extern DCH4CONSET       /* 0xBF811368 */
  .extern DCH4CONINV       /* 0xBF81136C */
  .extern DCH4ECON         /* 0xBF811370 */
  .extern DCH4ECONCLR      /* 0xBF811374 */
  .extern DCH4ECONSET      /* 0xBF811378 */
  .extern DCH4ECONINV      /* 0xBF81137C */
  .extern DCH4INT          /* 0xBF811380 */
  .extern DCH4INTCLR       /* 0xBF811384 */
  .extern DCH4INTSET       /* 0xBF811388 */
  .extern DCH4INTINV       /* 0xBF81138C */
  .extern DCH4SSA          /* 0xBF811390 */
  .extern DCH4SSACLR       /* 0xBF811394 */
  .extern DCH4SSASET       /* 0xBF811398 */
  .extern DCH4SSAINV       /* 0xBF81139C */
  .extern DCH4DSA          /* 0xBF8113A0 */
  .extern DCH4DSACLR       /* 0xBF8113A4 */
  .extern DCH4DSASET       /* 0xBF8113A8 */
  .extern DCH4DSAINV       /* 0xBF8113AC */
  .extern DCH4SSIZ         /* 0xBF8113B0 */
  .extern DCH4SSIZCLR      /* 0xBF8113B4 */
  .extern DCH4SSIZSET      /* 0xBF8113B8 */
  .extern DCH4SSIZINV      /* 0xBF8113BC */
  .extern DCH4DSIZ         /* 0xBF8113C0 */
  .extern DCH4DSIZCLR      /* 0xBF8113C4 */
  .extern DCH4DSIZSET      /* 0xBF8113C8 */
  .extern DCH4DSIZINV      /* 0xBF8113CC */
  .extern DCH4SPTR         /* 0xBF8113D0 */
  .extern DCH4SPTRCLR      /* 0xBF8113D4 */
  .extern DCH4SPTRSET      /* 0xBF8113D8 */
  .extern DCH4SPTRINV      /* 0xBF8113DC */
  .extern DCH4DPTR         /* 0xBF8113E0 */
  .extern DCH4DPTRCLR      /* 0xBF8113E4 */
  .extern DCH4DPTRSET      /* 0xBF8113E8 */
  .extern DCH4DPTRINV      /* 0xBF8113EC */
  .extern DCH4CSIZ         /* 0xBF8113F0 */
  .extern DCH4CSIZCLR      /* 0xBF8113F4 */
  .extern DCH4CSIZSET      /* 0xBF8113F8 */
  .extern DCH4CSIZINV      /* 0xBF8113FC */
  .extern DCS4CPTR         /* 0xBF811400 */
  .extern DCS4CPTRCLR      /* 0xBF811404 */
  .extern DCS4CPTRSET      /* 0xBF811408 */
  .extern DCS4CPTRINV      /* 0xBF81140C */
  .extern DCH4DAT          /* 0xBF811410 */
  .extern DCH4DATCLR       /* 0xBF811414 */
  .extern DCH4DATSET       /* 0xBF811418 */
  .extern DCH4DATINV       /* 0xBF81141C */
  .extern DCH5CON          /* 0xBF811420 */
  .extern DCH5CONCLR       /* 0xBF811424 */
  .extern DCH5CONSET       /* 0xBF811428 */
  .extern DCH5CONINV       /* 0xBF81142C */
  .extern DCH5ECON         /* 0xBF811430 */
  .extern DCH5ECONCLR      /* 0xBF811434 */
  .extern DCH5ECONSET      /* 0xBF811438 */
  .extern DCH5ECONINV      /* 0xBF81143C */
  .extern DCH5INT          /* 0xBF811440 */
  .extern DCH5INTCLR       /* 0xBF811444 */
  .extern DCH5INTSET       /* 0xBF811448 */
  .extern DCH5INTINV       /* 0xBF81144C */
  .extern DCH5SSA          /* 0xBF811450 */
  .extern DCH5SSACLR       /* 0xBF811454 */
  .extern DCH5SSASET       /* 0xBF811458 */
  .extern DCH5SSAINV       /* 0xBF81145C */
  .extern DCH5DSA          /* 0xBF811460 */
  .extern DCH5DSACLR       /* 0xBF811464 */
  .extern DCH5DSASET       /* 0xBF811468 */
  .extern DCH5DSAINV       /* 0xBF81146C */
  .extern DCH5SSIZ         /* 0xBF811470 */
  .extern DCH5SSIZCLR      /* 0xBF811474 */
  .extern DCH5SSIZSET      /* 0xBF811478 */
  .extern DCH5SSIZINV      /* 0xBF81147C */
  .extern DCH5DSIZ         /* 0xBF811480 */
  .extern DCH5DSIZCLR      /* 0xBF811484 */
  .extern DCH5DSIZSET      /* 0xBF811488 */
  .extern DCH5DSIZINV      /* 0xBF81148C */
  .extern DCH5SPTR         /* 0xBF811490 */
  .extern DCH5SPTRCLR      /* 0xBF811494 */
  .extern DCH5SPTRSET      /* 0xBF811498 */
  .extern DCH5SPTRINV      /* 0xBF81149C */
  .extern DCH5DPTR         /* 0xBF8114A0 */
  .extern DCH5DPTRCLR      /* 0xBF8114A4 */
  .extern DCH5DPTRSET      /* 0xBF8114A8 */
  .extern DCH5DPTRINV      /* 0xBF8114AC */
  .extern DCH5CSIZ         /* 0xBF8114B0 */
  .extern DCH5CSIZCLR      /* 0xBF8114B4 */
  .extern DCH5CSIZSET      /* 0xBF8114B8 */
  .extern DCH5CSIZINV      /* 0xBF8114BC */
  .extern DCS5CPTR         /* 0xBF8114C0 */
  .extern DCS5CPTRCLR      /* 0xBF8114C4 */
  .extern DCS5CPTRSET      /* 0xBF8114C8 */
  .extern DCS5CPTRINV      /* 0xBF8114CC */
  .extern DCH5DAT          /* 0xBF8114D0 */
  .extern DCH5DATCLR       /* 0xBF8114D4 */
  .extern DCH5DATSET       /* 0xBF8114D8 */
  .extern DCH5DATINV       /* 0xBF8114DC */
  .extern DCH6CON          /* 0xBF8114E0 */
  .extern DCH6CONCLR       /* 0xBF8114E4 */
  .extern DCH6CONSET       /* 0xBF8114E8 */
  .extern DCH6CONINV       /* 0xBF8114EC */
  .extern DCH6ECON         /* 0xBF8114F0 */
  .extern DCH6ECONCLR      /* 0xBF8114F4 */
  .extern DCH6ECONSET      /* 0xBF8114F8 */
  .extern DCH6ECONINV      /* 0xBF8114FC */
  .extern DCH6INT          /* 0xBF811500 */
  .extern DCH6INTCLR       /* 0xBF811504 */
  .extern DCH6INTSET       /* 0xBF811508 */
  .extern DCH6INTINV       /* 0xBF81150C */
  .extern DCH6SSA          /* 0xBF811510 */
  .extern DCH6SSACLR       /* 0xBF811514 */
  .extern DCH6SSASET       /* 0xBF811518 */
  .extern DCH6SSAINV       /* 0xBF81151C */
  .extern DCH6DSA          /* 0xBF811520 */
  .extern DCH6DSACLR       /* 0xBF811524 */
  .extern DCH6DSASET       /* 0xBF811528 */
  .extern DCH6DSAINV       /* 0xBF81152C */
  .extern DCH6SSIZ         /* 0xBF811530 */
  .extern DCH6SSIZCLR      /* 0xBF811534 */
  .extern DCH6SSIZSET      /* 0xBF811538 */
  .extern DCH6SSIZINV      /* 0xBF81153C */
  .extern DCH6DSIZ         /* 0xBF811540 */
  .extern DCH6DSIZCLR      /* 0xBF811544 */
  .extern DCH6DSIZSET      /* 0xBF811548 */
  .extern DCH6DSIZINV      /* 0xBF81154C */
  .extern DCH6SPTR         /* 0xBF811550 */
  .extern DCH6SPTRCLR      /* 0xBF811554 */
  .extern DCH6SPTRSET      /* 0xBF811558 */
  .extern DCH6SPTRINV      /* 0xBF81155C */
  .extern DCH6DPTR         /* 0xBF811560 */
  .extern DCH6DPTRCLR      /* 0xBF811564 */
  .extern DCH6DPTRSET      /* 0xBF811568 */
  .extern DCH6DPTRINV      /* 0xBF81156C */
  .extern DCH6CSIZ         /* 0xBF811570 */
  .extern DCH6CSIZCLR      /* 0xBF811574 */
  .extern DCH6CSIZSET      /* 0xBF811578 */
  .extern DCH6CSIZINV      /* 0xBF81157C */
  .extern DCS6CPTR         /* 0xBF811580 */
  .extern DCS6CPTRCLR      /* 0xBF811584 */
  .extern DCS6CPTRSET      /* 0xBF811588 */
  .extern DCS6CPTRINV      /* 0xBF81158C */
  .extern DCH6DAT          /* 0xBF811590 */
  .extern DCH6DATCLR       /* 0xBF811594 */
  .extern DCH6DATSET       /* 0xBF811598 */
  .extern DCH6DATINV       /* 0xBF81159C */
  .extern DCH7CON          /* 0xBF8115A0 */
  .extern DCH7CONCLR       /* 0xBF8115A4 */
  .extern DCH7CONSET       /* 0xBF8115A8 */
  .extern DCH7CONINV       /* 0xBF8115AC */
  .extern DCH7ECON         /* 0xBF8115B0 */
  .extern DCH7ECONCLR      /* 0xBF8115B4 */
  .extern DCH7ECONSET      /* 0xBF8115B8 */
  .extern DCH7ECONINV      /* 0xBF8115BC */
  .extern DCH7INT          /* 0xBF8115C0 */
  .extern DCH7INTCLR       /* 0xBF8115C4 */
  .extern DCH7INTSET       /* 0xBF8115C8 */
  .extern DCH7INTINV       /* 0xBF8115CC */
  .extern DCH7SSA          /* 0xBF8115D0 */
  .extern DCH7SSACLR       /* 0xBF8115D4 */
  .extern DCH7SSASET       /* 0xBF8115D8 */
  .extern DCH7SSAINV       /* 0xBF8115DC */
  .extern DCH7DSA          /* 0xBF8115E0 */
  .extern DCH7DSACLR       /* 0xBF8115E4 */
  .extern DCH7DSASET       /* 0xBF8115E8 */
  .extern DCH7DSAINV       /* 0xBF8115EC */
  .extern DCH7SSIZ         /* 0xBF8115F0 */
  .extern DCH7SSIZCLR      /* 0xBF8115F4 */
  .extern DCH7SSIZSET      /* 0xBF8115F8 */
  .extern DCH7SSIZINV      /* 0xBF8115FC */
  .extern DCH7DSIZ         /* 0xBF811600 */
  .extern DCH7DSIZCLR      /* 0xBF811604 */
  .extern DCH7DSIZSET      /* 0xBF811608 */
  .extern DCH7DSIZINV      /* 0xBF81160C */
  .extern DCH7SPTR         /* 0xBF811610 */
  .extern DCH7SPTRCLR      /* 0xBF811614 */
  .extern DCH7SPTRSET      /* 0xBF811618 */
  .extern DCH7SPTRINV      /* 0xBF81161C */
  .extern DCH7DPTR         /* 0xBF811620 */
  .extern DCH7DPTRCLR      /* 0xBF811624 */
  .extern DCH7DPTRSET      /* 0xBF811628 */
  .extern DCH7DPTRINV      /* 0xBF81162C */
  .extern DCH7CSIZ         /* 0xBF811630 */
  .extern DCH7CSIZCLR      /* 0xBF811634 */
  .extern DCH7CSIZSET      /* 0xBF811638 */
  .extern DCH7CSIZINV      /* 0xBF81163C */
  .extern DCS7CPTR         /* 0xBF811640 */
  .extern DCS7CPTRCLR      /* 0xBF811644 */
  .extern DCS7CPTRSET      /* 0xBF811648 */
  .extern DCS7CPTRINV      /* 0xBF81164C */
  .extern DCH7DAT          /* 0xBF811650 */
  .extern DCH7DATCLR       /* 0xBF811654 */
  .extern DCH7DATSET       /* 0xBF811658 */
  .extern DCH7DATINV       /* 0xBF81165C */
  .extern I2C1CON          /* 0xBF820000 */
  .extern I2C1CONCLR       /* 0xBF820004 */
  .extern I2C1CONSET       /* 0xBF820008 */
  .extern I2C1CONINV       /* 0xBF82000C */
  .extern I2C1STAT         /* 0xBF820010 */
  .extern I2C1STATCLR      /* 0xBF820014 */
  .extern I2C1STATSET      /* 0xBF820018 */
  .extern I2C1STATINV      /* 0xBF82001C */
  .extern I2C1ADD          /* 0xBF820020 */
  .extern I2C1ADDCLR       /* 0xBF820024 */
  .extern I2C1ADDSET       /* 0xBF820028 */
  .extern I2C1ADDINV       /* 0xBF82002C */
  .extern I2C1MSK          /* 0xBF820030 */
  .extern I2C1MSKCLR       /* 0xBF820034 */
  .extern I2C1MSKSET       /* 0xBF820038 */
  .extern I2C1MSKINV       /* 0xBF82003C */
  .extern I2C1BRG          /* 0xBF820040 */
  .extern I2C1BRGCLR       /* 0xBF820044 */
  .extern I2C1BRGSET       /* 0xBF820048 */
  .extern I2C1BRGINV       /* 0xBF82004C */
  .extern I2C1TRN          /* 0xBF820050 */
  .extern I2C1TRNCLR       /* 0xBF820054 */
  .extern I2C1TRNSET       /* 0xBF820058 */
  .extern I2C1TRNINV       /* 0xBF82005C */
  .extern I2C1RCV          /* 0xBF820060 */
  .extern I2C1RCVCLR       /* 0xBF820064 */
  .extern I2C1RCVSET       /* 0xBF820068 */
  .extern I2C1RCVINV       /* 0xBF82006C */
  .extern I2C2CON          /* 0xBF820200 */
  .extern I2C2CONCLR       /* 0xBF820204 */
  .extern I2C2CONSET       /* 0xBF820208 */
  .extern I2C2CONINV       /* 0xBF82020C */
  .extern I2C2STAT         /* 0xBF820210 */
  .extern I2C2STATCLR      /* 0xBF820214 */
  .extern I2C2STATSET      /* 0xBF820218 */
  .extern I2C2STATINV      /* 0xBF82021C */
  .extern I2C2ADD          /* 0xBF820220 */
  .extern I2C2ADDCLR       /* 0xBF820224 */
  .extern I2C2ADDSET       /* 0xBF820228 */
  .extern I2C2ADDINV       /* 0xBF82022C */
  .extern I2C2MSK          /* 0xBF820230 */
  .extern I2C2MSKCLR       /* 0xBF820234 */
  .extern I2C2MSKSET       /* 0xBF820238 */
  .extern I2C2MSKINV       /* 0xBF82023C */
  .extern I2C2BRG          /* 0xBF820240 */
  .extern I2C2BRGCLR       /* 0xBF820244 */
  .extern I2C2BRGSET       /* 0xBF820248 */
  .extern I2C2BRGINV       /* 0xBF82024C */
  .extern I2C2TRN          /* 0xBF820250 */
  .extern I2C2TRNCLR       /* 0xBF820254 */
  .extern I2C2TRNSET       /* 0xBF820258 */
  .extern I2C2TRNINV       /* 0xBF82025C */
  .extern I2C2RCV          /* 0xBF820260 */
  .extern I2C2RCVCLR       /* 0xBF820264 */
  .extern I2C2RCVSET       /* 0xBF820268 */
  .extern I2C2RCVINV       /* 0xBF82026C */
  .extern I2C3CON          /* 0xBF820400 */
  .extern I2C3CONCLR       /* 0xBF820404 */
  .extern I2C3CONSET       /* 0xBF820408 */
  .extern I2C3CONINV       /* 0xBF82040C */
  .extern I2C3STAT         /* 0xBF820410 */
  .extern I2C3STATCLR      /* 0xBF820414 */
  .extern I2C3STATSET      /* 0xBF820418 */
  .extern I2C3STATINV      /* 0xBF82041C */
  .extern I2C3ADD          /* 0xBF820420 */
  .extern I2C3ADDCLR       /* 0xBF820424 */
  .extern I2C3ADDSET       /* 0xBF820428 */
  .extern I2C3ADDINV       /* 0xBF82042C */
  .extern I2C3MSK          /* 0xBF820430 */
  .extern I2C3MSKCLR       /* 0xBF820434 */
  .extern I2C3MSKSET       /* 0xBF820438 */
  .extern I2C3MSKINV       /* 0xBF82043C */
  .extern I2C3BRG          /* 0xBF820440 */
  .extern I2C3BRGCLR       /* 0xBF820444 */
  .extern I2C3BRGSET       /* 0xBF820448 */
  .extern I2C3BRGINV       /* 0xBF82044C */
  .extern I2C3TRN          /* 0xBF820450 */
  .extern I2C3TRNCLR       /* 0xBF820454 */
  .extern I2C3TRNSET       /* 0xBF820458 */
  .extern I2C3TRNINV       /* 0xBF82045C */
  .extern I2C3RCV          /* 0xBF820460 */
  .extern I2C3RCVCLR       /* 0xBF820464 */
  .extern I2C3RCVSET       /* 0xBF820468 */
  .extern I2C3RCVINV       /* 0xBF82046C */
  .extern I2C4CON          /* 0xBF820600 */
  .extern I2C4CONCLR       /* 0xBF820604 */
  .extern I2C4CONSET       /* 0xBF820608 */
  .extern I2C4CONINV       /* 0xBF82060C */
  .extern I2C4STAT         /* 0xBF820610 */
  .extern I2C4STATCLR      /* 0xBF820614 */
  .extern I2C4STATSET      /* 0xBF820618 */
  .extern I2C4STATINV      /* 0xBF82061C */
  .extern I2C4ADD          /* 0xBF820620 */
  .extern I2C4ADDCLR       /* 0xBF820624 */
  .extern I2C4ADDSET       /* 0xBF820628 */
  .extern I2C4ADDINV       /* 0xBF82062C */
  .extern I2C4MSK          /* 0xBF820630 */
  .extern I2C4MSKCLR       /* 0xBF820634 */
  .extern I2C4MSKSET       /* 0xBF820638 */
  .extern I2C4MSKINV       /* 0xBF82063C */
  .extern I2C4BRG          /* 0xBF820640 */
  .extern I2C4BRGCLR       /* 0xBF820644 */
  .extern I2C4BRGSET       /* 0xBF820648 */
  .extern I2C4BRGINV       /* 0xBF82064C */
  .extern I2C4TRN          /* 0xBF820650 */
  .extern I2C4TRNCLR       /* 0xBF820654 */
  .extern I2C4TRNSET       /* 0xBF820658 */
  .extern I2C4TRNINV       /* 0xBF82065C */
  .extern I2C4RCV          /* 0xBF820660 */
  .extern I2C4RCVCLR       /* 0xBF820664 */
  .extern I2C4RCVSET       /* 0xBF820668 */
  .extern I2C4RCVINV       /* 0xBF82066C */
  .extern I2C5CON          /* 0xBF820800 */
  .extern I2C5CONCLR       /* 0xBF820804 */
  .extern I2C5CONSET       /* 0xBF820808 */
  .extern I2C5CONINV       /* 0xBF82080C */
  .extern I2C5STAT         /* 0xBF820810 */
  .extern I2C5STATCLR      /* 0xBF820814 */
  .extern I2C5STATSET      /* 0xBF820818 */
  .extern I2C5STATINV      /* 0xBF82081C */
  .extern I2C5ADD          /* 0xBF820820 */
  .extern I2C5ADDCLR       /* 0xBF820824 */
  .extern I2C5ADDSET       /* 0xBF820828 */
  .extern I2C5ADDINV       /* 0xBF82082C */
  .extern I2C5MSK          /* 0xBF820830 */
  .extern I2C5MSKCLR       /* 0xBF820834 */
  .extern I2C5MSKSET       /* 0xBF820838 */
  .extern I2C5MSKINV       /* 0xBF82083C */
  .extern I2C5BRG          /* 0xBF820840 */
  .extern I2C5BRGCLR       /* 0xBF820844 */
  .extern I2C5BRGSET       /* 0xBF820848 */
  .extern I2C5BRGINV       /* 0xBF82084C */
  .extern I2C5TRN          /* 0xBF820850 */
  .extern I2C5TRNCLR       /* 0xBF820854 */
  .extern I2C5TRNSET       /* 0xBF820858 */
  .extern I2C5TRNINV       /* 0xBF82085C */
  .extern I2C5RCV          /* 0xBF820860 */
  .extern I2C5RCVCLR       /* 0xBF820864 */
  .extern I2C5RCVSET       /* 0xBF820868 */
  .extern I2C5RCVINV       /* 0xBF82086C */
  .extern SPI1CON          /* 0xBF821000 */
  .extern SPI1CONCLR       /* 0xBF821004 */
  .extern SPI1CONSET       /* 0xBF821008 */
  .extern SPI1CONINV       /* 0xBF82100C */
  .extern SPI1STAT         /* 0xBF821010 */
  .extern SPI1STATCLR      /* 0xBF821014 */
  .extern SPI1STATSET      /* 0xBF821018 */
  .extern SPI1STATINV      /* 0xBF82101C */
  .extern SPI1BUF          /* 0xBF821020 */
  .extern SPI1BRG          /* 0xBF821030 */
  .extern SPI1BRGCLR       /* 0xBF821034 */
  .extern SPI1BRGSET       /* 0xBF821038 */
  .extern SPI1BRGINV       /* 0xBF82103C */
  .extern SPI1CON2         /* 0xBF821040 */
  .extern SPI1CON2CLR      /* 0xBF821044 */
  .extern SPI1CON2SET      /* 0xBF821048 */
  .extern SPI1CON2INV      /* 0xBF82104C */
  .extern SPI2CON          /* 0xBF821200 */
  .extern SPI2CONCLR       /* 0xBF821204 */
  .extern SPI2CONSET       /* 0xBF821208 */
  .extern SPI2CONINV       /* 0xBF82120C */
  .extern SPI2STAT         /* 0xBF821210 */
  .extern SPI2STATCLR      /* 0xBF821214 */
  .extern SPI2STATSET      /* 0xBF821218 */
  .extern SPI2STATINV      /* 0xBF82121C */
  .extern SPI2BUF          /* 0xBF821220 */
  .extern SPI2BRG          /* 0xBF821230 */
  .extern SPI2BRGCLR       /* 0xBF821234 */
  .extern SPI2BRGSET       /* 0xBF821238 */
  .extern SPI2BRGINV       /* 0xBF82123C */
  .extern SPI2CON2         /* 0xBF821240 */
  .extern SPI2CON2CLR      /* 0xBF821244 */
  .extern SPI2CON2SET      /* 0xBF821248 */
  .extern SPI2CON2INV      /* 0xBF82124C */
  .extern SPI3CON          /* 0xBF821400 */
  .extern SPI3CONCLR       /* 0xBF821404 */
  .extern SPI3CONSET       /* 0xBF821408 */
  .extern SPI3CONINV       /* 0xBF82140C */
  .extern SPI3STAT         /* 0xBF821410 */
  .extern SPI3STATCLR      /* 0xBF821414 */
  .extern SPI3STATSET      /* 0xBF821418 */
  .extern SPI3STATINV      /* 0xBF82141C */
  .extern SPI3BUF          /* 0xBF821420 */
  .extern SPI3BRG          /* 0xBF821430 */
  .extern SPI3BRGCLR       /* 0xBF821434 */
  .extern SPI3BRGSET       /* 0xBF821438 */
  .extern SPI3BRGINV       /* 0xBF82143C */
  .extern SPI3CON2         /* 0xBF821440 */
  .extern SPI3CON2CLR      /* 0xBF821444 */
  .extern SPI3CON2SET      /* 0xBF821448 */
  .extern SPI3CON2INV      /* 0xBF82144C */
  .extern SPI4CON          /* 0xBF821600 */
  .extern SPI4CONCLR       /* 0xBF821604 */
  .extern SPI4CONSET       /* 0xBF821608 */
  .extern SPI4CONINV       /* 0xBF82160C */
  .extern SPI4STAT         /* 0xBF821610 */
  .extern SPI4STATCLR      /* 0xBF821614 */
  .extern SPI4STATSET      /* 0xBF821618 */
  .extern SPI4STATINV      /* 0xBF82161C */
  .extern SPI4BUF          /* 0xBF821620 */
  .extern SPI4BRG          /* 0xBF821630 */
  .extern SPI4BRGCLR       /* 0xBF821634 */
  .extern SPI4BRGSET       /* 0xBF821638 */
  .extern SPI4BRGINV       /* 0xBF82163C */
  .extern SPI4CON2         /* 0xBF821640 */
  .extern SPI4CON2CLR      /* 0xBF821644 */
  .extern SPI4CON2SET      /* 0xBF821648 */
  .extern SPI4CON2INV      /* 0xBF82164C */
  .extern SPI5CON          /* 0xBF821800 */
  .extern SPI5CONCLR       /* 0xBF821804 */
  .extern SPI5CONSET       /* 0xBF821808 */
  .extern SPI5CONINV       /* 0xBF82180C */
  .extern SPI5STAT         /* 0xBF821810 */
  .extern SPI5STATCLR      /* 0xBF821814 */
  .extern SPI5STATSET      /* 0xBF821818 */
  .extern SPI5STATINV      /* 0xBF82181C */
  .extern SPI5BUF          /* 0xBF821820 */
  .extern SPI5BRG          /* 0xBF821830 */
  .extern SPI5BRGCLR       /* 0xBF821834 */
  .extern SPI5BRGSET       /* 0xBF821838 */
  .extern SPI5BRGINV       /* 0xBF82183C */
  .extern SPI5CON2         /* 0xBF821840 */
  .extern SPI5CON2CLR      /* 0xBF821844 */
  .extern SPI5CON2SET      /* 0xBF821848 */
  .extern SPI5CON2INV      /* 0xBF82184C */
  .extern SPI6CON          /* 0xBF821A00 */
  .extern SPI6CONCLR       /* 0xBF821A04 */
  .extern SPI6CONSET       /* 0xBF821A08 */
  .extern SPI6CONINV       /* 0xBF821A0C */
  .extern SPI6STAT         /* 0xBF821A10 */
  .extern SPI6STATCLR      /* 0xBF821A14 */
  .extern SPI6STATSET      /* 0xBF821A18 */
  .extern SPI6STATINV      /* 0xBF821A1C */
  .extern SPI6BUF          /* 0xBF821A20 */
  .extern SPI6BRG          /* 0xBF821A30 */
  .extern SPI6BRGCLR       /* 0xBF821A34 */
  .extern SPI6BRGSET       /* 0xBF821A38 */
  .extern SPI6BRGINV       /* 0xBF821A3C */
  .extern SPI6CON2         /* 0xBF821A40 */
  .extern SPI6CON2CLR      /* 0xBF821A44 */
  .extern SPI6CON2SET      /* 0xBF821A48 */
  .extern SPI6CON2INV      /* 0xBF821A4C */
  .extern U1MODE           /* 0xBF822000 */
  .extern UABMODE          /* 0xBF822000 */
  .extern U1MODECLR        /* 0xBF822004 */
  .extern UABMODECLR       /* 0xBF822004 */
  .extern U1MODESET        /* 0xBF822008 */
  .extern UABMODESET       /* 0xBF822008 */
  .extern U1MODEINV        /* 0xBF82200C */
  .extern UABMODEINV       /* 0xBF82200C */
  .extern U1STA            /* 0xBF822010 */
  .extern UABSTA           /* 0xBF822010 */
  .extern U1STACLR         /* 0xBF822014 */
  .extern UABSTACLR        /* 0xBF822014 */
  .extern U1STASET         /* 0xBF822018 */
  .extern UABSTASET        /* 0xBF822018 */
  .extern U1STAINV         /* 0xBF82201C */
  .extern UABSTAINV        /* 0xBF82201C */
  .extern U1TXREG          /* 0xBF822020 */
  .extern UABTXREG         /* 0xBF822020 */
  .extern U1RXREG          /* 0xBF822030 */
  .extern UABRXREG         /* 0xBF822030 */
  .extern U1BRG            /* 0xBF822040 */
  .extern UABBRG           /* 0xBF822040 */
  .extern U1BRGCLR         /* 0xBF822044 */
  .extern UABBRGCLR        /* 0xBF822044 */
  .extern U1BRGSET         /* 0xBF822048 */
  .extern UABBRGSET        /* 0xBF822048 */
  .extern U1BRGINV         /* 0xBF82204C */
  .extern UABBRGINV        /* 0xBF82204C */
  .extern U2MODE           /* 0xBF822200 */
  .extern UCDMODE          /* 0xBF822200 */
  .extern U2MODECLR        /* 0xBF822204 */
  .extern UCDMODECLR       /* 0xBF822204 */
  .extern U2MODESET        /* 0xBF822208 */
  .extern UCDMODESET       /* 0xBF822208 */
  .extern U2MODEINV        /* 0xBF82220C */
  .extern UCDMODEINV       /* 0xBF82220C */
  .extern U2STA            /* 0xBF822210 */
  .extern UCDSTA           /* 0xBF822210 */
  .extern U2STACLR         /* 0xBF822214 */
  .extern UCDSTACLR        /* 0xBF822214 */
  .extern U2STASET         /* 0xBF822218 */
  .extern UCDSTASET        /* 0xBF822218 */
  .extern U2STAINV         /* 0xBF82221C */
  .extern UCDSTAINV        /* 0xBF82221C */
  .extern U2TXREG          /* 0xBF822220 */
  .extern UCDTXREG         /* 0xBF822220 */
  .extern U2RXREG          /* 0xBF822230 */
  .extern UCDRXREG         /* 0xBF822230 */
  .extern U2BRG            /* 0xBF822240 */
  .extern UCDBRG           /* 0xBF822240 */
  .extern U2BRGCLR         /* 0xBF822244 */
  .extern UCDBRGCLR        /* 0xBF822244 */
  .extern U2BRGSET         /* 0xBF822248 */
  .extern UCDBRGSET        /* 0xBF822248 */
  .extern U2BRGINV         /* 0xBF82224C */
  .extern UCDBRGINV        /* 0xBF82224C */
  .extern U3MODE           /* 0xBF822400 */
  .extern UEFMODE          /* 0xBF822400 */
  .extern U3MODECLR        /* 0xBF822404 */
  .extern UEFMODECLR       /* 0xBF822404 */
  .extern U3MODESET        /* 0xBF822408 */
  .extern UEFMODESET       /* 0xBF822408 */
  .extern U3MODEINV        /* 0xBF82240C */
  .extern UEFMODEINV       /* 0xBF82240C */
  .extern U3STA            /* 0xBF822410 */
  .extern UEFSTA           /* 0xBF822410 */
  .extern U3STACLR         /* 0xBF822414 */
  .extern UEFSTACLR        /* 0xBF822414 */
  .extern U3STASET         /* 0xBF822418 */
  .extern UEFSTASET        /* 0xBF822418 */
  .extern U3STAINV         /* 0xBF82241C */
  .extern UEFSTAINV        /* 0xBF82241C */
  .extern U3TXREG          /* 0xBF822420 */
  .extern UEFTXREG         /* 0xBF822420 */
  .extern U3RXREG          /* 0xBF822430 */
  .extern UEFRXREG         /* 0xBF822430 */
  .extern U3BRG            /* 0xBF822440 */
  .extern UEFBRG           /* 0xBF822440 */
  .extern U3BRGCLR         /* 0xBF822444 */
  .extern UEFBRGCLR        /* 0xBF822444 */
  .extern U3BRGSET         /* 0xBF822448 */
  .extern UEFBRGSET        /* 0xBF822448 */
  .extern U3BRGINV         /* 0xBF82244C */
  .extern UEFBRGINV        /* 0xBF82244C */
  .extern U4MODE           /* 0xBF822600 */
  .extern UGHMODE          /* 0xBF822600 */
  .extern U4MODECLR        /* 0xBF822604 */
  .extern UGHMODECLR       /* 0xBF822604 */
  .extern U4MODESET        /* 0xBF822608 */
  .extern UGHMODESET       /* 0xBF822608 */
  .extern U4MODEINV        /* 0xBF82260C */
  .extern UGHMODEINV       /* 0xBF82260C */
  .extern U4STA            /* 0xBF822610 */
  .extern UGHSTA           /* 0xBF822610 */
  .extern U4STACLR         /* 0xBF822614 */
  .extern UGHSTACLR        /* 0xBF822614 */
  .extern U4STASET         /* 0xBF822618 */
  .extern UGHSTASET        /* 0xBF822618 */
  .extern U4STAINV         /* 0xBF82261C */
  .extern UGHSTAINV        /* 0xBF82261C */
  .extern U4TXREG          /* 0xBF822620 */
  .extern UGHTXREG         /* 0xBF822620 */
  .extern U4RXREG          /* 0xBF822630 */
  .extern UGHRXREG         /* 0xBF822630 */
  .extern U4BRG            /* 0xBF822640 */
  .extern UGHBRG           /* 0xBF822640 */
  .extern U4BRGCLR         /* 0xBF822644 */
  .extern UGHBRGCLR        /* 0xBF822644 */
  .extern U4BRGSET         /* 0xBF822648 */
  .extern UGHBRGSET        /* 0xBF822648 */
  .extern U4BRGINV         /* 0xBF82264C */
  .extern UGHBRGINV        /* 0xBF82264C */
  .extern U5MODE           /* 0xBF822800 */
  .extern UJKMODE          /* 0xBF822800 */
  .extern U5MODECLR        /* 0xBF822804 */
  .extern UJKMODECLR       /* 0xBF822804 */
  .extern U5MODESET        /* 0xBF822808 */
  .extern UJKMODESET       /* 0xBF822808 */
  .extern U5MODEINV        /* 0xBF82280C */
  .extern UJKMODEINV       /* 0xBF82280C */
  .extern U5STA            /* 0xBF822810 */
  .extern UJKSTA           /* 0xBF822810 */
  .extern U5STACLR         /* 0xBF822814 */
  .extern UJKSTACLR        /* 0xBF822814 */
  .extern U5STASET         /* 0xBF822818 */
  .extern UJKSTASET        /* 0xBF822818 */
  .extern U5STAINV         /* 0xBF82281C */
  .extern UJKSTAINV        /* 0xBF82281C */
  .extern U5TXREG          /* 0xBF822820 */
  .extern UJKTXREG         /* 0xBF822820 */
  .extern U5RXREG          /* 0xBF822830 */
  .extern UJKRXREG         /* 0xBF822830 */
  .extern U5BRG            /* 0xBF822840 */
  .extern UJKBRG           /* 0xBF822840 */
  .extern U5BRGCLR         /* 0xBF822844 */
  .extern UJKBRGCLR        /* 0xBF822844 */
  .extern U5BRGSET         /* 0xBF822848 */
  .extern UJKBRGSET        /* 0xBF822848 */
  .extern U5BRGINV         /* 0xBF82284C */
  .extern UJKBRGINV        /* 0xBF82284C */
  .extern U6MODE           /* 0xBF822A00 */
  .extern ULMMODE          /* 0xBF822A00 */
  .extern U6MODECLR        /* 0xBF822A04 */
  .extern ULMMODECLR       /* 0xBF822A04 */
  .extern U6MODESET        /* 0xBF822A08 */
  .extern ULMMODESET       /* 0xBF822A08 */
  .extern U6MODEINV        /* 0xBF822A0C */
  .extern ULMMODEINV       /* 0xBF822A0C */
  .extern U6STA            /* 0xBF822A10 */
  .extern ULMSTA           /* 0xBF822A10 */
  .extern U6STACLR         /* 0xBF822A14 */
  .extern ULMSTACLR        /* 0xBF822A14 */
  .extern U6STASET         /* 0xBF822A18 */
  .extern ULMSTASET        /* 0xBF822A18 */
  .extern U6STAINV         /* 0xBF822A1C */
  .extern ULMSTAINV        /* 0xBF822A1C */
  .extern U6TXREG          /* 0xBF822A20 */
  .extern ULMTXREG         /* 0xBF822A20 */
  .extern U6RXREG          /* 0xBF822A30 */
  .extern ULMRXREG         /* 0xBF822A30 */
  .extern U6BRG            /* 0xBF822A40 */
  .extern ULMBRG           /* 0xBF822A40 */
  .extern U6BRGCLR         /* 0xBF822A44 */
  .extern ULMBRGCLR        /* 0xBF822A44 */
  .extern U6BRGSET         /* 0xBF822A48 */
  .extern ULMBRGSET        /* 0xBF822A48 */
  .extern U6BRGINV         /* 0xBF822A4C */
  .extern ULMBRGINV        /* 0xBF822A4C */
  .extern PMCON            /* 0xBF82E000 */
  .extern PMCONCLR         /* 0xBF82E004 */
  .extern PMCONSET         /* 0xBF82E008 */
  .extern PMCONINV         /* 0xBF82E00C */
  .extern PMMODE           /* 0xBF82E010 */
  .extern PMMODECLR        /* 0xBF82E014 */
  .extern PMMODESET        /* 0xBF82E018 */
  .extern PMMODEINV        /* 0xBF82E01C */
  .extern PMADDR           /* 0xBF82E020 */
  .extern PMADDRCLR        /* 0xBF82E024 */
  .extern PMADDRSET        /* 0xBF82E028 */
  .extern PMADDRINV        /* 0xBF82E02C */
  .extern PMDOUT           /* 0xBF82E030 */
  .extern PMDOUTCLR        /* 0xBF82E034 */
  .extern PMDOUTSET        /* 0xBF82E038 */
  .extern PMDOUTINV        /* 0xBF82E03C */
  .extern PMDIN            /* 0xBF82E040 */
  .extern PMDINCLR         /* 0xBF82E044 */
  .extern PMDINSET         /* 0xBF82E048 */
  .extern PMDININV         /* 0xBF82E04C */
  .extern PMAEN            /* 0xBF82E050 */
  .extern PMAENCLR         /* 0xBF82E054 */
  .extern PMAENSET         /* 0xBF82E058 */
  .extern PMAENINV         /* 0xBF82E05C */
  .extern PMSTAT           /* 0xBF82E060 */
  .extern PMSTATCLR        /* 0xBF82E064 */
  .extern PMSTATSET        /* 0xBF82E068 */
  .extern PMSTATINV        /* 0xBF82E06C */
  .extern T1CON            /* 0xBF840000 */
  .extern T1CONCLR         /* 0xBF840004 */
  .extern T1CONSET         /* 0xBF840008 */
  .extern T1CONINV         /* 0xBF84000C */
  .extern TMR1             /* 0xBF840010 */
  .extern TMR1CLR          /* 0xBF840014 */
  .extern TMR1SET          /* 0xBF840018 */
  .extern TMR1INV          /* 0xBF84001C */
  .extern PR1              /* 0xBF840020 */
  .extern PR1CLR           /* 0xBF840024 */
  .extern PR1SET           /* 0xBF840028 */
  .extern PR1INV           /* 0xBF84002C */
  .extern T2CON            /* 0xBF840200 */
  .extern T2CONCLR         /* 0xBF840204 */
  .extern T2CONSET         /* 0xBF840208 */
  .extern T2CONINV         /* 0xBF84020C */
  .extern TMR2             /* 0xBF840210 */
  .extern TMR2CLR          /* 0xBF840214 */
  .extern TMR2SET          /* 0xBF840218 */
  .extern TMR2INV          /* 0xBF84021C */
  .extern PR2              /* 0xBF840220 */
  .extern PR2CLR           /* 0xBF840224 */
  .extern PR2SET           /* 0xBF840228 */
  .extern PR2INV           /* 0xBF84022C */
  .extern T3CON            /* 0xBF840400 */
  .extern T3CONCLR         /* 0xBF840404 */
  .extern T3CONSET         /* 0xBF840408 */
  .extern T3CONINV         /* 0xBF84040C */
  .extern TMR3             /* 0xBF840410 */
  .extern TMR3CLR          /* 0xBF840414 */
  .extern TMR3SET          /* 0xBF840418 */
  .extern TMR3INV          /* 0xBF84041C */
  .extern PR3              /* 0xBF840420 */
  .extern PR3CLR           /* 0xBF840424 */
  .extern PR3SET           /* 0xBF840428 */
  .extern PR3INV           /* 0xBF84042C */
  .extern T4CON            /* 0xBF840600 */
  .extern T4CONCLR         /* 0xBF840604 */
  .extern T4CONSET         /* 0xBF840608 */
  .extern T4CONINV         /* 0xBF84060C */
  .extern TMR4             /* 0xBF840610 */
  .extern TMR4CLR          /* 0xBF840614 */
  .extern TMR4SET          /* 0xBF840618 */
  .extern TMR4INV          /* 0xBF84061C */
  .extern PR4              /* 0xBF840620 */
  .extern PR4CLR           /* 0xBF840624 */
  .extern PR4SET           /* 0xBF840628 */
  .extern PR4INV           /* 0xBF84062C */
  .extern T5CON            /* 0xBF840800 */
  .extern T5CONCLR         /* 0xBF840804 */
  .extern T5CONSET         /* 0xBF840808 */
  .extern T5CONINV         /* 0xBF84080C */
  .extern TMR5             /* 0xBF840810 */
  .extern TMR5CLR          /* 0xBF840814 */
  .extern TMR5SET          /* 0xBF840818 */
  .extern TMR5INV          /* 0xBF84081C */
  .extern PR5              /* 0xBF840820 */
  .extern PR5CLR           /* 0xBF840824 */
  .extern PR5SET           /* 0xBF840828 */
  .extern PR5INV           /* 0xBF84082C */
  .extern T6CON            /* 0xBF840A00 */
  .extern T6CONCLR         /* 0xBF840A04 */
  .extern T6CONSET         /* 0xBF840A08 */
  .extern T6CONINV         /* 0xBF840A0C */
  .extern TMR6             /* 0xBF840A10 */
  .extern TMR6CLR          /* 0xBF840A14 */
  .extern TMR6SET          /* 0xBF840A18 */
  .extern TMR6INV          /* 0xBF840A1C */
  .extern PR6              /* 0xBF840A20 */
  .extern PR6CLR           /* 0xBF840A24 */
  .extern PR6SET           /* 0xBF840A28 */
  .extern PR6INV           /* 0xBF840A2C */
  .extern T7CON            /* 0xBF840C00 */
  .extern T7CONCLR         /* 0xBF840C04 */
  .extern T7CONSET         /* 0xBF840C08 */
  .extern T7CONINV         /* 0xBF840C0C */
  .extern TMR7             /* 0xBF840C10 */
  .extern TMR7CLR          /* 0xBF840C14 */
  .extern TMR7SET          /* 0xBF840C18 */
  .extern TMR7INV          /* 0xBF840C1C */
  .extern PR7              /* 0xBF840C20 */
  .extern PR7CLR           /* 0xBF840C24 */
  .extern PR7SET           /* 0xBF840C28 */
  .extern PR7INV           /* 0xBF840C2C */
  .extern T8CON            /* 0xBF840E00 */
  .extern T8CONCLR         /* 0xBF840E04 */
  .extern T8CONSET         /* 0xBF840E08 */
  .extern T8CONINV         /* 0xBF840E0C */
  .extern TMR8             /* 0xBF840E10 */
  .extern TMR8CLR          /* 0xBF840E14 */
  .extern TMR8SET          /* 0xBF840E18 */
  .extern TMR8INV          /* 0xBF840E1C */
  .extern PR8              /* 0xBF840E20 */
  .extern PR8CLR           /* 0xBF840E24 */
  .extern PR8SET           /* 0xBF840E28 */
  .extern PR8INV           /* 0xBF840E2C */
  .extern T9CON            /* 0xBF841000 */
  .extern T9CONCLR         /* 0xBF841004 */
  .extern T9CONSET         /* 0xBF841008 */
  .extern T9CONINV         /* 0xBF84100C */
  .extern TMR9             /* 0xBF841010 */
  .extern TMR9CLR          /* 0xBF841014 */
  .extern TMR9SET          /* 0xBF841018 */
  .extern TMR9INV          /* 0xBF84101C */
  .extern PR9              /* 0xBF841020 */
  .extern PR9CLR           /* 0xBF841024 */
  .extern PR9SET           /* 0xBF841028 */
  .extern PR9INV           /* 0xBF84102C */
  .extern IC1CON           /* 0xBF842000 */
  .extern IC1CONCLR        /* 0xBF842004 */
  .extern IC1CONSET        /* 0xBF842008 */
  .extern IC1CONINV        /* 0xBF84200C */
  .extern IC1BUF           /* 0xBF842010 */
  .extern IC2CON           /* 0xBF842200 */
  .extern IC2CONCLR        /* 0xBF842204 */
  .extern IC2CONSET        /* 0xBF842208 */
  .extern IC2CONINV        /* 0xBF84220C */
  .extern IC2BUF           /* 0xBF842210 */
  .extern IC3CON           /* 0xBF842400 */
  .extern IC3CONCLR        /* 0xBF842404 */
  .extern IC3CONSET        /* 0xBF842408 */
  .extern IC3CONINV        /* 0xBF84240C */
  .extern IC3BUF           /* 0xBF842410 */
  .extern IC4CON           /* 0xBF842600 */
  .extern IC4CONCLR        /* 0xBF842604 */
  .extern IC4CONSET        /* 0xBF842608 */
  .extern IC4CONINV        /* 0xBF84260C */
  .extern IC4BUF           /* 0xBF842610 */
  .extern IC5CON           /* 0xBF842800 */
  .extern IC5CONCLR        /* 0xBF842804 */
  .extern IC5CONSET        /* 0xBF842808 */
  .extern IC5CONINV        /* 0xBF84280C */
  .extern IC5BUF           /* 0xBF842810 */
  .extern IC6CON           /* 0xBF842A00 */
  .extern IC6CONCLR        /* 0xBF842A04 */
  .extern IC6CONSET        /* 0xBF842A08 */
  .extern IC6CONINV        /* 0xBF842A0C */
  .extern IC6BUF           /* 0xBF842A10 */
  .extern IC7CON           /* 0xBF842C00 */
  .extern IC7CONCLR        /* 0xBF842C04 */
  .extern IC7CONSET        /* 0xBF842C08 */
  .extern IC7CONINV        /* 0xBF842C0C */
  .extern IC7BUF           /* 0xBF842C10 */
  .extern IC8CON           /* 0xBF842E00 */
  .extern IC8CONCLR        /* 0xBF842E04 */
  .extern IC8CONSET        /* 0xBF842E08 */
  .extern IC8CONINV        /* 0xBF842E0C */
  .extern IC8BUF           /* 0xBF842E10 */
  .extern IC9CON           /* 0xBF843000 */
  .extern IC9CONCLR        /* 0xBF843004 */
  .extern IC9CONSET        /* 0xBF843008 */
  .extern IC9CONINV        /* 0xBF84300C */
  .extern IC9BUF           /* 0xBF843010 */
  .extern OC1CON           /* 0xBF844000 */
  .extern OC1CONCLR        /* 0xBF844004 */
  .extern OC1CONSET        /* 0xBF844008 */
  .extern OC1CONINV        /* 0xBF84400C */
  .extern OC1R             /* 0xBF844010 */
  .extern OC1RCLR          /* 0xBF844014 */
  .extern OC1RSET          /* 0xBF844018 */
  .extern OC1RINV          /* 0xBF84401C */
  .extern OC1RS            /* 0xBF844020 */
  .extern OC1RSCLR         /* 0xBF844024 */
  .extern OC1RSSET         /* 0xBF844028 */
  .extern OC1RSINV         /* 0xBF84402C */
  .extern OC2CON           /* 0xBF844200 */
  .extern OC2CONCLR        /* 0xBF844204 */
  .extern OC2CONSET        /* 0xBF844208 */
  .extern OC2CONINV        /* 0xBF84420C */
  .extern OC2R             /* 0xBF844210 */
  .extern OC2RCLR          /* 0xBF844214 */
  .extern OC2RSET          /* 0xBF844218 */
  .extern OC2RINV          /* 0xBF84421C */
  .extern OC2RS            /* 0xBF844220 */
  .extern OC2RSCLR         /* 0xBF844224 */
  .extern OC2RSSET         /* 0xBF844228 */
  .extern OC2RSINV         /* 0xBF84422C */
  .extern OC3CON           /* 0xBF844400 */
  .extern OC3CONCLR        /* 0xBF844404 */
  .extern OC3CONSET        /* 0xBF844408 */
  .extern OC3CONINV        /* 0xBF84440C */
  .extern OC3R             /* 0xBF844410 */
  .extern OC3RCLR          /* 0xBF844414 */
  .extern OC3RSET          /* 0xBF844418 */
  .extern OC3RINV          /* 0xBF84441C */
  .extern OC3RS            /* 0xBF844420 */
  .extern OC3RSCLR         /* 0xBF844424 */
  .extern OC3RSSET         /* 0xBF844428 */
  .extern OC3RSINV         /* 0xBF84442C */
  .extern OC4CON           /* 0xBF844600 */
  .extern OC4CONCLR        /* 0xBF844604 */
  .extern OC4CONSET        /* 0xBF844608 */
  .extern OC4CONINV        /* 0xBF84460C */
  .extern OC4R             /* 0xBF844610 */
  .extern OC4RCLR          /* 0xBF844614 */
  .extern OC4RSET          /* 0xBF844618 */
  .extern OC4RINV          /* 0xBF84461C */
  .extern OC4RS            /* 0xBF844620 */
  .extern OC4RSCLR         /* 0xBF844624 */
  .extern OC4RSSET         /* 0xBF844628 */
  .extern OC4RSINV         /* 0xBF84462C */
  .extern OC5CON           /* 0xBF844800 */
  .extern OC5CONCLR        /* 0xBF844804 */
  .extern OC5CONSET        /* 0xBF844808 */
  .extern OC5CONINV        /* 0xBF84480C */
  .extern OC5R             /* 0xBF844810 */
  .extern OC5RCLR          /* 0xBF844814 */
  .extern OC5RSET          /* 0xBF844818 */
  .extern OC5RINV          /* 0xBF84481C */
  .extern OC5RS            /* 0xBF844820 */
  .extern OC5RSCLR         /* 0xBF844824 */
  .extern OC5RSSET         /* 0xBF844828 */
  .extern OC5RSINV         /* 0xBF84482C */
  .extern OC6CON           /* 0xBF844A00 */
  .extern OC6CONCLR        /* 0xBF844A04 */
  .extern OC6CONSET        /* 0xBF844A08 */
  .extern OC6CONINV        /* 0xBF844A0C */
  .extern OC6R             /* 0xBF844A10 */
  .extern OC6RCLR          /* 0xBF844A14 */
  .extern OC6RSET          /* 0xBF844A18 */
  .extern OC6RINV          /* 0xBF844A1C */
  .extern OC6RS            /* 0xBF844A20 */
  .extern OC6RSCLR         /* 0xBF844A24 */
  .extern OC6RSSET         /* 0xBF844A28 */
  .extern OC6RSINV         /* 0xBF844A2C */
  .extern OC7CON           /* 0xBF844C00 */
  .extern OC7CONCLR        /* 0xBF844C04 */
  .extern OC7CONSET        /* 0xBF844C08 */
  .extern OC7CONINV        /* 0xBF844C0C */
  .extern OC7R             /* 0xBF844C10 */
  .extern OC7RCLR          /* 0xBF844C14 */
  .extern OC7RSET          /* 0xBF844C18 */
  .extern OC7RINV          /* 0xBF844C1C */
  .extern OC7RS            /* 0xBF844C20 */
  .extern OC7RSCLR         /* 0xBF844C24 */
  .extern OC7RSSET         /* 0xBF844C28 */
  .extern OC7RSINV         /* 0xBF844C2C */
  .extern OC8CON           /* 0xBF844E00 */
  .extern OC8CONCLR        /* 0xBF844E04 */
  .extern OC8CONSET        /* 0xBF844E08 */
  .extern OC8CONINV        /* 0xBF844E0C */
  .extern OC8R             /* 0xBF844E10 */
  .extern OC8RCLR          /* 0xBF844E14 */
  .extern OC8RSET          /* 0xBF844E18 */
  .extern OC8RINV          /* 0xBF844E1C */
  .extern OC8RS            /* 0xBF844E20 */
  .extern OC8RSCLR         /* 0xBF844E24 */
  .extern OC8RSSET         /* 0xBF844E28 */
  .extern OC8RSINV         /* 0xBF844E2C */
  .extern OC9CON           /* 0xBF845000 */
  .extern OC9CONCLR        /* 0xBF845004 */
  .extern OC9CONSET        /* 0xBF845008 */
  .extern OC9CONINV        /* 0xBF84500C */
  .extern OC9R             /* 0xBF845010 */
  .extern OC9RCLR          /* 0xBF845014 */
  .extern OC9RSET          /* 0xBF845018 */
  .extern OC9RINV          /* 0xBF84501C */
  .extern OC9RS            /* 0xBF845020 */
  .extern OC9RSCLR         /* 0xBF845024 */
  .extern OC9RSSET         /* 0xBF845028 */
  .extern OC9RSINV         /* 0xBF84502C */
  .extern AD1CON1          /* 0xBF84B000 */
  .extern AD1CON2          /* 0xBF84B004 */
  .extern AD1CON3          /* 0xBF84B008 */
  .extern AD1IMOD          /* 0xBF84B00C */
  .extern AD1GIRQEN1       /* 0xBF84B010 */
  .extern AD1GIRQEN2       /* 0xBF84B014 */
  .extern AD1CSS1          /* 0xBF84B018 */
  .extern AD1CSS2          /* 0xBF84B01C */
  .extern AD1DSTAT1        /* 0xBF84B020 */
  .extern AD1DSTAT2        /* 0xBF84B024 */
  .extern AD1CMPEN1        /* 0xBF84B028 */
  .extern AD1CMP1          /* 0xBF84B02C */
  .extern AD1CMPEN2        /* 0xBF84B030 */
  .extern AD1CMP2          /* 0xBF84B034 */
  .extern AD1CMPEN3        /* 0xBF84B038 */
  .extern AD1CMP3          /* 0xBF84B03C */
  .extern AD1CMPEN4        /* 0xBF84B040 */
  .extern AD1CMP4          /* 0xBF84B044 */
  .extern AD1CMPEN5        /* 0xBF84B048 */
  .extern AD1CMP5          /* 0xBF84B04C */
  .extern AD1CMPEN6        /* 0xBF84B050 */
  .extern AD1CMP6          /* 0xBF84B054 */
  .extern AD1FLTR1         /* 0xBF84B058 */
  .extern AD1FLTR2         /* 0xBF84B05C */
  .extern AD1FLTR3         /* 0xBF84B060 */
  .extern AD1FLTR4         /* 0xBF84B064 */
  .extern AD1FLTR5         /* 0xBF84B068 */
  .extern AD1FLTR6         /* 0xBF84B06C */
  .extern AD1TRG1          /* 0xBF84B070 */
  .extern AD1TRG2          /* 0xBF84B074 */
  .extern AD1TRG3          /* 0xBF84B078 */
  .extern AD1CMPCON1       /* 0xBF84B090 */
  .extern AD1CMPCON2       /* 0xBF84B094 */
  .extern AD1CMPCON3       /* 0xBF84B098 */
  .extern AD1CMPCON4       /* 0xBF84B09C */
  .extern AD1CMPCON5       /* 0xBF84B0A0 */
  .extern AD1CMPCON6       /* 0xBF84B0A4 */
  .extern AD1DATA0         /* 0xBF84B0B8 */
  .extern AD1DATA1         /* 0xBF84B0BC */
  .extern AD1DATA2         /* 0xBF84B0C0 */
  .extern AD1DATA3         /* 0xBF84B0C4 */
  .extern AD1DATA4         /* 0xBF84B0C8 */
  .extern AD1DATA5         /* 0xBF84B0CC */
  .extern AD1DATA6         /* 0xBF84B0D0 */
  .extern AD1DATA7         /* 0xBF84B0D4 */
  .extern AD1DATA8         /* 0xBF84B0D8 */
  .extern AD1DATA9         /* 0xBF84B0DC */
  .extern AD1DATA10        /* 0xBF84B0E0 */
  .extern AD1DATA11        /* 0xBF84B0E4 */
  .extern AD1DATA12        /* 0xBF84B0E8 */
  .extern AD1DATA13        /* 0xBF84B0EC */
  .extern AD1DATA14        /* 0xBF84B0F0 */
  .extern AD1DATA15        /* 0xBF84B0F4 */
  .extern AD1DATA16        /* 0xBF84B0F8 */
  .extern AD1DATA17        /* 0xBF84B0FC */
  .extern AD1DATA18        /* 0xBF84B100 */
  .extern AD1DATA19        /* 0xBF84B104 */
  .extern AD1DATA20        /* 0xBF84B108 */
  .extern AD1DATA21        /* 0xBF84B10C */
  .extern AD1DATA22        /* 0xBF84B110 */
  .extern AD1DATA23        /* 0xBF84B114 */
  .extern AD1DATA24        /* 0xBF84B118 */
  .extern AD1DATA25        /* 0xBF84B11C */
  .extern AD1DATA26        /* 0xBF84B120 */
  .extern AD1DATA27        /* 0xBF84B124 */
  .extern AD1DATA28        /* 0xBF84B128 */
  .extern AD1DATA29        /* 0xBF84B12C */
  .extern AD1DATA30        /* 0xBF84B130 */
  .extern AD1DATA31        /* 0xBF84B134 */
  .extern AD1DATA32        /* 0xBF84B138 */
  .extern AD1DATA33        /* 0xBF84B13C */
  .extern AD1DATA34        /* 0xBF84B140 */
  .extern AD1DATA35        /* 0xBF84B144 */
  .extern AD1DATA36        /* 0xBF84B148 */
  .extern AD1DATA37        /* 0xBF84B14C */
  .extern AD1DATA38        /* 0xBF84B150 */
  .extern AD1DATA39        /* 0xBF84B154 */
  .extern AD1DATA40        /* 0xBF84B158 */
  .extern AD1DATA41        /* 0xBF84B15C */
  .extern AD1DATA42        /* 0xBF84B160 */
  .extern AD1DATA43        /* 0xBF84B164 */
  .extern AD1DATA44        /* 0xBF84B168 */
  .extern AD1CAL1          /* 0xBF84B200 */
  .extern AD1CAL2          /* 0xBF84B204 */
  .extern AD1CAL3          /* 0xBF84B208 */
  .extern AD1CAL4          /* 0xBF84B20C */
  .extern AD1CAL5          /* 0xBF84B210 */
  .extern CM1CON           /* 0xBF84C000 */
  .extern CM1CONCLR        /* 0xBF84C004 */
  .extern CM1CONSET        /* 0xBF84C008 */
  .extern CM1CONINV        /* 0xBF84C00C */
  .extern CM2CON           /* 0xBF84C010 */
  .extern CM2CONCLR        /* 0xBF84C014 */
  .extern CM2CONSET        /* 0xBF84C018 */
  .extern CM2CONINV        /* 0xBF84C01C */
  .extern CMSTAT           /* 0xBF84C060 */
  .extern CMSTATCLR        /* 0xBF84C064 */
  .extern CMSTATSET        /* 0xBF84C068 */
  .extern CMSTATINV        /* 0xBF84C06C */
  .extern ANSELA           /* 0xBF860000 */
  .extern ANSELACLR        /* 0xBF860004 */
  .extern ANSELASET        /* 0xBF860008 */
  .extern ANSELAINV        /* 0xBF86000C */
  .extern TRISA            /* 0xBF860010 */
  .extern TRISACLR         /* 0xBF860014 */
  .extern TRISASET         /* 0xBF860018 */
  .extern TRISAINV         /* 0xBF86001C */
  .extern PORTA            /* 0xBF860020 */
  .extern PORTACLR         /* 0xBF860024 */
  .extern PORTASET         /* 0xBF860028 */
  .extern PORTAINV         /* 0xBF86002C */
  .extern LATA             /* 0xBF860030 */
  .extern LATACLR          /* 0xBF860034 */
  .extern LATASET          /* 0xBF860038 */
  .extern LATAINV          /* 0xBF86003C */
  .extern ODCA             /* 0xBF860040 */
  .extern ODCACLR          /* 0xBF860044 */
  .extern ODCASET          /* 0xBF860048 */
  .extern ODCAINV          /* 0xBF86004C */
  .extern CNPUA            /* 0xBF860050 */
  .extern CNPUACLR         /* 0xBF860054 */
  .extern CNPUASET         /* 0xBF860058 */
  .extern CNPUAINV         /* 0xBF86005C */
  .extern CNPDA            /* 0xBF860060 */
  .extern CNPDACLR         /* 0xBF860064 */
  .extern CNPDASET         /* 0xBF860068 */
  .extern CNPDAINV         /* 0xBF86006C */
  .extern CNCONA           /* 0xBF860070 */
  .extern CNCONACLR        /* 0xBF860074 */
  .extern CNCONASET        /* 0xBF860078 */
  .extern CNCONAINV        /* 0xBF86007C */
  .extern CNENA            /* 0xBF860080 */
  .extern CNENACLR         /* 0xBF860084 */
  .extern CNENASET         /* 0xBF860088 */
  .extern CNENAINV         /* 0xBF86008C */
  .extern CNSTATA          /* 0xBF860090 */
  .extern CNSTATACLR       /* 0xBF860094 */
  .extern CNSTATASET       /* 0xBF860098 */
  .extern CNSTATAINV       /* 0xBF86009C */
  .extern ANSELB           /* 0xBF860100 */
  .extern ANSELBCLR        /* 0xBF860104 */
  .extern ANSELBSET        /* 0xBF860108 */
  .extern ANSELBINV        /* 0xBF86010C */
  .extern TRISB            /* 0xBF860110 */
  .extern TRISBCLR         /* 0xBF860114 */
  .extern TRISBSET         /* 0xBF860118 */
  .extern TRISBINV         /* 0xBF86011C */
  .extern PORTB            /* 0xBF860120 */
  .extern PORTBCLR         /* 0xBF860124 */
  .extern PORTBSET         /* 0xBF860128 */
  .extern PORTBINV         /* 0xBF86012C */
  .extern LATB             /* 0xBF860130 */
  .extern LATBCLR          /* 0xBF860134 */
  .extern LATBSET          /* 0xBF860138 */
  .extern LATBINV          /* 0xBF86013C */
  .extern ODCB             /* 0xBF860140 */
  .extern ODCBCLR          /* 0xBF860144 */
  .extern ODCBSET          /* 0xBF860148 */
  .extern ODCBINV          /* 0xBF86014C */
  .extern CNPUB            /* 0xBF860150 */
  .extern CNPUBCLR         /* 0xBF860154 */
  .extern CNPUBSET         /* 0xBF860158 */
  .extern CNPUBINV         /* 0xBF86015C */
  .extern CNPDB            /* 0xBF860160 */
  .extern CNPDBCLR         /* 0xBF860164 */
  .extern CNPDBSET         /* 0xBF860168 */
  .extern CNPDBINV         /* 0xBF86016C */
  .extern CNCONB           /* 0xBF860170 */
  .extern CNCONBCLR        /* 0xBF860174 */
  .extern CNCONBSET        /* 0xBF860178 */
  .extern CNCONBINV        /* 0xBF86017C */
  .extern CNENB            /* 0xBF860180 */
  .extern CNENBCLR         /* 0xBF860184 */
  .extern CNENBSET         /* 0xBF860188 */
  .extern CNENBINV         /* 0xBF86018C */
  .extern CNSTATB          /* 0xBF860190 */
  .extern CNSTATBCLR       /* 0xBF860194 */
  .extern CNSTATBSET       /* 0xBF860198 */
  .extern CNSTATBINV       /* 0xBF86019C */
  .extern ANSELC           /* 0xBF860200 */
  .extern ANSELCCLR        /* 0xBF860204 */
  .extern ANSELCSET        /* 0xBF860208 */
  .extern ANSELCINV        /* 0xBF86020C */
  .extern TRISC            /* 0xBF860210 */
  .extern TRISCCLR         /* 0xBF860214 */
  .extern TRISCSET         /* 0xBF860218 */
  .extern TRISCINV         /* 0xBF86021C */
  .extern PORTC            /* 0xBF860220 */
  .extern PORTCCLR         /* 0xBF860224 */
  .extern PORTCSET         /* 0xBF860228 */
  .extern PORTCINV         /* 0xBF86022C */
  .extern LATC             /* 0xBF860230 */
  .extern LATCCLR          /* 0xBF860234 */
  .extern LATCSET          /* 0xBF860238 */
  .extern LATCINV          /* 0xBF86023C */
  .extern ODCC             /* 0xBF860240 */
  .extern ODCCCLR          /* 0xBF860244 */
  .extern ODCCSET          /* 0xBF860248 */
  .extern ODCCINV          /* 0xBF86024C */
  .extern CNPUC            /* 0xBF860250 */
  .extern CNPUCCLR         /* 0xBF860254 */
  .extern CNPUCSET         /* 0xBF860258 */
  .extern CNPUCINV         /* 0xBF86025C */
  .extern CNPDC            /* 0xBF860260 */
  .extern CNPDCCLR         /* 0xBF860264 */
  .extern CNPDCSET         /* 0xBF860268 */
  .extern CNPDCINV         /* 0xBF86026C */
  .extern CNCONC           /* 0xBF860270 */
  .extern CNCONCCLR        /* 0xBF860274 */
  .extern CNCONCSET        /* 0xBF860278 */
  .extern CNCONCINV        /* 0xBF86027C */
  .extern CNENC            /* 0xBF860280 */
  .extern CNENCCLR         /* 0xBF860284 */
  .extern CNENCSET         /* 0xBF860288 */
  .extern CNENCINV         /* 0xBF86028C */
  .extern CNSTATC          /* 0xBF860290 */
  .extern CNSTATCCLR       /* 0xBF860294 */
  .extern CNSTATCSET       /* 0xBF860298 */
  .extern CNSTATCINV       /* 0xBF86029C */
  .extern ANSELD           /* 0xBF860300 */
  .extern ANSELDCLR        /* 0xBF860304 */
  .extern ANSELDSET        /* 0xBF860308 */
  .extern ANSELDINV        /* 0xBF86030C */
  .extern TRISD            /* 0xBF860310 */
  .extern TRISDCLR         /* 0xBF860314 */
  .extern TRISDSET         /* 0xBF860318 */
  .extern TRISDINV         /* 0xBF86031C */
  .extern PORTD            /* 0xBF860320 */
  .extern PORTDCLR         /* 0xBF860324 */
  .extern PORTDSET         /* 0xBF860328 */
  .extern PORTDINV         /* 0xBF86032C */
  .extern LATD             /* 0xBF860330 */
  .extern LATDCLR          /* 0xBF860334 */
  .extern LATDSET          /* 0xBF860338 */
  .extern LATDINV          /* 0xBF86033C */
  .extern ODCD             /* 0xBF860340 */
  .extern ODCDCLR          /* 0xBF860344 */
  .extern ODCDSET          /* 0xBF860348 */
  .extern ODCDINV          /* 0xBF86034C */
  .extern CNPUD            /* 0xBF860350 */
  .extern CNPUDCLR         /* 0xBF860354 */
  .extern CNPUDSET         /* 0xBF860358 */
  .extern CNPUDINV         /* 0xBF86035C */
  .extern CNPDD            /* 0xBF860360 */
  .extern CNPDDCLR         /* 0xBF860364 */
  .extern CNPDDSET         /* 0xBF860368 */
  .extern CNPDDINV         /* 0xBF86036C */
  .extern CNCOND           /* 0xBF860370 */
  .extern CNCONDCLR        /* 0xBF860374 */
  .extern CNCONDSET        /* 0xBF860378 */
  .extern CNCONDINV        /* 0xBF86037C */
  .extern CNEND            /* 0xBF860380 */
  .extern CNENDCLR         /* 0xBF860384 */
  .extern CNENDSET         /* 0xBF860388 */
  .extern CNENDINV         /* 0xBF86038C */
  .extern CNSTATD          /* 0xBF860390 */
  .extern CNSTATDCLR       /* 0xBF860394 */
  .extern CNSTATDSET       /* 0xBF860398 */
  .extern CNSTATDINV       /* 0xBF86039C */
  .extern ANSELE           /* 0xBF860400 */
  .extern ANSELECLR        /* 0xBF860404 */
  .extern ANSELESET        /* 0xBF860408 */
  .extern ANSELEINV        /* 0xBF86040C */
  .extern TRISE            /* 0xBF860410 */
  .extern TRISECLR         /* 0xBF860414 */
  .extern TRISESET         /* 0xBF860418 */
  .extern TRISEINV         /* 0xBF86041C */
  .extern PORTE            /* 0xBF860420 */
  .extern PORTECLR         /* 0xBF860424 */
  .extern PORTESET         /* 0xBF860428 */
  .extern PORTEINV         /* 0xBF86042C */
  .extern LATE             /* 0xBF860430 */
  .extern LATECLR          /* 0xBF860434 */
  .extern LATESET          /* 0xBF860438 */
  .extern LATEINV          /* 0xBF86043C */
  .extern ODCE             /* 0xBF860440 */
  .extern ODCECLR          /* 0xBF860444 */
  .extern ODCESET          /* 0xBF860448 */
  .extern ODCEINV          /* 0xBF86044C */
  .extern CNPUE            /* 0xBF860450 */
  .extern CNPUECLR         /* 0xBF860454 */
  .extern CNPUESET         /* 0xBF860458 */
  .extern CNPUEINV         /* 0xBF86045C */
  .extern CNPDE            /* 0xBF860460 */
  .extern CNPDECLR         /* 0xBF860464 */
  .extern CNPDESET         /* 0xBF860468 */
  .extern CNPDEINV         /* 0xBF86046C */
  .extern CNCONE           /* 0xBF860470 */
  .extern CNCONECLR        /* 0xBF860474 */
  .extern CNCONESET        /* 0xBF860478 */
  .extern CNCONEINV        /* 0xBF86047C */
  .extern CNENE            /* 0xBF860480 */
  .extern CNENECLR         /* 0xBF860484 */
  .extern CNENESET         /* 0xBF860488 */
  .extern CNENEINV         /* 0xBF86048C */
  .extern CNSTATE          /* 0xBF860490 */
  .extern CNSTATECLR       /* 0xBF860494 */
  .extern CNSTATESET       /* 0xBF860498 */
  .extern CNSTATEINV       /* 0xBF86049C */
  .extern ANSELF           /* 0xBF860500 */
  .extern ANSELFCLR        /* 0xBF860504 */
  .extern ANSELFSET        /* 0xBF860508 */
  .extern ANSELFINV        /* 0xBF86050C */
  .extern TRISF            /* 0xBF860510 */
  .extern TRISFCLR         /* 0xBF860514 */
  .extern TRISFSET         /* 0xBF860518 */
  .extern TRISFINV         /* 0xBF86051C */
  .extern PORTF            /* 0xBF860520 */
  .extern PORTFCLR         /* 0xBF860524 */
  .extern PORTFSET         /* 0xBF860528 */
  .extern PORTFINV         /* 0xBF86052C */
  .extern LATF             /* 0xBF860530 */
  .extern LATFCLR          /* 0xBF860534 */
  .extern LATFSET          /* 0xBF860538 */
  .extern LATFINV          /* 0xBF86053C */
  .extern ODCF             /* 0xBF860540 */
  .extern ODCFCLR          /* 0xBF860544 */
  .extern ODCFSET          /* 0xBF860548 */
  .extern ODCFINV          /* 0xBF86054C */
  .extern CNPUF            /* 0xBF860550 */
  .extern CNPUFCLR         /* 0xBF860554 */
  .extern CNPUFSET         /* 0xBF860558 */
  .extern CNPUFINV         /* 0xBF86055C */
  .extern CNPDF            /* 0xBF860560 */
  .extern CNPDFCLR         /* 0xBF860564 */
  .extern CNPDFSET         /* 0xBF860568 */
  .extern CNPDFINV         /* 0xBF86056C */
  .extern CNCONF           /* 0xBF860570 */
  .extern CNCONFCLR        /* 0xBF860574 */
  .extern CNCONFSET        /* 0xBF860578 */
  .extern CNCONFINV        /* 0xBF86057C */
  .extern CNENF            /* 0xBF860580 */
  .extern CNENFCLR         /* 0xBF860584 */
  .extern CNENFSET         /* 0xBF860588 */
  .extern CNENFINV         /* 0xBF86058C */
  .extern CNSTATF          /* 0xBF860590 */
  .extern CNSTATFCLR       /* 0xBF860594 */
  .extern CNSTATFSET       /* 0xBF860598 */
  .extern CNSTATFINV       /* 0xBF86059C */
  .extern ANSELG           /* 0xBF860600 */
  .extern ANSELGCLR        /* 0xBF860604 */
  .extern ANSELGSET        /* 0xBF860608 */
  .extern ANSELGINV        /* 0xBF86060C */
  .extern TRISG            /* 0xBF860610 */
  .extern TRISGCLR         /* 0xBF860614 */
  .extern TRISGSET         /* 0xBF860618 */
  .extern TRISGINV         /* 0xBF86061C */
  .extern PORTG            /* 0xBF860620 */
  .extern PORTGCLR         /* 0xBF860624 */
  .extern PORTGSET         /* 0xBF860628 */
  .extern PORTGINV         /* 0xBF86062C */
  .extern LATG             /* 0xBF860630 */
  .extern LATGCLR          /* 0xBF860634 */
  .extern LATGSET          /* 0xBF860638 */
  .extern LATGINV          /* 0xBF86063C */
  .extern ODCG             /* 0xBF860640 */
  .extern ODCGCLR          /* 0xBF860644 */
  .extern ODCGSET          /* 0xBF860648 */
  .extern ODCGINV          /* 0xBF86064C */
  .extern CNPUG            /* 0xBF860650 */
  .extern CNPUGCLR         /* 0xBF860654 */
  .extern CNPUGSET         /* 0xBF860658 */
  .extern CNPUGINV         /* 0xBF86065C */
  .extern CNPDG            /* 0xBF860660 */
  .extern CNPDGCLR         /* 0xBF860664 */
  .extern CNPDGSET         /* 0xBF860668 */
  .extern CNPDGINV         /* 0xBF86066C */
  .extern CNCONG           /* 0xBF860670 */
  .extern CNCONGCLR        /* 0xBF860674 */
  .extern CNCONGSET        /* 0xBF860678 */
  .extern CNCONGINV        /* 0xBF86067C */
  .extern CNENG            /* 0xBF860680 */
  .extern CNENGCLR         /* 0xBF860684 */
  .extern CNENGSET         /* 0xBF860688 */
  .extern CNENGINV         /* 0xBF86068C */
  .extern CNSTATG          /* 0xBF860690 */
  .extern CNSTATGCLR       /* 0xBF860694 */
  .extern CNSTATGSET       /* 0xBF860698 */
  .extern CNSTATGINV       /* 0xBF86069C */
  .extern ANSELH           /* 0xBF860700 */
  .extern ANSELHCLR        /* 0xBF860704 */
  .extern ANSELHSET        /* 0xBF860708 */
  .extern ANSELHINV        /* 0xBF86070C */
  .extern TRISH            /* 0xBF860710 */
  .extern TRISHCLR         /* 0xBF860714 */
  .extern TRISHSET         /* 0xBF860718 */
  .extern TRISHINV         /* 0xBF86071C */
  .extern PORTH            /* 0xBF860720 */
  .extern PORTHCLR         /* 0xBF860724 */
  .extern PORTHSET         /* 0xBF860728 */
  .extern PORTHINV         /* 0xBF86072C */
  .extern LATH             /* 0xBF860730 */
  .extern LATHCLR          /* 0xBF860734 */
  .extern LATHSET          /* 0xBF860738 */
  .extern LATHINV          /* 0xBF86073C */
  .extern ODCH             /* 0xBF860740 */
  .extern ODCHCLR          /* 0xBF860744 */
  .extern ODCHSET          /* 0xBF860748 */
  .extern ODCHINV          /* 0xBF86074C */
  .extern CNPUH            /* 0xBF860750 */
  .extern CNPUHCLR         /* 0xBF860754 */
  .extern CNPUHSET         /* 0xBF860758 */
  .extern CNPUHINV         /* 0xBF86075C */
  .extern CNPDH            /* 0xBF860760 */
  .extern CNPDHCLR         /* 0xBF860764 */
  .extern CNPDHSET         /* 0xBF860768 */
  .extern CNPDHINV         /* 0xBF86076C */
  .extern CNCONH           /* 0xBF860770 */
  .extern CNCONHCLR        /* 0xBF860774 */
  .extern CNCONHSET        /* 0xBF860778 */
  .extern CNCONHINV        /* 0xBF86077C */
  .extern CNENH            /* 0xBF860780 */
  .extern CNENHCLR         /* 0xBF860784 */
  .extern CNENHSET         /* 0xBF860788 */
  .extern CNENHINV         /* 0xBF86078C */
  .extern CNSTATH          /* 0xBF860790 */
  .extern CNSTATHCLR       /* 0xBF860794 */
  .extern CNSTATHSET       /* 0xBF860798 */
  .extern CNSTATHINV       /* 0xBF86079C */
  .extern ANSELJ           /* 0xBF860800 */
  .extern ANSELJCLR        /* 0xBF860804 */
  .extern ANSELJSET        /* 0xBF860808 */
  .extern ANSELJINV        /* 0xBF86080C */
  .extern TRISJ            /* 0xBF860810 */
  .extern TRISJCLR         /* 0xBF860814 */
  .extern TRISJSET         /* 0xBF860818 */
  .extern TRISJINV         /* 0xBF86081C */
  .extern PORTJ            /* 0xBF860820 */
  .extern PORTJCLR         /* 0xBF860824 */
  .extern PORTJSET         /* 0xBF860828 */
  .extern PORTJINV         /* 0xBF86082C */
  .extern LATJ             /* 0xBF860830 */
  .extern LATJCLR          /* 0xBF860834 */
  .extern LATJSET          /* 0xBF860838 */
  .extern LATJINV          /* 0xBF86083C */
  .extern ODCJ             /* 0xBF860840 */
  .extern ODCJCLR          /* 0xBF860844 */
  .extern ODCJSET          /* 0xBF860848 */
  .extern ODCJINV          /* 0xBF86084C */
  .extern CNPUJ            /* 0xBF860850 */
  .extern CNPUJCLR         /* 0xBF860854 */
  .extern CNPUJSET         /* 0xBF860858 */
  .extern CNPUJINV         /* 0xBF86085C */
  .extern CNPDJ            /* 0xBF860860 */
  .extern CNPDJCLR         /* 0xBF860864 */
  .extern CNPDJSET         /* 0xBF860868 */
  .extern CNPDJINV         /* 0xBF86086C */
  .extern CNCONJ           /* 0xBF860870 */
  .extern CNCONJCLR        /* 0xBF860874 */
  .extern CNCONJSET        /* 0xBF860878 */
  .extern CNCONJINV        /* 0xBF86087C */
  .extern CNENJ            /* 0xBF860880 */
  .extern CNENJCLR         /* 0xBF860884 */
  .extern CNENJSET         /* 0xBF860888 */
  .extern CNENJINV         /* 0xBF86088C */
  .extern CNSTATJ          /* 0xBF860890 */
  .extern CNSTATJCLR       /* 0xBF860894 */
  .extern CNSTATJSET       /* 0xBF860898 */
  .extern CNSTATJINV       /* 0xBF86089C */
  .extern ANSELK           /* 0xBF860900 */
  .extern ANSELKCLR        /* 0xBF860904 */
  .extern ANSELKSET        /* 0xBF860908 */
  .extern ANSELKINV        /* 0xBF86090C */
  .extern TRISK            /* 0xBF860910 */
  .extern TRISKCLR         /* 0xBF860914 */
  .extern TRISKSET         /* 0xBF860918 */
  .extern TRISKINV         /* 0xBF86091C */
  .extern PORTK            /* 0xBF860920 */
  .extern PORTKCLR         /* 0xBF860924 */
  .extern PORTKSET         /* 0xBF860928 */
  .extern PORTKINV         /* 0xBF86092C */
  .extern LATK             /* 0xBF860930 */
  .extern LATKCLR          /* 0xBF860934 */
  .extern LATKSET          /* 0xBF860938 */
  .extern LATKINV          /* 0xBF86093C */
  .extern ODCK             /* 0xBF860940 */
  .extern ODCKCLR          /* 0xBF860944 */
  .extern ODCKSET          /* 0xBF860948 */
  .extern ODCKINV          /* 0xBF86094C */
  .extern CNPUK            /* 0xBF860950 */
  .extern CNPUKCLR         /* 0xBF860954 */
  .extern CNPUKSET         /* 0xBF860958 */
  .extern CNPUKINV         /* 0xBF86095C */
  .extern CNPDK            /* 0xBF860960 */
  .extern CNPDKCLR         /* 0xBF860964 */
  .extern CNPDKSET         /* 0xBF860968 */
  .extern CNPDKINV         /* 0xBF86096C */
  .extern CNCONK           /* 0xBF860970 */
  .extern CNCONKCLR        /* 0xBF860974 */
  .extern CNCONKSET        /* 0xBF860978 */
  .extern CNCONKINV        /* 0xBF86097C */
  .extern CNENK            /* 0xBF860980 */
  .extern CNENKCLR         /* 0xBF860984 */
  .extern CNENKSET         /* 0xBF860988 */
  .extern CNENKINV         /* 0xBF86098C */
  .extern CNSTATK          /* 0xBF860990 */
  .extern CNSTATKCLR       /* 0xBF860994 */
  .extern CNSTATKSET       /* 0xBF860998 */
  .extern CNSTATKINV       /* 0xBF86099C */
  .extern C1CON            /* 0xBF880000 */
  .extern C1CONCLR         /* 0xBF880004 */
  .extern C1CONSET         /* 0xBF880008 */
  .extern C1CONINV         /* 0xBF88000C */
  .extern C1CFG            /* 0xBF880010 */
  .extern C1CFGCLR         /* 0xBF880014 */
  .extern C1CFGSET         /* 0xBF880018 */
  .extern C1CFGINV         /* 0xBF88001C */
  .extern C1INT            /* 0xBF880020 */
  .extern C1INTCLR         /* 0xBF880024 */
  .extern C1INTSET         /* 0xBF880028 */
  .extern C1INTINV         /* 0xBF88002C */
  .extern C1VEC            /* 0xBF880030 */
  .extern C1VECCLR         /* 0xBF880034 */
  .extern C1VECSET         /* 0xBF880038 */
  .extern C1VECINV         /* 0xBF88003C */
  .extern C1TREC           /* 0xBF880040 */
  .extern C1TRECCLR        /* 0xBF880044 */
  .extern C1TRECSET        /* 0xBF880048 */
  .extern C1TRECINV        /* 0xBF88004C */
  .extern C1FSTAT          /* 0xBF880050 */
  .extern C1FSTATCLR       /* 0xBF880054 */
  .extern C1FSTATSET       /* 0xBF880058 */
  .extern C1FSTATINV       /* 0xBF88005C */
  .extern C1RXOVF          /* 0xBF880060 */
  .extern C1RXOVFCLR       /* 0xBF880064 */
  .extern C1RXOVFSET       /* 0xBF880068 */
  .extern C1RXOVFINV       /* 0xBF88006C */
  .extern C1TMR            /* 0xBF880070 */
  .extern C1TMRCLR         /* 0xBF880074 */
  .extern C1TMRSET         /* 0xBF880078 */
  .extern C1TMRINV         /* 0xBF88007C */
  .extern C1RXM0           /* 0xBF880080 */
  .extern C1RXM0CLR        /* 0xBF880084 */
  .extern C1RXM0SET        /* 0xBF880088 */
  .extern C1RXM0INV        /* 0xBF88008C */
  .extern C1RXM1           /* 0xBF880090 */
  .extern C1RXM1CLR        /* 0xBF880094 */
  .extern C1RXM1SET        /* 0xBF880098 */
  .extern C1RXM1INV        /* 0xBF88009C */
  .extern C1RXM2           /* 0xBF8800A0 */
  .extern C1RXM2CLR        /* 0xBF8800A4 */
  .extern C1RXM2SET        /* 0xBF8800A8 */
  .extern C1RXM2INV        /* 0xBF8800AC */
  .extern C1RXM3           /* 0xBF8800B0 */
  .extern C1RXM3CLR        /* 0xBF8800B4 */
  .extern C1RXM3SET        /* 0xBF8800B8 */
  .extern C1RXM3INV        /* 0xBF8800BC */
  .extern C1FLTCON0        /* 0xBF8800C0 */
  .extern C1FLTCON0CLR     /* 0xBF8800C4 */
  .extern C1FLTCON0SET     /* 0xBF8800C8 */
  .extern C1FLTCON0INV     /* 0xBF8800CC */
  .extern C1FLTCON1        /* 0xBF8800D0 */
  .extern C1FLTCON1CLR     /* 0xBF8800D4 */
  .extern C1FLTCON1SET     /* 0xBF8800D8 */
  .extern C1FLTCON1INV     /* 0xBF8800DC */
  .extern C1FLTCON2        /* 0xBF8800E0 */
  .extern C1FLTCON2CLR     /* 0xBF8800E4 */
  .extern C1FLTCON2SET     /* 0xBF8800E8 */
  .extern C1FLTCON2INV     /* 0xBF8800EC */
  .extern C1FLTCON3        /* 0xBF8800F0 */
  .extern C1FLTCON3CLR     /* 0xBF8800F4 */
  .extern C1FLTCON3SET     /* 0xBF8800F8 */
  .extern C1FLTCON3INV     /* 0xBF8800FC */
  .extern C1FLTCON4        /* 0xBF880100 */
  .extern C1FLTCON4CLR     /* 0xBF880104 */
  .extern C1FLTCON4SET     /* 0xBF880108 */
  .extern C1FLTCON4INV     /* 0xBF88010C */
  .extern C1FLTCON5        /* 0xBF880110 */
  .extern C1FLTCON5CLR     /* 0xBF880114 */
  .extern C1FLTCON5SET     /* 0xBF880118 */
  .extern C1FLTCON5INV     /* 0xBF88011C */
  .extern C1FLTCON6        /* 0xBF880120 */
  .extern C1FLTCON6CLR     /* 0xBF880124 */
  .extern C1FLTCON6SET     /* 0xBF880128 */
  .extern C1FLTCON6INV     /* 0xBF88012C */
  .extern C1FLTCON7        /* 0xBF880130 */
  .extern C1FLTCON7CLR     /* 0xBF880134 */
  .extern C1FLTCON7SET     /* 0xBF880138 */
  .extern C1FLTCON7INV     /* 0xBF88013C */
  .extern C1RXF0           /* 0xBF880140 */
  .extern C1RXF0CLR        /* 0xBF880144 */
  .extern C1RXF0SET        /* 0xBF880148 */
  .extern C1RXF0INV        /* 0xBF88014C */
  .extern C1RXF1           /* 0xBF880150 */
  .extern C1RXF1CLR        /* 0xBF880154 */
  .extern C1RXF1SET        /* 0xBF880158 */
  .extern C1RXF1INV        /* 0xBF88015C */
  .extern C1RXF2           /* 0xBF880160 */
  .extern C1RXF2CLR        /* 0xBF880164 */
  .extern C1RXF2SET        /* 0xBF880168 */
  .extern C1RXF2INV        /* 0xBF88016C */
  .extern C1RXF3           /* 0xBF880170 */
  .extern C1RXF3CLR        /* 0xBF880174 */
  .extern C1RXF3SET        /* 0xBF880178 */
  .extern C1RXF3INV        /* 0xBF88017C */
  .extern C1RXF4           /* 0xBF880180 */
  .extern C1RXF4CLR        /* 0xBF880184 */
  .extern C1RXF4SET        /* 0xBF880188 */
  .extern C1RXF4INV        /* 0xBF88018C */
  .extern C1RXF5           /* 0xBF880190 */
  .extern C1RXF5CLR        /* 0xBF880194 */
  .extern C1RXF5SET        /* 0xBF880198 */
  .extern C1RXF5INV        /* 0xBF88019C */
  .extern C1RXF6           /* 0xBF8801A0 */
  .extern C1RXF6CLR        /* 0xBF8801A4 */
  .extern C1RXF6SET        /* 0xBF8801A8 */
  .extern C1RXF6INV        /* 0xBF8801AC */
  .extern C1RXF7           /* 0xBF8801B0 */
  .extern C1RXF7CLR        /* 0xBF8801B4 */
  .extern C1RXF7SET        /* 0xBF8801B8 */
  .extern C1RXF7INV        /* 0xBF8801BC */
  .extern C1RXF8           /* 0xBF8801C0 */
  .extern C1RXF8CLR        /* 0xBF8801C4 */
  .extern C1RXF8SET        /* 0xBF8801C8 */
  .extern C1RXF8INV        /* 0xBF8801CC */
  .extern C1RXF9           /* 0xBF8801D0 */
  .extern C1RXF9CLR        /* 0xBF8801D4 */
  .extern C1RXF9SET        /* 0xBF8801D8 */
  .extern C1RXF9INV        /* 0xBF8801DC */
  .extern C1RXF10          /* 0xBF8801E0 */
  .extern C1RXF10CLR       /* 0xBF8801E4 */
  .extern C1RXF10SET       /* 0xBF8801E8 */
  .extern C1RXF10INV       /* 0xBF8801EC */
  .extern C1RXF11          /* 0xBF8801F0 */
  .extern C1RXF11CLR       /* 0xBF8801F4 */
  .extern C1RXF11SET       /* 0xBF8801F8 */
  .extern C1RXF11INV       /* 0xBF8801FC */
  .extern C1RXF12          /* 0xBF880200 */
  .extern C1RXF12CLR       /* 0xBF880204 */
  .extern C1RXF12SET       /* 0xBF880208 */
  .extern C1RXF12INV       /* 0xBF88020C */
  .extern C1RXF13          /* 0xBF880210 */
  .extern C1RXF13CLR       /* 0xBF880214 */
  .extern C1RXF13SET       /* 0xBF880218 */
  .extern C1RXF13INV       /* 0xBF88021C */
  .extern C1RXF14          /* 0xBF880220 */
  .extern C1RXF14CLR       /* 0xBF880224 */
  .extern C1RXF14SET       /* 0xBF880228 */
  .extern C1RXF14INV       /* 0xBF88022C */
  .extern C1RXF15          /* 0xBF880230 */
  .extern C1RXF15CLR       /* 0xBF880234 */
  .extern C1RXF15SET       /* 0xBF880238 */
  .extern C1RXF15INV       /* 0xBF88023C */
  .extern C1RXF16          /* 0xBF880240 */
  .extern C1RXF16CLR       /* 0xBF880244 */
  .extern C1RXF16SET       /* 0xBF880248 */
  .extern C1RXF16INV       /* 0xBF88024C */
  .extern C1RXF17          /* 0xBF880250 */
  .extern C1RXF17CLR       /* 0xBF880254 */
  .extern C1RXF17SET       /* 0xBF880258 */
  .extern C1RXF17INV       /* 0xBF88025C */
  .extern C1RXF18          /* 0xBF880260 */
  .extern C1RXF18CLR       /* 0xBF880264 */
  .extern C1RXF18SET       /* 0xBF880268 */
  .extern C1RXF18INV       /* 0xBF88026C */
  .extern C1RXF19          /* 0xBF880270 */
  .extern C1RXF19CLR       /* 0xBF880274 */
  .extern C1RXF19SET       /* 0xBF880278 */
  .extern C1RXF19INV       /* 0xBF88027C */
  .extern C1RXF20          /* 0xBF880280 */
  .extern C1RXF20CLR       /* 0xBF880284 */
  .extern C1RXF20SET       /* 0xBF880288 */
  .extern C1RXF20INV       /* 0xBF88028C */
  .extern C1RXF21          /* 0xBF880290 */
  .extern C1RXF21CLR       /* 0xBF880294 */
  .extern C1RXF21SET       /* 0xBF880298 */
  .extern C1RXF21INV       /* 0xBF88029C */
  .extern C1RXF22          /* 0xBF8802A0 */
  .extern C1RXF22CLR       /* 0xBF8802A4 */
  .extern C1RXF22SET       /* 0xBF8802A8 */
  .extern C1RXF22INV       /* 0xBF8802AC */
  .extern C1RXF23          /* 0xBF8802B0 */
  .extern C1RXF23CLR       /* 0xBF8802B4 */
  .extern C1RXF23SET       /* 0xBF8802B8 */
  .extern C1RXF23INV       /* 0xBF8802BC */
  .extern C1RXF24          /* 0xBF8802C0 */
  .extern C1RXF24CLR       /* 0xBF8802C4 */
  .extern C1RXF24SET       /* 0xBF8802C8 */
  .extern C1RXF24INV       /* 0xBF8802CC */
  .extern C1RXF25          /* 0xBF8802D0 */
  .extern C1RXF25CLR       /* 0xBF8802D4 */
  .extern C1RXF25SET       /* 0xBF8802D8 */
  .extern C1RXF25INV       /* 0xBF8802DC */
  .extern C1RXF26          /* 0xBF8802E0 */
  .extern C1RXF26CLR       /* 0xBF8802E4 */
  .extern C1RXF26SET       /* 0xBF8802E8 */
  .extern C1RXF26INV       /* 0xBF8802EC */
  .extern C1RXF27          /* 0xBF8802F0 */
  .extern C1RXF27CLR       /* 0xBF8802F4 */
  .extern C1RXF27SET       /* 0xBF8802F8 */
  .extern C1RXF27INV       /* 0xBF8802FC */
  .extern C1RXF28          /* 0xBF880300 */
  .extern C1RXF28CLR       /* 0xBF880304 */
  .extern C1RXF28SET       /* 0xBF880308 */
  .extern C1RXF28INV       /* 0xBF88030C */
  .extern C1RXF29          /* 0xBF880310 */
  .extern C1RXF29CLR       /* 0xBF880314 */
  .extern C1RXF29SET       /* 0xBF880318 */
  .extern C1RXF29INV       /* 0xBF88031C */
  .extern C1RXF30          /* 0xBF880320 */
  .extern C1RXF30CLR       /* 0xBF880324 */
  .extern C1RXF30SET       /* 0xBF880328 */
  .extern C1RXF30INV       /* 0xBF88032C */
  .extern C1RXF31          /* 0xBF880330 */
  .extern C1RXF31CLR       /* 0xBF880334 */
  .extern C1RXF31SET       /* 0xBF880338 */
  .extern C1RXF31INV       /* 0xBF88033C */
  .extern C1FIFOBA         /* 0xBF880340 */
  .extern C1FIFOBACLR      /* 0xBF880344 */
  .extern C1FIFOBASET      /* 0xBF880348 */
  .extern C1FIFOBAINV      /* 0xBF88034C */
  .extern C1FIFOCON0       /* 0xBF880350 */
  .extern C1FIFOCON0CLR    /* 0xBF880354 */
  .extern C1FIFOCON0SET    /* 0xBF880358 */
  .extern C1FIFOCON0INV    /* 0xBF88035C */
  .extern C1FIFOINT0       /* 0xBF880360 */
  .extern C1FIFOINT0CLR    /* 0xBF880364 */
  .extern C1FIFOINT0SET    /* 0xBF880368 */
  .extern C1FIFOINT0INV    /* 0xBF88036C */
  .extern C1FIFOUA0        /* 0xBF880370 */
  .extern C1FIFOUA0CLR     /* 0xBF880374 */
  .extern C1FIFOUA0SET     /* 0xBF880378 */
  .extern C1FIFOUA0INV     /* 0xBF88037C */
  .extern C1FIFOCI0        /* 0xBF880380 */
  .extern C1FIFOCI0CLR     /* 0xBF880384 */
  .extern C1FIFOCI0SET     /* 0xBF880388 */
  .extern C1FIFOCI0INV     /* 0xBF88038C */
  .extern C1FIFOCON1       /* 0xBF880390 */
  .extern C1FIFOCON1CLR    /* 0xBF880394 */
  .extern C1FIFOCON1SET    /* 0xBF880398 */
  .extern C1FIFOCON1INV    /* 0xBF88039C */
  .extern C1FIFOINT1       /* 0xBF8803A0 */
  .extern C1FIFOINT1CLR    /* 0xBF8803A4 */
  .extern C1FIFOINT1SET    /* 0xBF8803A8 */
  .extern C1FIFOINT1INV    /* 0xBF8803AC */
  .extern C1FIFOUA1        /* 0xBF8803B0 */
  .extern C1FIFOUA1CLR     /* 0xBF8803B4 */
  .extern C1FIFOUA1SET     /* 0xBF8803B8 */
  .extern C1FIFOUA1INV     /* 0xBF8803BC */
  .extern C1FIFOCI1        /* 0xBF8803C0 */
  .extern C1FIFOCI1CLR     /* 0xBF8803C4 */
  .extern C1FIFOCI1SET     /* 0xBF8803C8 */
  .extern C1FIFOCI1INV     /* 0xBF8803CC */
  .extern C1FIFOCON2       /* 0xBF8803D0 */
  .extern C1FIFOCON2CLR    /* 0xBF8803D4 */
  .extern C1FIFOCON2SET    /* 0xBF8803D8 */
  .extern C1FIFOCON2INV    /* 0xBF8803DC */
  .extern C1FIFOINT2       /* 0xBF8803E0 */
  .extern C1FIFOINT2CLR    /* 0xBF8803E4 */
  .extern C1FIFOINT2SET    /* 0xBF8803E8 */
  .extern C1FIFOINT2INV    /* 0xBF8803EC */
  .extern C1FIFOUA2        /* 0xBF8803F0 */
  .extern C1FIFOUA2CLR     /* 0xBF8803F4 */
  .extern C1FIFOUA2SET     /* 0xBF8803F8 */
  .extern C1FIFOUA2INV     /* 0xBF8803FC */
  .extern C1FIFOCI2        /* 0xBF880400 */
  .extern C1FIFOCI2CLR     /* 0xBF880404 */
  .extern C1FIFOCI2SET     /* 0xBF880408 */
  .extern C1FIFOCI2INV     /* 0xBF88040C */
  .extern C1FIFOCON3       /* 0xBF880410 */
  .extern C1FIFOCON3CLR    /* 0xBF880414 */
  .extern C1FIFOCON3SET    /* 0xBF880418 */
  .extern C1FIFOCON3INV    /* 0xBF88041C */
  .extern C1FIFOINT3       /* 0xBF880420 */
  .extern C1FIFOINT3CLR    /* 0xBF880424 */
  .extern C1FIFOINT3SET    /* 0xBF880428 */
  .extern C1FIFOINT3INV    /* 0xBF88042C */
  .extern C1FIFOUA3        /* 0xBF880430 */
  .extern C1FIFOUA3CLR     /* 0xBF880434 */
  .extern C1FIFOUA3SET     /* 0xBF880438 */
  .extern C1FIFOUA3INV     /* 0xBF88043C */
  .extern C1FIFOCI3        /* 0xBF880440 */
  .extern C1FIFOCI3CLR     /* 0xBF880444 */
  .extern C1FIFOCI3SET     /* 0xBF880448 */
  .extern C1FIFOCI3INV     /* 0xBF88044C */
  .extern C1FIFOCON4       /* 0xBF880450 */
  .extern C1FIFOCON4CLR    /* 0xBF880454 */
  .extern C1FIFOCON4SET    /* 0xBF880458 */
  .extern C1FIFOCON4INV    /* 0xBF88045C */
  .extern C1FIFOINT4       /* 0xBF880460 */
  .extern C1FIFOINT4CLR    /* 0xBF880464 */
  .extern C1FIFOINT4SET    /* 0xBF880468 */
  .extern C1FIFOINT4INV    /* 0xBF88046C */
  .extern C1FIFOUA4        /* 0xBF880470 */
  .extern C1FIFOUA4CLR     /* 0xBF880474 */
  .extern C1FIFOUA4SET     /* 0xBF880478 */
  .extern C1FIFOUA4INV     /* 0xBF88047C */
  .extern C1FIFOCI4        /* 0xBF880480 */
  .extern C1FIFOCI4CLR     /* 0xBF880484 */
  .extern C1FIFOCI4SET     /* 0xBF880488 */
  .extern C1FIFOCI4INV     /* 0xBF88048C */
  .extern C1FIFOCON5       /* 0xBF880490 */
  .extern C1FIFOCON5CLR    /* 0xBF880494 */
  .extern C1FIFOCON5SET    /* 0xBF880498 */
  .extern C1FIFOCON5INV    /* 0xBF88049C */
  .extern C1FIFOINT5       /* 0xBF8804A0 */
  .extern C1FIFOINT5CLR    /* 0xBF8804A4 */
  .extern C1FIFOINT5SET    /* 0xBF8804A8 */
  .extern C1FIFOINT5INV    /* 0xBF8804AC */
  .extern C1FIFOUA5        /* 0xBF8804B0 */
  .extern C1FIFOUA5CLR     /* 0xBF8804B4 */
  .extern C1FIFOUA5SET     /* 0xBF8804B8 */
  .extern C1FIFOUA5INV     /* 0xBF8804BC */
  .extern C1FIFOCI5        /* 0xBF8804C0 */
  .extern C1FIFOCI5CLR     /* 0xBF8804C4 */
  .extern C1FIFOCI5SET     /* 0xBF8804C8 */
  .extern C1FIFOCI5INV     /* 0xBF8804CC */
  .extern C1FIFOCON6       /* 0xBF8804D0 */
  .extern C1FIFOCON6CLR    /* 0xBF8804D4 */
  .extern C1FIFOCON6SET    /* 0xBF8804D8 */
  .extern C1FIFOCON6INV    /* 0xBF8804DC */
  .extern C1FIFOINT6       /* 0xBF8804E0 */
  .extern C1FIFOINT6CLR    /* 0xBF8804E4 */
  .extern C1FIFOINT6SET    /* 0xBF8804E8 */
  .extern C1FIFOINT6INV    /* 0xBF8804EC */
  .extern C1FIFOUA6        /* 0xBF8804F0 */
  .extern C1FIFOUA6CLR     /* 0xBF8804F4 */
  .extern C1FIFOUA6SET     /* 0xBF8804F8 */
  .extern C1FIFOUA6INV     /* 0xBF8804FC */
  .extern C1FIFOCI6        /* 0xBF880500 */
  .extern C1FIFOCI6CLR     /* 0xBF880504 */
  .extern C1FIFOCI6SET     /* 0xBF880508 */
  .extern C1FIFOCI6INV     /* 0xBF88050C */
  .extern C1FIFOCON7       /* 0xBF880510 */
  .extern C1FIFOCON7CLR    /* 0xBF880514 */
  .extern C1FIFOCON7SET    /* 0xBF880518 */
  .extern C1FIFOCON7INV    /* 0xBF88051C */
  .extern C1FIFOINT7       /* 0xBF880520 */
  .extern C1FIFOINT7CLR    /* 0xBF880524 */
  .extern C1FIFOINT7SET    /* 0xBF880528 */
  .extern C1FIFOINT7INV    /* 0xBF88052C */
  .extern C1FIFOUA7        /* 0xBF880530 */
  .extern C1FIFOUA7CLR     /* 0xBF880534 */
  .extern C1FIFOUA7SET     /* 0xBF880538 */
  .extern C1FIFOUA7INV     /* 0xBF88053C */
  .extern C1FIFOCI7        /* 0xBF880540 */
  .extern C1FIFOCI7CLR     /* 0xBF880544 */
  .extern C1FIFOCI7SET     /* 0xBF880548 */
  .extern C1FIFOCI7INV     /* 0xBF88054C */
  .extern C1FIFOCON8       /* 0xBF880550 */
  .extern C1FIFOCON8CLR    /* 0xBF880554 */
  .extern C1FIFOCON8SET    /* 0xBF880558 */
  .extern C1FIFOCON8INV    /* 0xBF88055C */
  .extern C1FIFOINT8       /* 0xBF880560 */
  .extern C1FIFOINT8CLR    /* 0xBF880564 */
  .extern C1FIFOINT8SET    /* 0xBF880568 */
  .extern C1FIFOINT8INV    /* 0xBF88056C */
  .extern C1FIFOUA8        /* 0xBF880570 */
  .extern C1FIFOUA8CLR     /* 0xBF880574 */
  .extern C1FIFOUA8SET     /* 0xBF880578 */
  .extern C1FIFOUA8INV     /* 0xBF88057C */
  .extern C1FIFOCI8        /* 0xBF880580 */
  .extern C1FIFOCI8CLR     /* 0xBF880584 */
  .extern C1FIFOCI8SET     /* 0xBF880588 */
  .extern C1FIFOCI8INV     /* 0xBF88058C */
  .extern C1FIFOCON9       /* 0xBF880590 */
  .extern C1FIFOCON9CLR    /* 0xBF880594 */
  .extern C1FIFOCON9SET    /* 0xBF880598 */
  .extern C1FIFOCON9INV    /* 0xBF88059C */
  .extern C1FIFOINT9       /* 0xBF8805A0 */
  .extern C1FIFOINT9CLR    /* 0xBF8805A4 */
  .extern C1FIFOINT9SET    /* 0xBF8805A8 */
  .extern C1FIFOINT9INV    /* 0xBF8805AC */
  .extern C1FIFOUA9        /* 0xBF8805B0 */
  .extern C1FIFOUA9CLR     /* 0xBF8805B4 */
  .extern C1FIFOUA9SET     /* 0xBF8805B8 */
  .extern C1FIFOUA9INV     /* 0xBF8805BC */
  .extern C1FIFOCI9        /* 0xBF8805C0 */
  .extern C1FIFOCI9CLR     /* 0xBF8805C4 */
  .extern C1FIFOCI9SET     /* 0xBF8805C8 */
  .extern C1FIFOCI9INV     /* 0xBF8805CC */
  .extern C1FIFOCON10      /* 0xBF8805D0 */
  .extern C1FIFOCON10CLR   /* 0xBF8805D4 */
  .extern C1FIFOCON10SET   /* 0xBF8805D8 */
  .extern C1FIFOCON10INV   /* 0xBF8805DC */
  .extern C1FIFOINT10      /* 0xBF8805E0 */
  .extern C1FIFOINT10CLR   /* 0xBF8805E4 */
  .extern C1FIFOINT10SET   /* 0xBF8805E8 */
  .extern C1FIFOINT10INV   /* 0xBF8805EC */
  .extern C1FIFOUA10       /* 0xBF8805F0 */
  .extern C1FIFOUA10CLR    /* 0xBF8805F4 */
  .extern C1FIFOUA10SET    /* 0xBF8805F8 */
  .extern C1FIFOUA10INV    /* 0xBF8805FC */
  .extern C1FIFOCI10       /* 0xBF880600 */
  .extern C1FIFOCI10CLR    /* 0xBF880604 */
  .extern C1FIFOCI10SET    /* 0xBF880608 */
  .extern C1FIFOCI10INV    /* 0xBF88060C */
  .extern C1FIFOCON11      /* 0xBF880610 */
  .extern C1FIFOCON11CLR   /* 0xBF880614 */
  .extern C1FIFOCON11SET   /* 0xBF880618 */
  .extern C1FIFOCON11INV   /* 0xBF88061C */
  .extern C1FIFOINT11      /* 0xBF880620 */
  .extern C1FIFOINT11CLR   /* 0xBF880624 */
  .extern C1FIFOINT11SET   /* 0xBF880628 */
  .extern C1FIFOINT11INV   /* 0xBF88062C */
  .extern C1FIFOUA11       /* 0xBF880630 */
  .extern C1FIFOUA11CLR    /* 0xBF880634 */
  .extern C1FIFOUA11SET    /* 0xBF880638 */
  .extern C1FIFOUA11INV    /* 0xBF88063C */
  .extern C1FIFOCI11       /* 0xBF880640 */
  .extern C1FIFOCI11CLR    /* 0xBF880644 */
  .extern C1FIFOCI11SET    /* 0xBF880648 */
  .extern C1FIFOCI11INV    /* 0xBF88064C */
  .extern C1FIFOCON12      /* 0xBF880650 */
  .extern C1FIFOCON12CLR   /* 0xBF880654 */
  .extern C1FIFOCON12SET   /* 0xBF880658 */
  .extern C1FIFOCON12INV   /* 0xBF88065C */
  .extern C1FIFOINT12      /* 0xBF880660 */
  .extern C1FIFOINT12CLR   /* 0xBF880664 */
  .extern C1FIFOINT12SET   /* 0xBF880668 */
  .extern C1FIFOINT12INV   /* 0xBF88066C */
  .extern C1FIFOUA12       /* 0xBF880670 */
  .extern C1FIFOUA12CLR    /* 0xBF880674 */
  .extern C1FIFOUA12SET    /* 0xBF880678 */
  .extern C1FIFOUA12INV    /* 0xBF88067C */
  .extern C1FIFOCI12       /* 0xBF880680 */
  .extern C1FIFOCI12CLR    /* 0xBF880684 */
  .extern C1FIFOCI12SET    /* 0xBF880688 */
  .extern C1FIFOCI12INV    /* 0xBF88068C */
  .extern C1FIFOCON13      /* 0xBF880690 */
  .extern C1FIFOCON13CLR   /* 0xBF880694 */
  .extern C1FIFOCON13SET   /* 0xBF880698 */
  .extern C1FIFOCON13INV   /* 0xBF88069C */
  .extern C1FIFOINT13      /* 0xBF8806A0 */
  .extern C1FIFOINT13CLR   /* 0xBF8806A4 */
  .extern C1FIFOINT13SET   /* 0xBF8806A8 */
  .extern C1FIFOINT13INV   /* 0xBF8806AC */
  .extern C1FIFOUA13       /* 0xBF8806B0 */
  .extern C1FIFOUA13CLR    /* 0xBF8806B4 */
  .extern C1FIFOUA13SET    /* 0xBF8806B8 */
  .extern C1FIFOUA13INV    /* 0xBF8806BC */
  .extern C1FIFOCI13       /* 0xBF8806C0 */
  .extern C1FIFOCI13CLR    /* 0xBF8806C4 */
  .extern C1FIFOCI13SET    /* 0xBF8806C8 */
  .extern C1FIFOCI13INV    /* 0xBF8806CC */
  .extern C1FIFOCON14      /* 0xBF8806D0 */
  .extern C1FIFOCON14CLR   /* 0xBF8806D4 */
  .extern C1FIFOCON14SET   /* 0xBF8806D8 */
  .extern C1FIFOCON14INV   /* 0xBF8806DC */
  .extern C1FIFOINT14      /* 0xBF8806E0 */
  .extern C1FIFOINT14CLR   /* 0xBF8806E4 */
  .extern C1FIFOINT14SET   /* 0xBF8806E8 */
  .extern C1FIFOINT14INV   /* 0xBF8806EC */
  .extern C1FIFOUA14       /* 0xBF8806F0 */
  .extern C1FIFOUA14CLR    /* 0xBF8806F4 */
  .extern C1FIFOUA14SET    /* 0xBF8806F8 */
  .extern C1FIFOUA14INV    /* 0xBF8806FC */
  .extern C1FIFOCI14       /* 0xBF880700 */
  .extern C1FIFOCI14CLR    /* 0xBF880704 */
  .extern C1FIFOCI14SET    /* 0xBF880708 */
  .extern C1FIFOCI14INV    /* 0xBF88070C */
  .extern C1FIFOCON15      /* 0xBF880710 */
  .extern C1FIFOCON15CLR   /* 0xBF880714 */
  .extern C1FIFOCON15SET   /* 0xBF880718 */
  .extern C1FIFOCON15INV   /* 0xBF88071C */
  .extern C1FIFOINT15      /* 0xBF880720 */
  .extern C1FIFOINT15CLR   /* 0xBF880724 */
  .extern C1FIFOINT15SET   /* 0xBF880728 */
  .extern C1FIFOINT15INV   /* 0xBF88072C */
  .extern C1FIFOUA15       /* 0xBF880730 */
  .extern C1FIFOUA15CLR    /* 0xBF880734 */
  .extern C1FIFOUA15SET    /* 0xBF880738 */
  .extern C1FIFOUA15INV    /* 0xBF88073C */
  .extern C1FIFOCI15       /* 0xBF880740 */
  .extern C1FIFOCI15CLR    /* 0xBF880744 */
  .extern C1FIFOCI15SET    /* 0xBF880748 */
  .extern C1FIFOCI15INV    /* 0xBF88074C */
  .extern C1FIFOCON16      /* 0xBF880750 */
  .extern C1FIFOCON16CLR   /* 0xBF880754 */
  .extern C1FIFOCON16SET   /* 0xBF880758 */
  .extern C1FIFOCON16INV   /* 0xBF88075C */
  .extern C1FIFOINT16      /* 0xBF880760 */
  .extern C1FIFOINT16CLR   /* 0xBF880764 */
  .extern C1FIFOINT16SET   /* 0xBF880768 */
  .extern C1FIFOINT16INV   /* 0xBF88076C */
  .extern C1FIFOUA16       /* 0xBF880770 */
  .extern C1FIFOUA16CLR    /* 0xBF880774 */
  .extern C1FIFOUA16SET    /* 0xBF880778 */
  .extern C1FIFOUA16INV    /* 0xBF88077C */
  .extern C1FIFOCI16       /* 0xBF880780 */
  .extern C1FIFOCI16CLR    /* 0xBF880784 */
  .extern C1FIFOCI16SET    /* 0xBF880788 */
  .extern C1FIFOCI16INV    /* 0xBF88078C */
  .extern C1FIFOCON17      /* 0xBF880790 */
  .extern C1FIFOCON17CLR   /* 0xBF880794 */
  .extern C1FIFOCON17SET   /* 0xBF880798 */
  .extern C1FIFOCON17INV   /* 0xBF88079C */
  .extern C1FIFOINT17      /* 0xBF8807A0 */
  .extern C1FIFOINT17CLR   /* 0xBF8807A4 */
  .extern C1FIFOINT17SET   /* 0xBF8807A8 */
  .extern C1FIFOINT17INV   /* 0xBF8807AC */
  .extern C1FIFOUA17       /* 0xBF8807B0 */
  .extern C1FIFOUA17CLR    /* 0xBF8807B4 */
  .extern C1FIFOUA17SET    /* 0xBF8807B8 */
  .extern C1FIFOUA17INV    /* 0xBF8807BC */
  .extern C1FIFOCI17       /* 0xBF8807C0 */
  .extern C1FIFOCI17CLR    /* 0xBF8807C4 */
  .extern C1FIFOCI17SET    /* 0xBF8807C8 */
  .extern C1FIFOCI17INV    /* 0xBF8807CC */
  .extern C1FIFOCON18      /* 0xBF8807D0 */
  .extern C1FIFOCON18CLR   /* 0xBF8807D4 */
  .extern C1FIFOCON18SET   /* 0xBF8807D8 */
  .extern C1FIFOCON18INV   /* 0xBF8807DC */
  .extern C1FIFOINT18      /* 0xBF8807E0 */
  .extern C1FIFOINT18CLR   /* 0xBF8807E4 */
  .extern C1FIFOINT18SET   /* 0xBF8807E8 */
  .extern C1FIFOINT18INV   /* 0xBF8807EC */
  .extern C1FIFOUA18       /* 0xBF8807F0 */
  .extern C1FIFOUA18CLR    /* 0xBF8807F4 */
  .extern C1FIFOUA18SET    /* 0xBF8807F8 */
  .extern C1FIFOUA18INV    /* 0xBF8807FC */
  .extern C1FIFOCI18       /* 0xBF880800 */
  .extern C1FIFOCI18CLR    /* 0xBF880804 */
  .extern C1FIFOCI18SET    /* 0xBF880808 */
  .extern C1FIFOCI18INV    /* 0xBF88080C */
  .extern C1FIFOCON19      /* 0xBF880810 */
  .extern C1FIFOCON19CLR   /* 0xBF880814 */
  .extern C1FIFOCON19SET   /* 0xBF880818 */
  .extern C1FIFOCON19INV   /* 0xBF88081C */
  .extern C1FIFOINT19      /* 0xBF880820 */
  .extern C1FIFOINT19CLR   /* 0xBF880824 */
  .extern C1FIFOINT19SET   /* 0xBF880828 */
  .extern C1FIFOINT19INV   /* 0xBF88082C */
  .extern C1FIFOUA19       /* 0xBF880830 */
  .extern C1FIFOUA19CLR    /* 0xBF880834 */
  .extern C1FIFOUA19SET    /* 0xBF880838 */
  .extern C1FIFOUA19INV    /* 0xBF88083C */
  .extern C1FIFOCI19       /* 0xBF880840 */
  .extern C1FIFOCI19CLR    /* 0xBF880844 */
  .extern C1FIFOCI19SET    /* 0xBF880848 */
  .extern C1FIFOCI19INV    /* 0xBF88084C */
  .extern C1FIFOCON20      /* 0xBF880850 */
  .extern C1FIFOCON20CLR   /* 0xBF880854 */
  .extern C1FIFOCON20SET   /* 0xBF880858 */
  .extern C1FIFOCON20INV   /* 0xBF88085C */
  .extern C1FIFOINT20      /* 0xBF880860 */
  .extern C1FIFOINT20CLR   /* 0xBF880864 */
  .extern C1FIFOINT20SET   /* 0xBF880868 */
  .extern C1FIFOINT20INV   /* 0xBF88086C */
  .extern C1FIFOUA20       /* 0xBF880870 */
  .extern C1FIFOUA20CLR    /* 0xBF880874 */
  .extern C1FIFOUA20SET    /* 0xBF880878 */
  .extern C1FIFOUA20INV    /* 0xBF88087C */
  .extern C1FIFOCI20       /* 0xBF880880 */
  .extern C1FIFOCI20CLR    /* 0xBF880884 */
  .extern C1FIFOCI20SET    /* 0xBF880888 */
  .extern C1FIFOCI20INV    /* 0xBF88088C */
  .extern C1FIFOCON21      /* 0xBF880890 */
  .extern C1FIFOCON21CLR   /* 0xBF880894 */
  .extern C1FIFOCON21SET   /* 0xBF880898 */
  .extern C1FIFOCON21INV   /* 0xBF88089C */
  .extern C1FIFOINT21      /* 0xBF8808A0 */
  .extern C1FIFOINT21CLR   /* 0xBF8808A4 */
  .extern C1FIFOINT21SET   /* 0xBF8808A8 */
  .extern C1FIFOINT21INV   /* 0xBF8808AC */
  .extern C1FIFOUA21       /* 0xBF8808B0 */
  .extern C1FIFOUA21CLR    /* 0xBF8808B4 */
  .extern C1FIFOUA21SET    /* 0xBF8808B8 */
  .extern C1FIFOUA21INV    /* 0xBF8808BC */
  .extern C1FIFOCI21       /* 0xBF8808C0 */
  .extern C1FIFOCI21CLR    /* 0xBF8808C4 */
  .extern C1FIFOCI21SET    /* 0xBF8808C8 */
  .extern C1FIFOCI21INV    /* 0xBF8808CC */
  .extern C1FIFOCON22      /* 0xBF8808D0 */
  .extern C1FIFOCON22CLR   /* 0xBF8808D4 */
  .extern C1FIFOCON22SET   /* 0xBF8808D8 */
  .extern C1FIFOCON22INV   /* 0xBF8808DC */
  .extern C1FIFOINT22      /* 0xBF8808E0 */
  .extern C1FIFOINT22CLR   /* 0xBF8808E4 */
  .extern C1FIFOINT22SET   /* 0xBF8808E8 */
  .extern C1FIFOINT22INV   /* 0xBF8808EC */
  .extern C1FIFOUA22       /* 0xBF8808F0 */
  .extern C1FIFOUA22CLR    /* 0xBF8808F4 */
  .extern C1FIFOUA22SET    /* 0xBF8808F8 */
  .extern C1FIFOUA22INV    /* 0xBF8808FC */
  .extern C1FIFOCI22       /* 0xBF880900 */
  .extern C1FIFOCI22CLR    /* 0xBF880904 */
  .extern C1FIFOCI22SET    /* 0xBF880908 */
  .extern C1FIFOCI22INV    /* 0xBF88090C */
  .extern C1FIFOCON23      /* 0xBF880910 */
  .extern C1FIFOCON23CLR   /* 0xBF880914 */
  .extern C1FIFOCON23SET   /* 0xBF880918 */
  .extern C1FIFOCON23INV   /* 0xBF88091C */
  .extern C1FIFOINT23      /* 0xBF880920 */
  .extern C1FIFOINT23CLR   /* 0xBF880924 */
  .extern C1FIFOINT23SET   /* 0xBF880928 */
  .extern C1FIFOINT23INV   /* 0xBF88092C */
  .extern C1FIFOUA23       /* 0xBF880930 */
  .extern C1FIFOUA23CLR    /* 0xBF880934 */
  .extern C1FIFOUA23SET    /* 0xBF880938 */
  .extern C1FIFOUA23INV    /* 0xBF88093C */
  .extern C1FIFOCI23       /* 0xBF880940 */
  .extern C1FIFOCI23CLR    /* 0xBF880944 */
  .extern C1FIFOCI23SET    /* 0xBF880948 */
  .extern C1FIFOCI23INV    /* 0xBF88094C */
  .extern C1FIFOCON24      /* 0xBF880950 */
  .extern C1FIFOCON24CLR   /* 0xBF880954 */
  .extern C1FIFOCON24SET   /* 0xBF880958 */
  .extern C1FIFOCON24INV   /* 0xBF88095C */
  .extern C1FIFOINT24      /* 0xBF880960 */
  .extern C1FIFOINT24CLR   /* 0xBF880964 */
  .extern C1FIFOINT24SET   /* 0xBF880968 */
  .extern C1FIFOINT24INV   /* 0xBF88096C */
  .extern C1FIFOUA24       /* 0xBF880970 */
  .extern C1FIFOUA24CLR    /* 0xBF880974 */
  .extern C1FIFOUA24SET    /* 0xBF880978 */
  .extern C1FIFOUA24INV    /* 0xBF88097C */
  .extern C1FIFOCI24       /* 0xBF880980 */
  .extern C1FIFOCI24CLR    /* 0xBF880984 */
  .extern C1FIFOCI24SET    /* 0xBF880988 */
  .extern C1FIFOCI24INV    /* 0xBF88098C */
  .extern C1FIFOCON25      /* 0xBF880990 */
  .extern C1FIFOCON25CLR   /* 0xBF880994 */
  .extern C1FIFOCON25SET   /* 0xBF880998 */
  .extern C1FIFOCON25INV   /* 0xBF88099C */
  .extern C1FIFOINT25      /* 0xBF8809A0 */
  .extern C1FIFOINT25CLR   /* 0xBF8809A4 */
  .extern C1FIFOINT25SET   /* 0xBF8809A8 */
  .extern C1FIFOINT25INV   /* 0xBF8809AC */
  .extern C1FIFOUA25       /* 0xBF8809B0 */
  .extern C1FIFOUA25CLR    /* 0xBF8809B4 */
  .extern C1FIFOUA25SET    /* 0xBF8809B8 */
  .extern C1FIFOUA25INV    /* 0xBF8809BC */
  .extern C1FIFOCI25       /* 0xBF8809C0 */
  .extern C1FIFOCI25CLR    /* 0xBF8809C4 */
  .extern C1FIFOCI25SET    /* 0xBF8809C8 */
  .extern C1FIFOCI25INV    /* 0xBF8809CC */
  .extern C1FIFOCON26      /* 0xBF8809D0 */
  .extern C1FIFOCON26CLR   /* 0xBF8809D4 */
  .extern C1FIFOCON26SET   /* 0xBF8809D8 */
  .extern C1FIFOCON26INV   /* 0xBF8809DC */
  .extern C1FIFOINT26      /* 0xBF8809E0 */
  .extern C1FIFOINT26CLR   /* 0xBF8809E4 */
  .extern C1FIFOINT26SET   /* 0xBF8809E8 */
  .extern C1FIFOINT26INV   /* 0xBF8809EC */
  .extern C1FIFOUA26       /* 0xBF8809F0 */
  .extern C1FIFOUA26CLR    /* 0xBF8809F4 */
  .extern C1FIFOUA26SET    /* 0xBF8809F8 */
  .extern C1FIFOUA26INV    /* 0xBF8809FC */
  .extern C1FIFOCI26       /* 0xBF880A00 */
  .extern C1FIFOCI26CLR    /* 0xBF880A04 */
  .extern C1FIFOCI26SET    /* 0xBF880A08 */
  .extern C1FIFOCI26INV    /* 0xBF880A0C */
  .extern C1FIFOCON27      /* 0xBF880A10 */
  .extern C1FIFOCON27CLR   /* 0xBF880A14 */
  .extern C1FIFOCON27SET   /* 0xBF880A18 */
  .extern C1FIFOCON27INV   /* 0xBF880A1C */
  .extern C1FIFOINT27      /* 0xBF880A20 */
  .extern C1FIFOINT27CLR   /* 0xBF880A24 */
  .extern C1FIFOINT27SET   /* 0xBF880A28 */
  .extern C1FIFOINT27INV   /* 0xBF880A2C */
  .extern C1FIFOUA27       /* 0xBF880A30 */
  .extern C1FIFOUA27CLR    /* 0xBF880A34 */
  .extern C1FIFOUA27SET    /* 0xBF880A38 */
  .extern C1FIFOUA27INV    /* 0xBF880A3C */
  .extern C1FIFOCI27       /* 0xBF880A40 */
  .extern C1FIFOCI27CLR    /* 0xBF880A44 */
  .extern C1FIFOCI27SET    /* 0xBF880A48 */
  .extern C1FIFOCI27INV    /* 0xBF880A4C */
  .extern C1FIFOCON28      /* 0xBF880A50 */
  .extern C1FIFOCON28CLR   /* 0xBF880A54 */
  .extern C1FIFOCON28SET   /* 0xBF880A58 */
  .extern C1FIFOCON28INV   /* 0xBF880A5C */
  .extern C1FIFOINT28      /* 0xBF880A60 */
  .extern C1FIFOINT28CLR   /* 0xBF880A64 */
  .extern C1FIFOINT28SET   /* 0xBF880A68 */
  .extern C1FIFOINT28INV   /* 0xBF880A6C */
  .extern C1FIFOUA28       /* 0xBF880A70 */
  .extern C1FIFOUA28CLR    /* 0xBF880A74 */
  .extern C1FIFOUA28SET    /* 0xBF880A78 */
  .extern C1FIFOUA28INV    /* 0xBF880A7C */
  .extern C1FIFOCI28       /* 0xBF880A80 */
  .extern C1FIFOCI28CLR    /* 0xBF880A84 */
  .extern C1FIFOCI28SET    /* 0xBF880A88 */
  .extern C1FIFOCI28INV    /* 0xBF880A8C */
  .extern C1FIFOCON29      /* 0xBF880A90 */
  .extern C1FIFOCON29CLR   /* 0xBF880A94 */
  .extern C1FIFOCON29SET   /* 0xBF880A98 */
  .extern C1FIFOCON29INV   /* 0xBF880A9C */
  .extern C1FIFOINT29      /* 0xBF880AA0 */
  .extern C1FIFOINT29CLR   /* 0xBF880AA4 */
  .extern C1FIFOINT29SET   /* 0xBF880AA8 */
  .extern C1FIFOINT29INV   /* 0xBF880AAC */
  .extern C1FIFOUA29       /* 0xBF880AB0 */
  .extern C1FIFOUA29CLR    /* 0xBF880AB4 */
  .extern C1FIFOUA29SET    /* 0xBF880AB8 */
  .extern C1FIFOUA29INV    /* 0xBF880ABC */
  .extern C1FIFOCI29       /* 0xBF880AC0 */
  .extern C1FIFOCI29CLR    /* 0xBF880AC4 */
  .extern C1FIFOCI29SET    /* 0xBF880AC8 */
  .extern C1FIFOCI29INV    /* 0xBF880ACC */
  .extern C1FIFOCON30      /* 0xBF880AD0 */
  .extern C1FIFOCON30CLR   /* 0xBF880AD4 */
  .extern C1FIFOCON30SET   /* 0xBF880AD8 */
  .extern C1FIFOCON30INV   /* 0xBF880ADC */
  .extern C1FIFOINT30      /* 0xBF880AE0 */
  .extern C1FIFOINT30CLR   /* 0xBF880AE4 */
  .extern C1FIFOINT30SET   /* 0xBF880AE8 */
  .extern C1FIFOINT30INV   /* 0xBF880AEC */
  .extern C1FIFOUA30       /* 0xBF880AF0 */
  .extern C1FIFOUA30CLR    /* 0xBF880AF4 */
  .extern C1FIFOUA30SET    /* 0xBF880AF8 */
  .extern C1FIFOUA30INV    /* 0xBF880AFC */
  .extern C1FIFOCI30       /* 0xBF880B00 */
  .extern C1FIFOCI30CLR    /* 0xBF880B04 */
  .extern C1FIFOCI30SET    /* 0xBF880B08 */
  .extern C1FIFOCI30INV    /* 0xBF880B0C */
  .extern C1FIFOCON31      /* 0xBF880B10 */
  .extern C1FIFOCON31CLR   /* 0xBF880B14 */
  .extern C1FIFOCON31SET   /* 0xBF880B18 */
  .extern C1FIFOCON31INV   /* 0xBF880B1C */
  .extern C1FIFOINT31      /* 0xBF880B20 */
  .extern C1FIFOINT31CLR   /* 0xBF880B24 */
  .extern C1FIFOINT31SET   /* 0xBF880B28 */
  .extern C1FIFOINT31INV   /* 0xBF880B2C */
  .extern C1FIFOUA31       /* 0xBF880B30 */
  .extern C1FIFOUA31CLR    /* 0xBF880B34 */
  .extern C1FIFOUA31SET    /* 0xBF880B38 */
  .extern C1FIFOUA31INV    /* 0xBF880B3C */
  .extern C1FIFOCI31       /* 0xBF880B40 */
  .extern C1FIFOCI31CLR    /* 0xBF880B44 */
  .extern C1FIFOCI31SET    /* 0xBF880B48 */
  .extern C1FIFOCI31INV    /* 0xBF880B4C */
  .extern C2CON            /* 0xBF881000 */
  .extern C2CONCLR         /* 0xBF881004 */
  .extern C2CONSET         /* 0xBF881008 */
  .extern C2CONINV         /* 0xBF88100C */
  .extern C2CFG            /* 0xBF881010 */
  .extern C2CFGCLR         /* 0xBF881014 */
  .extern C2CFGSET         /* 0xBF881018 */
  .extern C2CFGINV         /* 0xBF88101C */
  .extern C2INT            /* 0xBF881020 */
  .extern C2INTCLR         /* 0xBF881024 */
  .extern C2INTSET         /* 0xBF881028 */
  .extern C2INTINV         /* 0xBF88102C */
  .extern C2VEC            /* 0xBF881030 */
  .extern C2VECCLR         /* 0xBF881034 */
  .extern C2VECSET         /* 0xBF881038 */
  .extern C2VECINV         /* 0xBF88103C */
  .extern C2TREC           /* 0xBF881040 */
  .extern C2TRECCLR        /* 0xBF881044 */
  .extern C2TRECSET        /* 0xBF881048 */
  .extern C2TRECINV        /* 0xBF88104C */
  .extern C2FSTAT          /* 0xBF881050 */
  .extern C2FSTATCLR       /* 0xBF881054 */
  .extern C2FSTATSET       /* 0xBF881058 */
  .extern C2FSTATINV       /* 0xBF88105C */
  .extern C2RXOVF          /* 0xBF881060 */
  .extern C2RXOVFCLR       /* 0xBF881064 */
  .extern C2RXOVFSET       /* 0xBF881068 */
  .extern C2RXOVFINV       /* 0xBF88106C */
  .extern C2TMR            /* 0xBF881070 */
  .extern C2TMRCLR         /* 0xBF881074 */
  .extern C2TMRSET         /* 0xBF881078 */
  .extern C2TMRINV         /* 0xBF88107C */
  .extern C2RXM0           /* 0xBF881080 */
  .extern C2RXM0CLR        /* 0xBF881084 */
  .extern C2RXM0SET        /* 0xBF881088 */
  .extern C2RXM0INV        /* 0xBF88108C */
  .extern C2RXM1           /* 0xBF881090 */
  .extern C2RXM1CLR        /* 0xBF881094 */
  .extern C2RXM1SET        /* 0xBF881098 */
  .extern C2RXM1INV        /* 0xBF88109C */
  .extern C2RXM2           /* 0xBF8810A0 */
  .extern C2RXM2CLR        /* 0xBF8810A4 */
  .extern C2RXM2SET        /* 0xBF8810A8 */
  .extern C2RXM2INV        /* 0xBF8810AC */
  .extern C2RXM3           /* 0xBF8810B0 */
  .extern C2RXM3CLR        /* 0xBF8810B4 */
  .extern C2RXM3SET        /* 0xBF8810B8 */
  .extern C2RXM3INV        /* 0xBF8810BC */
  .extern C2FLTCON0        /* 0xBF8810C0 */
  .extern C2FLTCON0CLR     /* 0xBF8810C4 */
  .extern C2FLTCON0SET     /* 0xBF8810C8 */
  .extern C2FLTCON0INV     /* 0xBF8810CC */
  .extern C2FLTCON1        /* 0xBF8810D0 */
  .extern C2FLTCON1CLR     /* 0xBF8810D4 */
  .extern C2FLTCON1SET     /* 0xBF8810D8 */
  .extern C2FLTCON1INV     /* 0xBF8810DC */
  .extern C2FLTCON2        /* 0xBF8810E0 */
  .extern C2FLTCON2CLR     /* 0xBF8810E4 */
  .extern C2FLTCON2SET     /* 0xBF8810E8 */
  .extern C2FLTCON2INV     /* 0xBF8810EC */
  .extern C2FLTCON3        /* 0xBF8810F0 */
  .extern C2FLTCON3CLR     /* 0xBF8810F4 */
  .extern C2FLTCON3SET     /* 0xBF8810F8 */
  .extern C2FLTCON3INV     /* 0xBF8810FC */
  .extern C2FLTCON4        /* 0xBF881100 */
  .extern C2FLTCON4CLR     /* 0xBF881104 */
  .extern C2FLTCON4SET     /* 0xBF881108 */
  .extern C2FLTCON4INV     /* 0xBF88110C */
  .extern C2FLTCON5        /* 0xBF881110 */
  .extern C2FLTCON5CLR     /* 0xBF881114 */
  .extern C2FLTCON5SET     /* 0xBF881118 */
  .extern C2FLTCON5INV     /* 0xBF88111C */
  .extern C2FLTCON6        /* 0xBF881120 */
  .extern C2FLTCON6CLR     /* 0xBF881124 */
  .extern C2FLTCON6SET     /* 0xBF881128 */
  .extern C2FLTCON6INV     /* 0xBF88112C */
  .extern C2FLTCON7        /* 0xBF881130 */
  .extern C2FLTCON7CLR     /* 0xBF881134 */
  .extern C2FLTCON7SET     /* 0xBF881138 */
  .extern C2FLTCON7INV     /* 0xBF88113C */
  .extern C2RXF0           /* 0xBF881140 */
  .extern C2RXF0CLR        /* 0xBF881144 */
  .extern C2RXF0SET        /* 0xBF881148 */
  .extern C2RXF0INV        /* 0xBF88114C */
  .extern C2RXF1           /* 0xBF881150 */
  .extern C2RXF1CLR        /* 0xBF881154 */
  .extern C2RXF1SET        /* 0xBF881158 */
  .extern C2RXF1INV        /* 0xBF88115C */
  .extern C2RXF2           /* 0xBF881160 */
  .extern C2RXF2CLR        /* 0xBF881164 */
  .extern C2RXF2SET        /* 0xBF881168 */
  .extern C2RXF2INV        /* 0xBF88116C */
  .extern C2RXF3           /* 0xBF881170 */
  .extern C2RXF3CLR        /* 0xBF881174 */
  .extern C2RXF3SET        /* 0xBF881178 */
  .extern C2RXF3INV        /* 0xBF88117C */
  .extern C2RXF4           /* 0xBF881180 */
  .extern C2RXF4CLR        /* 0xBF881184 */
  .extern C2RXF4SET        /* 0xBF881188 */
  .extern C2RXF4INV        /* 0xBF88118C */
  .extern C2RXF5           /* 0xBF881190 */
  .extern C2RXF5CLR        /* 0xBF881194 */
  .extern C2RXF5SET        /* 0xBF881198 */
  .extern C2RXF5INV        /* 0xBF88119C */
  .extern C2RXF6           /* 0xBF8811A0 */
  .extern C2RXF6CLR        /* 0xBF8811A4 */
  .extern C2RXF6SET        /* 0xBF8811A8 */
  .extern C2RXF6INV        /* 0xBF8811AC */
  .extern C2RXF7           /* 0xBF8811B0 */
  .extern C2RXF7CLR        /* 0xBF8811B4 */
  .extern C2RXF7SET        /* 0xBF8811B8 */
  .extern C2RXF7INV        /* 0xBF8811BC */
  .extern C2RXF8           /* 0xBF8811C0 */
  .extern C2RXF8CLR        /* 0xBF8811C4 */
  .extern C2RXF8SET        /* 0xBF8811C8 */
  .extern C2RXF8INV        /* 0xBF8811CC */
  .extern C2RXF9           /* 0xBF8811D0 */
  .extern C2RXF9CLR        /* 0xBF8811D4 */
  .extern C2RXF9SET        /* 0xBF8811D8 */
  .extern C2RXF9INV        /* 0xBF8811DC */
  .extern C2RXF10          /* 0xBF8811E0 */
  .extern C2RXF10CLR       /* 0xBF8811E4 */
  .extern C2RXF10SET       /* 0xBF8811E8 */
  .extern C2RXF10INV       /* 0xBF8811EC */
  .extern C2RXF11          /* 0xBF8811F0 */
  .extern C2RXF11CLR       /* 0xBF8811F4 */
  .extern C2RXF11SET       /* 0xBF8811F8 */
  .extern C2RXF11INV       /* 0xBF8811FC */
  .extern C2RXF12          /* 0xBF881200 */
  .extern C2RXF12CLR       /* 0xBF881204 */
  .extern C2RXF12SET       /* 0xBF881208 */
  .extern C2RXF12INV       /* 0xBF88120C */
  .extern C2RXF13          /* 0xBF881210 */
  .extern C2RXF13CLR       /* 0xBF881214 */
  .extern C2RXF13SET       /* 0xBF881218 */
  .extern C2RXF13INV       /* 0xBF88121C */
  .extern C2RXF14          /* 0xBF881220 */
  .extern C2RXF14CLR       /* 0xBF881224 */
  .extern C2RXF14SET       /* 0xBF881228 */
  .extern C2RXF14INV       /* 0xBF88122C */
  .extern C2RXF15          /* 0xBF881230 */
  .extern C2RXF15CLR       /* 0xBF881234 */
  .extern C2RXF15SET       /* 0xBF881238 */
  .extern C2RXF15INV       /* 0xBF88123C */
  .extern C2RXF16          /* 0xBF881240 */
  .extern C2RXF16CLR       /* 0xBF881244 */
  .extern C2RXF16SET       /* 0xBF881248 */
  .extern C2RXF16INV       /* 0xBF88124C */
  .extern C2RXF17          /* 0xBF881250 */
  .extern C2RXF17CLR       /* 0xBF881254 */
  .extern C2RXF17SET       /* 0xBF881258 */
  .extern C2RXF17INV       /* 0xBF88125C */
  .extern C2RXF18          /* 0xBF881260 */
  .extern C2RXF18CLR       /* 0xBF881264 */
  .extern C2RXF18SET       /* 0xBF881268 */
  .extern C2RXF18INV       /* 0xBF88126C */
  .extern C2RXF19          /* 0xBF881270 */
  .extern C2RXF19CLR       /* 0xBF881274 */
  .extern C2RXF19SET       /* 0xBF881278 */
  .extern C2RXF19INV       /* 0xBF88127C */
  .extern C2RXF20          /* 0xBF881280 */
  .extern C2RXF20CLR       /* 0xBF881284 */
  .extern C2RXF20SET       /* 0xBF881288 */
  .extern C2RXF20INV       /* 0xBF88128C */
  .extern C2RXF21          /* 0xBF881290 */
  .extern C2RXF21CLR       /* 0xBF881294 */
  .extern C2RXF21SET       /* 0xBF881298 */
  .extern C2RXF21INV       /* 0xBF88129C */
  .extern C2RXF22          /* 0xBF8812A0 */
  .extern C2RXF22CLR       /* 0xBF8812A4 */
  .extern C2RXF22SET       /* 0xBF8812A8 */
  .extern C2RXF22INV       /* 0xBF8812AC */
  .extern C2RXF23          /* 0xBF8812B0 */
  .extern C2RXF23CLR       /* 0xBF8812B4 */
  .extern C2RXF23SET       /* 0xBF8812B8 */
  .extern C2RXF23INV       /* 0xBF8812BC */
  .extern C2RXF24          /* 0xBF8812C0 */
  .extern C2RXF24CLR       /* 0xBF8812C4 */
  .extern C2RXF24SET       /* 0xBF8812C8 */
  .extern C2RXF24INV       /* 0xBF8812CC */
  .extern C2RXF25          /* 0xBF8812D0 */
  .extern C2RXF25CLR       /* 0xBF8812D4 */
  .extern C2RXF25SET       /* 0xBF8812D8 */
  .extern C2RXF25INV       /* 0xBF8812DC */
  .extern C2RXF26          /* 0xBF8812E0 */
  .extern C2RXF26CLR       /* 0xBF8812E4 */
  .extern C2RXF26SET       /* 0xBF8812E8 */
  .extern C2RXF26INV       /* 0xBF8812EC */
  .extern C2RXF27          /* 0xBF8812F0 */
  .extern C2RXF27CLR       /* 0xBF8812F4 */
  .extern C2RXF27SET       /* 0xBF8812F8 */
  .extern C2RXF27INV       /* 0xBF8812FC */
  .extern C2RXF28          /* 0xBF881300 */
  .extern C2RXF28CLR       /* 0xBF881304 */
  .extern C2RXF28SET       /* 0xBF881308 */
  .extern C2RXF28INV       /* 0xBF88130C */
  .extern C2RXF29          /* 0xBF881310 */
  .extern C2RXF29CLR       /* 0xBF881314 */
  .extern C2RXF29SET       /* 0xBF881318 */
  .extern C2RXF29INV       /* 0xBF88131C */
  .extern C2RXF30          /* 0xBF881320 */
  .extern C2RXF30CLR       /* 0xBF881324 */
  .extern C2RXF30SET       /* 0xBF881328 */
  .extern C2RXF30INV       /* 0xBF88132C */
  .extern C2RXF31          /* 0xBF881330 */
  .extern C2RXF31CLR       /* 0xBF881334 */
  .extern C2RXF31SET       /* 0xBF881338 */
  .extern C2RXF31INV       /* 0xBF88133C */
  .extern C2FIFOBA         /* 0xBF881340 */
  .extern C2FIFOBACLR      /* 0xBF881344 */
  .extern C2FIFOBASET      /* 0xBF881348 */
  .extern C2FIFOBAINV      /* 0xBF88134C */
  .extern C2FIFOCON0       /* 0xBF881350 */
  .extern C2FIFOCON0CLR    /* 0xBF881354 */
  .extern C2FIFOCON0SET    /* 0xBF881358 */
  .extern C2FIFOCON0INV    /* 0xBF88135C */
  .extern C2FIFOINT0       /* 0xBF881360 */
  .extern C2FIFOINT0CLR    /* 0xBF881364 */
  .extern C2FIFOINT0SET    /* 0xBF881368 */
  .extern C2FIFOINT0INV    /* 0xBF88136C */
  .extern C2FIFOUA0        /* 0xBF881370 */
  .extern C2FIFOUA0CLR     /* 0xBF881374 */
  .extern C2FIFOUA0SET     /* 0xBF881378 */
  .extern C2FIFOUA0INV     /* 0xBF88137C */
  .extern C2FIFOCI0        /* 0xBF881380 */
  .extern C2FIFOCI0CLR     /* 0xBF881384 */
  .extern C2FIFOCI0SET     /* 0xBF881388 */
  .extern C2FIFOCI0INV     /* 0xBF88138C */
  .extern C2FIFOCON1       /* 0xBF881390 */
  .extern C2FIFOCON1CLR    /* 0xBF881394 */
  .extern C2FIFOCON1SET    /* 0xBF881398 */
  .extern C2FIFOCON1INV    /* 0xBF88139C */
  .extern C2FIFOINT1       /* 0xBF8813A0 */
  .extern C2FIFOINT1CLR    /* 0xBF8813A4 */
  .extern C2FIFOINT1SET    /* 0xBF8813A8 */
  .extern C2FIFOINT1INV    /* 0xBF8813AC */
  .extern C2FIFOUA1        /* 0xBF8813B0 */
  .extern C2FIFOUA1CLR     /* 0xBF8813B4 */
  .extern C2FIFOUA1SET     /* 0xBF8813B8 */
  .extern C2FIFOUA1INV     /* 0xBF8813BC */
  .extern C2FIFOCI1        /* 0xBF8813C0 */
  .extern C2FIFOCI1CLR     /* 0xBF8813C4 */
  .extern C2FIFOCI1SET     /* 0xBF8813C8 */
  .extern C2FIFOCI1INV     /* 0xBF8813CC */
  .extern C2FIFOCON2       /* 0xBF8813D0 */
  .extern C2FIFOCON2CLR    /* 0xBF8813D4 */
  .extern C2FIFOCON2SET    /* 0xBF8813D8 */
  .extern C2FIFOCON2INV    /* 0xBF8813DC */
  .extern C2FIFOINT2       /* 0xBF8813E0 */
  .extern C2FIFOINT2CLR    /* 0xBF8813E4 */
  .extern C2FIFOINT2SET    /* 0xBF8813E8 */
  .extern C2FIFOINT2INV    /* 0xBF8813EC */
  .extern C2FIFOUA2        /* 0xBF8813F0 */
  .extern C2FIFOUA2CLR     /* 0xBF8813F4 */
  .extern C2FIFOUA2SET     /* 0xBF8813F8 */
  .extern C2FIFOUA2INV     /* 0xBF8813FC */
  .extern C2FIFOCI2        /* 0xBF881400 */
  .extern C2FIFOCI2CLR     /* 0xBF881404 */
  .extern C2FIFOCI2SET     /* 0xBF881408 */
  .extern C2FIFOCI2INV     /* 0xBF88140C */
  .extern C2FIFOCON3       /* 0xBF881410 */
  .extern C2FIFOCON3CLR    /* 0xBF881414 */
  .extern C2FIFOCON3SET    /* 0xBF881418 */
  .extern C2FIFOCON3INV    /* 0xBF88141C */
  .extern C2FIFOINT3       /* 0xBF881420 */
  .extern C2FIFOINT3CLR    /* 0xBF881424 */
  .extern C2FIFOINT3SET    /* 0xBF881428 */
  .extern C2FIFOINT3INV    /* 0xBF88142C */
  .extern C2FIFOUA3        /* 0xBF881430 */
  .extern C2FIFOUA3CLR     /* 0xBF881434 */
  .extern C2FIFOUA3SET     /* 0xBF881438 */
  .extern C2FIFOUA3INV     /* 0xBF88143C */
  .extern C2FIFOCI3        /* 0xBF881440 */
  .extern C2FIFOCI3CLR     /* 0xBF881444 */
  .extern C2FIFOCI3SET     /* 0xBF881448 */
  .extern C2FIFOCI3INV     /* 0xBF88144C */
  .extern C2FIFOCON4       /* 0xBF881450 */
  .extern C2FIFOCON4CLR    /* 0xBF881454 */
  .extern C2FIFOCON4SET    /* 0xBF881458 */
  .extern C2FIFOCON4INV    /* 0xBF88145C */
  .extern C2FIFOINT4       /* 0xBF881460 */
  .extern C2FIFOINT4CLR    /* 0xBF881464 */
  .extern C2FIFOINT4SET    /* 0xBF881468 */
  .extern C2FIFOINT4INV    /* 0xBF88146C */
  .extern C2FIFOUA4        /* 0xBF881470 */
  .extern C2FIFOUA4CLR     /* 0xBF881474 */
  .extern C2FIFOUA4SET     /* 0xBF881478 */
  .extern C2FIFOUA4INV     /* 0xBF88147C */
  .extern C2FIFOCI4        /* 0xBF881480 */
  .extern C2FIFOCI4CLR     /* 0xBF881484 */
  .extern C2FIFOCI4SET     /* 0xBF881488 */
  .extern C2FIFOCI4INV     /* 0xBF88148C */
  .extern C2FIFOCON5       /* 0xBF881490 */
  .extern C2FIFOCON5CLR    /* 0xBF881494 */
  .extern C2FIFOCON5SET    /* 0xBF881498 */
  .extern C2FIFOCON5INV    /* 0xBF88149C */
  .extern C2FIFOINT5       /* 0xBF8814A0 */
  .extern C2FIFOINT5CLR    /* 0xBF8814A4 */
  .extern C2FIFOINT5SET    /* 0xBF8814A8 */
  .extern C2FIFOINT5INV    /* 0xBF8814AC */
  .extern C2FIFOUA5        /* 0xBF8814B0 */
  .extern C2FIFOUA5CLR     /* 0xBF8814B4 */
  .extern C2FIFOUA5SET     /* 0xBF8814B8 */
  .extern C2FIFOUA5INV     /* 0xBF8814BC */
  .extern C2FIFOCI5        /* 0xBF8814C0 */
  .extern C2FIFOCI5CLR     /* 0xBF8814C4 */
  .extern C2FIFOCI5SET     /* 0xBF8814C8 */
  .extern C2FIFOCI5INV     /* 0xBF8814CC */
  .extern C2FIFOCON6       /* 0xBF8814D0 */
  .extern C2FIFOCON6CLR    /* 0xBF8814D4 */
  .extern C2FIFOCON6SET    /* 0xBF8814D8 */
  .extern C2FIFOCON6INV    /* 0xBF8814DC */
  .extern C2FIFOINT6       /* 0xBF8814E0 */
  .extern C2FIFOINT6CLR    /* 0xBF8814E4 */
  .extern C2FIFOINT6SET    /* 0xBF8814E8 */
  .extern C2FIFOINT6INV    /* 0xBF8814EC */
  .extern C2FIFOUA6        /* 0xBF8814F0 */
  .extern C2FIFOUA6CLR     /* 0xBF8814F4 */
  .extern C2FIFOUA6SET     /* 0xBF8814F8 */
  .extern C2FIFOUA6INV     /* 0xBF8814FC */
  .extern C2FIFOCI6        /* 0xBF881500 */
  .extern C2FIFOCI6CLR     /* 0xBF881504 */
  .extern C2FIFOCI6SET     /* 0xBF881508 */
  .extern C2FIFOCI6INV     /* 0xBF88150C */
  .extern C2FIFOCON7       /* 0xBF881510 */
  .extern C2FIFOCON7CLR    /* 0xBF881514 */
  .extern C2FIFOCON7SET    /* 0xBF881518 */
  .extern C2FIFOCON7INV    /* 0xBF88151C */
  .extern C2FIFOINT7       /* 0xBF881520 */
  .extern C2FIFOINT7CLR    /* 0xBF881524 */
  .extern C2FIFOINT7SET    /* 0xBF881528 */
  .extern C2FIFOINT7INV    /* 0xBF88152C */
  .extern C2FIFOUA7        /* 0xBF881530 */
  .extern C2FIFOUA7CLR     /* 0xBF881534 */
  .extern C2FIFOUA7SET     /* 0xBF881538 */
  .extern C2FIFOUA7INV     /* 0xBF88153C */
  .extern C2FIFOCI7        /* 0xBF881540 */
  .extern C2FIFOCI7CLR     /* 0xBF881544 */
  .extern C2FIFOCI7SET     /* 0xBF881548 */
  .extern C2FIFOCI7INV     /* 0xBF88154C */
  .extern C2FIFOCON8       /* 0xBF881550 */
  .extern C2FIFOCON8CLR    /* 0xBF881554 */
  .extern C2FIFOCON8SET    /* 0xBF881558 */
  .extern C2FIFOCON8INV    /* 0xBF88155C */
  .extern C2FIFOINT8       /* 0xBF881560 */
  .extern C2FIFOINT8CLR    /* 0xBF881564 */
  .extern C2FIFOINT8SET    /* 0xBF881568 */
  .extern C2FIFOINT8INV    /* 0xBF88156C */
  .extern C2FIFOUA8        /* 0xBF881570 */
  .extern C2FIFOUA8CLR     /* 0xBF881574 */
  .extern C2FIFOUA8SET     /* 0xBF881578 */
  .extern C2FIFOUA8INV     /* 0xBF88157C */
  .extern C2FIFOCI8        /* 0xBF881580 */
  .extern C2FIFOCI8CLR     /* 0xBF881584 */
  .extern C2FIFOCI8SET     /* 0xBF881588 */
  .extern C2FIFOCI8INV     /* 0xBF88158C */
  .extern C2FIFOCON9       /* 0xBF881590 */
  .extern C2FIFOCON9CLR    /* 0xBF881594 */
  .extern C2FIFOCON9SET    /* 0xBF881598 */
  .extern C2FIFOCON9INV    /* 0xBF88159C */
  .extern C2FIFOINT9       /* 0xBF8815A0 */
  .extern C2FIFOINT9CLR    /* 0xBF8815A4 */
  .extern C2FIFOINT9SET    /* 0xBF8815A8 */
  .extern C2FIFOINT9INV    /* 0xBF8815AC */
  .extern C2FIFOUA9        /* 0xBF8815B0 */
  .extern C2FIFOUA9CLR     /* 0xBF8815B4 */
  .extern C2FIFOUA9SET     /* 0xBF8815B8 */
  .extern C2FIFOUA9INV     /* 0xBF8815BC */
  .extern C2FIFOCI9        /* 0xBF8815C0 */
  .extern C2FIFOCI9CLR     /* 0xBF8815C4 */
  .extern C2FIFOCI9SET     /* 0xBF8815C8 */
  .extern C2FIFOCI9INV     /* 0xBF8815CC */
  .extern C2FIFOCON10      /* 0xBF8815D0 */
  .extern C2FIFOCON10CLR   /* 0xBF8815D4 */
  .extern C2FIFOCON10SET   /* 0xBF8815D8 */
  .extern C2FIFOCON10INV   /* 0xBF8815DC */
  .extern C2FIFOINT10      /* 0xBF8815E0 */
  .extern C2FIFOINT10CLR   /* 0xBF8815E4 */
  .extern C2FIFOINT10SET   /* 0xBF8815E8 */
  .extern C2FIFOINT10INV   /* 0xBF8815EC */
  .extern C2FIFOUA10       /* 0xBF8815F0 */
  .extern C2FIFOUA10CLR    /* 0xBF8815F4 */
  .extern C2FIFOUA10SET    /* 0xBF8815F8 */
  .extern C2FIFOUA10INV    /* 0xBF8815FC */
  .extern C2FIFOCI10       /* 0xBF881600 */
  .extern C2FIFOCI10CLR    /* 0xBF881604 */
  .extern C2FIFOCI10SET    /* 0xBF881608 */
  .extern C2FIFOCI10INV    /* 0xBF88160C */
  .extern C2FIFOCON11      /* 0xBF881610 */
  .extern C2FIFOCON11CLR   /* 0xBF881614 */
  .extern C2FIFOCON11SET   /* 0xBF881618 */
  .extern C2FIFOCON11INV   /* 0xBF88161C */
  .extern C2FIFOINT11      /* 0xBF881620 */
  .extern C2FIFOINT11CLR   /* 0xBF881624 */
  .extern C2FIFOINT11SET   /* 0xBF881628 */
  .extern C2FIFOINT11INV   /* 0xBF88162C */
  .extern C2FIFOUA11       /* 0xBF881630 */
  .extern C2FIFOUA11CLR    /* 0xBF881634 */
  .extern C2FIFOUA11SET    /* 0xBF881638 */
  .extern C2FIFOUA11INV    /* 0xBF88163C */
  .extern C2FIFOCI11       /* 0xBF881640 */
  .extern C2FIFOCI11CLR    /* 0xBF881644 */
  .extern C2FIFOCI11SET    /* 0xBF881648 */
  .extern C2FIFOCI11INV    /* 0xBF88164C */
  .extern C2FIFOCON12      /* 0xBF881650 */
  .extern C2FIFOCON12CLR   /* 0xBF881654 */
  .extern C2FIFOCON12SET   /* 0xBF881658 */
  .extern C2FIFOCON12INV   /* 0xBF88165C */
  .extern C2FIFOINT12      /* 0xBF881660 */
  .extern C2FIFOINT12CLR   /* 0xBF881664 */
  .extern C2FIFOINT12SET   /* 0xBF881668 */
  .extern C2FIFOINT12INV   /* 0xBF88166C */
  .extern C2FIFOUA12       /* 0xBF881670 */
  .extern C2FIFOUA12CLR    /* 0xBF881674 */
  .extern C2FIFOUA12SET    /* 0xBF881678 */
  .extern C2FIFOUA12INV    /* 0xBF88167C */
  .extern C2FIFOCI12       /* 0xBF881680 */
  .extern C2FIFOCI12CLR    /* 0xBF881684 */
  .extern C2FIFOCI12SET    /* 0xBF881688 */
  .extern C2FIFOCI12INV    /* 0xBF88168C */
  .extern C2FIFOCON13      /* 0xBF881690 */
  .extern C2FIFOCON13CLR   /* 0xBF881694 */
  .extern C2FIFOCON13SET   /* 0xBF881698 */
  .extern C2FIFOCON13INV   /* 0xBF88169C */
  .extern C2FIFOINT13      /* 0xBF8816A0 */
  .extern C2FIFOINT13CLR   /* 0xBF8816A4 */
  .extern C2FIFOINT13SET   /* 0xBF8816A8 */
  .extern C2FIFOINT13INV   /* 0xBF8816AC */
  .extern C2FIFOUA13       /* 0xBF8816B0 */
  .extern C2FIFOUA13CLR    /* 0xBF8816B4 */
  .extern C2FIFOUA13SET    /* 0xBF8816B8 */
  .extern C2FIFOUA13INV    /* 0xBF8816BC */
  .extern C2FIFOCI13       /* 0xBF8816C0 */
  .extern C2FIFOCI13CLR    /* 0xBF8816C4 */
  .extern C2FIFOCI13SET    /* 0xBF8816C8 */
  .extern C2FIFOCI13INV    /* 0xBF8816CC */
  .extern C2FIFOCON14      /* 0xBF8816D0 */
  .extern C2FIFOCON14CLR   /* 0xBF8816D4 */
  .extern C2FIFOCON14SET   /* 0xBF8816D8 */
  .extern C2FIFOCON14INV   /* 0xBF8816DC */
  .extern C2FIFOINT14      /* 0xBF8816E0 */
  .extern C2FIFOINT14CLR   /* 0xBF8816E4 */
  .extern C2FIFOINT14SET   /* 0xBF8816E8 */
  .extern C2FIFOINT14INV   /* 0xBF8816EC */
  .extern C2FIFOUA14       /* 0xBF8816F0 */
  .extern C2FIFOUA14CLR    /* 0xBF8816F4 */
  .extern C2FIFOUA14SET    /* 0xBF8816F8 */
  .extern C2FIFOUA14INV    /* 0xBF8816FC */
  .extern C2FIFOCI14       /* 0xBF881700 */
  .extern C2FIFOCI14CLR    /* 0xBF881704 */
  .extern C2FIFOCI14SET    /* 0xBF881708 */
  .extern C2FIFOCI14INV    /* 0xBF88170C */
  .extern C2FIFOCON15      /* 0xBF881710 */
  .extern C2FIFOCON15CLR   /* 0xBF881714 */
  .extern C2FIFOCON15SET   /* 0xBF881718 */
  .extern C2FIFOCON15INV   /* 0xBF88171C */
  .extern C2FIFOINT15      /* 0xBF881720 */
  .extern C2FIFOINT15CLR   /* 0xBF881724 */
  .extern C2FIFOINT15SET   /* 0xBF881728 */
  .extern C2FIFOINT15INV   /* 0xBF88172C */
  .extern C2FIFOUA15       /* 0xBF881730 */
  .extern C2FIFOUA15CLR    /* 0xBF881734 */
  .extern C2FIFOUA15SET    /* 0xBF881738 */
  .extern C2FIFOUA15INV    /* 0xBF88173C */
  .extern C2FIFOCI15       /* 0xBF881740 */
  .extern C2FIFOCI15CLR    /* 0xBF881744 */
  .extern C2FIFOCI15SET    /* 0xBF881748 */
  .extern C2FIFOCI15INV    /* 0xBF88174C */
  .extern C2FIFOCON16      /* 0xBF881750 */
  .extern C2FIFOCON16CLR   /* 0xBF881754 */
  .extern C2FIFOCON16SET   /* 0xBF881758 */
  .extern C2FIFOCON16INV   /* 0xBF88175C */
  .extern C2FIFOINT16      /* 0xBF881760 */
  .extern C2FIFOINT16CLR   /* 0xBF881764 */
  .extern C2FIFOINT16SET   /* 0xBF881768 */
  .extern C2FIFOINT16INV   /* 0xBF88176C */
  .extern C2FIFOUA16       /* 0xBF881770 */
  .extern C2FIFOUA16CLR    /* 0xBF881774 */
  .extern C2FIFOUA16SET    /* 0xBF881778 */
  .extern C2FIFOUA16INV    /* 0xBF88177C */
  .extern C2FIFOCI16       /* 0xBF881780 */
  .extern C2FIFOCI16CLR    /* 0xBF881784 */
  .extern C2FIFOCI16SET    /* 0xBF881788 */
  .extern C2FIFOCI16INV    /* 0xBF88178C */
  .extern C2FIFOCON17      /* 0xBF881790 */
  .extern C2FIFOCON17CLR   /* 0xBF881794 */
  .extern C2FIFOCON17SET   /* 0xBF881798 */
  .extern C2FIFOCON17INV   /* 0xBF88179C */
  .extern C2FIFOINT17      /* 0xBF8817A0 */
  .extern C2FIFOINT17CLR   /* 0xBF8817A4 */
  .extern C2FIFOINT17SET   /* 0xBF8817A8 */
  .extern C2FIFOINT17INV   /* 0xBF8817AC */
  .extern C2FIFOUA17       /* 0xBF8817B0 */
  .extern C2FIFOUA17CLR    /* 0xBF8817B4 */
  .extern C2FIFOUA17SET    /* 0xBF8817B8 */
  .extern C2FIFOUA17INV    /* 0xBF8817BC */
  .extern C2FIFOCI17       /* 0xBF8817C0 */
  .extern C2FIFOCI17CLR    /* 0xBF8817C4 */
  .extern C2FIFOCI17SET    /* 0xBF8817C8 */
  .extern C2FIFOCI17INV    /* 0xBF8817CC */
  .extern C2FIFOCON18      /* 0xBF8817D0 */
  .extern C2FIFOCON18CLR   /* 0xBF8817D4 */
  .extern C2FIFOCON18SET   /* 0xBF8817D8 */
  .extern C2FIFOCON18INV   /* 0xBF8817DC */
  .extern C2FIFOINT18      /* 0xBF8817E0 */
  .extern C2FIFOINT18CLR   /* 0xBF8817E4 */
  .extern C2FIFOINT18SET   /* 0xBF8817E8 */
  .extern C2FIFOINT18INV   /* 0xBF8817EC */
  .extern C2FIFOUA18       /* 0xBF8817F0 */
  .extern C2FIFOUA18CLR    /* 0xBF8817F4 */
  .extern C2FIFOUA18SET    /* 0xBF8817F8 */
  .extern C2FIFOUA18INV    /* 0xBF8817FC */
  .extern C2FIFOCI18       /* 0xBF881800 */
  .extern C2FIFOCI18CLR    /* 0xBF881804 */
  .extern C2FIFOCI18SET    /* 0xBF881808 */
  .extern C2FIFOCI18INV    /* 0xBF88180C */
  .extern C2FIFOCON19      /* 0xBF881810 */
  .extern C2FIFOCON19CLR   /* 0xBF881814 */
  .extern C2FIFOCON19SET   /* 0xBF881818 */
  .extern C2FIFOCON19INV   /* 0xBF88181C */
  .extern C2FIFOINT19      /* 0xBF881820 */
  .extern C2FIFOINT19CLR   /* 0xBF881824 */
  .extern C2FIFOINT19SET   /* 0xBF881828 */
  .extern C2FIFOINT19INV   /* 0xBF88182C */
  .extern C2FIFOUA19       /* 0xBF881830 */
  .extern C2FIFOUA19CLR    /* 0xBF881834 */
  .extern C2FIFOUA19SET    /* 0xBF881838 */
  .extern C2FIFOUA19INV    /* 0xBF88183C */
  .extern C2FIFOCI19       /* 0xBF881840 */
  .extern C2FIFOCI19CLR    /* 0xBF881844 */
  .extern C2FIFOCI19SET    /* 0xBF881848 */
  .extern C2FIFOCI19INV    /* 0xBF88184C */
  .extern C2FIFOCON20      /* 0xBF881850 */
  .extern C2FIFOCON20CLR   /* 0xBF881854 */
  .extern C2FIFOCON20SET   /* 0xBF881858 */
  .extern C2FIFOCON20INV   /* 0xBF88185C */
  .extern C2FIFOINT20      /* 0xBF881860 */
  .extern C2FIFOINT20CLR   /* 0xBF881864 */
  .extern C2FIFOINT20SET   /* 0xBF881868 */
  .extern C2FIFOINT20INV   /* 0xBF88186C */
  .extern C2FIFOUA20       /* 0xBF881870 */
  .extern C2FIFOUA20CLR    /* 0xBF881874 */
  .extern C2FIFOUA20SET    /* 0xBF881878 */
  .extern C2FIFOUA20INV    /* 0xBF88187C */
  .extern C2FIFOCI20       /* 0xBF881880 */
  .extern C2FIFOCI20CLR    /* 0xBF881884 */
  .extern C2FIFOCI20SET    /* 0xBF881888 */
  .extern C2FIFOCI20INV    /* 0xBF88188C */
  .extern C2FIFOCON21      /* 0xBF881890 */
  .extern C2FIFOCON21CLR   /* 0xBF881894 */
  .extern C2FIFOCON21SET   /* 0xBF881898 */
  .extern C2FIFOCON21INV   /* 0xBF88189C */
  .extern C2FIFOINT21      /* 0xBF8818A0 */
  .extern C2FIFOINT21CLR   /* 0xBF8818A4 */
  .extern C2FIFOINT21SET   /* 0xBF8818A8 */
  .extern C2FIFOINT21INV   /* 0xBF8818AC */
  .extern C2FIFOUA21       /* 0xBF8818B0 */
  .extern C2FIFOUA21CLR    /* 0xBF8818B4 */
  .extern C2FIFOUA21SET    /* 0xBF8818B8 */
  .extern C2FIFOUA21INV    /* 0xBF8818BC */
  .extern C2FIFOCI21       /* 0xBF8818C0 */
  .extern C2FIFOCI21CLR    /* 0xBF8818C4 */
  .extern C2FIFOCI21SET    /* 0xBF8818C8 */
  .extern C2FIFOCI21INV    /* 0xBF8818CC */
  .extern C2FIFOCON22      /* 0xBF8818D0 */
  .extern C2FIFOCON22CLR   /* 0xBF8818D4 */
  .extern C2FIFOCON22SET   /* 0xBF8818D8 */
  .extern C2FIFOCON22INV   /* 0xBF8818DC */
  .extern C2FIFOINT22      /* 0xBF8818E0 */
  .extern C2FIFOINT22CLR   /* 0xBF8818E4 */
  .extern C2FIFOINT22SET   /* 0xBF8818E8 */
  .extern C2FIFOINT22INV   /* 0xBF8818EC */
  .extern C2FIFOUA22       /* 0xBF8818F0 */
  .extern C2FIFOUA22CLR    /* 0xBF8818F4 */
  .extern C2FIFOUA22SET    /* 0xBF8818F8 */
  .extern C2FIFOUA22INV    /* 0xBF8818FC */
  .extern C2FIFOCI22       /* 0xBF881900 */
  .extern C2FIFOCI22CLR    /* 0xBF881904 */
  .extern C2FIFOCI22SET    /* 0xBF881908 */
  .extern C2FIFOCI22INV    /* 0xBF88190C */
  .extern C2FIFOCON23      /* 0xBF881910 */
  .extern C2FIFOCON23CLR   /* 0xBF881914 */
  .extern C2FIFOCON23SET   /* 0xBF881918 */
  .extern C2FIFOCON23INV   /* 0xBF88191C */
  .extern C2FIFOINT23      /* 0xBF881920 */
  .extern C2FIFOINT23CLR   /* 0xBF881924 */
  .extern C2FIFOINT23SET   /* 0xBF881928 */
  .extern C2FIFOINT23INV   /* 0xBF88192C */
  .extern C2FIFOUA23       /* 0xBF881930 */
  .extern C2FIFOUA23CLR    /* 0xBF881934 */
  .extern C2FIFOUA23SET    /* 0xBF881938 */
  .extern C2FIFOUA23INV    /* 0xBF88193C */
  .extern C2FIFOCI23       /* 0xBF881940 */
  .extern C2FIFOCI23CLR    /* 0xBF881944 */
  .extern C2FIFOCI23SET    /* 0xBF881948 */
  .extern C2FIFOCI23INV    /* 0xBF88194C */
  .extern C2FIFOCON24      /* 0xBF881950 */
  .extern C2FIFOCON24CLR   /* 0xBF881954 */
  .extern C2FIFOCON24SET   /* 0xBF881958 */
  .extern C2FIFOCON24INV   /* 0xBF88195C */
  .extern C2FIFOINT24      /* 0xBF881960 */
  .extern C2FIFOINT24CLR   /* 0xBF881964 */
  .extern C2FIFOINT24SET   /* 0xBF881968 */
  .extern C2FIFOINT24INV   /* 0xBF88196C */
  .extern C2FIFOUA24       /* 0xBF881970 */
  .extern C2FIFOUA24CLR    /* 0xBF881974 */
  .extern C2FIFOUA24SET    /* 0xBF881978 */
  .extern C2FIFOUA24INV    /* 0xBF88197C */
  .extern C2FIFOCI24       /* 0xBF881980 */
  .extern C2FIFOCI24CLR    /* 0xBF881984 */
  .extern C2FIFOCI24SET    /* 0xBF881988 */
  .extern C2FIFOCI24INV    /* 0xBF88198C */
  .extern C2FIFOCON25      /* 0xBF881990 */
  .extern C2FIFOCON25CLR   /* 0xBF881994 */
  .extern C2FIFOCON25SET   /* 0xBF881998 */
  .extern C2FIFOCON25INV   /* 0xBF88199C */
  .extern C2FIFOINT25      /* 0xBF8819A0 */
  .extern C2FIFOINT25CLR   /* 0xBF8819A4 */
  .extern C2FIFOINT25SET   /* 0xBF8819A8 */
  .extern C2FIFOINT25INV   /* 0xBF8819AC */
  .extern C2FIFOUA25       /* 0xBF8819B0 */
  .extern C2FIFOUA25CLR    /* 0xBF8819B4 */
  .extern C2FIFOUA25SET    /* 0xBF8819B8 */
  .extern C2FIFOUA25INV    /* 0xBF8819BC */
  .extern C2FIFOCI25       /* 0xBF8819C0 */
  .extern C2FIFOCI25CLR    /* 0xBF8819C4 */
  .extern C2FIFOCI25SET    /* 0xBF8819C8 */
  .extern C2FIFOCI25INV    /* 0xBF8819CC */
  .extern C2FIFOCON26      /* 0xBF8819D0 */
  .extern C2FIFOCON26CLR   /* 0xBF8819D4 */
  .extern C2FIFOCON26SET   /* 0xBF8819D8 */
  .extern C2FIFOCON26INV   /* 0xBF8819DC */
  .extern C2FIFOINT26      /* 0xBF8819E0 */
  .extern C2FIFOINT26CLR   /* 0xBF8819E4 */
  .extern C2FIFOINT26SET   /* 0xBF8819E8 */
  .extern C2FIFOINT26INV   /* 0xBF8819EC */
  .extern C2FIFOUA26       /* 0xBF8819F0 */
  .extern C2FIFOUA26CLR    /* 0xBF8819F4 */
  .extern C2FIFOUA26SET    /* 0xBF8819F8 */
  .extern C2FIFOUA26INV    /* 0xBF8819FC */
  .extern C2FIFOCI26       /* 0xBF881A00 */
  .extern C2FIFOCI26CLR    /* 0xBF881A04 */
  .extern C2FIFOCI26SET    /* 0xBF881A08 */
  .extern C2FIFOCI26INV    /* 0xBF881A0C */
  .extern C2FIFOCON27      /* 0xBF881A10 */
  .extern C2FIFOCON27CLR   /* 0xBF881A14 */
  .extern C2FIFOCON27SET   /* 0xBF881A18 */
  .extern C2FIFOCON27INV   /* 0xBF881A1C */
  .extern C2FIFOINT27      /* 0xBF881A20 */
  .extern C2FIFOINT27CLR   /* 0xBF881A24 */
  .extern C2FIFOINT27SET   /* 0xBF881A28 */
  .extern C2FIFOINT27INV   /* 0xBF881A2C */
  .extern C2FIFOUA27       /* 0xBF881A30 */
  .extern C2FIFOUA27CLR    /* 0xBF881A34 */
  .extern C2FIFOUA27SET    /* 0xBF881A38 */
  .extern C2FIFOUA27INV    /* 0xBF881A3C */
  .extern C2FIFOCI27       /* 0xBF881A40 */
  .extern C2FIFOCI27CLR    /* 0xBF881A44 */
  .extern C2FIFOCI27SET    /* 0xBF881A48 */
  .extern C2FIFOCI27INV    /* 0xBF881A4C */
  .extern C2FIFOCON28      /* 0xBF881A50 */
  .extern C2FIFOCON28CLR   /* 0xBF881A54 */
  .extern C2FIFOCON28SET   /* 0xBF881A58 */
  .extern C2FIFOCON28INV   /* 0xBF881A5C */
  .extern C2FIFOINT28      /* 0xBF881A60 */
  .extern C2FIFOINT28CLR   /* 0xBF881A64 */
  .extern C2FIFOINT28SET   /* 0xBF881A68 */
  .extern C2FIFOINT28INV   /* 0xBF881A6C */
  .extern C2FIFOUA28       /* 0xBF881A70 */
  .extern C2FIFOUA28CLR    /* 0xBF881A74 */
  .extern C2FIFOUA28SET    /* 0xBF881A78 */
  .extern C2FIFOUA28INV    /* 0xBF881A7C */
  .extern C2FIFOCI28       /* 0xBF881A80 */
  .extern C2FIFOCI28CLR    /* 0xBF881A84 */
  .extern C2FIFOCI28SET    /* 0xBF881A88 */
  .extern C2FIFOCI28INV    /* 0xBF881A8C */
  .extern C2FIFOCON29      /* 0xBF881A90 */
  .extern C2FIFOCON29CLR   /* 0xBF881A94 */
  .extern C2FIFOCON29SET   /* 0xBF881A98 */
  .extern C2FIFOCON29INV   /* 0xBF881A9C */
  .extern C2FIFOINT29      /* 0xBF881AA0 */
  .extern C2FIFOINT29CLR   /* 0xBF881AA4 */
  .extern C2FIFOINT29SET   /* 0xBF881AA8 */
  .extern C2FIFOINT29INV   /* 0xBF881AAC */
  .extern C2FIFOUA29       /* 0xBF881AB0 */
  .extern C2FIFOUA29CLR    /* 0xBF881AB4 */
  .extern C2FIFOUA29SET    /* 0xBF881AB8 */
  .extern C2FIFOUA29INV    /* 0xBF881ABC */
  .extern C2FIFOCI29       /* 0xBF881AC0 */
  .extern C2FIFOCI29CLR    /* 0xBF881AC4 */
  .extern C2FIFOCI29SET    /* 0xBF881AC8 */
  .extern C2FIFOCI29INV    /* 0xBF881ACC */
  .extern C2FIFOCON30      /* 0xBF881AD0 */
  .extern C2FIFOCON30CLR   /* 0xBF881AD4 */
  .extern C2FIFOCON30SET   /* 0xBF881AD8 */
  .extern C2FIFOCON30INV   /* 0xBF881ADC */
  .extern C2FIFOINT30      /* 0xBF881AE0 */
  .extern C2FIFOINT30CLR   /* 0xBF881AE4 */
  .extern C2FIFOINT30SET   /* 0xBF881AE8 */
  .extern C2FIFOINT30INV   /* 0xBF881AEC */
