/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import processing.app.Editor;
import processing.app.EditorConsole;
import processing.app.Platform;
import processing.app.Preferences;
import processing.app.Sketch;
import processing.app.Theme;
import processing.app.UpdateCheck;
import processing.app.debug.Compiler;
import processing.app.debug.Target;
import processing.core.PApplet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Base {
    static Logger logger = Logger.getLogger((String)Base.class.getName());
    public static final int REVISION = 150;
    static String VERSION_NAME = "0150";
    public static boolean RELEASE = false;
    static HashMap<Integer, String> platformNames = new HashMap();
    static HashMap<String, Integer> platformIndices;
    static Platform platform;
    private static boolean commandLine;
    Preferences preferencesFrame;
    boolean builtOnce;
    static File buildFolder;
    private static File examplesFolder;
    private static File librariesFolder;
    private static File toolsFolder;
    private static File hardwareFolder;
    static HashSet<File> libraries;
    static HashMap<String, File> importToLibraryTable;
    public static String librariesClassPath;
    public static HashMap<String, Target> targetsTable;
    static File untitledFolder;
    List<Editor> editors = Collections.synchronizedList(new ArrayList());
    Editor activeEditor;
    boolean breakTime = false;
    String[] months = new String[]{"jan", "feb", "mar", "apr", "may", "jun", "jul", "aug", "sep", "oct", "nov", "dec"};

    public static void main(String[] args) {
        block5: {
            try {
                String version;
                BasicConfigurator.configure();
                Logger.getRootLogger().setLevel(Level.DEBUG);
                logger.debug((Object)("DEBUG: Logging enabled." + Base.class.getName()));
                File versionFile = Base.getContentFile("lib/version.txt");
                if (versionFile.exists() && !(version = PApplet.loadStrings(versionFile)[0]).equals(VERSION_NAME)) {
                    VERSION_NAME = version;
                    RELEASE = true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Base.initPlatform();
            JPopupMenu.setDefaultLightWeightPopupEnabled(false);
            Preferences.init(null);
            Theme.init();
            try {
                platform.setLookAndFeel();
            }
            catch (Exception e) {
                String mess = e.getMessage();
                if (mess.indexOf("ch.randelshofer.quaqua.QuaquaLookAndFeel") != -1) break block5;
                System.err.println("Non-fatal error while setting the Look & Feel.");
                System.err.println("The error message follows, however MPIDE should run fine.");
                System.err.println(mess);
            }
        }
        untitledFolder = Base.createTempFolder("untitled");
        untitledFolder.deleteOnExit();
        new Base(args);
    }

    protected static void setCommandLine() {
        commandLine = true;
    }

    protected static boolean isCommandLine() {
        return commandLine;
    }

    protected static void initPlatform() {
        logger.debug((Object)("Platform and arch: " + Base.osName()));
        try {
            Class<?> platformClass = Class.forName("processing.app.Platform");
            if (Base.isMacOS()) {
                platformClass = Class.forName("processing.app.macosx.Platform");
            } else if (Base.isWindows()) {
                platformClass = Class.forName("processing.app.windows.Platform");
            } else if (Base.isLinux()) {
                platformClass = Class.forName("processing.app.linux.Platform");
            }
            platform = (Platform)platformClass.newInstance();
        }
        catch (Exception e) {
            Base.showError("Problem Setting the Platform", "An unknown error occurred while trying to load\nplatform-specific code for your machine.", e);
        }
    }

    protected static void initRequirements() {
        try {
            Class.forName("com.sun.jdi.VirtualMachine");
        }
        catch (ClassNotFoundException cnfe) {
            Base.showPlatforms();
            Base.showError("Please install JDK 1.5 or later", "MPIDE requires a full JDK (not just a JRE)\nto run. Please install JDK 1.5 or later.\nMore information can be found in the reference.", cnfe);
        }
    }

    public Base(String[] args) {
        File skechbookFolder;
        platform.init(this);
        examplesFolder = Base.getContentFile("examples");
        toolsFolder = Base.getContentFile("tools");
        String sketchbookPath = Preferences.get("sketchbook.path");
        if (sketchbookPath != null && !(skechbookFolder = new File(sketchbookPath)).exists()) {
            Base.showWarning("Sketchbook folder disappeared", "The sketchbook folder no longer exists.\nMPIDE will switch to the default sketchbook\nlocation, and create a new sketchbook folder if\nnecessary. MPIDE will then stop talking about\nhimself in the third person.", null);
            sketchbookPath = null;
        }
        if (sketchbookPath == null) {
            File defaultFolder = this.getDefaultSketchbookFolder();
            Preferences.set("sketchbook.path", defaultFolder.getAbsolutePath());
            if (!defaultFolder.exists()) {
                defaultFolder.mkdirs();
            }
        }
        targetsTable = new HashMap();
        this.loadHardware(Base.getHardwareFolder());
        String platformname = Base.getBoardPreferences().get("platform");
        logger.debug((Object)("!!!Base: Platform Name: " + platformname));
        String libraryPath = Base.getPlatformPreferences(platformname).get("library.path");
        logger.debug((Object)("!!!Base: Library Path: " + libraryPath));
        librariesFolder = Base.getContentFile(libraryPath);
        logger.debug((Object)("Base: librariesFolder: " + librariesFolder));
        boolean opened = this.restoreSketches();
        for (int i = 0; i < args.length; ++i) {
            String path = args[i];
            if (Base.isWindows()) {
                try {
                    File file = new File(args[i]);
                    path = file.getCanonicalPath();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (this.handleOpen(path) == null) continue;
            opened = true;
        }
        if (!opened) {
            this.handleNew();
        }
        if (Preferences.getBoolean("update.check")) {
            new UpdateCheck(this);
        }
    }

    protected boolean restoreSketches() {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        boolean windowPositionValid = true;
        if (Preferences.get("last.screen.height") != null) {
            int screenW = Preferences.getInteger("last.screen.width");
            int screenH = Preferences.getInteger("last.screen.height");
            if (screen.width != screenW || screen.height != screenH) {
                windowPositionValid = false;
            }
        } else {
            windowPositionValid = false;
        }
        int count = Preferences.getInteger("last.sketch.count");
        int opened = 0;
        for (int i = 0; i < count; ++i) {
            int[] location;
            String path = Preferences.get("last.sketch" + i + ".path");
            if (windowPositionValid) {
                String locationStr = Preferences.get("last.sketch" + i + ".location");
                location = PApplet.parseInt(PApplet.split(locationStr, ','));
            } else {
                location = this.nextEditorLocation();
            }
            if (this.handleOpen(path, location) == null) continue;
            ++opened;
        }
        return opened > 0;
    }

    protected void storeSketches() {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        Preferences.setInteger("last.screen.width", screen.width);
        Preferences.setInteger("last.screen.height", screen.height);
        String untitledPath = untitledFolder.getAbsolutePath();
        int index = 0;
        for (Editor editor : this.editors) {
            String path = editor.getSketch().getMainFilePath();
            if (path.startsWith(untitledPath) && !editor.getSketch().isModified()) continue;
            Preferences.set("last.sketch" + index + ".path", path);
            int[] location = editor.getPlacement();
            String locationStr = PApplet.join(PApplet.str(location), ",");
            Preferences.set("last.sketch" + index + ".location", locationStr);
            ++index;
        }
        Preferences.setInteger("last.sketch.count", index);
    }

    protected void storeSketchPath(Editor editor, int index) {
        String untitledPath;
        String path = editor.getSketch().getMainFilePath();
        if (path.startsWith(untitledPath = untitledFolder.getAbsolutePath())) {
            path = "";
        }
        Preferences.set("last.sketch" + index + ".path", path);
    }

    protected void handleActivated(Editor whichEditor) {
        this.activeEditor = whichEditor;
        EditorConsole.setEditor(this.activeEditor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int[] nextEditorLocation() {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        int defaultWidth = Preferences.getInteger("editor.window.width.default");
        int defaultHeight = Preferences.getInteger("editor.window.height.default");
        if (this.activeEditor == null) {
            return new int[]{(screen.width - defaultWidth) / 2, (screen.height - defaultHeight) / 2, defaultWidth, defaultHeight, 0};
        }
        List<Editor> list = this.editors;
        synchronized (list) {
            int OVER = 50;
            Editor lastOpened = this.editors.get(this.editors.size() - 1);
            int[] location = lastOpened.getPlacement();
            location[0] = location[0] + 50;
            location[1] = location[1] + 50;
            if (location[0] == 50 || location[2] == 50 || location[0] + location[2] > screen.width || location[1] + location[3] > screen.height) {
                return new int[]{(int)(Math.random() * (double)(screen.width - defaultWidth)), (int)(Math.random() * (double)(screen.height - defaultHeight)), defaultWidth, defaultHeight, 0};
            }
            return location;
        }
    }

    protected String createNewUntitled() throws IOException {
        File newbieDir = null;
        String newbieName = null;
        File sketchbookDir = Base.getSketchbookFolder();
        File newbieParentDir = untitledFolder;
        int index = 0;
        Calendar cal = Calendar.getInstance();
        int day = cal.get(5);
        int month = cal.get(2);
        String purty = this.months[month] + PApplet.nf(day, 2);
        do {
            if (index == 26) {
                if (!this.breakTime) {
                    Base.showWarning("Time for a Break", "You've reached the limit for auto naming of new sketches\nfor the day. How about going for a walk instead?", null);
                    this.breakTime = true;
                } else {
                    Base.showWarning("Sunshine", "No really, time for some fresh air for you.", null);
                }
                return null;
            }
            newbieName = "sketch_" + purty + (char)(97 + index);
            newbieDir = new File(newbieParentDir, newbieName);
            ++index;
        } while (newbieDir.exists() || new File(sketchbookDir, newbieName).exists());
        newbieDir.mkdirs();
        File newbieFile = new File(newbieDir, newbieName + ".pde");
        new FileOutputStream(newbieFile);
        return newbieFile.getAbsolutePath();
    }

    public void handleNew() {
        block3: {
            try {
                String path = this.createNewUntitled();
                if (path != null) {
                    Editor editor = this.handleOpen(path);
                    editor.untitled = true;
                }
            }
            catch (IOException e) {
                if (this.activeEditor == null) break block3;
                this.activeEditor.statusError(e);
            }
        }
    }

    public void handleNewReplace() {
        if (!this.activeEditor.checkModified()) {
            return;
        }
        this.activeEditor.internalCloseRunner();
        this.handleNewReplaceImpl();
    }

    protected void handleNewReplaceImpl() {
        try {
            String path = this.createNewUntitled();
            if (path != null) {
                this.activeEditor.handleOpenInternal(path);
                this.activeEditor.untitled = true;
            }
        }
        catch (IOException e) {
            this.activeEditor.statusError(e);
        }
    }

    public void handleOpenReplace(String path) {
        if (!this.activeEditor.checkModified()) {
            return;
        }
        this.activeEditor.internalCloseRunner();
        boolean loaded = this.activeEditor.handleOpenInternal(path);
        if (!loaded) {
            this.handleNewReplaceImpl();
        }
    }

    public void handleOpenPrompt() {
        FileDialog fd = new FileDialog((Frame)this.activeEditor, "Open an Arduino sketch...", 0);
        fd.setFilenameFilter(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(".ino") || name.toLowerCase().endsWith(".pde");
            }
        });
        fd.setVisible(true);
        String directory = fd.getDirectory();
        String filename = fd.getFile();
        if (filename == null) {
            return;
        }
        File inputFile = new File(directory, filename);
        this.handleOpen(inputFile.getAbsolutePath());
    }

    public Editor handleOpen(String path) {
        return this.handleOpen(path, this.nextEditorLocation());
    }

    protected Editor handleOpen(String path, int[] location) {
        File file = new File(path);
        if (!file.exists()) {
            return null;
        }
        for (Editor editor : this.editors) {
            if (!editor.getSketch().getMainFilePath().equals(path)) continue;
            editor.toFront();
            return editor;
        }
        Editor editor = new Editor(this, path, location);
        if (editor.getSketch() == null) {
            return null;
        }
        this.editors.add(editor);
        editor.setVisible(true);
        return editor;
    }

    public boolean handleClose(Editor editor) {
        if (!editor.checkModified()) {
            return false;
        }
        editor.internalCloseRunner();
        if (this.editors.size() == 1) {
            Object[] options;
            String prompt;
            int result;
            if (Base.isMacOS() && ((result = JOptionPane.showOptionDialog(editor, prompt = "<html> <head> <style type=\"text/css\">b { font: 13pt \"Lucida Grande\" }p { font: 11pt \"Lucida Grande\"; margin-top: 8px }</style> </head><b>Are you sure you want to Quit?</b><p>Closing the last open sketch will quit MPIDE.", "Quit", 0, 3, null, options = new Object[]{"OK", "Cancel"}, options[0])) == 1 || result == -1)) {
                return false;
            }
            this.editors.remove(editor);
            Editor.serialMonitor.closeSerialPort();
            this.storeSketches();
            Preferences.save();
            System.exit(0);
        } else {
            editor.setVisible(false);
            editor.dispose();
            this.editors.remove(editor);
        }
        return true;
    }

    public boolean handleQuit() {
        this.storeSketches();
        Editor.serialMonitor.closeSerialPort();
        if (this.handleQuitEach()) {
            for (Editor editor : this.editors) {
                editor.internalCloseRunner();
            }
            Preferences.save();
            if (!Base.isMacOS()) {
                System.exit(0);
            }
            return true;
        }
        return false;
    }

    protected boolean handleQuitEach() {
        int index = 0;
        for (Editor editor : this.editors) {
            if (editor.checkModified()) {
                this.storeSketchPath(editor, index);
                ++index;
                continue;
            }
            return false;
        }
        return true;
    }

    protected void rebuildSketchbookMenus() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Base.this.rebuildSketchbookMenu(Editor.sketchbookMenu);
                Base.this.rebuildToolbarMenu(Editor.toolbarMenu);
            }
        });
    }

    protected void rebuildToolbarMenu(JMenu menu) {
        menu.removeAll();
        JMenuItem item = Editor.newJMenuItem("Open...", 79);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Base.this.handleOpenPrompt();
            }
        });
        menu.add(item);
        menu.addSeparator();
        try {
            boolean sketches = this.addSketches(menu, Base.getSketchbookFolder(), true);
            if (sketches) {
                menu.addSeparator();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            boolean found = this.addSketches(menu, examplesFolder, true);
            if (found) {
                menu.addSeparator();
            }
            if (found = this.addSketches(menu, Base.getSketchbookLibrariesFolder(), true)) {
                menu.addSeparator();
            }
            this.addSketches(menu, librariesFolder, true);
            logger.debug((Object)("Base: addsketches librariesFolder: true: " + librariesFolder));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void rebuildSketchbookMenu(JMenu menu) {
        try {
            menu.removeAll();
            this.addSketches(menu, Base.getSketchbookFolder(), false);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void rebuildImportMenu(JMenu importMenu) {
        logger.debug((Object)"Base: DEBUG:start: rebuilding import menu");
        importMenu.removeAll();
        libraries = new HashSet();
        importToLibraryTable = new HashMap();
        try {
            String platformname = this.getBoardPreferences().get("platform");
            String targetname = Base.getPlatformPreferences(platformname).get("name");
            String libraryPath = Base.getPlatformPreferences(platformname).get("library.path");
            logger.debug((Object)("Base: library.path  = " + libraryPath));
            logger.debug((Object)"Base: DEBUG: add libraries.");
            JMenuItem platformItem = new JMenuItem(targetname);
            platformItem.setEnabled(false);
            importMenu.add(platformItem);
            importMenu.addSeparator();
            this.addLibraries(importMenu, Base.getCoreLibraries(libraryPath));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        int separatorIndex = importMenu.getItemCount();
        try {
            File sketchbookLibraries = Base.getSketchbookLibrariesFolder();
            boolean found = this.addLibraries(importMenu, sketchbookLibraries);
            if (found) {
                JMenuItem contrib = new JMenuItem("Contributed");
                contrib.setEnabled(false);
                importMenu.insert(contrib, separatorIndex);
                importMenu.insertSeparator(separatorIndex);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void rebuildExamplesMenu(JMenu menu) {
        logger.debug((Object)"Base: rebuildExamplesMenu: DEBUG: Enter: rebuildExamplesMenu");
        try {
            String platformname = this.getBoardPreferences().get("platform");
            logger.debug((Object)("Base: rebuildExamplesMenu: Platform Name: " + platformname));
            String targetname = Base.getPlatformPreferences(platformname).get("name");
            logger.debug((Object)("Base: rebuildExamplesMenu: Target Name: " + targetname));
            String libraryPath = Base.getPlatformPreferences(platformname).get("library.path");
            menu.removeAll();
            boolean found = this.addSketches(menu, examplesFolder, false);
            logger.debug((Object)("Base: RebuildExamplesMenu: DEBUG: Find examples in library.path  = " + libraryPath));
            JMenuItem platformItem = new JMenuItem("Platform: " + targetname);
            platformItem.setEnabled(false);
            menu.add(platformItem);
            menu.addSeparator();
            if (found) {
                menu.addSeparator();
            }
            if (found = this.addSketches(menu, Base.getSketchbookLibrariesFolder(), false)) {
                menu.addSeparator();
            }
            this.addSketches(menu, Base.getContentFile(libraryPath), false);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void onBoardOrPortChange() {
        for (Editor editor : this.editors) {
            editor.onBoardOrPortChange();
        }
    }

    public void rebuildBoardsMenu(JMenu menu) {
        logger.debug((Object)"Base: rebuildBoardsMenu: DEBUG: start: rebuilding boards menu.");
        menu.removeAll();
        ButtonGroup group = new ButtonGroup();
        HashMap<String, JMenu> groupings = new HashMap<String, JMenu>();
        for (Target target : targetsTable.values()) {
            for (String board : target.getBoards().keySet()) {
                AbstractAction action = new AbstractAction(target.getBoards().get(board).get("name")){

                    public void actionPerformed(ActionEvent actionevent) {
                        logger.debug((Object)("Base: rebuildBoardsMenu: DEBUG: start: Switching to " + (String)this.getValue("target") + ":" + (String)this.getValue("board")));
                        Preferences.set("target", (String)this.getValue("target"));
                        Preferences.set("board", (String)this.getValue("board"));
                        Base.this.onBoardOrPortChange();
                        Editor cfr_ignored_0 = Base.this.activeEditor;
                        Base.this.rebuildImportMenu(Editor.importMenu);
                        logger.debug((Object)"Base: rebuildBoardsMenu: Rebuilding examples menu base on board.");
                        Editor cfr_ignored_1 = Base.this.activeEditor;
                        Base.this.rebuildExamplesMenu(Editor.examplesMenu);
                    }
                };
                action.putValue("target", target.getName());
                action.putValue("board", board);
                JRadioButtonMenuItem item = new JRadioButtonMenuItem(action);
                if (target.getName().equals(Preferences.get("target")) && board.equals(Preferences.get("board"))) {
                    item.setSelected(true);
                }
                group.add(item);
                if (target.getBoards().get(board).get("group") != null) {
                    if (groupings.get(target.getBoards().get(board).get("group")) == null) {
                        groupings.put(target.getBoards().get(board).get("group"), new JMenu(target.getBoards().get(board).get("group")));
                    }
                    ((JMenu)groupings.get(target.getBoards().get(board).get("group"))).add(item);
                } else {
                    menu.add(item);
                }
                for (String grp : groupings.keySet()) {
                    menu.add((JMenuItem)groupings.get(grp));
                }
            }
        }
        logger.debug((Object)"Base: rebuildBoardsMenu: DEBUG: end: rebuilding boards menu.");
    }

    public void rebuildProgrammerMenu(JMenu menu) {
        menu.removeAll();
        for (Target target : targetsTable.values()) {
            for (String programmer : target.getProgrammers().keySet()) {
                AbstractAction action = new AbstractAction("w/ " + target.getProgrammers().get(programmer).get("name")){

                    public void actionPerformed(ActionEvent actionevent) {
                        Base.this.activeEditor.handleBurnBootloader((String)this.getValue("target"), (String)this.getValue("programmer"));
                    }
                };
                action.putValue("target", target.getName());
                action.putValue("programmer", programmer);
                JMenuItem item = new JMenuItem(action);
                menu.add(item);
            }
        }
    }

    protected boolean addSketches(JMenu menu, File folder, final boolean replaceExisting) throws IOException {
        if (!folder.isDirectory()) {
            return false;
        }
        String[] list = folder.list();
        if (list == null) {
            return false;
        }
        Arrays.sort(list, String.CASE_INSENSITIVE_ORDER);
        ActionListener listener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String path = e.getActionCommand();
                if (new File(path).exists()) {
                    boolean replace = replaceExisting;
                    if ((e.getModifiers() & 1) != 0) {
                        boolean bl = replace = !replace;
                    }
                    if (replace) {
                        Base.this.handleOpenReplace(path);
                    } else {
                        Base.this.handleOpen(path);
                    }
                } else {
                    Base.showWarning("Sketch Does Not Exist", "The selected sketch no longer exists.\nYou may need to restart MPIDE to update\nthe sketchbook menu.", null);
                }
            }
        };
        boolean ifound = false;
        for (int i = 0; i < list.length; ++i) {
            File subfolder;
            if (list[i].charAt(0) == '.' || list[i].equals("CVS") || !(subfolder = new File(folder, list[i])).isDirectory()) continue;
            File entry = new File(subfolder, list[i] + ".ino");
            if (!entry.exists() && new File(subfolder, list[i] + ".pde").exists()) {
                entry = new File(subfolder, list[i] + ".pde");
            }
            if (entry.exists()) {
                if (!Sketch.isSanitaryName(list[i])) {
                    if (this.builtOnce) continue;
                    String complaining = "The sketch \"" + list[i] + "\" cannot be used.\n" + "Sketch names must contain only basic letters and numbers\n" + "(ASCII-only with no spaces, " + "and it cannot start with a number).\n" + "To get rid of this message, remove the sketch from\n" + entry.getAbsolutePath();
                    Base.showMessage("Ignoring sketch with bad name", complaining);
                    continue;
                }
                JMenuItem item = new JMenuItem(list[i]);
                item.addActionListener(listener);
                item.setActionCommand(entry.getAbsolutePath());
                menu.add(item);
                ifound = true;
                continue;
            }
            if (subfolder.getName().equals("examples")) {
                boolean found = this.addSketches(menu, subfolder, replaceExisting);
                if (!found) continue;
                ifound = true;
                continue;
            }
            JMenu submenu = new JMenu(list[i]);
            boolean found = this.addSketches(submenu, subfolder, replaceExisting);
            if (!found) continue;
            menu.add(submenu);
            ifound = true;
        }
        return ifound;
    }

    protected boolean addLibraries(JMenu menu, File folder) throws IOException {
        logger.debug((Object)"Base: addLibraries: DEBUG: start: addLibraries.");
        if (!folder.isDirectory()) {
            return false;
        }
        String[] list = folder.list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                if (name.charAt(0) == '.') {
                    return false;
                }
                if (name.equals("CVS")) {
                    return false;
                }
                return new File(dir, name).isDirectory();
            }
        });
        if (list == null) {
            return false;
        }
        Arrays.sort(list, String.CASE_INSENSITIVE_ORDER);
        ActionListener listener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Base.this.activeEditor.getSketch().importLibrary(e.getActionCommand());
            }
        };
        boolean ifound = false;
        for (String potentialName : list) {
            String[] packages;
            File subfolder = new File(folder, potentialName);
            String sanityCheck = Sketch.sanitizeName(potentialName);
            if (!sanityCheck.equals(potentialName)) {
                String mess = "The library \"" + potentialName + "\" cannot be used.\n" + "Library names must contain only basic letters and numbers.\n" + "(ASCII only and no spaces, and it cannot start with a number)";
                Base.showMessage("Ignoring bad library name", mess);
                continue;
            }
            String libraryName = potentialName;
            libraries.add(subfolder);
            logger.debug((Object)("Base: addLibraries: Base.subfolder: " + subfolder));
            for (String pkg : packages = Compiler.headerListFromIncludePath(subfolder.getAbsolutePath())) {
                importToLibraryTable.put(pkg, subfolder);
            }
            JMenuItem item = new JMenuItem(libraryName);
            item.addActionListener(listener);
            item.setActionCommand(subfolder.getAbsolutePath());
            menu.add(item);
            ifound = true;
        }
        return ifound;
    }

    protected void loadHardware(File folder) {
        if (!folder.isDirectory()) {
            return;
        }
        String[] list = folder.list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                if (name.charAt(0) == '.') {
                    return false;
                }
                if (name.equals("CVS")) {
                    return false;
                }
                return new File(dir, name).isDirectory();
            }
        });
        if (list == null) {
            return;
        }
        Arrays.sort(list, String.CASE_INSENSITIVE_ORDER);
        for (String target : list) {
            File subfolder = new File(folder, target);
            File pf = new File(subfolder, "platforms.txt");
            if (!pf.exists()) continue;
            targetsTable.put(target, new Target(target, subfolder));
        }
    }

    public void handleAbout() {
        final Image image = Base.getLibImage("about.jpg", this.activeEditor);
        final Window window = new Window(this.activeEditor){

            public void paint(Graphics g) {
                g.drawImage(image, 0, 0, null);
                Graphics2D g2 = (Graphics2D)g;
                g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
                g.setFont(new Font("SansSerif", 0, 11));
                g.setColor(Color.white);
                g.drawString(VERSION_NAME, 50, 30);
            }
        };
        window.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                window.dispose();
            }
        });
        int w = image.getWidth(this.activeEditor);
        int h = image.getHeight(this.activeEditor);
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        window.setBounds((screen.width - w) / 2, (screen.height - h) / 2, w, h);
        window.setVisible(true);
    }

    public void handlePrefs() {
        if (this.preferencesFrame == null) {
            this.preferencesFrame = new Preferences();
        }
        this.preferencesFrame.showFrame(this.activeEditor);
    }

    public static Platform getPlatform() {
        return platform;
    }

    public static String getPlatformName() {
        String osname = System.getProperty("os.name");
        if (osname.indexOf("Mac") != -1) {
            return "macosx";
        }
        if (osname.indexOf("Windows") != -1) {
            return "windows";
        }
        if (osname.equals("Linux")) {
            return "linux";
        }
        return "other";
    }

    public static String getPlatformName(int which) {
        return platformNames.get(which);
    }

    public static int getPlatformIndex(String what) {
        Integer entry = platformIndices.get(what);
        return entry == null ? -1 : entry;
    }

    public static String osName() {
        String sysname = Base.getPlatformName();
        String arch = System.getProperty("os.arch");
        return sysname + "_" + arch;
    }

    public static boolean isMacOS() {
        return System.getProperty("os.name").indexOf("Mac") != -1;
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").indexOf("Windows") != -1;
    }

    public static boolean isLinux() {
        return System.getProperty("os.name").indexOf("Linux") != -1;
    }

    public static File getSettingsFolder() {
        File settingsFolder = null;
        String preferencesPath = Preferences.get("settings.path");
        if (preferencesPath != null) {
            settingsFolder = new File(preferencesPath);
        } else {
            try {
                settingsFolder = platform.getSettingsFolder();
            }
            catch (Exception e) {
                Base.showError("Problem getting data folder", "Error getting the MPIDE data folder.", e);
            }
        }
        if (!settingsFolder.exists() && !settingsFolder.mkdirs()) {
            Base.showError("Settings issues", "MPIDE cannot run because it could not\ncreate a folder to store your settings.", null);
        }
        return settingsFolder;
    }

    public static File getSettingsFile(String filename) {
        return new File(Base.getSettingsFolder(), filename);
    }

    public static File getBuildFolder() {
        if (buildFolder == null) {
            String buildPath = Preferences.get("build.path");
            if (buildPath != null) {
                buildFolder = new File(buildPath);
            } else {
                buildFolder = Base.createTempFolder("build");
                buildFolder.deleteOnExit();
            }
        }
        return buildFolder;
    }

    public static File createTempFolder(String name) {
        try {
            File folder = File.createTempFile(name, null);
            folder.delete();
            folder.mkdirs();
            return folder;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Set<File> getLibraries() {
        return libraries;
    }

    public static String getExamplesPath() {
        return examplesFolder.getAbsolutePath();
    }

    public static String getLibrariesPath() {
        return librariesFolder.getAbsolutePath();
    }

    public static File getToolsFolder() {
        return toolsFolder;
    }

    public static String getToolsPath() {
        return toolsFolder.getAbsolutePath();
    }

    public static File getHardwareFolder() {
        return Base.getContentFile("hardware");
    }

    public static File getCoreLibraries(String path) {
        return Base.getContentFile(path);
    }

    public static String getHardwarePath() {
        return Base.getHardwareFolder().getAbsolutePath();
    }

    public static String getAvrBasePath() {
        if (Base.isLinux()) {
            return "";
        }
        return Base.getHardwarePath() + File.separator + "tools" + File.separator + "avr" + File.separator + "bin" + File.separator;
    }

    public static Target getTarget() {
        Target target = targetsTable.get(Preferences.get("target"));
        if (target == null) {
            return null;
        }
        logger.debug((Object)("Base: getTarget() : Target Name: " + target.getName()));
        return target;
    }

    public static Map<String, String> getSketchPreferences(File folder) {
        Target target = Base.getTarget();
        Map<String, String> map = target.getSketchPreferences(folder);
        return map;
    }

    public static Map<String, String> getPlatformPreferences() {
        Target target = Base.getTarget();
        if (target == null) {
            return new LinkedHashMap<String, String>();
        }
        Map<String, Object> map = target.getPlatforms();
        map = map.get(Preferences.get("platform"));
        return map;
    }

    public static Map<String, String> getPlatformPreferences(String platformname) {
        logger.debug((Object)("Base: getPlatformPreferences: platformname: " + platformname));
        Target target = Base.getTarget();
        if (target == null) {
            return new LinkedHashMap<String, String>();
        }
        Map<String, Object> map = target.getPlatforms();
        map = map.get(platformname);
        return map;
    }

    public static Map<String, String> getBoardPreferences() {
        Target target = Base.getTarget();
        if (target == null) {
            logger.debug((Object)"Base: getBoardPreferences target is null");
            return new LinkedHashMap<String, String>();
        }
        Map<String, Object> map = target.getBoards();
        if (map == null) {
            logger.debug((Object)"Base: getBoardPreferences target getBoards() is null");
            return new LinkedHashMap<String, String>();
        }
        Map<String, String> map1 = map.get(Preferences.get("board"));
        if (map1 == null) {
            String[] entries = map.keySet().toArray(new String[0]);
            logger.debug((Object)("Base: getBoardPreferences board not found, defaulting to " + entries[0]));
            map = (Map)map.get(entries[0]);
            if (map == null) {
                logger.debug((Object)"Base: getBoardPreferences unable to find any board");
                return new LinkedHashMap<String, String>();
            }
        } else {
            map = map1;
        }
        return map;
    }

    public static File getSketchbookFolder() {
        return new File(Preferences.get("sketchbook.path"));
    }

    public static File getSketchbookLibrariesFolder() {
        File libdir = new File(Base.getSketchbookFolder(), "libraries");
        if (!libdir.exists()) {
            try {
                libdir.mkdirs();
                File readme = new File(libdir, "readme.txt");
                FileWriter freadme = new FileWriter(readme);
                freadme.write("For information on installing libraries, see: http://chipkit.net\n");
                freadme.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return libdir;
    }

    public static String getSketchbookLibrariesPath() {
        return Base.getSketchbookLibrariesFolder().getAbsolutePath();
    }

    public static File getSketchbookHardwareFolder() {
        return new File(Base.getSketchbookFolder(), "hardware");
    }

    protected File getDefaultSketchbookFolder() {
        File sketchbookFolder = null;
        try {
            sketchbookFolder = platform.getDefaultSketchbookFolder();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (sketchbookFolder == null) {
            sketchbookFolder = Base.promptSketchbookLocation();
        }
        boolean result = true;
        if (!sketchbookFolder.exists()) {
            result = sketchbookFolder.mkdirs();
        }
        if (!result) {
            Base.showError("You forgot your sketchbook", "MPIDE cannot run because it could not\ncreate a folder to store your sketchbook.", null);
        }
        return sketchbookFolder;
    }

    protected static File promptSketchbookLocation() {
        File folder = null;
        folder = new File(System.getProperty("user.home"), "sketchbook");
        if (!folder.exists()) {
            folder.mkdirs();
            return folder;
        }
        String prompt = "Select (or create new) folder for sketches...";
        folder = Base.selectFolder(prompt, null, null);
        if (folder == null) {
            System.exit(0);
        }
        return folder;
    }

    public static void openURL(String url) {
        try {
            platform.openURL(url);
        }
        catch (Exception e) {
            Base.showWarning("Problem Opening URL", "Could not open the URL\n" + url, e);
        }
    }

    protected static boolean openFolderAvailable() {
        return platform.openFolderAvailable();
    }

    public static void openFolder(File file) {
        try {
            platform.openFolder(file);
        }
        catch (Exception e) {
            Base.showWarning("Problem Opening Folder", "Could not open the folder\n" + file.getAbsolutePath(), e);
        }
    }

    public static File selectFolder(String prompt, File folder, Frame frame) {
        if (Base.isMacOS()) {
            if (frame == null) {
                frame = new Frame();
            }
            FileDialog fd = new FileDialog(frame, prompt, 0);
            if (folder != null) {
                fd.setDirectory(folder.getParent());
            }
            System.setProperty("apple.awt.fileDialogForDirectories", "true");
            fd.setVisible(true);
            System.setProperty("apple.awt.fileDialogForDirectories", "false");
            if (fd.getFile() == null) {
                return null;
            }
            return new File(fd.getDirectory(), fd.getFile());
        }
        JFileChooser fc = new JFileChooser();
        fc.setDialogTitle(prompt);
        if (folder != null) {
            fc.setSelectedFile(folder);
        }
        fc.setFileSelectionMode(1);
        int returned = fc.showOpenDialog(new JDialog());
        if (returned == 0) {
            return fc.getSelectedFile();
        }
        return null;
    }

    public static void setIcon(Frame frame) {
        File imageLocation = new File(Base.getContentFile("lib/theme"), "mpide-icon.png");
        Image image = Toolkit.getDefaultToolkit().createImage(imageLocation.getAbsolutePath());
        frame.setIconImage(image);
    }

    public static void registerWindowCloseKeys(JRootPane root, ActionListener disposer) {
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        root.registerKeyboardAction(disposer, stroke, 2);
        int modifiers = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        stroke = KeyStroke.getKeyStroke(87, modifiers);
        root.registerKeyboardAction(disposer, stroke, 2);
    }

    public static void showReference(String filename) {
        File referenceFolder = Base.getContentFile("reference");
        File referenceFile = new File(referenceFolder, filename);
        Base.openURL(referenceFile.getAbsolutePath());
    }

    public static void showGettingStarted() {
        if (Base.isMacOS()) {
            Base.showReference("Guide_MacOSX.html");
        } else if (Base.isWindows()) {
            Base.showReference("Guide_Windows.html");
        } else {
            Base.openURL("http://www.arduino.cc/playground/Learning/Linux");
        }
    }

    public static void showReference() {
        Base.showReference("index.html");
    }

    public static void showEnvironment() {
        Base.showReference("Guide_Environment.html");
    }

    public static void showPlatforms() {
        Base.showReference("environment" + File.separator + "platforms.html");
    }

    public static void showTroubleshooting() {
        Base.showReference("Guide_Troubleshooting.html");
    }

    public static void showFAQ() {
        Base.showReference("FAQ.html");
    }

    public static void showMessage(String title, String message) {
        if (title == null) {
            title = "Message";
        }
        if (commandLine) {
            System.out.println(title + ": " + message);
        } else {
            JOptionPane.showMessageDialog(new Frame(), message, title, 1);
        }
    }

    public static void showWarning(String title, String message, Exception e) {
        if (title == null) {
            title = "Warning";
        }
        if (commandLine) {
            System.out.println(title + ": " + message);
        } else {
            JOptionPane.showMessageDialog(new Frame(), message, title, 2);
        }
        if (e != null) {
            e.printStackTrace();
        }
    }

    public static void showError(String title, String message, Throwable e) {
        if (title == null) {
            title = "Error";
        }
        if (commandLine) {
            System.err.println(title + ": " + message);
        } else {
            JOptionPane.showMessageDialog(new Frame(), message, title, 0);
        }
        if (e != null) {
            e.printStackTrace();
        }
        System.exit(1);
    }

    public static int showYesNoCancelQuestion(Editor editor, String title, String primary, String secondary) {
        if (!Base.isMacOS()) {
            int result = JOptionPane.showConfirmDialog(null, primary + "\n" + secondary, title, 1, 3);
            return result;
        }
        JOptionPane pane = new JOptionPane("<html> <head> <style type=\"text/css\">b { font: 13pt \"Lucida Grande\" }p { font: 11pt \"Lucida Grande\"; margin-top: 8px }</style> </head><b>Do you want to save changes to this sketch<BR> before closing?</b><p>If you don't save, your changes will be lost.", 3);
        Object[] options = new String[]{"Save", "Cancel", "Don't Save"};
        pane.setOptions(options);
        pane.setInitialValue(options[0]);
        pane.putClientProperty("Quaqua.OptionPane.destructiveOption", new Integer(2));
        JDialog dialog = pane.createDialog(editor, null);
        dialog.setVisible(true);
        Object result = pane.getValue();
        if (result == options[0]) {
            return 0;
        }
        if (result == options[1]) {
            return 2;
        }
        if (result == options[2]) {
            return 1;
        }
        return -1;
    }

    public static int showYesNoQuestion(Frame editor, String title, String primary, String secondary) {
        if (!Base.isMacOS()) {
            return JOptionPane.showConfirmDialog(editor, "<html><body><b>" + primary + "</b>" + "<br>" + secondary, title, 0, 3);
        }
        JOptionPane pane = new JOptionPane("<html> <head> <style type=\"text/css\">b { font: 13pt \"Lucida Grande\" }p { font: 11pt \"Lucida Grande\"; margin-top: 8px }</style> </head><b>" + primary + "</b>" + "<p>" + secondary + "</p>", 3);
        Object[] options = new String[]{"Yes", "No"};
        pane.setOptions(options);
        pane.setInitialValue(options[0]);
        JDialog dialog = pane.createDialog(editor, null);
        dialog.setVisible(true);
        Object result = pane.getValue();
        if (result == options[0]) {
            return 0;
        }
        if (result == options[1]) {
            return 1;
        }
        return -1;
    }

    public static File getContentFile(String name) {
        String javaroot;
        String path = System.getProperty("user.dir");
        if (Base.isMacOS() && (javaroot = System.getProperty("javaroot")) != null) {
            path = javaroot;
        }
        File working = new File(path);
        return new File(working, name);
    }

    public static Image getThemeImage(String name, Component who) {
        return Base.getLibImage("theme/" + name, who);
    }

    public static Image getLibImage(String name, Component who) {
        Image image = null;
        Toolkit tk = Toolkit.getDefaultToolkit();
        File imageLocation = new File(Base.getContentFile("lib"), name);
        image = tk.getImage(imageLocation.getAbsolutePath());
        logger.debug((Object)("Base: getLibImage: DEBUG: Image location: " + imageLocation.getAbsolutePath()));
        MediaTracker tracker = new MediaTracker(who);
        tracker.addImage(image, 0);
        try {
            tracker.waitForAll();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        return image;
    }

    public static InputStream getLibStream(String filename) throws IOException {
        return new FileInputStream(new File(Base.getContentFile("lib"), filename));
    }

    public static int countLines(String what) {
        int count = 1;
        for (char c : what.toCharArray()) {
            if (c != '\n') continue;
            ++count;
        }
        return count;
    }

    public static byte[] loadBytesRaw(File file) throws IOException {
        int bytesRead;
        int size = (int)file.length();
        FileInputStream input = new FileInputStream(file);
        byte[] buffer = new byte[size];
        int offset = 0;
        while ((bytesRead = input.read(buffer, offset, size - offset)) != -1) {
            offset += bytesRead;
            if (bytesRead != 0) continue;
        }
        input.close();
        input = null;
        return buffer;
    }

    public static HashMap<String, String> readSettings(File inputFile) {
        HashMap<String, String> outgoing = new HashMap<String, String>();
        if (!inputFile.exists()) {
            return outgoing;
        }
        String[] lines = PApplet.loadStrings(inputFile);
        for (int i = 0; i < lines.length; ++i) {
            String line;
            int hash = lines[i].indexOf(35);
            String string = line = hash == -1 ? lines[i].trim() : lines[i].substring(0, hash).trim();
            if (line.length() == 0) continue;
            int equals = line.indexOf(61);
            if (equals == -1) {
                System.err.println("ignoring illegal line in " + inputFile);
                System.err.println("  " + line);
                continue;
            }
            String attr = line.substring(0, equals).trim();
            String valu = line.substring(equals + 1).trim();
            outgoing.put(attr, valu);
        }
        return outgoing;
    }

    public static void copyFile(File sourceFile, File targetFile) throws IOException {
        int bytesRead;
        BufferedInputStream from = new BufferedInputStream(new FileInputStream(sourceFile));
        BufferedOutputStream to = new BufferedOutputStream(new FileOutputStream(targetFile));
        byte[] buffer = new byte[16384];
        while ((bytesRead = ((InputStream)from).read(buffer)) != -1) {
            ((OutputStream)to).write(buffer, 0, bytesRead);
        }
        ((OutputStream)to).flush();
        ((InputStream)from).close();
        from = null;
        ((OutputStream)to).close();
        to = null;
        targetFile.setLastModified(sourceFile.lastModified());
    }

    public static String loadFile(File file) throws IOException {
        String[] contents = PApplet.loadStrings(file);
        if (contents == null) {
            return null;
        }
        return PApplet.join(contents, "\n");
    }

    public static void saveFile(String str, File file) throws IOException {
        boolean result;
        File temp = File.createTempFile(file.getName(), null, file.getParentFile());
        PApplet.saveStrings(temp, new String[]{str});
        if (file.exists() && !(result = file.delete())) {
            throw new IOException("Could not remove old version of " + file.getAbsolutePath());
        }
        result = temp.renameTo(file);
        if (!result) {
            throw new IOException("Could not replace " + file.getAbsolutePath());
        }
    }

    public static void copyDir(File sourceDir, File targetDir) throws IOException {
        targetDir.mkdirs();
        String[] files = sourceDir.list();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].charAt(0) == '.') continue;
            File source = new File(sourceDir, files[i]);
            File target = new File(targetDir, files[i]);
            if (source.isDirectory()) {
                Base.copyDir(source, target);
                target.setLastModified(source.lastModified());
                continue;
            }
            Base.copyFile(source, target);
        }
    }

    public static void removeDir(File dir) {
        if (dir.exists()) {
            Base.removeDescendants(dir);
            if (!dir.delete()) {
                System.err.println("Could not delete " + dir);
            }
        }
    }

    public static void removeDescendants(File dir) {
        if (!dir.exists()) {
            return;
        }
        String[] files = dir.list();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].equals(".") || files[i].equals("..")) continue;
            File dead = new File(dir, files[i]);
            if (!dead.isDirectory()) {
                if (Preferences.getBoolean("compiler.save_build_files") || dead.delete()) continue;
                System.err.println("Could not delete " + dead);
                continue;
            }
            Base.removeDir(dead);
        }
    }

    public static int calcFolderSize(File folder) {
        int size = 0;
        String[] files = folder.list();
        if (files == null) {
            return -1;
        }
        for (int i = 0; i < files.length; ++i) {
            if (files[i].equals(".") || files[i].equals("..") || files[i].equals(".DS_Store")) continue;
            File fella = new File(folder, files[i]);
            if (fella.isDirectory()) {
                size += Base.calcFolderSize(fella);
                continue;
            }
            size += (int)fella.length();
        }
        return size;
    }

    public static String[] listFiles(String path, boolean relative) {
        return Base.listFiles(new File(path), relative);
    }

    public static String[] listFiles(File folder, boolean relative) {
        String path = folder.getAbsolutePath();
        Vector<String> vector = new Vector<String>();
        Base.listFiles(relative ? path + File.separator : "", path, vector);
        Object[] outgoing = new String[vector.size()];
        vector.copyInto(outgoing);
        return outgoing;
    }

    protected static void listFiles(String basePath, String path, Vector<String> vector) {
        File folder = new File(path);
        String[] list = folder.list();
        if (list == null) {
            return;
        }
        for (int i = 0; i < list.length; ++i) {
            if (list[i].charAt(0) == '.') continue;
            File file = new File(path, list[i]);
            String newPath = file.getAbsolutePath();
            if (newPath.startsWith(basePath)) {
                newPath = newPath.substring(basePath.length());
            }
            vector.add(newPath);
            if (!file.isDirectory()) continue;
            Base.listFiles(basePath, newPath, vector);
        }
    }

    static {
        platformNames.put(1, "windows");
        platformNames.put(2, "macosx");
        platformNames.put(3, "linux");
        platformIndices = new HashMap();
        platformIndices.put("windows", 1);
        platformIndices.put("macosx", 2);
        platformIndices.put("linux", 3);
    }
}

