/*
 * Decompiled with CFR 0.152.
 */
package processing.xml;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Vector;
import processing.xml.XMLElement;

public class XMLWriter {
    private PrintWriter writer;

    public XMLWriter(Writer writer) {
        this.writer = writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer);
    }

    public XMLWriter(OutputStream outputStream) {
        this.writer = new PrintWriter(outputStream);
    }

    protected void finalize() throws Throwable {
        this.writer = null;
        super.finalize();
    }

    public void write(XMLElement xMLElement) throws IOException {
        this.write(xMLElement, false, 0, true);
    }

    public void write(XMLElement xMLElement, boolean bl) throws IOException {
        this.write(xMLElement, bl, 0, true);
    }

    public void write(XMLElement xMLElement, boolean bl, int n) throws IOException {
        this.write(xMLElement, bl, n, true);
    }

    public void write(XMLElement xMLElement, boolean bl, int n, boolean bl2) throws IOException {
        if (bl) {
            for (int i = 0; i < n; ++i) {
                this.writer.print(' ');
            }
        }
        if (xMLElement.getLocalName() == null) {
            if (xMLElement.getContent() != null) {
                if (bl) {
                    this.writeEncoded(xMLElement.getContent().trim());
                    this.writer.println();
                } else {
                    this.writeEncoded(xMLElement.getContent());
                }
            }
        } else {
            Object object;
            Enumeration<XMLElement> enumeration;
            this.writer.print('<');
            this.writer.print(xMLElement.getName());
            Vector<Object> vector = new Vector<Object>();
            if (xMLElement.getNamespace() != null) {
                if (xMLElement.getLocalName().equals(xMLElement.getName())) {
                    this.writer.print(" xmlns=\"" + xMLElement.getNamespace() + '\"');
                } else {
                    enumeration = xMLElement.getName();
                    enumeration = ((String)((Object)enumeration)).substring(0, ((String)((Object)enumeration)).indexOf(58));
                    vector.addElement(enumeration);
                    this.writer.print(" xmlns:" + enumeration);
                    this.writer.print("=\"" + xMLElement.getNamespace() + "\"");
                }
            }
            enumeration = xMLElement.enumerateAttributeNames();
            while (enumeration.hasMoreElements()) {
                String string;
                String string2;
                object = enumeration.nextElement();
                int n2 = ((String)object).indexOf(58);
                if (n2 < 0 || (string2 = xMLElement.getAttributeNamespace((String)object)) == null || vector.contains(string = ((String)object).substring(0, n2))) continue;
                this.writer.print(" xmlns:" + string);
                this.writer.print("=\"" + string2 + '\"');
                vector.addElement(string);
            }
            enumeration = xMLElement.enumerateAttributeNames();
            while (enumeration.hasMoreElements()) {
                object = enumeration.nextElement();
                String string = xMLElement.getAttribute((String)object, null);
                this.writer.print(" " + (String)object + "=\"");
                this.writeEncoded(string);
                this.writer.print('\"');
            }
            if (xMLElement.getContent() != null && xMLElement.getContent().length() > 0) {
                this.writer.print('>');
                this.writeEncoded(xMLElement.getContent());
                this.writer.print("</" + xMLElement.getName() + '>');
                if (bl) {
                    this.writer.println();
                }
            } else if (xMLElement.hasChildren() || !bl2) {
                this.writer.print('>');
                if (bl) {
                    this.writer.println();
                }
                enumeration = xMLElement.enumerateChildren();
                while (enumeration.hasMoreElements()) {
                    object = enumeration.nextElement();
                    this.write((XMLElement)object, bl, n + 4, bl2);
                }
                if (bl) {
                    for (int i = 0; i < n; ++i) {
                        this.writer.print(' ');
                    }
                }
                this.writer.print("</" + xMLElement.getName() + ">");
                if (bl) {
                    this.writer.println();
                }
            } else {
                this.writer.print("/>");
                if (bl) {
                    this.writer.println();
                }
            }
        }
        this.writer.flush();
    }

    private void writeEncoded(String string) {
        block8: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\n': {
                    this.writer.print(c);
                    continue block8;
                }
                case '<': {
                    this.writer.print("&lt;");
                    continue block8;
                }
                case '>': {
                    this.writer.print("&gt;");
                    continue block8;
                }
                case '&': {
                    this.writer.print("&amp;");
                    continue block8;
                }
                case '\'': {
                    this.writer.print("&apos;");
                    continue block8;
                }
                case '\"': {
                    this.writer.print("&quot;");
                    continue block8;
                }
                default: {
                    if (c < ' ' || c > '~') {
                        this.writer.print("&#x");
                        this.writer.print(Integer.toString(c, 16));
                        this.writer.print(';');
                        continue block8;
                    }
                    this.writer.print(c);
                }
            }
        }
    }
}

