/*
 * Decompiled with CFR 0.152.
 */
package processing.app.debug;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import processing.app.Base;
import processing.app.Preferences;
import processing.app.SerialException;
import processing.app.debug.RunnerException;
import processing.app.debug.Target;
import processing.app.debug.Uploader;

public class AvrdudeUploader
extends Uploader {
    static Logger logger = Logger.getLogger((String)Base.class.getName());

    public boolean uploadUsingPreferences(String buildPath, String className, boolean verbose) throws RunnerException, SerialException {
        Target t;
        this.verbose = verbose;
        Map<String, String> boardPreferences = Base.getBoardPreferences();
        String uploadUsing = boardPreferences.get("upload.using");
        if (uploadUsing == null) {
            uploadUsing = Preferences.get("upload.using");
        }
        logger.debug((Object)("*** UPLOAD USING: " + uploadUsing));
        if (uploadUsing.equals("bootloader")) {
            return this.uploadViaBootloader(buildPath, className);
        }
        if (uploadUsing.indexOf(58) == -1) {
            t = Base.getTarget();
        } else {
            String targetName = uploadUsing.substring(0, uploadUsing.indexOf(58));
            t = Base.targetsTable.get(targetName);
            uploadUsing = uploadUsing.substring(uploadUsing.indexOf(58) + 1);
        }
        Map<String, Map<String, String>> bootLoaders = t.getBootloaders();
        Map<String, String> bootloader = bootLoaders.get(uploadUsing);
        if (bootloader != null) {
            ArrayList parts = new ArrayList();
            String command = null;
            command = bootloader.get("command_" + Base.osName());
            if (command == null) {
                command = bootloader.get("command_" + Base.getPlatformName());
            }
            if (command == null) {
                command = bootloader.get("command");
            }
            if (command == null) {
                logger.debug((Object)"ERROR: No command found for bootloader!");
                return false;
            }
            logger.debug((Object)"================ UPLOAD =================");
            logger.debug((Object)("Bootloader selected: " + uploadUsing));
            logger.debug((Object)("Command: " + command));
            logger.debug((Object)"");
            ArrayList<String> spl = new ArrayList<String>();
            Matcher m = Pattern.compile("([^\"]\\S*|\".+?\")\\s*").matcher(command);
            while (m.find()) {
                spl.add(m.group(1));
            }
            String executable = (String)spl.get(0);
            executable = executable.replace("\"", "");
            if (Base.isWindows() && executable.indexOf(".exe") == -1) {
                executable = executable + ".exe";
            }
            String variant = boardPreferences.get("build.variant");
            String variantPath = t.getVariantFolder(variant).getAbsolutePath() + "/tools/";
            String basePath = new String(Base.getHardwarePath() + "/tools/");
            String foundPath = null;
            File testFile = null;
            testFile = new File(variantPath, executable);
            logger.debug((Object)("Searching for " + variantPath + "/" + executable + "..."));
            if (testFile.exists()) {
                logger.debug((Object)"... found");
                foundPath = variantPath;
            } else {
                logger.debug((Object)("Searching for " + basePath + "/" + executable + "..."));
                testFile = new File(basePath, executable);
                if (testFile.exists()) {
                    logger.debug((Object)"... found");
                    foundPath = basePath;
                }
            }
            if (foundPath == null) {
                System.out.println("Command not found: " + executable);
                return false;
            }
            command = command.replace("%A", t.getVariantFolder(variant).getAbsolutePath());
            command = command.replace("%H", buildPath + File.separator + className + ".hex");
            command = command.replace("%V", verbose ? bootloader.get("verbose") : (bootloader.get("quiet") != null ? bootloader.get("quiet") : ""));
            command = command.replace("%P", (Base.isWindows() ? "\\\\.\\" : "") + Preferences.get("serial.port"));
            command = command.replace("%B", boardPreferences.get("upload.speed") != null ? boardPreferences.get("upload.speed") : "");
            command = command.replace("%O", boardPreferences.get("upload.protocol") != null ? boardPreferences.get("upload.protocol") : "");
            command = command.replace("%T", foundPath);
            command = command.replace("%M", boardPreferences.get("build.mcu") != null ? boardPreferences.get("build.mcu") : "");
            command = command.trim();
            spl.clear();
            m = Pattern.compile("([^\"]\\S*|\".+?\")\\s*").matcher(command);
            while (m.find()) {
                spl.add(m.group(1));
            }
            for (int i = 0; i < spl.size(); ++i) {
                String tmp = (String)spl.get(i);
                tmp = tmp.replace("\"", "");
                tmp = tmp.trim();
                spl.set(i, tmp);
                if (((String)spl.get(i)).length() <= 0) continue;
                parts.add(spl.get(i));
            }
            return this.executeToolsCommand(parts, foundPath);
        }
        Collection params = this.getProgrammerCommands(t, uploadUsing);
        params.add("-Uflash:w:" + buildPath + File.separator + className + ".hex:i");
        return this.avrdude(params);
    }

    private boolean uploadViaBootloader(String buildPath, String className) throws RunnerException, SerialException {
        Map<String, String> boardPreferences = Base.getBoardPreferences();
        ArrayList<String> commandDownloader = new ArrayList<String>();
        String protocol = boardPreferences.get("upload.protocol");
        if (protocol.equals("stk500")) {
            protocol = "stk500v1";
        }
        commandDownloader.add("-c" + protocol);
        commandDownloader.add("-P" + (Base.isWindows() ? "\\\\.\\" : "") + Preferences.get("serial.port"));
        commandDownloader.add("-b" + Integer.parseInt(boardPreferences.get("upload.speed")));
        commandDownloader.add("-D");
        commandDownloader.add("-Uflash:w:" + buildPath + File.separator + className + ".hex:i");
        if (boardPreferences.get("upload.disable_flushing") == null || boardPreferences.get("upload.disable_flushing").toLowerCase().equals("false")) {
            this.flushSerialBuffer();
        }
        return this.avrdude(commandDownloader);
    }

    public boolean burnBootloader(String targetName, String programmer) throws RunnerException {
        return this.burnBootloader(this.getProgrammerCommands(Base.targetsTable.get(targetName), programmer));
    }

    private Collection getProgrammerCommands(Target target, String programmer) {
        Map<String, String> programmerPreferences = target.getProgrammers().get(programmer);
        ArrayList<String> params = new ArrayList<String>();
        params.add("-c" + programmerPreferences.get("protocol"));
        if ("usb".equals(programmerPreferences.get("communication"))) {
            params.add("-Pusb");
        } else if ("serial".equals(programmerPreferences.get("communication"))) {
            params.add("-P" + (Base.isWindows() ? "\\\\.\\" : "") + Preferences.get("serial.port"));
            if (programmerPreferences.get("speed") != null) {
                params.add("-b" + Integer.parseInt(programmerPreferences.get("speed")));
            }
        }
        if (programmerPreferences.get("force") != null && programmerPreferences.get("force").toLowerCase().equals("true")) {
            params.add("-F");
        }
        if (programmerPreferences.get("delay") != null) {
            params.add("-i" + programmerPreferences.get("delay"));
        }
        return params;
    }

    protected boolean burnBootloader(Collection params) throws RunnerException {
        Target t;
        Map<String, String> boardPreferences = Base.getBoardPreferences();
        ArrayList<String> fuses = new ArrayList<String>();
        fuses.add("-e");
        fuses.add("-Ulock:w:" + boardPreferences.get("bootloader.unlock_bits") + ":m");
        if (boardPreferences.get("bootloader.extended_fuses") != null) {
            fuses.add("-Uefuse:w:" + boardPreferences.get("bootloader.extended_fuses") + ":m");
        }
        fuses.add("-Uhfuse:w:" + boardPreferences.get("bootloader.high_fuses") + ":m");
        fuses.add("-Ulfuse:w:" + boardPreferences.get("bootloader.low_fuses") + ":m");
        if (!this.avrdude(params, fuses)) {
            return false;
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        String bootloaderPath = boardPreferences.get("bootloader.path");
        if (bootloaderPath.indexOf(58) == -1) {
            t = Base.getTarget();
        } else {
            String targetName = bootloaderPath.substring(0, bootloaderPath.indexOf(58));
            t = Base.targetsTable.get(targetName);
            bootloaderPath = bootloaderPath.substring(bootloaderPath.indexOf(58) + 1);
        }
        File bootloadersFile = new File(t.getFolder(), "bootloaders");
        File bootloaderFile = new File(bootloadersFile, bootloaderPath);
        bootloaderPath = bootloaderFile.getAbsolutePath();
        ArrayList<String> bootloader = new ArrayList<String>();
        bootloader.add("-Uflash:w:" + bootloaderPath + File.separator + boardPreferences.get("bootloader.file") + ":i");
        bootloader.add("-Ulock:w:" + boardPreferences.get("bootloader.lock_bits") + ":m");
        return this.avrdude(params, bootloader);
    }

    public boolean avrdude(Collection p1, Collection p2) throws RunnerException {
        ArrayList p = new ArrayList(p1);
        p.addAll(p2);
        return this.avrdude(p);
    }

    public boolean avrdude(Collection params) throws RunnerException {
        ArrayList<String> commandDownloader = new ArrayList<String>();
        commandDownloader.add("avrdude");
        if (Base.isLinux()) {
            commandDownloader.add("-C" + Base.getHardwarePath() + "/tools/avrdude.conf");
        } else {
            commandDownloader.add("-C" + Base.getHardwarePath() + "/tools/avr/etc/avrdude.conf");
        }
        if (this.verbose || Preferences.getBoolean("upload.verbose")) {
            commandDownloader.add("-v");
            commandDownloader.add("-v");
            commandDownloader.add("-v");
            commandDownloader.add("-v");
        } else {
            commandDownloader.add("-q");
            commandDownloader.add("-q");
        }
        commandDownloader.add("-p" + Base.getBoardPreferences().get("build.mcu"));
        commandDownloader.addAll(params);
        return this.executeUploadCommand(commandDownloader);
    }
}

