/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import com.sun.jna.Library;
import com.sun.jna.Native;
import java.io.File;
import javax.swing.UIManager;
import processing.app.Base;
import processing.app.Preferences;

public class Platform {
    Base base;

    public void setLookAndFeel() throws Exception {
        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
    }

    public void init(Base base) {
        this.base = base;
    }

    public File getSettingsFolder() throws Exception {
        File home2 = new File(System.getProperty("user.home"));
        File dataFolder = new File(home2, ".mpide");
        return dataFolder;
    }

    public File getDefaultSketchbookFolder() throws Exception {
        return null;
    }

    public void openURL(String url) throws Exception {
        String launcher = Preferences.get("launcher");
        if (launcher != null) {
            Runtime.getRuntime().exec(new String[]{launcher, url});
        } else {
            this.showLauncherWarning();
        }
    }

    public boolean openFolderAvailable() {
        return Preferences.get("launcher") != null;
    }

    public void openFolder(File file) throws Exception {
        String launcher = Preferences.get("launcher");
        if (launcher != null) {
            String folder = file.getAbsolutePath();
            Runtime.getRuntime().exec(new String[]{launcher, folder});
        } else {
            this.showLauncherWarning();
        }
    }

    public void setenv(String variable, String value) {
        CLibrary clib = CLibrary.INSTANCE;
        clib.setenv(variable, value, 1);
    }

    public String getenv(String variable) {
        CLibrary clib = CLibrary.INSTANCE;
        return clib.getenv(variable);
    }

    public int unsetenv(String variable) {
        CLibrary clib = CLibrary.INSTANCE;
        return clib.unsetenv(variable);
    }

    protected void showLauncherWarning() {
        Base.showWarning("No launcher available", "Unspecified platform, no launcher available.\nTo enable opening URLs or folders, add a \n\"launcher=/path/to/app\" line to preferences.txt", null);
    }

    public static interface CLibrary
    extends Library {
        public static final CLibrary INSTANCE = (CLibrary)Native.loadLibrary("c", CLibrary.class);

        public int setenv(String var1, String var2, int var3);

        public String getenv(String var1);

        public int unsetenv(String var1);

        public int putenv(String var1);
    }
}

