/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.main.server;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import sun.plugin2.main.server.AppletID;
import sun.plugin2.main.server.JVMManager;
import sun.plugin2.main.server.Plugin;

public class ModalitySupport {
    private static Map pluginInfoMap = new HashMap();

    public static synchronized void initialize(int n, Plugin plugin) {
        pluginInfoMap.put(new Integer(n), new PerPluginInfo(plugin));
    }

    public static synchronized void shutdown(int n) {
        PerPluginInfo perPluginInfo = (PerPluginInfo)pluginInfoMap.remove(new Integer(n));
        perPluginInfo.getPlugin().notifyMainThread();
    }

    public static void modalityChanged(int n, boolean bl) {
        final PerPluginInfo perPluginInfo = (PerPluginInfo)pluginInfoMap.get(new Integer(n));
        if (perPluginInfo == null) {
            return;
        }
        final AppletID appletID = new AppletID(n);
        if (bl) {
            final int n2 = perPluginInfo.modalityPushed();
            final Plugin plugin = perPluginInfo.getPlugin();
            plugin.invokeLater(new Runnable(){

                public void run() {
                    while (!JVMManager.getManager().appletExited(appletID) && perPluginInfo.getModalityDepth() >= n2) {
                        plugin.waitForSignalWithModalBlocking();
                    }
                    plugin.notifyMainThread();
                }
            });
        } else {
            perPluginInfo.modalityPopped();
        }
    }

    public static synchronized boolean appletShouldBlockBrowser(int n) {
        Thread thread = Thread.currentThread();
        PerPluginInfo perPluginInfo = (PerPluginInfo)pluginInfoMap.get(new Integer(n));
        if (perPluginInfo != null && perPluginInfo.getModalityDepth() > 0) {
            return true;
        }
        Iterator iterator = pluginInfoMap.values().iterator();
        while (iterator.hasNext()) {
            perPluginInfo = (PerPluginInfo)iterator.next();
            if (perPluginInfo.getPluginMainThread() != thread || perPluginInfo.getModalityDepth() <= 0) continue;
            return true;
        }
        return false;
    }

    public static boolean appletShouldBlockBrowser(AppletID appletID) {
        if (appletID == null) {
            return false;
        }
        return ModalitySupport.appletShouldBlockBrowser(appletID.getID());
    }

    public static synchronized Integer getAppletBlockingBrowser() {
        Thread thread = Thread.currentThread();
        Iterator iterator = pluginInfoMap.keySet().iterator();
        while (iterator.hasNext()) {
            Integer n = (Integer)iterator.next();
            PerPluginInfo perPluginInfo = (PerPluginInfo)pluginInfoMap.get(n);
            if (perPluginInfo.getPluginMainThread() != thread || perPluginInfo.getModalityDepth() <= 0) continue;
            return n;
        }
        return null;
    }

    private ModalitySupport() {
    }

    static class PerPluginInfo {
        private Plugin plugin;
        private Thread pluginMainThread;
        private int modalityDepth;

        public PerPluginInfo(Plugin plugin) {
            this.plugin = plugin;
            this.pluginMainThread = Thread.currentThread();
        }

        public Plugin getPlugin() {
            return this.plugin;
        }

        public Thread getPluginMainThread() {
            return this.pluginMainThread;
        }

        public synchronized int modalityPushed() {
            return ++this.modalityDepth;
        }

        public synchronized void modalityPopped() {
            --this.modalityDepth;
            this.plugin.notifyMainThread();
        }

        public synchronized int getModalityDepth() {
            return this.modalityDepth;
        }
    }
}

