/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.opengl;

import java.awt.Color;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import sun.awt.image.CachingSurfaceManager;
import sun.java2d.SurfaceData;
import sun.java2d.loops.CompositeType;
import sun.java2d.opengl.WGLGraphicsConfig;
import sun.java2d.opengl.WGLSurfaceData;

public class WGLCachingSurfaceManager
extends CachingSurfaceManager {
    private int transparency;

    public WGLCachingSurfaceManager(BufferedImage bufferedImage) {
        super(bufferedImage);
        this.transparency = bufferedImage.getColorModel().getTransparency();
        if (accelerationThreshold == 0 && this.localAccelerationEnabled) {
            GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
            this.initAcceleratedSurface(graphicsConfiguration, bufferedImage.getWidth(), bufferedImage.getHeight());
        }
    }

    protected boolean isDestSurfaceAccelerated(SurfaceData surfaceData) {
        return surfaceData instanceof WGLSurfaceData;
    }

    protected boolean isOperationSupported(SurfaceData surfaceData, CompositeType compositeType, Color color, boolean bl) {
        return surfaceData instanceof WGLSurfaceData && (color == null || this.transparency == 1);
    }

    protected SurfaceData createAccelSurface(GraphicsConfiguration graphicsConfiguration, int n, int n2) {
        if (graphicsConfiguration instanceof WGLGraphicsConfig) {
            return WGLSurfaceData.createData((WGLGraphicsConfig)graphicsConfiguration, n, n2, graphicsConfiguration.getColorModel(this.transparency), this.bImg, 3);
        }
        return null;
    }

    public String toString() {
        return new String("WGLCachingSurfaceManager@" + Integer.toHexString(this.hashCode()) + " transparency: " + (this.transparency == 1 ? "OPAQUE" : (this.transparency == 2 ? "BITMASK" : "TRANSLUCENT")));
    }
}

