10 CLS
17 REM Added check for insufficient impedance step up ratio per N6MW, Jul 12, 2011
18 REM Removed corrections RA/2 and XA/2 per W6NL, Apr 1, 2000
19 REM Corrected error in wavelength conversion, Mar 1997
20 PRINT "           Gamma Match Design"
25 PRINT
30 PRINT "    Using W7ITB, WB0IKN, W6NL Equations"
35 PRINT "         Version 2.1, July 2011"
40 PRINT
45 PRINT
50 DEF FNCSH (X) = LOG(X + SQR(X * X - 1))
60 PI = 3.14159
120 INPUT "Frequency, MHz"; F
130 INPUT "Feed point resistance, ohms"; RA
140 INPUT "Feed point reactance, ohms"; XA
170 INPUT "Feed line impedance, ohms"; RO
180 PRINT : INPUT "Driven element diameter, inches"; DE
190 INPUT "Gamma rod diameter, inches"; DR
200 INPUT "Gamma rod spacing, inches"; S
210 HZ = (1 + ((FNCSH((4 * S * S - DE * DE + DR * DR) / (4 * S * DR))) / (FNCSH((4 * S * S + DE * DE - DR * DR) / (4 * S * DE))))) ^ 2
215 IF RO >= HZ * RA THEN PRINT : PRINT "The Feed Line Impedance of"; RO; " ohms is greater than the impedance step up ratio of"; HZ; " times the Feed Point Resistance of"; RA; "ohms.": PRINT : PRINT "As a result the program output is unlikely to be correct or useful. Change gamma rod diameter or spacing until this message is not printed.  See the program's accompanying README file on the CD-ROM." ELSE GOTO 220
216 PRINT : INPUT "Start the program again? (Y/N)"; P$: IF P$ = "Y" OR P$ = "y" THEN GOTO 10 ELSE SYSTEM
220 ZO = 60 * FNCSH((4 * S * S - DE * DE - DR * DR) / (2 * DE * DR))
230 T = HZ / ZO
240 a = ((RO * XA) / (HZ * RA - RO))
250 B = (RO * (RA ^ 2 + XA ^ 2)) / (HZ * RA - RO)
260 Q = a + SQR(a * a + B)
270 XS = HZ * ((RO * XA + SQR((RO * XA) ^ 2 + RO * (HZ * RA - RO) * (RA ^ 2 + XA ^ 2))) / (HZ * RA - RO))
280 LDRA = ATN(Q * T)
290 LDR = LDRA * 180 / PI
300 E = (RO / RA) * ((RA ^ 2 + XA ^ 2) / Q)
310 G = (RO / RA) * XA
320 CR = 1000000! / (2 * PI * (E + G) * F)
330 CLS
360 PRINT
380 PRINT
390 PRINT "Frequency, MHz: "; F
400 PRINT "Driven element diam: "; DE
410 PRINT "Gamma rod diam: "; DR
420 PRINT "Gamma rod spacing: "; S
430 PRINT "Feed point resistance: "; RA
440 PRINT "Feed point reactance: "; XA
450 PRINT "Feed line impedance: "; RO
460 PRINT
470 PRINT "Gamma length (degrees): "; LDR
480 FT = (984 / F) * (LDR / 360): PRINT "Gamma length (feet): "; FT
490 IN = FT * 12: PRINT "Gamma length (inches): "; IN
'print "HZ = ";HZ;
'print "  ZO = ";ZO
500 PRINT "Gamma capacitor (pF): "; CR
510 PRINT : INPUT "Do another (Y/N)"; T$
520 IF T$ = "y" OR T$ = "Y" THEN GOTO 10 ELSE SYSTEM

