      SUBROUTINE EFFLEN(NUMEL,SEGLEN,SEGDIA,ELENGT,ELDIAM,MAXSEG)
      DIMENSION SEGLEN(50,9),SEGDIA(50,9),ELENGT(50),TOTLEN(50),TH(2),
     1 MAXSEG(50),ELDIAM(50),CUML(0:10),EQREAC(50)
C     Version 2.1, Feb. 28, 1994
C     N --> Number of element, M --> specific segment, starting at 
C     center of a particular element.  By W6QHS we need to find LN(Ae),
C     TOTLEN of the physical element, TOTAREA, which is really the
C     sum of the products of Ln and LN(An) for each segment, and the 
C     CUML(n) from the boom to the end of each segment.  Then we can
C     calculate the equivalent diameter and length of the equivalent
C     cylinder with the same electrical characteristics of the tapered
C     element.  N is related to the number of the element, and L is 
C     related to the segment number of a particular element.
      DO 30, N=1,NUMEL
C       Initialize variables
        TOTLEN(N)=0.0
        TOTAREA=0.0
        CUML(0) = 0.0
        CUML(N) = 0.0
        ELENGT(N)=0.0
        DO 10, I=1,MAXSEG(N)
C         Actual physical total half element length for this element
          TOTLEN(N)=TOTLEN(N)+SEGLEN(N,I)
C         Cumulative length from boom to this section N
          CUML(I) = CUML(I-1)+SEGLEN(N,I)
C         The total "area" for the element N: Sum[Ln * LN(An)]
          AREA = SEGLEN(N,I)*LOG(SEGDIA(N,I)/2)
          TOTAREA=TOTAREA+AREA
10      CONTINUE
C       Now, calculate the Shelkunof M and N functions and their 
C       summations.
        DO 20, L=1,MAXSEG(N)
          IF(L.EQ.1) THEN
            XN = 0.
            XM = 0.
            SUMN = 0.0
            SUMM = 0.0
            SUMNP = 0.0
            SUMMP = 0.0
          ENDIF
C         Calculate summations of N, section by section L.
          XN = 60*(LOG(SEGDIA(N,L)/2)-TOTAREA/TOTLEN(N))* 
     &     (SIN(3.141593*CUML(L)/TOTLEN(N))-
     &      SIN(3.141593*CUML(L-1)/TOTLEN(N)))  
          SUMN=SUMN+XN
C         Calculate summations of M, section by section L.
          XM = -60*(LOG(SEGDIA(N,L)/2)-TOTAREA/TOTLEN(N))* 
     &     (COS(3.141593*CUML(L)/TOTLEN(N))-
     &      COS(3.141593*CUML(L-1)/TOTLEN(N)))
          SUMM=SUMM+XM
C         Calculate summation of derivatives N(prime), section by 
C         section L.
          XNP = 120*(LOG(SEGDIA(N,L)/2)-TOTAREA/TOTLEN(N))*
     &     (CUML(L)*COS(3.141593*CUML(L)/TOTLEN(N))-
     &      CUML(L-1)*COS(3.141593*CUML(L-1)/TOTLEN(N)))/TOTLEN(N)
          SUMNP=SUMNP+XNP
C         Calculate summation of derivatives M(prime), section by 
C         section L.
          XMP = 120*(LOG(SEGDIA(N,L)/2)-TOTAREA/TOTLEN(N))*
     &     (CUML(L)*SIN(3.141593*CUML(L)/TOTLEN(N))-
     &      CUML(L-1)*SIN(3.141593*CUML(L-1)/TOTLEN(N)))/TOTLEN(N)
          SUMMP=SUMMP+XMP
20      CONTINUE
C       The desired output diameter is ELDIAM(N), and the desired 
C       output equivalent length is ELENGT(N).  First, set variables
C       to zero.
        AM = 0.
        AKA = 0.
        X0 = 0.
        Z0 = 0.
        FROF0 = 0.
        F0 = 0.
        X0P = 0.
        F0POF0 = 0.
        Z0P = 0.
        AKAP = 0.
        DP = 0.
C       Original tapered element.
        AM = -21.13 + SUMM
        AKA = 120.*(LOG(2.*TOTLEN(N))-1-TOTAREA/TOTLEN(N))
        X0 = (42.545-SUMN)*(1-AM/AKA)
        Z0 = AKA - 2.*AM - (1-AM/AKA)*(56.93+SUMNP) -
     &    (X0/AKA)*(76.39+SUMMP)
        FROF0 = 1 - (2.*X0)/(3.141593*Z0)
        F0 = 11802.85/(4.*TOTLEN(N))
C       Equivalent cylindical element.
        X0P = 42.545*(1+21.13/AKA)
        F0POF0 = (1 - 2.*(X0-X0P)/(3.141593*Z0))
        Z0P = Z0*(F0POF0)
        AKAP = Z0P + 14.67 + 4253./AKA + 68673/((AKA)**2.)
        ELENGT(N) = TOTLEN(N)/F0POF0
        DP = 4*ELENGT(N)*2.718282**(-AKAP/120.-1)
        ELDIAM(N) = DP
C     End of segment by segment (M) loop within N loop.
C     Take care of monotaper input.
      IF(MAXSEG(N).EQ.1) THEN
        ELENGT(N) = SEGLEN(N,1)
        ELDIAM(N) = SEGDIA(N,1)
      ENDIF
30    CONTINUE
100   RETURN
      END
